//  $Id: StructureViewer.java,v 1.58 2007/11/16 17:25:20 Sasha Buzko Exp $
//
//  Copyright (c) 2000-2002  San Diego Supercomputer Center (SDSC),
//  a facility operated jointly by the University of California,
//  San Diego (UCSD) and General Atomics, San Diego, California, USA.
//
//  Users and possessors of this source code are hereby granted a
//  nonexclusive, royalty-free copyright and design patent license to
//  use this code in individual software.  License is not granted for
//  commercial resale, in whole or in part, without prior written
//  permission from SDSC.  This source is provided "AS IS" without express
//  or implied warranty of any kind.
//
//  For further information, please see:  http://mbt.sdsc.edu
//
//  History:
//  $Log: StructureViewer.java,v $
//  Revision 1.58  2007/11/16 17:25:20  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.57  2007/11/12 21:29:06  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.56  2007/11/09 22:53:30  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.55  2007/10/24 19:27:25  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.54  2007/10/12 19:12:49  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.53  2007/08/31 23:02:45  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.52  2007/08/15 18:20:12  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.51  2007/08/05 22:51:32  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.50  2007/06/22 02:12:15  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.49  2007/06/20 21:45:54  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.48  2007/06/17 01:16:36  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.47  2007/06/15 17:45:54  Sasha Buzko
//  graph clustering code
//
//  Revision 1.46  2007/06/04 22:46:52  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.45  2007/05/26 17:07:12  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.44  2007/05/23 05:04:10  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.43  2007/05/23 00:02:44  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.42  2007/05/22 20:55:41  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.41  2007/05/18 01:52:05  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.40  2007/05/12 16:55:25  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.39  2007/05/10 04:27:14  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.38  2007/05/03 23:49:02  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.37  2007/04/27 15:16:28  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.36  2007/04/26 17:56:47  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.35  2007/04/07 04:37:18  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.34  2007/03/21 23:58:14  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.33  2007/03/18 03:30:31  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.32  2007/03/13 04:33:59  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.31  2007/03/02 18:36:25  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.30  2007/03/02 18:05:49  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.29  2007/03/01 20:56:27  Sasha Buzko
//  Added MD video
//
//  Revision 1.28  2007/02/27 06:03:55  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.27  2007/02/26 04:33:43  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.26  2007/02/26 04:22:48  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.25  2007/02/25 23:30:33  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.24  2007/02/25 00:07:15  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.23  2007/02/22 19:57:41  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.22  2007/02/22 19:56:33  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.21  2007/02/19 07:31:04  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.20  2007/02/18 05:08:08  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.19  2007/02/13 19:08:42  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.18  2007/02/09 05:08:53  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.17  2007/02/07 02:45:49  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.16  2007/02/06 05:41:59  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.15  2007/02/01 07:44:36  Sasha Buzko
//  tutorials added
//
//  Revision 1.14  2007/01/29 02:01:03  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.13  2007/01/26 18:05:21  Sasha Buzko
//  MD support for concatenated runs
//
//  Revision 1.12  2007/01/22 22:36:31  Sasha Buzko
//  Added tree viewer
//
//  Revision 1.11  2007/01/03 13:41:23  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.10  2007/01/03 09:08:11  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.9  2006/12/25 21:17:25  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.8  2006/12/23 06:18:55  Sasha Buzko
//  md
//
//  Revision 1.7  2006/11/22 04:29:07  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.6  2006/11/22 01:58:39  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.5  2006/11/21 01:02:05  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.4  2006/11/18 00:41:23  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.3  2006/10/23 22:23:06  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.2  2006/10/21 18:41:27  Sasha Buzko
//  *** empty log message ***
//
//  Revision 1.1  2006/10/21 17:52:23  Sasha Buzko
//  Refactored the project to move all new code to edu.sdsc.sirius package.
//
//  Revision 1.52  2006/10/21 16:52:55  Sasha Buzko
//  *** empty log message ***
//
//
//  Revision 1.23  2003/06/24 22:52:36  agramada
//  Move the code handling the building of the scene in static methods in
//  SsGeometry and PsGeometry classes. Also, some rudimentary attempts to
//  implement highlighting.
//
//  Revision 1.22  2003/05/19 20:29:29  moreland
//  Added stereo rendering support.
//
//  Revision 1.21  2003/05/16 21:31:04  moreland
//  *** empty log message ***
//
//  Revision 1.20  2003/05/15 23:34:40  moreland
//  Moved putTree to bottom of structureAdded method so no rendering happens until done.
//
//  Revision 1.19  2003/05/14 18:15:07  moreland
//  Added code to clean up after removal of a structure.
//
//  Revision 1.18  2003/05/14 16:26:27  moreland
//  Added structureRemoved method support.
//
//  Revision 1.17  2003/05/14 01:19:41  moreland
//  Added missing comments to several public methods.
//  Added public resetView pass-through method.
//  Removed debug print statements.
//
//  Revision 1.16  2003/04/30 21:49:52  agramada
//  Adapted the code for building the SS scene to the new, object-oriented
//  StructureMap. Also, included code that can make use of derived SS
//  (via the Kabsch-Sander algorithm) information for building the scene.
//
//  Revision 1.15  2003/04/30 18:04:14  moreland
//  Added Status progress meter display.
//  Added code to check for huge chains and skips drawing atoms.
//
//  Revision 1.14  2003/04/23 23:55:17  moreland
//  Now implements the StructureStylesEventListner interface.
//  Now sets style state using the StructureStyle class (thus also causing
//  events to be propagated back to all viewers.
//  Added preliminary support for a correctly styled backbone trace (using
//  a LineStripArray).
//  The Atom generation code now fully supports selection, color, and radius
//  changes via StructureStyleEvents.
//  Temporarily commented out Apostol's code until it is updated to use the
//  StructureMap, StructureStyles, and all associated event handling features.
//
//  Revision 1.13  2003/03/19 22:53:09  moreland
//  Added very preliminary support for Ligand display.
//
//  Revision 1.12  2003/03/10 22:58:40  moreland
//  Changed calls to reflect StructureMap get*AlphaIndex method name changes.
//
//  Revision 1.11  2003/02/21 22:03:07  moreland
//  Changed println lines to Status.output lines.
//
//  Revision 1.10  2003/02/06 20:19:17  agramada
//  Added code to insert 2-res coil segments between consecutive strand
//  and/or helices.
//
//  Revision 1.9  2003/02/03 18:58:27  agramada
//  Added code to skip one residue strands and code that colors two residue
//  helices in magenta to point out anomalies.
//
//  Revision 1.8  2003/01/28 18:25:43  agramada
//  Included code to deal with correct handling of consequtive turns.
//
//  Revision 1.7  2003/01/22 01:16:31  agramada
//  Reinterpreted short helix ( < 3 Res ) found in some cif files (ex. 4hhb) as
//  turns.
//
//  Revision 1.6  2003/01/14 01:15:38  agramada
//  Commented out some debug messages.
//
//  Revision 1.5  2003/01/10 23:57:29  agramada
//  Added code to build the 3d secondary structure scene.
//
//  Revision 1.4  2002/12/16 06:48:23  moreland
//  Added initial picking/selection handling code and some other support code.
//
//  Revision 1.3  2002/11/14 18:21:50  moreland
//  Began implementation of the basic StructureViewer.
//  Changed to match Viewer change from class to interface.
//  Added new event callback methods to implement Viewer interface.
//  Changed old "MbtController" references to new "StructureDocument" class.
//
//  Revision 1.2  2002/10/24 18:10:05  moreland
//  Began integration of Apostol's geometry generation code with the toolkit.
//
//  Revision 1.1.1.1  2002/07/16 18:00:21  moreland
//  Imported sources
//
//  Revision 1.0  2002/06/10 23:38:39  moreland
//


package edu.sdsc.sirius.viewers;


// MBT
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;
import java.util.regex.*;

import java.io.*;
import java.net.*;
import java.util.zip.*;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import edu.sdsc.mbt.*;
import edu.sdsc.mbt.image.ImageHandler;
import edu.sdsc.mbt.util.*;
import edu.sdsc.mbt.viewables.*;

import edu.sdsc.mbt.viewers.GLViewerImpl.*;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3f;
import edu.sdsc.sirius.builder.*;
import edu.sdsc.sirius.dialogs.*;
import edu.sdsc.sirius.export.*;
import edu.sdsc.sirius.io.*;
import edu.sdsc.sirius.monitors.*;
import edu.sdsc.sirius.search.*;
import edu.sdsc.sirius.util.*;
import edu.sdsc.sirius.surface.*;

import edu.sdsc.sirius.viewers.TreeViewer.*;
import edu.sdsc.sirius.lsp.*;

import java.util.prefs.*;

/**
 *  This class impements a 3D structure viewer.
 *  <P>
 *  @see edu.sdsc.sirius.viewers.Viewer
 *  @see edu.sdsc.mbt.viewables.StructureDocument
 *  @see edu.sdsc.mbt.viewables.StructureDocumentEvent
 *  <P>
 *  @author John L. Moreland and Oleksandr V. Buzko
 */
public class StructureViewer
	extends JPanel
	implements Viewer, GvPickEventListener, StructureStylesEventListener, StructureComponentEventListener, 
		DisplayDialogListener, MoveEventListener {

	private GlGeometryViewer geometryViewer;

	private Hashtable objectHash = new Hashtable();
	
	private Vector renderablesList = new Vector();
	
	private HashMap residueToFragment = new HashMap();//references structure -> data hash for that structure

	/**
	 *  The StructureDocument to which we are currently added/viewing.
	 */
	private StructureDocument structureDocument;
	
	private Vector selectedChains = new Vector();//Chain objects for which ribbon has been rendered and there is at least one selection
	
	private Vector componentListeners = new Vector();
	
	private StructureViewer thisViewer;
	
	/**
	 * Indicates whether the geometry viewer should refresh once a structure is removed. Needs to be set to false when an
	 * undo is performed, to avoid useless display refresh with a blank screen.
	 */
	private boolean updateViewOnRemove = true;

	/**
	 *  Holds references to all entries with their associated Structure objects
	 */
	private HashMap structures = new HashMap();//entry->structure
	private HashMap entries = new HashMap();// structure -> entry
	
	private Vector structureList = new Vector();//only Structures, in a set order

	private ArrayList dummyAtoms = new ArrayList();
	
	/**
	 * Stores all Residues affected by Residue, Atom and Bond selections. Values of the hash are boolean flags indicating selection states.
	 */
	private HashMap selection = new HashMap();
	
	private Object value = new Object();//as a filler for hashes
	
	/**
	 * Stores Objects that are serialized states of the display identical to those used for state saving
	 */
	private Vector undoBuffer = new Vector();
	
	private Vector surfaceObjects = new Vector();
	private HashMap surfaceMap = new HashMap();//Atom -> SurfaceComponent
	
	/**
	 * Stores references to StructureComponent instances that are hidden from the display.
	 */
	private HashMap hiddenComponents = new HashMap();
	
	private HashMap renderables = new HashMap();//Structure -> Vector of renderables to be rendered in the next pass
	
	private TransformGroupRenderable rotationGroup;
	
	private double[] motionCenter;//center of rotation for independent group motion
	
	private double fogBackDistance = 225.0;
	private double fogFrontDistance = 10.0;
	private double fogDefaultDistance = 225.0;
	
	private double minZ = 0.0;
	private double maxZ = 0.0;
	
	private boolean rotationMode = false;
	private AngleMonitorDialog angleDialog;
	private Vector rotatedAtoms = new Vector();
	private double[] rotationAxis;
	private Atom rotationRootAtom;
	private double currentRotationAngle = 0;
	double[] toOrigin = new double[16];
	double[] fromOrigin = new double[16];
	
	//default coordinate system that is modified when a subset is independently moved
	double[] xCoord = new double[]{ 1.0, 0.0, 0.0 };
	double[] yCoord = new double[]{ 0.0, 1.0, 0.0 };
	double[] zCoord = new double[]{ 0.0, 0.0, 1.0 };
	
	double[][] standardCoordinates = new double[][]{ { 1, 0, 0 }, { 0, 1, 0 }, {0, 0, 1 } };
	
	private HashMap atomSets = new HashMap();//set name -> Vector of Atom objects
	private Vector atomSetNames = new Vector();
	
	public static boolean undoProcess = false;
	
	private Vector globalResidues = new Vector();//for bump detection when things are being moved
	
	/**
	 * Flag that indicates whether hidden structure components should be included in rendering
	 */
	private boolean renderHidden = true;
	
	private HashMap atomToBumps = new HashMap();//Atom -> Vector of Bumps
	private HashMap atomToHBonds = new HashMap();//Atom -> Vector of HBComponents
	private HashMap atomToMonitors = new HashMap();//Atom -> Vector of Monitors
	private HashMap atomToLabels = new HashMap();//Atom -> LabelComponent (one label for each atom at most)
	private HashMap atomToResidueLabels = new HashMap();//Atom -> ResidueLabelComponent (one label for each atom at most)
	
	private boolean repaintMonitors = true;
	
	private boolean trackGeometry = false;//whether dynamic phi/psi angle tracking is needed
	private Residue rotatedResidue;
	
	/**
	 * Flag that indicates whether hidden structure components should be included in coloring
	 */
	public boolean colorHidden = true;
	
	private boolean trackBumps = false;
	
	private HashMap transformedCoordinates = new HashMap();
	
	private double[] coordinateMatrix = new double[16];//for accumulating changes to atomic coordinates. if atoms are added, 
	//they are initially transformed with this matrix
	
	private double[] fragmentLocation;
	
	private Vector updatedMonitors = new Vector();//Monitor renderables that need to be updated during rotation
	
	private HashMap clusters = new HashMap();//Cluster -> ClusterRenderable
	
	/**
	 * Stores references to currently existing monitors.
	 */
	private HashMap monitors = new HashMap();//hash of hashes: MonitorComponent->Renderable
	private HashMap hBonds = new HashMap();//same for hBonds
	private HashMap bumps = new HashMap();//same for bumps
	private HashMap labels = new HashMap();//labels
	
	private HashMap arrows = new HashMap();//same for arrow geometry elements - for vectors
	private HashMap rotationArrow = new HashMap();//structure -> renderable
	private Bond rotationAxisBond;
	private Vector rotatedSet = new Vector();
	
	private HashMap structureNames = new HashMap();
	
	private Vector independentSet = new Vector();
	private Vector independentComponents = new Vector();//for dynamic bump checking (Atoms and Residues)
	
//	private Vector independentRenderables = new Vector();
	private TransformGroupRenderable independentGroup;
	private Structure independentStructure;
	
	private double[] initialMotionCenter;
	
	private boolean fogEnabled = true;
	
	private boolean stopCheckDummyAtoms = false;
		
	private int fragmentDistanceFromCamera = 10;
	
	private HashMap initialCoordinates = new HashMap();//Structure -> Atom -> coordinates: if a structure is transformed, the initial coordinates are saved
	
	public static Hashtable defaultGeometry = new Hashtable( );
	static
	{
		AtomGeometry atomGeometry = new AtomGeometry( );//don't translate geometry labels
		defaultGeometry.put( "AtomGeometry", atomGeometry );
		BondGeometry bondGeometry = new BondGeometry( );
		// bondGeometry.setShowOrder( true ); // JLM DEBUG
		defaultGeometry.put( "BondGeometry", bondGeometry );
		ChainGeometry chainGeometry = new ChainGeometry( );
		defaultGeometry.put( "ChainGeometry", chainGeometry );
		
		MonitorGeometry monitorGeometry = new MonitorGeometry();
		defaultGeometry.put("MonitorGeometry", monitorGeometry);
		
		LabelGeometry labelGeometry = new LabelGeometry();
		defaultGeometry.put("LabelGeometry", labelGeometry);

		ResidueLabelGeometry residueLabelGeometry = new ResidueLabelGeometry();
		defaultGeometry.put("ResidueLabelGeometry", residueLabelGeometry);

		ArrowGeometry arrowGeometry = new ArrowGeometry();
		defaultGeometry.put("ArrowGeometry", arrowGeometry);
		
		AtomLineGeometry atomLineGeometry = new AtomLineGeometry();
		defaultGeometry.put("AtomLineGeometry", atomLineGeometry);
		
		SurfaceGeometry surfaceGeometry = new SurfaceGeometry();
		defaultGeometry.put("SurfaceGeometry", surfaceGeometry);
		
		ClusterGeometry clusterGeometry = new ClusterGeometry();
		defaultGeometry.put("ClusterGeometry", clusterGeometry);

	}

	
	//
	// Constructor
	//

	/**
	 *  Construct a StructureViewer object.
	 */
	public StructureViewer()
	{
		geometryViewer = new GlGeometryViewer();
		geometryViewer.addPickEventListener( this );
		geometryViewer.addMoveEventListener(this);
		setLayout( new java.awt.GridLayout( 1, 1 ) );
		
		thisViewer = this;
		
		add( geometryViewer );
		
		
	}
	
	/**
	 * Sets background color.
	 */
	public void setBackgroundColor(float[] color){
		geometryViewer.setBackgroundColor(color);
	}

	/**
	 *  Make sure that at least a minimal sized widget is maintained.
	 */
	public java.awt.Dimension getMinimumSize()
	{
		return new java.awt.Dimension( 100, 100 );
	}


	/**
	 *  Turn stereo rendering on or off (if supported by the hardware).
	 */
	public void setStereoEnable( boolean on )
	{
//		geometryViewer.setStereoEnable( on );
	}


	/**
	 * Get the current stereo display state (ie: is it enabled or disabled?)
	 */
//	public boolean getStereoEnable( )
//	{
//		return geometryViewer.getStereoEnable( );
//	}

	public void resetFog(){
		
		try{
			if (structures.size() > 0){
				double minX = 1000000;
				double minY = 1000000;
				double minZ = 1000000;
				double maxX = -1000000;
				double maxY = -1000000;
				double maxZ = -1000000;
				
				Set keys = structures.keySet();
				Iterator it = keys.iterator();
				while (it.hasNext()){
					Structure s = (Structure)structures.get(it.next());
//					System.out.println("s = " + s.getUrlString());
					s.getStructureMap().calculateBounds(true);
					double[] min = s.getStructureMap().getMinCoordinate();
					double[] max = s.getStructureMap().getMaxCoordinate();
					
					if (min[0] < minX) minX = min[0];
					if (min[1] < minY) minY = min[1];
					if (min[2] < minZ) minZ = min[2];
					
					if (max[0] > maxX) maxX = max[0];
					if (max[1] > maxY) maxY = max[1];
					if (max[2] > maxZ) maxZ = max[2];
				}
				
				double spanX = maxX - minX;
				double spanY = maxY - minY;
				double spanZ = maxZ - minZ;
				
				double maxDistance = spanX > spanY ? (spanX > spanZ ? spanX : spanZ) : (spanY > spanZ ? spanY : spanZ);
				double radius = maxDistance/2;

				double centerX = ((double)(maxX + minX))/2.0;
				double centerY = ((double)(maxY + minY))/2.0;
				double centerZ = ((double)(maxZ + minZ))/2.0;

				double[] center = new double[] {centerX, centerY, centerZ};
//				System.out.println("center = " + center[0] + "," + center[1] + "," + center[2] + ", radius = " + radius);
				
				geometryViewer.resetFog(center, radius + radius/2, true);
				
			}
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception resetting the view", ex);
		}
	}
	
	public void fitDisplay(){
		
		//make sure ribbon geometry is included even if atoms are invisible
		try{
			
			//determine the common geometric center of the display
			double[] center = new double[3];
			int n = structureList.size();
			for (int i = 0; i < n; i++){
				Structure structure = (Structure)structureList.get(i);
				center[0] += ((double[])structure.getStructureMap().getCenter())[0];
				center[1] += ((double[])structure.getStructureMap().getCenter())[1];
				center[2] += ((double[])structure.getStructureMap().getCenter())[2];
			}
			
			center[0] /= n;
			center[1] /= n;
			center[2] /= n;
			
			//prepare directional vectors
			double[] up = getGeometryViewer().getUpVector();
			double[] down = Algebra.getReverseVector(up);
			double[] look = getGeometryViewer().getLookAt();
			double[] right = Algebra.crossProduct(look, up);
			Algebra.normalizeVector(right);
			double[] left = Algebra.getReverseVector(right);
			
			//maximum distances from the geometric center of display when looking from camera
			double maxUp = 0;
			double maxDown = 0;
			double maxLeft = 0;
			double maxRight = 0;
			
			
			if (structures.size() > 0){
				
				for (int i = 0 ; i < structureList.size(); i++){
					Structure s = (Structure)structureList.get(i);
					
					boolean start = true;
					for ( int j = 0; j < s.getStructureMap().getResidueCount(); j++ ){
						
						Residue res = s.getStructureMap().getResidue(j);
						boolean process = false;
						if (!res.visible){
							if (res.getCompoundCode().equals("HOH") || res.getCompoundCode().equals("WAT")) continue;//don't translate
							//check its ribbon status
							if (res.ribbon){
								//use CA as the reference
								process = true;
							}
						}
						else{
//							System.out.println("residue " + res.getCompoundCode() + " : " + res.getChainId() + " is visible");
							process = true;
						}
						
						if (!process) continue;
						for (int k = 0; k < res.getAtomCount(); k++){
							Atom atom = res.getAtom(k);
							//determine vector from center to the atom
							double[] direction = Algebra.getVector(center, atom.coordinate);
							
							//angle between up vector and direction
							double angle = Algebra.getAngleBetweenVectors(up, direction);
							if (angle < 0 || angle > 90){
								//compute the down directed angle
								angle = Algebra.getAngleBetweenVectors(down, direction);
								double h = Algebra.vectorLength(direction)*Math.cos(Math.toRadians(angle));//projection on to the down vector
								if (h > maxDown) maxDown = h;
							}
							else{
								double h = Algebra.vectorLength(direction)*Math.cos(Math.toRadians(angle));//projection on to the up vector
								if (h > maxUp) maxUp = h;
							}
							
							//same for left-right
							angle = Algebra.getAngleBetweenVectors(left, direction);
							if (angle < 0){
								//compute the down directed angle
								angle = Algebra.getAngleBetweenVectors(right, direction);
								double h = Algebra.vectorLength(direction)*Math.cos(Math.toRadians(angle));//projection on to the down vector
								if (h > maxRight) maxRight = h;
							}
							else{
								double h = Algebra.vectorLength(direction)*Math.cos(Math.toRadians(angle));//projection on to the up vector
								if (h > maxLeft) maxLeft = h;
							}
						}
						
					}

				}
				
				//calculate bounds: we now have maximum reach of the structure(s) in all four directions
				//perpendicular to the lookAt vector
				double maxVertical = maxUp > maxDown ? maxUp : maxDown;
				double maxHorizontal = maxLeft > maxRight ? maxLeft : maxRight;
				
				double ratio = maxVertical/maxHorizontal;
				double radius = 20;
				//compare to the current aspect ratio
				if (ratio < getGeometryViewer().getAspectRatio()){
					radius = maxHorizontal;
				}
				else{
					radius = maxVertical;
				}
				
				geometryViewer.fitView(center, radius);
				
			}
			
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception resetting the view", ex);
		}
		
		
	}

	/**
	 *  Reset the viewpoint so that all geometry can be seen.
	 */
	public void resetView( )
	{
		try{
			
//			System.out.println("reset view");
		if (structures.size() > 0){
			double minX = 1000000;
			double minY = 1000000;
			double minZ = 1000000;
			double maxX = -1000000;
			double maxY = -1000000;
			double maxZ = -1000000;
			
			Set keys = structures.keySet();
			Iterator it = keys.iterator();
			while (it.hasNext()){
				Structure s = (Structure)structures.get(it.next());
//				System.out.println("s = " + s.getUrlString());
				s.getStructureMap().calculateBounds(true);
				double[] min = s.getStructureMap().getMinCoordinate();
				double[] max = s.getStructureMap().getMaxCoordinate();
				
				if (min[0] < minX) minX = min[0];
				if (min[1] < minY) minY = min[1];
				if (min[2] < minZ) minZ = min[2];
				
				if (max[0] > maxX) maxX = max[0];
				if (max[1] > maxY) maxY = max[1];
				if (max[2] > maxZ) maxZ = max[2];
			}
			
			double spanX = maxX - minX;
			double spanY = maxY - minY;
			double spanZ = maxZ - minZ;
			
			double maxDistance = spanX > spanY ? (spanX > spanZ ? spanX : spanZ) : (spanY > spanZ ? spanY : spanZ);
			double radius = maxDistance/2;

			double centerX = ((double)(maxX + minX))/2.0;
			double centerY = ((double)(maxY + minY))/2.0;
			double centerZ = ((double)(maxZ + minZ))/2.0;

			double[] center = new double[] {centerX, centerY, centerZ};
//			System.out.println("center = " + center[0] + "," + center[1] + "," + center[2]);

			geometryViewer.resetView(center, radius, false, !structureDocument.parent.getHoldDisplayUpdate());
			
		}
		else{
			geometryViewer.resetView(!structureDocument.parent.getHoldDisplayUpdate());
		}
		
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception resetting the view", ex);
		}
	}
	
	/**
	 * Determines whether any structure styles object has any selection
	 * @return
	 */
	public boolean anythingSelected(){
		for (int i = 0; i < getLoadedStructures().size(); i++){
			Structure s = (Structure)getLoadedStructures().get(i);
			if (s.getStructureMap().getStructureStyles().getSelectionFlag() != StructureStyles.FLAG_NONE){
				return true;
			}
		}
		
		return false;
	}
	
	
	/**
	 * Processes a DisplayDialogEvent. The source of the event is determined, and the structure 
	 * appearance is modified as requested. The event can come from a ColorDialog, RenderingDialog, etc.
	 */
	public void processDisplayDialogEvent(DisplayDialogEvent event){
	
		DisplayDialog source = event.getSource();
		
		if (source instanceof RenderingDialog || source instanceof VisibilityDialog || source instanceof ColorDialog){
			if (objectHash == null || objectHash.size() == 0){
				return;//nothing is currently loaded
			}

			if (event.getSetFlag() == DialogConstants.APPLY_SELECTION){
				if (!anythingSelected()){
					structureDocument.parent.displayErrorMessage("Nothing is selected and no level of selection is specified");
					return;
				}
			}
		}
		
		if (StylesPreferences.undoEnabled) saveStateForUndo();
		
		if (source instanceof RenderingDialog){
			
			//the event was sent by RenderingDialog
			String label = ((RenderingEvent)event).componentId;
			int setFlag = ((RenderingEvent)event).setFlag;
			short styleFlag = ((RenderingEvent)event).styleFlag;
			short qualityFlag = ((RenderingEvent)event).qualityFlag;
			
			Atom atom = null;
			try{
				atom = (Atom)((RenderingEvent)event).structureComponent;
			}
			catch (ClassCastException e){}
			
			if (setFlag != DialogConstants.APPLY_SELECTION){
				if (label.equals("") && atom == null){
					return;
				}
			}
			
			if (atomSetNames.contains(label)){
				//a set has been selected
				
				Vector atomSet = (Vector)atomSets.get(label);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						r.structure.getStructureMap().getStructureStyles().setRenderingStyle(r, styleFlag, qualityFlag, true);
						checkDummyAtoms(r);
					}
					catch (ClassCastException e){
						Atom a = (Atom)atomSet.get(i);
						a.structure.getStructureMap().getStructureStyles().setRenderingStyle(a, styleFlag, qualityFlag, true);
					}
				}
				
				structureDocument.parent.updateView();

				return;
			}


			if (setFlag == DialogConstants.APPLY_ATOM){
				//get atom object out of the label
				if (atom == null){
					atom = (Atom)(labelToObject(label));
				}
				
				if (atom == null){
					return;
				}
				
				StructureMap map = atom.structure.getStructureMap();
				StructureStyles styles = map.getStructureStyles();
				styles.setRenderingStyle(atom, styleFlag, qualityFlag, false);
			}
			else if (setFlag == DialogConstants.APPLY_RESIDUE){
				Residue residue = null;
				if (atom == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				else{
					residue = atom.structure.getStructureMap().getResidue(atom);
				}
				
				if (residue == null) return;
				
				residue.structure.getStructureMap().getStructureStyles().setRenderingStyle(residue, styleFlag, qualityFlag, false);
				checkDummyAtoms(residue);
			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				Chain chain = null;
				
				if (((RenderingEvent)event).structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
					chain = (Chain)((RenderingEvent)event).structureComponent;
				}
				else{
					if (atom == null){
						try{
							int index = label.lastIndexOf(":");
							String newLabel = label.substring(0, index);
							int index2 = newLabel.lastIndexOf(":");
						
							chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
						}
						catch (ClassCastException ex){
							//happens when the labels ends with the residue record
							chain = (Chain)(labelToObject(label));
						}
					}
					else{
						chain = atom.structure.getStructureMap().getChain(atom);
					}
				}
				
				if (chain == null) return;

				chain.structure.getStructureMap().getStructureStyles().setRenderingStyle(chain, styleFlag, qualityFlag, false);
				checkDummyAtoms(chain.structure, true);
			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				Structure structure = null;
				if (atom == null){
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
				else{
					structure = atom.structure;
				}
				
				if (structure == null){
					return;
				}
				
				structure.getStructureMap().getStructureStyles().setRenderingStyle(styleFlag, qualityFlag);
				checkDummyAtoms(structure, true);
				geometryViewer.updateView();
			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				//walk through the loaded structures and check all selected items
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					
					//process individual atoms and bonds
					Enumeration selectedAtoms = styles.getSelection().keys();
					styles.setRenderingStyle(selectedAtoms, styleFlag, qualityFlag, true, false);
				}
				
			}
	
		}
		else if (source instanceof HydrogenDialog){

			
			String label = ((HydrogenEvent)event).componentId;
			int setFlag = ((HydrogenEvent)event).setFlag;
			int phFlag = ((HydrogenEvent)event).phFlag;
			float pH = ((HydrogenEvent)event).pH;
			
			if (setFlag == HydrogenDialog.PH_NEUTRAL){
				pH = 7.0f;
			}
			
			Atom atom = null;
			try{
				atom = (Atom)((HydrogenEvent)event).structureComponent;
			}
			catch (ClassCastException e){}
			
			if (setFlag != DialogConstants.APPLY_SELECTION){
				if (label.equals("") && atom == null){
					return;
				}
			}
			
			if (StylesPreferences.undoEnabled){
				saveStateForUndo();
			}
			
			
			if (atomSetNames.contains(label)){
				//a set has been selected
				
				Vector atomSet = (Vector)atomSets.get(label);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						//scan through residue atoms
						for (int j = 0; j < r.getAtomCount(); j++){
							Atom a = r.getAtom(j);
							StructureMath.checkHydrogens(a, this, pH, true);
						}
					}
					catch (ClassCastException e){
						Atom a = (Atom)atomSet.get(i);
						//check hydrogens at the given atom only
						StructureMath.checkHydrogens(a, this, pH, true);
					}
				}
				
				updateAppearance();
				structureDocument.parent.updateView();
				return;
			}

			if (setFlag == DialogConstants.APPLY_ATOM){
				//get atom object out of the label
				if (atom == null){
					atom = (Atom)(labelToObject(label));
				}
				
				if (atom == null){
					return;
				}
				
				StructureMap map = atom.structure.getStructureMap();
				StructureStyles styles = map.getStructureStyles();
				
				//check hydrogens at the given atom only
				StructureMath.checkHydrogens(atom, this, pH, false);
				updateAppearance();
				structureDocument.parent.updateView();
			}
			else if (setFlag == DialogConstants.APPLY_RESIDUE){
				Residue residue = null;
				if (atom == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				else{
					residue = atom.structure.getStructureMap().getResidue(atom);
				}
				
				if (residue == null){
					return;
				}
				
				//scan through residue atoms
				for (int i = 0; i < residue.getAtomCount(); i++){
					Atom a = residue.getAtom(i);
					StructureMath.checkHydrogens(a, this, pH, true);
				}
				updateAppearance();
				structureDocument.parent.updateView();
				
			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				Chain chain = null;
				if (atom == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
						int index2 = newLabel.lastIndexOf(":");
					
						chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						chain = (Chain)(labelToObject(label));
					}
				}
				else{
					chain = atom.structure.getStructureMap().getChain(atom);
				}
				
				if (chain == null){
					return;
				}
				
				//scan through residues and launch those that belong to this chain
				for (int i = 0; i < chain.structure.getStructureMap().getResidueCount(); i++){
					Residue residue = chain.structure.getStructureMap().getResidue(i);
					if (!residue.getChainId().equals(chain.getChainId())) continue;
						
					for (int j = 0; j < residue.getAtomCount(); j++){
						Atom a = residue.getAtom(j);
						StructureMath.checkHydrogens(a, this, pH, true);
					}
					
				}
				
				updateAppearance();
				structureDocument.parent.updateView();
			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				Structure structure = null;
				if (atom == null){
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
				else{
					structure = atom.structure;
				}
				
				if (structure == null){
					return;
				}
				StructureMath.checkHydrogens(structure, this, pH);
				structureDocument.parent.updateView();
			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				//walk through the loaded structures and check all selected items
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					
					//process individual atoms and bonds
					Enumeration selectedAtoms = styles.getSelection().keys();
					while (selectedAtoms.hasMoreElements()){
						try{
							Atom a = (Atom)selectedAtoms.nextElement();
							StructureMath.checkHydrogens(a, this, pH, true);
						}
						catch (Exception ex){
							continue;
						}
					}
				}
				updateAppearance();
				structureDocument.parent.updateView();
			}
		}
		
		else if (source instanceof WeightDialog){

			
			String label = ((WeightEvent)event).componentId;
			int setFlag = ((WeightEvent)event).setFlag;
			
			Atom atom = null;
			try{
				atom = (Atom)((WeightEvent)event).structureComponent;
			}
			catch (ClassCastException e){}
			
			if (setFlag != DialogConstants.APPLY_SELECTION){
				if (label.equals("") && atom == null){
					return;
				}
			}
			
			if (StylesPreferences.undoEnabled){
				saveStateForUndo();
			}
			
			double result = 0.0;
			
			if (atomSetNames.contains(label)){
				//a set has been selected
				
				Vector atomSet = (Vector)atomSets.get(label);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						//scan through residue atoms
						for (int j = 0; j < r.getAtomCount(); j++){
							Atom a = r.getAtom(j);
							result += PeriodicTable.getElementWeight(a.element);
						}
					}
					catch (ClassCastException e){
						Atom a = (Atom)atomSet.get(i);
						result += PeriodicTable.getElementWeight(a.element);
					}
				}
				
				return;
			}

			if (setFlag == DialogConstants.APPLY_ATOM){
				//get atom object out of the label
				if (atom == null){
					atom = (Atom)(labelToObject(label));
				}
				
				if (atom == null){
					return;
				}
				
				StructureMap map = atom.structure.getStructureMap();
				StructureStyles styles = map.getStructureStyles();
				
				//check hydrogens at the given atom only
				result += PeriodicTable.getElementWeight(atom.element);
				
			}
			else if (setFlag == DialogConstants.APPLY_RESIDUE){
				Residue residue = null;
				if (atom == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				else{
					residue = atom.structure.getStructureMap().getResidue(atom);
				}
				
				if (residue == null){
					return;
				}
				
				//scan through residue atoms
				for (int i = 0; i < residue.getAtomCount(); i++){
					Atom a = residue.getAtom(i);
					result += PeriodicTable.getElementWeight(a.element);
				}
				
			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				Chain chain = null;
				if (atom == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
						int index2 = newLabel.lastIndexOf(":");
					
						chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						chain = (Chain)(labelToObject(label));
					}
				}
				else{
					chain = atom.structure.getStructureMap().getChain(atom);
				}
				
				if (chain == null){
					return;
				}
				
				//scan through residues and launch those that belong to this chain
				for (int i = 0; i < chain.structure.getStructureMap().getResidueCount(); i++){
					Residue residue = chain.structure.getStructureMap().getResidue(i);
					if (!residue.getChainId().equals(chain.getChainId())) continue;
						
					for (int j = 0; j < residue.getAtomCount(); j++){
						Atom a = residue.getAtom(j);
						result += PeriodicTable.getElementWeight(a.element);
					}
					
				}
				
			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				Structure structure = null;
				if (atom == null){
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
				else{
					structure = atom.structure;
				}
				
				if (structure == null){
					return;
				}
				
				for (int i = 0; i < structure.getStructureMap().getAtomCount(); i++){
					Atom a = structure.getStructureMap().getAtom(i);
					result += PeriodicTable.getElementWeight(a.element);
				}
				
			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				//walk through the loaded structures and check all selected items
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					
					//process individual atoms and bonds
					Enumeration selectedAtoms = styles.getSelection().keys();
					while (selectedAtoms.hasMoreElements()){
						try{
							Atom a = (Atom)selectedAtoms.nextElement();
							result += PeriodicTable.getElementWeight(a.element);
						}
						catch (Exception ex){
							continue;
						}
					}
				}

			}
			
			//output the result
			String output = StringUtils.getFormattedNumber(result, 3);
			structureDocument.parent.displayMessage("Molecular weight = " + output + " Da");
		}

		else if (source instanceof CountBondsDialog){

			
			String label = ((WeightEvent)event).componentId;
			int setFlag = ((WeightEvent)event).setFlag;
			
			Atom atom = null;
			try{
				atom = (Atom)((WeightEvent)event).structureComponent;
			}
			catch (ClassCastException e){}
			
			if (setFlag != DialogConstants.APPLY_SELECTION){
				if (label.equals("") && atom == null){
					return;
				}
			}
			
			if (StylesPreferences.undoEnabled){
				saveStateForUndo();
			}
			
			int result = 0;
			
			if (setFlag == DialogConstants.APPLY_RESIDUE){
				Residue residue = null;
				if (atom == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				else{
					residue = atom.structure.getStructureMap().getResidue(atom);
				}
				
				if (residue == null){
					return;
				}
				
				StructureMap map = residue.structure.getStructureMap();
				for (int i = 0; i < map.getBondCount(); i++){
					Bond b = map.getBond(i);
					if (b.getAtom(0).element == 1 || b.getAtom(1).element == 1) continue;
					if (b.getAtom(0).residue == residue && b.getAtom(1).residue == residue){
						//also, exclude terminal bonds, i.e. when one of the atoms only has hydrogens
						//or no atoms at all
						//count all atoms around each atom that are not the other partner in the bond in question
						Vector atoms = map.getAtoms(b.getAtom(0));
						int nonH = 0;
						for (int j = 0; j < atoms.size(); j++){
							Atom a = (Atom)atoms.get(j);
							if (a == b.getAtom(1)) continue;
							if (a.element > 1) nonH++;
						}
						
						if (nonH == 0) continue;
						
						atoms = map.getAtoms(b.getAtom(1));
						nonH = 0;
						for (int j = 0; j < atoms.size(); j++){
							Atom a = (Atom)atoms.get(j);
							if (a == b.getAtom(0)) continue;
							if (a.element > 1) nonH++;
						}
						
						if (nonH == 0) continue;

						if (StructureMath.isRotatableBond(b)){
							result++;
						}
					}
				}
				
			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				Chain chain = null;
				if (atom == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
						int index2 = newLabel.lastIndexOf(":");
					
						chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						chain = (Chain)(labelToObject(label));
					}
				}
				else{
					chain = atom.structure.getStructureMap().getChain(atom);
				}
				
				if (chain == null){
					return;
				}
				
				StructureMap map = chain.structure.getStructureMap();
				for (int i = 0; i < map.getBondCount(); i++){
					Bond b = map.getBond(i);
					if (b.getAtom(0).element == 1 || b.getAtom(1).element == 1) continue;
					if (b.getAtom(0).chain_id == chain.getChainId() && b.getAtom(1).chain_id == chain.getChainId()){
						Vector atoms = map.getAtoms(b.getAtom(0));
						int nonH = 0;
						for (int j = 0; j < atoms.size(); j++){
							Atom a = (Atom)atoms.get(j);
							if (a == b.getAtom(1)) continue;
							if (a.element > 1) nonH++;
						}
						
						if (nonH == 0) continue;
						
						atoms = map.getAtoms(b.getAtom(1));
						nonH = 0;
						for (int j = 0; j < atoms.size(); j++){
							Atom a = (Atom)atoms.get(j);
							if (a == b.getAtom(0)) continue;
							if (a.element > 1) nonH++;
						}
						
						if (nonH == 0) continue;

						if (StructureMath.isRotatableBond(b)){
							result++;
						}
					}
				}
				
			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				Structure structure = null;
				if (atom == null){
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
				else{
					structure = atom.structure;
				}
				
				if (structure == null){
					return;
				}
				
				StructureMap map = structure.getStructureMap();
				for (int i = 0; i < map.getBondCount(); i++){
					Bond b = map.getBond(i);
					if (b.getAtom(0).element == 1 || b.getAtom(1).element == 1) continue;
					
					Vector atoms = map.getAtoms(b.getAtom(0));
					int nonH = 0;
					for (int j = 0; j < atoms.size(); j++){
						Atom a = (Atom)atoms.get(j);
						if (a == b.getAtom(1)) continue;
						if (a.element > 1) nonH++;
					}
					
					if (nonH == 0) continue;
					
					atoms = map.getAtoms(b.getAtom(1));
					nonH = 0;
					for (int j = 0; j < atoms.size(); j++){
						Atom a = (Atom)atoms.get(j);
						if (a == b.getAtom(0)) continue;
						if (a.element > 1) nonH++;
					}
					
					if (nonH == 0) continue;

					
					if (StructureMath.isRotatableBond(b)){
						result++;
					}
				}
				
			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				//walk through the loaded structures and check all selected items
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					
					for (int j = 0; j < structure.getStructureMap().getBondCount(); j++){
						Bond b = structure.getStructureMap().getBond(j);
						if (b.getAtom(0).element == 1 || b.getAtom(1).element == 1) continue;
						
						if (styles.isSelected(b)){

							Vector atoms = structure.getStructureMap().getAtoms(b.getAtom(0));
							int nonH = 0;
							for (int k = 0; k < atoms.size(); k++){
								Atom a = (Atom)atoms.get(k);
								if (a == b.getAtom(1)) continue;
								if (a.element > 1) nonH++;
							}
							
							if (nonH == 0) continue;
							
							atoms = structure.getStructureMap().getAtoms(b.getAtom(1));
							nonH = 0;
							for (int k = 0; k < atoms.size(); k++){
								Atom a = (Atom)atoms.get(k);
								if (a == b.getAtom(0)) continue;
								if (a.element > 1) nonH++;
							}
							
							if (nonH == 0) continue;

							
							if (StructureMath.isRotatableBond(b)){
								result++;
							}
						}
					}

				}

			}
			
			//output the result
			structureDocument.parent.displayMessage("Rotatable bond count = " + result);
		}
		
		else if (source instanceof VisibilityDialog){
			//decide which components need to be updated
			String label = ((VisibilityEvent)event).componentId;
			int setFlag = ((VisibilityEvent)event).setFlag;
			int visFlag = ((VisibilityEvent)event).visFlag;
			int typeFlag = ((VisibilityEvent)event).typeFlag;
			
			if (setFlag != DialogConstants.APPLY_SELECTION){
				if (((VisibilityEvent)event).structureComponent == null && label.equals("")){
					return;
				}
			}
			
			
			if (atomSetNames.contains(label)){
				
				if (typeFlag == VisibilityDialog.TYPE_RIBBON){
					structureDocument.parent.displayErrorMessage("Ribbon operation may only be applied to a chain or a structure");
					return;
				}
				
				//a set has been selected

				//go over the global options
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					
					//check special cases
					if (visFlag == VisibilityDialog.VIS_SHOW_ONLY){
						styles.hideAll(true);
					}
				}
				
//				repaintMonitors = false;
				
				Vector atomSet = (Vector)atomSets.get(label);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						if (visFlag == VisibilityDialog.VIS_HIDE){
							r.structure.getStructureMap().getStructureStyles().setVisible(r, false, true, true);
						}
						else{
							r.structure.getStructureMap().getStructureStyles().setVisible(r, true, true, true);
						}
						checkDummyAtoms(r);
					}
					catch (ClassCastException e){
						Atom a = (Atom)atomSet.get(i);
						if (visFlag == VisibilityDialog.VIS_HIDE){
							a.structure.getStructureMap().getStructureStyles().setVisible(a, false, true, true);
						}
						else{
							a.structure.getStructureMap().getStructureStyles().setVisible(a, true, true, true);
						}
						checkDummyAtoms(a, false);
					}
				}
				
				structureDocument.parent.updateView();
				
				if (repaintMonitors){
					MonitorDialog md = structureDocument.parent.getMonitorDialog();
					if (md != null) md.repaintTree();
				}
				
				return;
			}


			if (setFlag == DialogConstants.APPLY_ATOM){
				//get atom object out of the label
				Atom atom = null;
				try{
					atom = (Atom)((VisibilityEvent)event).structureComponent;
					
				}
				catch (Exception ex){
					//ribbon clicked
					return;
				}
				
				if (atom == null){
					atom = (Atom)(labelToObject(label));
				}
				
				if (atom == null){
					return;
				}
				
//				repaintMonitors = false;
				
				StructureMap map = atom.structure.getStructureMap();
				StructureStyles styles = map.getStructureStyles();
				if (visFlag == VisibilityDialog.VIS_HIDE){
					styles.setVisible(atom, false, true, false);
				}
				else if (visFlag == VisibilityDialog.VIS_SHOW){
					styles.setVisible(atom, true, true, false);
				}
				else if (visFlag == VisibilityDialog.VIS_SHOW_ONLY){
					//hide everything else, other structures included
					Vector s = getLoadedStructures();
					for (int i = 0; i < s.size(); i++){
						((Structure)s.get(i)).getStructureMap().getStructureStyles().hideAll(true);
					}
					styles.setVisible(atom, true, true, false);
				}
				
				if (repaintMonitors){
					MonitorDialog md = structureDocument.parent.getMonitorDialog();
					if (md != null) md.repaintTree();
				}

			}
			else if (setFlag == DialogConstants.APPLY_RESIDUE){
				
				if (typeFlag == VisibilityDialog.TYPE_RIBBON) return;
				
				Residue residue = null;
				try{
					Atom atom = (Atom)((VisibilityEvent)event).structureComponent;
					residue = atom.residue;
				}
				catch (ClassCastException r){
					try{
						residue = (Residue)((VisibilityEvent)event).structureComponent;
					}
					catch (Exception e){}
				}
				
				if (residue == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				
				if (residue == null){
					return;
				}
				
//				repaintMonitors = false;
				
				///for visibility, traverse all atoms and bonds of this residue and update their
				//visibility as well, without firing an event
				StructureMap map = residue.structure.getStructureMap();
				StructureStyles styles = map.getStructureStyles();
				
				if (visFlag == VisibilityDialog.VIS_HIDE){
					styles.setVisible(residue, false, true, false);
				}
				else if (visFlag == VisibilityDialog.VIS_SHOW){
					styles.setVisible(residue, true, true, false);
				}
				else if (visFlag == VisibilityDialog.VIS_SHOW_ONLY){
					Vector s = getLoadedStructures();
					for (int i = 0; i < s.size(); i++){
						((Structure)s.get(i)).getStructureMap().getStructureStyles().hideAll(true);
					}
					styles.setVisible(residue, true, true, false);
				}
				
				if (repaintMonitors){
					MonitorDialog md = structureDocument.parent.getMonitorDialog();
					if (md != null) md.repaintTree();
				}

			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				Chain chain = null;
				try{
					if (((VisibilityEvent)event).structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
						chain = (Chain)((VisibilityEvent)event).structureComponent;
					}
					else{
						try{
							Atom a = (Atom)((VisibilityEvent)event).structureComponent;
							chain = a.structure.getStructureMap().getChain(a);
						}
						catch (ClassCastException ex){
							Residue r = (Residue)((VisibilityEvent)event).structureComponent;
							chain = r.structure.getStructureMap().getChain(r.getAtom(0));
						}
						catch (NullPointerException s){}
					}
				}
				catch (Exception ex){}
				if (chain == null){
					
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
						int index2 = newLabel.lastIndexOf(":");
					
						if (index2 < 0){
							//there is probably no terminating :
							chain = (Chain)(labelToObject(newLabel));
						}
						else{
							chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
						}
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						chain = (Chain)(labelToObject(label));
					}
				}
				
				if (chain == null){
					return;
				}
				
//				repaintMonitors = false;
				
				StructureMap map = chain.structure.getStructureMap();
				StructureStyles styles = map.getStructureStyles();
				if (typeFlag == VisibilityDialog.TYPE_RIBBON){
					if (visFlag == VisibilityDialog.VIS_HIDE){
						styles.setRibbonVisible(chain, false, true, false);
					}
					else if (visFlag == VisibilityDialog.VIS_SHOW){
						styles.setRibbonVisible(chain, true, true, false);
					}
					else if (visFlag == VisibilityDialog.VIS_SHOW_ONLY){
						Vector s = getLoadedStructures();
						for (int i = 0; i < s.size(); i++){
							((Structure)s.get(i)).getStructureMap().getStructureStyles().hideAll(true);
						}
						styles.setRibbonVisible(chain, true, true, false);
					}
				}
				else{
					//structure
					if (visFlag == VisibilityDialog.VIS_HIDE){
						styles.setVisible(chain, false, true, false);
					}
					else if (visFlag == VisibilityDialog.VIS_SHOW){
						styles.setVisible(chain, true, true, false);
					}
					else if (visFlag == VisibilityDialog.VIS_SHOW_ONLY){
						Vector s = getLoadedStructures();
						for (int i = 0; i < s.size(); i++){
							((Structure)s.get(i)).getStructureMap().getStructureStyles().hideAll(true);
						}
						styles.setVisible(chain, true, true, false);
					}
				}
				
				if (repaintMonitors){
					MonitorDialog md = structureDocument.parent.getMonitorDialog();
					if (md != null) md.repaintTree();
				}
				
				//a bit of a hack here, to get any cluster renderables to hide or show
				//instead of placing them in the event handler, we need to keep them here, since
				//event handler receives events of a different level for full structure or chain display
				if (clusters.size() > 0){
					ClusterRenderable r = null;
					Set keys = clusters.keySet();
					Iterator it = keys.iterator();
					while (it.hasNext()){
						Cluster c = (Cluster)it.next();
						if (c.chain1 == chain){
							r = ((ClusterRenderable[])clusters.get(c))[0];
							if (r != null){
								if (visFlag == VisibilityDialog.VIS_HIDE){
									renderablesList.remove(r);
									c.visible1 = false;
								}
								else if (visFlag == VisibilityDialog.VIS_SHOW){
									renderablesList.add(r);
									c.visible1 = true;
								}
								else if (visFlag == VisibilityDialog.VIS_SHOW_ONLY){
									renderablesList.add(r);
									c.visible1 = true;
								}
								r.setDirty();
							}
							break;
						}
						else if (c.chain2 == chain){
							r = ((ClusterRenderable[])clusters.get(c))[1];
							if (r != null){
								if (visFlag == VisibilityDialog.VIS_HIDE){
									renderablesList.remove(r);
									c.visible2 = false;
								}
								else if (visFlag == VisibilityDialog.VIS_SHOW){
									renderablesList.add(r);
									c.visible2 = true;
								}
								else if (visFlag == VisibilityDialog.VIS_SHOW_ONLY){
									renderablesList.add(r);
									c.visible2 = true;
								}
								r.setDirty();
							}
							break;
						}
					}
					
					updateAppearance();
				}

			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				Structure structure = null;
				try{
					Atom a = (Atom)((VisibilityEvent)event).structureComponent;
					structure = a.structure;
				}
				catch (ClassCastException ex){
					Residue r = (Residue)((VisibilityEvent)event).structureComponent;
					structure = r.structure;
				}
				catch (NullPointerException s){}
				
				if (structure == null){
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
				
				if (structure == null){
					return;
				}
				
				if (typeFlag == VisibilityDialog.TYPE_RIBBON){
					if (visFlag == VisibilityDialog.VIS_HIDE){
						for (int i = 0; i < structure.getStructureMap().getChainCount(); i++){
							Chain c = structure.getStructureMap().getChain(i);
							structure.getStructureMap().getStructureStyles().setRibbonVisible(c, false, true, false);
						}
					}
					else if (visFlag == VisibilityDialog.VIS_SHOW){
						for (int i = 0; i < structure.getStructureMap().getChainCount(); i++){
							Chain c = structure.getStructureMap().getChain(i);
							structure.getStructureMap().getStructureStyles().setRibbonVisible(c, true, true, false);
						}
					}
					else if (visFlag == VisibilityDialog.VIS_SHOW_ONLY){
						Vector s = getLoadedStructures();
						for (int i = 0; i < s.size(); i++){
							if (s.get(i) == structure)continue;
							((Structure)s.get(i)).getStructureMap().getStructureStyles().hideAll(true);
							for (int j = 0; j < structure.getStructureMap().getChainCount(); j++){
								Chain c = structure.getStructureMap().getChain(j);
								structure.getStructureMap().getStructureStyles().setRibbonVisible(c, false, true, false);
							}
						}
						
						for (int i = 0; i < structure.getStructureMap().getChainCount(); i++){
							Chain c = structure.getStructureMap().getChain(i);
							structure.getStructureMap().getStructureStyles().setRibbonVisible(c, true, true, false);
						}
					}
				}
				else{
					if (visFlag == VisibilityDialog.VIS_HIDE){
						structure.getStructureMap().getStructureStyles().hideAll(false);
					}
					else if (visFlag == VisibilityDialog.VIS_SHOW){
						structure.getStructureMap().getStructureStyles().showAll(false);
					}
					else if (visFlag == VisibilityDialog.VIS_SHOW_ONLY){
						Vector s = getLoadedStructures();
						for (int i = 0; i < s.size(); i++){
							if (s.get(i) == structure)continue;
							((Structure)s.get(i)).getStructureMap().getStructureStyles().hideAll(true);
						}
						structure.getStructureMap().getStructureStyles().showAll(false);
					}
				}
				
				
			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				setVisibilityInSelection(visFlag);
				
			}
			
			structureDocument.parent.updateView();
		
		}
		else if (source instanceof LabelDialog){
			
			//decide which components need to be updated
			String label = ((LabelEvent)event).componentId;
			int setFlag = ((LabelEvent)event).setFlag;
			int typeFlag = ((LabelEvent)event).typeFlag;
			boolean add = ((LabelEvent)event).aux;
			String text = ((LabelEvent)event).text;
			
			if (setFlag != DialogConstants.APPLY_SELECTION && setFlag != DialogConstants.APPLY_ALL){
				if (((LabelEvent)event).structureComponent == null && label.equals("")){
					return;
				}
			}
			
			if (atomSetNames.contains(label)){
				
				//a set has been selected	
				Vector atomSet = (Vector)atomSets.get(label);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						for (int j = 0; j < r.getAtomCount(); j++){
							Atom a = r.getAtom(j);
							if (add){
								if (atomToLabels.containsKey(a)){
									//check whether the label has changed
									LabelComponent c = (LabelComponent)atomToLabels.get(a);
									if (c.dataType == typeFlag){
										if (c.dataType == LabelDialog.TYPE_CUSTOM){
											//check whether the text has changed
											if (!text.equals(c.label)){
												c.label = text;
											}
										}
									}
									else{
										c.dataType = typeFlag;
									}
								}
								else{
									//create a new label
									if (a.visible){
										createLabel(a, typeFlag, -1, text, false);
									}
								}
							}
							else{
								//remove label
								if (atomToLabels.containsKey(a)){
									removeLabel((LabelComponent)atomToLabels.get(a), false);
								}
							}
						}
					}
					catch (ClassCastException e){
						Atom a = (Atom)atomSet.get(i);
						if (add){
							if (atomToLabels.containsKey(a)){
								//check whether the label has changed
								LabelComponent c = (LabelComponent)atomToLabels.get(a);
								GlRenderable r = (GlRenderable)labels.get(c);
								if (c.dataType == typeFlag){
									if (c.dataType == LabelDialog.TYPE_CUSTOM){
										//check whether the text has changed
										if (!text.equals(c.label)){
											c.label = text;
											r.setDirty();
										}
									}
								}
								else{
									c.dataType = typeFlag;
									r.setDirty();
								}
							}
							else{
								//create a new label
								if (a.visible) createLabel(a, typeFlag, -1, text, false);
							}
						}
						else{
							//remove label
							if (atomToLabels.containsKey(a)){
								removeLabel((LabelComponent)atomToLabels.get(a), false);
							}
						}
					}
				}
				
				structureDocument.parent.updateView();
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				
				return;
			}


			if (setFlag == DialogConstants.APPLY_ATOM){
				//get atom object out of the label
				Atom atom = null;
				try{
					atom = (Atom)((LabelEvent)event).structureComponent;
					
				}
				catch (Exception ex){
					//ribbon clicked
					return;
				}
				
				if (atom == null){
					atom = (Atom)(labelToObject(label));
				}
				
				if (atom == null){
					return;
				}
				
				if (add){
					if (atomToLabels.containsKey(atom)){
						//check whether the label has changed
						LabelComponent c = (LabelComponent)atomToLabels.get(atom);
						GlRenderable r = (GlRenderable)labels.get(c);
						if (c.dataType == typeFlag){
							if (c.dataType == LabelDialog.TYPE_CUSTOM){
								//check whether the text has changed
								if (!text.equals(c.label)){
									c.label = text;
									r.setDirty();
								}
							}
						}
						else{
							c.dataType = typeFlag;
							r.setDirty();
						}
					}
					else{
						//create a new label
						if (atom.visible) createLabel(atom, typeFlag, -1, text, false);
					}
				}
				else{
					//remove label
					if (atomToLabels.containsKey(atom)){
						removeLabel((LabelComponent)atomToLabels.get(atom), false);
					}
				}

				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				geometryViewer.updateView();

			}
			else if (setFlag == DialogConstants.APPLY_RESIDUE){
				
				Residue residue = null;
				try{
					Atom atom = (Atom)((LabelEvent)event).structureComponent;
					residue = atom.residue;
				}
				catch (ClassCastException r){
					try{
						residue = (Residue)((LabelEvent)event).structureComponent;
					}
					catch (Exception e){}
				}
				
				if (residue == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				
				if (residue == null){
					return;
				}
				
				for (int j = 0; j < residue.getAtomCount(); j++){
					Atom a = residue.getAtom(j);
					if (add){
						if (atomToLabels.containsKey(a)){
							//check whether the label has changed
							LabelComponent c = (LabelComponent)atomToLabels.get(a);
							GlRenderable r = (GlRenderable)labels.get(c);
							if (c.dataType == typeFlag){
								if (c.dataType == LabelDialog.TYPE_CUSTOM){
									//check whether the text has changed
									if (!text.equals(c.label)){
										c.label = text;
										r.setDirty();
									}
								}
							}
							else{
								c.dataType = typeFlag;
								r.setDirty();
							}
						}
						else{
							//create a new label
							if (a.visible) createLabel(a, typeFlag, -1, text, false);
						}
					}
					else{
						//remove label
						if (atomToLabels.containsKey(a)){
							removeLabel((LabelComponent)atomToLabels.get(a), false);
						}
					}
				}
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				geometryViewer.updateView();

			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				Chain chain = null;
				
				if (((LabelEvent)event).structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
					chain = (Chain)((LabelEvent)event).structureComponent;
				}
				else{
					try{
						Atom a = (Atom)((LabelEvent)event).structureComponent;
						chain = a.structure.getStructureMap().getChain(a);
					}
					catch (ClassCastException ex){
						Residue r = (Residue)((LabelEvent)event).structureComponent;
						chain = r.structure.getStructureMap().getChain(r.getAtom(0));
					}
					catch (NullPointerException s){}
				}
				
				if (chain == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
						int index2 = newLabel.lastIndexOf(":");
					
						chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						chain = (Chain)(labelToObject(label));
					}
				}
				
				if (chain == null){
					return;
				}
				
				for (int i = 0; i < chain.getResidueCount(); i++){
					Residue r = chain.getResidue(i);
//					if (r.getCompoundCode().equals("HOH")){
//						if (!StylesPreferences.showBoundWaters){
//							continue;
//						}
//					}
					for (int j = 0; j < r.getAtomCount(); j++){
						Atom a = r.getAtom(j);
						if (add){
							if (atomToLabels.containsKey(a)){
								//check whether the label has changed
								LabelComponent c = (LabelComponent)atomToLabels.get(a);
								GlRenderable rr = (GlRenderable)labels.get(c);
								if (c.dataType == typeFlag){
									if (c.dataType == LabelDialog.TYPE_CUSTOM){
										//check whether the text has changed
										if (!text.equals(c.label)){
											c.label = text;
											rr.setDirty();
										}
									}
								}
								else{
									c.dataType = typeFlag;
									rr.setDirty();
								}
							}
							else{
								//create a new label
								if (a.visible) createLabel(a, typeFlag, -1, text, false);
							}
						}
						else{
							//remove label
							if (atomToLabels.containsKey(a)){
								removeLabel((LabelComponent)atomToLabels.get(a), false);
							}
						}

					}
				}
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				geometryViewer.updateView();

			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				Structure structure = null;
				try{
					Atom a = (Atom)((LabelEvent)event).structureComponent;
					structure = a.structure;
				}
				catch (ClassCastException ex){
					Residue r = (Residue)((LabelEvent)event).structureComponent;
					structure = r.structure;
				}
				catch (NullPointerException s){}
				
				if (structure == null){
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
				
				if (structure == null){
					return;
				}
				
				StructureMap map = structure.getStructureMap();
				for (int i = 0; i < map.getAtomCount(); i++){
					Atom a = map.getAtom(i);
//					if (a.residue.getCompoundCode().equals("HOH")){
//						if (!StylesPreferences.showBoundWaters){
//							continue;
//						}
//					}

					if (add){
						if (atomToLabels.containsKey(a)){
							//check whether the label has changed
							LabelComponent c = (LabelComponent)atomToLabels.get(a);
							GlRenderable r = (GlRenderable)labels.get(c);
							if (c.dataType == typeFlag){
								if (c.dataType == LabelDialog.TYPE_CUSTOM){
									//check whether the text has changed
									if (!text.equals(c.label)){
										c.label = text;
										r.setDirty();
									}
								}
							}
							else{
								c.dataType = typeFlag;
								r.setDirty();
							}
						}
						else{
							//create a new label
							if (a.visible) createLabel(a, typeFlag, -1, text, false);
						}
					}
					else{
						//remove label
						if (atomToLabels.containsKey(a)){
							removeLabel((LabelComponent)atomToLabels.get(a), false);
						}
					}

				}
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				geometryViewer.updateView();
				
			}
			else if (setFlag == DialogConstants.APPLY_ALL){
				
				for (int i = 0; i < getLoadedStructures().size(); i++){
					Structure structure = (Structure)getLoadedStructures().get(i);

					StructureMap map = structure.getStructureMap();
					for (int j = 0; j < map.getAtomCount(); j++){
						Atom a = map.getAtom(j);
//						if (a.residue.getCompoundCode().equals("HOH")){
//							if (!StylesPreferences.showBoundWaters){
//								continue;
//							}
//						}
						if (add){
							if (atomToLabels.containsKey(a)){
								//check whether the label has changed
								LabelComponent c = (LabelComponent)atomToLabels.get(a);
								GlRenderable r = (GlRenderable)labels.get(c);
								if (c.dataType == typeFlag){
									if (c.dataType == LabelDialog.TYPE_CUSTOM){
										//check whether the text has changed
										if (!text.equals(c.label)){
											c.label = text;
											r.setDirty();
										}
									}
								}
								else{
									c.dataType = typeFlag;
									r.setDirty();
								}
							}
							else{
								//create a new label
								if (a.visible) createLabel(a, typeFlag, -1, text, false);
							}
						}
						else{
							//remove label
							if (atomToLabels.containsKey(a)){
								removeLabel((LabelComponent)atomToLabels.get(a), false);
							}
						}

					}
				}

				
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				geometryViewer.updateView();

			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				//walk through the loaded structures and check all selected items
				
//				repaintMonitors = false;
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					
					Enumeration selectedAtoms = styles.getSelection().keys();
					
					Vector residues = new Vector();
					//run residues first, then leftover atoms
					while (selectedAtoms.hasMoreElements()){
						try{
							Residue r = (Residue)selectedAtoms.nextElement();
//							if (r.getCompoundCode().equals("HOH")){
//								if (!StylesPreferences.showBoundWaters){
//									continue;
//								}
//							}
							for (int j = 0; j < r.getAtomCount(); j++){
								Atom a = r.getAtom(j);
								if (add){
									if (atomToLabels.containsKey(a)){
										//check whether the label has changed
										LabelComponent c = (LabelComponent)atomToLabels.get(a);
										GlRenderable rr = (GlRenderable)labels.get(c);
										if (c.dataType == typeFlag){
											if (c.dataType == LabelDialog.TYPE_CUSTOM){
												//check whether the text has changed
												if (!text.equals(c.label)){
													c.label = text;
													rr.setDirty();
												}
											}
										}
										else{
											c.dataType = typeFlag;
											rr.setDirty();
										}
									}
									else{
										//create a new label
										if (a.visible) createLabel(a, typeFlag, -1, text, false);
									}
								}
								else{
									//remove label
									if (atomToLabels.containsKey(a)){
										removeLabel((LabelComponent)atomToLabels.get(a), false);
									}
								}
							}

							residues.add(r);
						}
						catch (Exception ex){
							continue;
						}
					}
					
					//run through the lone atoms
					selectedAtoms = styles.getSelection().keys();
					while (selectedAtoms.hasMoreElements()){
						try{
							
							Atom a = (Atom)selectedAtoms.nextElement();
							if (residues.contains(a.structure.getStructureMap().getResidue(a))) continue;
//							if (a.residue.getCompoundCode().equals("HOH")){
//								if (!StylesPreferences.showBoundWaters){
//									continue;
//								}
//							}
							
							if (add){
								if (atomToLabels.containsKey(a)){
									//check whether the label has changed
									LabelComponent c = (LabelComponent)atomToLabels.get(a);
									GlRenderable r = (GlRenderable)labels.get(c);
									if (c.dataType == typeFlag){
										if (c.dataType == LabelDialog.TYPE_CUSTOM){
											//check whether the text has changed
											if (!text.equals(c.label)){
												c.label = text;
												r.setDirty();
											}
										}
									}
									else{
										c.dataType = typeFlag;
										r.setDirty();
									}
								}
								else{
									//create a new label
									if (a.visible) createLabel(a, typeFlag, -1, text, false);
								}
							}
							else{
								//remove label
								if (atomToLabels.containsKey(a)){
									removeLabel((LabelComponent)atomToLabels.get(a), false);
								}
							}

						}
						catch (ClassCastException ex){}
					}
				}
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();

				geometryViewer.updateView();
			}
		
		
		}
		else if (source instanceof ResidueLabelDialog){

			//decide which components need to be updated
			String label = ((LabelEvent)event).componentId;
			int setFlag = ((LabelEvent)event).setFlag;
			int typeFlag = ((LabelEvent)event).typeFlag;
			boolean add = ((LabelEvent)event).aux;
			String text = ((LabelEvent)event).text;
			
			if (setFlag != DialogConstants.APPLY_SELECTION && setFlag != DialogConstants.APPLY_ALL){
				if (((LabelEvent)event).structureComponent == null && label.equals("")){
					return;
				}
			}
			
			if (atomSetNames.contains(label)){
				
				//a set has been selected	
				Vector atomSet = (Vector)atomSets.get(label);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						if (add){
							if (!r.visible) continue;
							Atom ref = r.centerAtom;
							if (ref == null) ref = r.getAtom(0);
							if (atomToResidueLabels.containsKey(ref)){
								//refresh the renderable
								ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(ref);
								GlRenderable rrr = (GlRenderable)labels.get(c);
								if (c.dataType == typeFlag){
									if (c.dataType == LabelDialog.TYPE_CUSTOM){
										//check whether the text has changed
										if (!text.equals(c.label)){
											c.label = text;
											rrr.setDirty();
										}
									}
								}
								else{
									c.dataType = typeFlag;
									rrr.setDirty();
								}
							}
							else{
								ResidueLabelComponent c = new ResidueLabelComponent(r, LabelDialog.TYPE_NAME, LabelGeometry.MEDIUM_FONT, text );
								MonitorRenderable rr = new MonitorRenderable(c, (ResidueLabelGeometry)defaultGeometry.get("ResidueLabelGeometry"));//don't translate
								labels.put(c, rr);
								atomToResidueLabels.put(c.reference, c);
								if (independentSet != null){
									if (independentSet.contains(c.reference)){
										independentGroup.addChild(rr);
									}
									else{
										renderablesList.add(rr);
									}
								}
								else{
									renderablesList.add(rr);
								}

							}

						}
						else{
							
							Atom a = r.centerAtom;
							if (a == null) a = r.getAtom(0);
							
							if (atomToResidueLabels.containsKey(a)){
								removeLabel((ResidueLabelComponent)atomToResidueLabels.get(a), false);
							}

						}
					}
					catch (ClassCastException e){}
				}
				
				structureDocument.parent.updateView();
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				
				return;
			}


			if (setFlag == DialogConstants.APPLY_RESIDUE){
				
				Residue residue = null;
				try{
					Atom atom = (Atom)((LabelEvent)event).structureComponent;
					residue = atom.residue;
				}
				catch (ClassCastException r){
					try{
						residue = (Residue)((LabelEvent)event).structureComponent;
					}
					catch (Exception e){}
				}
				
				if (residue == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				
				if (residue == null){
					return;
				}
				

				Atom ref = residue.centerAtom;
				if (ref == null) ref = residue.getAtom(0);
				if (add){
					if (!residue.visible) return;
					if (atomToResidueLabels.containsKey(residue.centerAtom)){
						//refresh the renderable
						ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(ref);
						GlRenderable rrr = (GlRenderable)labels.get(c);
						if (c.dataType == typeFlag){
							if (c.dataType == LabelDialog.TYPE_CUSTOM){
								//check whether the text has changed
								if (!text.equals(c.label)){
									c.label = text;
									rrr.setDirty();
								}
							}
						}
						else{
							c.dataType = typeFlag;
							rrr.setDirty();
						}
					}
					else{
						ResidueLabelComponent c = new ResidueLabelComponent(residue, LabelDialog.TYPE_NAME, LabelGeometry.MEDIUM_FONT, text );
						if (c.dataType == typeFlag){
							if (c.dataType == LabelDialog.TYPE_CUSTOM){
								//check whether the text has changed
								if (!text.equals(c.label)){
									c.label = text;
								}
							}
						}
						else{
							c.dataType = typeFlag;
						}
						
						MonitorRenderable rr = new MonitorRenderable(c, (ResidueLabelGeometry)defaultGeometry.get("ResidueLabelGeometry"));//don't translate
					
						labels.put(c, rr);
						atomToResidueLabels.put(c.reference, c);

						if (independentSet != null){
							if (independentSet.contains(c.reference)){
								independentGroup.addChild(rr);
							}
							else{
								renderablesList.add(rr);
							}
						}
						else{
							renderablesList.add(rr);
						}
					}
				}
				else{
					if (atomToResidueLabels.containsKey(ref)){
						removeLabel((ResidueLabelComponent)atomToResidueLabels.get(ref), false);
					}
				}
				
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				geometryViewer.updateView();

			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				Chain chain = null;
				
				if (((LabelEvent)event).structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
					chain = (Chain)((LabelEvent)event).structureComponent;
				}
				else{
					try{
						Atom a = (Atom)((LabelEvent)event).structureComponent;
						chain = a.structure.getStructureMap().getChain(a);
					}
					catch (ClassCastException ex){
						Residue r = (Residue)((LabelEvent)event).structureComponent;
						chain = r.structure.getStructureMap().getChain(r.getAtom(0));
					}
					catch (NullPointerException s){}
				}
				
				if (chain == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
						int index2 = newLabel.lastIndexOf(":");
					
						chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						chain = (Chain)(labelToObject(label));
					}
				}
				
				if (chain == null){
					return;
				}
				
				for (int i = 0; i < chain.getResidueCount(); i++){
					Residue r = chain.getResidue(i);
//					if (r.getCompoundCode().equals("HOH")){
//						if (!StylesPreferences.showBoundWaters){
//							continue;
//						}
//					}
					
					Atom ref = r.centerAtom;
					if (ref == null) ref = r.getAtom(0);
					if (add){
						if (!r.visible) return;
						if (atomToResidueLabels.containsKey(ref)){
							//refresh the renderable
							ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(ref);
							GlRenderable rrr = (GlRenderable)labels.get(c);
							if (c.dataType == typeFlag){
								if (c.dataType == LabelDialog.TYPE_CUSTOM){
									//check whether the text has changed
									if (!text.equals(c.label)){
										c.label = text;
										rrr.setDirty();
									}
								}
							}
							else{
								c.dataType = typeFlag;
								rrr.setDirty();
							}
						}
						else{
							ResidueLabelComponent c = new ResidueLabelComponent(r, LabelDialog.TYPE_NAME, LabelGeometry.MEDIUM_FONT, text );
							if (c.dataType == typeFlag){
								if (c.dataType == LabelDialog.TYPE_CUSTOM){
									//check whether the text has changed
									if (!text.equals(c.label)){
										c.label = text;
									}
								}
							}
							else{
								c.dataType = typeFlag;
							}

							MonitorRenderable rr = new MonitorRenderable(c, (ResidueLabelGeometry)defaultGeometry.get("ResidueLabelGeometry"));//don't translate
							labels.put(c, rr);
							atomToResidueLabels.put(c.reference, c);

							if (independentSet != null){
								if (independentSet.contains(c.reference)){
									independentGroup.addChild(rr);
								}
								else{
									renderablesList.add(rr);
								}
							}
							else{
								renderablesList.add(rr);
							}
						}
					}
					else{
						if (atomToResidueLabels.containsKey(ref)){
							removeLabel((ResidueLabelComponent)atomToResidueLabels.get(ref), false);
						}
					}

				}
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				geometryViewer.updateView();

			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				Structure structure = null;
				try{
					Atom a = (Atom)((LabelEvent)event).structureComponent;
					structure = a.structure;
				}
				catch (ClassCastException ex){
					Residue r = (Residue)((LabelEvent)event).structureComponent;
					structure = r.structure;
				}
				catch (NullPointerException s){}
				
				if (structure == null){
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
				
				if (structure == null){
					return;
				}
				
				StructureMap map = structure.getStructureMap();
				for (int i = 0; i < map.getResidueCount(); i++){
					Residue r = map.getResidue(i);
//					if (r.getCompoundCode().equals("HOH")){
//						if (!StylesPreferences.showBoundWaters){
//							continue;
//						}
//					}

					Atom ref = r.centerAtom;
					if (ref == null) ref = r.getAtom(0);
					if (add){
						if (!r.visible) return;
						if (atomToResidueLabels.containsKey(ref)){
							//refresh the renderable
							ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(ref);
							GlRenderable rrr = (GlRenderable)labels.get(c);
							if (c.dataType == typeFlag){
								if (c.dataType == LabelDialog.TYPE_CUSTOM){
									//check whether the text has changed
									if (!text.equals(c.label)){
										c.label = text;
										rrr.setDirty();
									}
								}
							}
							else{
								c.dataType = typeFlag;
								rrr.setDirty();
							}
						}
						else{
							ResidueLabelComponent c = new ResidueLabelComponent(r, LabelDialog.TYPE_NAME, LabelGeometry.MEDIUM_FONT, text );
							if (c.dataType == typeFlag){
								if (c.dataType == LabelDialog.TYPE_CUSTOM){
									//check whether the text has changed
									if (!text.equals(c.label)){
										c.label = text;
									}
								}
							}
							else{
								c.dataType = typeFlag;
							}

							MonitorRenderable rr = new MonitorRenderable(c, (ResidueLabelGeometry)defaultGeometry.get("ResidueLabelGeometry"));//don't translate
						
							labels.put(c, rr);
							atomToResidueLabels.put(c.reference, c);

							if (independentSet != null){
								if (independentSet.contains(c.reference)){
									independentGroup.addChild(rr);
								}
								else{
									renderablesList.add(rr);
								}
							}
							else{
								renderablesList.add(rr);
							}
						}
					}
					else{
						if (atomToResidueLabels.containsKey(ref)){
							removeLabel((ResidueLabelComponent)atomToResidueLabels.get(ref), false);
						}
					}

				}
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				
				geometryViewer.updateView();
				
			}
			else if (setFlag == DialogConstants.APPLY_ALL){
				
				for (int i = 0; i < getLoadedStructures().size(); i++){
					Structure structure = (Structure)getLoadedStructures().get(i);

					StructureMap map = structure.getStructureMap();
					for (int j = 0; j < map.getResidueCount(); j++){
						Residue r = map.getResidue(j);
						Atom ref = r.centerAtom;
						if (ref == null) r.getAtom(0);
						if (add){
							if (!r.visible) return;
							if (atomToResidueLabels.containsKey(ref)){
								//refresh the renderable
								ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(ref);
								GlRenderable rrr = (GlRenderable)labels.get(c);
								if (c.dataType == typeFlag){
									if (c.dataType == LabelDialog.TYPE_CUSTOM){
										//check whether the text has changed
										if (!text.equals(c.label)){
											c.label = text;
											rrr.setDirty();
										}
									}
								}
								else{
									c.dataType = typeFlag;
									rrr.setDirty();
								}
							}
							else{
								ResidueLabelComponent c = new ResidueLabelComponent(r, LabelDialog.TYPE_NAME, LabelGeometry.MEDIUM_FONT, text );
								if (c.dataType == typeFlag){
									if (c.dataType == LabelDialog.TYPE_CUSTOM){
										//check whether the text has changed
										if (!text.equals(c.label)){
											c.label = text;
										}
									}
								}
								else{
									c.dataType = typeFlag;
								}

								MonitorRenderable rr = new MonitorRenderable(c, (ResidueLabelGeometry)defaultGeometry.get("ResidueLabelGeometry"));
							
								labels.put(c, rr);
								atomToResidueLabels.put(c.reference, c);

								if (independentSet != null){
									if (independentSet.contains(c.reference)){
										independentGroup.addChild(rr);
									}
									else{
										renderablesList.add(rr);
									}
								}
								else{
									renderablesList.add(rr);
								}
							}
						}
						else{
							if (atomToResidueLabels.containsKey(ref)){
								removeLabel((ResidueLabelComponent)atomToResidueLabels.get(ref), false);
							}
						}
						
					}
				}

				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				
				geometryViewer.updateView();

			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				//walk through the loaded structures and check all selected items
				
//				repaintMonitors = false;
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					
					Enumeration selectedAtoms = styles.getSelection().keys();
					
					Vector residues = new Vector();
					//run residues first, then leftover atoms
					while (selectedAtoms.hasMoreElements()){
						try{
							Residue r = (Residue)selectedAtoms.nextElement();
							Atom ref = r.centerAtom;
							if (ref == null) ref = r.getAtom(0);
							if (add){
								if (!r.visible) return;
								if (atomToResidueLabels.containsKey(ref)){
									//refresh the renderable
									ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(ref);
									GlRenderable rrr = (GlRenderable)labels.get(c);
									if (c.dataType == typeFlag){
										if (c.dataType == LabelDialog.TYPE_CUSTOM){
											//check whether the text has changed
											if (!text.equals(c.label)){
												c.label = text;
												rrr.setDirty();
											}
										}
									}
									else{
										c.dataType = typeFlag;
										rrr.setDirty();
									}
								}
								else{
									ResidueLabelComponent c = new ResidueLabelComponent(r, LabelDialog.TYPE_NAME, LabelGeometry.MEDIUM_FONT, text );
									if (c.dataType == typeFlag){
										if (c.dataType == LabelDialog.TYPE_CUSTOM){
											//check whether the text has changed
											if (!text.equals(c.label)){
												c.label = text;
											}
										}
									}
									else{
										c.dataType = typeFlag;
									}
									MonitorRenderable rr = new MonitorRenderable(c, (ResidueLabelGeometry)defaultGeometry.get("ResidueLabelGeometry"));//don't translate
								
									labels.put(c, rr);
									atomToResidueLabels.put(c.reference, c);

									if (independentSet != null){
										if (independentSet.contains(c.reference)){
											independentGroup.addChild(rr);
										}
										else{
											renderablesList.add(rr);
										}
									}
									else{
										renderablesList.add(rr);
									}
								}
							}
							else{
								if (atomToResidueLabels.containsKey(ref)){
									removeLabel((ResidueLabelComponent)atomToResidueLabels.get(ref), false);
								}
							}

							residues.add(r);
						}
						catch (Exception ex){
							continue;
						}
					}
					
				}
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();

				geometryViewer.updateView();
			}
		
		
		
		}
		else if (source instanceof CenterDialog){
			String label = ((ViewEvent)event).componentId;
			Atom atom = null;
			try{
				atom = (Atom)((ViewEvent)event).structureComponent;
			}
			catch (ClassCastException e){}
			
			if (atom == null){
				atom = (Atom)labelToObject(label);
			}
			if (atom == null) return;
			try{
				geometryViewer.lookAt( atom.coordinate );
			}
			catch (ClassCastException ex){
				structureDocument.parent.displayErrorMessage("New center can only be assigned to an individual atom");
				return;
			}
		}
		
		/**
		 * TODO
		 */
		else if (source instanceof MotionDialog){
			
			if (independentGroup != null){
				structureDocument.parent.displayErrorMessage("A group of atoms is already set for independent motion. Finalize the previous operation and try again.");
				return;
			}
						
			String label = ((ViewEvent)event).componentId;
			Atom atom = null;
			try{
				atom = (Atom)((ViewEvent)event).structureComponent;
			}
			catch (ClassCastException e){}
			trackBumps = ((ViewEvent)event).flag;
			
			int setFlag = ((ViewEvent)event).setFlag;
			
			
			//the goal is to define a set of atoms that need to be transformed independently
			//the corresponding bonds then are also added, and the handler method will add a 
			//composite TransformGroupRenderable to display

			independentComponents.clear();
			
			Vector atoms = getIndependentAtomSet(atom, label, setFlag);
			
			if (atoms.size() == 0){
				structureDocument.parent.displayErrorMessage("The atom set is empty");
				return;
			}
			
			setIndependentMotion(atoms, true);

		
		}
		else if (source instanceof SelectionAreaDialog){
			String label = ((ViewEvent)event).componentId;
			Atom atom = null;
			try{
				atom = (Atom)((ViewEvent)event).structureComponent;
			}
			catch (ClassCastException e){}
			
			if (atom == null){
				atom = (Atom)labelToObject(label);
			}
			if (atom == null) return;
			
			float radius = ((ViewEvent)event).radius;
			boolean includeResidues = ((ViewEvent)event).flag;
			try{
				selectByRadius(atom, radius, includeResidues);
			}
			catch (ClassCastException ex){
				structureDocument.parent.displayErrorMessage("New center can only be assigned to an individual atom");
				return;
			}
		}
		else if (source instanceof BumpDialog){
			
			int interaction = ((StericEvent)event).type;
			double overlap = ((StericEvent)event).value;
			
			int setF1 = ((StericEvent)event).setFlags[0];
			int setF2 = ((StericEvent)event).setFlags[1];
			
			Atom atom1 = null;
			try{
				atom1 = (Atom)((StericEvent)event).atoms[0];
			}
			catch (ClassCastException e){}
			
			Atom atom2 = null;
			try{
				atom2 = (Atom)((StericEvent)event).atoms[1];
			}
			catch (ClassCastException e){}
			
			String label1 = (String)((StericEvent)event).atomLabels.get(0);
			String label2 = (String)((StericEvent)event).atomLabels.get(1);
			
			//the first set will definitely be present for both interaction cases
			//so, process the first one
			
			//the goal is to have two lists of Atoms - one for the item in question
			// and the other one is for the item it interacts with
			Vector ligandAtoms = new Vector();//names are only for convenience
			Vector proteinAtoms = new Vector();
			
			if (setF1 != DialogConstants.APPLY_SELECTION){
				if (label1.equals("") && atom1 == null){
					return;
				}
			}
			
			if (atomSetNames.contains(label1)){
				//a set has been selected
				
				Vector atomSet = (Vector)atomSets.get(label1);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						ligandAtoms.add(r);
					}
					catch (ClassCastException e){
						ligandAtoms.add(atomSet.get(i));
					}
				}
			}
			else{
				if (setF1 == DialogConstants.APPLY_RESIDUE){
					Residue residue = null;
					if (atom1 == null){
						try{
							int index = label1.lastIndexOf(":");
							String newLabel = label1.substring(0, index);
						
							residue = (Residue)(labelToObject(newLabel));
						}
						catch (ClassCastException ex){
							//happens when the labels ends with the residue record
							residue = (Residue)(labelToObject(label1));
						}
					}
					else{
						residue = atom1.structure.getStructureMap().getResidue(atom1);
					}
					
					if (residue == null){
						return;
					}
					
					ligandAtoms.add(residue);
					
				}
				else if (setF1 == DialogConstants.APPLY_CHAIN){
					Chain chain = null;
					if (atom1 == null){
						try{
							int index = label1.lastIndexOf(":");
							String newLabel = label1.substring(0, index);
							int index2 = newLabel.lastIndexOf(":");
						
							chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
						}
						catch (ClassCastException ex){
							//happens when the labels ends with the residue record
							chain = (Chain)(labelToObject(label1));
						}
					}
					else{
						chain = atom1.structure.getStructureMap().getChain(atom1);
					}
					
					if (chain == null){
						return;
					}
					
					StructureMap map = chain.structure.getStructureMap();
					
					//add chain atoms to the vector
					for (int i = 0; i < map.getResidueCount(); i++){
						Residue a = map.getResidue(i);
						if (a.getChainId().equals(chain.getChainId())){
							ligandAtoms.add(a);
						}
					}
	
				}
				else if (setF1 == DialogConstants.APPLY_STRUCTURE){
					Structure structure = null;
					if (atom1 == null){
						//no matter what information is contained in the label, pick only the first fragment
						int index = label1.indexOf(":");
						
						String newLabel = "";
						if (index == -1){
							newLabel = label1;
						}
						else{
							newLabel = label1.substring(0,index);
						}
						
						try{
							structure = (Structure)(labelToObject(newLabel));
						}
						catch (ClassCastException ex){
							return;
						}
					}
					else{
						structure = atom1.structure;
					}
					
					if (structure == null){
						return;
					}
					
					for (int i = 0; i < structure.getStructureMap().getResidueCount(); i++){
						ligandAtoms.add(structure.getStructureMap().getResidue(i));
					}
				}
				else if (setF1 == DialogConstants.APPLY_SELECTION){
					//walk through the loaded structures and check all selected items
					Vector s = getLoadedStructures();
					for (int i = 0; i < s.size(); i++){
						Structure structure = (Structure)s.get(i);
						StructureStyles styles = structure.getStructureMap().getStructureStyles();
						
						//process individual atoms and bonds
						Enumeration selectedAtoms = styles.getSelection().keys();
						Vector res = new Vector();
						while (selectedAtoms.hasMoreElements()){
							try{
								Residue r = (Residue)selectedAtoms.nextElement();
								ligandAtoms.add(r);
								res.add(r);
							}
							catch (Exception ex){
								continue;
							}
						}
						
						selectedAtoms = styles.getSelection().keys();
						while (selectedAtoms.hasMoreElements()){
							try{
								Atom a = (Atom)selectedAtoms.nextElement();
								if (res.contains(a.residue)) continue;
								ligandAtoms.add(a);
							}
							catch (Exception ex){
								continue;
							}
						}

					}
					
				}
			}
			
			if (interaction == BumpDialog.INTRASET){
				//compare the selected set to the rest of its structure
				if (ligandAtoms.size() == 0){
					return;
				}
				proteinAtoms = ligandAtoms;//search for bumps within the set itself
				
			}
			else{
				//process set 2 and add all atoms to the proteinAtoms vector
				if (setF1 == DialogConstants.APPLY_SELECTION && setF2 == DialogConstants.APPLY_SELECTION){
					structureDocument.parent.displayErrorMessage("Both sets apply to the same selection");
					return;
				}
				
				if (atomSetNames.contains(label2)){
					//a set has been selected
					
					Vector atomSet = (Vector)atomSets.get(label2);
					for (int i = 0; i < atomSet.size(); i++){
						try{
							Residue r = (Residue)atomSet.get(i);
							proteinAtoms.add(r);
						}
						catch (ClassCastException e){
							proteinAtoms.add(atomSet.get(i));
						}
					}
				}
				else{
					if (setF2 == DialogConstants.APPLY_RESIDUE){
						Residue residue = null;
						if (atom2 == null){
							try{
								int index = label2.lastIndexOf(":");
								String newLabel = label2.substring(0, index);
							
								residue = (Residue)(labelToObject(newLabel));
							}
							catch (ClassCastException ex){
								//happens when the labels ends with the residue record
								residue = (Residue)(labelToObject(label2));
							}
						}
						else{
							residue = atom2.structure.getStructureMap().getResidue(atom2);
						}
						
						if (residue == null){
							return;
						}
						
						proteinAtoms.add(residue);

					}
					else if (setF2 == DialogConstants.APPLY_CHAIN){
						Chain chain = null;
						if (atom2 == null){
							try{
								int index = label2.lastIndexOf(":");
								String newLabel = label2.substring(0, index);
								int index2 = newLabel.lastIndexOf(":");
							
								chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
							}
							catch (ClassCastException ex){
								//happens when the labels ends with the residue record
								chain = (Chain)(labelToObject(label2));
							}
						}
						else{
							chain = atom2.structure.getStructureMap().getChain(atom2);
						}
						
						if (chain == null){
							return;
						}
						
						StructureMap map = chain.structure.getStructureMap();
						
						//add chain atoms to the vector
						for (int i = 0; i < map.getResidueCount(); i++){
							Residue r = map.getResidue(i);
							if (r.getChainId().equals(chain.getChainId())){
								proteinAtoms.add(r);
							}
						}
	
					}
					else if (setF2 == DialogConstants.APPLY_STRUCTURE){
						Structure structure = null;
						if (atom2 == null){
							//no matter what information is contained in the label, pick only the first fragment
							int index = label2.indexOf(":");
							
							String newLabel = "";
							if (index == -1){
								newLabel = label2;
							}
							else{
								newLabel = label2.substring(0,index);
							}
							
							try{
								structure = (Structure)(labelToObject(newLabel));
							}
							catch (ClassCastException ex){
								return;
							}
						}
						else{
							structure = atom2.structure;
						}
						
						if (structure == null){
							return;
						}
						
						for (int i = 0; i < structure.getStructureMap().getResidueCount(); i++){
							proteinAtoms.add(structure.getStructureMap().getResidue(i));
						}
					}
					else if (setF2 == DialogConstants.APPLY_SELECTION){
						
						//walk through the loaded structures and check all selected items
						Vector s = getLoadedStructures();
						for (int i = 0; i < s.size(); i++){
							Structure structure = (Structure)s.get(i);
							StructureStyles styles = structure.getStructureMap().getStructureStyles();
							
							//process individual atoms and bonds
							Enumeration selectedAtoms = styles.getSelection().keys();
							Vector res = new Vector();
							while (selectedAtoms.hasMoreElements()){
								try{
									Residue r = (Residue)selectedAtoms.nextElement();
									proteinAtoms.add(r);
									res.add(r);
								}
								catch (Exception ex){
									continue;
								}
							}
							
							selectedAtoms = styles.getSelection().keys();
							while (selectedAtoms.hasMoreElements()){
								try{
									Atom a = (Atom)selectedAtoms.nextElement();
									if (res.contains(a.residue)) continue;
									proteinAtoms.add(a);
								}
								catch (Exception ex){
									continue;
								}
							}
						}
						
					}
					
					
				}
			}
			
			detectBumps(ligandAtoms, proteinAtoms, overlap, (interaction == BumpDialog.INTRASET), false);
	
		}
		else if (source instanceof HBDialog){

			
			int interaction = ((StericEvent)event).type;
			double maximum = ((StericEvent)event).value;
			
			int setF1 = ((StericEvent)event).setFlags[0];
			int setF2 = ((StericEvent)event).setFlags[1];
			
			Atom atom1 = null;
			try{
				atom1 = (Atom)((StericEvent)event).atoms[0];
			}
			catch (ClassCastException e){}
			
			Atom atom2 = null;
			try{
				atom2 = (Atom)((StericEvent)event).atoms[1];
			}
			catch (ClassCastException e){}
			
			String label1 = (String)((StericEvent)event).atomLabels.get(0);
			String label2 = (String)((StericEvent)event).atomLabels.get(1);
			
			//the first set will definitely be present for both interaction cases
			//so, process the first one
			
			//the goal is to have two lists of Atoms - one for the item in question
			// and the other one is for the item it interacts with
			
			//one alternative case is to have a fully intramolecular case, to check all atoms
			//within the structure
			Vector ligandAtoms = new Vector();//names are only for convenience
			Vector proteinAtoms = new Vector();
			
			if (setF1 != DialogConstants.APPLY_SELECTION){
				if (label1.equals("") && atom1 == null){
					return;
				}
			}
			
			boolean multistructure = false;//whether selection spans several structures
			
			if (atomSetNames.contains(label1)){
				//a set has been selected
				
				Vector atomSet = (Vector)atomSets.get(label1);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						for (int j = 0; j < r.getAtomCount(); j++){
							ligandAtoms.add(r.getAtom(j));
						}
					}
					catch (ClassCastException e){
						ligandAtoms.add(atomSet.get(i));
					}
				}
			}
			else{

				if (setF1 == DialogConstants.APPLY_RESIDUE){
					Residue residue = null;
					if (atom1 == null){
						try{
							int index = label1.lastIndexOf(":");
							String newLabel = label1.substring(0, index);
						
							residue = (Residue)(labelToObject(newLabel));
						}
						catch (ClassCastException ex){
							//happens when the labels ends with the residue record
							residue = (Residue)(labelToObject(label1));
						}
					}
					else{
						residue = atom1.structure.getStructureMap().getResidue(atom1);
					}
					
					if (residue == null){
						return;
					}
					
					for (int i = 0; i < residue.getAtomCount(); i++){
						ligandAtoms.add(residue.getAtom(i));
					}
				}
				else if (setF1 == DialogConstants.APPLY_CHAIN){
					Chain chain = null;
					if (atom1 == null){
						try{
							int index = label1.lastIndexOf(":");
							String newLabel = label1.substring(0, index);
							int index2 = newLabel.lastIndexOf(":");
						
							chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
						}
						catch (ClassCastException ex){
							//happens when the labels ends with the residue record
							chain = (Chain)(labelToObject(label1));
						}
					}
					else{
						chain = atom1.structure.getStructureMap().getChain(atom1);
					}
					
					if (chain == null){
						return;
					}
					
					StructureMap map = chain.structure.getStructureMap();
					
					//add chain atoms to the vector
					for (int i = 0; i < map.getAtomCount(); i++){
						Atom a = map.getAtom(i);
						if (a.chain_id.equals(chain.getChainId())){
							ligandAtoms.add(a);
						}
					}
	
				}
				else if (setF1 == DialogConstants.APPLY_STRUCTURE){
					Structure structure = null;
					if (atom1 == null){
						//no matter what information is contained in the label, pick only the first fragment
						int index = label1.indexOf(":");
						
						String newLabel = "";
						if (index == -1){
							newLabel = label1;
						}
						else{
							newLabel = label1.substring(0,index);
						}
						
						try{
							structure = (Structure)(labelToObject(newLabel));
						}
						catch (ClassCastException ex){
							return;
						}
					}
					else{
						structure = atom1.structure;
					}
					
					if (structure == null){
						return;
					}
					
					for (int i = 0; i < structure.getStructureMap().getAtomCount(); i++){
						ligandAtoms.add(structure.getStructureMap().getAtom(i));
					}
				}
				else if (setF1 == DialogConstants.APPLY_SELECTION){
					//walk through the loaded structures and check all selected items
					Vector s = getLoadedStructures();
					int added = -1;
					for (int i = 0; i < s.size(); i++){
						Structure structure = (Structure)s.get(i);
						StructureStyles styles = structure.getStructureMap().getStructureStyles();
						
						//process individual atoms and bonds
						Enumeration selectedAtoms = styles.getSelection().keys();
						while (selectedAtoms.hasMoreElements()){
							try{
								ligandAtoms.add((Atom)selectedAtoms.nextElement());
								if (added != -1 && added != i){
									multistructure = true;
								}
							}
							catch (Exception ex){
								continue;
							}
						}
					}
					
				}
			}
			
			if (interaction == BumpDialog.INTRASET){
				//compare the selected set to the rest of its structure
				
				if (ligandAtoms.size() == 0){
					return;
				}
				
				proteinAtoms = ligandAtoms;
			}
			else{
				//process set 2 and add all atoms to the proteinAtoms vector
				if (setF1 == DialogConstants.APPLY_SELECTION && setF2 == DialogConstants.APPLY_SELECTION){
					structureDocument.parent.displayErrorMessage("Both sets of atoms apply to the same selection");
					return;
				}
				
				if (atomSetNames.contains(label2)){
					//a set has been selected
					
					Vector atomSet = (Vector)atomSets.get(label2);
					for (int i = 0; i < atomSet.size(); i++){
						try{
							Residue r = (Residue)atomSet.get(i);
							for (int j = 0; j < r.getAtomCount(); j++){
								proteinAtoms.add(r.getAtom(j));
							}
						}
						catch (ClassCastException e){
							proteinAtoms.add(atomSet.get(i));
						}
					}
				}
				else{
				
					if (setF2 == DialogConstants.APPLY_RESIDUE){
						Residue residue = null;
						if (atom2 == null){
							try{
								int index = label2.lastIndexOf(":");
								String newLabel = label2.substring(0, index);
							
								residue = (Residue)(labelToObject(newLabel));
							}
							catch (ClassCastException ex){
								//happens when the labels ends with the residue record
								residue = (Residue)(labelToObject(label2));
							}
						}
						else{
							residue = atom2.structure.getStructureMap().getResidue(atom2);
						}
						
						if (residue == null){
							return;
						}
						
						for (int i = 0; i < residue.getAtomCount(); i++){
							proteinAtoms.add(residue.getAtom(i));
						}
					}
					else if (setF2 == DialogConstants.APPLY_CHAIN){
						Chain chain = null;
						if (atom2 == null){
							try{
								int index = label2.lastIndexOf(":");
								String newLabel = label2.substring(0, index);
								int index2 = newLabel.lastIndexOf(":");
							
								chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
							}
							catch (ClassCastException ex){
								//happens when the labels ends with the residue record
								chain = (Chain)(labelToObject(label2));
							}
						}
						else{
							chain = atom2.structure.getStructureMap().getChain(atom2);
						}
						
						if (chain == null){
							return;
						}
						
						StructureMap map = chain.structure.getStructureMap();
						
						//add chain atoms to the vector
						for (int i = 0; i < map.getAtomCount(); i++){
							Atom a = map.getAtom(i);
							if (a.chain_id.equals(chain.getChainId())){
								proteinAtoms.add(a);
							}
						}
	
					}
					else if (setF2 == DialogConstants.APPLY_STRUCTURE){
						Structure structure = null;
						if (atom2 == null){
							//no matter what information is contained in the label, pick only the first fragment
							int index = label2.indexOf(":");
							
							String newLabel = "";
							if (index == -1){
								newLabel = label2;
							}
							else{
								newLabel = label2.substring(0,index);
							}
							
							try{
								structure = (Structure)(labelToObject(newLabel));
							}
							catch (ClassCastException ex){
								return;
							}
						}
						else{
							structure = atom2.structure;
						}
						
						if (structure == null){
							return;
						}
						
						for (int i = 0; i < structure.getStructureMap().getAtomCount(); i++){
							proteinAtoms.add(structure.getStructureMap().getAtom(i));
						}
					}
					else if (setF2 == DialogConstants.APPLY_SELECTION){
						
						//walk through the loaded structures and check all selected items
						Vector s = getLoadedStructures();
						int added = -1;
						for (int i = 0; i < s.size(); i++){
							Structure structure = (Structure)s.get(i);
							StructureStyles styles = structure.getStructureMap().getStructureStyles();
							
							//process individual atoms and bonds
							Enumeration selectedAtoms = styles.getSelection().keys();
							while (selectedAtoms.hasMoreElements()){
								try{
									proteinAtoms.add((Atom)selectedAtoms.nextElement());
									if (added != -1 && added != i){
										multistructure = true;
									}
									added = i;
								}
								catch (Exception ex){
									continue;
								}
							}
						}
						
					}
					
					
				}
			}
			
			detectHydrogenBonds(ligandAtoms, proteinAtoms, maximum, (interaction == BumpDialog.INTRASET));
	
		
		}
		else if (source instanceof StructureEditDialog){
			
			int type = ((StericEvent)event).type;
			String name = ((StericEvent)event).text;
			
			int setF1 = ((StericEvent)event).setFlags[0];
			int setF2 = ((StericEvent)event).setFlags[1];
			
			Atom atom1 = null;
			try{
				atom1 = (Atom)((StericEvent)event).atoms[0];
			}
			catch (ClassCastException e){}

			Atom atom2 = null;
			try{
				atom2 = (Atom)((StericEvent)event).atoms[1];
			}
			catch (ClassCastException e){}
			
			String label1 = (String)((StericEvent)event).atomLabels.get(0);
			String label2 = (String)((StericEvent)event).atomLabels.get(1);
			
			//the first set will definitely be present for all cases
			//so, process the first one
			
			//the goal is to have two lists of Atoms - one for the item in question
			// and the other one is for the other atom
			
			Vector atoms1 = new Vector();//names are only for convenience
			Vector atoms2 = new Vector();
			
			Vector residues1 = new Vector();//list of complete residues affected by this change
			
			if (setF1 != DialogConstants.APPLY_SELECTION){
				if (label1.equals("") && atom1 == null){
					structureDocument.parent.displayErrorMessage("Nothing is picked and no name is typed in.");
					return;
				}
			}
			
			if (setF1 == DialogConstants.APPLY_SELECTION && !anythingSelected()){
				structureDocument.parent.displayErrorMessage("Nothing is selected. No set of atoms to operate");
				return;
			}
			
			Structure structure1 = null;
			Structure structure2 = null;
			
			if (atomSetNames.contains(label1) && type != StructureEditDialog.MERGE){
				//a set has been selected
				
				Vector atomSet = (Vector)atomSets.get(label1);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						residues1.add(r);
					}
					catch (ClassCastException e){
						Atom a = (Atom)atomSet.get(i);
						atoms1.add(a);
					}
				}
			}
			else{
			
				if (setF1 == DialogConstants.APPLY_RESIDUE){
					Residue residue = null;
					if (atom1 == null){
						try{
							int index = label1.lastIndexOf(":");
							String newLabel = label1.substring(0, index);
						
							residue = (Residue)(labelToObject(newLabel));
						}
						catch (ClassCastException ex){
							//happens when the labels ends with the residue record
							residue = (Residue)(labelToObject(label1));
						}
					}
					else{
						residue = atom1.structure.getStructureMap().getResidue(atom1);
					}
					
					if (residue == null){
						return;
					}
					
					residues1.add(residue);
				}
				else if (setF1 == DialogConstants.APPLY_CHAIN){
					Chain chain = null;
					if (atom1 == null){
						try{
							int index = label1.lastIndexOf(":");
							String newLabel = label1.substring(0, index);
							int index2 = newLabel.lastIndexOf(":");
						
							chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
						}
						catch (ClassCastException ex){
							//happens when the labels ends with the residue record
							chain = (Chain)(labelToObject(label1));
						}
					}
					else{
						chain = atom1.structure.getStructureMap().getChain(atom1);
					}
					
					if (chain == null){
						return;
					}
					
					StructureMap map = chain.structure.getStructureMap();
					
					//add chain atoms to the vector
					for (int i = 0; i < map.getResidueCount(); i++){
						Residue r = map.getResidue(i);
						if (!r.getAtom(0).chain_id.equals(chain.getChainId())) continue;
						residues1.add(r);
					}
	
				}
				else if (setF1 == DialogConstants.APPLY_STRUCTURE){
					
					if (type == StructureEditDialog.DELETE){
						structureDocument.parent.displayErrorMessage("You are effectively attempting to delete the entire structure. Select close instead");
						return;
					}
					
					Structure structure = null;
					if (atom1 == null){
						//no matter what information is contained in the label, pick only the first fragment
						int index = label1.indexOf(":");
						
						String newLabel = "";
						if (index == -1){
							newLabel = label1;
						}
						else{
							newLabel = label1.substring(0,index);
						}
						
						try{
							structure = (Structure)(labelToObject(newLabel));
						}
						catch (ClassCastException ex){
							return;
						}
					}
					else{
						structure = atom1.structure;
					}
					
					if (structure == null){
						return;
					}
					
					structure1 = structure;
					
					for (int i = 0; i < structure.getStructureMap().getResidueCount(); i++){
						Residue r = structure.getStructureMap().getResidue(i);
						residues1.add(r);
						
					}
				}
				else if (setF1 == DialogConstants.APPLY_SELECTION){
					
					//walk through the loaded structures and check all selected items
					Vector s = getLoadedStructures();
					for (int i = 0; i < s.size(); i++){
						Structure structure = (Structure)s.get(i);
						StructureStyles styles = structure.getStructureMap().getStructureStyles();
						
						//process individual atoms and bonds
						Enumeration selectedAtoms = styles.getSelection().keys();
						while (selectedAtoms.hasMoreElements()){
							try{
								residues1.add((Residue)selectedAtoms.nextElement());
							}
							catch (Exception ex){
								continue;
							}
						}
						
//						System.out.println("residues1 = " + residues1.size());
						
						//whatever is left of selectedAtoms contains actual atoms
						selectedAtoms = styles.getSelection().keys();
						while (selectedAtoms.hasMoreElements()){
							try{
								Atom a = (Atom)selectedAtoms.nextElement();
								if (residues1.contains(a.structure.getStructureMap().getResidue(a)))continue;
								atoms1.add(a);
							}
							catch (Exception ex){
								continue;
							}
						}
						
//						System.out.println("atoms1 = " + atoms1.size());

					}
					
				}
			}
			
//			System.out.println("renderablesList before = " + renderablesList.size());
			if (type == StructureEditDialog.DELETE){
				//remove atoms and their associated bonds from the structure they are in
				//could be in multiple structures,so scan all loaded objects
				
				if (atoms1.size() == 0 && residues1.size() == 0){
					return;
				}
				

				//walk through the residues first, then finish the atoms
				for (int i = 0; i < residues1.size(); i++){
					Residue r = (Residue)residues1.get(i);
//					System.out.println("deleting residue = " + r);
					r.structure.getStructureMap().getStructureStyles().deleteStructureComponent(r, true, true);
				}
				
				for (int i = 0; i < atoms1.size(); i++){
					Atom a = (Atom)atoms1.get(i);
//					System.out.println("deleting atom = " + a);
//					System.out.println("styles = " + a.structure.getStructureMap().getStructureStyles());
					a.structure.getStructureMap().getStructureStyles().deleteStructureComponent(a, true, true);
				}
				
/*				System.out.println("checking dummies");
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					this.checkDummyAtoms((Structure)s.get(i), false);
				}
				
				System.out.println("cleaning up sets");
				if (atomSets.containsKey(label1)){
					//this will remove all atoms that are part of the set
					//remove the set
					atomSets.remove(label1);
					atomSetNames.remove(label1);
				}
*/				
//				System.out.println("renderablesList after = " + renderablesList.size());

				structureDocument.parent.updateView();
				
//				System.out.println("renderablesList final = " + renderablesList.size());

			}
			else if (type == StructureEditDialog.EXTRACT){
				
				//remove the structure components from the original structure, create new one and assign
				//them to it, without touching the geometry (except for the structureHash reassignment)
				//Also, perform the bookkeeping in StructureDocument, since this will create a full-blown
				//entry.
				
				StructureEntry entry = new StructureEntry();
				entry.setName(name);
				
				//walk through the structure components to be extracted and place them in the Hashtable
				Hashtable components = new Hashtable();
				Vector atomComponents = new Vector();
				Vector bondComponents = new Vector();
				
				HashMap referenceStructure = new HashMap();//structurecomponent -> its former structure object
				HashMap referenceRender = new HashMap();//structure component -> renderable
				
				Vector bonds = new Vector();//to take care of their geometry
				
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureMap map = structure.getStructureMap();
					StructureStyles styles = structure.getStructureMap().getStructureStyles();

					Hashtable structureHash = (Hashtable)objectHash.get(structure);

					//start with any complete residues
					for (int j = 0; j < residues1.size(); j++){
						Residue r = (Residue)residues1.get(j);
						if (r.structure != structure) continue;
						
						//scan through its atoms
						for (int k = 0; k < r.getAtomCount(); k++){
							Atom a = r.getAtom(k);
							atomComponents.add(a);
							referenceStructure.put(a, structure);
							referenceRender.put(a, structureHash.get(a));
							
							Vector bb = map.getBonds(a);
							if (bb != null && bb.size() > 0){
								for (int n = 0 ; n < bb.size(); n++){
									Bond b = (Bond)bb.get(n);
									if (!bonds.contains(b)){
										bondComponents.add(b);
										bonds.add(b);
										referenceStructure.put(b, structure);
										referenceRender.put(b, structureHash.get(b));
									}
									
								}
							}
							
						}
					}
					
					//process individual atoms and bonds that are left after full residue processing
					Vector atoms = new Vector();
					for (int j = 0; j < atoms1.size(); j++){
						Atom a = (Atom)atoms1.get(j);
						if (a.structure != structure) continue;
						
						atomComponents.add(a);
						referenceStructure.put(a, structure);
						referenceRender.put(a, structureHash.get(a));
						
						Vector bb = map.getBonds(a);
						if (bb != null && bb.size() > 0){
							for (int k = 0 ; k< bb.size(); k++){
								Bond b = (Bond)bb.get(k);
								if (!bonds.contains(b)){
									bondComponents.add(b);
									bonds.add(b);
									referenceStructure.put(b, structure);
									referenceRender.put(b, structureHash.get(b));
								}
								
							}
						}
					}
				}
				
//				System.out.println("Size of bonds = " + bonds.size());
				
//				System.out.println("residues1 = " + residues1);
				
				components.put(StructureComponentRegistry.TYPE_ATOM, atomComponents);
				components.put(StructureComponentRegistry.TYPE_BOND, bondComponents);
				components.put(StructureComponentRegistry.TYPE_RESIDUE, residues1);
				
				Structure st = IOHandler.getStructure(components, name);
				entry.setStructure(st);
				entry.TYPE = StructureEntry.STRUCTURE_ENTRY;
				structureDocument.addEntryRecord(entry);
				
				structureNames.put(st, name);
				
				structures.put(entry, st);
				structureList.add(st);
				
				StructureMap newMap = st.getStructureMap();
				StructureStyles newStyles = newMap.getStructureStyles();
				newStyles.addStructureStylesEventListener( this );
				
				Vector renderablesVector = new Vector();//to be placed in renderables
				Hashtable stHash = new Hashtable();
				
				objectHash.put(st, stHash);
				renderables.put(st, renderablesVector);

				
				//make a second pass to get the styles and reassign structureHash records to
				//the new structure
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					if (structure == st){
						continue;
					}
					
					StructureMap map = structure.getStructureMap();
					StructureStyles oldStyles = structure.getStructureMap().getStructureStyles();					
					
					Hashtable structureHash = (Hashtable)objectHash.get(structure);
					Vector rvector = (Vector)renderables.get(structure);
					
					//process whole residue records
					for (int j = 0; j < residues1.size(); j++){
						Residue r = (Residue)residues1.get(j);
						oldStyles.deleteStructureComponent(r, false, true);
						
					}

					//process individual atoms and bonds
					Vector atoms = new Vector();
					for (int j = 0; j < atoms1.size(); j++){
						Atom a = (Atom)atoms1.get(j);
						if (referenceStructure.get(a) != structure) continue;
						
						//take care of the renderables
						MbtRenderable r = (MbtRenderable)referenceRender.get(a);
						if (r != null){
							stHash.put(a, r);
							renderablesVector.add(r);
							rvector.remove(r);
							r.structureStyles = newStyles;
						}
						structureHash.remove(a);

						Vector bb = map.getBonds(a);
						if (bb != null && bb.size() > 0){
							for (int k = 0 ; k< bb.size(); k++){
								Bond b = (Bond)bb.get(k);
								if (bonds.contains(b)){
									MbtRenderable rr = (MbtRenderable)referenceRender.get(b);
//									System.out.println("bond = " + b + ",rr = " + rr);
									if (rr != null){
//										System.out.println("placing a renderable into hash");
										stHash.put(b, rr);
										renderablesVector.add(rr);
										rr.structureStyles = newStyles;
									}
									
									newStyles.setBondColor(b, oldStyles.getBondColor(b));
									newStyles.setBondRadius(b, oldStyles.getBondRadius(b));
//									newStyles.setVisible(b, b., true, false);
									
									map.removeBond(b);//directly call it because firing calls it in the new styles as well
									structureHash.remove(b);
									rvector.remove(rr);
									bonds.remove(b);//to avoid double processing
								}
								
							}
						}
						
						map.removeAtom(a);

						
						//get the styles and delete the component from the original styles
						newStyles.setAtomColor(a, oldStyles.getAtomColor(a), true, true);
						newStyles.setAtomRadius(a, oldStyles.getAtomRadius(a));
						newStyles.setSelected(a, oldStyles.isSelected(a), true, false);
						
//						oldStyles.deleteStructureComponent(a, false, true);
						
						
					}
					
				}
				
/*				//remove residues from the old structure
				for (int i = residues1.size()-1; i >= 0; i--){
					Residue r = (Residue)residues1.get(i);
					r.structure.getStructureMap().getStructureStyles().deleteStructureComponent(r, false, true);
					r.structure.getStructureMap().
				}
				
				//remaining atoms
				for (int i = atoms1.size()-1; i >= 0; i--){
					Atom a = (Atom)atoms1.get(i);
					a.structure.getStructureMap().getStructureStyles().deleteStructureComponent(a, false, true);
				}
*/				
				//check new structure
				for (int i = 0; i < newMap.getResidueCount(); i++){
					Residue r = newMap.getResidue(i);
				}
				
				
				for (int i = 0; i < s.size(); i++){
					this.checkDummyAtoms((Structure)s.get(i), false);
				}

				structureDocument.reloadContent();

			}
			else if (type == StructureEditDialog.MERGE){
				
//				if (structure1 == null){
//					System.out.println("structure1 = null");
//				}
				
				if (atom2 == null){
					//no matter what information is contained in the label, pick only the first fragment
					int index = label2.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label2;
					}
					else{
						newLabel = label2.substring(0,index);
					}
					
					try{
						structure2 = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
				else{
					structure2 = atom2.structure;
				}
				
				if (structure2 == null){
					return;
				}
				
//				System.out.println("structure1 = " + structure1 + ", structure2 = " + structure2);
				
				if (structure1 == structure2){
					structureDocument.parent.displayErrorMessage("You may merge only two different structures, not the same one.");
					return;
				}
				
				//now do the whole structure merging part. use the code from fragment attachment, but without the bonding
				//and coordinate transformation
				StructureMap map1 = structure1.getStructureMap();
				StructureMap map2 = structure2.getStructureMap();
				
				StructureStyles styles1 = map1.getStructureStyles();
				StructureStyles styles2 = map2.getStructureStyles();
				
				//take care of the data structures
				
				Hashtable structureHash1 = (Hashtable)objectHash.get(structure1);
				Hashtable structureHash2 = (Hashtable)objectHash.get(structure2);
				
				Vector rvector1 = (Vector)renderables.get(structure1);
				Vector rvector2 = (Vector)renderables.get(structure2);
				
				//combine the two structures using the first one as the parent
				map1.addStructure(map2);
				
//				System.out.println("after: map1 = " + map1.getAtomCount());
				styles1.addStyles(styles2);
				
				//combine the renderables
				
				structureHash1.putAll(structureHash2);
				objectHash.remove(structure2);
				
				
				//traverse the structureHash and set all renderables to dirty (just in case some of them 
				//are hidden and will not appear on the renderables list to be updated
				Collection rrr = structureHash1.values();
				Iterator t = rrr.iterator();
				while (t.hasNext()){
					MbtRenderable m = (MbtRenderable)t.next();
					m.structureStyles = styles1;
					m.setDirty();
				}
				
				rvector1.addAll(rvector2);
				
				//get rid of the traces of structure2 and its Entry object
				
				//get the entry and remove it from structureDocument
				Set k = structures.keySet();
				Iterator ii = k.iterator();
				Entry doomed = null;
				while (ii.hasNext()){
					StructureEntry ee = (StructureEntry)ii.next();
					Structure ss = (Structure)structures.get(ee);
					if (ss == structure2){
						doomed = ee;
						break;
					}
				}
				
				structureDocument.removeEntry(doomed);
				structureDocument.parent.removeCloseListener(doomed);
				
				//use the supplied name to rename the resulting entry
				if (name != null){
					renameStructure(structure1, name);
				}
				
				updateAppearance();
				
				structureDocument.reloadContent();
				
			}
			
		}
		else if (source instanceof ColorDialog){
			
			//the event was sent by ColorDialog
			String label = ((ColorEvent)event).componentId;
			
			int setFlag = ((ColorEvent)event).setFlag;
			int colorType = ((ColorEvent)event).colorType;
//			Atom atom = (Atom)((ColorEvent)event).structureComponent;
			
			AtomColor atomColor = null;
			ResidueColor residueColor = null;
			RibbonColor ribbonColor = null;//for common coloring
			
			if (colorType == ColorDialog.COLOR_CUSTOM){
				Color structureColor = ((ColorEvent)event).structureColor;
				atomColor = AtomColorFactory.getAtomColor(structureColor);
				residueColor = ResidueColorFactory.getResidueColor(structureColor);
				ribbonColor = RibbonColorFactory.getRibbonColor(structureColor);
			}
			else if (colorType == ColorDialog.COLOR_BY_CHAIN){//applies only to the entire structure, selections are ignored
				
				
				Structure structure = null;
				try{
					structure = ((ColorEvent)event).structureComponent.structure;
				}
				catch (Exception ex){}
				
				if (structure == null){
					try{
						structure = ((StructureComponent)(labelToObject(label))).structure;
					}
					catch (ClassCastException ex){
						structure = (Structure)(labelToObject(label));
					}
				}
				
				if (structure == null){
					return;
				}
				
				StructureMap map = structure.getStructureMap();

				int counter = 0;
				residueColor = ResidueColorFactory.getResidueColor(StylesPreferences.chainColors[counter]);
				ribbonColor = RibbonColorFactory.getRibbonColor(StylesPreferences.chainColors[counter]);
				
				String lastChain = null;
				for (int j = 0; j < map.getResidueCount(); j++){
					Residue r = map.getResidue(j);
					String chain = r.getChainId();
					if (chain.equals(lastChain)){
						//simply apply the current color
						map.getStructureStyles().setResidueColor(r, residueColor, true, true);
						if (StylesPreferences.commonRibbonColoring){
							map.getStructureStyles().setRibbonColor(r, ribbonColor, false, true);
						}
					}
					else{
						if (lastChain == null){
							map.getStructureStyles().setResidueColor(r, residueColor, true, true);
							if (StylesPreferences.commonRibbonColoring){
								map.getStructureStyles().setRibbonColor(r, ribbonColor, false, true);
							}
							lastChain = r.getChainId();
						}
						else{
							//chain has switched
							lastChain = r.getChainId();
							counter++;
							if (counter >= StylesPreferences.chainColors.length) counter = 0;
							residueColor = ResidueColorFactory.getResidueColor(StylesPreferences.chainColors[counter]);
							ribbonColor = RibbonColorFactory.getRibbonColor(StylesPreferences.chainColors[counter]);
							map.getStructureStyles().setResidueColor(r, residueColor, true, true);
							if (StylesPreferences.commonRibbonColoring){
								map.getStructureStyles().setRibbonColor(r, ribbonColor, true, true);
							}
						}
					}
				}
				
				for (int i = 0; i < map.getChainCount(); i++){
					map.getStructureStyles().updateChain(map.getChain(i), true);
				}
				
				structureDocument.parent.updateView();
				return;
				
			}
			else if (colorType == ColorDialog.COLOR_BY_CHARGE){
				atomColor = AtomColorByCharge.create();
				residueColor = ResidueColorByCharge.create();
				ribbonColor = RibbonColorDefault.create();
			}
			else {
				//color by element
				atomColor = AtomColorByElement.create();
				residueColor = ResidueColorByElement.create();
				ribbonColor = RibbonColorDefault.create();
			}
							
			if (setFlag != DialogConstants.APPLY_SELECTION){
				if (((ColorEvent)event).structureComponent == null && label.equals("")){
					return;
				}
			}
			
			Hashtable structureHash = null;
			Structure structure = null;
			StructureMap structureMap = null;
			
			if (atomSetNames.contains(label)){
				//a set has been selected
				Vector chains = new Vector();
				
				Vector atomSet = (Vector)atomSets.get(label);
				for (int i = 0; i < atomSet.size(); i++){
					try{
						Residue r = (Residue)atomSet.get(i);
						r.structure.getStructureMap().getStructureStyles().setSelected(r, false, false, true);
						r.structure.getStructureMap().getStructureStyles().setResidueColor(r, residueColor, true, true);
						if (StylesPreferences.commonRibbonColoring){
							r.structure.getStructureMap().getStructureStyles().setRibbonColor(r, ribbonColor, true, true);
							if (!chains.contains(r.structure.getStructureMap().getChain(r.getAtom(0)))) chains.add(r.structure.getStructureMap().getChain(r.getAtom(0)));
						}
					}
					catch (ClassCastException e){
						Atom a = (Atom)atomSet.get(i);
						a.structure.getStructureMap().getStructureStyles().setSelected(a, false, false, true);
						a.structure.getStructureMap().getStructureStyles().setAtomColor(a, atomColor, true, true);
					}
				}
				
				for (int i = 0; i < chains.size(); i++){
					Chain c = (Chain)chains.get(i);
					c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
				}
				
				structureDocument.parent.updateView();

				return;
			}
			
			if (setFlag == DialogConstants.APPLY_ATOM){
				
				//get atom object out of the label
				Atom atom = null;
				try{
					atom = (Atom)((ColorEvent)event).structureComponent;
				}
				catch (ClassCastException ex){
					//it's a residue, so skip the whole thing
					return;
				}
				catch (NullPointerException x){}
				
				if (atom == null){
					atom = (Atom)(labelToObject(label));
				}
				
				if (atom == null){
					return;
				}
				
				atom.structure.getStructureMap().getStructureStyles().setSelected(atom, false, false, false);
				atom.structure.getStructureMap().getStructureStyles().setAtomColor(atom, atomColor, true, false);
				
			}
			else if (setFlag == DialogConstants.APPLY_RESIDUE){
				
				Residue residue = null;
				
				try{
					Atom a = (Atom)((ColorEvent)event).structureComponent;
					residue = a.residue;
				}
				catch (ClassCastException ex){
					residue = (Residue)((ColorEvent)event).structureComponent;
				}
				catch (NullPointerException e){}
				
				if (residue == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				
				if (residue == null) return;
					
				structure = residue.structure;
				structureMap = residue.structure.getStructureMap();
				if (structureHash == null){
					structureHash = (Hashtable)objectHash.get(residue.structure);
				}
				
				StructureStyles structureStyles = structureMap.getStructureStyles();
				
				structureStyles.setSelected(residue, false, false, false);
				
				//take care of the styles
				structureStyles.setResidueColor(residue, residueColor, true, false);
				if (StylesPreferences.commonRibbonColoring){
					structureStyles.setRibbonColor(residue, ribbonColor, true, false);
				}
			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				
				Chain chain = null;
				if (((ColorEvent)event).structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
					chain = (Chain)((ColorEvent)event).structureComponent;
				}
				else{
					try{
						Atom a = (Atom)((ColorEvent)event).structureComponent;
						chain = a.structure.getStructureMap().getChain(a);
					}
					catch (ClassCastException ex){
						Residue residue = (Residue)((ColorEvent)event).structureComponent;
						chain = residue.structure.getStructureMap().getChain(residue.getAtom(0));
					}
					catch (NullPointerException e){}
				}

				if (chain == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
						int index2 = newLabel.lastIndexOf(":");
						chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						chain = (Chain)(labelToObject(label));
					}
				}
				
				if (chain == null) return;
					
				structure = chain.structure;
				structureMap = chain.structure.getStructureMap();
				if (structureHash == null){
					structureHash = (Hashtable)objectHash.get(chain.structure);
				}
				
				StructureStyles structureStyles = structureMap.getStructureStyles();
				
				structureStyles.setSelected(chain, false, false, true);
				
				//take care of the styles
				structureStyles.setResidueColor(chain, residueColor, true, true);
				if (StylesPreferences.commonRibbonColoring){
					for (int i = 0; i < chain.getResidueCount(); i++){
						structureStyles.setRibbonColor(chain.getResidue(i), ribbonColor, false, true);
					}
					
					Hashtable hash = (Hashtable)objectHash.get(structure);
					if (hash.containsKey(chain)){
						((MbtRenderable)hash.get(chain)).setDirty();
					}
				}
				structureDocument.parent.updateView();
			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				
				try{
					Atom a = (Atom)((ColorEvent)event).structureComponent;
					structure = a.structure;
				}
				catch (ClassCastException ex){
					Residue residue = (Residue)((ColorEvent)event).structureComponent;
					structure = residue.structure;
				}
				catch (NullPointerException e){}

				if (structure == null){
					
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
								
				if (structure == null){
					return;
				}
				
				StructureMap map = structure.getStructureMap();
				
				map.getStructureStyles().setStructureColor(residueColor, atomColor);
				map.getStructureStyles().selectNone(true, false);
				
				if (StylesPreferences.commonRibbonColoring){
					for (int i = 0; i < map.getResidueCount(); i++){
						map.getStructureStyles().setRibbonColor(map.getResidue(i), ribbonColor, false, true);
					}
					
					Hashtable hash = (Hashtable)objectHash.get(structure);
					for (int i = 0; i < map.getChainCount(); i++){
						Chain c = map.getChain(i);
						if (hash.containsKey(c)){
							((MbtRenderable)hash.get(c)).setDirty();
						}
					}
				}
				
				
				structureDocument.parent.updateView();
			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				Vector chains = new Vector();//to keep track of ribbons to be updated
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure ss = (Structure)s.get(i);
					StructureMap map = ss.getStructureMap();
					StructureStyles styles = map.getStructureStyles();
					
					Hashtable hash = (Hashtable)objectHash.get(ss);
					
					//quick check: whether the entire structure is selected
					if (styles.getSelectionFlag() == StructureStyles.FLAG_ALL){
						styles.selectNone(false, false);
						styles.setStructureColor(residueColor, atomColor);
					}
					else{
						Enumeration selectedItems = styles.getSelection().keys();
//						System.out.println("size = " + selectedItems.size());
						Residue ancor = null;//to later force sequence viewer to repaint
						while (selectedItems.hasMoreElements()){
							try{
								Object item = selectedItems.nextElement();
								if (item instanceof Residue){
									styles.setSelected((Residue)item, false, false, true);
									styles.setResidueColor((Residue)item, residueColor, true, true);
									if (StylesPreferences.commonRibbonColoring){
										styles.setRibbonColor((Residue)item, ribbonColor, false, true);
										if (!chains.contains(map.getChain(((Residue)item).getAtom(0)))) chains.add(map.getChain(((Residue)item).getAtom(0)));
									}
									else{
										//if a ribbon is displayed, update it anyway to reflect the change in selection status
										if (hash.containsKey(map.getChain(((Residue)item).getAtom(0)))){
											if (!chains.contains(map.getChain(((Residue)item).getAtom(0)))) chains.add(map.getChain(((Residue)item).getAtom(0)));
										}
									}
								}
							}
							catch (Exception e){
								e.printStackTrace();
							}
						}

						//look for any remaining selected atoms
						selectedItems = styles.getSelection().keys();
//						System.out.println("remaining size = " + selectedItems.size());
						
						while (selectedItems.hasMoreElements()){
							try{
								Object item = selectedItems.nextElement();
								if (item instanceof Atom){
									styles.setSelected((Atom)item, false, false, true);
									styles.setAtomColor((Atom)item, atomColor, true, true);
								}
							}
							catch (Exception e){
								System.out.println("Exception in selection coloring");
								e.printStackTrace();
							}
						}
					}
				}
				
				if (chains.size() > 0){
					for (int i = 0; i < chains.size(); i++){
						Chain c = (Chain)chains.get(i);
						c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
					}
				}
				
				structureDocument.parent.updateView();
			}

		}
		else if (source instanceof RibbonColorDialog){

			//the event was sent by ColorDialog
			String label = ((RibbonColorEvent)event).componentId;
			
			int setFlag = ((RibbonColorEvent)event).setFlag;
			int colorType = ((RibbonColorEvent)event).colorType;
			
			//in case the click was in the ribbon itself, handle the cast difference and get the correct residue out of it
			
//			System.out.println("ribbon color");
			StructureComponent structureComponent = ((RibbonColorEvent)event).structureComponent;
			
			RibbonColor ribbonColor = null;
			ResidueColor residueColor = null;//in case common coloring is requested
			
			if (colorType == RibbonColorDialog.COLOR_CUSTOM){
				Color structureColor = ((RibbonColorEvent)event).ribbonColor;
				ribbonColor = RibbonColorFactory.getRibbonColor(structureColor);
				residueColor = ResidueColorFactory.getResidueColor(structureColor);
			}
			else if (colorType == RibbonColorDialog.COLOR_BY_CHAIN){
				
				Structure structure = null;
				try{
					structure = ((RibbonColorEvent)event).structureComponent.structure;
				}
				catch (NullPointerException ex){}
				
				if (structure == null){
					try{
						structure = ((StructureComponent)(labelToObject(label))).structure;
					}
					catch (ClassCastException ex){
						structure = (Structure)(labelToObject(label));
					}
				}
				
				if (structure == null){
					return;
				}
				
				StructureMap map = structure.getStructureMap();

				int counter = 0;
				residueColor = ResidueColorFactory.getResidueColor(StylesPreferences.chainColors[counter]);
				ribbonColor = RibbonColorFactory.getRibbonColor(StylesPreferences.chainColors[counter]);
				
				String lastChain = null;
				for (int j = 0; j < map.getResidueCount(); j++){
					Residue r = map.getResidue(j);
					String chain = r.getChainId();
					if (chain.equals(lastChain)){
						//simply apply the current color
						map.getStructureStyles().setRibbonColor(r, residueColor, false, true);
						if (StylesPreferences.commonRibbonColoring){
							map.getStructureStyles().setResidueColor(r, residueColor, true, true);
						}
					}
					else{
						if (lastChain == null){
							map.getStructureStyles().setRibbonColor(r, ribbonColor, false, true);
							if (StylesPreferences.commonRibbonColoring){
								map.getStructureStyles().setResidueColor(r, residueColor, true, true);
							}
							lastChain = r.getChainId();
						}
						else{
							//chain has switched
							lastChain = r.getChainId();
							counter++;
							if (counter >= StylesPreferences.chainColors.length) counter = 0;
							residueColor = ResidueColorFactory.getResidueColor(StylesPreferences.chainColors[counter]);
							ribbonColor = RibbonColorFactory.getRibbonColor(StylesPreferences.chainColors[counter]);
							map.getStructureStyles().setRibbonColor(r, ribbonColor, false, true);
							if (StylesPreferences.commonRibbonColoring){
								map.getStructureStyles().setResidueColor(r, residueColor, true, true);
							}
						}
					}
				}
				
				for (int i = 0; i < map.getChainCount(); i++){
					map.getStructureStyles().updateChain(map.getChain(i), true);
				}
				
				structureDocument.parent.updateView();
				return;
			}
			else{
				//color by default
				ribbonColor = RibbonColorDefault.create();
				residueColor = ResidueColorByElement.create();
			}
							
			if (setFlag != DialogConstants.APPLY_SELECTION && setFlag != DialogConstants.APPLY_VISIBLE){
				if ( structureComponent == null && label.equals("")){
					return;
				}
			}
			
			Hashtable structureHash = null;
			Structure structure = null;
			StructureMap structureMap = null;
			
			Vector chains = new Vector();
			
			if (setFlag == DialogConstants.APPLY_RESIDUE){
				
				Residue residue = null;
				try{
					residue = (Residue)((RibbonColorEvent)event).structureComponent;
				}
				catch (ClassCastException ex){
					//must have been an atom
					Atom a = (Atom)((RibbonColorEvent)event).structureComponent;
					residue = a.residue;
				}
				catch (NullPointerException e){}//just check later for the label
				
				if (residue == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				
				if (residue == null) return;
					
				structure = residue.structure;
				structureMap = residue.structure.getStructureMap();
				if (structureHash == null){
					structureHash = (Hashtable)objectHash.get(residue.structure);
				}
				
				StructureStyles structureStyles = structureMap.getStructureStyles();
				
				if (StylesPreferences.commonRibbonColoring){
					structureStyles.setSelected(residue, false, false, false);
					structureStyles.setResidueColor(residue, residueColor, true, false);
				}
				else{
					structureStyles.setSelected(residue, false, true, false);
				}
				
				//take care of the styles
				structureStyles.setRibbonColor(residue, ribbonColor, true, false);
			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				
				Chain chain = null;
				if (((RibbonColorEvent)event).structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
					chain = (Chain)((RibbonColorEvent)event).structureComponent;
				}
				else{
					try{
						Residue r = (Residue)((RibbonColorEvent)event).structureComponent;
						chain = r.structure.getStructureMap().getChain(r.getAtom(0));
					}
					catch (ClassCastException ex){
						//must have been an atom
						Atom a = (Atom)((RibbonColorEvent)event).structureComponent;
						chain = a.structure.getStructureMap().getChain(a);
					}
					catch (NullPointerException e){}
				}
				
				if (chain == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
						int index2 = newLabel.lastIndexOf(":");
						chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						chain = (Chain)(labelToObject(label));
					}
				}
				
				if (chain == null) return;
				
				structure = chain.structure;
				structureMap = chain.structure.getStructureMap();
				if (structureHash == null){
					structureHash = (Hashtable)objectHash.get(chain.structure);
				}
				
				StructureStyles structureStyles = structureMap.getStructureStyles();
				
				if (StylesPreferences.commonRibbonColoring){
					structureStyles.setSelected(chain, false, false, true);
				}
				else{
					structureStyles.setSelected(chain, false, true, true);
				}
				
				//take care of the styles
				for (int i = 0; i < chain.getResidueCount(); i++){
					Residue r = chain.getResidue(i);
					structureStyles.setRibbonColor(r, ribbonColor, false, true);
					if (StylesPreferences.commonRibbonColoring){
						structureStyles.setResidueColor(r, residueColor, true, true);
					}
				}
				
				structureStyles.updateChain(chain, true);
				
				structureDocument.parent.updateView();
			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				
				
				try{
					structure = ((RibbonColorEvent)event).structureComponent.structure;
				}
				catch (NullPointerException e){}
				
				if (structure == null){
					
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return;
					}
				}
				
				if (structure == null){
					return;
				}
				
				StructureStyles styles = structure.getStructureMap().getStructureStyles();
				styles.selectNone(true, false);
				for (int i = 0; i < structure.getStructureMap().getResidueCount(); i++){
					Residue r = structure.getStructureMap().getResidue(i);
					styles.setRibbonColor(r, ribbonColor, false, true);
					if (StylesPreferences.commonRibbonColoring){
						styles.setResidueColor(r, residueColor, true, true);
					}
					
				}
				
				updateAppearance();
			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure ss = (Structure)s.get(i);
					StructureMap map = ss.getStructureMap();
					StructureStyles styles = map.getStructureStyles();
					
					//quick check: whether the entire structure is selected
					if (styles.getSelectionFlag() == StructureStyles.FLAG_ALL){
						styles.selectNone(false, false);
						for (int j = 0; j < structure.getStructureMap().getResidueCount(); j++){
							Residue r = structure.getStructureMap().getResidue(j);
							styles.setRibbonColor(r, ribbonColor, true, true);
						}
					}
					else{
						Enumeration selectedItems = styles.getSelection().keys();
						while (selectedItems.hasMoreElements()){
							try{
								Object item = selectedItems.nextElement();
								if (item instanceof Residue){
									if (StylesPreferences.commonRibbonColoring){
										styles.setSelected((Residue)item, false, false, true);
										styles.setResidueColor((Residue)item, residueColor, true, true);
									}
									else{
										styles.setSelected((Residue)item, false, true, true);
									}
									styles.setRibbonColor((Residue)item, ribbonColor, true, true);
								}
							}
							catch (Exception e){
								e.printStackTrace();
							}
						}

						//look for any remaining selected atoms
						selectedItems = styles.getSelection().keys();
//						System.out.println("remaining size = " + selectedItems.size());
						
						while (selectedItems.hasMoreElements()){
							try{
								Object item = selectedItems.nextElement();
								if (item instanceof Atom){
									if (StylesPreferences.commonRibbonColoring){
										styles.setSelected(((Atom)item).residue, false, false, true);
										styles.setResidueColor(((Atom)item).residue, residueColor, true, true);
									}
									else{
										styles.setSelected((Atom)item, false, true, true);
									}
									styles.setRibbonColor(((Atom)item).residue, ribbonColor, true, true);
								}
							}
							catch (Exception e){
								System.out.println("Exception in selection coloring");
								e.printStackTrace();
							}
						}
					}
				}
				
				structureDocument.parent.updateView();
			}
			else if (setFlag == DialogConstants.APPLY_VISIBLE){
				
				//get the affected chains
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure ss = (Structure)s.get(i);
					StructureMap map = ss.getStructureMap();
					StructureStyles styles = map.getStructureStyles();
					
//					Vector selection = new Vector();//chains
					
					for (int j = 0; j < map.getChainCount(); j++){
						Chain ch = map.getChain(j);
						
						for (int m = 0; m < ch.getResidueCount(); m++){
							Residue res = ch.getResidue(m);
							if (res.ribbon){
//									if (!selection.contains(ch)) selection.add(ch);
								if (StylesPreferences.commonRibbonColoring){
									styles.setSelected(res, false, false, true);
									styles.setResidueColor(res, residueColor, true, true);
								}
								else{
									styles.setSelected(res, false, true, true);
								}
								styles.setRibbonColor(res, ribbonColor, true, true);
							}

						}
						
					}

				}	
				
				structureDocument.parent.updateView();
			}

		
		}
		else if (source instanceof DistanceDialog){
			
			try{
		
				Vector atoms = ((GeometryEvent)event).atoms;
				Atom atom1 = (Atom)atoms.get(0);
				Atom atom2 = (Atom)atoms.get(1);
				
				if ((atom1 == null)||(atom2 == null)){
					
					Vector labels = ((GeometryEvent)event).atomLabels;
					if (labels == null || labels.get(0) == null || labels.get(1) == null){
						structureDocument.parent.displayErrorMessage("Specified atom(s) not found");
						return;
					}
					
					//get the label and atoms out of them
					atom1 = (Atom)labelToObject((String)labels.elementAt(0));
					atom2 = (Atom)labelToObject((String)labels.elementAt(1));
					
					if (atom1 == null || atom2 == null){
						structureDocument.parent.displayErrorMessage("Specified atom(s) not found");
						return;
					}
				}

				computeDistance(atom1, atom2);
				
				
			
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception measuring interatomic distance", ex);
			}
			
		}
		else if (source instanceof AngleDialog){
			
			try{
			
				Vector inputAtoms = ((GeometryEvent)event).atoms;
				Vector labels = ((GeometryEvent)event).atomLabels;
				
				//store atoms and bonds in Vectors
				
				Vector atoms = new Vector();
				for (int i = 0; i < inputAtoms.size(); i++){
					if (inputAtoms.get(i) != null){
						atoms.add(inputAtoms.get(i));
					}
					else{
						atoms.add(labelToObject((String)labels.get(i)));
					}
					
					if (atoms.get(i) == null){
						structureDocument.parent.displayErrorMessage("Specified atom(s) not found.");
						return;
					}
				}
				
				computeAngle(atoms);
				
				
			
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception measuring bond angle", ex);
			}
		}	
		else if (source instanceof DihedralDialog){
			
			try{
			
			Vector inputAtoms = ((GeometryEvent)event).atoms;
			Vector labels = ((GeometryEvent)event).atomLabels;
			
			//store atoms and bonds in Vectors
			Vector atoms = new Vector();
			
			//check whether there are four unique atoms
			HashMap uAtoms = new HashMap();
			Vector bonds = new Vector();//Vector of Vectors
			for (int i = 0; i < inputAtoms.size(); i++){
				if (inputAtoms.get(i) != null){
					atoms.add(inputAtoms.get(i));
					uAtoms.put(inputAtoms.get(i), "");
				}
				else{
					atoms.add(labelToObject((String)labels.get(i)));
					uAtoms.put(labelToObject((String)labels.elementAt(i)), "");
				}
				if (atoms.elementAt(i) == null){
					structureDocument.parent.displayErrorMessage("Specified atom(s) not found.");
					return;
				}
				
				
				//get the bonds
				bonds.add(((Atom)atoms.elementAt(i)).structure.getStructureMap().getBonds((Atom)atoms.elementAt(i)));
			}
			
			if (uAtoms.size() < 4){
				structureDocument.parent.displayErrorMessage("Dihedral angle calculation requires 4 unique atoms.");
				return;
			}
			
			//search for the two central and two peripheral atoms
			//search one by one and choose as central the atom with two bonds common to the entire set
			Vector central = new Vector();//the two central atoms
			Vector others = new Vector();//the two peripheral atoms
			for (int i = 0; i < atoms.size(); i++){
				int counter = 0;
				for (int j = 0; j < ((Vector)bonds.elementAt(i)).size(); j++){
					Bond b = (Bond)((Vector)bonds.elementAt(i)).elementAt(j);
					//now iterate over the other Bond Vectors
					for (int k = 0; k < bonds.size(); k++){
						if (i != k){//don't count itself
							if (((Vector)bonds.elementAt(k)).contains(b)){
								counter++;
							}
						}
					}
				}
				if (counter == 2){
					central.add(atoms.elementAt(i));
				}
				else{
					others.add(atoms.elementAt(i));
				}
			}		
			
			//if the three atoms are not immediately adjacent, bail out
			if ((central.size() < 2)||(others.size() < 2)){
				structureDocument.parent.displayErrorMessage("Invalid set of atoms for bond angle measurement.");
				return;
			}
				
			//now trace the sequence of atoms by starting from one of the peripheral atoms
			Vector out = new Vector();//contains the sequence to be used for the method call
			out.add(others.elementAt(0));
			
			//get list of bonds associated with this atom
			Vector b0 = ((Atom)others.elementAt(0)).structure.getStructureMap().getBonds((Atom)others.elementAt(0));
			
			//now find out which central atom is bonded to this one
			for (int i = 0; i < b0.size(); i++){
			
				Bond b = (Bond)b0.elementAt(i);
				
				Atom aa1 = b.getAtom(0);
				Atom aa2 = b.getAtom(1);
				
				if (central.contains(aa1)){
					out.add(aa1);
					central.remove(aa1);
					out.add(central.elementAt(0));
					out.add(others.elementAt(1));
					break;
				}
				if (central.contains(aa2)){
					out.add(aa2);
					central.remove(aa2);
					out.add(central.elementAt(0));
					out.add(others.elementAt(1));
					break;
				}
			}

			double angle = Algebra.dihedralAngle(((Atom)out.elementAt(0)).coordinate, ((Atom)out.elementAt(1)).coordinate, 
					((Atom)out.elementAt(2)).coordinate,((Atom)out.elementAt(3)).coordinate);

			String res = (new Double(angle)).toString();
			int index = res.indexOf(".");
			String result = null;
			try{
				result = res.substring(0, index+3);//two decimal places after the dot
			}
			catch (Exception ex){
				//if it has only one digit after the dot to begin with
				result = res.substring(0, index+2);
			}
//			System.out.println("Dihedral angle = " + result);
			structureDocument.parent.displayMessage("Dihedral angle = " + result + " degrees.");
			
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception measuring dihedral angle", ex);
			}
		}
		else if (source instanceof HybridizationDialog){
			short h = ((GeometryEvent)event).hybridization;
			Vector atoms = ((GeometryEvent)event).atoms;
			
			Atom atom = (Atom)atoms.get(0);
			
			if (atom == null){
				//check the entered text, maybe the user typed the atom names
				Vector labels = ((GeometryEvent)event).atomLabels;
				if (labels == null || labels.get(0) == null){
					structureDocument.parent.displayErrorMessage("Specified atom not found");
					return;
				}
								
				//get the label and atoms out of them
				atom = (Atom)labelToObject((String)labels.elementAt(0));
				
				if (atom == null){
					structureDocument.parent.displayErrorMessage("Specified atom not found");
					return;
				}
			}
			
			//remove any hydrogens and re-add them to this atom
			StructureMap map = atom.structure.getStructureMap();
			Vector aa = map.getAtoms(atom);
			for (int i = aa.size()-1; i >= 0; i--){
				Atom aaa = (Atom)aa.get(i);
				if (aaa.element == 1){
					//delete it
					map.getStructureStyles().deleteStructureComponent(aaa, true, true);
				}
			}
			
			atom.hybridization = h;
			StructureMath.checkHydrogens(atom, this, 7.0f, false);
			updateAppearance();

		}
		else if (source instanceof BondOrderDialog){
			float order = ((GeometryEvent)event).bondOrder;
			
			Vector atoms = ((GeometryEvent)event).atoms;
			
			Atom atom1 = (Atom)atoms.get(0);
			Atom atom2 = (Atom)atoms.get(1);
			
			if ((atom1 == null)||(atom2 == null)){
				//check the entered text, maybe the user typed the atom names
				Vector labels = ((GeometryEvent)event).atomLabels;
				if (labels == null || labels.get(0) == null || labels.get(1) == null){
					structureDocument.parent.displayErrorMessage("Specified atom(s) not found");
					return;
				}
								
				//get the label and atoms out of them
				atom1 = (Atom)labelToObject((String)labels.elementAt(0));
				atom2 = (Atom)labelToObject((String)labels.elementAt(1));
				
				if (atom1 == null || atom2 == null){
					structureDocument.parent.displayErrorMessage("Specified atom(s) not found");
					return;
				}
			}
			
			Bond bond = null;
			try{
				//now determine which bond to change
				Vector bondList = atom1.structure.getStructureMap().getBonds(atom1);
				for (int i = 0; i < bondList.size(); i++){
					Bond b = (Bond)bondList.get(i);
					if (b.getAtom(0) == atom1){
						if (b.getAtom(1) == atom2){
							bond = b;
							break;
						}
					}
					else if (b.getAtom(0) == atom2){
						if (b.getAtom(1) == atom1){
							bond = b;
							break;
						}
						
					}
				}
				if (bond == null){
					structureDocument.parent.displayErrorMessage("Specified bond could not be found");
					return;
				}
				
				bond.setOrder(order);
				
	//			System.out.println(atom1.name + ":" + atom1.hybridization + ", " + atom2.name + ": " + atom2.hybridization);
				
				StructureMath.checkHydrogens(atom1, this, 7.0f, false);
				StructureMath.checkHydrogens(atom2, this, 7.0f, false);
			
			}
			catch (Exception ee){
				ee.printStackTrace();
			}
			Hashtable structureHash = (Hashtable)objectHash.get(atom1.structure);
			GlRenderable r = (GlRenderable)structureHash.get(bond);
			if (r == null) return;
			
			r.setDirty();
			
			bond.structure.getStructureMap().bondOrderUserAssigned = true;
			updateAppearance();
		}
		else if (source instanceof CreateBondDialog){
			try{
				
				Vector atoms = ((StructureEvent)event).atoms;
				
				Atom atom1 = (Atom)atoms.get(0);
				Atom atom2 = (Atom)atoms.get(1);
				
				if ((atom1 == null)||(atom2 == null)){
					
					Vector labels = ((StructureEvent)event).atomLabels;
					if (labels == null || labels.get(0) == null || labels.get(1) == null){
						structureDocument.parent.displayErrorMessage("Specified atom(s) not found");
						return;
					}
					
					//get the label and atoms out of them
					atom1 = (Atom)labelToObject((String)labels.elementAt(0));
					atom2 = (Atom)labelToObject((String)labels.elementAt(1));
					
					if (atom1 == null || atom2 == null){
						structureDocument.parent.displayErrorMessage("Specified atom(s) not found");
						return;
					}
				}
				
				//pass the atoms to the handler
				//atom1 is in the structure that retains its coordinates
				if (atom1.structure == atom2.structure){
					//it's a bond within the same structure
					
					//check whether one or both atoms are hydrogens. If so, create a bond between the parent atoms and delete the
					//hydrogen(s)
					Atom temp1 = null;
					
					if (atom1.element == 1){
						Vector aaa = atom1.structure.getStructureMap().getAtoms(atom1);
						if (aaa.size() == 0){
							return;
						}
						temp1 = (Atom)aaa.get(0);
						atom1.structure.getStructureMap().getStructureStyles().deleteStructureComponent(atom1, true, true);
					
					}
					Atom temp2 = null;
					if (atom2.element == 1){
						Vector bbb = atom2.structure.getStructureMap().getAtoms(atom2);
						if (bbb.size() == 0){
							return;
						}
						temp2 = (Atom)bbb.get(0);
						atom2.structure.getStructureMap().getStructureStyles().deleteStructureComponent(atom2, true, true);
					
					}
					
					if (temp1 != null) atom1 = temp1;
					if (temp2 != null) atom2 = temp2;
					
					Bond b = new Bond(atom1, atom2);
					atom1.structure.getStructureMap().addBond(b);

					MbtRenderable renderable = new MbtRenderable(b, atom1.structure.getStructureMap().getStructureStyles(), new BondGeometry());

					Hashtable structureHash = (Hashtable)objectHash.get(atom1.structure);
					structureHash.put(b, renderable);
					renderablesList.add(renderable);
					Vector rvector = (Vector)renderables.get(atom1.structure);
					rvector.add(renderable);

					atom1.structure.getStructureMap().getStructureStyles().addStructureComponent(b, (short)-1, (short)-1, true);

					
					if (dummyAtoms.contains(atom1)){
						if (independentSet.contains(atom1)){
							independentGroup.removeChild((GlRenderable)structureHash.get(atom1));
						}
						else{
							Vector rrr = (Vector)renderables.get(atom1.structure);
							rrr.remove(structureHash.get(atom1));
							renderablesList.remove(structureHash.get(atom1));
						}
						
						dummyAtoms.remove(atom1);
						hiddenComponents.remove(atom1);
						structureHash.remove(atom1);
					}
					
					if (dummyAtoms.contains(atom2)){
						if (independentSet.contains(atom2)){
							independentGroup.removeChild((GlRenderable)structureHash.get(atom2));
						}
						else{
							Vector rrr = (Vector)renderables.get(atom2.structure);
							rrr.remove(structureHash.get(atom2));
							renderablesList.remove(structureHash.get(atom2));
						}
						
						dummyAtoms.remove(atom2);
						hiddenComponents.remove(atom2);
						structureHash.remove(atom2);
					}
					

					geometryViewer.setRenderables(renderablesList);
					geometryViewer.updateView();
				}
				else{
					//two structures are being combined (the fun part :)
					
					//atom1 - parent structure
					//atom2 - fragment
					
					//transform coordinates
					if (atom1.element != 1 || atom2.element != 1){
						structureDocument.parent.displayErrorMessage("Structures can be connected only through hydrogens");
						return;
					}
					
					//get the main vectors
					//since each atom is a hydrogen, it can have only one bond
					Bond b1 = (Bond)(atom1.structure.getStructureMap().getBonds(atom1)).get(0);
					Bond b2 = (Bond)(atom2.structure.getStructureMap().getBonds(atom2)).get(0);
					
					StructureMap map1 = atom1.structure.getStructureMap();
					StructureMap map2 = atom2.structure.getStructureMap();
					
					
					Structure structure1 = atom1.structure;
					Structure structure2 = atom2.structure;

					//atoms next to the hydrogens
					Atom atom11 = (Atom)(map1.getAtoms(atom1)).get(0);
					Atom atom21 = (Atom)(map2.getAtoms(atom2)).get(0);
					
					//determine the correct bond distance for the two neighboring atoms
					/**
					 * TODO include an external bond length dictionary to reference by bond type
					 * perhaps organize it as a matrix, with symbols on either side of the table 
					 * denoting elements and reading the corresponding value in the crossing
					 * 
					 */
					double distance = ElementProperties.getBondLength(atom11.element, atom21.element);
					
//					System.out.println("distance = " + distance + " for " + atom11.element + " - " + atom21.element);
					
					Location location1 = StructureMath.getBondLocation(b1);
					//the position must be relocated to the end of the lookAt vector where the added
					//connection atom will be, at the appropriate bond distance
					double[] p = StructureMath.getPointOnVector(location1.position, location1.lookAt, distance);
					location1.position[0] = p[0];
					location1.position[1] = p[1];
					location1.position[2] = p[2];
					
					Location location2 = StructureMath.getBondLocation(b2);
					
					//before transforming coordinates, reverse the lookAt vector of the fragment to align
					//the structures correctly
					Algebra.reverseVector(location2.lookAt);
					
					StructureMath.transformStructure(location2, location1, atom2.structure);
				
					Residue residue1 = map1.getResidue(atom1);
					Residue residue2 = map2.getResidue(atom2);
					
					
					StructureStyles styles1 = map1.getStructureStyles();
					StructureStyles styles2 = map2.getStructureStyles();
					
					//take care of the data structures
					//remove the hydrogens and their bonds first
					//fire an event
					map1.removeBond(b1);
					styles1.deleteStructureComponent(b1, true, true);
					
					Hashtable structureHash1 = (Hashtable)objectHash.get(structure1);
					GlRenderable r1 = (GlRenderable)structureHash1.get(b1);
					
					Vector rvector1 = (Vector)renderables.get(atom1.structure);
					rvector1.remove(r1);
					structureHash1.remove(b1);
					
					//the other bond
					map2.removeBond(b2);
					styles2.deleteStructureComponent(b2, true, true);

					
					Hashtable structureHash2 = (Hashtable)objectHash.get(structure2);
					GlRenderable r2 = (GlRenderable)structureHash2.get(b2);
					
					Vector rvector2 = (Vector)renderables.get(structure2);
					rvector2.remove(r2);
					structureHash2.remove(b2);
					
					//remove the atoms
					map1.removeAtom(atom1);
					styles1.deleteStructureComponent(atom1, true, true);

					GlRenderable r3 = (GlRenderable)structureHash1.get(atom1);
					
					rvector1.remove(r3);
					structureHash1.remove(atom1);
					renderablesList.remove(r3);
					
					
					map2.removeAtom(atom2);
					styles2.deleteStructureComponent(atom2, true, true);

					GlRenderable r4 = (GlRenderable)structureHash2.get(atom2);
					
					rvector2.remove(r4);
					structureHash2.remove(atom2);
					renderablesList.remove(r4);
					
					//renumber residues in the new structure, continuing incrementally
/*					int n = 1;
					for (int i = 0; i < map1.getResidueCount(); i++){
						Residue r = map1.getResidue(i);
						map1.setResidueId(r, n);
						n++;
					}
					
					for (int i = 0; i < map2.getResidueCount(); i++){
						Residue r = map2.getResidue(i);
						map2.setResidueId(r, n);
						n++;
					}
*/					
					//combine the two structures using the first one as the parent
					map1.addStructure(map2);
					
//					System.out.println("after: map1 = " + map1.getAtomCount());
					styles1.addStyles(styles2);
					
					//combine the renderables
					
					structureHash1.putAll(structureHash2);
					objectHash.remove(structure2);
					
					
					//traverse the structureHash and set all renderables to dirty (just in case some of them 
					//are hidden and will not appear on the renderables list to be updated
					Collection rrr = structureHash1.values();
					Iterator t = rrr.iterator();
					while (t.hasNext()){
						MbtRenderable m = (MbtRenderable)t.next();
						m.structureStyles = styles1;
						m.setDirty();
					}
					
					//reassign structure styles
					rvector1.addAll(rvector2);
					
					//get rid of the traces of structure2 and its Entry object
					
					//get the entry and remove it from structureDocument
					Set k = structures.keySet();
					Iterator ii = k.iterator();
					Entry doomed = null;
					while (ii.hasNext()){
						StructureEntry ee = (StructureEntry)ii.next();
						Structure ss = (Structure)structures.get(ee);
						if (ss == structure2){
							doomed = ee;
							break;
						}
					}
					
					structureDocument.removeEntry(doomed);
					structureDocument.parent.removeCloseListener(doomed);
					
					//create the new bond
					Bond b = new Bond(atom11, atom21);
//					System.out.println("new bond = " + b);
					map1.addBond(b);

					MbtRenderable renderable = new MbtRenderable(b, styles1, new BondGeometry());

					structureHash1.put(b, renderable);
					
					//fire an event
					styles1.addStructureComponent(b, (short)-1, (short)-1, true);

					if (atom21.visible){
						rvector1.add(renderable);
					}
					else{
						hiddenComponents.put(b, renderable);
						styles1.setVisible(b, false, true, false);
					}
					
//					System.out.println("map1: " + map1.getAtomCount() + ", bonds = " + map1.getBondCount());

					updateAppearance();
					
					
					
					structureDocument.reloadContent();
				}
				
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception creating bond", ex);
			}
			
		}
		else if (source instanceof BreakBondDialog){
			try{
				
				Vector atoms = ((StructureEvent)event).atoms;
				
				
				Atom atom1 = (Atom)atoms.get(0);
				Atom atom2 = (Atom)atoms.get(1);
				
				if ((atom1 == null)||(atom2 == null)){
					
					Vector labels = ((StructureEvent)event).atomLabels;
					if (labels == null || labels.get(0) == null || labels.get(1) == null){
						structureDocument.parent.displayErrorMessage("Specified atom(s) not found");
						return;
					}
					
					//get the label and atoms out of them
					atom1 = (Atom)labelToObject((String)labels.elementAt(0));
					atom2 = (Atom)labelToObject((String)labels.elementAt(1));
					
					if (atom1 == null || atom2 == null){
						structureDocument.parent.displayErrorMessage("Specified atom(s) not found");
						return;
					}
				}
				
				//pass the atoms to the handler
				//atom1 is in the structure that retains its coordinates
				if (atom1.structure == atom2.structure){
					//it's a bond within the same structure
					Vector bonds = atom1.structure.getStructureMap().getBonds(atom1);
					Bond doomed = null;
					for (int i = 0; i < bonds.size(); i++){
						Bond b = (Bond)bonds.get(i);
						Atom a1 = b.getAtom(0);
						if (a1 == atom1){
							if (b.getAtom(1) == atom2){
								doomed = b;
								break;
							}
						}
						else if (a1 == atom2){
							if (b.getAtom(1) == atom1){
								doomed = b;
								break;
							}
						}
					}
					
//					System.out.println("breaking bond");
					atom1.structure.getStructureMap().removeBond(doomed);
					atom1.structure.getStructureMap().getStructureStyles().deleteStructureComponent(doomed, true, false);
					
					checkDummyAtoms(atom1, false);
					checkDummyAtoms(atom2, false);

					geometryViewer.updateView();
				}
				else{
					structureDocument.parent.displayErrorMessage("Only a bond within a single structure can be removed");
				}
				
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception creating bond", ex);
			}
			
		}
		else if (source instanceof RotateBondDialog){
			
			/**
			 * TODO
			 */
			try{
				
				Vector atoms = ((StructureEvent)event).atoms;
				trackBumps = ((StructureEvent)event).check;
				
				Atom atom1 = (Atom)atoms.get(0);
				Atom atom2 = (Atom)atoms.get(1);
				
				if ((atom1 == null)||(atom2 == null)){
					
					Vector labels = ((StructureEvent)event).atomLabels;
					if (labels == null || labels.get(0) == null || labels.get(1) == null){
						structureDocument.parent.displayErrorMessage("Specified atom(s) not found");
						return;
					}
					
					//get the label and atoms out of them
					atom1 = (Atom)labelToObject((String)labels.elementAt(0));
					atom2 = (Atom)labelToObject((String)labels.elementAt(1));
					
					if (atom1 == null || atom2 == null){
						structureDocument.parent.displayErrorMessage("Specified atoms not found");
						return;
					}
				}
				
				//check whether this part of the structure is being independently moved
				if (independentSet != null && (independentSet.contains(atom1) || independentSet.contains(atom2))){
					structureDocument.parent.displayErrorMessage("At this time bond rotation within a separately moved structure is not supported");
					return;
				}
				
				//create an arrow geometry around the bond
				//find out which bond it is and check its rendering style and bond radius
				//to determine a radius for the arrow
				Bond bond = null;
				
				StructureMap map = atom1.structure.getStructureMap();
				
				Vector bonds = map.getBonds(atom1);
				for (int i = 0; i < bonds.size(); i++){
					Bond b = (Bond)bonds.get(i);
					if (b.getAtom(0) == atom1 && b.getAtom(1) == atom2){
						bond = b;
						break;					
					}
					if (b.getAtom(1) == atom1 && b.getAtom(0) == atom2){
						bond = b;
						break;
					}
				}
				
				if (bond == null){
					structureDocument.parent.displayErrorMessage("Specified bond not found");
					return;
				}
				
				//check the bond order
				if (bond.order > 1){
					structureDocument.parent.displayErrorMessage("Selected bond appears to have order that restricts its rotation.");
					return;
				}
				
				Structure structure = bond.structure;
				if (!initialCoordinates.containsKey(structure)) saveInitialCoordinates(structure);
				
				double radius = 0.1;
				if (bond.render != StylesPreferences.RENDERING_LINES){
					radius = 0.22;
				}
				
				Vector localRenderables = (Vector)renderables.get(bond.structure);
				
				
				//calculate which atoms are going to be rotated and open a dialog to monitor angle
				//changes
				Vector rotated = StructureMath.getRotatedAtoms(map, bond, atom2);
				
				if (rotated == null){
					structureDocument.parent.displayErrorMessage("Selected bond appears to be in a cycle. Restricted rotation is currently not supported.");
					return;
				}
				
				//create the geometry			
				MonitorRenderable r = new MonitorRenderable(new ArrowComponent(atom1.coordinate, atom2.coordinate, radius, null),
						(AnnotationGeometry)defaultGeometry.get("ArrowGeometry"));//don't translate
				
				rotationArrow.put(atom1.structure, r);
				
//				Vector rr = (Vector)renderables.get(atom1.structure);
				renderablesList.add(r);
				
//				map.getStructureStyles().setVisible(bond, false, true);
				
				//display a dialog to monitor rotation
				
				rotationMode = true;
				geometryViewer.setRotationMode(true);
				structureDocument.parent.setDisplayDialogStatus(true);
				
				if (angleDialog == null){
					angleDialog = new AngleMonitorDialog(structureDocument.parent.getApplicationFrame(), this);
				}
				angleDialog.showDialog(true);
				rotatedAtoms = rotated;
				rotationAxisBond = bond;
				rotationRootAtom = atom2;
				
				//check if Ramachandran viewer needs to be notified of any changes
				Residue res = map.getResidue(atom1);
				if (ProteinProperties.isAminoAcid(res.getCompoundCode())){
					//also make sure that the rotation concerns the two relevant bonds
					Vector names = new Vector();
					names.add(atom1.name);
					names.add(atom2.name);
					boolean enable = false;
					if (names.contains("N") && names.contains("CA")){
						enable = true;
					}
					else if (names.contains("C") && names.contains("CA")){
						enable = true;
					}

					if (enable){
						RamachandranViewer rv = structureDocument.parent.getRamachandranViewer(atom1.structure);
						if (rv != null){
							trackGeometry = true;
							rotatedResidue = res;
						}
					}
				}
				
				//get the list of all other atoms in the display
				if (trackBumps || trackGeometry){
					
					if (trackBumps){
						globalResidues.clear();
						Vector s = this.getLoadedStructures();
						for (int i = 0; i < s.size(); i++){
							Vector aaa = ((Structure)s.get(i)).getStructureMap().getResidues();
							globalResidues.addAll(aaa);
						}
					}
					
					for (int i = 0; i < rotatedAtoms.size(); i++){
						Atom a = (Atom)rotatedAtoms.get(i);
//						System.out.println("rotated = " + a.name + ", vis = " + a.structure.getStructureMap().getStructureStyles().isVisible(a));
						transformedCoordinates.put(a, new double[]{ a.coordinate[0], a.coordinate[1], a.coordinate[2] });
						
					}
					
				}
				
				currentRotationAngle = 0;
				
				rotationAxis = new double[3];
				rotationAxis[0] = atom2.coordinate[0] - atom1.coordinate[0];
				rotationAxis[1] = atom2.coordinate[1] - atom1.coordinate[1];
				rotationAxis[2] = atom2.coordinate[2] - atom1.coordinate[2];
				
				toOrigin = StructureMath.getToOriginMatrix(rotationRootAtom);
				fromOrigin = StructureMath.getFromOriginMatrix(rotationRootAtom);
				
				//move the atom and bond renderables to the composite renderable
				rotationGroup = new TransformGroupRenderable();
//				rotationGroup.setTransform(toOrigin);
				
				Hashtable structureHash = (Hashtable)objectHash.get(atom1.structure);
				rotatedSet = new Vector();//atom and bond objects
				map = atom1.structure.getStructureMap();
				for (int i = 0; i < rotatedAtoms.size(); i++){
					Atom a = (Atom)rotatedAtoms.get(i);
					rotatedSet.add(a);
					
					if (atomToLabels.containsKey(a)){
						GlRenderable lr = (GlRenderable)labels.get(atomToLabels.get(a));
						renderablesList.remove(lr);
						localRenderables.remove(lr);
						rotationGroup.addChild(lr);
					}

					if (atomToResidueLabels.containsKey(a)){
						GlRenderable lr = (GlRenderable)labels.get(atomToResidueLabels.get(a));
						renderablesList.remove(lr);
						localRenderables.remove(lr);
						rotationGroup.addChild(lr);
					}

					Vector bb = map.getBonds(a);
					for (int j = 0; j < bb.size(); j++){
						Bond bbb = (Bond)bb.get(j);
						if (rotatedAtoms.contains(bbb.getAtom(0)) && rotatedAtoms.contains(bbb.getAtom(1))){
							if (!rotatedSet.contains(bbb)) rotatedSet.add(bbb);
						}
					}
				}
				
				//at this point, the structure components are accounted for
				
				for (int n = 0; n < rotatedSet.size(); n++){
					GlRenderable rs = (GlRenderable)structureHash.get(rotatedSet.get(n));
					if (rs != null){
						rotationGroup.addChild(rs);
						renderablesList.remove(rs);
						localRenderables.remove(rs);
					}
					
					//take care of monitors that are entirely within the set
					try{
						Atom a = (Atom)rotatedSet.get(n);
						if (atomToMonitors.containsKey(a)){
							Vector mm = (Vector)atomToMonitors.get(a);
							for (int j = 0; j < mm.size(); j++){
								MonitorComponent c = (MonitorComponent)mm.get(j);
								if (c.atom1 == a){
									if (rotatedSet.contains(c.atom2)){
										//the monitor should be added
										rotationGroup.addChild((GlRenderable)monitors.get(c));
										renderablesList.remove(monitors.get(c));
										localRenderables.remove(monitors.get(c));
									}
									else{
										/**
										 * TODO handle changing length of the distance marker
										 */
									}
								}
								else if (c.atom2 == a){
									if (rotatedSet.contains(c.atom1)){
										//the monitor should be added
										rotationGroup.addChild((GlRenderable)monitors.get(c));
										renderablesList.remove(monitors.get(c));
										localRenderables.remove(monitors.get(c));
									}
									else{
										//change of distance as the group rotates
									}
								}

							}
						}
						
						if (atomToHBonds.containsKey(a)){
							Vector mm = (Vector)atomToHBonds.get(a);
							for (int j = 0; j < mm.size(); j++){
								HydrogenBondComponent c = (HydrogenBondComponent)mm.get(j);
								if (c.atom1 == a){
									if (rotatedSet.contains(c.atom2)){
										//the monitor should be added
										rotationGroup.addChild((GlRenderable)hBonds.get(c));
										renderablesList.remove(hBonds.get(c));
										localRenderables.remove(hBonds.get(c));
									}
									else{
										//remove HB
										removeHBond(c, false);
									}
								}
								else if (c.atom2 == a){
									if (rotatedSet.contains(c.atom1)){
										//the monitor should be added
										rotationGroup.addChild((GlRenderable)hBonds.get(c));
										renderablesList.remove(hBonds.get(c));
										localRenderables.remove(hBonds.get(c));
									}
									else{
										//remove HB
										removeHBond(c, false);
									}
								}

							}
						}

						if (atomToBumps.containsKey(a)){
							Vector mm = (Vector)atomToBumps.get(a);
							for (int j = 0; j < mm.size(); j++){
								StericBumpComponent c = (StericBumpComponent)mm.get(j);
								if (c.atom1 == a){
									if (rotatedSet.contains(c.atom2)){
										//the bump should be added
										rotationGroup.addChild((GlRenderable)bumps.get(c));
										renderablesList.remove(bumps.get(c));
										localRenderables.remove(bumps.get(c));
									}
									else{
										//remove bump
										removeBump(c, false);
									}
								}
								else if (c.atom2 == a){
									if (rotatedSet.contains(c.atom1)){
										//the bump should be added
										rotationGroup.addChild((GlRenderable)bumps.get(c));
										renderablesList.remove(bumps.get(c));
										localRenderables.remove(bumps.get(c));
									}
									else{
										//remove bump
										removeBump(c, false);
									}
								}

							}
						}
					}
					catch (ClassCastException e){}
				}
				
				renderablesList.add(rotationGroup);
				
				geometryViewer.setRenderables(renderablesList);
				geometryViewer.updateView();
				
				//the rest will be handled in the event handling code
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception performing bond rotation", ex);
			}
			
		}
		else if (source instanceof AtomDialog){
			try{
				
				Vector atoms = ((StructureEvent)event).atoms;
				Vector atomLabels = ((StructureEvent)event).atomLabels;
				int type = ((StructureEvent)event).eventType;
				
				if (type == StructureEventRegistry.SELECT_ATOM){
					
					String name = null;
					if (atomLabels == null || atomLabels.size() == 0){
						//try checking name out of the atom
						Atom atom = (Atom)atoms.get(0);
						if (atom == null){
							structureDocument.parent.displayErrorMessage("Specified atom not found");
							return;
						}
						
						name = atom.name;
					}
					else{
						name = (String)atomLabels.get(0);
					}
					
					for (int i = 0; i < structureList.size(); i++){
						Structure s = (Structure)structureList.get(i);
						for (int j = 0; j < s.getStructureMap().getAtomCount(); j++){
							Atom a = s.getStructureMap().getAtom(j);
							if (a.name.equals(name) || a.name.equals(name.toUpperCase())){
								s.getStructureMap().getStructureStyles().setSelected(a, true, true,true);
							}
						}
					}

				}
				else if (type == StructureEventRegistry.DELETE_ATOM){
					
					Atom atom = (Atom)atoms.get(0);
					
					if (atom == null){
						
						Vector labels = ((StructureEvent)event).atomLabels;
						if (labels == null || labels.get(0) == null){
							structureDocument.parent.displayErrorMessage("Specified atom not found");
							return;
						}
						
						//get the label and atoms out of them
						atom = (Atom)labelToObject((String)labels.elementAt(0));
						
						if (atom == null){
							structureDocument.parent.displayErrorMessage("Specified atom not found");
							return;
						}
					}
					
					StructureMap map = atom.structure.getStructureMap();
					atom.structure.getStructureMap().getStructureStyles().deleteStructureComponent(atom, true, false);
				}

				structureDocument.parent.updateView();
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception processing atom", ex);
			}
		}
		else if (source instanceof ReplaceAtomDialog){
			try{
				Vector atoms = ((StructureEvent)event).atoms;
				String element = ((StructureEvent)event).element;
				
				Atom atom = (Atom)atoms.get(0);
				if (atom == null){
					
					Vector labels = ((StructureEvent)event).atomLabels;
					if (labels == null || labels.get(0) == null){
						structureDocument.parent.displayErrorMessage("Specified atom not found");
						return;
					}
					
					//get the label and atoms out of them
					atom = (Atom)labelToObject((String)labels.elementAt(0));
					
					if (atom == null){
						structureDocument.parent.displayErrorMessage("Specified atom not found");
						return;
					}
				}
				
				
				//this check can be done if the replaced atom is either hydrogen or another
				//element that is bonded only to hydrogens, except for one atom, which serves as the reference point
				//for new bond length calculation
				
				short newElement = (short)PeriodicTable.getElementNumber(element);
				
				//walk around the atom being replaced
				Vector aaa = atom.structure.getStructureMap().getAtoms(atom);
				int nonH = 0;
				Atom next = null;
				if (aaa.size() > 0){
					for (int i = 0; i < aaa.size(); i++){
						Atom aa = (Atom)aaa.get(i);
						if (aa.element > 1){
							nonH++;
							next = aa;
						}
					}
				
					if (nonH < 2){
						if (next == null) next = (Atom)aaa.get(0);
						double distance = ElementProperties.getBondLength(newElement, next.element);
						double[] vector = Algebra.getVector(next.coordinate, atom.coordinate);
						double[] position = StructureMath.getPointOnVector(next.coordinate, vector, distance);
						atom.coordinate[0] = position[0];
						atom.coordinate[1] = position[1];
						atom.coordinate[2] = position[2];
					}
				
				}

				
				atom.structure.getStructureMap().getStructureStyles().replaceStructureComponent(atom, element);
				
				structureDocument.parent.updateView();
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception replacing atom", ex);
			}
		}
		else if (source instanceof RibbonDialog){
			
			/**
			 * TODO 
			 */
			
			try{
		
				//get the information
				String label = ((RibbonEvent)event).componentId;
				boolean flag = ((RibbonEvent)event).status;
				int ribbonType = ((RibbonEvent)event).ribbonType;
				float ribbonDiameter = ((RibbonEvent)event).ribbonDiameter;
				boolean status = ((RibbonEvent)event).status;
				int setFlag = ((RibbonEvent)event).setFlag;
				float ribbonQuality = ((RibbonEvent)event).ribbonQuality;
				
				if (atomSetNames.contains(label)){
					//a set has been selected
					
					Vector atomSet = (Vector)atomSets.get(label);
					Vector s = getLoadedStructures();
					for (int i = 0; i < s.size(); i++){
						Structure ss = (Structure)s.get(i);
						StructureMap map = ss.getStructureMap();
						StructureStyles styles = map.getStructureStyles();
						
						Vector selection = new Vector();//chains
						
						for (int j = 0; j < map.getChainCount(); j++){
							Chain ch = map.getChain(j);
							
							for (int m = 0; m < ch.getResidueCount(); m++){
								Residue res = ch.getResidue(m);
								if (res.getClassification().equals(Residue.COMPOUND_AMINO_ACID)){
									if (atomSet.contains(res)){
										res.ribbon = status;
										if (!selection.contains(ch)) selection.add(ch);
									}
									else{
										boolean sel = true;
										for (int k = 0; k < res.getAtomCount(); k++){
											Atom a = res.getAtom(k);
											if (a.backbone){
												if (!atomSet.contains(a)){
													sel = false;
													break;
												}
											}
										}
										
										if (sel){
											res.ribbon = status;
											if (!selection.contains(ch)) selection.add(ch);
										}
									}
								}
								else if (res.getClassification().equals(Residue.COMPOUND_NUCLEIC_ACID)){
									if (atomSet.contains(res)){
										res.ribbon = status;
										if (!selection.contains(ch)) selection.add(ch);
									}
									else{
										boolean sel = true;
										for (int k = 0; k < res.getAtomCount(); k++){
											Atom a = res.getAtom(k);
											if (a.backbone){
												if (!atomSet.contains(a)){
													sel = false;
													break;
												}
											}
										}
										
										if (sel){
											res.ribbon = status;
											if (!selection.contains(ch)) selection.add(ch);
										}
										
									}
								}

							}
							
						}
						
//						System.out.println("selection = " + selection.size());
						
						Hashtable structureHash = (Hashtable)objectHash.get(ss);
						Vector rr = (Vector)renderables.get(ss);
						
						//ribbon gets completely removed only if no residues are shown						
						
						for (int j = 0 ; j < selection.size(); j++){
							Chain chain = (Chain)selection.get(j);
							
							boolean delete = true;
							for (int k = 0; k < chain.getResidueCount(); k++){
								Residue res = chain.getResidue(k);
								if (res.ribbon){
									delete = false;
									break;
								}
							}
							
							//if ribbon is kept but the event was "hide", keep the old styles
							
							
							if (!delete){
							
								//show a ribbon
								if (structureHash.containsKey(chain)){
									
									//check whether the ribbon is hidden
									if (hiddenComponents.containsKey(chain)){
										rr.add(structureHash.get(chain));
										renderablesList.add(structureHash.get(chain));
										hiddenComponents.remove(chain);
									}
									
									if (status){
										styles.setRibbonType(chain, ribbonType);
										styles.setRibbonQuality(chain, ribbonQuality);
										styles.setRibbonDiameter(chain, ribbonDiameter);
									}
									GlRenderable r = (GlRenderable)structureHash.get(chain);
									r.setDirty();
									
									geometryViewer.updateView();
									
									continue;
									
								}
								
//								System.out.println("viewer: ribbon type = " + ribbonType);
								
								styles.setRibbonType(chain, ribbonType);
								styles.setRibbonQuality(chain, ribbonQuality);
								styles.setRibbonDiameter(chain, ribbonDiameter);
								styles.setRibbonVisible(chain, true, false, false);

								MbtRenderable r = new MbtRenderable( chain, styles, new ChainGeometry());
								
								
								//now check whether this chain is being moved independently
								if (independentGroup != null){
									//check the independent components
									Vector residues = new Vector();
									for (int k = 0; k < independentComponents.size(); k++){
										try{
											Residue res = (Residue)independentComponents.get(k);
											if (!residues.contains(res)) residues.add(res);
										}
										catch (ClassCastException ex){}
									}
									
									//check whether movable residue count in the chain is the same as the total residue count
									int count = 0;
									for (int k = 0; k < map.getChildren(chain).size(); k++){
										Fragment f = (Fragment)map.getChildren(chain).get(k);
										count += f.structure.getStructureMap().getChildren(f).size();
									}

									if (count == residues.size()){
										independentGroup.addChild(r);
									}
									else{
										rr.add(r);
										renderablesList.add(r);
									}
								}
								else{
									rr.add(r);
									renderablesList.add(r);
								}
								
								structureHash.put(chain, r);
							}
							else{
								//remove the ribbon - move to hiddenComponents
								if (!structureHash.containsKey(chain)) return;
								GlRenderable r = (GlRenderable)structureHash.get(chain);
								
								//hide it
								hiddenComponents.put(chain, r);
								renderablesList.remove(r);
								rr.remove(r);
								
								
								if (independentGroup != null && independentGroup.containsChild(r)){
									independentGroup.removeChild(r);
								}
								else{
									rr.remove(r);
									renderablesList.remove(r);
								}
								styles.setRibbonVisible(chain, false, false, false);
							}
						}
					}
					
					structureDocument.parent.updateView();

					return;
				}


				if (setFlag == DialogConstants.APPLY_SELECTION){
					//get a list of currently selected residues
					//even if the residue is not selected fully, check, whether its backbone atoms
					//are selected - that qualifies
					//residue-level operation only requires setting the ribbon flag
					//affected chains are selected and their chains are created
					setRibbonInSelection(status, ribbonType, ribbonDiameter, ribbonQuality);
					
				}
				else if (setFlag == DialogConstants.APPLY_VISIBLE){
					//get a list of currently visible ribbon fragments: DO NOT change residue.ribbon flags, but only
					//re-render the ribbon, in case the user only changed appearance or quality
					setRibbonInVisible(status, ribbonType, ribbonDiameter, ribbonQuality);
				}
				else if (setFlag == DialogConstants.APPLY_CHAIN){
					Chain chain = null;
					if (((RibbonEvent)event).structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
						chain = (Chain)((RibbonEvent)event).structureComponent;
					}
					else{
						try{
							Atom a = (Atom)((RibbonEvent)event).structureComponent;
							chain = a.structure.getStructureMap().getChain(a);
						}
						catch (ClassCastException ex){
							Residue r = (Residue)((RibbonEvent)event).structureComponent;
							chain = r.structure.getStructureMap().getChain(r.getAtom(0));
						}
						catch (NullPointerException s){}
					}
					
					if (chain == null){
						try{
							int index = label.lastIndexOf(":");
							String newLabel = label.substring(0, index);
							int index2 = newLabel.lastIndexOf(":");
						
							chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
						}
						catch (ClassCastException ex){
							//happens when the labels ends with the residue record
							chain = (Chain)(labelToObject(label));
						}
					}
					
					if (chain == null){
						return;
					}
					
					Structure structure = chain.structure;
					StructureStyles structureStyles = structure.getStructureMap().getStructureStyles();
					Hashtable structureHash = (Hashtable)objectHash.get(structure);
					Vector rr = (Vector)renderables.get(structure);
					
					boolean proceed = false;//there is at least one amino acid or nucleic acid in the chain
					for (int i = 0; i < chain.getResidueCount(); i++){
						Residue res = chain.getResidue(i);
						if (res.getClassification().equals(Residue.COMPOUND_AMINO_ACID) || 
								res.getClassification().equals(Residue.COMPOUND_NUCLEIC_ACID)){
							res.ribbon = status;
							proceed = true;
						}
					}
	
					if (!proceed) return;
					
					if (status){
						//add/show a ribbon
						if (structureHash.containsKey(chain)){
							
							//check whether the ribbon is hidden
							if (hiddenComponents.containsKey(chain)){
								rr.add(structureHash.get(chain));
								renderablesList.add(structureHash.get(chain));
								hiddenComponents.remove(chain);
							}
							
							//since the parameters may be the same, but residue visibility different,
							//just repaint it.
							
/*							//check if the requested type is the same as the existing one
							if (structureStyles.getRibbonType(chain) == ribbonType && 
									structureStyles.getRibbonQuality(chain) == ribbonQuality && 
									structureStyles.getRibbonDiameter(chain) == ribbonDiameter){
								return;
							}
*/							
							
							structureStyles.setRibbonType(chain, ribbonType);
							structureStyles.setRibbonQuality(chain, ribbonQuality);
							structureStyles.setRibbonDiameter(chain, ribbonDiameter);
							GlRenderable r = (GlRenderable)structureHash.get(chain);
							r.setDirty();
							
							geometryViewer.updateView();
							
							return;
							
						}
						
//						System.out.println("viewer: ribbon type = " + ribbonType);
						
						structureStyles.setRibbonType(chain, ribbonType);
						structureStyles.setRibbonQuality(chain, ribbonQuality);
						structureStyles.setRibbonDiameter(chain, ribbonDiameter);
						structureStyles.setRibbonVisible(chain, true, false, false);

						MbtRenderable r = new MbtRenderable( chain, structureStyles, new ChainGeometry());
						
						
						//now check whether this chain is being moved independently
						if (independentGroup != null){
							//check the independent components
							Vector residues = new Vector();
							for (int i = 0; i < independentComponents.size(); i++){
								try{
									Residue res = (Residue)independentComponents.get(i);
									if (!residues.contains(res)) residues.add(res);
								}
								catch (ClassCastException ex){}
							}
							
							//check whether movable residue count in the chain is the same as the total residue count
							int count = 0;
							for (int i = 0; i < structure.getStructureMap().getChildren(chain).size(); i++){
								Fragment f = (Fragment)structure.getStructureMap().getChildren(chain).get(i);
								count += f.structure.getStructureMap().getChildren(f).size();
							}

							if (count == residues.size()){
								independentGroup.addChild(r);
							}
							else{
								rr.add(r);
								renderablesList.add(r);
							}
						}
						else{
							rr.add(r);
							renderablesList.add(r);
						}
						
						structureHash.put(chain, r);
					}
					else{
						//remove the ribbon
						if (!structureHash.containsKey(chain)) return;
						GlRenderable r = (GlRenderable)structureHash.get(chain);
						
						//hide it
						hiddenComponents.put(chain, r);
						renderablesList.remove(r);
						rr.remove(r);
						
						
						if (independentGroup != null && independentGroup.containsChild(r)){
							independentGroup.removeChild(r);
						}
						else{
							rr.remove(r);
							renderablesList.remove(r);
						}
						
						structureStyles.setRibbonVisible(chain, false, false, false);
					}
					
					
				}
				else if (setFlag == DialogConstants.APPLY_STRUCTURE){
					
					Structure structure = null;
					
					try{
						Atom a = (Atom)((RibbonEvent)event).structureComponent;
						structure = a.structure;
					}
					catch (ClassCastException ex){
						Residue r = (Residue)((RibbonEvent)event).structureComponent;
						structure = r.structure;
					}
					catch (NullPointerException s){}
				
					if (structure == null){
						
						//try to get it from the label
						//no matter what information is contained in the label, pick only the first fragment
						int index = label.indexOf(":");
						
						String newLabel = "";
						if (index == -1){
							newLabel = label;
						}
						else{
							newLabel = label.substring(0,index);
						}
						
						try{
							structure = (Structure)labelToObject(newLabel);
						}
						catch (ClassCastException ex){
							structureDocument.parent.displayExceptionMessage("Exception rendering ribbon", ex);
							return;
						}
					}
					
					if (structure == null){
						structureDocument.parent.displayErrorMessage("Unable to display ribbon for structure = null");
						return;
					}
					
					Vector rr = (Vector)renderables.get(structure);
					Hashtable structureHash = (Hashtable)objectHash.get(structure);
					
					Vector chains = structure.getStructureMap().getChains();
					if (status){
						//add a ribbon
						for (int i = 0; i < chains.size(); i++){

							boolean proceed = false;
							Chain chain = (Chain)chains.get(i);
							Residue lastResidue = null;
							
							for (int j = 0; j < chain.getResidueCount(); j++){
								Residue res = chain.getResidue(j);
								try{
									if (res.getClassification().equals(Residue.COMPOUND_AMINO_ACID) || 
											res.getClassification().equals(Residue.COMPOUND_NUCLEIC_ACID)){
										//check the distance
										if (lastResidue != null){
											if (Algebra.distance(lastResidue.getAlphaAtom().coordinate, res.getAlphaAtom().coordinate) > 5){
	//											System.out.println("distance is greater than 5 A");
												lastResidue.ribbon = false;//to avoid long ribbon fragments
												res.ribbon = false;
											}
											else{
												res.ribbon = true;
											}
										}
										else{
											res.ribbon = true;
										}
										proceed = true;
									}
									else{
										res.ribbon = false;
										if (lastResidue != null){
											lastResidue.ribbon = false;
										}
									}
								}
								catch (Exception ee){
									res.ribbon = false;
									if (lastResidue != null) lastResidue.ribbon = false;
								}
								
								lastResidue = res;
							}
							
							if (!proceed){
								continue;
							}
							
							if (structureHash.containsKey(chain)){
								
								if (hiddenComponents.containsKey(chain)){
									MbtRenderable rrr = (MbtRenderable)hiddenComponents.get(chain);
									rr.add(rrr);
									renderablesList.add(rrr);
								}
								
								structure.getStructureMap().getStructureStyles().setRibbonType(chain, ribbonType);
								structure.getStructureMap().getStructureStyles().setRibbonQuality(chain, ribbonQuality);
								structure.getStructureMap().getStructureStyles().setRibbonDiameter(chain, ribbonDiameter);
 
								GlRenderable r = (GlRenderable)structureHash.get(chain);
								r.setDirty();
								
								continue;
								
							}
							else{
								try{
									addRibbon(chain, ribbonType, ribbonQuality, ribbonDiameter, false);
								}
								catch (Exception ex){
									ex.printStackTrace();
								}
							}
							
						}
					}
					else{
						//remove ribbon
						for (int i = 0; i < chains.size(); i++){
							Chain chain = (Chain)chains.get(i);
							boolean proceed = false;
							for (int j = 0; j < chain.getResidueCount(); j++){
								Residue res = chain.getResidue(j);
								if (res.getClassification().equals(Residue.COMPOUND_AMINO_ACID) || 
										res.getClassification().equals(Residue.COMPOUND_NUCLEIC_ACID)){
									res.ribbon = false;
									proceed = true;
								}
								else{
									res.ribbon = false;
								}
							}
							
							if (!proceed) continue;
							removeRibbon(chain, false);
							
						}
					}
				}
				
				geometryViewer.setRenderables(renderablesList);
				geometryViewer.updateView();

			
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception processing ribbon request", ex);
			}
		}
	}
	
	public void createRibbon(Chain chain, int type, float quality, float diameter, boolean updateView){
		
		//add a ribbon
		Structure structure = chain.structure;
		StructureMap map = structure.getStructureMap();
		StructureStyles styles = map.getStructureStyles();
		
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector rr = (Vector)renderables.get(structure);
		
		if (structureHash.containsKey(chain)){
			
			styles.setRibbonType(chain, type);
			styles.setRibbonQuality(chain, quality);
			styles.setRibbonDiameter(chain, diameter);
			GlRenderable r = (GlRenderable)structureHash.get(chain);
			r.setDirty();
			
			geometryViewer.updateView();
			
			return;
		}
		
		styles.setRibbonType(chain, type);
		styles.setRibbonQuality(chain, quality);
		styles.setRibbonDiameter(chain, diameter);
		
		boolean visible = false;
		//if at least one residue is visible, ribbon is visible
		for (int i = 0; i < chain.getResidueCount(); i++){
			Residue r = chain.getResidue(i);
			if (r.ribbon){
				visible = true;
				break;
			}
		}

		MbtRenderable r = new MbtRenderable( chain, structure.getStructureMap().getStructureStyles(), new ChainGeometry());
		structureHash.put(chain, r);
		
		//check whether any residues in this chain are selected
		for (int i = 0; i < chain.getResidueCount(); i++){
			if (styles.isSelected(chain.getResidue(i))){
				selectedChains.add(chain);
				break;
			}
		}

		if (visible){
			rr.add(r);
			renderablesList.add(r);
			if (updateView){
				geometryViewer.setRenderables(renderablesList);
				geometryViewer.updateView();
			}
		}
		else{
			hiddenComponents.put(chain, r);
		}

	}
	
	public void createRibbonInSelection(int type, float quality, float diameter, boolean updateView){
		
		Vector s = getLoadedStructures();
		for (int i = 0; i < s.size(); i++){
			Structure ss = (Structure)s.get(i);
			StructureMap map = ss.getStructureMap();
			StructureStyles styles = map.getStructureStyles();
			
			Vector selection = new Vector();//chains
			
			for (int j = 0; j < map.getChainCount(); j++){
				Chain ch = map.getChain(j);
				
				for (int m = 0; m < ch.getResidueCount(); m++){
					Residue res = ch.getResidue(m);
					if (res.getClassification().equals(Residue.COMPOUND_AMINO_ACID)){
						if (styles.isSelected(res)){
							res.ribbon = true;
							if (!selection.contains(ch)) selection.add(ch);
						}
						else{
							boolean sel = true;
							for (int k = 0; k < res.getAtomCount(); k++){
								Atom a = res.getAtom(k);
								if (a.backbone){
									if (!styles.isSelected(a)){
										sel = false;
										break;
									}
								}
							}
							
							if (sel){
								res.ribbon = true;
								if (!selection.contains(ch)) selection.add(ch);
							}
						}
						
					}
					else if (res.getClassification().equals(Residue.COMPOUND_NUCLEIC_ACID)){
						if (styles.isSelected(res)){
							res.ribbon = true;
							if (!selection.contains(ch)) selection.add(ch);
						}
						else{
							boolean sel = true;
							for (int k = 0; k < res.getAtomCount(); k++){
								Atom a = res.getAtom(k);
								if (a.backbone){
									if (!styles.isSelected(a)){
										sel = false;
										break;
									}
								}
							}
							
							if (sel){
								res.ribbon = true;
								if (!selection.contains(ch)) selection.add(ch);
							}
							
						}
					}

				}
				
			}
			
//			System.out.println("selection = " + selection.size());
			
			Hashtable structureHash = (Hashtable)objectHash.get(ss);
			Vector rr = (Vector)renderables.get(ss);
			
			//ribbon gets completely removed only if no residues are shown		
			
			for (int j = 0 ; j < selection.size(); j++){
				Chain chain = (Chain)selection.get(j);
				
				
				//show a ribbon
				if (structureHash.containsKey(chain)){
					//check whether the ribbon is hidden
					if (hiddenComponents.containsKey(chain)){
						rr.add(structureHash.get(chain));
						renderablesList.add(structureHash.get(chain));
						hiddenComponents.remove(chain);
					}
					
					styles.setRibbonType(chain, type);
					styles.setRibbonQuality(chain, quality);
					styles.setRibbonDiameter(chain, diameter);
						
					GlRenderable r = (GlRenderable)structureHash.get(chain);
					r.setDirty();
					
					geometryViewer.updateView();
					
					continue;
					
				}
				
				styles.setRibbonType(chain, type);
				styles.setRibbonQuality(chain, quality);
				styles.setRibbonDiameter(chain, diameter);
				styles.setRibbonVisible(chain, true, false, false);

				MbtRenderable r = new MbtRenderable( chain, styles, new ChainGeometry());
				
				
				//now check whether this chain is being moved independently
				if (independentGroup != null){
					//check the independent components
					Vector residues = new Vector();
					for (int k = 0; k < independentComponents.size(); k++){
						try{
							Residue res = (Residue)independentComponents.get(k);
							if (!residues.contains(res)) residues.add(res);
						}
						catch (ClassCastException ex){}
					}
					
					//check whether movable residue count in the chain is the same as the total residue count
					int count = 0;
					for (int k = 0; k < map.getChildren(chain).size(); k++){
						Fragment f = (Fragment)map.getChildren(chain).get(k);
						count += f.structure.getStructureMap().getChildren(f).size();
					}

					if (count == residues.size()){
						independentGroup.addChild(r);
					}
					else{
						rr.add(r);
						renderablesList.add(r);
					}
				}
				else{
					rr.add(r);
					renderablesList.add(r);
				}
				
				structureHash.put(chain, r);
				
				styles.updateChain(chain, true);
				
			}
		}
	}

	
	/**
	 * This method serves to delete hydrogens without creating any dummy atoms. Used to subsequently 
	 * correctly assign hydrogens
	 * @param atom
	 */
	public void deleteHydrogen(Atom atom, boolean update){

		atom.structure.getStructureMap().getStructureStyles().deleteStructureComponent(atom, true, !update);
	}
	
	/**
	 * This method returns a String identification of the structure component in the format structure:residue:atom
	 */
	
	/**
	 * Returns structure component identified by the given string
	 */
	public Object labelToObject(String label){
		
		try{
		
		if (label.length() == 0){
			return null;
		}
		
		label.toUpperCase();
		
		Vector tokens = new Vector();
		StringTokenizer tok = new StringTokenizer(label, ":", false);
		while (tok.hasMoreTokens()){
			String t = tok.nextToken();
			tokens.add(t);
		}
		
		if (tokens.size() == 0){
			return null;
		}
		
		String structureId = null;
		String tag = (String)tokens.elementAt(0);
		
		
		String paddedId = tag;
		String tagId = tag;

		//identify the object using the id
		Structure structure = null;
		
		//make sure both database and file-derived structures are handled properly
//		System.out.println("Queried structure name = " + tag + " and " + paddedId);
		
		Set keys = structures.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			StructureEntry e = (StructureEntry)it.next();
			if (this.getStructureName(((StructureEntry)e).getStructure()).equals(tag)){
				structure = ((StructureEntry)e).getStructure();
//				System.out.println("structure match");
				break;
			}
			else if (e.getName() != null && e.getName().compareToIgnoreCase(tag) == 0){
				structure = ((StructureEntry)e).getStructure();
//				System.out.println("structure match");
				break;
			}
		}
		
//		System.out.println("tokens = " + tokens);
		
		if (tokens.size() == 1){
			//only the structure has been specified
//			System.out.println("Only structure");
			return structure;
		}
		
		if (structure == null){
			return null;
		}
		
		StructureMap structureMap = structure.getStructureMap();
		
		//now get the chain
		Chain chain = null;
		String chain_id = (String)tokens.elementAt(1);
		int chainCount = structureMap.getChainCount();
		for (int i = 0; i < chainCount; i++){
			Chain c = structureMap.getChain(i);
			if (c.getChainId().equals(chain_id)){
				chain = c;
				break;
			}
		}
		
//		System.out.println("chain = " + chain);
		
		if (tokens.size() == 2){
			return chain;
		}
		
		//now get the residue
		//check whether the 3-letter code is active (nucleotides tend to have 1-letter code)
//		System.out.println("Matching " + tokens.elementAt(2));
		
		int residue_id = getResidueNumberFromLabel((String)tokens.elementAt(2));
		
//		System.out.println("residue_id = " + residue_id);
		
		//declare the residues vector just in case it's needed
		Vector residues = null;

		if (residue_id != -1){
			
			//identify this Residue in the StructureMap by its number and chain
			String chainResId = chain_id + residue_id;
			
			Residue residue = structureMap.getResidue(chainResId);
		
			if (tokens.size() == 3){
				return residue;
			}
			
			//get the atom(s)
			String a = (String)tokens.elementAt(3);

			int atomCount = residue.getAtomCount();
			for (int i = 0; i < atomCount; i++){
				Atom aa = residue.getAtom(i);
				if (aa.name.equals(a)){
					return aa;
				}
			}
			
		}	
		else{
				
			//the residue record is either garbage or a comma-separated list of residues or a dash
			//separated range
			residues = new Vector();
			
			boolean done = false;
			
			Vector cTokens = new Vector();
			StringTokenizer t = new StringTokenizer((String)tokens.elementAt(2), ",", false );
			while (t.hasMoreTokens()){
				cTokens.add(t.nextToken());
			}
			if (cTokens.size() > 0){
				//there are residues separated by commas
				for (int i = 0; i < cTokens.size(); i++){
					String record = ((String)cTokens.elementAt(i)).trim();
					//check whether it's a valid residue record
					int n = getResidueNumberFromLabel(record);
					if (n > -1){
						residues.add(new Integer(n));
						done = true;
					}
				}
			}
				
			//check whether the comma-separated list check was successful
			if (!done){
				//assume that the entered record is a dash-separated range
				String[] labels = new String[2];
				StringTokenizer tt = new StringTokenizer((String)tokens.elementAt(2), "-", false);
				
				if (tt.countTokens() < 2){
					return null;
				}
				else{
					labels[0] = tt.nextToken();	
					labels[1] = tt.nextToken();
				
					//get the two numbers and generate all residue numbers in between
					int n1 = getResidueNumberFromLabel(labels[0]);
					int n2 = getResidueNumberFromLabel(labels[1]);
					
					if (n1 < 0 || n2 < 0){
						return null;
					}
					else{
						//go over the list and populate the intermediate numbers
						for (int k = n1; k <=n2; k++){
							residues.add(new Integer(k));
						}
					}
				}
			}
		}
		
		if (tokens.size() == 3){
//			System.out.println("three tokens");
			//just the residues are required.
			//iterate through the vector (if exists) and return a Vector of Residue objects
			if (residues != null && residues.size() > 0){
				Vector out = new Vector();
				for (int k = 0; k < residues.size(); k++){
					String chainResId = chain_id + residue_id;
					Residue residue = structureMap.getResidue(chainResId);
					out.add(residue);
				}
				return out;
			}
			else{
				return null;
			}
		}
		
		//the atom tag was also entered, so iterate through specified atoms and return them
		//get the atom(s)
		
//		System.out.println("Processing atom tag");
		if (residues != null && residues.size() > 0){
			Vector out = new Vector();
			for (int k = 0; k < residues.size(); k++){
//				System.out.println("residue");
				String chainResId = chain_id + residue_id;
				Residue residue = structureMap.getResidue(chainResId);
				String a = (String)tokens.elementAt(3);

				int atomCount = residue.getAtomCount();
				for (int i = 0; i < atomCount; i++){
					Atom aa = residue.getAtom(i);
					if (aa.name.equals(a)){
						out.add(aa);
					}
				}
			}
		
			return out;
		}
		
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception converting label to object", ex);
		}
		
		return null;
	}
	
	
	private int getResidueNumberFromLabel(String label){
		
		int result = -1;
		try{
			
			//this method takes a record that may contain a residue number or aa+number
			//and extracts a number from it.
			//if no valid number can be extracted, -1 is returned
			String number = "";
			Pattern pattern = Pattern.compile("(([A-Z]+)([0-9]+))");
			Matcher matcher = pattern.matcher(label);
			if (matcher.matches()){
				number = matcher.group(3);
			}
			else{
				//try to match just the residue number
				pattern = Pattern.compile("(([0-9]+))");
				matcher = pattern.matcher(label);
				
				if (matcher.matches()){
					number = matcher.group(2);
				}
				else{
					return -1;
				}
			}
			
			try{
				result = Integer.parseInt(number);
			}
			catch (NumberFormatException ex){
				return -1;
			}
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception retrieving residue number from label", ex);
		}
		return result;
							
	}
	
	public void clearAllSelection(){
		for (int i = 0; i < structureDocument.getEntryCount(); i++){
			Structure structure = (Structure)structures.get(structureDocument.getEntry(i));
			structure.getStructureMap().getStructureStyles().selectNone(true, false);
		}
		structureDocument.parent.updateView();
	}
	
	/**
	 * This method check atoms next to the given Bond and determines whether a line geometry needs
	 * to be created (if the atom is visible and has no visible bonds) or removed (if at least one
	 * bond becomes visible). This applies only to line geometry, otherwise, atoms are explicitly drawn
	 * and are handled separately
	 * @param bond
	 */
	private void checkDummyAtoms(Bond bond){
		
		StructureMap map = bond.structure.getStructureMap();
		StructureStyles styles = map.getStructureStyles();
		boolean visible = bond.visible;
		Atom a0 = bond.getAtom(0);
		Atom a1 = bond.getAtom(1);
		
		if (visible){
			//bond has been displayed. check if any of its atoms are represented in dummies
			if (dummyAtoms.contains(a0) && a0.render == StylesPreferences.RENDERING_LINES){
				//delete the geometry
				Hashtable structureHash = (Hashtable)objectHash.get(a0.structure);
				if (independentSet.contains(a0)){
					independentGroup.removeChild((GlRenderable)structureHash.get(a0));
				}
				else{
					Vector rrr = (Vector)renderables.get(a0.structure);
					renderablesList.remove(structureHash.get(a0));
					rrr.remove(structureHash.get(a0));

				}
				dummyAtoms.remove(a0);
				
				geometryViewer.setRenderables(renderablesList);
				geometryViewer.updateView();
				
				structureHash.remove(a0);
			}
			if (dummyAtoms.contains(a1) && a1.render == StylesPreferences.RENDERING_LINES ){
				//delete the geometry
				Hashtable structureHash = (Hashtable)objectHash.get(a1.structure);
				dummyAtoms.remove(a1);
				if (independentSet.contains(a0)){
					independentGroup.removeChild((GlRenderable)structureHash.get(a0));
				}
				else{
					Vector rrr = (Vector)renderables.get(a1.structure);
					renderablesList.remove(structureHash.get(a0));
					rrr.remove(structureHash.get(a1));
				}
				geometryViewer.setRenderables(renderablesList);
				geometryViewer.updateView();

				structureHash.remove(a1);
			}
			
		}
		else{
			//bond has been hidden. check if any of its atoms remain with no visible bonds and
			//a dummy needs to be created
			if (a0.render == StylesPreferences.RENDERING_LINES && a0.visible){
				//check its bond list
				Vector bonds = map.getBonds(a0);
				boolean vis = false;
				for (int i = 0; i < bonds.size(); i++){
					if (((Bond)bonds.get(i)).visible){
						vis = true;
						break;
					}
				}
				if (!dummyAtoms.contains(a0) && !vis){
					//no bonds are visible, dummy geometry needs to be created
					MbtRenderable rr = new MbtRenderable(a0, styles, (AtomLineGeometry)defaultGeometry.get("AtomLineGeometry"));//don't translate
					if (independentSet.contains(a0)){
						independentGroup.addChild(rr);
					}
					else{
						Vector rrr = (Vector)renderables.get(a0.structure);
						rrr.add(rr);
						renderablesList.add(rr);
					}
					
					Hashtable structureHash = (Hashtable)objectHash.get(a0.structure);
					structureHash.put(a0, rr);

					dummyAtoms.add(a0);
					
					geometryViewer.setRenderables(renderablesList);
					geometryViewer.updateView();
				}
				
			}
			if (a1.render == StylesPreferences.RENDERING_LINES && a1.visible){
				//check its bond list
				Vector bonds = map.getBonds(a1);
				boolean vis = false;
				for (int i = 0; i < bonds.size(); i++){
					if (((Bond)bonds.get(i)).visible){
						vis = true;
						break;
					}
				}
				if (!dummyAtoms.contains(a1) && !vis){
					//no bonds are visible, dummy geometry needs to be created
					MbtRenderable rr = new MbtRenderable(a1, styles, (AtomLineGeometry)defaultGeometry.get("AtomLineGeometry"));//don't translate
					if (independentSet.contains(a1)){
						independentGroup.addChild(rr);
					}
					else{
						Vector rrr = (Vector)renderables.get(a1.structure);
						rrr.add(rr);
						renderablesList.add(rr);
					}

					Hashtable structureHash = (Hashtable)objectHash.get(a1.structure);
					structureHash.put(a1, rr);

					dummyAtoms.add(a1);
					
					geometryViewer.setRenderables(renderablesList);
					geometryViewer.updateView();
				}
			}
			
		}
	}
	
	/**
	 * This method checks whether the atom should be represented as a dummy
	 * @param atom
	 * @param update
	 */
	public void checkDummyAtoms(Atom atom, boolean update){
		StructureMap map = atom.structure.getStructureMap();
		StructureStyles styles = map.getStructureStyles();
		
		if (atom.render != StylesPreferences.RENDERING_LINES) return;
		
		boolean visible = atom.visible;
		
		Vector bonds = map.getBonds(atom);
		boolean vis = false;
		if (bonds != null && bonds.size() > 0){
			for (int i = 0; i < bonds.size(); i++){
				if (((Bond)bonds.get(i)).visible){
					vis = true;
					break;
				}
			}
		}
		else{
			//typical for bound waters
			//add a dummy if atom is visible
			if (visible && !dummyAtoms.contains(atom)){
				//atom needs to be added and geometry needs to be created
				MbtRenderable rr = new MbtRenderable(atom, styles, (AtomLineGeometry)defaultGeometry.get("AtomLineGeometry"));//don't translate
				if (independentSet.contains(atom)){
					independentGroup.addChild(rr);
				}
				else{
					Vector rrr = (Vector)renderables.get(atom.structure);
					rrr.add(rr);
					renderablesList.add(rr);
				}
				
				Hashtable structureHash = (Hashtable)objectHash.get(atom.structure);
				structureHash.put(atom, rr);

				dummyAtoms.add(atom);
				
				geometryViewer.setRenderables(renderablesList);
				if (update) geometryViewer.updateView();
			}
			else if (!visible){
				//dummy atom needs to be hidden
				Hashtable structureHash = (Hashtable)objectHash.get(atom.structure);
				MbtRenderable rr = (MbtRenderable)structureHash.get(atom);
				if (independentSet.contains(atom)){
					independentGroup.removeChild(rr);
				}
				else{
					Vector rrr = (Vector)renderables.get(atom.structure);
					rrr.remove(rr);
					renderablesList.remove(rr);
				}
				
				hiddenComponents.put(atom, rr);
				
			}
			else if (visible){
				//show the existing dummy atom renderable
				if (dummyAtoms.contains(atom)){
					if (hiddenComponents.containsKey(atom)){
						MbtRenderable rr = (MbtRenderable)hiddenComponents.get(atom);
						if (independentSet.contains(atom)){
							independentGroup.addChild(rr);
						}
						else{
							Vector rrr = (Vector)renderables.get(atom.structure);
							rrr.add(rr);
							renderablesList.add(rr);
						}
						
					}
				}
				
			}
			
			return;
		}
		
		if (visible && !vis){
			if (!dummyAtoms.contains(atom)){
				//atom needs to be added and geometry needs to be created
				MbtRenderable rr = new MbtRenderable(atom, styles, (AtomLineGeometry)defaultGeometry.get("AtomLineGeometry"));//don't translate
				if (independentSet.contains(atom)){
					independentGroup.addChild(rr);
				}
				else{
					Vector rrr = (Vector)renderables.get(atom.structure);
					rrr.add(rr);
					renderablesList.add(rr);
				}
				
				Hashtable structureHash = (Hashtable)objectHash.get(atom.structure);
				structureHash.put(atom, rr);

				dummyAtoms.add(atom);
				
				geometryViewer.setRenderables(renderablesList);
				if (update) geometryViewer.updateView();
			}
		}
		else if (!visible && !vis && dummyAtoms.contains(atom)){
			//atom is hidden along with the bonds - no dummy is needed
			//delete the geometry
			Hashtable structureHash = (Hashtable)objectHash.get(atom.structure);
			if (independentSet.contains(atom)){
				independentGroup.removeChild((GlRenderable)structureHash.get(atom));
			}
			else{
				Vector rrr = (Vector)renderables.get(atom.structure);
				rrr.remove(structureHash.get(atom));
				renderablesList.remove(structureHash.get(atom));
			}
			
			dummyAtoms.remove(atom);

			geometryViewer.setRenderables(renderablesList);
			if (update) geometryViewer.updateView();

			hiddenComponents.remove(atom);
			structureHash.remove(atom);
		}
		else if (visible && vis && dummyAtoms.contains(atom)){
			//there is at least one visible bond and the atom is visible
			//no dummy is needed
			Hashtable structureHash = (Hashtable)objectHash.get(atom.structure);
			if (independentSet.contains(atom)){
				independentGroup.removeChild((GlRenderable)structureHash.get(atom));
			}
			else{
				Vector rrr = (Vector)renderables.get(atom.structure);
				rrr.remove(structureHash.get(atom));
				renderablesList.remove(structureHash.get(atom));
			}

			dummyAtoms.remove(atom);

			geometryViewer.setRenderables(renderablesList);
			if (update) geometryViewer.updateView();

			structureHash.remove(atom);
		}
	}
	
	/**
	 * This method is a Residue-level utility optimized to run a limited check within the residue
	 * affected by a visibility event
	 * @param residue
	 * @param selected
	 */
	public void checkDummyAtoms(Residue residue){
		
		StructureStyles styles = residue.structure.getStructureMap().getStructureStyles();
		Vector atoms = residue.getAtoms();
		if (atoms == null || atoms.size() == 0) return;
		
		Hashtable structureHash = (Hashtable)objectHash.get(residue.structure);
		Vector localRenderables = (Vector)renderables.get(residue.structure);
		
		for (int i = 0; i < atoms.size(); i++){
			Atom a = (Atom)atoms.get(i);
			if (a.render != StylesPreferences.RENDERING_LINES) continue;
			
			boolean visible = a.visible;
			
			if (dummyAtoms.contains(a) && !visible){//invisible, so no dummy is needed
				
				//delete the dummy geometry
				GlRenderable r = (GlRenderable)structureHash.get(a);
				if (independentSet.contains(a)){
					independentGroup.removeChild(r);
				}
				else{
					localRenderables.remove(r);
					renderablesList.remove(r);
				}

				dummyAtoms.remove(a);
				structureHash.remove(a);
				hiddenComponents.remove(a);
				
				geometryViewer.setRenderables(renderablesList);
				geometryViewer.updateView();
				continue;
			}
			
			
			Vector bonds = residue.structure.getStructureMap().getBonds(a);
			boolean vis = false;
			if (bonds != null && bonds.size() > 0){
				for (int j = 0; j < bonds.size(); j++){
					if (((Bond)bonds.get(j)).visible){
						vis = true;
						break;
					}
				}
			}
			else{
				//a typical case with protein waters, when there are no explicit bonds
				//create a dummy
				if (visible){
					if (!dummyAtoms.contains(a)){
						//atom needs to be added and geometry needs to be created
						MbtRenderable rr = new MbtRenderable(a, styles, (AtomLineGeometry)defaultGeometry.get("AtomLineGeometry"));//don't translate
						if (independentSet.contains(a)){
							independentGroup.addChild(rr);
						}
						else{
							localRenderables.add(rr);
							renderablesList.add(rr);
						}
						structureHash.put(a, rr);

						dummyAtoms.add(a);
						
						geometryViewer.setRenderables(renderablesList);
						geometryViewer.updateView();
					}
					else{
						//show the existing dummy atom renderable
						if (dummyAtoms.contains(a)){
							if (hiddenComponents.containsKey(a)){
								MbtRenderable rr = (MbtRenderable)hiddenComponents.get(a);
								if (independentSet.contains(a)){
									independentGroup.addChild(rr);
								}
								else{
									Vector rrr = (Vector)renderables.get(a.structure);
									rrr.add(rr);
									renderablesList.add(rr);
								}
								
							}
						}
						
					}

				}
				continue;
			}
			
			if (visible && !vis){
				if (!dummyAtoms.contains(a)){
					//atom needs to be added and geometry needs to be created
					MbtRenderable rr = new MbtRenderable(a, styles, (AtomLineGeometry)defaultGeometry.get("AtomLineGeometry"));//don't translate
					if (independentSet.contains(a)){
						independentGroup.addChild(rr);
					}
					else{
						localRenderables.add(rr);
						renderablesList.add(rr);
					}
					structureHash.put(a, rr);

					dummyAtoms.add(a);
					
					geometryViewer.setRenderables(renderablesList);
					geometryViewer.updateView();
				}
			}
			else if (!visible && !vis && dummyAtoms.contains(a)){
				//atom is hidden along with the bonds - no dummy is needed
				//delete the geometry
				if (independentSet.contains(a)){
					independentGroup.removeChild((GlRenderable)structureHash.get(a));
				}
				else{
					localRenderables.remove(structureHash.get(a));
					renderablesList.remove(structureHash.get(a));
				}
				dummyAtoms.remove(a);

				geometryViewer.setRenderables(renderablesList);
				geometryViewer.updateView();

				hiddenComponents.remove(a);
				structureHash.remove(a);
			}
			else if (visible && vis && dummyAtoms.contains(a)){
				//there is at least one visible bond and the atom is visible
				//no dummy is needed
				if (independentSet.contains(a)){
					independentGroup.removeChild((GlRenderable)structureHash.get(a));
				}
				else{
					localRenderables.remove(structureHash.get(a));
					renderablesList.remove(structureHash.get(a));
				}
				
				dummyAtoms.remove(a);

				geometryViewer.setRenderables(renderablesList);
				geometryViewer.updateView();

				structureHash.remove(a);
			}
			
			
		}
		
	}
	
	
	public void checkDummyAtoms(Structure structure, boolean updateView){
		
		
		StructureStyles styles = structure.getStructureMap().getStructureStyles();
		Vector atoms = structure.getStructureMap().getAtoms();
		if (atoms == null || atoms.size() == 0) return;
		
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector localRenderables = (Vector)renderables.get(structure);
		
		//structure is partially visible or fully visible with dummy atoms, such as water O's
		//check all atoms and create/delete dummies whenever needed
		for (int i = 0; i < atoms.size(); i++){
			Atom atom = (Atom)atoms.get(i);
			if (atom.render != StylesPreferences.RENDERING_LINES) continue;
			
			boolean visible = atom.visible;
			Vector bonds = structure.getStructureMap().getBonds(atom);
			boolean vis = false;
			if (bonds != null && bonds.size() > 0){
				for (int j = 0; j < bonds.size(); j++){
					if (((Bond)bonds.get(j)).visible){
						vis = true;
						break;
					}
				}
			}
			else{
				//a typical case with protein waters, when there are no explicit bonds
				//create a dummy
				if (visible){
					if (!dummyAtoms.contains(atom)){
						//atom needs to be added and geometry needs to be created
						MbtRenderable rr = new MbtRenderable(atom, styles, (AtomLineGeometry)defaultGeometry.get("AtomLineGeometry"));//don't translate
						if (independentSet.contains(atom)){
							independentGroup.addChild(rr);
						}
						else{
							localRenderables.add(rr);
							renderablesList.add(rr);
						}
						structureHash.put(atom, rr);

						dummyAtoms.add(atom);
					}
					else if (visible){
						//show the existing dummy atom renderable
						if (dummyAtoms.contains(atom)){
							if (hiddenComponents.containsKey(atom)){
								MbtRenderable rr = (MbtRenderable)hiddenComponents.get(atom);
								if (independentSet.contains(atom)){
									independentGroup.addChild(rr);
								}
								else{
									Vector rrr = (Vector)renderables.get(atom.structure);
									rrr.add(rr);
									renderablesList.add(rr);
								}
								
							}
						}
						
					}

				}
				continue;
			}
			
			if (visible && !vis){
				if (!dummyAtoms.contains(atom)){
					//atom needs to be added and geometry needs to be created
					MbtRenderable rr = new MbtRenderable(atom, styles, (AtomLineGeometry)defaultGeometry.get("AtomLineGeometry"));//don't translate
					if (independentSet.contains(atom)){
						independentGroup.addChild(rr);
					}
					else{
						localRenderables.add(rr);
						renderablesList.add(rr);
					}
					structureHash.put(atom, rr);

					dummyAtoms.add(atom);
				}
			}
			else if (!visible && !vis && dummyAtoms.contains(atom)){
				//atom is hidden along with the bonds - no dummy is needed
				//delete the geometry
				dummyAtoms.remove(atom);
				if (independentSet.contains(atom)){
					independentGroup.removeChild((GlRenderable)structureHash.get(atom));
				}
				else{
					renderablesList.remove(structureHash.get(atom));
					localRenderables.remove(structureHash.get(atom));
				}
				hiddenComponents.remove(atom);
				structureHash.remove(atom);
			}
			else if (visible && vis && dummyAtoms.contains(atom)){
				//there is at least one visible bond and the atom is visible
				//no dummy is needed
				if (independentSet.contains(atom)){
					independentGroup.removeChild((GlRenderable)structureHash.get(atom));
				}
				else{
					localRenderables.remove(structureHash.get(atom));
					renderablesList.remove(structureHash.get(atom));
				}
				
				dummyAtoms.remove(atom);
				structureHash.remove(atom);
				
			}
			
		}
		
		geometryViewer.setRenderables(renderablesList);
		if (updateView) geometryViewer.updateView();

		
	}
	
	/**
	 * This method searches through selected atoms and determines whether any atom on the other
	 * end of any of the bonds is visible with invisible bonds or a dummy is no longer needed
	 * This way the search is only within the selected area, rather than the entire structure
	 * @param selection
	 */
	public void checkDummyAtomsSelection(StructureStyles styles){
		
		Enumeration selection = styles.getSelection().keys();

		while (selection.hasMoreElements()){
			try{
				Atom a = (Atom)selection.nextElement();
				
				//check atom's own geometries and delete/create any dummies if needed
				checkDummyAtoms(a, false);
				
				//walk over the neighbors to see if they need any dummy action
				Vector atoms = a.structure.getStructureMap().getAtoms(a);//neighbors
				if (atoms == null) continue;
				for (int j = 0; j < atoms.size(); j++){
					Atom aa = (Atom)atoms.get(j);
					checkDummyAtoms(aa, false);
				}
				
				geometryViewer.updateView();
			}
			catch (ClassCastException ex){
				continue;
				
			}
			
		}
		
		
	}
	
		
	//
	// Viewer methods
	//
	
	
	public void processStructureComponentEvent(StructureComponentEvent event){
		
		if (event.structureComponent == null) return;
		
		StructureComponent structureComponent = event.structureComponent;
		
		if (event.changeType == StructureComponentEvent.TYPE_REMOVE){
			
			if (structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_RESIDUE){
				
				//delete residue
				Residue r = (Residue)structureComponent;
				Hashtable structureHash = (Hashtable)objectHash.get(r.structure);
				Vector rvector = (Vector)renderables.get(r.structure);
				
				Vector bonds = new Vector();//to take care of their geometry
				
				for (int i = r.getAtomCount()-1; i >= 0; i--){
					Atom a = r.getAtom(i);
					Vector bb = r.structure.getStructureMap().getBonds(a);
					if (bb != null && bb.size() > 0){
						for (int k = 0 ; k< bb.size(); k++){
							Bond b = (Bond)bb.get(k);
							if (!bonds.contains(b)){
								MbtRenderable rb = (MbtRenderable)structureHash.get(b);
								if (rb != null){
									rvector.remove(rb);
									this.removeRenderable(rb);
									renderablesList.remove(rb);
								}
								structureHash.remove(b);
								this.hiddenComponents.remove(b);
								
								bonds.add(b);
							}
						}
					}
					
					MbtRenderable r1 = (MbtRenderable)structureHash.get(a);
					if (r1 != null){
						rvector.remove(r1);
						structureHash.remove(a);
						this.hiddenComponents.remove(a);
						renderablesList.remove(r1);
						this.removeRenderable(r1);
					}
					r.structure.getStructureMap().removeAtom(a);
					
					//check if this atom has any bumps
					Vector bumps = (Vector)atomToBumps.get(a);
					if (bumps != null && bumps.size() > 0){
						for (int j = bumps.size()-1; j >= 0; j--){
							removeBump((StericBumpComponent)bumps.get(j), !event.batch);
						}
					}
					
					Vector hbonds = (Vector)atomToHBonds.get(a);
					if (hbonds != null && hbonds.size() > 0){
						for (int j = hbonds.size()-1; j >= 0; j--){
							removeHBond((HydrogenBondComponent)hbonds.get(j), !event.batch);
						}
					}

					Vector monitors = (Vector)atomToMonitors.get(a);
					if (monitors != null && monitors.size() > 0){
						for (int j = monitors.size()-1; j >= 0; j--){
							removeMonitor((MonitorComponent)monitors.get(j), !event.batch);
						}
					}
					
					if (atomToLabels.containsKey(a)){
						LabelComponent c = (LabelComponent)atomToLabels.get(a);
						removeLabel(c, !event.batch);
					}

					if (atomToResidueLabels.containsKey(a)){
						ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
						removeLabel(c, !event.batch);
					}
				}
				
				if (!event.batch){
					MonitorDialog md = structureDocument.parent.getMonitorDialog();
					if (md != null) md.updateTree();
					checkDummyAtoms(r.structure, false);
					geometryViewer.updateView();
				}
				

			}
			else if (structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_ATOM){
				
				Atom a = (Atom)structureComponent;
				Hashtable structureHash = (Hashtable)objectHash.get(a.structure);
				Vector rvector = (Vector)renderables.get(a.structure);
				
				Vector bonds = new Vector();
				Vector bb = a.structure.getStructureMap().getBonds(a);
				if (bb != null && bb.size() > 0){
					for (int k = bb.size()-1 ; k >= 0; k--){
						Bond b = (Bond)bb.get(k);
						if (bonds.contains(b))continue;
						MbtRenderable r = (MbtRenderable)structureHash.get(b);
//						System.out.println("bond renderable = " + r);
						if (r != null){
							if (independentSet.contains(b)){
								independentGroup.removeChild(r);
							}
							else{
//								System.out.println("removing bond renderable");
								rvector.remove(r);
								renderablesList.remove(r);
							}
							this.removeRenderable(r);
						}
						structureHash.remove(b);
						this.hiddenComponents.remove(b);
						bonds.add(b);
					}
				}
				
//				System.out.println("renderablesList after = " + renderablesList.size());
				
				MbtRenderable r1 = (MbtRenderable)structureHash.get(a);
				if (r1 != null){
					if (independentSet.contains(a)){
						independentGroup.removeChild(r1);
					}
					else{
						rvector.remove(r1);
						renderablesList.remove(r1);
					}
					this.removeRenderable(r1);
				}
				
				structureHash.remove(a);
				this.hiddenComponents.remove(a);

				//check if this atom has any bumps
				Vector bumps = (Vector)atomToBumps.get(a);
				if (bumps != null && bumps.size() > 0){
					for (int j = bumps.size()-1; j >= 0; j--){
						removeBump((StericBumpComponent)bumps.get(j), !event.batch);
					}
				}
				Vector hbonds = (Vector)atomToHBonds.get(a);
				if (hbonds != null && hbonds.size() > 0){
					for (int j = hbonds.size()-1; j >= 0; j--){
						removeHBond((HydrogenBondComponent)hbonds.get(j), !event.batch);
					}
				}
				Vector monitors = (Vector)atomToMonitors.get(a);
				if (monitors != null && monitors.size() > 0){
					for (int j = monitors.size()-1; j >= 0; j--){
						removeMonitor((MonitorComponent)monitors.get(j), !event.batch);
					}
				}
				
				if (atomToLabels.containsKey(a)){
					LabelComponent c = (LabelComponent)atomToLabels.get(a);
					removeLabel(c, !event.batch);
				}

				if (atomToResidueLabels.containsKey(a)){
					ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
					removeLabel(c, !event.batch);
				}

				a.structure.getStructureMap().removeAtom(a);

				if (!event.batch){
					checkDummyAtoms(a.structure, false);
					geometryViewer.setRenderables(renderablesList);
					geometryViewer.updateView();
				}
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.updateTree();
				
//				System.out.println("renderablesList after = " + renderablesList.size());
//				System.out.println("rvector after = " + rvector.size());

			}
			else if (structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_BOND){
				
				Bond b = (Bond)structureComponent;
				Hashtable structureHash = (Hashtable)objectHash.get(b.structure);
				Vector rvector = (Vector)renderables.get(b.structure);
				
				GlRenderable r1 = (GlRenderable)structureHash.get(b);
				
				Vector localRenderables = (Vector)renderables.get(b.structure);
				localRenderables.remove(r1);
				structureHash.remove(b);

				renderablesList.remove(r1);
				geometryViewer.setRenderables(renderablesList);
				
				//check dummy atoms
				if (!event.batch){
					geometryViewer.updateView();
				}

				
			}
			
		}
		else if (event.changeType == StructureComponentEvent.TYPE_ADD){
			
			if (structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_ATOM){
				//delete residue
				Residue r = (Residue)structureComponent;
				Hashtable structureHash = (Hashtable)objectHash.get(r.structure);
				Vector rvector = (Vector)renderables.get(r.structure);
			
			}
			
			
			
		}
		else if (event.changeType == StructureComponentEvent.TYPE_REPLACE){
			if (structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_RESIDUE){
				
				Residue r = (Residue)structureComponent;
				String replacement = event.data;
				
				if (!ProteinProperties.isAminoAcid(replacement)){
					structureDocument.parent.displayErrorMessage("Specified replacement is not an amino acid.");
					return;
				}
				
				//get the set of atoms and bonds out of the replacement dictionary
				//and process the target residue
				SideChain sideChain = DataService.getSideChain(replacement);
				
				if (sideChain == null || sideChain.atoms.size() == 0 || 
						(sideChain.bonds.size() == 0 && !replacement.equals("GLY"))){
					structureDocument.parent.displayErrorMessage("Unable to load replacement side chain");
					return;
				}
				
				//walk through the atoms and bonds in the residue and save them to the backup object
				//for future undo
				StructureMap map = r.structure.getStructureMap();
				
				boolean addH = r.getCompoundCode().equals("PRO");//N hydrogen needs to be added in case we are replacing PRO and H's are visible
				
				
				Atom N = null;
				Atom CA = null;
				Atom C = null;
				Atom atomCB = null;
				Atom HN = null;
				Atom CD = null;//for reversal to Pro
				
				r.setCompoundCode(replacement);
				
				boolean H = false;//add hydrogens as well
				Vector bonds = new Vector();
				Vector atoms = new Vector();
				for (int i = r.getAtomCount()-1; i >= 0; i--){
					Atom a = r.getAtom(i);
					if (atomToLabels.containsKey(a)){
						LabelComponent c = (LabelComponent)atomToLabels.get(a);
						removeLabel(c, !event.batch);
					}
					
					if (atomToResidueLabels.containsKey(a)){
						ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
						removeLabel(c, !event.batch);
					}

					//check if this atom has any bumps
					Vector bumps = (Vector)atomToBumps.get(a);
					if (bumps != null && bumps.size() > 0){
						for (int j = bumps.size()-1; j >= 0; j--){
							removeBump((StericBumpComponent)bumps.get(j), !event.batch);
						}
					}
					
					Vector hbonds = (Vector)atomToHBonds.get(a);
					if (hbonds != null && hbonds.size() > 0){
						for (int j = hbonds.size()-1; j >= 0; j--){
							removeHBond((HydrogenBondComponent)hbonds.get(j), !event.batch);
						}
					}

					Vector monitors = (Vector)atomToMonitors.get(a);
					if (monitors != null && monitors.size() > 0){
						for (int j = monitors.size()-1; j >= 0; j--){
							removeMonitor((MonitorComponent)monitors.get(j), !event.batch);
						}
					}

					//now take care of the atoms
					if (a.name.equals("N")){
						N = a;
						a.compound = replacement;
						continue;
					}
					else if (a.name.equals("C")){
						C = a;
						a.compound = replacement;
						continue;
					}
					else if (a.name.equals("CA")){
						CA = a;
						a.compound = replacement;
						continue;
					}
					else if ( a.name.equals("O") || a.name.equals("2H")){
						a.compound = replacement;
						continue;
					}
					else if (a.name.equals("1H")){
						HN = a;
						a.compound = replacement;
						if (!replacement.equals("PRO")) continue;
					}
					else if (a.name.equals("HA")){
						H = true;
						a.compound = replacement;
						continue;
					}
					else if (a.name.equals("CD")){
						CD = a;
					}
					
					//all other atoms must leave :)
					atoms.add(a);
					Vector bb = map.getBonds(a);
					if (bb != null){
						for (int j = bb.size()-1; j >= 0; j--){
							if (!bonds.contains(bb.get(j))){
								bonds.add(bb.get(j));
							}
						}
					}
					//batch mode: view will be updated after new atoms are added
					map.getStructureStyles().deleteStructureComponent(a, true, true);
					
				}
				
				if (!H) addH = false;
				
				//now transform coordinates of the new atoms
				Vector newAtoms = new Vector();
				Vector newBonds = new Vector();
				
				//get the Location object for the original Residue
				double[] originalLookAt = Algebra.getNormalizedVector(CA.coordinate, N.coordinate);
				double[] temp = Algebra.getNormalizedVector(CA.coordinate, C.coordinate);
				double[] originalUp = Algebra.crossProduct(originalLookAt, temp);
				
				Location original = new Location(originalLookAt, originalUp, CA.coordinate);
				
				//get the Location for the new atom set
				Location side = sideChain.location;
				
				newAtoms = sideChain.atoms;
				newBonds = sideChain.bonds;
				
				StructureMath.transformAtomSet(side, original, newAtoms);
								
				short renderingStyle = r.getAlphaAtom().render;
				short renderingQuality = r.getAlphaAtom().quality;
				
				boolean addHtoN = false;
				Vector bbb = map.getAtoms(N);
				if (bbb.size() < 3) addHtoN = true;

				//now walk through the atoms and bonds Vectors and add them to the Residue
				for (int i = 0; i < newAtoms.size(); i++){
					Atom a = (Atom)newAtoms.get(i);
					if (!H && a.element == 1) continue;
					
					//check whether any N hydrogens need to be added
					if (a.name.equals("1H") || a.name.equals("2H")){
						if (!addHtoN) continue;
					}
					map.addAtom(a, r, false);
				}
				
				//now add bonds
				for (int i = 0; i < newBonds.size(); i++){
					if (!H){
						//check the names of the atoms that are connected
						Bond b = (Bond)newBonds.get(i);
						if (b.getAtom(0).element == 1 || b.getAtom(1).element == 1) continue;
					}
					map.addBond((Bond)newBonds.get(i));
				}
				
				for (int i = 0; i < newAtoms.size(); i++){
					Atom a = (Atom)newAtoms.get(i);
					if (!H && a.element == 1) continue;
					//check whether any N hydrogens need to be added
					if (a.name.equals("1H") || a.name.equals("2H")){
						if (!addHtoN) continue;
					}
					map.getStructureStyles().addStructureComponent((Atom)newAtoms.get(i), renderingStyle, renderingQuality, true);
				}
				
				for (int i = 0; i < newBonds.size(); i++){
					if (!H){
						//check the names of the atoms that are connected
						Bond b = (Bond)newBonds.get(i);
						if (b.getAtom(0).element == 1 || b.getAtom(1).element == 1) continue;
					}
					map.getStructureStyles().addStructureComponent((Bond)newBonds.get(i), renderingStyle, renderingQuality, true);
				}
				
				//create the bond between the CA and CB
				Atom CB = sideChain.CB;
				
				Bond b = null;
				if (replacement.equals("GLY")){
					if (H){
						b = new Bond(CA, (Atom)newAtoms.get(0));
						//rename the original atom from HA to 1HA
						Vector aaa = map.getAtoms(CA);
						for (int k = 0; k < aaa.size(); k++){
							Atom a = (Atom)aaa.get(k);
							if (a.element == 1){
								if (a == newAtoms.get(0)){
									a.name = "2HA";
								}
								else{
									a.name = "1HA";
								}
							}
						}
					}
				}
				else{
					b = new Bond(CA, CB);
				}
				
				if (b != null) {
					map.addBond(b);
					map.getStructureStyles().addStructureComponent(b, renderingStyle, renderingQuality, true);
				}
				
				//check whether the new residue is a proline and another bond is needed
				if (replacement.equals("PRO")){
					Bond bb = new Bond(N, sideChain.CD);
					map.addBond(bb);
					map.getStructureStyles().addStructureComponent(bb, renderingStyle, renderingQuality, true);
				}
				
				//check whether a PRO is being replaced and a hydrogen at N needs to be added
				if (addH){
					Bond bb = new Bond(N, sideChain.HN);
					map.addBond(bb);
					map.getStructureStyles().addStructureComponent(bb, renderingStyle, renderingQuality, true);
				}
				
				//check if the parent residue was selected
				if (map.getStructureStyles().isSelected(r)){
					for (int i = 0; i < r.getAtomCount(); i++){
						map.getStructureStyles().setSelected(r.getAtom(i), true, true, true);
					}
				}

//				geometryViewer.updateView();
				
			}
			else if (structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_ATOM){
				Atom atom = (Atom)structureComponent;
				StructureMap map = atom.structure.getStructureMap();
				
				
				Vector bonds = map.getBonds(atom);
				
				//mark renderables are dirty
				Hashtable structureHash = (Hashtable)objectHash.get(atom.structure);
				GlRenderable r1 = (GlRenderable)structureHash.get(atom);
				if (r1 != null)	r1.setDirty();
				
				
				for (int i = 0; i < bonds.size(); i++){
					GlRenderable rr = (GlRenderable)structureHash.get(bonds.get(i));
					if (rr != null) rr.setDirty();
				}
				
				StructureMath.checkHydrogens(atom, this, 7.0f, false);

				structureDocument.parent.updateView();
				
			}
		}
		
	}

	/**
	 * Process in incoming StructureStylesEvent.
	 */
	public synchronized void processStructureStylesEvent( StructureStylesEvent structureStylesEvent )
	{

		StructureComponent structureComponent = structureStylesEvent.structureComponent;
		StructureStyles structureStyles = structureStylesEvent.structureStyles;
		if (structureComponent == null){
			
			//possibly it's a general call to do a sweep selection of the given structure or another action
			if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_SELECTION){
				
//				System.out.println("global selection event");
				
				int status = structureStylesEvent.flag;
				Structure structure = structureStylesEvent.structureStyles.getStructureMap().getStructure();
				Hashtable structureHash = (Hashtable)objectHash.get(structure);
				Set keys = structureHash.keySet();
				Iterator it = keys.iterator();
/*				if (status == StructureStyles.FLAG_ALL){
					//select everything
					while (it.hasNext()){
						StructureComponent sc = (StructureComponent)it.next();
						if (sc.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
							if (structureStylesEvent.aux){
								if (selectedChains.contains(sc)){
									((MbtRenderable)structureHash.get(sc)).setDirty();
									selectedChains.remove(sc);
								}
							}
							else{
								continue;
							}
						}
						((MbtRenderable)structureHash.get(sc)).setDirty();
					}
				}
				else if (status == StructureStyles.FLAG_NONE){
*/					//deselect everything
					while (it.hasNext()){
						StructureComponent sc = (StructureComponent)it.next();
//						if (sc.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
//							if (structureStylesEvent.aux){
//								if (selectedChains.contains(sc)){
//									((MbtRenderable)structureHash.get(sc)).setDirty();
//									selectedChains.remove(sc);
//								}
//							}
//							else{
//								continue;
//							}
//						}
						((MbtRenderable)structureHash.get(sc)).setDirty();
					}
//				}
				
				if (!structureStylesEvent.batch) geometryViewer.updateView();
			}
			else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_VISIBILITY){
				//add or remove renderables from the display
				if (structureStylesEvent.flag == StructureStyles.FLAG_NONE){
					//hide everything
					//get the renderables for this structure and move them to hiddenComponents
					Structure s = structureStylesEvent.structureStyles.getStructureMap().getStructure();
					Hashtable structureHash = (Hashtable)objectHash.get(s);
					Vector localRenderables = (Vector)renderables.get(s);
					if (localRenderables == null || localRenderables.size() == 0) return;
					if (structureHash == null || structureHash.size() == 0) return;
					
					//exclude ribbons from the list: make sure the visibility state of each given chain is not changed
					//since some chains may already be hidden
					HashMap ribbons = new HashMap();
					Vector chainsVis = new Vector();
					for (int i = 0; i < s.getStructureMap().getChainCount(); i++){
						Chain chain = s.getStructureMap().getChain(i);
						if (structureHash.containsKey(chain)){
							if (!hiddenComponents.containsKey(chain)){
								ribbons.put(chain, structureHash.get(chain));
								chainsVis.add(chain);
							}
						}
					}
					
					localRenderables.clear();
					renderablesList.removeAll(structureHash.values());
					hiddenComponents.putAll(structureHash);
										
					//remove visible ribbons (chains) from hiddenComponents
					for (int i = 0; i < chainsVis.size(); i++){
						hiddenComponents.remove(chainsVis.get(i));
					}
					
					localRenderables.addAll(ribbons.values());
					renderablesList.addAll(ribbons.values());
					
					if (independentGroup != null){
						independentGroup.removeChildren();
					}
					
					//hide any cluster renderables that refer to this structure
					if (clusters.size() > 0){
						Set keys = clusters.keySet();
						Iterator it = keys.iterator();
						while (it.hasNext()){
							Cluster c = (Cluster)it.next();
							if (c.chain1.structure == s){
								c.visible1 = false;
								ClusterRenderable[] r = (ClusterRenderable[])clusters.get(c);
								renderablesList.remove(r[0]);
							}
							else if (c.chain2.structure == s){
								c.visible2 = false;
								ClusterRenderable[] r = (ClusterRenderable[])clusters.get(c);
								renderablesList.remove(r[1]);
							}
							
						}
					}
					
					
					
					
					
					//hide all monitors
					setAnnotationVisibility(false, true);
					
				}
				else if (structureStylesEvent.flag == StructureStyles.FLAG_ALL){
					//show everything
					Structure structure = structureStylesEvent.structureStyles.getStructureMap().getStructure();
					Hashtable structureHash = (Hashtable)objectHash.get(structure);
					Vector localRenderables = (Vector)renderables.get(structure);
					
					if (localRenderables == null && hiddenComponents.size() == 0){
						if (structureHash != null && structureHash.size() > 0){
							//it means that structure components are present, but their renderables have not been
							//instantiated yet - most likely, a ribbon was displayed by default
							//create the renderables and then proceed
//							System.out.println("Nothing was shown - need to create all renderables");
							createStructureRenderables(structure);
							
							//all renderables have been just added to the vector, so no need to go through the make visible process
							geometryViewer.updateView();
							return;
						}
					}
					
					if (structureHash == null) return;
					
//					System.out.println("Creating missing renderables");
					createStructureRenderables(structure);//create all missing renderables
					
					Set keys = hiddenComponents.keySet();
					Iterator it = keys.iterator();
					Vector doomed = new Vector();//structure components that need to be removed from the hidden list
					while (it.hasNext()){
						StructureComponent sc = (StructureComponent)it.next();
						if (sc.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN) continue;//skip ribbon
						if (sc.structure == structure){
							MbtRenderable rr = (MbtRenderable)hiddenComponents.get(sc);
							if (independentStructure == structure){
								if (independentSet.contains(sc)) independentGroup.addChild(rr);
							}
							else{
								localRenderables.add(rr);
								renderablesList.add(rr);
							}
							doomed.add(sc);
						}
					}
					
					for (int i = 0; i < doomed.size(); i++){
						hiddenComponents.remove(doomed.get(i));
					}
					
					setAnnotationVisibility(true, true);
					
					
					//show all cluster renderables
					if (clusters.size() > 0){
						Set ckeys = clusters.keySet();
						Iterator cit = ckeys.iterator();
						while (cit.hasNext()){
							Cluster c = (Cluster)cit.next();
							if (c.chain1.structure == structure){
								c.visible1 = true;
								ClusterRenderable[] r = (ClusterRenderable[])clusters.get(c);
								renderablesList.add(r[0]);
								r[0].setDirty();
							}
							else if (c.chain2.structure == structure){
								c.visible2 = true;
								ClusterRenderable[] r = (ClusterRenderable[])clusters.get(c);
								renderablesList.add(r[1]);
								r[1].setDirty();
							}
						}
					}
					
				}
				
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null) md.repaintTree();
				
				checkDummyAtoms(structureStylesEvent.structureStyles.getStructureMap().getStructure(), false);
				updateBoundWaters(!structureStylesEvent.batch);
				if (!structureStylesEvent.batch){
					geometryViewer.setRenderables(renderablesList);
					geometryViewer.updateView();
				}
				
			}
			else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_RIBBON_VISIBILITY){
				//add or remove renderables from the display
				if (structureStylesEvent.flag == StructureStyles.FLAG_NONE){
					//hide ribbons for this structure
					//get the ribbon renderables for this structure and move them to hiddenComponents
					Structure s = structureStylesEvent.structureStyles.getStructureMap().getStructure();
					Hashtable structureHash = (Hashtable)objectHash.get(s);
					Vector localRenderables = (Vector)renderables.get(s);
					
					if (localRenderables == null || localRenderables.size() == 0) return;
					if (structureHash == null || structureHash.size() == 0) return;
					
					for (int i = 0; i < s.getStructureMap().getChainCount(); i++){
						Chain chain = s.getStructureMap().getChain(i);
						MbtRenderable rrr = (MbtRenderable)structureHash.get(chain);
						if (rrr == null) continue;
						if (!hiddenComponents.containsKey(chain) && localRenderables.contains(rrr)){
							hiddenComponents.put(chain, rrr);
							localRenderables.remove(rrr);
							renderablesList.remove(rrr);
						}
					}
				}
				else if (structureStylesEvent.flag == StructureStyles.FLAG_ALL){
					//show everything
					Structure structure = structureStylesEvent.structureStyles.getStructureMap().getStructure();
					Hashtable structureHash = (Hashtable)objectHash.get(structure);
					Vector localRenderables = (Vector)renderables.get(structure);
					if (localRenderables == null || hiddenComponents.size() == 0) return;
					if (structureHash == null) return;
					
					for (int i = 0; i < structure.getStructureMap().getChainCount(); i++){
						Chain chain = structure.getStructureMap().getChain(i);
						MbtRenderable rrr = (MbtRenderable)structureHash.get(chain);
						if (rrr == null) continue;
						if (hiddenComponents.containsKey(chain) && !localRenderables.contains(rrr)){
							hiddenComponents.remove(chain);
							localRenderables.add(rrr);
							renderablesList.add(rrr);
						}
					}
					
				}
				if (!structureStylesEvent.batch){
					geometryViewer.setRenderables(renderablesList);
					geometryViewer.updateView();
				}
			}
			else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_STYLE){
				if (structureStylesEvent.property == StructureStyles.PROPERTY_COLOR){
					
					updateAppearance();
					
				}
			}
			
			return;
		}
		
		Structure structure = structureComponent.structure;
		StructureMap structureMap = structure.getStructureMap( );
		
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector localRenderables = (Vector)renderables.get(structure);
		MbtRenderable sceneObject = (MbtRenderable) structureHash.get( structureComponent );
		
		String structureComponentType = structureComponent.getStructureComponentType( );
		
		if ( structureComponentType == StructureComponentRegistry.TYPE_ATOM ){
			
			try{
				
				Atom a = (Atom)structureComponent;
				if (a == null) return;
				
				int atomIndex = structureMap.getAtomIndex( a );
			
				boolean lines = (a.render == StylesPreferences.RENDERING_LINES);
				
				if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_SELECTION){
					// Set the color of the Atom's Sphere.
					
					if (sceneObject != null){
						sceneObject.setDirty();
					}
					
					//bonds are taken care of here
					Vector bonds = structureMap.getBonds(a);
					if (bonds != null && bonds.size() > 0){
						for (int i = 0; i < bonds.size(); i++){
							Bond bb = (Bond)bonds.get(i);
							Object bondObject = (Object) structureHash.get( bb );
							if (bondObject != null) ((GlRenderable) bondObject).setDirty();
						}
					}
					
					//check surfaces
					for (int i = 0; i < surfaceObjects.size(); i++){
						SurfaceComponent sc = (SurfaceComponent)surfaceObjects.get(i);
						if (hiddenComponents.containsKey(sc)) continue;//the surface was hidden separately
						if (sc.getAtoms().contains(a)){
							MbtRenderable r = (MbtRenderable)structureHash.get(sc);
							r.setDirty();
						}
					}
					
					if (!structureStylesEvent.batch) geometryViewer.updateView();
	
				}
				else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_VISIBILITY){
					
//					System.out.println("atom visibility");
					if (sceneObject != null){
						//update Atom visibility
						if ((hiddenComponents.containsKey(a))&&(a.visible)){
							//the atom is currently hidden
							//add it to the display
							if (independentSet.contains(a)){
								//move the renderable to transform group renderable
								independentGroup.addChild(sceneObject);
							}
							else{
								if (!renderablesList.contains(sceneObject)){
									renderablesList.add(sceneObject);
								}
								localRenderables.add(sceneObject);
							}
							hiddenComponents.remove(a);
							
							
						}
						else if ((!hiddenComponents.containsKey(a))&&(!a.visible)){
							//the Atom visibility needs to be updated if there is atom geometry
							//it should be hidden
							if (independentSet.contains(a)){
								//move the renderable from transform group renderable
								independentGroup.removeChild(sceneObject);
							}
							else{
								localRenderables.remove(sceneObject);
								if (renderablesList.contains(sceneObject)){
									renderablesList.remove(sceneObject);
								}
							}
							hiddenComponents.put(a, sceneObject);

	//						System.out.println("hiding atom, a.render = " + a.render);
						}
					}
					else{
						//scene object = null, but atom should be present (perhaps, only a ribbon was first loaded)
						if (!lines){
							
							//create atom renderable
							createAtomRenderable(a);
						}
					}
					
					
					if (a.visible){
						//check if there are annotations associated with this atom and show them
						Vector bumps = (Vector)atomToBumps.get(a);
						if (bumps != null && bumps.size() > 0){
							for (int j = bumps.size()-1; j >= 0; j--){
								StericBumpComponent h = (StericBumpComponent)bumps.get(j);
								Atom a1 = h.atom1;
								Atom a2 = h.atom2;
								if (a1 == a){
									if (!a2.visible) continue;//hb should not be displayed if the other atom is still invisible
								}
								else if (a2 == a){
									if (!a1.visible) continue;
								}
								setAnnotationVisibility((StericBumpComponent)bumps.get(j), true, structureStylesEvent.batch);
								repaintMonitors = true;
							}
						}
						Vector hbonds = (Vector)atomToHBonds.get(a);
						if (hbonds != null && hbonds.size() > 0){
							for (int j = hbonds.size()-1; j >= 0; j--){
								HydrogenBondComponent h = (HydrogenBondComponent)hbonds.get(j);
								Atom a1 = h.atom1;
								Atom a2 = h.atom2;
								if (a1 == a){
									if (!a2.visible) continue;//hb should not be displayed if the other atom is still invisible
								}
								else if (a2 == a){
									if (!a1.visible) continue;
								}
								setAnnotationVisibility((HydrogenBondComponent)hbonds.get(j), true, structureStylesEvent.batch);
								repaintMonitors = true;
							}
						}
						Vector monitors = (Vector)atomToMonitors.get(a);
						if (monitors != null && monitors.size() > 0){
							for (int j = monitors.size()-1; j >= 0; j--){
								MonitorComponent h = (MonitorComponent)monitors.get(j);
								Atom a1 = h.atom1;
								Atom a2 = h.atom2;
								if (a1 == a){
									if (!a2.visible) continue;//hb should not be displayed if the other atom is still invisible
								}
								else if (a2 == a){
									if (!a1.visible) continue;
								}
								setAnnotationVisibility((MonitorComponent)monitors.get(j), true, structureStylesEvent.batch);
								repaintMonitors = true;
							}
						}
						if (atomToLabels.containsKey(a)){
							LabelComponent c = (LabelComponent)atomToLabels.get(a);
							setAnnotationVisibility(c, true, structureStylesEvent.batch);
							repaintMonitors = true;
						}

						if (atomToResidueLabels.containsKey(a)){
							ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
							setAnnotationVisibility(c, true, structureStylesEvent.batch);
							repaintMonitors = true;
						}

					}
					else{
						//check if there are annotations associated with this atom and hide them
						Vector bumps = (Vector)atomToBumps.get(a);
						if (bumps != null && bumps.size() > 0){
							for (int j = bumps.size()-1; j >= 0; j--){
								setAnnotationVisibility((StericBumpComponent)bumps.get(j), false, structureStylesEvent.batch);
								repaintMonitors = true;
							}
						}
						Vector hbonds = (Vector)atomToHBonds.get(a);
						if (hbonds != null && hbonds.size() > 0){
							for (int j = hbonds.size()-1; j >= 0; j--){
								setAnnotationVisibility((HydrogenBondComponent)hbonds.get(j), false, structureStylesEvent.batch);
								repaintMonitors = true;
							}
						}
						Vector monitors = (Vector)atomToMonitors.get(a);
						if (monitors != null && monitors.size() > 0){
							for (int j = monitors.size()-1; j >= 0; j--){
								setAnnotationVisibility((MonitorComponent)monitors.get(j), false, structureStylesEvent.batch);
								repaintMonitors = true;
							}
						}
						
						if (atomToLabels.containsKey(a)){
							LabelComponent c = (LabelComponent)atomToLabels.get(a);
							setAnnotationVisibility(c, false, structureStylesEvent.batch);
							repaintMonitors = true;
						}
						
						if (atomToResidueLabels.containsKey(a)){
							ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
							setAnnotationVisibility(c, false, structureStylesEvent.batch);
							repaintMonitors = true;
						}

					}
					
					//run through the bond geometries
					Vector bonds = structureMap.getBonds(a);
					if (bonds == null || bonds.size() == 0){
						if (!stopCheckDummyAtoms){
							checkDummyAtoms(a, false);
						}
						return;
					}
					
					for (int i = 0; i < bonds.size(); i++){
						Bond bond = (Bond)bonds.get(i);
						if ((hiddenComponents.containsKey(bond))&&(bond.visible)){
							//the bond is currently hidden
							//add it to the display
							GlRenderable r = (GlRenderable)structureHash.get(bond);
							if (independentSet.contains(bond)){
								//move the renderable to transform group renderable
								independentGroup.addChild(r);
							}
							else{
								localRenderables.add(structureHash.get(bond));
								if (!renderablesList.contains(r)){
									renderablesList.add(r);
								}
								
							}
							
							hiddenComponents.remove(bond);
						}
						else if ((!hiddenComponents.containsKey(bond))&&(!bond.visible)){
					
							//the Bond visibility needs to be updated
							GlRenderable r = (GlRenderable)structureHash.get(bond);
							if (independentSet.contains(bond)){
								//move the renderable to transform group renderable
								independentGroup.removeChild(r);
							}
							else{
								localRenderables.remove(r);
								if (renderablesList.contains(r)){
									renderablesList.remove(r);
								}
							}
							hiddenComponents.put(bond, r);

						}
						
						if (!stopCheckDummyAtoms){
							checkDummyAtoms(bond);
						}
						
					}
					
					//check surfaces
					for (int i = 0; i < surfaceObjects.size(); i++){
						SurfaceComponent sc = (SurfaceComponent)surfaceObjects.get(i);
						if (sc.getAtoms().contains(a)){
							MbtRenderable r = (MbtRenderable)structureHash.get(sc);
							r.setDirty();
							if (hiddenComponents.containsKey(sc)){
								renderablesList.add(r);
								hiddenComponents.remove(sc);
							}
						}
					}

					
					geometryViewer.setRenderables(renderablesList);
					if (!structureStylesEvent.batch) geometryViewer.updateView();


				}
				else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_STYLE){
					if (structureStylesEvent.property == StructureStyles.PROPERTY_RENDERING){
						
//						System.out.println("atom rendering style called: sceneObject = " + sceneObject);
						
						if (sceneObject != null){
							if (((MbtRenderable)sceneObject).getGeometry() instanceof AtomLineGeometry || lines){
								//remove the old scene object first
								if (renderablesList.contains(sceneObject)){
									renderablesList.remove(sceneObject);
									
								}
								else{
									//check whether the atom is a part of an independent group
									if (independentSet != null && independentSet.contains(structureComponent)){
//										System.out.println("Removing renderable");
										independentGroup.removeChild(sceneObject);
									}
								}
								
								localRenderables.remove(sceneObject);
								hiddenComponents.remove(a);
								structureHash.remove(a);
								sceneObject = null;
								
								if (dummyAtoms.contains(a)) dummyAtoms.remove(a);
								
								if (!structureStylesEvent.batch){
									geometryViewer.updateView();
								}

							}
						}
						
						//it's non-lines
						if (a.render == StylesPreferences.RENDERING_STICK){
							AtomRadiusByConstant r = (AtomRadiusByConstant)AtomRadiusRegistry.get(AtomRadiusByConstant.NAME);
							r.setRadius(StylesPreferences.stickSize);
							structureStyles.setAtomRadius(a, r);
							//check if atom was already displayed - then simply update the renderable
							if (sceneObject != null){
								sceneObject.setDirty();
								
								if (atomToLabels.containsKey(a)){
									LabelComponent c = (LabelComponent)atomToLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

								if (atomToResidueLabels.containsKey(a)){
									ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

							}
							else{
								MbtRenderable m = new MbtRenderable( a, structureStyles, (AtomGeometry)defaultGeometry.get("AtomGeometry") );//don't translate
								if (independentSet != null && independentSet.contains(a)){
									//add it to the independentGroup
									if (a.visible){
										independentGroup.addChild(m);
									}
									else{
										hiddenComponents.put(structureComponent, m);
									}
									if (!structureStylesEvent.batch) geometryViewer.updateView();
								}
								else{
									if (a.visible){
										localRenderables.add(m);
										renderablesList.add(m);
									}
									else{
										hiddenComponents.put(structureComponent, m);
									}
								}
								structureHash.put(a, m);
								
								if (atomToLabels.containsKey(a)){
									LabelComponent c = (LabelComponent)atomToLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

								if (atomToResidueLabels.containsKey(a)){
									ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

							}
						}
						else if (a.render == StylesPreferences.RENDERING_BALL_STICK){
							//the rendering is changing from cpk to ball and stick
							if (StylesPreferences.ballRadiusOption == StylesPreferences.ATOMIC_RADIUS){
								structureStyles.setAtomRadius(a, AtomRadiusRegistry.get(AtomRadiusByScaledCpk.NAME));
							}
							else{
								AtomRadiusByConstant r = (AtomRadiusByConstant)AtomRadiusRegistry.get(AtomRadiusByConstant.NAME);
								r.setRadius(StylesPreferences.ballRadius);
								structureStyles.setAtomRadius(a, r);
							}
							
							if (sceneObject != null){
								sceneObject.setDirty();
								
								if (atomToLabels.containsKey(a)){
									LabelComponent c = (LabelComponent)atomToLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

								if (atomToResidueLabels.containsKey(a)){
									ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

							}
							else{
								MbtRenderable m = new MbtRenderable( a, structureStyles, (AtomGeometry)defaultGeometry.get("AtomGeometry") );//don't translate
								if (a.visible){
									if (independentSet != null && independentSet.contains(a)){
										independentGroup.addChild(m);
									}
									else{
										localRenderables.add(m);
										renderablesList.add(m);
										geometryViewer.setRenderables(renderablesList);
									}
									if (!structureStylesEvent.batch) geometryViewer.updateView();
								}
								else{
									hiddenComponents.put(a, m);
								}
								structureHash.put(a, m);
								
								if (atomToLabels.containsKey(a)){
									LabelComponent c = (LabelComponent)atomToLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

								if (atomToResidueLabels.containsKey(a)){
									ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

							}
						}
						else if (a.render == StylesPreferences.RENDERING_CPK){
							
							//the rendering is changing from ball and stick to cpk
							structureStyles.setAtomRadius(a, AtomRadiusRegistry.get(AtomRadiusByCpk.NAME));
							if (sceneObject != null){
								sceneObject.setDirty();
								if (atomToLabels.containsKey(a)){
									LabelComponent c = (LabelComponent)atomToLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}
								if (atomToResidueLabels.containsKey(a)){
									ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

							}
							else{
								MbtRenderable m = new MbtRenderable( a, structureStyles, (AtomGeometry)defaultGeometry.get("AtomGeometry"));//don't translate
								if (a.visible){
									if (independentSet != null && independentSet.contains(a)){
										independentGroup.addChild(m);
									}
									else{
										localRenderables.add(m);
										renderablesList.add(m);
									}
									if (!structureStylesEvent.batch) geometryViewer.updateView();
								}
								else{
									hiddenComponents.put(a, m);
								}
								structureHash.put(a, m);
								
								if (atomToLabels.containsKey(a)){
									LabelComponent c = (LabelComponent)atomToLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

								if (atomToResidueLabels.containsKey(a)){
									ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
									GlRenderable rr = (GlRenderable)labels.get(c);
									rr.setDirty();
								}

							}
						}

						if (!structureStylesEvent.batch){
							checkDummyAtoms(a, true);
						}
						
					}
					else if ( structureStylesEvent.property == StructureStyles.PROPERTY_RADIUS && sceneObject != null) {
						if (lines) return;
						sceneObject.setDirty();
						
						if (atomToLabels.containsKey(a)){
							LabelComponent c = (LabelComponent)atomToLabels.get(a);
							GlRenderable rr = (GlRenderable)labels.get(c);
							rr.setDirty();
						}

						if (atomToResidueLabels.containsKey(a)){
							ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
							GlRenderable rr = (GlRenderable)labels.get(c);
							rr.setDirty();
						}

					}
					else if (structureStylesEvent.property == StructureStyles.PROPERTY_COLOR){
						
						Vector bonds = (Vector)a.structure.getStructureMap().getBonds(a);
						if (bonds != null){
							for (int i = 0; i < bonds.size(); i++){
								try{
									Bond bb = (Bond)bonds.get(i);
									Object bondObject = (Object) structureHash.get( bb );
									if (bondObject == null)continue;
									((GlRenderable) bondObject).setDirty();
								}
								catch (Exception ex){
									continue;
								}
							}
						}
						
						
						//check surfaces
						for (int i = 0; i < surfaceObjects.size(); i++){
							SurfaceComponent sc = (SurfaceComponent)surfaceObjects.get(i);
							if (sc.getAtoms().contains(a)){
								MbtRenderable r = (MbtRenderable)structureHash.get(sc);
								r.setDirty();
//								if (hiddenComponents.containsKey(sc)){
//									renderablesList.add(r);
//									hiddenComponents.remove(sc);
//								}
							}
						}
						
						
							
						if (sceneObject != null){
							((GlRenderable)structureHash.get(a)).setDirty();
						}
						
					}

				}
				
				geometryViewer.setRenderables(renderablesList);
				if (!structureStylesEvent.batch){
					geometryViewer.updateView();
				}
			
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception processing atom style event", ex);
			}

		}
		else if (structureComponentType == StructureComponentRegistry.TYPE_BOND ){
		
			
			Bond bond = (Bond)structureComponent;
			
			if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_VISIBILITY){
				
				if (!structureHash.containsKey(bond) && bond.render != StylesPreferences.RENDERING_CPK){
					//we need to create a renderable


					MbtRenderable m = new MbtRenderable( bond, structureStyles, (BondGeometry)defaultGeometry.get("BondGeometry") );//don't translate
					structureHash.put(bond, m);
					if (StylesPreferences.renderingMode == StylesPreferences.RENDERING_STICK){
						structureStyles.setBondRadius(bond, BondRadiusByAtomRadius.create());
					}
					else if (StylesPreferences.renderingMode == StylesPreferences.RENDERING_BALL_STICK){
						structureStyles.setBondRadius(bond, BondRadiusAsStick.create());
					}

				}
				
				if ((hiddenComponents.containsKey(bond))&&(bond.visible)){
					//the bond is currently hidden
					//add it to the display
					GlRenderable r = (GlRenderable)structureHash.get(bond);
					if (independentSet != null && independentSet.contains(bond)){
						independentGroup.addChild(r);
					}
					else{
						if (!renderablesList.contains(r)){
							localRenderables.add(structureHash.get(bond));
							renderablesList.add(r);
						}
					}
					
					hiddenComponents.remove(bond);
				}
				else if ((!hiddenComponents.containsKey(bond))&&(!bond.visible)){
			
					//the Bond visibility needs to be updated
					if (independentSet != null && independentSet.contains(bond)){
						independentGroup.removeChild(sceneObject);
					}
					else{
						if (renderablesList.contains(sceneObject)){
							localRenderables.remove(sceneObject);
							renderablesList.remove(sceneObject);
						}
					}
					hiddenComponents.put(bond, sceneObject);
				}
				else if (!hiddenComponents.containsKey(bond) && (bond.visible)){
					//in other words, this is probably a new bond and has not been added yet
					if (!structureHash.containsKey(bond)){
						//a new geometry needs to be created
						if (StylesPreferences.structureView != StylesPreferences.RENDERING_CPK){
							
							MbtRenderable m = new MbtRenderable( bond, structureStyles, (BondGeometry)defaultGeometry.get("BondGeometry") );//don't translate
							structureHash.put(bond, m);
							if (bond.visible){
								localRenderables.add(m);
								renderablesList.add(m);
							}
							else{
								hiddenComponents.put(bond, m);
							}
						}
					}
				}
				
				if (!stopCheckDummyAtoms) checkDummyAtoms(bond);

			}
			else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_SELECTION){
				if (sceneObject == null) return;
				sceneObject.setDirty();
				
				//this should never be called: bond selection is done through its atoms indirectly
			}
			else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_STYLE){
			
				if (structureStylesEvent.property == StructureStyles.PROPERTY_COLOR){
					if (sceneObject == null) return;
					sceneObject.setDirty();
				}
				else if (structureStylesEvent.property == StructureStyles.PROPERTY_RENDERING){
					
//					System.out.println("bond rendering style called");
					
					//check whether the requested geometry is cpk
					short style = ((Bond)structureComponent).render;
					if (sceneObject != null && style == StylesPreferences.RENDERING_CPK){
						//remove the old scene object first
						if (renderablesList.contains(sceneObject)){
							renderablesList.remove(sceneObject);
						}
						else{
							if (independentGroup != null) independentGroup.removeChild(sceneObject);
						}
						localRenderables.remove(sceneObject);
						hiddenComponents.remove(bond);
						structureHash.remove(bond);
					}
					
					if (bond.render == StylesPreferences.RENDERING_STICK){
//						System.out.println("bond stick event");
						//create a stick representation of the bond instead of the old one
						structureStyles.setBondRadius(bond, BondRadiusByAtomRadius.create());
						if (sceneObject != null){
							sceneObject.setDirty();
							if (hiddenComponents.containsKey(bond)){
								if (bond.visible){
									renderablesList.add(sceneObject);
									localRenderables.add(sceneObject);
									hiddenComponents.remove(bond);
								}
							}
						}
						else{
							MbtRenderable m = new MbtRenderable( bond, structureStyles, (BondGeometry)defaultGeometry.get("BondGeometry") );//don't translate
							structureHash.put(bond, m);
							if (bond.visible){
								if (independentSet != null && independentSet.contains(bond)){
									independentGroup.addChild(m);
								}
								else{
									localRenderables.add(m);
									renderablesList.add(m);
								}
								if (!structureStylesEvent.batch) geometryViewer.updateView();
							}
							else{
								hiddenComponents.put(bond, m);
							}
						}
					}
					else if (bond.render == StylesPreferences.RENDERING_BALL_STICK){
//						System.out.println(bond + ": bond ball-stick event");
						//the rendering is changing from lines to ball and stick
						structureStyles.setBondRadius(bond, BondRadiusAsStick.create());
						if (sceneObject != null){
							sceneObject.setDirty();
							if (hiddenComponents.containsKey(bond)){
								if (bond.visible){
									renderablesList.add(sceneObject);
									localRenderables.add(sceneObject);
									hiddenComponents.remove(bond);
								}
							}
						}
						else{
							MbtRenderable m = new MbtRenderable( bond, structureStyles, (BondGeometry)defaultGeometry.get("BondGeometry") );//don't translate
							if (bond.visible){
								if (independentSet != null && independentSet.contains(bond)){
									independentGroup.addChild(m);
								}
								else{
									localRenderables.add(m);
									renderablesList.add(m);
								}
								if (!structureStylesEvent.batch) geometryViewer.updateView();
							}
							else{
//								System.out.println("Added bond to hiddenComponents");
								hiddenComponents.put(bond, m);
							}
							structureHash.put(bond, m);
						}
					}
					else if (bond.render == StylesPreferences.RENDERING_LINES){
						if (sceneObject != null){
							sceneObject.setDirty();
						}
						else{
							try{
//								System.out.println("created renderable");
								MbtRenderable m = new MbtRenderable( bond, structureStyles, (BondGeometry)defaultGeometry.get("BondGeometry") );//don't translate
								if (bond.visible){
									if (independentSet != null && independentSet.contains(bond)){
										independentGroup.addChild(m);
									}
									else{
										localRenderables.add(m);
										renderablesList.add(m);
									}
//									if (!structureStylesEvent.batch) geometryViewer.updateView();
								}
								else{
									hiddenComponents.put(bond, m);
								}
								structureHash.put(bond, m);
							}
							catch (Exception e){
								e.printStackTrace();
							}
						}
					
					}
				}
			}
			
			geometryViewer.setRenderables(renderablesList);
			if (!structureStylesEvent.batch) geometryViewer.updateView();
		}

		else if (structureComponentType == StructureComponentRegistry.TYPE_RESIDUE ){
			
			//not all residues have representation in the structure
			try{
				Residue residue = (Residue)structureComponent;
				if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_VISIBILITY){
					
					Vector bonds = new Vector();
					Vector atoms = residue.getAtoms();
					for (int i = 0; i < atoms.size(); i++){
						Atom a = (Atom)atoms.get(i);
						
						if (!structureHash.containsKey(a) && a.render != StylesPreferences.RENDERING_LINES){
							//we need to create atom renderable
							createAtomRenderable(a);
							
						}
						
						//handle atom visibility
						GlRenderable ar = (GlRenderable)structureHash.get(a);
						if (ar != null && !dummyAtoms.contains(a)){
							//update Atom visibility
							if ((hiddenComponents.containsKey(a))&&(a.visible)){
								//the atom is currently hidden
								//add it to the display
								if (independentSet.contains(a)){
									independentGroup.addChild(ar);
								}
								else{
									if (!renderablesList.contains(ar)){
										localRenderables.add(ar);
										renderablesList.add(ar);
									}
								}
								
								hiddenComponents.remove(a);
							}
							else if ((!hiddenComponents.containsKey(a))&&(!a.visible)){
								//the Atom visibility needs to be updated if there is atom geometry
								//it should be hidden
								if (independentSet.contains(a)){
									independentGroup.removeChild(ar);
								}
								else{
									if (renderablesList.contains(ar)){
										localRenderables.remove(ar);
										renderablesList.remove(ar);
									}
								}
								hiddenComponents.put(a, ar);
							}
						}
						
						if (a.visible){
							//check if there are annotations associated with this atom and show them
							Vector bumps = (Vector)atomToBumps.get(a);
							if (bumps != null && bumps.size() > 0){
								for (int j = bumps.size()-1; j >= 0; j--){
									setAnnotationVisibility((StericBumpComponent)bumps.get(j), true, structureStylesEvent.batch);
									repaintMonitors = true;
								}
							}
							Vector hbonds = (Vector)atomToHBonds.get(a);
							if (hbonds != null && hbonds.size() > 0){
								for (int j = hbonds.size()-1; j >= 0; j--){
									setAnnotationVisibility((HydrogenBondComponent)hbonds.get(j), true, structureStylesEvent.batch);
									repaintMonitors = true;
								}
							}
							Vector monitors = (Vector)atomToMonitors.get(a);
							if (monitors != null && monitors.size() > 0){
								for (int j = monitors.size()-1; j >= 0; j--){
									setAnnotationVisibility((MonitorComponent)monitors.get(j), true, structureStylesEvent.batch);
									repaintMonitors = true;
								}
							}
							
							if (atomToLabels.containsKey(a)){
								LabelComponent c = (LabelComponent)atomToLabels.get(a);
								setAnnotationVisibility(c, true, structureStylesEvent.batch);
								repaintMonitors = true;
							}
							if (atomToResidueLabels.containsKey(a)){
								ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
								setAnnotationVisibility(c, true, structureStylesEvent.batch);
								repaintMonitors = true;
							}
						}
						else{
							//check if there are annotations associated with this atom and hide them
							Vector bumps = (Vector)atomToBumps.get(a);
							if (bumps != null && bumps.size() > 0){
								for (int j = bumps.size()-1; j >= 0; j--){
									setAnnotationVisibility((StericBumpComponent)bumps.get(j), false, structureStylesEvent.batch);
									repaintMonitors = true;
								}
							}
							Vector hbonds = (Vector)atomToHBonds.get(a);
							if (hbonds != null && hbonds.size() > 0){
								for (int j = hbonds.size()-1; j >= 0; j--){
									setAnnotationVisibility((HydrogenBondComponent)hbonds.get(j), false, structureStylesEvent.batch);
									repaintMonitors = true;
								}
							}
							Vector monitors = (Vector)atomToMonitors.get(a);
							if (monitors != null && monitors.size() > 0){
								for (int j = monitors.size()-1; j >= 0; j--){
									setAnnotationVisibility((MonitorComponent)monitors.get(j), false, structureStylesEvent.batch);
									repaintMonitors = true;
								}
							}
							
							if (atomToLabels.containsKey(a)){
								LabelComponent c = (LabelComponent)atomToLabels.get(a);
								setAnnotationVisibility(c, false, structureStylesEvent.batch);
								repaintMonitors = true;
							}

							if (atomToResidueLabels.containsKey(a)){
								ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(a);
								setAnnotationVisibility(c, false, structureStylesEvent.batch);
								repaintMonitors = true;
							}
						}

						
						//check the bonds
						Vector bb = structureMap.getBonds(a);
						if (bb != null){
							for (int j = 0; j < bb.size(); j++){
								if (!bonds.contains(bb.get(j))){
									bonds.add(bb.get(j));
								}
							}
						}
						else{
							checkDummyAtoms(a, false);
						}
					}
					
					//now run through the non-redundant list of bonds
					for (int i = 0; i < bonds.size(); i++){
						
						Bond bond = (Bond)bonds.get(i);
						
						if (!structureHash.containsKey(bond) && bond.render != StylesPreferences.RENDERING_CPK){
							MbtRenderable m = new MbtRenderable( bond, structureStyles, (BondGeometry)defaultGeometry.get("BondGeometry") );//don't translate
							structureHash.put(bond, m);
							if (StylesPreferences.renderingMode == StylesPreferences.RENDERING_STICK){
								structureStyles.setBondRadius(bond, BondRadiusByAtomRadius.create());
							}
							else if (StylesPreferences.renderingMode == StylesPreferences.RENDERING_BALL_STICK){
								structureStyles.setBondRadius(bond, BondRadiusAsStick.create());
							}
							
							if (bond.visible){
								if (independentSet.contains(bond)){
									independentGroup.addChild(m);
								}
								else{
									if (!renderablesList.contains(m)){
										localRenderables.add(structureHash.get(bond));
										renderablesList.add(m);
									}
								}
							}
							else{
								hiddenComponents.put(bond, m);
							}
						}
						
						if ((hiddenComponents.containsKey(bond))&&(bond.visible)){
							//the bond is currently hidden
							//add it to the display
							GlRenderable r = (GlRenderable)structureHash.get(bond);
							if (independentSet.contains(bond)){
								independentGroup.addChild(r);
							}
							else{
								if (!renderablesList.contains(r)){
									localRenderables.add(structureHash.get(bond));
									renderablesList.add(r);
								}
							}
							hiddenComponents.remove(bond);
						}
						else if ((!hiddenComponents.containsKey(bond))&&(!bond.visible)){
					
							//the Bond visibility needs to be updated
							GlRenderable r = (GlRenderable)structureHash.get(bond);
							if (independentSet.contains(bond)){
								independentGroup.removeChild(r);
							}
							else{
								if (renderablesList.contains(r)){
									localRenderables.remove(r);
									renderablesList.remove(r);
								}
							}
							hiddenComponents.put(bond, r);

						}

					}
					
					Vector surfaces = new Vector();//surface components that need to be repainted
					for (int i = 0; i < surfaceObjects.size(); i++){
						SurfaceComponent sc = (SurfaceComponent)surfaceObjects.get(i);
						for (int j = 0; j < residue.getAtomCount(); j++){
							if (sc.getAtoms().contains(residue.getAtom(j))){
								if (!surfaces.contains(sc)) surfaces.add(sc);
								break;
							}
						}
					}
					
					for (int i = 0; i < surfaces.size(); i++){
						SurfaceComponent sc = (SurfaceComponent)surfaces.get(i);
						MbtRenderable sr = (MbtRenderable) structureHash.get(sc);
						if (hiddenComponents.containsKey(sc)){
							hiddenComponents.remove(sc);
							renderablesList.add(sr);
						}
						sr.setDirty();
					}

					
					geometryViewer.setRenderables(renderablesList);

					//run dummy check
					if (!stopCheckDummyAtoms){
						checkDummyAtoms(residue);
					}
				}
				else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_SELECTION){
					
					//residue representation in the ribbon or constituent atoms needs to be updated
					//get the renderables and set them dirty
					Vector atoms = residue.getAtoms();
					Vector bonds = new Vector();
					for (int i = 0; i < atoms.size(); i++){
						Atom a = (Atom)atoms.get(i);
						MbtRenderable r = (MbtRenderable)structureHash.get(a);
						if (r != null) r.setDirty();
						Vector inner = structureMap.getBonds(a);
						if (inner == null) continue;
						for (int j = 0; j < inner.size(); j++){
							Bond b = (Bond)inner.get(j);
							if (bonds.contains(b))continue;//to avoid repeated calls
							MbtRenderable rb = (MbtRenderable) structureHash.get(b);
							if (rb == null) continue;
							rb.setDirty();
							bonds.add(b);
						}
					}
					
					
					Vector surfaces = new Vector();//surface components that need to be repainted
					for (int i = 0; i < surfaceObjects.size(); i++){
						SurfaceComponent sc = (SurfaceComponent)surfaceObjects.get(i);
						for (int j = 0; j < residue.getAtomCount(); j++){
							if (sc.getAtoms().contains(residue.getAtom(j))){
								if (!surfaces.contains(sc)) surfaces.add(sc);
								break;
							}
						}
					}
					
					for (int i = 0; i < surfaces.size(); i++){
						SurfaceComponent sc = (SurfaceComponent)surfaces.get(i);
						MbtRenderable sr = (MbtRenderable) structureHash.get(sc);
						sr.setDirty();
					}
					
					if (!structureStylesEvent.batch) geometryViewer.updateView();
				}
				else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_STYLE){
					if (structureStylesEvent.property == StructureStyles.PROPERTY_COLOR){
						
						AtomColor atomColor = null;
						
						if (structureStyles.getResidueColor(residue) instanceof ResidueColorByElement 
								|| structureStyles.getResidueColor(residue) instanceof ResidueColorDefault){
							atomColor = AtomColorRegistry.get(AtomColorByElement.NAME);
						}
						else if (structureStyles.getResidueColor(residue) instanceof ResidueColorByCharge){
							atomColor = AtomColorByCharge.create();
						}
						else{
							//generate the necessary AtomColor
							float color[] = new float[3];
							(structureStyles.getResidueColor(residue)).getResidueColor(residue, color);
//							System.out.println("Requested color = " + color[0] + "," + color[1] + "," + color[2]);
							Color residueColor = new Color(color[0], color[1], color[2]);
							atomColor = AtomColorFactory.getAtomColor(residueColor);
						}
						
						//iterate over all atoms contained in this Residue
						Vector atoms = residue.getAtoms();
					
						for (int i = 0; i < residue.getAtomCount(); i++){
							Atom a = residue.getAtom(i);
							MbtRenderable object = (MbtRenderable)structureHash.get(a);
							
							structureStyles.setAtomColor(a, atomColor, false, true);
							
							if (object != null){
								object.setDirty();
							}
							
							Vector bonds = (Vector)a.structure.getStructureMap().getBonds(a);
							if (bonds == null){
								continue;
							}
							for (int j = 0; j < bonds.size(); j++){
								try{
									Bond bb = (Bond)bonds.get(j);
									Object bondObject = (Object) structureHash.get( bb );
									if (bondObject == null) continue;
									((MbtRenderable) bondObject).setDirty();
								}
								catch (Exception ex){
									continue;
								}
							}
							
							if (structureHash.get(a) != null) ((MbtRenderable)structureHash.get(a)).setDirty();
	
						}
						
						Vector surfaces = new Vector();//surface components that need to be repainted
						for (int i = 0; i < surfaceObjects.size(); i++){
							SurfaceComponent sc = (SurfaceComponent)surfaceObjects.get(i);
							for (int j = 0; j < residue.getAtomCount(); j++){
								if (sc.getAtoms().contains(residue.getAtom(j))){
									if (!surfaces.contains(sc)) surfaces.add(sc);
									break;
								}
							}
						}
						
						for (int i = 0; i < surfaces.size(); i++){
							SurfaceComponent sc = (SurfaceComponent)surfaces.get(i);
							if (hiddenComponents.containsKey(sc)) continue;//the surface was hidden separately
							MbtRenderable sr = (MbtRenderable) structureHash.get(sc);
							sr.setDirty();
						}

						
						if (!structureStylesEvent.batch) geometryViewer.updateView();
					}
					else if (structureStylesEvent.property == StructureStyles.PROPERTY_RIBBON_COLOR){
						
						Chain c = residue.structure.getStructureMap().getChain(residue.getAtom(0));
						MbtRenderable rr = (MbtRenderable)structureHash.get(c);
						if (rr != null) rr.setDirty();
						
					}
				}
				
				if (!structureStylesEvent.batch) geometryViewer.updateView();
	
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("StructureViewer: Exception processing residue style event", ex);
				ex.printStackTrace();
				return;
			}
		}
		else if (structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){

			
			//not all residues have representation in the structure
		
			try{
				Chain chain = (Chain)structureComponent;
				if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_VISIBILITY){
					
					//check whether it's a ribbon event
					if (structureStylesEvent.property == StructureStyles.PROPERTY_RIBBON_VISIBILITY){
						MbtRenderable rr = (MbtRenderable)structureHash.get(chain);
						if (rr == null){
							//ribbon has not been created yet - make it
							this.createRibbon(chain, StylesPreferences.RIBBON_RENDERED, StylesPreferences.ribbonQuality, StylesPreferences.ribbonDiameter, true);
							return;
						}
						if (structureStyles.isRibbonVisible(chain) && hiddenComponents.containsKey(chain)){
							
							localRenderables.add(rr);
							if (!renderablesList.contains(rr)){
								renderablesList.add(rr);
							}
							hiddenComponents.remove(chain);
						}
						else if (!structureStyles.isRibbonVisible(chain) && !hiddenComponents.containsKey(chain)){
							//hide it
							localRenderables.remove(rr);
							if (renderablesList.contains(rr)){
								renderablesList.remove(rr);
							}
							hiddenComponents.put(chain, rr);
						}
						
						updateAppearance();

						return;
					}
					
					Vector residues = structureMap.getResidues();
					Vector bonds = new Vector();
					
					for (int i = 0; i < residues.size(); i++){
						Residue r = (Residue)residues.get(i);
						if (!r.getChainId().equals(chain.getChainId())) continue;
						
						Vector atoms = r.getAtoms();
						for (int j = 0; j < atoms.size(); j++){
							Atom a = (Atom)atoms.get(j);
							
							if (!structureHash.containsKey(a) && a.render != StylesPreferences.RENDERING_LINES){
								//we need to create atom renderable
								createAtomRenderable(a);
							}
							
							//handle atom visibility
							GlRenderable ar = (GlRenderable)structureHash.get(a);
							if (ar != null && !dummyAtoms.contains(a)){
								//update Atom visibility
								if ((hiddenComponents.containsKey(a))&&(a.visible)){
									//the atom is currently hidden
									//add it to the display
									localRenderables.add(ar);
									renderables.put(a.structure, localRenderables);
									
									if (!renderablesList.contains(ar)){
										renderablesList.add(ar);
									}
									hiddenComponents.remove(a);
								}
								else if ((!hiddenComponents.containsKey(a))&&(!a.visible)){
									//the Atom visibility needs to be updated if there is atom geometry
									//it should be hidden
									if (renderablesList.contains(ar)){
										renderablesList.remove(ar);
									}
									localRenderables.remove(ar);
									hiddenComponents.put(a, ar);
								}
							}
							
							//check the bonds
							Vector bb = structureMap.getBonds(a);
							if (bb != null){
								for (int k = 0; k < bb.size(); k++){
									if (!bonds.contains(bb.get(k))){
										bonds.add(bb.get(k));
									}
								}
							}
							else{
								checkDummyAtoms(a, false);
							}
						}
					}
					
					
					//now run through the non-redundant list of bonds
					for (int i = 0; i < bonds.size(); i++){
						
						Bond bond = (Bond)bonds.get(i);
						
						if (!structureHash.containsKey(bond) && bond.render != StylesPreferences.RENDERING_CPK){
							MbtRenderable m = new MbtRenderable( bond, structureStyles, (BondGeometry)defaultGeometry.get("BondGeometry") );//don't translate
							structureHash.put(bond, m);
							if (StylesPreferences.renderingMode == StylesPreferences.RENDERING_STICK){
								structureStyles.setBondRadius(bond, BondRadiusByAtomRadius.create());
							}
							else if (StylesPreferences.renderingMode == StylesPreferences.RENDERING_BALL_STICK){
								structureStyles.setBondRadius(bond, BondRadiusAsStick.create());
							}
							
							if (bond.visible){
								if (independentSet.contains(bond)){
									independentGroup.addChild(m);
								}
								else{
									if (!renderablesList.contains(m)){
										localRenderables.add(structureHash.get(bond));
										renderablesList.add(m);
									}
								}
							}
							else{
								hiddenComponents.put(bond, m);
							}
						}
						
						if ((hiddenComponents.containsKey(bond))&&(bond.visible)){
							//the bond is currently hidden
							//add it to the display
							GlRenderable r = (GlRenderable)structureHash.get(bond);
							localRenderables.add(structureHash.get(bond));
							
							hiddenComponents.remove(bond);
							if (!renderablesList.contains(r)){
								renderablesList.add(r);
							}
						}
						else if ((!hiddenComponents.containsKey(bond))&&(!bond.visible)){
					
							//the Bond visibility needs to be updated
							GlRenderable r = (GlRenderable)structureHash.get(bond);
							localRenderables.remove(r);
							hiddenComponents.put(bond, r);

							if (renderablesList.contains(r)){
								renderablesList.remove(r);
							}
						}

					}
										
					//run dummy check
					if (!stopCheckDummyAtoms){
//						System.out.println("checking dummy atoms");
						checkDummyAtoms(chain.structure, false);
					}
					
//					System.out.println("updating appearance");
					updateAppearance();
				}
				else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_STYLE){
					if (structureStylesEvent.property == StructureStyles.PROPERTY_COLOR){
						
						AtomColor atomColor = null;
						//take the first residue as the reference
						Vector residues = new Vector();//list of residues in this chain
						Vector rr = structureMap.getResidues();
						for (int i = 0; i < rr.size(); i++){
							
							Residue r = (Residue)rr.get(i);
							if (!(r.getChainId().equals(chain.getChainId())))continue;
							residues.add(r);
						}
		
						if (structureStyles.getResidueColor(chain) instanceof ResidueColorByElement){
							atomColor = AtomColorRegistry.get(AtomColorByElement.NAME);
						}
						else if (structureStyles.getResidueColor(chain) instanceof ResidueColorByCharge){
							atomColor = AtomColorByCharge.create();
						}
						else{
							//generate the necessary AtomColor
							float color[] = new float[3];
							(structureStyles.getResidueColor(chain)).getResidueColor((Residue)residues.get(0), color);
							Color residueColor = new Color(color[0], color[1], color[2]);
							atomColor = AtomColorFactory.getAtomColor(residueColor);
						}
						
						//iterate over the chosen residues
						for (int i = 0; i < residues.size(); i++){
							Residue residue = (Residue)residues.get(i);
							
							//iterate over all atoms contained in this Residue
							Vector atoms = residue.getAtoms();
						
							for (int j = 0; j < residue.getAtomCount(); j++){
								Atom a = residue.getAtom(j);
								MbtRenderable object = (MbtRenderable)structureHash.get(a);
								
								structureStyles.setAtomColor(a, atomColor, false, true);
								
								if (object != null){
									object.setDirty();
								}
								
								Vector bb = (Vector)a.structure.getStructureMap().getBonds(a);
								if (bb == null){
									continue;
								}
								for (int k = 0; k < bb.size(); k++){
									try{
										Bond bbb = (Bond)bb.get(k);
										if (bbb == null) continue;
										Object bondObject = (Object) structureHash.get( bbb );
										if (bondObject == null) continue;
										((MbtRenderable) bondObject).setDirty();
									}
									catch (Exception ex){
										ex.printStackTrace();
										continue;
									}
								}
								
								if (structureHash.get(a) != null) ((MbtRenderable)structureHash.get(a)).setDirty();
		
							}
							
						}
					}
					else if (structureStylesEvent.property == StructureStyles.PROPERTY_RIBBON_COLOR){
						MbtRenderable rr = (MbtRenderable)structureHash.get(chain);
						if (rr != null){
//							System.out.println(chain.getChainId() + ": setting to dirty");
							rr.setDirty();
						}
					}
				}
				else if (structureStylesEvent.attribute == StructureStyles.ATTRIBUTE_SELECTION){
					//add or remove the chain from the selectedChains list
					boolean selection = structureStylesEvent.batch;
					if (structureHash.containsKey(chain)){
						if (selection){
							if (!selectedChains.contains(chain)) selectedChains.add(chain);
						}
						else{
							if (selectedChains.contains(chain)) selectedChains.remove(chain);
						}
					}
				}
	
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("StructureViewer: Exception processing residue style event", ex);
				ex.printStackTrace();
				return;
			}
		
		}//end of Chain
		
//		System.out.println("Size of selectedResidues in StructureViewer = " + selectedResidues.size());
	}

	/**
	 * Process a StructureDocumentEvent message.
	 */
	public void processStructureDocumentEvent( StructureDocumentEvent structureDocumentEvent )
	{
		try{
		
			int type = structureDocumentEvent.type;
			int change = structureDocumentEvent.change;
			
			if ( type == StructureDocumentEvent.TYPE_VIEWER ){
				if ( change == StructureDocumentEvent.CHANGE_ADDED )
				{
					structureDocument = structureDocumentEvent.structureDocument;
					viewerAdded( structureDocumentEvent.viewer );
				}
				else if ( change == StructureDocumentEvent.CHANGE_REMOVED )
				{
					structureDocument = null;
					viewerRemoved( structureDocumentEvent.viewer );
				}
			}
			else if ( type == StructureDocumentEvent.TYPE_DATA ){
				Entry e = structureDocumentEvent.entry;
				Structure structure = null;
				if (e instanceof StructureEntry){
					StructureEntry entry = (StructureEntry)structureDocumentEvent.entry;
					structure = entry.getStructure();
				}
				else if (e instanceof FragmentEntry){
					FragmentEntry entry = (FragmentEntry)structureDocumentEvent.entry;
					structure = entry.getStructure();
				}
				
				if (structure == null){
					return;
				}
				
				if (structure.getStructureMap() == null || structure.getStructureMap().getAtomCount() == 0){
					return;
				}
				
				if ( change == StructureDocumentEvent.CHANGE_ADDED ){
					
					//just being paranoid: check if there are any atoms (data can be corrupted)
					if (structure.getStructureMap().getAtomCount() == 0) return;
					
					structures.put(e, structure);
					entries.put(structure, e);
					structureList.add(structure);
					if (e.TYPE == StructureEntry.FRAGMENT_ENTRY){
						structureNames.put(structure, e.getName());
						fragmentAdded((FragmentEntry)e, structure);
					}
					else{
						structureNames.put(structure, e.getName());
						structureAdded( structure );
					}
				}
				else if ( change == StructureDocumentEvent.CHANGE_REMOVED ){
					
					structureNames.remove(structure);
					structureRemoved( structure );
					structures.remove(e);
					entries.remove(structure);
					structureList.remove(structure);
				}
				else if (change == StructureDocumentEvent.CHANGE_RENAMED){
					structureNames.put(structure, e.getName());
				}
				
				structure = null;
				structureDocumentEvent = null;
				
			}
			else if (type == StructureDocumentEvent.TYPE_GLOBAL){
				if (change == StructureDocumentEvent.CHANGE_RELOAD){
					//ignore: this is for sequence viewer
				}
			}
		
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception processing StructureDocumentEvent", ex);
		}
	}
	
	public void updateCoordinates(Structure structure, double[] coordinates, float[] charges, boolean updateSS, boolean centerView){
		
		int j = 0;
		for (int i = 0; i < structure.getStructureMap().getAtomCount(); i++){
			Atom a = structure.getStructureMap().getAtom(i);
			a.coordinate[0] = coordinates[j++];
			a.coordinate[1] = coordinates[j++];
			a.coordinate[2] = coordinates[j++];
			if (charges != null) a.partialCharge = charges[i];
		}
		
		Hashtable rr = (Hashtable)objectHash.get(structure);
		Collection values = rr.values();
		Iterator it = values.iterator();
		while (it.hasNext()){
			((GlRenderable)it.next()).setDirty();
		}
		
		if (updateSS && structure.getStructureMap().getAtomCount() > structure.getStructureMap().MIN_ATOMS_FOR_FRAGMENTS){
			structure.getStructureMap().generateFragments();
		}
		
		//check for any monitors
/*		Set keys = monitors.keySet();
		Iterator t = keys.iterator();
		while (t.hasNext()){
			MonitorComponent comp = (MonitorComponent)t.next();
			MonitorRenderable r = (MonitorRenderable)monitors.get(comp);
			r.setDirty();
		}
*/		
		if (centerView){
			fitDisplay();
		}
		
		updateAppearance();
		
		
	}

	/**
	 *  The StructureViewer was just added to a StructureDocument.
	 */
	private void viewerAdded( Viewer viewer )
	{
		if ( viewer != this ) return;

		ArrayList entries = structureDocument.getEntriesByType(StructureEntry.STRUCTURE_ENTRY);
		for ( int i = 0; i < entries.size(); i++ )
		{
			Entry entry = (Entry)entries.get( i );
			if (entry.TYPE == StructureEntry.STRUCTURE_ENTRY){
				structureAdded( ((StructureEntry)entry).getStructure() );
			}
			else if (entry.TYPE == StructureEntry.FRAGMENT_ENTRY){
				fragmentAdded( (FragmentEntry)entry, ((FragmentEntry)entry).getStructure() );
			}
		}
		
		// New geometry should be available, so recompute a default view.
		resetView();
	}

	/**
	 *  A Viewer was just removed from a StructureDocument.
	 */
	private void viewerRemoved( Viewer viewer )
	{
		if ( viewer != this ) return;

		ArrayList entries = structureDocument.getEntriesByType(StructureEntry.STRUCTURE_ENTRY);
		for ( int i = 0; i < entries.size(); i++ )
		{
			Entry entry = (Entry)entries.get( i );
			structureRemoved( ((StructureEntry)entry).getStructure() );
		}
		
	}

	/**
	 *  A Structure was just added to a StructureDocument.
	 */
	private void structureAdded( Structure structure )
	{
		try{
			Status.progress( 0.3f, "StructureViewer adding structure..." );
			
			//create document hash entry: StructureComponent -> MbtRenderable
			Hashtable structureHash = new Hashtable();
			
			//List of Renderables to be displayed on the next pass
			Vector localRenderables = new Vector();
			renderables.put(structure, localRenderables);
			
			objectHash.put(structure, structureHash);
			
			Status.progress( 0.6f, "Parsing structural information..." );
			StructureMap structureMap = structure.getStructureMap( );
			
//			System.out.println("structureMap = " + structureMap);
			
//			System.out.println("Atom count = " + structureMap.getAtomCount() + ", bond count = " + structureMap.getBondCount());
			
			Status.progress( 0.9f, "Generating appearance settings..." );
			StructureStyles structureStyles = structureMap.getStructureStyles( );
			
			
			// If it's just sequence data lets bail out!
			if ( structureMap.getAtomCount() < 0 )
				return;

			// Add a StructureStylesEventListener so we recieve updates.
			structureStyles.addStructureStylesEventListener( this );
			structureStyles.addStructureComponentEventListener(this);
			
			structureStyles.setSelectedChains(selectedChains);
			
	
			int totalResidues = structureMap.getResidueCount( );
			int onePercent = (int) ((float) totalResidues / 100.0f);
			if ( onePercent <= 0 ) onePercent = 1;
			int currentResidue = 0;
	
			double[] vector3d = new double[3];
			int chainCount = structureMap.getChainCount( );
			
			Status.progress( 0.0f, "Generating geometry..." );
			
			boolean ribbonDisplay = (StylesPreferences.structureView == StylesPreferences.RENDERING_RIBBON);//render only ribbon

			if (structureMap.getAtomCount() > 20000){
				if (!ribbonDisplay){
					//ask about a ribbon
					if (JOptionPane.showConfirmDialog(structureDocument.parent.getApplicationFrame(), "The structure is over 20000 atoms, and display may be slow with all atoms and bonds shown. Would you like to display only the ribbons?", 
							"Loading confirmation", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION){
						ribbonDisplay = true;
					}
				}
			}
			
			if (!ribbonDisplay){
				StylesPreferences.renderingMode = StylesPreferences.structureView;
				createStructureRenderables(structure);
			}
			else {
				boolean atomsFlag = true;
				for (int i = 0; i < structure.getStructureMap().getChainCount(); i++){
					Chain chain = (Chain)structure.getStructureMap().getChain(i);
					
					if (ProteinProperties.isAminoAcid(chain.getResidue(0).getCompoundCode())){
						if (chain.getResidueCount() > 10){
							atomsFlag = false;
						}
					}
					else if (DNAProperties.isNucleicAcid(chain.getResidue(0).getCompoundCode())){
						if (chain.getResidueCount() > 5){
							atomsFlag = false;
						}
					}
					
					addRibbon(chain, StylesPreferences.RIBBON_RENDERED, StylesPreferences.ribbonQuality, StylesPreferences.ribbonDiameter, false);
					
				}
				
				if (atomsFlag){
					//no chains were created
					StylesPreferences.renderingMode = StylesPreferences.RENDERING_LINES;
					createStructureRenderables(structure);
					//run dummy check
					if (!stopCheckDummyAtoms) checkDummyAtoms(structure, false);
				}

			}
			

			updateBoundWaters(structure, false);
			
			
			//in case this is an undo operation, check whether there is a Ramachandran plot associated with this structure
			if (undoProcess){
				ArrayList rvs = structureDocument.getViewers();
				for (int i = 0; i < rvs.size(); i++){
					Viewer v = (Viewer)rvs.get(i);
					try{
						//try this one
						RamachandranViewer rv = (RamachandranViewer)v;
						rv.connect(structure, getLoadedStructures().indexOf(structure));
					}
					catch (ClassCastException e){}
				}
			}

			if (StylesPreferences.structureColorSequence){
				if (StylesPreferences.structureColorIndex == StylesPreferences.structureColors.length){
					StylesPreferences.structureColorIndex = 0;
				}
				//apply the current color
				Color structureColor = StylesPreferences.structureColors[StylesPreferences.structureColorIndex++];
				AtomColor atomColor = AtomColorFactory.getAtomColor(structureColor);
				ResidueColor residueColor = ResidueColorFactory.getResidueColor(structureColor);
				
				structureMap.getStructureStyles().setStructureColor(residueColor, atomColor);
				
			}
			
			
			updateAppearance();
			if (structureList.size() == 1){
				resetView();
			}
			else{
				if (structureDocument.parent.isResetView()) resetView();
			}
	
			Status.progress( 1.0f, null );
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Unable to load structure: errors in the data.", ex);
			Status.progress( 1.0f, null );
		}
		
	}
	
	
	
	private void fragmentAdded(FragmentEntry entry, Structure structure){
		
		
		try{
			//create document hash entry: StructureComponent -> MbtRenderable
			Hashtable structureHash = new Hashtable();
			
			//List of Renderables to be displayed on the next pass
			Vector localRenderables = new Vector();
			
			objectHash.put(structure, structureHash);
	
			StructureMap structureMap = structure.getStructureMap( );
			StructureStyles structureStyles = structureMap.getStructureStyles( );
			
//			System.out.println("mode = " + StylesPreferences.renderingMode);
	
			if ( structureMap.getAtomCount() < 0 ){
				return;
			}
			
	
			// Add a StructureStylesEventListener so we recieve updates.
			structureStyles.addStructureStylesEventListener( this );
			structureStyles.addStructureComponentEventListener(this);
	
			//make sure the fragment lands in the middle of the display
			//along the lookAt vector with the fragment's up vector colinear with the up vector of the view
			
			double[] normal = entry.getLookAt();
			double[] fragmentUp = entry.getUp();
			double[] center = entry.getCenter();
			
			if (structures.size() > 1){
				//align with the current view
				double[] lookAt = geometryViewer.getLookAt();
				double[] up = geometryViewer.getUpVector();
				double[] eye = geometryViewer.getEyePosition();
			
				double[] targetPosition = new double[3];
				if (fragmentLocation != null){
					targetPosition = StructureMath.getPointOnVector(fragmentLocation, lookAt, 1);
					fragmentLocation = null;
				}
				else{
					targetPosition = StructureMath.getPointOnVector(eye, lookAt, fragmentDistanceFromCamera);
				}
				StructureMath.transformStructure(new Location(normal, fragmentUp, center), new Location(lookAt, up, targetPosition), structure);

				resetFog();
			}
			else{
				double[] lookAt = new double[] { 0, 0, -1 };
				double[] up = new double[] { 0, 1, 0 };
				StructureMath.transformStructure(new Location(normal, fragmentUp, center), new Location(lookAt, up, center), structure);
				
				geometryViewer.resetView(center, 2.0, true, true);
			}
			
			
			double[] vector3d = new double[3];
			float color[] = new float[3];
			double coord[] = new double[3];
			
			int quality = StylesPreferences.startupRenderingQuality;
			
//			System.out.println("quality = " + quality);

			objectHash.put(structure, structureHash);
			renderables.put(structure, localRenderables);
			
			boolean lines = (StylesPreferences.structureView == StylesPreferences.RENDERING_LINES);
			if (StylesPreferences.structureView == StylesPreferences.RENDERING_RIBBON){
				lines = true;
			}
			
//			System.out.println("lines = " + lines);
			
			//Atoms
			if (!lines){
				int atomCount = structureMap.getAtomCount( );
				try{
					AtomGeometry atomGeometry = (AtomGeometry)defaultGeometry.get("AtomGeometry");//don't translate
					for ( int atomIndex=0; atomIndex<atomCount; atomIndex++ )
					{
						if (StylesPreferences.structureView != StylesPreferences.RENDERING_LINES){
							Atom atom = structureMap.getAtom( atomIndex );
			
							//
							// Atom Geometry
							//
							MbtRenderable renderable = new MbtRenderable( atom, structureStyles, atomGeometry );
							structureHash.put( atom, renderable );
							if (atom.visible){
								localRenderables.add(renderable);
								renderablesList.add(renderable);
							}
							else{
								hiddenComponents.put(atom, renderable);
							}

							Vector bonds = atom.structure.getStructureMap().getBonds(atom);
							if (StylesPreferences.structureView == StylesPreferences.RENDERING_BALL_STICK){
								for (int i = 1; i < bonds.size(); i++){
									structureStyles.setBondRadius((Bond)bonds.get(i), BondRadiusAsStick.create());
								}
//								structureStyles.setRenderingStyle(atom, StylesPreferences.RENDERING_BALL_STICK, quality, true);
								if (StylesPreferences.ballRadiusOption == StylesPreferences.ATOMIC_RADIUS){
									structureStyles.setAtomRadius(atom, AtomRadiusRegistry.get(AtomRadiusByScaledCpk.NAME));
								}
								else{
									AtomRadiusByConstant r = (AtomRadiusByConstant)AtomRadiusRegistry.get(AtomRadiusByConstant.NAME);
									r.setRadius(StylesPreferences.ballRadius*StylesPreferences.atomRadiusScale);
									structureStyles.setAtomRadius(atom, r);
								}
							}
							else if (StylesPreferences.structureView == StylesPreferences.RENDERING_STICK){					
//								structureStyles.setRenderingStyle(atom, StylesPreferences.RENDERING_STICK, quality, true);
								AtomRadiusByConstant r = (AtomRadiusByConstant)AtomRadiusRegistry.get(AtomRadiusByConstant.NAME);
								r.setRadius(StylesPreferences.stickSize);
								structureStyles.setAtomRadius(atom, r);
							}
							else if (StylesPreferences.structureView == StylesPreferences.RENDERING_CPK){
								
//								structureStyles.setRenderingStyle(atom, StylesPreferences.RENDERING_CPK, quality, true);
								Vector bbb = atom.structure.getStructureMap().getBonds(atom);
								for (int i = 1; i < bbb.size(); i++){
									structureStyles.setBondRadius((Bond)bbb.get(i), BondRadiusAsStick.create());
								}

								structureStyles.setAtomRadius(atom, AtomRadiusRegistry.get(AtomRadiusByCpk.NAME));

							}
							
						}
					}
				}
				catch (OutOfMemoryError e){
					System.err.println("Ran out of memory while loading structure");
				}
			}
			
			structureStyles.setSelectedChains(selectedChains);


			//Bonds
			int bondCount = structureMap.getBondCount( );
			int onePercentBonds = (int) ( (float) bondCount / 100.0f );
			
//			System.out.println("rendering mode = " + StylesPreferences.renderingMode);
			
			BondGeometry bondGeometry = (BondGeometry)defaultGeometry.get("BondGeometry");//don't translate
			for ( int bondIndex=0; bondIndex<bondCount; bondIndex++ )
			{
				Bond bond = structureMap.getBond( bondIndex );
				bond.render = StylesPreferences.structureView;
				if (StylesPreferences.structureView != StylesPreferences.RENDERING_CPK){
					
					MbtRenderable m = new MbtRenderable( bond, structureStyles, bondGeometry );
					structureHash.put(bond, m);
					if (bond.visible){
						localRenderables.add(m);
						renderablesList.add(m);
					}
					else{
						hiddenComponents.put(bond, m);
					}

					if (StylesPreferences.structureView == StylesPreferences.RENDERING_STICK){
						structureStyles.setBondRadius(bond, BondRadiusByAtomRadius.create());
					}
					else if (StylesPreferences.structureView == StylesPreferences.RENDERING_BALL_STICK){
						structureStyles.setBondRadius(bond, BondRadiusAsStick.create());
					}
				}
				
//				System.out.println("bond.render = " + bond.render);
			}
			
			if (StylesPreferences.structureView != StylesPreferences.RENDERING_LINES){
				if (StylesPreferences.structureView == StylesPreferences.RENDERING_RIBBON){
					structureStyles.setRenderingStyle(StylesPreferences.RENDERING_LINES, StylesPreferences.startupRenderingQuality);
				}
				else{
					structureStyles.setRenderingStyle(StylesPreferences.structureView, StylesPreferences.startupRenderingQuality);
				}
			}

						
			geometryViewer.setRenderables(renderablesList);
			geometryViewer.updateView();
	
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Unable to load structure: errors in the data.", ex);
		}
	
	}
	
	/**
	 *  A Structure was just removed from a StructureDocument.
	 */
	private void structureRemoved( Structure structure )
	{
		try{
			
		StructureMap structureMap = structure.getStructureMap( );
		StructureStyles structureStyles = structureMap.getStructureStyles( );
		structureStyles.removeStructureStylesEventListener( this );
		structureStyles.removeStructureComponentEventListener(this);
		
		Hashtable structureHash = (Hashtable)objectHash.get(structure);

		
		//check whether this structure had any independent motion going on
		if (independentStructure == structure){
			//reset things to common motion first
			setCommonMotion(false);
		}
		
		for (int i = surfaceObjects.size()-1; i >= 0; i--){
			SurfaceComponent sc = (SurfaceComponent)surfaceObjects.get(i);
			if (sc.structure == structure){
				MbtRenderable sr = (MbtRenderable)structureHash.get(sc);
				removeRenderable(sr);
				structureHash.remove(sc);
				surfaceObjects.remove(sc);
			}
		}
		
		//cluster renderables
		removeClusterRenderables(structure, false);
		
		//search hiddenComponents
		Vector doomed = new Vector();
		Set keys = hiddenComponents.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			StructureComponent cs = (StructureComponent)it.next();
			if (cs.structure == structure){
				doomed.add(cs);
			}
		}
		
		for (int i = 0; i < doomed.size(); i++){
			StructureComponent sc = (StructureComponent)doomed.get(i);
			hiddenComponents.remove(sc);
		}
		
		//get rid of the geometries
		
		Vector rrr = (Vector)renderables.get(structure);
		removeRenderables(rrr);
		
		renderables.remove(structure);
		
		if (structureHash != null){
			structureHash.clear();
		}
		structureHash = null;
		
		//check ribbon display
		for (int i = 0; i < structure.getStructureMap().getChainCount(); i++){
			Chain c = structure.getStructureMap().getChain(i);
			if (selectedChains.contains(c)) selectedChains.remove(c);
		}
		
		
		//get rid of the rest
		objectHash.remove(structure);
		residueToFragment.remove(structure);
		
					
		//remove the pair from structures
		Entry target = null;
		keys = structures.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			Entry en = (Entry)it.next();
			Structure s = (Structure)structures.get(en);
			if (structure == s){
				target = en;
				break;
			}
		}
		
		//check if this entry has a structure, and if so, whether a Ramachandran plot is open
		if (structureDocument.parent.getRamachandranViewer(structure) != null){
			if (undoProcess){
				//leave the Rama viewer, but also leave a record of the structure connection to the viewer
				//it will store the index of the structure to be associated with, as well as a lookup
				//hash for residue indices to be associated with its records
				structureDocument.parent.getRamachandranViewer(structure).disconnect(getLoadedStructures().indexOf(structure));
				
				
			}
			else{
				structureDocument.parent.removeRamachandranDialog(((StructureEntry)target).getStructure());
			}
		}

		structures.remove(target);
		entries.remove(structure);
		structureList.remove(structure);
		
		if (initialCoordinates.containsKey(structure)) initialCoordinates.remove(structure);

		
		SearchServicePanel p = structureDocument.parent.getActiveSearchServicePanel();
		if (p != null){
			if (p.getCurrentEntry() == target){
				p.processClick(null, null, -1);
			}
		}
		
		componentListeners.remove(structureStyles);
		
		//check dummy atom records
		for (int i = dummyAtoms.size()-1; i >= 0; i--){
			Atom a = (Atom)dummyAtoms.get(i);
			if (a.structure == structure){
				dummyAtoms.remove(a);
			}
		}
		
		//check if any atoms from this structure are in a set
		for (int i = atomSetNames.size()-1; i >= 0; i--){
			Vector atoms = (Vector)atomSets.get(atomSetNames.get(i));
			for (int j = atoms.size()-1; j >= 0; j--){
				StructureComponent a = (StructureComponent)atoms.get(j);
				if (a.structure == structure){
					atoms.remove(a);
				}
			}
			if (atoms.size() == 0){
				atomSets.remove(atomSetNames.get(i));
				atomSetNames.remove(i);
			}
		}
		
		for (int i = independentComponents.size()-1; i >= 0 ; i--){
			StructureComponent sc = (StructureComponent)independentComponents.get(i);
			if (sc.structure == structure) independentComponents.remove(sc);
		}
		
		removeMonitors(structure, false);
		structureDocument.parent.getRasmolReader().clear(structure);//just in case
		
		structure = null;
		structureMap = null;
		structureStyles = null;
		
		Status.output(Status.LEVEL_REMARK, "");//clear the status line
		
		structureDocument.parent.updateMonitorDialog();

		if (updateViewOnRemove) updateAppearance();
		
		if (!undoProcess && entries.size() == 0){
			undoBuffer.clear();
			structureDocument.parent.setUndo(false);
		}
		
		
		System.gc();
		
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception removing a structure", ex);
		}
	}

	
	/**
	 * Creates a distance monitor
	 * @param structure Structure whose distance parameter was measured
	 * @param a coordinates of the first point
	 * @param b coordinates of the second point
	 * @param label distance label
	 */
	public void createMonitor(Atom atom1, Atom atom2, String label, float[] color, boolean updateView){
	
		try{
			
			if (!undoProcess){
				if (StylesPreferences.undoEnabled) saveStateForUndo();
			}
			
			MonitorComponent c = new MonitorComponent(atom1, atom2, label, color );
			
			MonitorRenderable r = new MonitorRenderable(c, (MonitorGeometry)defaultGeometry.get("MonitorGeometry"));//don't translate
		
			monitors.put(c, r);
			
			Vector lr = (Vector)atomToMonitors.get(atom1);
			if (lr == null){
				lr = new Vector();
				atomToMonitors.put(atom1, lr);
			}
			lr.add(c);

			Vector lr2 = (Vector)atomToMonitors.get(atom2);
			if (lr2 == null){
				lr2 = new Vector();
				atomToMonitors.put(atom2, lr2);
			}
			lr2.add(c);
			
			if (independentSet != null){
				if (independentSet.contains(atom1) && independentSet.contains(atom2)){
					independentGroup.addChild(r);
				}
				else{
					renderablesList.add(r);
				}
				
				if (independentSet.contains(atom1)){
					double[] ccc = (double[])transformedCoordinates.get(atom1);
					c.start = ccc;
				}
				if (independentSet.contains(atom2)){
					double[] ccc = (double[])transformedCoordinates.get(atom2);
					c.end = ccc;
				}
				
			}
			else{
				renderablesList.add(r);
			}
			
			geometryViewer.setRenderables(renderablesList);
			if (updateView){
				geometryViewer.updateView();
			}
			
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception displaying a distance monitor", ex);
		}
		
	}
	
	/**
	 * This method creates two ClusterRenderables for both affected chains
	 * @param cluster
	 * @param updateView
	 * @return
	 */
	public boolean createClusterRenderables(Cluster cluster, boolean updateView){
		
		//check whether the structures represented by the cluster are actually loaded
		if (structureList.contains(cluster.chain1.structure) && structureList.contains(cluster.chain2.structure)){
			
			if (clusters.containsKey(cluster)){
				//show clusters that may have been hidden
				ClusterRenderable[] r = (ClusterRenderable[])clusters.get(cluster);
				renderablesList.add(r[0]);
				renderablesList.add(r[1]);
				r[0].setDirty();
				r[1].setDirty();
				
				return true;
			}
			
			
			ClusterRenderable r1 = new ClusterRenderable(cluster, cluster.chain1, (ClusterGeometry)defaultGeometry.get("ClusterGeometry"));//don't translate
			renderablesList.add(r1);
			
			ClusterRenderable r2 = new ClusterRenderable(cluster, cluster.chain2, (ClusterGeometry)defaultGeometry.get("ClusterGeometry"));//don't translate
			renderablesList.add(r2);
	
			clusters.put(cluster, new ClusterRenderable[]{ r1, r2 });

			geometryViewer.setRenderables(renderablesList);
			if (updateView){
				geometryViewer.updateView();
			}
			
			updateAppearance();
			return true;
		}
		else{
			return false;
		}
		
		
	}
	
	public void updateClusterRenderables(){
		Set keys = clusters.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			ClusterRenderable[] r = (ClusterRenderable[])clusters.get(it.next());
			if (r[0] != null) r[0].setDirty();
			if (r[1] != null) r[1].setDirty();
		}
	}
	
	public void removeClusterRenderables(Cluster cluster, boolean updateView){
		if (clusters.containsKey(cluster)){
			ClusterRenderable[] list = (ClusterRenderable[])clusters.get(cluster);
			renderablesList.remove(list[0]);
			renderablesList.remove(list[1]);
			clusters.remove(cluster);
			
			geometryViewer.setRenderables(renderablesList);
			if (updateView){
				geometryViewer.updateView();
			}
		}
	}
	
	public void removeClusterRenderables(boolean updateView){
		Set keys = clusters.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			ClusterRenderable[] r = (ClusterRenderable[])clusters.get(it.next());
			renderablesList.remove(r[0]);
			renderablesList.remove(r[1]);
		}
		
		clusters.clear();
		geometryViewer.setRenderables(renderablesList);
		if (updateView){
			geometryViewer.updateView();
		}
	}
	
	public void removeClusterRenderables(Structure structure, boolean updateView){
		Set keys = clusters.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			Cluster c = (Cluster)it.next();
			if (c.chain1.structure == structure || c.chain2.structure == structure){
				ClusterRenderable[] r = (ClusterRenderable[])clusters.get(c);
				renderablesList.remove(r[0]);
				renderablesList.remove(r[1]);
			}
		}
		
		clusters.clear();
		geometryViewer.setRenderables(renderablesList);
		if (updateView){
			geometryViewer.updateView();
		}
		
	}

	
	public void createLabel(Atom atom, int type, int size, String text, boolean updateView){
		
		try{
			
			LabelComponent c = new LabelComponent(atom, type, size, text );
			
			MonitorRenderable r = new MonitorRenderable(c, (LabelGeometry)defaultGeometry.get("LabelGeometry"));//don't translate
		
			labels.put(c, r);
			atomToLabels.put(atom, c);

			if (independentSet != null){
				if (independentSet.contains(atom)){
					independentGroup.addChild(r);
				}
				else{
					if (atom.visible){
						renderablesList.add(r);
					}
				}
			}
			else{
				if (atom.visible){
					renderablesList.add(r);
				}
			}
			
			geometryViewer.setRenderables(renderablesList);
			if (updateView){
				geometryViewer.updateView();
			}
			
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception displaying a label", ex);
		}
		
	}

	public void createLabel(Atom atom, int type, int size, String text, boolean selected, float[] color, boolean updateView){
		
		try{
			
			LabelComponent c = new LabelComponent(atom, type, size, text, selected, color );
			MonitorRenderable r = new MonitorRenderable(c, (LabelGeometry)defaultGeometry.get("LabelGeometry"));//don't translate
		
			labels.put(c, r);
			atomToLabels.put(atom, c);

			if (independentSet != null){
				if (independentSet.contains(atom)){
					independentGroup.addChild(r);
				}
				else{
					renderablesList.add(r);
				}
			}
			else{
				renderablesList.add(r);
			}
			
			geometryViewer.setRenderables(renderablesList);
			if (updateView){
				geometryViewer.updateView();
			}
			
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception displaying an atom label", ex);
		}
		
	}
	
	public void createLabel(Residue residue, int type, int size, String text, boolean selected, float[] color, boolean updateView){
		
		try{
			
			ResidueLabelComponent c = new ResidueLabelComponent(residue, type, size, text, selected, color );
			
			MonitorRenderable r = new MonitorRenderable(c, (ResidueLabelGeometry)defaultGeometry.get("ResidueLabelGeometry"));//don't translate
		
			labels.put(c, r);
			atomToResidueLabels.put(c.reference, c);

			if (independentSet != null){
				if (independentSet.contains(c.reference)){
					independentGroup.addChild(r);
				}
				else{
					renderablesList.add(r);
				}
			}
			else{
				renderablesList.add(r);
			}
			
			geometryViewer.setRenderables(renderablesList);
			if (updateView){
				geometryViewer.updateView();
			}
			
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception displaying a residue label", ex);
		}
		
	}

	
	public void removeAnnotationComponent(AnnotationComponent component, boolean updateView){
		
		if (component == null) return;
		
		int type = component.getType();
		
		if (type == AnnotationComponentRegistry.TYPE_MONITOR){
			removeMonitor((MonitorComponent)component, false);
		}
		else if (type == AnnotationComponentRegistry.TYPE_HYDROGEN_BOND){
			removeHBond((HydrogenBondComponent)component, false);
		}
		else if (type == AnnotationComponentRegistry.TYPE_STERIC_BUMP){
			removeBump((StericBumpComponent)component, false);
		}
		else if (type == AnnotationComponentRegistry.TYPE_LABEL){
			removeLabel((LabelComponent)component, false);
		}
		else if (type == AnnotationComponentRegistry.TYPE_RESIDUE_LABEL){
			removeLabel((ResidueLabelComponent)component, false);
		}
		
		if (updateView){
			geometryViewer.setRenderables(renderablesList);
			geometryViewer.updateView();
			structureDocument.parent.updateMonitorDialog();
		}

	}
	
	public void labelResidues(){

		for (int i = 0 ; i < getLoadedStructures().size(); i++){
			Structure s = (Structure)getLoadedStructures().get(i);
			for (int j = 0 ; j < s.getStructureMap().getResidueCount(); j++){
				Residue r = s.getStructureMap().getResidue(j);
				
				if (!r.visible) continue;
				ResidueLabelComponent c = new ResidueLabelComponent(r, LabelDialog.TYPE_NAME, LabelGeometry.LARGE_FONT, null );
				
				MonitorRenderable rr = new MonitorRenderable(c, (ResidueLabelGeometry)defaultGeometry.get("ResidueLabelGeometry"));//don't translate
			
				labels.put(c, rr);
				atomToResidueLabels.put(c.reference, c);

				if (independentSet != null){
					if (independentSet.contains(c.reference)){
						independentGroup.addChild(rr);
					}
					else{
						renderablesList.add(rr);
					}
				}
				else{
					renderablesList.add(rr);
				}
				
				geometryViewer.setRenderables(renderablesList);
			}
		}
		
		MonitorDialog md = structureDocument.parent.getMonitorDialog();
		if (md != null) md.updateTree();

		geometryViewer.updateView();
	}
	
	/**
	 * Remove all monitors for a specific structure.
	 */
	public void removeMonitors(Structure structure, boolean update){
	
		
		Set keys = atomToMonitors.keySet();
		Iterator it = keys.iterator();
		Vector vector = new Vector();
		while (it.hasNext()){
			Atom a = (Atom)it.next();
			if (a.structure == structure){
				Vector content = (Vector)atomToMonitors.get(a);
				for (int i = 0; i < content.size(); i++){
					if (!vector.contains(content.get(i))){
						vector.add(content.get(i));
					}
				}
			}
		}
		
		for (int i = 0; i < vector.size(); i++){
			removeMonitor((MonitorComponent)vector.get(i), false);
		}

		
		
		keys = atomToHBonds.keySet();
		it = keys.iterator();
		vector = new Vector();
		while (it.hasNext()){
			Atom a = (Atom)it.next();
			if (a.structure == structure){
				Vector content = (Vector)atomToHBonds.get(a);
				for (int i = 0; i < content.size(); i++){
					if (!vector.contains(content.get(i))){
						vector.add(content.get(i));
					}
				}
			}
		}
		
		for (int i = 0; i < vector.size(); i++){
			removeHBond((HydrogenBondComponent)vector.get(i), false);
		}
		
		
		keys = atomToBumps.keySet();
		it = keys.iterator();
		vector = new Vector();
		while (it.hasNext()){
			Atom a = (Atom)it.next();
			if (a.structure == structure){
				Vector content = (Vector)atomToBumps.get(a);
				for (int i = 0; i < content.size(); i++){
					if (!vector.contains(content.get(i))){
						vector.add(content.get(i));
					}
				}
			}
		}
		
		for (int i = 0; i < vector.size(); i++){
			removeBump((StericBumpComponent)vector.get(i), false);
		}
		
		keys = atomToLabels.keySet();
		it = keys.iterator();
		vector = new Vector();
		while (it.hasNext()){
			Atom a = (Atom)it.next();
			if (a.structure == structure){
				vector.add(atomToLabels.get(a));
			}
		}
		
		for (int i = 0; i < vector.size(); i++){
			removeLabel((LabelComponent)vector.get(i), false);
		}
		
		keys = atomToResidueLabels.keySet();
		it = keys.iterator();
		vector = new Vector();
		while (it.hasNext()){
			Atom a = (Atom)it.next();
			if (a.structure == structure){
				vector.add(atomToResidueLabels.get(a));
			}
		}
		
		for (int i = 0; i < vector.size(); i++){
			removeLabel((ResidueLabelComponent)vector.get(i), false);
		}

		
		structureDocument.parent.updateMonitorDialog();
		if (update) geometryViewer.updateView();
	}
	
	public void removeMonitors(){
		
		//delete separately all distance monitors
		Set keys = atomToMonitors.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			Vector bb = (Vector)atomToMonitors.get(it.next());
			for (int i = 0; i < bb.size(); i++){
				GlRenderable renderable = (GlRenderable)labels.get(bb.get(i));
				if (independentGroup != null && independentGroup.containsChild(renderable)){
					independentGroup.removeChild(renderable);
				}
				else if (rotationGroup != null && rotationGroup.containsChild(renderable)){
					rotationGroup.removeChild(renderable);
				}
				else{
					renderablesList.remove(renderable);
				}
				monitors.remove(bb.get(i));
			}
		}
		atomToMonitors.clear();
		monitors.clear();
		
		//delete separately all bumps
		keys = atomToHBonds.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			Vector bb = (Vector)atomToHBonds.get(it.next());
			for (int i = 0; i < bb.size(); i++){
				GlRenderable renderable = (GlRenderable)labels.get(bb.get(i));
				if (independentGroup != null && independentGroup.containsChild(renderable)){
					independentGroup.removeChild(renderable);
				}
				else if (rotationGroup != null && rotationGroup.containsChild(renderable)){
					rotationGroup.removeChild(renderable);
				}
				else{
					renderablesList.remove(renderable);
				}
				hBonds.remove(bb.get(i));
			}
		}
		atomToHBonds.clear();
		hBonds.clear();

		//delete separately all bumps
		keys = atomToBumps.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			Vector bb = (Vector)atomToBumps.get(it.next());
			for (int i = 0; i < bb.size(); i++){
				GlRenderable renderable = (GlRenderable)labels.get(bb.get(i));
				if (independentGroup != null && independentGroup.containsChild(renderable)){
					independentGroup.removeChild(renderable);
				}
				else if (rotationGroup != null && rotationGroup.containsChild(renderable)){
					rotationGroup.removeChild(renderable);
				}
				else{
					renderablesList.remove(renderable);
				}
				bumps.remove(bb.get(i));
			}
		}
		atomToBumps.clear();
		bumps.clear();

		//delete separately all labels
		keys = atomToLabels.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			LabelComponent c = (LabelComponent)atomToLabels.get(it.next());
			GlRenderable renderable = (GlRenderable)labels.get(c);
			if (independentGroup != null && independentGroup.containsChild(renderable)){
				independentGroup.removeChild(renderable);
			}
			else if (rotationGroup != null && rotationGroup.containsChild(renderable)){
				rotationGroup.removeChild(renderable);
			}
			else{
				renderablesList.remove(renderable);
			}
			labels.remove(c);
		}
		atomToLabels.clear();

		keys = atomToResidueLabels.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			ResidueLabelComponent c = (ResidueLabelComponent)atomToResidueLabels.get(it.next());
			GlRenderable renderable = (GlRenderable)labels.get(c);
			if (independentGroup != null && independentGroup.containsChild(renderable)){
				independentGroup.removeChild(renderable);
			}
			else if (rotationGroup != null && rotationGroup.containsChild(renderable)){
				rotationGroup.removeChild(renderable);
			}
			else{
				renderablesList.remove(renderable);
			}
			labels.remove(c);
		}
		atomToResidueLabels.clear();
		labels.clear();

		
		structureDocument.parent.updateMonitorDialog();
		
//		geometryViewer.setRenderables(renderablesList);
//		geometryViewer.updateView();
		
		updateAppearance();
	}

	public void removeMonitor(MonitorComponent component, boolean update){
		
		if (component == null) return;
		
		Atom a1 = component.atom1;
		Atom a2 = component.atom2;
		
		Vector b1 = (Vector)atomToMonitors.get(a1);
		if (b1 != null) b1.remove(component);
		if (b1.size() == 0) atomToMonitors.remove(a1);
		
		Vector b2 = (Vector)atomToMonitors.get(a2);
		if (b2 != null) b2.remove(component);
		if (b2.size() == 0) atomToMonitors.remove(a2);
		
		GlRenderable renderable = (GlRenderable)monitors.get(component);
		if (independentGroup != null && independentGroup.containsChild(renderable)){
			independentGroup.removeChild(renderable);
		}
		else if (rotationGroup != null && rotationGroup.containsChild(renderable)){
			rotationGroup.removeChild(renderable);
		}
		else{
			renderablesList.remove(renderable);
		}
		monitors.remove(component);
		
		
		if (update){
			geometryViewer.setRenderables(renderablesList);
			geometryViewer.updateView();
		}
	}
	
	public void removeLabel(LabelComponent component, boolean update){
		
		if (component == null) return;
		
		Atom a = component.atom;
		atomToLabels.remove(a);
		
		GlRenderable renderable = (GlRenderable)labels.get(component);
		if (independentGroup != null && independentGroup.containsChild(renderable)){
			independentGroup.removeChild(renderable);
		}
		else if (rotationGroup != null && rotationGroup.containsChild(renderable)){
			rotationGroup.removeChild(renderable);
		}
		else{
			renderablesList.remove(renderable);
		}
		labels.remove(component);
		
		geometryViewer.setRenderables(renderablesList);
		if (update){
			geometryViewer.updateView();
		}
	}

	public void removeLabel(ResidueLabelComponent component, boolean update){
		
		if (component == null) return;
		
		Atom a = component.reference;
		atomToResidueLabels.remove(a);
		
		GlRenderable renderable = (GlRenderable)labels.get(component);
		if (independentGroup != null && independentGroup.containsChild(renderable)){
			independentGroup.removeChild(renderable);
		}
		else if (rotationGroup != null && rotationGroup.containsChild(renderable)){
			rotationGroup.removeChild(renderable);
		}
		else{
			renderablesList.remove(renderable);
		}
		labels.remove(component);
		
		geometryViewer.setRenderables(renderablesList);
		if (update){
			geometryViewer.updateView();
		}
	}

	public void removeBump(StericBumpComponent component, boolean update){
		
		if (component == null) return;
		
		Atom a1 = component.atom1;
		Atom a2 = component.atom2;
		
		Vector b1 = (Vector)atomToBumps.get(a1);
		if (b1 != null) b1.remove(component);
		if (b1.size() == 0) atomToBumps.remove(a1);
		
		Vector b2 = (Vector)atomToBumps.get(a2);
		if (b2 != null) b2.remove(component);
		if (b2.size() == 0) atomToBumps.remove(a2);
		
		GlRenderable renderable = (GlRenderable)bumps.get(component);
		if (independentGroup != null && independentGroup.containsChild(renderable)){
			independentGroup.removeChild(renderable);
		}
		else{
			renderablesList.remove(renderable);
		}
		bumps.remove(component);
		
		
		if (update){
			geometryViewer.setRenderables(renderablesList);
			geometryViewer.updateView();
		}
	}
	
	public void removeHBond(HydrogenBondComponent component, boolean update){
		
		if (component == null) return;
		
		Atom a1 = component.atom1;
		Atom a2 = component.atom2;
		
		Vector b1 = (Vector)atomToHBonds.get(a1);
		if (b1 != null) b1.remove(component);
		if (b1.size() == 0) atomToHBonds.remove(a1);
		
		Vector b2 = (Vector)atomToHBonds.get(a2);
		if (b2 != null) b2.remove(component);
		if (b2.size() == 0) atomToHBonds.remove(a2);
		
		GlRenderable renderable = (GlRenderable)hBonds.get(component);
		if (independentGroup != null && independentGroup.containsChild(renderable)){
			independentGroup.removeChild(renderable);
		}
		else if (rotationGroup != null && rotationGroup.containsChild(renderable)){
			rotationGroup.removeChild(renderable);
		}
		else{
			renderablesList.remove(renderable);
		}
		hBonds.remove(component);
		
		
		if (update){
			geometryViewer.setRenderables(renderablesList);
			geometryViewer.updateView();
		}
	}
	

	/**
	 * Blank method for compliance with the Viewer interface.
	 */
	public void registerResidueSelection(Entry e, Residue r, boolean b){
		//for compliance with the Viewer interface
	}
	
	public HashMap getResidueToFragment(){
		return residueToFragment;
	}
	
	public void processPickEvent(GvPickEvent event){
		try{
			
		GlRenderable rr = (GlRenderable)event.renderable;
		
		selection = new HashMap();
		
		boolean displayDialogActive = structureDocument.parent.getDisplayDialogStatus();
//		System.out.println("active status = " + displayDialogActive);
		final SearchServicePanel p = structureDocument.parent.getActiveSearchServicePanel();
		
		if (rr == null){
			
			Status.output(Status.LEVEL_REMARK, "");//clear the status line
			
			try{
				if (displayDialogActive){
					structureDocument.parent.getDisplayDialog().processPick("", null);
					return;
				}
				
				if (p != null){
					Thread runner = new Thread(){
						public void run(){
							p.processClick(null, null, -1);
						}
					};
					runner.start();
				}
			}
			catch (Exception ex){
//				ex.printStackTrace();
			}
			
			MouseEvent e = event.mouseEvent;
			
			if (FragmentRegistry.activeFragment != null && e.getButton() == MouseEvent.BUTTON1){
				
				
				String active = FragmentRegistry.activeFragment;
				
				if (active.equals("41") || active.equals("42") || active.equals("43") || active.equals("44")) return;//it's bond order
				//get the coordinates of the original click
				
				if (fragmentLocation == null) fragmentLocation = new double[3];

				if (getLoadedStructures().size() > 0){
					//determine the location on the lookAt vector where the new fragment should be placed
					double[] start = new double[3];
					start[0] = event.coordinate[0];
					start[1] = event.coordinate[1];
					start[2] = event.coordinate[2];
					

					double[] look = new double[3];
					look[0] = geometryViewer.getLookAt()[0];
					look[1] = geometryViewer.getLookAt()[1];
					look[2] = geometryViewer.getLookAt()[2];
					
					
					//convert look to a unit vector
					Algebra.normalizeVector(look);
					
					//now walk through the atoms in the display to determine which one is closest to the line of sight
					double min = 10000;
					Atom minAtom = null;
					//vector
					for (int i = 0; i < getLoadedStructures().size(); i++){
						Structure s = (Structure)getLoadedStructures().get(i);
						StructureMap map = s.getStructureMap();
						for (int j = 0; j < map.getAtomCount(); j++){
							Atom a = map.getAtom(j);
							double[] vector = Algebra.getVector(start, a.coordinate);
							double distance = Algebra.vectorLength(Algebra.crossProduct(look, vector));
							if (distance < min){
								min = distance;
								minAtom = a;
							}
						}
					}
					//now get the point on the look vector where the fragment should be located
					
					//determine the angle between lookAt and direction at the minAtom,
					//then use trigonometry to arrive at the catet
					double[] vector = Algebra.getVector(start, minAtom.coordinate);
					double cos = Algebra.dotProduct(vector, look)/(Algebra.vectorLength(vector) * Algebra.vectorLength(look));
					
					double offset = Algebra.vectorLength(vector)*cos;
					
					fragmentLocation = StructureMath.getPointOnVector(start, look, 3);
					
					if (StylesPreferences.undoEnabled) saveStateForUndo();
					
				}
				
				structureDocument.parent.loadFragment(FragmentRegistry.activeFragment);
				
				return;
			}
			

			MonitorDialog md = structureDocument.parent.getMonitorDialog();
			if (md != null){
				md.clearSelection();
			}
			else{
				clearAnnotationSelection();
			}
			
			if (StylesPreferences.selectionMode == StylesPreferences.SELECTION_REPLACE){
				//go over all loaded structures and call structureStyles.selectNone() method
				for (int i = 0; i < structureDocument.getEntryCount(); i++){
					Structure s = (Structure)structures.get(structureDocument.getEntry(i));
					if (s != null) s.getStructureMap().getStructureStyles().selectNone(true, true);
				}
				
				for (int i = selectedChains.size()-1; i >= 0; i--){
					Chain c = (Chain)selectedChains.get(i);
					c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
				}
				
				selectedChains.clear();
				structureDocument.parent.getSequenceViewer().clearCellSelection(false);
				
				structureDocument.parent.updateView();
			}

			
			return;
		}
		
		StructureMap structureMap = null;
		StructureStyles structureStyles = null;
		StructureComponent structureComponent = null;

		
		//check whether this renderable is composite
		if (rr == independentGroup){
			double[] c = event.coordinate;
//			System.out.println("group transform picked at " + c[0] + "," + c[1] + "," + c[2]);
			
			//loop through the independent set atoms and get the closest one
			if (independentSet == null || independentSet.size() == 0) return;
			
			double min = 100000;
			Atom selected = null;
			for (int i = 0; i < independentSet.size(); i++){
				try {
					Atom a = (Atom)independentSet.get(i);
					//get atom's transformed coordinates
					
					double d = Algebra.distance(c, (double[])transformedCoordinates.get(a));
					if (d < min){
						min = d;
						selected = a;
					}
				}
				catch (ClassCastException ex){
//					ex.printStackTrace();
				}
			}

			if (selected == null) return;
			
			structureComponent = selected;
			
		}
		else{
			try{
				structureComponent = ((MbtRenderable)rr).structureComponent;
			}
			catch (ClassCastException e){
				
				if (!event.mouseEvent.isControlDown()){
					if (StylesPreferences.selectionMode == StylesPreferences.SELECTION_REPLACE){
						//clear previous selection first
						//atom/ribbon selection
						for (int i = 0; i < structureDocument.getEntryCount(); i++){
							Structure s = (Structure)structures.get(structureDocument.getEntry(i));
							if (s != null) s.getStructureMap().getStructureStyles().selectNone(true, false);
						}
						
						for (int i = selectedChains.size()-1; i >= 0; i--){
							Chain c = (Chain)selectedChains.get(i);
							c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
						}
	
						//also check if other chains in this structure need to be updated since they got deselected
						for (int i = selectedChains.size()-1; i >= 0; i--){
							Chain cc = (Chain)selectedChains.get(i);
							selectedChains.remove(cc);
						}
						
						//monitor selection
						MonitorDialog md = structureDocument.parent.getMonitorDialog();
						if (md != null){
							md.clearSelection();
						}
						else{
							clearAnnotationSelection();
						}
					}

				}
				
				if (rr instanceof ClusterRenderable) return;
				
				
				//in case a monitor was clicked
				AnnotationComponent ac = ((MonitorRenderable)rr).getAnnotationComponent();
				
				if (ac.getSelected()){
					ac.setSelected(false);
				}
				else{
					ac.setSelected(true);
				}
				
				//notify the component tree of the change in selection
				MonitorDialog md = structureDocument.parent.getMonitorDialog();
				if (md != null){
					md.setSelection(ac, ac.getSelected());
				}
				
				//process selection or deselection of this component
				int type = ac.getType();
				if (type == AnnotationComponentRegistry.TYPE_HYDROGEN_BOND){
					MonitorRenderable r = (MonitorRenderable)hBonds.get(ac);
					if (r != null) r.setDirty();
				}
				else if (type == AnnotationComponentRegistry.TYPE_MONITOR){
					MonitorRenderable r = (MonitorRenderable)monitors.get(ac);
					if (r != null) r.setDirty();
				}
				else if (type == AnnotationComponentRegistry.TYPE_STERIC_BUMP){
					MonitorRenderable r = (MonitorRenderable)bumps.get(ac);
					if (r != null) r.setDirty();
				}
				else if (type == AnnotationComponentRegistry.TYPE_LABEL){
					MonitorRenderable r = (MonitorRenderable)labels.get(ac);
					if (r != null) r.setDirty();
				}
				

				structureDocument.parent.updateView();
				
				return;
			}
		}
				
		if (structureComponent == null){
			return;
		}
		
		if (p != null){
			p.processClick(structureComponent, (Entry)entries.get(structureComponent.structure), -1);
		}

		String structureComponentType = structureComponent.getStructureComponentType();
		if ( structureComponentType == StructureComponentRegistry.TYPE_ATOM ){
			Atom atom = (Atom) structureComponent;
			structureMap = atom.structure.getStructureMap( );
			structureStyles = structureMap.getStructureStyles( );

			//get the message for the status line
			String status = null;
			String name = null;
			Set k = structures.keySet();
			Iterator t = k.iterator();
			while (t.hasNext()){
				StructureEntry e = (StructureEntry)t.next();
				if (e.getStructure() == atom.structure){
					name = e.getName();
					break;
				}
			}
			
//			System.out.println("picked atom = " + atom.compound);
			if (atom.chain_id.length() > 0){
				//find the corresponding Entry and get its 
				status = name + ":" + atom.chain_id + ":" + atom.compound + atom.residue_id + ":" + atom.name;
			}
			else{
				status = name + ":_:" + atom.compound + atom.residue_id + ":" + atom.name;
			}
			Status.output(Status.LEVEL_REMARK, status);
				
			
			if (displayDialogActive){
//				System.out.println("active display dialog");
				try{
					structureDocument.parent.getDisplayDialog().processPick(status, atom);
				}
				catch (ClassCastException ex){
					structureDocument.parent.displayErrorMessage("For this operation you must pick atoms");
				}
				return;
			}
			
			Atom selectedAtom = atom;

			//check whether the builder is active
			if (FragmentRegistry.activeFragment != null){
				
				String active = FragmentRegistry.activeFragment;
				if (active.equals("41") || active.equals("42") || active.equals("43") || active.equals("44")){
					structureDocument.parent.displayErrorMessage("A bond rather than atom must be selected to change its order.\n" +
							"If you are trying to edit an separately moved structure, try using a bond order dialog.");
					return;
				}
				
				//attach the active fragment to this atom
				if (selectedAtom.element == 1){
					attachFragment(selectedAtom);
					return;
				}
			}
			
			
			Hashtable structureHash = (Hashtable)objectHash.get( atom.structure );
			
			if (StylesPreferences.selectionLevel == StylesPreferences.SELECTION_ATOM){
				//select the atom
				boolean selectionState = ! structureStyles.isSelected( selectedAtom );
//				System.out.println("New selection state = " + selectionState);
					
				if (selectionState){
					if (!event.mouseEvent.isControlDown()){
						if (StylesPreferences.selectionMode == StylesPreferences.SELECTION_REPLACE){
							for (int i = 0; i < structureDocument.getEntryCount(); i++){
								Structure s = (Structure)structures.get(structureDocument.getEntry(i));
								if (s != null) s.getStructureMap().getStructureStyles().selectNone(true, false);
							}
							
	/*						for (int i = selectedChains.size()-1; i >= 0; i--){
								Chain c = (Chain)selectedChains.get(i);
								c.structure.getStructureMap().getStructureStyles().updateChain(c);
							}
	*/						
							if (structureStyles.getSelectionFlag() != StructureStyles.FLAG_NONE){
								//also check if other chains in this structure need to be updated since they got deselected
								for (int i = selectedChains.size()-1; i >= 0; i--){
									Chain cc = (Chain)selectedChains.get(i);
	//								if (cc.structure == atom.structure){
										structureStyles.updateChain(cc, true);
	//								}
	//								selectedChains.remove(cc);
								}
							}
							
							//monitor selection
							MonitorDialog md = structureDocument.parent.getMonitorDialog();
							if (md != null){
								md.clearSelection();
							}
							else{
								clearAnnotationSelection();
							}
						}
					}
				}
				
				//update label selection, if any
				if (StylesPreferences.selectAtomLabel){
					if (atomToLabels.containsKey(atom)){
						//select the label as well
						LabelComponent lc = (LabelComponent)atomToLabels.get(atom);
						lc.setSelected(selectionState);
						GlRenderable r = (GlRenderable)labels.get(lc);
						if (r != null) r.setDirty();
						
						//update the monitor dialog if it's present
						MonitorDialog md = structureDocument.parent.getMonitorDialog();
						if (md != null){
							md.setSelection(lc, selectionState);
							md.repaintTree();
						}
					}
					else if (atomToResidueLabels.containsKey(atom)){
						ResidueLabelComponent lc = (ResidueLabelComponent)atomToResidueLabels.get(atom);
						lc.setSelected(selectionState);
						GlRenderable r = (GlRenderable)labels.get(lc);
						if (r != null) r.setDirty();
						
						//update the monitor dialog if it's present
						MonitorDialog md = structureDocument.parent.getMonitorDialog();
						if (md != null){
							md.setSelection(lc, selectionState);
							md.repaintTree();
						}
					}
				}

				structureStyles.setSelected( selectedAtom, selectionState, true, true );
				//bonds will get updated automatically, since their color is dependent on the
				//color of the neighboring atoms
				
				StructureBrowser sb = structureDocument.parent.getStructureBrowser();
				if (sb != null) sb.expandToNode(atom);
								
				structureDocument.parent.updateView();
			
			}
			else if (StylesPreferences.selectionLevel == StylesPreferences.SELECTION_RESIDUE){
				
				//select all atoms and bonds that belong to the residue that just got picked
				//first, identify the residue
				Residue res = structureMap.getResidue(atom);
				
				//get the new selection state of this residue
				boolean selectionState = ! structureStyles.isSelected(res);
			
				if (selectionState){
//					System.out.println("residue level selection");
					//check for modifier keys
					if (!event.mouseEvent.isControlDown()){
						if (StylesPreferences.selectionMode == StylesPreferences.SELECTION_REPLACE){
							for (int i = 0; i < structureDocument.getEntryCount(); i++){
								Structure s = (Structure)structures.get(structureDocument.getEntry(i));
								if (s != null) s.getStructureMap().getStructureStyles().selectNone(true, false);
							}
							
	/*						for (int i = selectedChains.size()-1; i >= 0; i--){
								Chain c = (Chain)selectedChains.get(i);
								c.structure.getStructureMap().getStructureStyles().updateChain(c);
							}
	*/						if (structureStyles.getSelectionFlag() != StructureStyles.FLAG_NONE){
	
								//also check if other chains in this structure need to be updated since they got deselected
								for (int i = selectedChains.size()-1; i >= 0; i--){
									Chain cc = (Chain)selectedChains.get(i);
	//								if (cc.structure == res.structure){
										structureStyles.updateChain(cc, true);
	//								}
	//								selectedChains.remove(cc);
								}
							}
							
							//monitor selection
							MonitorDialog md = structureDocument.parent.getMonitorDialog();
							if (md != null){
								md.clearSelection();
							}
							else{
								clearAnnotationSelection();
							}
						}

					}
				}
		
				//selection changes in atoms are automatically handled in the styles
				structureStyles.setSelected(res, selectionState, true, true);
				Chain chain = structureMap.getChain(atom);
				structureStyles.updateChain(chain, true);

/*				if (selectionState){
					if (!selectedChains.contains(chain)) selectedChains.add(chain);
				}
				else{
					//check whether there is any other residue selected within this chain
					//if not, remove it from selectedChains
					boolean remove = true;
					for (int j = 0; j < structureMap.getResidueCount(); j++){
						Residue r = structureMap.getResidue(j);
						if (structureMap.getChain(r.getAtom(0)) == chain){
							if (structureStyles.isSelected(r)){
								remove = false;
								break;
							}
							
						}
					}
					if (remove) selectedChains.remove(chain);
				}
*/				
				StructureBrowser sb = structureDocument.parent.getStructureBrowser();
				if (sb != null) sb.expandToNode(res);


				structureDocument.parent.updateView();
				
			}


					
		}
		else if( structureComponentType == StructureComponentRegistry.TYPE_BOND ){
			
			//single click selects the atom
			//closest to the point of the click; selection of two atoms (vertices) that are connected by the same bond
			//automatically selects the bond
			
			Hashtable structureHash = (Hashtable)objectHash.get( structureComponent.structure );
			Object sceneObject = (Object) structureHash.get( structureComponent );
			
//			System.out.println("scene object = " + sceneObject);
			
			Bond bond = (Bond)structureComponent;
			
			//identify the parent Structure and StructureStyles object
			Atom a1 = bond.getAtom(0);
			Atom a2 = bond.getAtom(1);
			
			structureMap = a1.structure.getStructureMap( );
			structureStyles = structureMap.getStructureStyles( );
			
			int renderingFlag = 0;
			
			int rm1 = a1.render;
			int rm2 = a2.render;
			
			//get rendering modes of the two atoms and accept the higher one
			if (rm1 >= rm2 ){
				renderingFlag = rm1;
			}
			else{
				renderingFlag = rm2;
			}
			
			Atom selectedAtom = null;
			
			
			//get their coordinates
			Vec3f a1_coord = new Vec3f((float)a1.coordinate[0], (float)a1.coordinate[1], (float)a1.coordinate[2]);
			Vec3f a2_coord = new Vec3f((float)a2.coordinate[0], (float)a2.coordinate[1], (float)a2.coordinate[2]);
			
			//get the pick coordinates
			Vec3f pick_coord = new Vec3f((float)event.coordinate[0], (float)event.coordinate[1], (float)event.coordinate[2]);
//			System.out.println("Pick: " + event.coordinate[0] + "," + event.coordinate[1] + "," + event.coordinate[2]);
			
			float distance1 = Algebra.distance(a1_coord, pick_coord);
			float distance2 = Algebra.distance(a2_coord, pick_coord);
			
			if (distance1 < distance2){
				selectedAtom = a1;
			}
			else{
				selectedAtom = a2;
			}
			
			
			//only the clicked point will get selected
			//get the message for the status line
			String status = null;
			String name = null;
			Set k = structures.keySet();
			Iterator t = k.iterator();
			while (t.hasNext()){
				StructureEntry e = (StructureEntry)t.next();
			 	if (((StructureEntry)e).getStructure() == selectedAtom.structure){
			 		name = e.getName();
			 		break;
			 	}
			}
			
			if (selectedAtom.chain_id.length() > 0){
				status = name + ":" + selectedAtom.chain_id + ":" + selectedAtom.compound + selectedAtom.residue_id + ":" + selectedAtom.name;
			}
			else{
				status = name + ":_:" + selectedAtom.compound + selectedAtom.residue_id + ":" + selectedAtom.name;
			}
			Status.output(Status.LEVEL_REMARK, status);
			
			if (displayDialogActive){
				String local = null;
				if (selectedAtom.chain_id.length() > 0){
					local = name + ":" + selectedAtom.chain_id + ":" + selectedAtom.compound + selectedAtom.residue_id + ":" + selectedAtom.name;
				}
				else{
					local = name + ":_:" + selectedAtom.compound + selectedAtom.residue_id + ":" + selectedAtom.name;
				}
				try{
					structureDocument.parent.getDisplayDialog().processPick(status, selectedAtom);
				}
				catch (ClassCastException ex){
					structureDocument.parent.displayErrorMessage("For this operation you must pick atoms");
				}
				catch (Exception e){
					//most likely, the bond angle monitor is open, so ignore it
				}
				return;
			}

			
			if (FragmentRegistry.activeFragment != null){
				//attach the active fragment to the selected atom

				String active = FragmentRegistry.activeFragment;
				if (active.equals("41") || active.equals("42") || active.equals("43") || active.equals("44")){
					
					if (StylesPreferences.undoEnabled) saveStateForUndo();
					
					if (active.equals("41")) bond.setOrder(1.0f);
					if (active.equals("42")) bond.setOrder(1.5f);
					if (active.equals("43")) bond.setOrder(2.0f);
					if (active.equals("44")) bond.setOrder(3.0f);
					
					StructureMath.checkHydrogens(a1, this, 7.0f, false);
					StructureMath.checkHydrogens(a2, this, 7.0f, false);
					
					GlRenderable r = (GlRenderable)structureHash.get(bond);
					if (r == null) return;
							
					r.setDirty();
							
					bond.structure.getStructureMap().bondOrderUserAssigned = true;
					structureDocument.parent.updateView();

					return;
				}

				try{
					if (selectedAtom.element == 1){
						attachFragment(selectedAtom);
						return;
					}
				}
				catch (Exception ex){
					ex.printStackTrace();
				}
			}

			
//			System.out.println("Selected atom = " + selectedAtom.name);
//			System.out.println("previous state = " + selectedAtom.structure.getStructureMap().getStructureStyles().isSelected(selectedAtom));
			
			if (StylesPreferences.selectionLevel == StylesPreferences.SELECTION_ATOM){
				
								

				boolean selectionState = ! structureStyles.isSelected( selectedAtom );
				
//				System.out.println("selectionState for atom = " + selectionState);
				
				//select the atom
				if (selectionState){
					if (!event.mouseEvent.isControlDown()){
						if (StylesPreferences.selectionMode == StylesPreferences.SELECTION_REPLACE){
							for (int i = 0; i < structureDocument.getEntryCount(); i++){
								Structure s = (Structure)structures.get(structureDocument.getEntry(i));
								if (s != null) s.getStructureMap().getStructureStyles().selectNone(true, false);
							}
							
	/*						for (int i = selectedChains.size()-1; i >= 0; i--){
								Chain c = (Chain)selectedChains.get(i);
								c.structure.getStructureMap().getStructureStyles().updateChain(c);
							}
	*/						if (structureStyles.getSelectionFlag() != StructureStyles.FLAG_NONE){
								//also check if other chains in this structure need to be updated since they got deselected
								for (int i = selectedChains.size()-1; i >= 0; i--){
									Chain cc = (Chain)selectedChains.get(i);
	//								if (cc.structure == bond.structure){
										structureStyles.updateChain(cc, true);
	//								}
	//								selectedChains.remove(cc);
								}
							}
							
							//monitor selection
							MonitorDialog md = structureDocument.parent.getMonitorDialog();
							if (md != null){
								md.clearSelection();
							}
							else{
								clearAnnotationSelection();
							}
						}

					}
				}
				
				//update label selection, if any
				if (StylesPreferences.selectAtomLabel){
					if (atomToLabels.containsKey(selectedAtom)){
						//select the label as well
						LabelComponent lc = (LabelComponent)atomToLabels.get(selectedAtom);
						lc.setSelected(selectionState);
						GlRenderable r = (GlRenderable)labels.get(lc);
						if (r != null) r.setDirty();
						
						//update the monitor dialog if it's present
						MonitorDialog md = structureDocument.parent.getMonitorDialog();
						if (md != null){
							md.setSelection(lc, selectionState);
							md.repaintTree();
						}
					}
					else if (atomToResidueLabels.containsKey(selectedAtom)){
						//select the label as well
						ResidueLabelComponent lc = (ResidueLabelComponent)atomToResidueLabels.get(selectedAtom);
						lc.setSelected(selectionState);
						GlRenderable r = (GlRenderable)labels.get(lc);
						if (r != null) r.setDirty();
						
						//update the monitor dialog if it's present
						MonitorDialog md = structureDocument.parent.getMonitorDialog();
						if (md != null){
							md.setSelection(lc, selectionState);
							md.repaintTree();
						}
					}

				}

				
				structureStyles.setSelected( selectedAtom, selectionState, true, true);
				StructureBrowser sb = structureDocument.parent.getStructureBrowser();
				if (sb != null) sb.expandToNode(selectedAtom);

				structureDocument.parent.updateView();
				
			}
			else if (StylesPreferences.selectionLevel == StylesPreferences.SELECTION_RESIDUE){
			
				//select all atoms and bonds that belong to the residue that just got clicked
				//first, identify the residue
				Residue res = structureMap.getResidue(selectedAtom);
				
				//get the current selection state of this residue
				boolean selectionState = ! structureStyles.isSelected(res);
				
//				System.out.println("new selection state = " + selectionState);

				if (selectionState){
					//check for modifier keys
					if (!event.mouseEvent.isControlDown()){
						if (StylesPreferences.selectionMode == StylesPreferences.SELECTION_REPLACE){
							for (int i = 0; i < structureDocument.getEntryCount(); i++){
								Structure s = (Structure)structures.get(structureDocument.getEntry(i));
								if (s != null) s.getStructureMap().getStructureStyles().selectNone(true, false);
							}
							
//							for (int i = selectedChains.size()-1; i >= 0; i--){
//								Chain c = (Chain)selectedChains.get(i);
//								c.structure.getStructureMap().getStructureStyles().updateChain(c);
//							}
							if (structureStyles.getSelectionFlag() != StructureStyles.FLAG_NONE){

								//also check if other chains in this structure need to be updated since they got deselected
								for (int i = selectedChains.size()-1; i >= 0; i--){
									Chain cc = (Chain)selectedChains.get(i);
//									if (cc.structure == res.structure){
										structureStyles.updateChain(cc, true);
//									}
//									selectedChains.remove(cc);
								}
							}
							
							//monitor selection
							MonitorDialog md = structureDocument.parent.getMonitorDialog();
							if (md != null){
								md.clearSelection();
							}
							else{
								clearAnnotationSelection();
							}
						}

					}
				}
				
				structureStyles.setSelected(res, selectionState, true, true);
				Chain chain = structureMap.getChain(res.getAtom(0));
				structureStyles.updateChain(chain, true);
				
/*				if (selectionState){
					if (!selectedChains.contains(chain)) selectedChains.add(chain);
				}
				else{
					//check whether there is any other residue selected within this chain
					//if not, remove it from selectedChains
					boolean remove = true;
					for (int j = 0; j < structureMap.getResidueCount(); j++){
						Residue r = structureMap.getResidue(j);
						if (structureMap.getChain(r.getAtom(0)) == chain){
							if (structureStyles.isSelected(r)){
								remove = false;
								break;
							}
							
						}
					}
					if (remove) selectedChains.remove(chain);
				}
*/				
				StructureBrowser sb = structureDocument.parent.getStructureBrowser();
				if (sb != null) sb.expandToNode(res);

				
				structureDocument.parent.updateView();

			}
		}
		else if ( structureComponentType == StructureComponentRegistry.TYPE_CHAIN ){
			
			Chain c = (Chain)structureComponent;
			//get the closest residue
			PickUtils.setPickLevel(PickUtils.PICK_RESIDUES);
			Atom atom = PickUtils.closestAtom(structureComponent, event.coordinate);
			structureMap = atom.structure.getStructureMap();
			structureStyles = structureMap.getStructureStyles();
			Residue residue = structureMap.getResidue(atom);
			
			//get the message for the status line
			String chainId = null;
			if (atom.chain_id.length() == 0){
				chainId = "_";
			}
			else{
				chainId = atom.chain_id;
			}
			
			String status = null;
			String name = null;
			Set k = structures.keySet();
			Iterator t = k.iterator();
			while (t.hasNext()){
				StructureEntry e = (StructureEntry)t.next();
				if (e.getStructure() == structureComponent.structure){
					name = e.getName();
					break;
				}
			}

			status = name + ":" + chainId + ":" + residue.getCompoundCode() + residue.getResidueId();
			
			Status.output(Status.LEVEL_REMARK, status);
			
			if (displayDialogActive){
				String local = null;
				local = name + ":" + chainId + ":" + residue.getAtom(0).compound + residue.getAtom(0).residue_id;
				structureDocument.parent.getDisplayDialog().processPick(local, atom);
				return;
			}
			
			//check the current status of the residue
			boolean selected = structureMap.getStructureStyles().isSelected(residue);
//			System.out.println("Residue selection: " + selected);
			if (!event.mouseEvent.isControlDown()){
				//clear current selection
				if (StylesPreferences.selectionMode == StylesPreferences.SELECTION_REPLACE){
					for (int i = 0; i < structureDocument.getEntryCount(); i++){
						Structure s = (Structure)structures.get(structureDocument.getEntry(i));
						if (s != null) s.getStructureMap().getStructureStyles().selectNone(true, false);
					}
					
	/*				if (structureStyles.getSelectionFlag() != StructureStyles.FLAG_NONE){
						
						//also check if other chains in this structure need to be updated since they got deselected
						for (int i = selectedChains.size()-1; i >= 0; i--){
							Chain cc = (Chain)selectedChains.get(i);
							if (cc.structure == c.structure){
								structureStyles.updateChain(cc, true);
							}
	//						selectedChains.remove(cc);
						}
					}
	*/				
					//monitor selection
					MonitorDialog md = structureDocument.parent.getMonitorDialog();
					if (md != null){
						md.clearSelection();
					}
					else{
						clearAnnotationSelection();
					}
				}

			}

			
			//add selection to the current
//			System.out.println("setting styles to negative of " + selected);
			structureMap.getStructureStyles().setSelected(residue, !selected, true, true);
			structureMap.getStructureStyles().updateChain(c, true);
			

/*			if (!selected){
				if (!selectedChains.contains(c)) selectedChains.add(c);
				
			}
			else{
				//check whether there is any other residue selected within this chain
				//if not, remove it from selectedChains
				boolean remove = true;
				for (int j = 0; j < structureMap.getResidueCount(); j++){
					Residue r = structureMap.getResidue(j);
					if (structureMap.getChain(r.getAtom(0)) == c){
						if (structureStyles.isSelected(r)){
							remove = false;
							break;
						}
						
					}
				}
				if (remove){
					selectedChains.remove(c);
				}
			}
*/
			StructureBrowser sb = structureDocument.parent.getStructureBrowser();
			if (sb != null) sb.expandToNode(residue);

			structureDocument.parent.updateView();
			
		}

		}
		catch (Exception ex){
			ex.printStackTrace();
			structureDocument.parent.displayExceptionMessage("Exception picking a 3D object", ex);
			return;
		}
		
//		System.out.println("size of bonds = " + selectedBonds.size());
		
			
	}
	
	public HashMap getRenderables(){
		return renderables;
	}
	
	public void setRenderables(HashMap renderables){
		this.renderables = renderables;
		
		Vector r = new Vector();
		Set keys = this.renderables.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			Vector rr = (Vector)this.renderables.get(it.next());
			r.addAll(rr);
		}
		
		geometryViewer.setRenderables(r);
	}

	/**
	 * Sets list of renderables for a specific structure
	 * @param structure
	 * @param renderables
	 */
	public void setRenderables(Structure structure, Vector renderables){
		this.renderables.put(structure, renderables);

		Vector r = new Vector();
		Set keys = this.renderables.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			Vector rr = (Vector)this.renderables.get(it.next());
			r.addAll(rr);
		}
		
		geometryViewer.setRenderables(r);

	}
	
	public void updateAppearance(){
		
		renderablesList = new Vector();
		Set keys = this.renderables.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			Vector rr = (Vector)this.renderables.get(it.next());
			renderablesList.addAll(rr);
		}
		
		keys = bumps.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			renderablesList.add(bumps.get(it.next()));
		}

		keys = hBonds.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			renderablesList.add(hBonds.get(it.next()));
		}
		
		keys = monitors.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			renderablesList.add(monitors.get(it.next()));
		}
		
		keys = labels.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			renderablesList.add(labels.get(it.next()));
		}
		
		keys = clusters.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			Cluster c = (Cluster)it.next();
			ClusterRenderable[] r = (ClusterRenderable[])clusters.get(c);
			if (c.visible1){
				renderablesList.add(r[0]);
			}
			if (c.visible2){
				renderablesList.add(r[1]);
			}
		}
		

		for (int i = renderablesList.size()-1; i >= 0; i--){
			
			GlRenderable rrr = (GlRenderable)renderablesList.get(i);
			if (rrr == null){
				renderablesList.remove(i);
				continue;
			}
			rrr.setDirty();
		}
		
		geometryViewer.setRenderables(renderablesList);
		if (!structureDocument.parent.getHoldDisplayUpdate()) geometryViewer.updateView();
	}
	
	public void setBackground(float[] color){
		geometryViewer.setBackgroundColor(color);
	}
	
	
	
	private void fireStructureComponentEvent(StructureComponentEvent event){
		for ( int i=0; i<componentListeners.size(); i++ )
		{
			StructureComponentEventListener listener =
				(StructureComponentEventListener) componentListeners.elementAt( i );
			listener.processStructureComponentEvent( event );
		}

	}
	
	public ArrayList getDummyAtoms(){
		return dummyAtoms;
	}
	
	public void addDummyAtoms(ArrayList d){
		if (d == null) return;
		for (int i = 0; i < d.size(); i++){
			if (!dummyAtoms.contains(d.get(i))){
				dummyAtoms.add(d.get(i));
			}
		}
	}
	
	public void removeDummyAtom(Atom a){
		if (a == null) return;
		dummyAtoms.remove(a);
	}
	
	public void processMoveEvent(MoveEvent e){
		
		if (e.type == MoveEvent.TYPE_BOND_ROTATION){
			int dx = e.dx;
			int dy = e.dy;
			
			//for now, this has to do with bond rotation
			double angle = (double)dx/2;
			
			//do the rotation of the atoms selected for transformation
			//use geometry transformation instead of changing coordinates and re-drawing the renderables
			//in new locations
			double dif = angle - currentRotationAngle;
			
			//get the matrices first
			double[] matrix = StructureMath.getLinearRotationMatrix(dif, rotationAxis);
			
			//set translation to the origin, then rotation and finally translation back to the 
			//original location
			rotationGroup.setTransform(fromOrigin);
			rotationGroup.setTransform(matrix);
			rotationGroup.setTransform(toOrigin);
			
			//one pixel to the right is + angle
			if (angleDialog != null){
				angleDialog.setAngle(angle);
			}
			
			currentRotationAngle += dif;
			
			//check if any bumps are associated with the rotated atoms and update them
			if (trackBumps || trackGeometry){
				double[] matrix2 = StructureMath.getLinearRotationMatrix(-dif, rotationAxis);
				
//				double[] temp = Algebra.multiplySquareMatrices(fromOrigin, matrix2);
//				double[] temp2 = Algebra.multiplySquareMatrices(temp, toOrigin);
				
				//transform coordinates of atom-specific coordinate arrays
				for (int i = 0; i < rotatedAtoms.size(); i++){
					Atom a = (Atom)rotatedAtoms.get(i);
	
					double[] coordinates = (double[])transformedCoordinates.get(a);
					if (coordinates == null) {
						coordinates = new double[]{ a.coordinate[0], a.coordinate[1], a.coordinate[2] };
						transformedCoordinates.put(a, coordinates);
					}
					
					//transform it
					StructureMath.transformCoordinates(coordinates, toOrigin);
					StructureMath.transformCoordinates(coordinates, matrix2);
					StructureMath.transformCoordinates(coordinates, fromOrigin);
					
//					StructureMath.transformCoordinates(coordinates, temp2);
					
					//check if this atom has a distance monitor with it
					if (atomToMonitors.containsKey(a)){
						Vector mcv = (Vector)atomToMonitors.get(a);
						for (int j = 0; j < mcv.size(); j++){
							MonitorComponent mc = (MonitorComponent)mcv.get(j);
							if (!rotationGroup.containsChild((GlRenderable)monitors.get(mc))){
								//this means that the other atom is fixed, so the monitor needs to be updated
								if (mc.atom1 == a){
									mc.start = (double[])transformedCoordinates.get(a);
								}
								else{
									mc.end = (double[])transformedCoordinates.get(a);
								}
								((GlRenderable)monitors.get(mc)).setDirty();
							}
						}
					}
					
				}
				
				if (trackBumps)	detectBumps(rotatedAtoms, globalResidues, 0.1, false, true);
				
				if (trackGeometry){
					((Atom)rotatedAtoms.get(0)).structure.getStructureMap().computePhiPsi(rotatedResidue, transformedCoordinates);
					((Atom)rotatedAtoms.get(0)).structure.getStructureMap().getStructureStyles().fireGeometryChangeEvent(rotatedResidue);
				}

			}
			else{
				//no tracking, but check whether there are any distance monitors to be updated
				double[] matrix2 = StructureMath.getLinearRotationMatrix(-dif, rotationAxis);
				
				for (int i = 0; i < rotatedAtoms.size(); i++){
					Atom a = (Atom)rotatedAtoms.get(i);
	
					if (atomToMonitors.containsKey(a)){
						double[] coordinates = (double[])transformedCoordinates.get(a);
						if (coordinates == null) {
							coordinates = new double[]{ a.coordinate[0], a.coordinate[1], a.coordinate[2] };
							transformedCoordinates.put(a, coordinates);
						}
						StructureMath.transformCoordinates(coordinates, toOrigin);
						StructureMath.transformCoordinates(coordinates, matrix2);
						StructureMath.transformCoordinates(coordinates, fromOrigin);

						Vector mcv = (Vector)atomToMonitors.get(a);
						for (int j = 0; j < mcv.size(); j++){
							MonitorComponent mc = (MonitorComponent)mcv.get(j);
							if (!rotationGroup.containsChild((GlRenderable)monitors.get(mc))){
								//update the monitor
								if (mc.atom1 == a){
									mc.start = (double[])transformedCoordinates.get(a);
								}
								else{
									mc.end = (double[])transformedCoordinates.get(a);
								}
								((GlRenderable)monitors.get(mc)).setDirty();
							}
						}
					}
				}
			}
			
			//track ramachandran angles if the display is present
		}
		else if (e.type == MoveEvent.TYPE_INDEPENDENT_MOTION){
			
			//coordinate transformation matrices and geometry transforms need to be computed separately,
			//because coordinates are not cumulative, while the geometry transformations are
			//for geometry, each time, the coordinate system needs to be transformed along with the
			//renderables to give the correct directions in the screen coordinates
			
			if (independentSet == null || independentSet.size() == 0) return;
//			System.out.println("independentGroup before = " + independentGroup.getChildCount());
//			System.out.println("renderablesList = " + renderablesList.size());
			
			double[] data = e.data;
			
			if (data.length == 3){
				//it's translation
				//data contains displacement data for coordinate transformation
				
				//use the current coordinate system to transform the input data into the currently correct state
				//the initial (screen) coordinate system is x,y,z with their respective values of 1
				//the actual one is saved in xCoord, yCoord, zCoord variables
				
				//Use motion center as well: to apply translation to the origin and then back (especially important for rotation below)
				//get the transformation of coordinate system from the standard to that of the moving object
				
//				System.out.println("input data = " + data[0] + "," + data[1] + "," + data[2]);
				
				double[] vector = new double[3];
				vector[0] = xCoord[0]*data[0] + xCoord[1]*data[1] + xCoord[2]*data[2];
				vector[1] = yCoord[0]*data[0] + yCoord[1]*data[1] + yCoord[2]*data[2];
				vector[2] = zCoord[0]*data[0] + zCoord[1]*data[1] + zCoord[2]*data[2];
				
//				System.out.println("new data = " + vector[0] + "," + vector[1] + "," + vector[2]);
				
				double[] matrix = StructureMath.getLinearTranslationMatrix(vector);
				
				independentGroup.setTransform(matrix);
				
				//the atom coordinates and motion center use non-transformed vector coordinates, because their change is incremental
				//rather than cumulative, and they exist in the world coordinate space
				
//				if (trackBumps){
					
					double[] matrix2 = StructureMath.getLinearTranslationMatrix(data);
					StructureMath.transformCoordinates(motionCenter, matrix2);//to keep rotation center correct
					
					double[] temp = Algebra.multiplySquareMatrices(coordinateMatrix, matrix2);
					coordinateMatrix = temp;
					
					
	//				System.out.println("new motionCenter coordinates: " + motionCenter[0] + "," + motionCenter[1] + "," + motionCenter[2]);
	
					for (int i = 0; i < independentSet.size(); i++){
						try{
							Atom a = (Atom)independentSet.get(i);
			
							double[] coordinates = (double[])transformedCoordinates.get(a);
							if (coordinates == null) {
								coordinates = new double[]{ a.coordinate[0], a.coordinate[1], a.coordinate[2] };
							}
							
							//transform it, and keep independent from the transformed group
							StructureMath.transformCoordinates(coordinates, matrix2);
							
							if (atomToMonitors.containsKey(a)){
								Vector mcv = (Vector)atomToMonitors.get(a);
								for (int j = 0; j < mcv.size(); j++){
									MonitorComponent mc = (MonitorComponent)mcv.get(j);
									if (!independentGroup.containsChild((GlRenderable)monitors.get(mc))){
										//this means that the other atom is fixed, so the monitor needs to be updated
										if (mc.atom1 == a){
											mc.start = (double[])transformedCoordinates.get(a);
										}
										else{
											mc.end = (double[])transformedCoordinates.get(a);
										}
										((GlRenderable)monitors.get(mc)).setDirty();
									}
								}
							}
	
						}
						catch (ClassCastException ex){
							continue;
						}
					}
					
					if (trackBumps){
						detectBumps(independentComponents, globalResidues, 0.1, false, true);

					}
					else{
						//with no bumps to track, only accumulate transformation matrices, but
						//don't actually transform coordinates of each atom
						//this dramatically speeds up motion
						
						//multiply the coordinate matrix by the newly applied matrix
						
//						StructureMath.transformCoordinates(motionCenter, matrix);//to keep rotation center correct
//						double[] temp = Algebra.multiplySquareMatrices(matrix, coordinateMatrix);
//						coordinateMatrix = temp;
					
						geometryViewer.updateView();
						
					}

				geometryViewer.setMotionCenter(motionCenter);
				
			}
			else{
				//rotation
				double angle = data[0];
				double[] axis = new double[3];
				axis[0] = data[1];
				axis[1] = data[2];
				axis[2] = data[3];
				
//				System.out.println("INPUT axis = " + axis[0] + "," + axis[1] + "," + axis[2]);
				
				
				//transform axes depending on the current coordinate system
				
				double[] vector = new double[3];
				vector[0] = xCoord[0]*axis[0] + xCoord[1]*axis[1] + xCoord[2]*axis[2];
				vector[1] = yCoord[0]*axis[0] + yCoord[1]*axis[1] + yCoord[2]*axis[2];
				vector[2] = zCoord[0]*axis[0] + zCoord[1]*axis[1] + zCoord[2]*axis[2];
				
				//find the projected rotation center point
				
				double[] matrix = StructureMath.getLinearRotationMatrix(Math.toDegrees(angle), vector);
				double[] toOrigin = StructureMath.getToOriginMatrix(initialMotionCenter);
				double[] fromOrigin = StructureMath.getFromOriginMatrix(initialMotionCenter);


				independentGroup.setTransform(fromOrigin);
				independentGroup.setTransform(matrix);
				independentGroup.setTransform(toOrigin);
				
				double[] matrix2 = StructureMath.getLinearRotationMatrix(Math.toDegrees(-angle), axis);

				//transform coordinate system
				StructureMath.transformCoordinates(xCoord, matrix2);
				StructureMath.transformCoordinates(yCoord, matrix2);
				StructureMath.transformCoordinates(zCoord, matrix2);

//				if (trackBumps){
					
					double[] toOrigin2 = StructureMath.getToOriginMatrix(motionCenter);
					double[] fromOrigin2 = StructureMath.getFromOriginMatrix(motionCenter);
					
					
					//transform coordinates of atom-specific coordinate arrays
					for (int i = 0; i < independentSet.size(); i++){
						try{
							Atom a = (Atom)independentSet.get(i);
			
							double[] coordinates = (double[])transformedCoordinates.get(a);
							if (coordinates == null) {
								coordinates = new double[]{ a.coordinate[0], a.coordinate[1], a.coordinate[2] };
							}
							
							//transform it
							StructureMath.transformCoordinates(coordinates, toOrigin2);
							StructureMath.transformCoordinates(coordinates, matrix2);
							StructureMath.transformCoordinates(coordinates, fromOrigin2);
							
//							StructureMath.transformCoordinates(coordinates, temp2);
							
							if (atomToMonitors.containsKey(a)){
								Vector mcv = (Vector)atomToMonitors.get(a);
								for (int j = 0; j < mcv.size(); j++){
									MonitorComponent mc = (MonitorComponent)mcv.get(j);
									if (!independentGroup.containsChild((GlRenderable)monitors.get(mc))){
										//this means that the other atom is fixed, so the monitor needs to be updated
										if (mc.atom1 == a){
											mc.start = (double[])transformedCoordinates.get(a);
										}
										else{
											mc.end = (double[])transformedCoordinates.get(a);
										}
										((GlRenderable)monitors.get(mc)).setDirty();
									}
								}
							}

							
						}
						catch (ClassCastException ex){
							continue;
						}
					}
					
					if (trackBumps){
						detectBumps(independentComponents, globalResidues, 0.1, false, true);
					}
					else{
//						
//						double[] temp = Algebra.multiplySquareMatrices(toOrigin, coordinateMatrix);
//						double[] temp2 = Algebra.multiplySquareMatrices(matrix2, temp);
//						coordinateMatrix = Algebra.multiplySquareMatrices(fromOrigin, temp2);
//						
//						
//						
//						
//						
//						
						
						geometryViewer.updateView();
					}
			}
			
//			System.out.println("independentGroup after = " + independentGroup.getChildCount());

		}
		
		geometryViewer.updateView();
	}
	
	public void acceptRotation(double angle){
		
		angleDialog.showDialog(false);
		structureDocument.parent.setDisplayDialogStatus(false);
		rotationMode = false;
		geometryViewer.setRotationMode(false);
		
		//get the transformation
		//get the axis out of the bond
		StructureMath.rotateStructure(rotationAxis, rotationRootAtom, angle, rotatedAtoms);
		
		//move renderables out of the composite renderable
		Structure structure = ((StructureComponent)rotatedSet.get(0)).structure;
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector localRenderables = (Vector)renderables.get(structure);
		for (int n = 0; n < rotatedSet.size(); n++){
			GlRenderable rs = (GlRenderable)structureHash.get(rotatedSet.get(n));
			if (rs != null){
				rs.setDirty();
				localRenderables.add(rs);
				renderablesList.add(rs);
				rotationGroup.removeChild((GlRenderable)structureHash.get(rotatedSet.get(n)));
			}
		}
		
		//move any remaining markers
		for (int i = 0 ; i < rotationGroup.getChildCount(); i++){
			GlRenderable r = rotationGroup.getChild(i);
			r.setDirty();
			renderablesList.add(r);
			rotationGroup.removeChild(r);
		}
		
		localRenderables.remove(rotationGroup);
		renderablesList.remove(rotationGroup);
		rotationGroup = null;
		rotatedSet.clear();
		rotatedSet = null;
		
		//remove the arrow
		GlRenderable r = (GlRenderable)rotationArrow.get(structure);
		Vector rr = (Vector)renderables.get(structure);
		rr.remove(r);
		renderablesList.remove(r);
		
		structure.getStructureMap().getStructureStyles().setVisible(rotationAxisBond, true, true, false);
		rotationAxisBond = null;
		currentRotationAngle = 0;
		
		if (trackBumps){
			trackBumps = false;
			detectBumps(rotatedAtoms, globalResidues, 0.1, false, false);
		}
		
		
//		long a = System.currentTimeMillis();
		globalResidues.clear();
		
		if (trackGeometry){
			((Atom)rotatedAtoms.get(0)).structure.getStructureMap().computePhiPsi(rotatedResidue, transformedCoordinates);
			((Atom)rotatedAtoms.get(0)).structure.getStructureMap().getStructureStyles().fireGeometryChangeEvent(rotatedResidue);
			rotatedResidue = null;
			trackGeometry = false;
		}
		
		//recompute geometric center for the structure, once the motion is done
		double[] center;
		double[] total = new double[3];
		int atomCount = structure.getStructureMap().getAtomCount();
		for (int i = 0; i < atomCount; i++){
			Atom aa = structure.getStructureMap().getAtom(i);
			total[0] += aa.coordinate[0];
			total[1] += aa.coordinate[1];
			total[2] += aa.coordinate[2];
			
		}
		
		center = new double[]{ total[0]/atomCount, total[1]/atomCount, total[2]/atomCount };
		structure.getStructureMap().setCenter(center);

		
		transformedCoordinates.clear();
		rotatedAtoms.clear();
//		updateAppearance();
		
		geometryViewer.setRenderables(renderablesList);
		geometryViewer.updateView();
		
	}
	
	public void cancelRotation(){
//		System.out.println("start = " + renderablesList.size());
		angleDialog.showDialog(false);
		structureDocument.parent.setDisplayDialogStatus(false);
		rotationMode = false;
		geometryViewer.setRotationMode(false);
				
		//move renderables out of the composite renderable
		Structure structure = ((StructureComponent)rotatedSet.get(0)).structure;
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector localRenderables = (Vector)renderables.get(structure);
		for (int n = 0; n < rotatedSet.size(); n++){
			GlRenderable rs = (GlRenderable)structureHash.get(rotatedSet.get(n));
			if (rs != null){
				rs.setDirty();
				localRenderables.add(rs);
				renderablesList.add(rs);
				rotationGroup.removeChild((GlRenderable)structureHash.get(rotatedSet.get(n)));
			}
		}
		
		//move any remaining markers
		for (int i = 0 ; i < rotationGroup.getChildCount(); i++){
			GlRenderable r = rotationGroup.getChild(i);
			r.setDirty();
			renderablesList.add(r);
			rotationGroup.removeChild(r);
		}

		localRenderables.remove(rotationGroup);
		renderablesList.remove(rotationGroup);
		rotationGroup = null;
		rotatedSet.clear();
		rotatedSet = null;
		
		
		//remove the arrow
		GlRenderable r = (GlRenderable)rotationArrow.get(structure);
		Vector rr = (Vector)renderables.get(structure);
		rr.remove(r);
		renderablesList.remove(r);
		
		structure.getStructureMap().getStructureStyles().setVisible(rotationAxisBond, true, true, false);
		rotationAxisBond = null;
		
		currentRotationAngle = 0;
		
		if (trackBumps){
			trackBumps = false;
			detectBumps(rotatedAtoms, globalResidues, 0.1, false, false);
		}
		
		if (trackGeometry){
			((Atom)rotatedAtoms.get(0)).structure.getStructureMap().computePhiPsi(rotatedResidue, null);
			((Atom)rotatedAtoms.get(0)).structure.getStructureMap().getStructureStyles().fireGeometryChangeEvent(rotatedResidue);
			rotatedResidue = null;
			trackGeometry = false;
		}

		globalResidues.clear();
		rotatedAtoms.clear();
		
		transformedCoordinates.clear();
		
		geometryViewer.setRenderables(renderablesList);
		geometryViewer.updateView();
//		updateAppearance();
//		System.out.println("end = " + renderablesList.size());
		
	}
	
	/**
	 * This method assumes that the necessary bookkeeping operations on StructureMap have been done,
	 * and it figures out what renderables are needed depending on the current display mode of the atom 
	 * the new one gets connected to
	 * @param atom
	 */
	public void addAtom(Atom atom, boolean update){
		
		
//		System.out.println("start: renderablesList = " + renderablesList.size());
		Atom local = (Atom)((Vector)atom.structure.getStructureMap().getAtoms(atom)).get(0);
		StructureStyles styles = local.structure.getStructureMap().getStructureStyles();
		
		short style = local.render;
		short quality = local.quality;
		
		Bond bond = (Bond)((Vector)atom.structure.getStructureMap().getBonds(atom)).get(0);
		
		//check whether the parent atom is in renderablesList or in independentGroup
		if (bond.getAtom(0) == atom){
			if (independentSet != null && independentSet.contains(bond.getAtom(1))){
				independentSet.add(atom);
				independentSet.add(bond);
				transformedCoordinates.put(atom, atom.coordinate);
			}
		}
		if (bond.getAtom(1) == atom){
			if (independentSet != null && independentSet.contains(bond.getAtom(0))){
				independentSet.add(atom);
				independentSet.add(bond);
				transformedCoordinates.put(atom, atom.coordinate);
			}
		}
		
		styles.addStructureComponent(atom, (short)-1, (short)-1, !update);
		styles.addStructureComponent(bond, (short)-1, (short)-1, !update);
		
		/**
		 * TODO a hack to avoid rewriting the event model for atom additions
		 * call a method in structureBrowser directly
		 * 
		 */
		
		StructureBrowser sb = structureDocument.parent.getStructureBrowser();
		if (sb != null) sb.addAtom(atom);
		
		styles.setRenderingStyle(atom, style, quality, !update);
		styles.setRenderingStyle(bond, style, quality, !update);

		
		if (update) structureDocument.parent.updateView();
		
	}
	
	public void saveImage(int x, int y, int width, int height, int resolution){
		
		
		int screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
//		System.out.println("screen = " + screenResolution);
		float ratio = 1.0f;
		
		BufferedImage image = null;
		
		if (resolution == 0){
			//screen resolution is requested
//			System.out.println("getBufferedImage");
			image = geometryViewer.getBufferedImage( );
			try{
				ImageHandler.saveImage(structureDocument.parent, image);
			}
			catch (Exception ex){
				structureDocument.parent.displayExceptionMessage("Exception saving image", ex);
			}
		}
		else{
			//higher resolution is requested
			geometryViewer.requestImage(x, y, width, height, resolution);
			//now wait for the image
			Thread runner = new Thread(){
				public void run(){
					try{
						BufferedImage image = null;
						while (true){
							image = geometryViewer.getImage();
							if (image != null) break;
							Thread.sleep(30);
						}
						ImageHandler.saveImage(structureDocument.parent, image);
					}
					catch (Exception ex){
						System.err.println("exception waiting for image: " + ex);
					}
					
				}
			};
			runner.start();
			
		}
		
	}
	
	private void clearGlResources( )
	{
        try
        {
			GLAutoDrawable drawable = geometryViewer.getDrawable( );
			GLContext context = drawable.getContext( );
			GL gl = context.getGL( );
            if ( context.makeCurrent() == GLContext.CONTEXT_NOT_CURRENT )
            {
                System.err.println( "Error getting GL context" );
            }
			else
			{
				int renderableCount = renderablesList.size( );
				for ( int r=0; r < renderableCount; r++ )
				{
					GlRenderable renderable =
						(GlRenderable) renderablesList.get( r );
					if ( renderable instanceof MbtRenderable )
						((MbtRenderable)renderable).freeGlResources( gl );
					if (renderable instanceof MonitorRenderable)
						((MonitorRenderable)renderable).freeGlResources( gl );
				}
				context.release( );
			}
        }
        catch ( GLException e )
        {
            System.err.println( "Error freeing GL context resources" );
        }
	}


	
	/**
	 * @return Returns the geometryViewer.
	 */
	public final GlGeometryViewer getGeometryViewer() {
		return geometryViewer;
	}
	
	public Vector getLoadedStructures(){
		return structureList;
	}
	
	public Vector getLoadedEntries(){
		//return keys of the structures hash
		Vector out = new Vector();
		Set keys = structures.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			out.add(it.next());
		}
		
		return out;
	}
	
	public void updateBoundWaters(boolean update){
		//walk through the HOH residues and check if they should have dummies
		boolean show = StylesPreferences.showBoundWaters;
		Vector s = getLoadedStructures();
		for (int i = 0; i < s.size(); i++){
			Structure ss = (Structure)s.get(i);
			updateBoundWaters(ss, update);
		}
	}
	
	public void updateBoundWaters(Structure structure, boolean update){
		
		Vector chains = structure.getStructureMap().getChains();
		for (int n = 0; n < chains.size(); n++){
			Chain chain = (Chain)chains.get(n);
			for (int j = 0; j < chain.getResidueCount(); j++){
				Residue residue = chain.getResidue(j);
				if (residue.getCompoundCode().equals("HOH")){
					
					//depending on the setting in preferences, decide on whether to create or remove a dummy atom
					StructureStyles styles = residue.structure.getStructureMap().getStructureStyles();
					Vector atoms = residue.getAtoms();
					if (atoms == null || atoms.size() == 0) return;
					
					residue.visible = StylesPreferences.showBoundWaters;
					
					Hashtable structureHash = (Hashtable)objectHash.get(residue.structure);
					Vector localRenderables = (Vector)renderables.get(residue.structure);
					
					for (int i = 0; i < atoms.size(); i++){
						Atom a = (Atom)atoms.get(i);
						
						styles.setVisible(a, StylesPreferences.showBoundWaters, false, true);//to keep things consistent
						if (structureHash.containsKey(a)){
							if (!StylesPreferences.showBoundWaters){//not needed, so no geometry is needed
								//delete the dummy geometry
								GlRenderable r = (GlRenderable)structureHash.get(a);
								localRenderables.remove(r);
		
								dummyAtoms.remove(a);
								structureHash.remove(a);
								hiddenComponents.remove(a);
								
								renderablesList.remove(r);
								geometryViewer.setRenderables(renderablesList);
								geometryViewer.updateView();
								continue;
							}
						}
						
						
						
						Vector bonds = residue.structure.getStructureMap().getBonds(a);
						boolean vis = false;
						if (bonds != null && bonds.size() > 0){
							for (int k = 0; k < bonds.size(); k++){
								if (((Bond)bonds.get(k)).visible){
									vis = true;
									break;
								}
							}
						}
						else{
							//a typical case with protein waters, when there are no explicit bonds
							//create a dummy if requested
							if (structureHash.containsKey(a) && !StylesPreferences.showBoundWaters){
								//remove. but this is never executed, since this is done in another clause above
								GlRenderable r = (GlRenderable)structureHash.get(a);
								localRenderables.remove(r);
		
								dummyAtoms.remove(a);
								structureHash.remove(a);
								hiddenComponents.remove(a);
								
								renderablesList.remove(r);
								geometryViewer.setRenderables(renderablesList);
								geometryViewer.updateView();
							}
							
							if (!structureHash.containsKey(a) && StylesPreferences.showBoundWaters){
								//atom needs to be added and geometry needs to be created
								MbtRenderable rr = null;
								if (a.render == StylesPreferences.RENDERING_LINES){
									AtomLineGeometry atomGeometry = new AtomLineGeometry( );
									rr = new MbtRenderable(a, styles, atomGeometry);
									dummyAtoms.add(a);
								}
								else{
									AtomGeometry atomGeometry = new AtomGeometry();
									rr = new MbtRenderable(a, styles, atomGeometry);
								}
								localRenderables.add(rr);
								structureHash.put(a, rr);
	
								
								renderablesList.add(rr);
								geometryViewer.setRenderables(renderablesList);
								geometryViewer.updateView();
							}
							
							continue;
						}
						
						if (!vis){
							if (!structureHash.containsKey(a) && StylesPreferences.showBoundWaters){
								//atom needs to be added and geometry needs to be created
								MbtRenderable rr = null;
								if (a.render == StylesPreferences.RENDERING_LINES){
									AtomLineGeometry atomGeometry = new AtomLineGeometry( );
									rr = new MbtRenderable(a, styles, atomGeometry);
									dummyAtoms.add(a);
								}
								else{
									AtomGeometry atomGeometry = new AtomGeometry();
									rr = new MbtRenderable(a, styles, atomGeometry);
								}
								localRenderables.add(rr);
								structureHash.put(a, rr);
	
								
								renderablesList.add(rr);
								geometryViewer.setRenderables(renderablesList);
								geometryViewer.updateView();
							}
						}
						else if (!vis && structureHash.containsKey(a) && !StylesPreferences.showBoundWaters){
							//atom is hidden along with the bonds - no dummy is needed
							//delete the geometry
							localRenderables.remove(structureHash.get(a));
							dummyAtoms.remove(a);
	
							renderablesList.remove(structureHash.get(a));
							geometryViewer.setRenderables(renderablesList);
							geometryViewer.updateView();
	
							hiddenComponents.remove(a);
							structureHash.remove(a);
						}
						else if (vis && structureHash.containsKey(a)){
							//there is at least one visible bond and the atom is visible
							//no dummy is needed
							localRenderables.remove(structureHash.get(a));
							dummyAtoms.remove(a);
	
							renderablesList.remove(structureHash.get(a));
							geometryViewer.setRenderables(renderablesList);
							geometryViewer.updateView();
	
							structureHash.remove(a);
						}
						
						
					}
					StructureBrowser sb = structureDocument.parent.getStructureBrowser();
					if (sb != null) sb.updateVisibility(residue);
				}
			}
			
		}
		
		if (update) geometryViewer.updateView();
	}
	
	public void updateMouseResponse(int f){
		geometryViewer.updateMouseResponse(f);
	}
	
	
	public void selectByResidue(String name){
		Vector s = getLoadedStructures();
		Vector chains = new Vector();
		for (int i = 0; i < s.size(); i++){
			Structure structure = (Structure)s.get(i);
			StructureMap map = structure.getStructureMap();
			StructureStyles styles = map.getStructureStyles();
			styles.selectNone(true, false);
			
			//also check if other chains in this structure need to be updated since they got deselected
			for (int j = selectedChains.size()-1; j >= 0; j--){
				Chain cc = (Chain)selectedChains.get(j);
//				if (cc.structure == structure){
					styles.updateChain(cc, true);
//				}
//				selectedChains.remove(cc);
			}

			for (int j = 0; j < structure.getStructureMap().getResidueCount(); j++){
				Residue residue = structure.getStructureMap().getResidue(j);
				if (residue.getCompoundCode().equals(name)){
					styles.setSelected(residue, true, StylesPreferences.commonSelection, true);
					if (!chains.contains(map.getChain(residue.getAtom(0)))) chains.add(map.getChain(residue.getAtom(0)));
				}
			}
		}
		
		for (int i = 0; i < chains.size(); i++){
			Chain c = (Chain)chains.get(i);
			c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
//			selectedChains.add(c);
		}
		
		structureDocument.parent.updateView();
		
	}
	
	public void selectByElement(String element){
		for (int i = 0; i < structureList.size(); i++){
			Structure structure = (Structure)structureList.get(i);
			StructureStyles styles = structure.getStructureMap().getStructureStyles();
			for (int j = 0; j < structure.getStructureMap().getAtomCount(); j++){
				Atom a = structure.getStructureMap().getAtom(j);
				if (a.getElement().equals(element)){
					styles.setSelected(a, true, true, true);
				}
			}
		}
		
		geometryViewer.updateView();
	}
	
	public void selectByRadius(Atom atom, float radius, boolean includeResidues){
		Vector s = getLoadedStructures();
		Vector chains = new Vector();//chains affected by the change
		if (includeResidues){
			Vector residues = new Vector();
			for (int i = 0; i < s.size(); i++){
				Structure structure = (Structure)s.get(i);
				StructureStyles styles = structure.getStructureMap().getStructureStyles();
				StructureMap map = structure.getStructureMap();
				styles.selectNone(true, false);
				
				//also check if other chains in this structure need to be updated since they got deselected
				for (int j = selectedChains.size()-1; j >= 0; j--){
					Chain cc = (Chain)selectedChains.get(j);
//					if (cc.structure == structure){
						styles.updateChain(cc, true);
//					}
//					selectedChains.remove(cc);
				}
				
				for (int j = 0; j < map.getAtomCount(); j++){
					Atom a = map.getAtom(j);
					if (Algebra.distance(a.coordinate, atom.coordinate) <= radius){
						Residue r = map.getResidue(a);
						if (!residues.contains(r)) residues.add(r);
						if (!chains.contains(map.getChain(a))) chains.add(map.getChain(a));
					}
				}
			}
			
			//scan residues and fire events
			for (int i = 0; i < residues.size(); i++){
				Residue r = (Residue)residues.get(i);
				r.structure.getStructureMap().getStructureStyles().setSelected(r, true, true, true);
			}
			
			for (int i = 0; i < chains.size(); i++){
				Chain c = (Chain)chains.get(i);
				c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
//				selectedChains.add(c);
			}
		}
		else{
			for (int i = 0; i < s.size(); i++){
				Structure structure = (Structure)s.get(i);
				StructureMap map = structure.getStructureMap();
				StructureStyles styles = structure.getStructureMap().getStructureStyles();
				styles.selectNone(true, false);
				
				//also check if other chains in this structure need to be updated since they got deselected
				for (int j = selectedChains.size()-1; j >= 0; j--){
					Chain cc = (Chain)selectedChains.get(j);
//					if (cc.structure == structure){
						styles.updateChain(cc, true);
//					}
//					selectedChains.remove(cc);
				}

				
				for (int j = 0; j < structure.getStructureMap().getAtomCount(); j++){
					Atom a = structure.getStructureMap().getAtom(j);
					if (Algebra.distance(a.coordinate, atom.coordinate) <= radius){
						styles.setSelected(a, true, true, true);
						if (!chains.contains(map.getChain(a))) chains.add(map.getChain(a));
					}
				}
				
			}
			
			for (int j = 0; j < chains.size(); j++){
				Chain c = (Chain)chains.get(j);
				c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
//				selectedChains.add(c);
			}

		}
		structureDocument.parent.updateView();
	}
	
	/**
	 * Boolean parameter determines whether to look for bumps between the members of the set
	 * and the rest of the display
	 * @param atoms
	 * @param overlap
	 * @param intra
	 */
	public void detectBumps(Vector atoms, double overlap, boolean intra, boolean noProgress){
		if (atoms == null || atoms.size() == 0) return;
		Vector protein = new Vector();
		//it is assumed that it's only atoms vs the rest of the displayed structures
		for (int j = 0; j < this.getLoadedStructures().size(); j++){
			Structure structure = (Structure)this.getLoadedStructures().get(j);
			StructureMap map = structure.getStructureMap();
			for (int i = 0; i < map.getResidueCount(); i++){
				Residue a = map.getResidue(i);
				if (atoms.contains(a))continue;
				protein.add(a);
			}
		}
		detectBumps(atoms, protein, overlap, intra, noProgress);
	}
	

	public void detectBumps(Vector ligand, Vector protein, double overlap, boolean intra, boolean noProgress){
		
		//scan through all atom pairs and determine which ones (non-bonded) are closer
		//than the sum of their VdW radii - overlap
		
		//sets of ligand and protein atoms are actually collections of Residue and Atom objects
		//Atoms are those that are not in the Residue objects, but defined/selected individually
		//this is done to speed up bump checking by checking only one atom from each residue for
		//preliminary distance evaluation
		//this especially speeds things up for protein-protein calculations, especially in motion
		
		//set up progress display if needed
		boolean progress = false;
		float percentDone = 1.0f;
		int onePercent = 1;
		if (!noProgress && ligand.size() > 1000){
			progress = true;
			onePercent = ( ligand.size()/ 100);
			if ( onePercent <= 0 ) onePercent = 1;
			percentDone = 0.0f;
			Status.progress( percentDone, "Detecting steric clashes");
		}
		
//		System.out.println("Ligand size = " + ligand.size() + ", protein size = " + protein.size());
		
		double CUTOFF = 15;//if atom 0 of a Residue is farther than this, the residue is skipped entirely from the calculation
		if (!noProgress){
			//static bump check
			CUTOFF = 20;//more time to spend on calculation
		}
		//make two passes: one with Residues on both sides, the other one with Atoms
		
		int counter = 0;
		for (int i = 0; i < ligand.size(); i++){
			try{
				Residue residue = (Residue)ligand.get(i);
				
				StructureMap map = residue.structure.getStructureMap();
				for (int j = 0; j < protein.size(); j++){
					try{
						Residue r = (Residue)protein.get(j);
						
						if (!intra && ligand.contains(r)) continue;
						
						//evaluate the distance
						double dist = 0.0;
						if (trackBumps){
							dist = Algebra.distance((double[])transformedCoordinates.get(residue.centerAtom), r.centerAtom.coordinate);
						}
						else{
							dist = Algebra.distance(residue.centerAtom.coordinate, r.centerAtom.coordinate);
						}

						if (dist > CUTOFF){
							continue;
						}
						
						//at this point, these two residues are within the checking range, so look at their atoms
						for (int n = 0; n < residue.getAtomCount(); n++){
							Atom atom = residue.getAtom(n);
							if (!atom.visible) continue;
							
							for (int m = 0; m < r.getAtomCount(); m++){
								Atom a = r.getAtom(m);
								if (a == atom) continue;//same atom
								if (!a.visible) continue;//if invisible
								if (!intra && ligand.contains(a)) continue;
								checkBumps(atom, a);
								
							}
						}
					}
					catch (ClassCastException e){
						//StructureComponent of the protein structure is not a Residue but an individual Atom
						//check the Atom, then
						Atom a = (Atom)protein.get(j);
						
						if (!intra && ligand.contains(a)) continue;
						
						//evaluate the distance
						double dist = Algebra.distance(residue.centerAtom.coordinate, a.coordinate);
						if (dist > CUTOFF) continue;
						
						
						//at this point, start scan
						for (int n = 0; n < residue.getAtomCount(); n++){
							Atom atom = residue.getAtom(n);
							if (!atom.visible) continue;
							
							checkBumps(atom, a);

						}	
					}
					
				}
				
				if ( progress && i % onePercent == 0 )
				{
					percentDone = (float) i / (float) map.getAtomCount();
					Status.progress( percentDone, "Detecting steric clashes" );
				}
				

			}
			catch (ClassCastException e){
				//ligand component is an atom, rather than Residue
				Atom atom = (Atom)ligand.get(i);
				if (!atom.visible) continue;
				
				StructureMap map = atom.structure.getStructureMap();
				for (int j = 0; j < protein.size(); j++){
					try{
						Residue r = (Residue)protein.get(j);
						
						if (!intra && ligand.contains(r)) continue;
						
						//evaluate the distance
						double dist = 0.0;
						if (trackBumps){
							dist = Algebra.distance((double[])transformedCoordinates.get(atom), r.centerAtom.coordinate);
						}
						else{
							dist = Algebra.distance(atom.coordinate, r.centerAtom.coordinate);
						}

						if (dist > CUTOFF){
							continue;
						}
						//at this point, these two residues are within the checking range, so look at their atoms
							
						for (int m = 0; m < r.getAtomCount(); m++){
							Atom a = r.getAtom(m);
							if (a == atom) continue;//same atom
							if (!a.visible) continue;//if invisible
							if (!intra && ligand.contains(a)) continue;
							
							checkBumps(atom, a);
						}
					}
					catch (ClassCastException ex){
						//StructureComponent of the protein structure is not a Residue but an individual Atom
						//check the Atom, then
						Atom a = (Atom)protein.get(j);
						if (!a.visible) continue;
						
						if (!intra && ligand.contains(a)) continue;
						
						//evaluate the distance
						double dist = Algebra.distance(atom.coordinate, a.coordinate);
						if (dist > CUTOFF) continue;
						
						checkBumps(atom, a);
					}
					
				}
				
			}
		}
		
		if (progress)Status.progress( 1.0f, null );
		
		structureDocument.parent.updateMonitorDialog();
		geometryViewer.updateView();
	}
	
	private void checkBumps(Atom atom, Atom a){
		
		if (a == atom) return;//same atom
		
		Vector bumps1 = (Vector)atomToBumps.get(atom);//bumps for atom
		Vector atoms1 = atom.structure.getStructureMap().getAtoms(atom);
	
		if (!a.visible) return;//if invisible
		if (atoms1 != null && atoms1.contains(a)) return;//they are bonded
		
		//get bumps for a
		Vector bumps2 = (Vector)atomToBumps.get(a);
	
		double distance = 10;
		double[] a1 = null;
		double[] a2 = null;
		if (trackBumps){
			if (transformedCoordinates.containsKey(atom)){
				a1 = (double[])transformedCoordinates.get(atom);
			}
			else{
				a1 = atom.coordinate;
			}
			if (transformedCoordinates.containsKey(a)){
				a2 = (double[])transformedCoordinates.get(a);
			}
			else{
				a2 = a.coordinate;
			}
			//instead of actual coordinates, use new transformed values
			distance = Algebra.distance(a1, a2);
		}
		else{
			distance = Algebra.distance(atom.coordinate, a.coordinate);
		}

		double sum = ElementProperties.getAtomRadius(atom.element)*0.8 + ElementProperties.getAtomRadius(a.element) * 0.8;

		
		if (distance < sum){
			//further check - omit atoms that are bonded through a third atom
			Vector atoms2 = a.structure.getStructureMap().getAtoms(a);
			if (atoms1 != null && atoms2 != null){
				boolean exit = false;
				for (int k = 0; k < atoms1.size(); k++){
					if (atoms2.contains(atoms1.get(k))){
						exit = true;
						break;
					}
				}
				
				if (exit) return;
			}
			
			//check if there is already bump between these two atoms
			boolean exists = false;
			StericBumpComponent bump = null;
			if (bumps1 != null && bumps2 != null){
				for (int k = 0; k < bumps2.size(); k++){
					if (bumps1.contains(bumps2.get(k))){
						exists = true;
						bump = (StericBumpComponent)bumps2.get(k);
						break;
					}
				}
			}
			
			if (exists){
				//there is already a bump between these atoms
				if (trackBumps){
					bump.start = a1;
					bump.end = a2;
				}
				else{
					bump.resetCoordinates();
				}
				MonitorRenderable r = (MonitorRenderable)bumps.get(bump);
				if (r != null) r.setDirty();
			}
			else{
				//bump needs to be created
				StericBumpComponent b = new StericBumpComponent(atom, a, null);
				if (trackBumps){
					b.start = a1;
					b.end = a2;
				}
				else{
					b.resetCoordinates();
				}
				Vector b1 = (Vector)atomToBumps.get(atom);
				if (b1 == null){
					b1 = new Vector();
					atomToBumps.put(atom, b1);
				}
				b1.add(b);
				Vector b2 = (Vector)atomToBumps.get(a);
				if (b2 == null){
					b2 = new Vector();
					atomToBumps.put(a, b2);
				}
				b2.add(b);
				
				//create a renderable for it
				MonitorRenderable rr = new MonitorRenderable(b, (AnnotationGeometry)defaultGeometry.get("MonitorGeometry"));//don't translate
				
				bumps.put(b, rr);
				renderablesList.add(rr);
				
			}
		}
		else{
			//this is not a bump. Check whether it used to be a bump, and the geometry 
			//and the bump record need to be deleted
//			System.out.println("delete bump between " + atom.name + " and " + a.name);
			boolean exists = false;
			StericBumpComponent bump = null;
			if (bumps1 != null && bumps2 != null){
//				System.out.println("both non-null");
				for (int k = bumps2.size()-1; k >= 0; k--){
					if (bumps1.contains(bumps2.get(k))){
						exists = true;
						bump = (StericBumpComponent)bumps2.get(k);
						break;
					}
				}
			}
			
			
//			System.out.println("exists = " + exists);
			
			if (exists){
				removeBump(bump, false);
			}
		}

	}
	
	public void createBump(Atom a1, Atom a2, boolean updateView){
		StericBumpComponent b = new StericBumpComponent(a1, a2, null);
		
		Vector b1 = (Vector)atomToBumps.get(a1);
		if (b1 == null){
			b1 = new Vector();
			atomToBumps.put(a1, b1);
		}
		b1.add(b);
		Vector b2 = (Vector)atomToBumps.get(a2);
		if (b2 == null){
			b2 = new Vector();
			atomToBumps.put(a2, b2);
		}
		b2.add(b);
		
		//create a renderable for it
		MonitorRenderable rr = new MonitorRenderable(b, (AnnotationGeometry)defaultGeometry.get("MonitorGeometry"));//don't translate
		
		bumps.put(b, rr);
		if (independentSet != null){
			if (independentSet.contains(a1) || independentSet.contains(a2)){
				independentGroup.addChild(rr);
			}
			else{
				renderablesList.add(rr);
			}
		}
		else{
			renderablesList.add(rr);
		}
		
		if (updateView){
			geometryViewer.setRenderables(renderablesList);
			geometryViewer.updateView();
		}
		
	}
	
/*	public void deleteBump(StericBumpComponent bump, boolean update){
		
		if (bump == null) return;
		
		MonitorRenderable r = (MonitorRenderable)bumps.get(bump);
		renderablesList.remove(r);
		bumps.remove(bump);
		
		Atom a1 = bump.atom1;
		Atom a2 = bump.atom2;
		
		Vector b1 = (Vector)atomToBumps.get(a1);
		if (b1 != null) b1.remove(bump);
		
		Vector b2 = (Vector)atomToBumps.get(a2);
		if (b2 != null) b2.remove(bump);
		
		if (update){
			geometryViewer.setRenderables(renderablesList);
			geometryViewer.updateView();
		}
	}
*/	
	public void selectBackbone(){
		//select backbone atoms in all loaded structures
		for (int j = 0; j < this.getLoadedStructures().size(); j++){
			Structure structure = (Structure)this.getLoadedStructures().get(j);
			StructureStyles styles = structure.getStructureMap().getStructureStyles();
			
			styles.selectNone(true, false);
			
			StructureMap map = structure.getStructureMap();
			
			for (int i = 0; i < map.getAtomCount(); i++){
				Atom a = map.getAtom(i);
				if (a.backbone){
					styles.setSelected(a, true, true, true);
				}
			}
		}
		
		structureDocument.parent.updateView();

	}
	
	
	public void selectByVisibility(boolean visible){/*
		
		Vector chains = new Vector();
		for (int j = 0; j < this.getLoadedStructures().size(); j++){
			Structure structure = (Structure)this.getLoadedStructures().get(j);
			StructureStyles styles = structure.getStructureMap().getStructureStyles();
			
			styles.selectNone(true, false);
			
			//also check if other chains in this structure need to be updated since they got deselected
			for (int i = selectedChains.size()-1; i >= 0; i--){
				Chain cc = (Chain)selectedChains.get(i);
				if (cc.structure == structure){
					styles.updateChain(cc);
				}
				selectedChains.remove(cc);
			}


			Vector residues = new Vector();
			if (visible){
				int count = 0;
				Enumeration visibility = styles.getVisibility().keys();
				while (visibility.hasMoreElements()){
					count++;
					StructureComponent component = (StructureComponent)visibility.nextElement();
					if (component.getStructureComponentType() == StructureComponentRegistry.TYPE_RESIDUE){
						residues.add(component);
						styles.setSelected(component, true, true, true);
						if (!chains.contains(((Residue)component).getAtom(0))) 
							chains.add(component.structure.getStructureMap().getChain(((Residue)component).getAtom(0)));
					}
				}
				
				count = 0;
				//check for leftover atoms
				visibility = styles.getVisibility().keys();
				while (visibility.hasMoreElements()){
					count++;
					StructureComponent component = (StructureComponent)visibility.nextElement();
					if (component.getStructureComponentType() == StructureComponentRegistry.TYPE_ATOM){
						if (residues.contains(component.structure.getStructureMap().getResidue((Atom)component))) continue;
						styles.setSelected(component, true, true, true);
					}
				}
//				System.out.println("visible = " + count);
			}
			else{
				Enumeration invisibility = styles.getInvisibility().keys();
				while (invisibility.hasMoreElements()){
					StructureComponent component = (StructureComponent)invisibility.nextElement();
					if (component.getStructureComponentType() == StructureComponentRegistry.TYPE_RESIDUE){
						residues.add(component);
						styles.setSelected(component, true, false, true);
					}
				}
				//check for leftover atoms
				invisibility = styles.getInvisibility().keys();
				while (invisibility.hasMoreElements()){
					StructureComponent component = (StructureComponent)invisibility.nextElement();
					if (component.getStructureComponentType() == StructureComponentRegistry.TYPE_ATOM){
						if (residues.contains(component.structure.getStructureMap().getResidue((Atom)component))) continue;
						styles.setSelected(component, true, false, true);
					}
				}
			}
		}
		
		for (int i = 0; i < chains.size(); i++){
			Chain c = (Chain)chains.get(i);
			c.structure.getStructureMap().getStructureStyles().updateChain(c);
			selectedChains.add(c);
		}

		
		geometryViewer.updateView();
		
	*/}
	
	public void invertSelection(){
		
		for (int j = 0; j < this.getLoadedStructures().size(); j++){
			Structure structure = (Structure)this.getLoadedStructures().get(j);
			StructureStyles styles = structure.getStructureMap().getStructureStyles();
			
			styles.invertSelection();

		}
		structureDocument.parent.updateAppearance();
	}
	
	/**
	 * Select a group of residues, not necessarily from the same structure
	 * @param residues
	 */
	public void selectResidues(Vector residues, int selection){
		try{
			Vector chains = new Vector();//to update
			for (int j = 0; j < this.getLoadedStructures().size(); j++){
				Structure structure = (Structure)this.getLoadedStructures().get(j);
				StructureStyles styles = structure.getStructureMap().getStructureStyles();
				if (selection == DialogConstants.REPLACE_SELECTION){
					styles.selectNone(true, false);
					
					//also check if other chains in this structure need to be updated since they got deselected
					for (int i = selectedChains.size()-1; i >= 0; i--){
						Chain cc = (Chain)selectedChains.get(i);
//						if (cc.structure == structure){
							styles.updateChain(cc, true);
//						}
//						selectedChains.remove(cc);
					}

				}
				for (int i = 0; i < residues.size(); i++){
					Residue r = (Residue)residues.get(i);
					if (r.structure == structure){
						styles.setSelected(r, true, true, true);
						if (!chains.contains(structure.getStructureMap().getChain(r.getAtom(0)))){
							chains.add(structure.getStructureMap().getChain(r.getAtom(0)));
						}
					}
				}
			}
			
			for (int i = 0; i < chains.size(); i++){
				Chain c = (Chain)chains.get(i);
				c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
//				selectedChains.add(c);
			}
		}
		catch (Exception e){
			structureDocument.parent.updateAppearance();
			structureDocument.parent.displayErrorMessage("Error processing selection. Check your input and try again");
			return;
		}
		
		structureDocument.parent.updateView();
		
	}
	
	public void detectHydrogenBonds(Vector ligand, Vector protein, double maximum, boolean intra){
				
		//first, find hydrogens with heteroatoms on both sets
		for (int i = 0; i < ligand.size(); i++){
			Atom a = (Atom)ligand.get(i);
			if (a.element == 1){
				try{
					Atom next = (Atom)(a.structure.getStructureMap().getAtoms(a)).get(0);
					if (next == null) continue;
					if (next.element == 8 || next.element == 7 || next.element == 16){
	//					System.out.println("Scanning for H: " + a.name + " in " + a.compound + a.residue_id);
						//scan through the atoms of protein set to find heteroatoms
						for (int j = 0; j < protein.size(); j++){
							Atom aa = (Atom)protein.get(j);
							if (aa == a || aa == next) continue;
							if (!intra && ligand.contains(aa)) continue;
							if (aa.element == 8 || aa.element == 7 || aa.element == 16){
								if (!aa.visible) continue;
								if (Algebra.distance(a.coordinate, aa.coordinate) <= maximum){
									
	//								System.out.println("possible H");
									
									boolean pass = false;
	//								System.out.println("possible H bond: " + aa.name + " in " + aa.compound + aa.residue_id);
									//a possible H bond
									//check its geometry to make sure the vectors are not at 
									//a sharp angle
									double angle1 = Algebra.angle(next.coordinate, a.coordinate, aa.coordinate);
	//								System.out.println("angle1 = " + angle1);
									if (angle1 < 130) continue;
									
									double angle2 = 0;
									//angle2 is between H, acceptor heteroatom, and the base of the acceptor heteroatom
									Vector atoms = aa.structure.getStructureMap().getAtoms(aa);
									if (atoms == null) continue;
									if (atoms.size() == 0) continue;
									if (atoms.size() == 1){
										//only one bond (possibly double)
										angle2 = Algebra.angle(a.coordinate, aa.coordinate, ((Atom)atoms.get(0)).coordinate);
	//									System.out.println(a.name + "-" + aa.name + "-" + ((Atom)atoms.get(0)).name + ": angle2 = " + angle2);
										if (angle2 > 110){
											if (angle1 < 120 || angle2 < 120){
												if (Algebra.distance(a.coordinate, aa.coordinate) > 2.5){
	//												System.out.println("Sharp angles: rejected");
													continue;
												}
											}
											pass = true;
										}
									}
									else{
										double[] h = new double[]{ aa.coordinate[0] - a.coordinate[0], aa.coordinate[1] - a.coordinate[1], aa.coordinate[2] - a.coordinate[2] };
										if (atoms.size() == 2){
	//										System.out.println("2 bonds for " + aa.name + " in " + aa.compound);
											Atom a1 = (Atom)atoms.get(0);
											Atom a2 = (Atom)atoms.get(1);
											
											double[] b = new double[]{ a1.coordinate[0] - aa.coordinate[0],a1.coordinate[1] - aa.coordinate[1],a1.coordinate[2] - aa.coordinate[2] }; 
											double[] aux = new double[]{ a1.coordinate[0] - a2.coordinate[0], a1.coordinate[1] - a2.coordinate[1], a1.coordinate[2] - a2.coordinate[2] };
											Algebra.normalizeVector(aux);
											double[] normal = Algebra.crossProduct(b, aux);
											Algebra.normalizeVector(normal);
											
											double[] pointer = Algebra.crossProduct(aux, normal);
											//check the direction: look at the angle with b, should be greater than 90 degrees
											double angle = Algebra.getAngleBetweenVectors(pointer, b);
											if (angle < 100){
												Algebra.reverseVector(pointer);
											}
											
	//										this.createArrow(aa.structure, aa.coordinate, StructureMath.getPointOnVector(aa.coordinate, pointer, 1), new float[]{ 1.0f, 0.0f, 0.0f });
											
											//get the vector from hydrogen to this heteroatom and get the angle
											angle2 = Algebra.getAngleBetweenVectors(h, pointer);
	//										System.out.println("angle2 = " + angle2);
											
											if (angle2 > 130) pass = true;
										}
									}
									if (pass){
										//add a hydrogen bond
										if (atomToHBonds.containsKey(a) && atomToHBonds.containsKey(aa)) continue;
										
										HydrogenBondComponent hComponent = new HydrogenBondComponent(a, aa, null);
										MonitorRenderable r = new MonitorRenderable(hComponent, 
												(AnnotationGeometry)defaultGeometry.get("MonitorGeometry"));//don't translate
									
										hBonds.put(hComponent, r);
										Vector v = (Vector)atomToHBonds.get(a);
										if (v == null){
											v = new Vector();
											atomToHBonds.put(a, v);
										}
										v.add(hComponent);
	
										Vector v2 = (Vector)atomToHBonds.get(aa);
										if (v2 == null){
											v2 = new Vector();
											atomToHBonds.put(aa, v2);
										}
										v2.add(hComponent);
	
										if (independentSet != null){
											if (independentSet.contains(a) || independentSet.contains(aa)){
												independentGroup.addChild(r);
											}
											else{
												renderablesList.add(r);
											}
										}
										else{
											renderablesList.add(r);
										}
										
									}
									
								}
							}
						}
					}
				}
				catch (Exception e){
					continue;
				}
			}
		}
		
		if (!intra){
			for (int i = 0; i < protein.size(); i++){
				
				try{
					Atom a = (Atom)protein.get(i);
					if (a.element == 1){
						Atom next = (Atom)(a.structure.getStructureMap().getAtoms(a)).get(0);
						if (next == null) continue;
						if (next.element == 8 || next.element == 7 || next.element == 16){
							//scan through the atoms of ligand set to find heteroatoms
							for (int j = 0; j < ligand.size(); j++){
								Atom aa = (Atom)ligand.get(j);
								if (aa.element == 8 || aa.element == 7 || aa.element == 16){
									if (aa.compound.equals("HOH")) continue;
									if (Algebra.distance(a.coordinate, aa.coordinate) <= maximum){
										//a possible H bond
										//check its geometry to make sure the vectors are not at 
										//a sharp angle
										double angle1 = Algebra.angle(next.coordinate, a.coordinate, aa.coordinate);
										
										if (angle1 < 130) continue;
										
										boolean pass = false;
										
										double angle2 = 0;
										//angle2 is between H, acceptor heteroatom, and the base of the acceptor heteroatom
										Vector atoms = aa.structure.getStructureMap().getAtoms(aa);
										if (atoms == null) continue;
										if (atoms.size() == 0) continue;
										if (atoms.size() == 1){
											//only one bond (possibly double)
											angle2 = Algebra.angle(a.coordinate, aa.coordinate, ((Atom)atoms.get(0)).coordinate);
	//										System.out.println(a.name + "-" + aa.name + "-" + ((Atom)atoms.get(0)).name + ": angle2 = " + angle2);
											if (angle2 > 110){
												if (angle1 < 120 || angle2 < 120){
													if (Algebra.distance(a.coordinate, aa.coordinate) > 2.5){
	//													System.out.println("Sharp angles: rejected");
														continue;
													}
												}
												pass = true;
											}
										}
										else{
											double[] h = new double[]{ aa.coordinate[0] - a.coordinate[0], aa.coordinate[1] - a.coordinate[1], aa.coordinate[2] - a.coordinate[2] };
											if (atoms.size() == 2){
	//											System.out.println("2 bonds for " + aa.name + " in " + aa.compound);
												Atom a1 = (Atom)atoms.get(0);
												Atom a2 = (Atom)atoms.get(1);
												
												double[] b = new double[]{ a1.coordinate[0] - aa.coordinate[0],a1.coordinate[1] - aa.coordinate[1],a1.coordinate[2] - aa.coordinate[2] }; 
												double[] aux = new double[]{ a1.coordinate[0] - a2.coordinate[0], a1.coordinate[1] - a2.coordinate[1], a1.coordinate[2] - a2.coordinate[2] };
												Algebra.normalizeVector(aux);
												double[] normal = Algebra.crossProduct(b, aux);
												Algebra.normalizeVector(normal);
												
												double[] pointer = Algebra.crossProduct(aux, normal);
												//check the direction: look at the angle with b, should be greater than 90 degrees
												double angle = Algebra.getAngleBetweenVectors(pointer, b);
												if (angle < 100){
													Algebra.reverseVector(pointer);
												}
												
	//											this.createArrow(aa.structure, aa.coordinate, StructureMath.getPointOnVector(aa.coordinate, pointer, 1), new float[]{ 1.0f, 0.0f, 0.0f });
												
												//get the vector from hydrogen to this heteroatom and get the angle
												angle2 = Algebra.getAngleBetweenVectors(h, pointer);
	//											System.out.println("angle2 = " + angle2);
												
												if (angle2 > 130) pass = true;
											}
										}
	
										
										if (pass){
											//add a hydrogen bond if none already exists
											if (atomToHBonds.containsKey(a) && atomToHBonds.containsKey(aa)) continue;
											
											HydrogenBondComponent hComponent = new HydrogenBondComponent(a, aa, null);
											MonitorRenderable r = new MonitorRenderable(hComponent, 
													(AnnotationGeometry)defaultGeometry.get("MonitorGeometry"));//don't translate
										
											hBonds.put(hComponent, r);
											Vector v = (Vector)atomToHBonds.get(a);
											if (v == null){
												v = new Vector();
												atomToHBonds.put(a, v);
											}
											v.add(hComponent);
											
											Vector v2 = (Vector)atomToHBonds.get(aa);
											if (v2 == null){
												v2 = new Vector();
												atomToHBonds.put(aa, v2);
											}
											v2.add(hComponent);
											
											if (independentSet != null){
												if (independentSet.contains(a) || independentSet.contains(aa)){
													independentGroup.addChild(r);
												}
												else{
													renderablesList.add(r);
												}
											}
											else{
												renderablesList.add(r);
											}
										}	
										
										
									}
								}
							}
		
					
						}
					}
					
					
				}
				catch(Exception ex){
					continue;
				}
			}
		}

		geometryViewer.setRenderables(renderablesList);
		
		structureDocument.parent.updateMonitorDialog();
		geometryViewer.updateView();
		
	}
	
	public void createHydrogenBond(Atom atom1, Atom atom2, boolean updateView){
		
		HydrogenBondComponent hComponent = new HydrogenBondComponent(atom1, atom2, null);
		MonitorRenderable r = new MonitorRenderable(hComponent, 
				(AnnotationGeometry)defaultGeometry.get("MonitorGeometry"));//don't translate
	
		hBonds.put(hComponent, r);
		Vector lr = (Vector)atomToHBonds.get(atom1);
		if (lr == null){
			lr = new Vector();
			atomToHBonds.put(atom1, lr);
		}
		lr.add(hComponent);
		
		Vector lr2 = (Vector)atomToHBonds.get(atom2);
		if (lr2 == null){
			lr2 = new Vector();
			atomToHBonds.put(atom2, lr2);
		}
		lr2.add(hComponent);
		
		if (independentSet != null){
			if (independentSet.contains(atom1) || independentSet.contains(atom2)){
				independentGroup.addChild(r);
			}
			else{
				renderablesList.add(r);
			}
		}
		else{
			renderablesList.add(r);
		}


		geometryViewer.setRenderables(renderablesList);
		
		if (updateView){
			geometryViewer.updateView();
		}
		
	}
	
	/**
	 * This method takes care of geometry and consistency of representation of the new bonds
	 * between structure map and structure styles
	 * @param bonds Vector of the new bonds
	 */
	public void addBonds(Vector bonds, boolean checkDummies, boolean saveUndo, boolean update){
		
		if (saveUndo && StylesPreferences.undoEnabled) saveStateForUndo();
		
		StructureComponentEvent e = new StructureComponentEvent();
		for (int i = 0; i < bonds.size(); i++){
			try{
				Bond b = (Bond)bonds.get(i);
				b.structure.getStructureMap().getStructureStyles().addStructureComponent(b, (short)-1, (short)-1, true);
			}
			catch (Exception ex){
				ex.printStackTrace();
				continue;
			}
		}
		
		if (checkDummies){
			for (int i = 0; i < getLoadedStructures().size(); i++){
				Structure s = (Structure)getLoadedStructures().get(i);
				checkDummyAtoms(s, false);
			}
		}
		
		if (update) geometryViewer.updateView();
		
	}
	
	
	public void setCommonMotion(boolean saveState){
		
		if (independentSet == null || independentSet.size() == 0) return;//there is nothing to do
		
		if (!undoProcess && StylesPreferences.undoEnabled && saveState) saveStateForUndo();
		
		Structure structure = independentStructure;
		
		//check if the structure is still present: in the event it's an unloading situation
		if (!this.getLoadedStructures().contains(structure)){
			
			transformedCoordinates.clear();
			independentSet.clear();
			independentGroup = null;
			independentStructure = null;
			motionCenter = null;
			initialMotionCenter = null;
			globalResidues.clear();
			

			structureDocument.parent.setSeparateMotion(false);
			
			xCoord = new double[]{ 1.0, 0.0, 0.0 };
			yCoord = new double[]{ 0.0, 1.0, 0.0 };
			zCoord = new double[]{ 0.0, 0.0, 1.0 };
			
			geometryViewer.setIndependentMotion(false, null, 0);
			updateAppearance();
			
			return;
		}
		
		
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector localRenderables = (Vector)renderables.get(structure);
		
//		double[] matrix = independentGroup.getTransform();
		

		int counter = 0;
		for (int n = 0; n < independentSet.size(); n++){
			
			//set new coordinates
			try{
				Atom a = (Atom)independentSet.get(n);
				
				//try getting a cumulative matrix to transform the atomic coordinates
//				StructureMath.transformCoordinates(a.coordinate, matrix);
				
//				if (trackBumps){
					double[] c = (double[])transformedCoordinates.get(a);
					a.coordinate[0] = c[0];
					a.coordinate[1] = c[1];
					a.coordinate[2] = c[2];
//				}
//				else{
					//transform atom coordinates using coordinateMatrix
//					StructureMath.transformCoordinates(a.coordinate, coordinateMatrix);
					
					
					/**
					 * TODO populate transformedCoordinates as well, to account for changed atomic coordinates
					 * 
					 */
//				}
				
				if (atomToLabels.containsKey(a)){
					GlRenderable r = (GlRenderable)labels.get(atomToLabels.get(a));
					if (independentGroup.containsChild(r)){
						independentGroup.removeChild(r);
						renderablesList.add(r);
						localRenderables.add(r);
						r.setDirty();
					}
				}
				if (atomToResidueLabels.containsKey(a)){
					GlRenderable r = (GlRenderable)labels.get(atomToResidueLabels.get(a));
					if (independentGroup.containsChild(r)){
						independentGroup.removeChild(r);
						renderablesList.add(r);
						localRenderables.add(r);
						r.setDirty();
					}
				}
			}
			catch (ClassCastException ex){}
			
			GlRenderable rs = (GlRenderable)structureHash.get(independentSet.get(n));
			if (rs != null){
				independentGroup.removeChild(rs);
				rs.setDirty();
				if (hiddenComponents.containsKey(independentSet.get(n))) continue;
				localRenderables.add(rs);
				renderablesList.add(rs);
				counter++;
			}
		}
		
		//recompute geometric center for the structure, once the motion is done
		double[] center;
		double[] total = new double[3];
		int atomCount = structure.getStructureMap().getAtomCount();
		for (int i = 0; i < atomCount; i++){
			Atom aa = structure.getStructureMap().getAtom(i);
			total[0] += aa.coordinate[0];
			total[1] += aa.coordinate[1];
			total[2] += aa.coordinate[2];
			
		}
		
		center = new double[]{ total[0]/atomCount, total[1]/atomCount, total[2]/atomCount };
		structure.getStructureMap().setCenter(center);
		
		//move remaining renderables
		for (int j = independentGroup.getChildCount()-1; j >= 0; j--){
			GlRenderable gr = independentGroup.getChild(j);
			independentGroup.removeChild(gr);
			gr.setDirty();
			if (!(gr instanceof ClusterRenderable)) localRenderables.add(gr);
			renderablesList.add(gr);
		}
		
		independentGroup.removeChildren();
		
		localRenderables.remove(independentGroup);
		renderablesList.remove(independentGroup);
		
		this.checkDummyAtoms(structure, false);

		structureDocument.parent.setSeparateMotion(false);
		
		xCoord = new double[]{ 1.0, 0.0, 0.0 };
		yCoord = new double[]{ 0.0, 1.0, 0.0 };
		zCoord = new double[]{ 0.0, 0.0, 1.0 };
		
		geometryViewer.setIndependentMotion(false, null, 0);

		if (trackBumps){
			detectBumps(independentComponents, globalResidues, 0.1, false, false);
			trackBumps = false;
		}
		
		transformedCoordinates.clear();
		independentSet.clear();
		independentGroup = null;
		independentStructure = null;
		motionCenter = null;
		initialMotionCenter = null;
		independentComponents.clear();
		globalResidues.clear();
		
		geometryViewer.updateView();
		
	}
	
	public String getStructureName(Structure structure){
		return (String)structureNames.get(structure);
	}
	
	public Structure getStructureByName(String name){
		Set keys = structureNames.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			Structure s = (Structure)it.next();
			String n = (String)structureNames.get(s);
			if (n.equals(name)){
				return s;
			}
		}
		
		return null;
	}
	
	
	public int getStructureCount(){
		return structureNames.size();
	}
	
	public void removeNotify( )
    {
		try{
			super.removeNotify( );
		}
		catch (Exception e){
//			e.printStackTrace();
			return;
		}
		GLAutoDrawable drawable = geometryViewer.getDrawable( );
		if ( drawable == null ) return; // JLM DEBUG: is silence ok?
		GLContext context = drawable.getContext( );
		if ( context == null ) return; // JLM DEBUG: is silence ok?

//		System.out.println("checking renderables");
		try {

			GL gl = null;
			if ( context.makeCurrent() == GLContext.CONTEXT_NOT_CURRENT ){
//				System.out.println("context not current");
//				return; // JLM DEBUG: is silence ok?
			}
			else{
				gl = context.getGL( );
			} 

			int renderableCount = renderablesList.size( );
			for ( int r=0; r<renderableCount; r++ ) {
				GlRenderable renderable = (GlRenderable) renderablesList.get( r );
				if ( renderable instanceof MbtRenderable ){
					((MbtRenderable)renderable).freeGlResources( gl );
				}
				else if (renderable instanceof TransformGroupRenderable){
					((TransformGroupRenderable)renderable).freeGlResources( gl );
				}
				else if (renderable instanceof MonitorRenderable){
					((MonitorRenderable)renderable).freeGlResources( gl );
				}
				else if (renderable instanceof ClusterRenderable){
					((ClusterRenderable)renderable).freeGlResources( gl );
				}
			}
			geometryViewer.updateView();
		}
		catch ( GLException e ){
			e.printStackTrace();
			return; // JLM DEBUG: is silence ok?
		}
	}
	
	public void replaceResidue(Residue residue, String label){
		
		if (residue == null) return;
		
		if (StylesPreferences.undoEnabled) saveStateForUndo();
		
		//check the target
		if (residue.getClassification() != Residue.COMPOUND_AMINO_ACID){
			structureDocument.parent.displayErrorMessage("Selected target residue is not an amino acid.");
			return;
		}

		residue.structure.getStructureMap().getStructureStyles().replaceStructureComponent(residue, label);
		
		structureDocument.parent.updateView();
	}
	
		
	private void removeRenderable(GlRenderable r){
		
		
		
		GLAutoDrawable drawable = geometryViewer.getDrawable( );
        GLContext context = drawable.getContext( );

        renderablesList.remove(r);
		
		try {
			if ( context.makeCurrent() == GLContext.CONTEXT_NOT_CURRENT ) {
				System.err.println( "Error getting GL context" );
			}
			else {
				r.freeGlResources( context.getGL() );
				context.release( );
			}
		}
		catch ( GLException e ){
//			e.printStackTrace();
//			System.err.println( "Error making GL context current" );
		}
	}
	
	private void removeRenderables(Vector renderables){
		
		GLAutoDrawable drawable = geometryViewer.getDrawable( );
        GLContext context = drawable.getContext( );
		renderablesList.removeAll(renderables);
		
		try {
			if ( context.makeCurrent() == GLContext.CONTEXT_NOT_CURRENT ) {
				System.err.println( "Error getting GL context" );
			}
			else {
				for (int i = 0; i < renderables.size(); i++){
					GlRenderable gr = (GlRenderable)renderables.get(i);
					if (gr != null) gr.freeGlResources( context.getGL() );
				}
				context.release( );
			}
		}
		catch ( GLException e ){
			System.err.println( "Error making GL context current" );
		}
		
	}
	
	private void attachFragment(Atom atom){
		
		if (atom == null || FragmentRegistry.activeFragment == null) return;
		
		if (atom.element != 1){
			structureDocument.parent.displayErrorMessage(" Fragment palette is active. Please select a hydrogen to be replaced with the active fragment.\n" +
					"If you would like to select the structure, deselect the current fragment or close builder palette.");
			return;
		}
		
		boolean independent = false;
		if (independentStructure != null && atom.structure == independentStructure){
			//scan independentComponents and see whether atom is one of them (or a part of one of the residues)
			
			for (int i = 0; i < independentComponents.size(); i++){
				try{
					Residue r = (Residue)independentComponents.get(i);
					boolean out = false;
					for (int j = 0; j < r.getAtomCount(); j++){
						Atom a = r.getAtom(j);
						if (a == atom){
							independent = true;
							out = true;
							break;
						}
					}
					if (out) break;
				}
				catch (ClassCastException e){
					try{
						Atom a = (Atom)independentComponents.get(i);
						if (a == atom){
							independent = true;
							break;
						}
					}
					catch (ClassCastException ee){}
				}
			}
		}
		
		int atomCount = 0;//compute how many atoms are in the parent structure, and then reassign atom numbers in the added fragment, to avoid having duplicates
		
		/**
		 * TODO try working out the transformedCoordinates issue, and check how undo behaves during such addition process
		 */
		
		if (independent){
			structureDocument.parent.displayErrorMessage("At this time modification of a structure that is being moved " +
					"independently is not supported.\n" +
					"         Try setting the display to common motion and then attaching the fragment");
			return;
		}
		
		Atom hostNext = null;
		try{
			hostNext = (Atom)(atom.structure.getStructureMap().getAtoms(atom).get(0));
		}
		catch (Exception ex){
			ex.printStackTrace();
		}
		
		if (hostNext == null){
			structureDocument.parent.displayErrorMessage("A fragment may not be attached to an isolated atom");
			return;
		}
		
		if (independentComponents.contains(atom) && !independentComponents.contains(hostNext)){
			structureDocument.parent.displayErrorMessage("A fragment may not be attached to an independently moved isolated atom.");
			return;
		}

		int fid = 0;
		try{
			fid = Integer.parseInt(FragmentRegistry.activeFragment);
		}
		catch (Exception ex){
			ex.printStackTrace();
		}

		Atom attachmentAtom = null;
		StructureMap structureMap = atom.structure.getStructureMap();
		StructureStyles structureStyles = structureMap.getStructureStyles();
		atomCount = structureMap.getAtomCount();


		//Atom and Bond objects that belong to the fragment
		Hashtable components = EntryFactory.loadFragmentComponents(FragmentRegistry.activeFragment);
		Vector atoms = (Vector)components.get(StructureComponentRegistry.TYPE_ATOM);

		//check first, what we are attaching to: if it's an aa, check which end was clicked (N- or C-terminal)
		boolean defaultAttachment = false;
		boolean peptide = false;
		
		Residue res = atom.residue;
		if (res.getClassification() == Residue.COMPOUND_AMINO_ACID){
			if (fid > 20 && fid < 41) peptide = true;
			//get the name of the host atom
			if (hostNext.name.equals("C")){
				//C-terminal, so regular attachment point will be used
				
			}
			else if (hostNext.name.equals("N")){
				//N-terminal
				if (peptide){
					String attachLabel = (String)FragmentRegistry.getAllAttachmentPoints(FragmentRegistry.activeFragment).get(1);
					int ii = attachLabel.indexOf("_");
					String attachResidue = attachLabel.substring(0, ii);
					String attachAtom = attachLabel.substring(ii+1);
					
					//get the Atom object
					for (int i = 0; i < atoms.size(); i++){
						Atom a = (Atom)atoms.get(i);
						if (a.name.equals(attachAtom) && a.compound.equals(attachResidue)){
							attachmentAtom = a;
							break;
						}
					}
				}
				
			}
			else{
				//check what's being attached: if another aa, bail out
				if (peptide){
					structureDocument.parent.displayErrorMessage("Amino acid fragments can only be added at the N- or C-terminal hydrogens");
					return;
				}
				
			}
		}
		
		if (attachmentAtom == null){
			//keep going with the default attachment point
			String attachLabel = FragmentRegistry.getAttachmentPoint(FragmentRegistry.activeFragment);
			int ii = attachLabel.indexOf("_");
			String attachResidue = attachLabel.substring(0, ii);
			String attachAtom = attachLabel.substring(ii+1);
			
			//get the Atom object
			for (int i = 0; i < atoms.size(); i++){
				Atom a = (Atom)atoms.get(i);
				if (a.name.equals(attachAtom) && a.compound.equals(attachResidue)){
					attachmentAtom = a;
					break;
				}
			}

		}
		
		if (StylesPreferences.undoEnabled) saveStateForUndo();

		
		
		Bond hostConnectorBond = null;
		Vector bb = hostNext.structure.getStructureMap().getBonds(hostNext);
		for (int i = 0; i < bb.size(); i++){
			Bond bbb = (Bond)bb.get(i);
			if (bbb.getAtom(0) == atom){
				hostConnectorBond = bbb;
				break;
			}
			if (bbb.getAtom(1) == atom){
				hostConnectorBond = bbb;
				break;
			}
		}
		
//		System.out.println("hostConnectorBond = " + hostConnectorBond);
//		System.out.println("hostNext = " + hostNext.name + ", hostH = " + atom);
		
		double[] hostVector = Algebra.getVector(hostNext.coordinate, atom.coordinate);
		
		//walk through the bonds of the new set and find the atom connected to the attachment atom
		Atom fragmentNext = null;
		Bond fragmentConnectorBond = null;
		
		Vector bonds = (Vector)components.get(StructureComponentRegistry.TYPE_BOND);
		for (int i = 0; i < bonds.size(); i++){
			Bond b = (Bond)bonds.get(i);
			if (b.getAtom(0) == attachmentAtom){
				fragmentNext = b.getAtom(1);
				fragmentConnectorBond = b;
				break;
			}
			else if (b.getAtom(1) == attachmentAtom){
				fragmentNext = b.getAtom(0);
				fragmentConnectorBond = b;
				break;
			}
		}
		
//		System.out.println("fragmentNext = " + fragmentNext.name);
		
		double[] fragmentVector = Algebra.getVector(attachmentAtom.coordinate, fragmentNext.coordinate);
		
		//get the transformation of coordinates using direction vectors

		//get the auxiliary vectors for location transformation
		//use adjacent bonds to get orthogonal vectors in the host and fragment structures
		
		//get the basis for the host
		double[] aux = new double[3];//vector of one of the adjacent bonds, if any
		Vector hostBonds = structureMap.getBonds(hostNext);
		if (hostBonds == null || hostBonds.size() == 0){
			aux[0] = hostVector[0];
			aux[1] = hostVector[1];
			aux[2] = hostVector[2]+0.1;
		}
		else{
			if (peptide){
				//don't rely on random orientation of the first picked bond, look for specific atoms
				//to get a defined orientation
				if (hostNext.name.equals("C")){
					Vector aaa = structureMap.getAtoms(hostNext);
					for (int i = 0; i < aaa.size(); i++){
						Atom aa = (Atom)aaa.get(i);
						if (aa.name.equals("O")){
							aux = Algebra.getVector(hostNext.coordinate, aa.coordinate);
							break;
						}
					}
				}
				else if (hostNext.name.equals("N")){
					Vector aaa = structureMap.getAtoms(hostNext);
					for (int i = 0; i < aaa.size(); i++){
						Atom aa = (Atom)aaa.get(i);
						if (aa.name.equals("CA")){
							aux = Algebra.getVector(hostNext.coordinate, aa.coordinate);
							break;
						}
					}
				}
				
			}
			else{
				for (int i = 0; i < hostBonds.size(); i++){
					Bond b = (Bond)hostBonds.get(i);
					if (b == hostConnectorBond) continue;
					
					//any other bond will do
					if (b.getAtom(0) == hostNext){
						aux = Algebra.getVector(hostNext.coordinate, b.getAtom(1).coordinate);
						break;
					}
					else if (b.getAtom(1) == hostNext){
						aux = Algebra.getVector(hostNext.coordinate, b.getAtom(0).coordinate);
						break;
					}
				}
			}
		}
		
		if (aux[2] == 0) aux[2] = 0.001;//a hack to maintain a proper geometry: apparently, with z = 0 there is an issue somewhere in the code that 
		//produces an incorrect vector result
		
		double[] hostA = Algebra.crossProduct(hostVector, aux);//normal to the plane
//		System.out.println("hostA = " + hostA[0] + ", " + hostA[1] + ", " + hostA[2]);

		double[] hostB = Algebra.crossProduct(hostVector, hostA);//right vector
		
		
		//same for the fragment
		aux = new double[3];
		if (bonds.size() == 0){
			aux[0] = fragmentVector[0];
			aux[1] = fragmentVector[1];
			aux[2] = fragmentVector[2]+0.1;
		}
		else{
			if (peptide){
				if (fragmentNext.name.equals("C")){
					for (int i = 0; i < bonds.size(); i++){
						Bond bbb = (Bond)bonds.get(i);
						if (bbb.getAtom(0) == fragmentNext){
							if (bbb.getAtom(1).name.equals("O")){
								aux = Algebra.getVector(fragmentNext.coordinate, bbb.getAtom(1).coordinate);
								break;
							}
						}
						else if (bbb.getAtom(1) == fragmentNext){
							if (bbb.getAtom(0).name.equals("O")){
								aux = Algebra.getVector(fragmentNext.coordinate, bbb.getAtom(0).coordinate);
								break;
							}
						}
					}
				}
				else if (fragmentNext.name.equals("N")){
					for (int i = 0; i < bonds.size(); i++){
						Bond bbb = (Bond)bonds.get(i);
						if (bbb.getAtom(0) == fragmentNext){
							if (bbb.getAtom(1).name.equals("CA")){
								aux = Algebra.getVector(fragmentNext.coordinate, bbb.getAtom(1).coordinate);
								break;
							}
						}
						else if (bbb.getAtom(1) == fragmentNext){
							if (bbb.getAtom(0).name.equals("CA")){
								aux = Algebra.getVector(fragmentNext.coordinate, bbb.getAtom(0).coordinate);
								break;
							}
						}
					}
				}
			}
			else{
				//walk through the bonds and find those that include fragmentNext
				for (int i = 0; i < bonds.size(); i++){
					Bond b = (Bond)bonds.get(i);
					if (b == fragmentConnectorBond) continue;
					if (b.getAtom(0) == fragmentNext){
						aux = Algebra.getVector(fragmentNext.coordinate, b.getAtom(1).coordinate);
						break;
					}
					else if (b.getAtom(1) == fragmentNext){
						aux = Algebra.getVector(fragmentNext.coordinate, b.getAtom(0).coordinate);
						break;
					}
				}
			}
		}
		
		double[] fragmentA = Algebra.crossProduct(fragmentVector, aux);
		double[] fragmentB = Algebra.crossProduct(fragmentVector, fragmentA);
		
		//transform the coordinates
		Location host = new Location(hostVector, hostA, hostB, StructureMath.getPointOnVector(hostNext.coordinate, hostVector, 
				ElementProperties.getBondLength(hostNext.element, fragmentNext.element)));
		
		Location fragment = new Location(fragmentVector, fragmentA, fragmentB, fragmentNext.coordinate);
		
		StructureMath.transformAtomSet(fragment, host, atoms);
		
/*		for (int i = 0; i < atoms.size(); i++){
			Atom a = (Atom)atoms.get(i);
			if (a.name.equals("N")){
				System.out.println("Updated N: " + a.coordinate[0] + "," + a.coordinate[1] + "," + a.coordinate[2]);
			}
		}
*/		
		//now add the atoms to the StructureMap bookkeeping mechanism and add them to the view to render
		
		//change parameters of the bonds that are being removed by replacing the atoms connected
		//now hostNext and fragmentNext are connected, and the initial hydrogens are discarded. One of the
		//bonds is also removed
		
		bonds.remove(fragmentConnectorBond);
		atoms.remove(attachmentAtom);
		
/*		if (independent){
			
			independentComponents.addAll(atoms);
			independentComponents.remove(atom);
			independentSet.remove(atom);
			independentSet.remove(hostConnectorBond);
			
			independentSet.addAll(atoms);
			independentSet.addAll(bonds);
			
			
			for (int i = 0; i < atoms.size(); i++){
				Atom a = (Atom)atoms.get(i);
				double[] aa = new double[]{ a.coordinate[0], a.coordinate[1], a.coordinate[2] };
			}
		}
*/		
		structureStyles.deleteStructureComponent(atom, true, true);
		//now the host connector hydrogen is gone along with its bond, so a new one needs to be
		//created
		
		
		//get the style of the host structure
		short style = hostNext.render;
		short quality = hostNext.quality;
		
		boolean prepend = false;
		if (peptide && hostNext.name.equals("N")){
			//adding from the N-terminal end - renumber all residues and set the new one as 1
			prepend = true;
		}
		
		Residue residue = new Residue();
		
		//set up renderable addition if independent mode is active
		Hashtable structureHash = (Hashtable)objectHash.get(atom.structure);
		Vector localRenderables = (Vector)renderables.get(atom.structure);
		
		if (independent){
			if (structureHash.containsKey(hostConnectorBond)){
				MbtRenderable r = (MbtRenderable)structureHash.get(hostConnectorBond);
				independentGroup.removeChild(r);
			}
		}
		
		double[] sum = new double[3];
		for (int i = 0; i < atoms.size(); i++){
			Atom a = (Atom)atoms.get(i);
			sum[0] += a.coordinate[0];
			sum[1] += a.coordinate[1];
			sum[2] += a.coordinate[2];
			if (prepend){
				structureMap.addAtom(a, residue, 1, hostNext.residue.getChainId() );
			}
			else{
				structureMap.addAtom(a, residue, hostNext.residue.getChainId());
			}
			structureStyles.addStructureComponent(a, style, quality, true);
		}
		
		sum[0] /= atoms.size();
		sum[1] /= atoms.size();
		sum[2] /= atoms.size();
		
		//another pass to determine which atom is the closest to the center
		double min = 100000;
		Atom target = null;
		for (int j = 0; j < residue.getAtomCount(); j++){
			Atom a = residue.getAtom(j);
			double d = Algebra.distance(a.coordinate, sum);
			if (d < min){
				min = d;
				target = a;
			}
		}
		if (target == null) target = residue.getAtom(0);
		
		residue.centerAtom = target;
		
		if (independent) independentComponents.add(residue);

		structureMap.addBonds(bonds);
		for (int i = 0; i < bonds.size(); i++){
			Bond b = (Bond)bonds.get(i);
			structureStyles.addStructureComponent(b, style, quality, true);
			if (independent){
				MbtRenderable rr = (MbtRenderable)structureHash.get(b);
				if (rr != null){
					independentGroup.addChild(rr);
					renderablesList.remove(rr);
					localRenderables.remove(rr);
				}
			}
		}
		
		Bond bond = new Bond(hostNext, fragmentNext);
		structureMap.addBond(bond);
		if (independent) independentSet.add(bond);
		structureStyles.addStructureComponent(bond, style, quality, true);
		structureStyles.addStructureComponent(residue, style, quality, true);
		
		//update structure browser
		if (peptide) structureDocument.reloadContent();
		
		geometryViewer.setRenderables(renderablesList);
		structureDocument.parent.updateView();
	}
	
	/**
	 * Save current state of the display for future undo
	 *
	 */
	public void saveStateForUndo(){
		
		StateObject state = StateHandler.createStateObject(this, structureDocument.parent.getSequenceViewer());
		undoBuffer.insertElementAt(state, 0);
		
		if (undoBuffer.size() > 0) structureDocument.parent.setUndo(true);
		if (undoBuffer.size() > StylesPreferences.undoBufferDepth){
//			System.out.println("exceeded buffer depth");
			undoBuffer.removeElementAt(undoBuffer.size()-1);//delete the last element in the buffer
		}
		
	}
	
	public void deleteLastUndoState(){
		if (undoBuffer.size() == 0) return;
		undoBuffer.remove(undoBuffer.lastElement());
		if (undoBuffer.size() == 0) structureDocument.parent.setUndo(false);
	}
	
	public void undo(){
		
		updateViewOnRemove = false;
		undoProcess = true;
		
		//unload the current view
		removeMonitors();
		try{
			structureDocument.parent.clearStructureEntries();
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception closing entries", ex);
			return;
		}
		
		try{
			
			StateObject state = (StateObject)undoBuffer.get(0);
			
			StateHandler.restoreState(state, structureDocument.parent, thisViewer, structureDocument.parent.getSequenceViewer());
			
			undoBuffer.remove(state);
			if (undoBuffer.size() == 0) structureDocument.parent.setUndo(false);
			
			updateAppearance();
		}
		catch (Exception e){
			e.printStackTrace();
		}
		
		updateViewOnRemove = true;
		undoProcess = false;
	}
	
	/**
	 * Creates a new fragment record for a user-defined structure. component denotes the structure to be saved, 
	 * attachments contain structure components corresponding to Atoms that will act as attachment points
	 * @param component
	 * @param name
	 * @param attachments
	 */
	public void saveCustomFragment(StructureComponent component, String name, StructureComponent[] attachments){
		
		
		//check whether there are still slots
		
		if (FragmentRegistry.getCustomFragmentRecords() != null && FragmentRegistry.getCustomFragmentRecords().size() == 20){
			structureDocument.parent.displayErrorMessage("The maximum number of 20 custom fragments is reached. Delete a fragment and try again");
			return;
		}

		Structure structure = component.structure;
		
		Vector names = new Vector();
		//check whether all components belong to the same structure
		for (int i = 0; i < attachments.length; i++){
			StructureComponent c = attachments[i];
			if (c == null) continue;
			if (c.structure != structure){
				structureDocument.parent.displayErrorMessage("Attachment points do not belong to the specified structure. Please try again.");
				return;
			}
			
			try{
				//compose a name out of residue_atom name to avoid problems with duplicate atom names
				String nnn = ((Atom)c).compound + "_" + ((Atom)c).name;
				names.add(nnn);
			}
			catch (Exception ex){
				System.out.println("Exception in naming attachment point: " + ex);
			}
		}
		
		//get the current viewing parameters
		double[] lookAt = new double[3];
		lookAt[0] = geometryViewer.getLookAt()[0];
		lookAt[1] = geometryViewer.getLookAt()[1];
		lookAt[2] = geometryViewer.getLookAt()[2];
		
		double[] up = new double[3];
		up[0] = geometryViewer.getUpVector()[0];
		up[1] = geometryViewer.getUpVector()[1];
		up[2] = geometryViewer.getUpVector()[2];
		
		FragmentRegistry.addCustomFragment(structure, name, names, lookAt, up);
		
		//once this is done, instantiate an additional tab in the builder panel
		structureDocument.parent.updateBuilderDialog();
		
	}

	public final HashMap getAtomSets() {
		return atomSets;
	}

	public final void setAtomSets(HashMap atomSets) {
		this.atomSets = atomSets;
	}
	
	public Vector getAtomSetNames(){
		return atomSetNames;
	}
	
	public void createSet(String name, Vector residues){
		//if residues is null, use selection
		
		Vector components = new Vector();//to go into the atomSets

		if (residues == null){
			
			//go over selection and save into a set
			Vector s = getLoadedStructures();
			for (int i = 0; i < s.size(); i++){
				Structure structure = (Structure)s.get(i);
				StructureStyles styles = structure.getStructureMap().getStructureStyles();
				
				//since no wholesale flags are hit, process individual atoms and bonds
				Enumeration selectedAtoms = styles.getSelection().keys();
				
				//in case it's a show only, hide everything, and then process
				
				residues = new Vector();
				//run residues first, then leftover atoms
				while (selectedAtoms.hasMoreElements()){
					try{
						Residue r = (Residue)selectedAtoms.nextElement();
						if (styles.isSelected(r)){
							components.add(r);
							residues.add(r);//to keep track of what's been added
						}						
					}
					catch (Exception ex){
						continue;
					}
				}
				
				//run through the lone atoms
				selectedAtoms = styles.getSelection().keys();
				while (selectedAtoms.hasMoreElements()){
					try{
						
						Atom a = (Atom)selectedAtoms.nextElement();
						if (residues.contains(a.structure.getStructureMap().getResidue(a))) continue;
						if (styles.isSelected(a)){
							components.add(a);
						}
					}
					catch (ClassCastException ex){}
				}
				
			}
		}
		else{
			
			for (int i = 0; i < residues.size(); i++){
				StructureComponent r = (StructureComponent)residues.get(i);
				components.add(r);
			}
		}
		
		if (atomSets.containsKey(name)){
			//add new atoms to the existing set
			Vector atomSet = (Vector)atomSets.get(name);
			
			//now walk over the atoms and add them
			for (int i = 0; i < components.size(); i++){
				StructureComponent a = (StructureComponent)components.get(i);
				if (!atomSet.contains(a)) atomSet.add(a);
			}
		}
		else{
			//create a new set
			atomSets.put(name, components);
			atomSetNames.add(name);
		}
		
	}

	public final void setAtomSetNames(Vector atomSetNames) {
		this.atomSetNames = atomSetNames;
	}

	public final HashMap getTransformedCoordinates() {
		return transformedCoordinates;
	}

	public final void setTransformedCoordinates(HashMap transformedCoordinates) {
		this.transformedCoordinates = transformedCoordinates;
	}

	public final Structure getIndependentStructure() {
		return independentStructure;
	}

	public final void setIndependentStructure(Structure independentStructure) {
		this.independentStructure = independentStructure;
	}

	public final Vector getIndependentComponents() {
		return independentComponents;
	}

	public final void setIndependentComponents(Vector independentComponents) {
		this.independentComponents = independentComponents;
	}
	
	public void setIndependentMotion(Vector atoms, boolean updateView){
		
		Vector ribbons = new Vector();//ribbons that are fully covered by the
		//atom set (those broken will be removed altogether)
		
		
		if (updateView && atoms.size() > 500) structureDocument.parent.displayWaitScreen();

		for (int i = atoms.size()-1; i >= 0; i--){
			try{
				Atom a = (Atom)atoms.get(i);
				
				Residue r = a.residue;
				if (r.ribbon){
					Chain c = a.structure.getStructureMap().getChain(a);
					if (!ribbons.contains(c)) ribbons.add(c);
				}
								
				if (independentStructure == null){
					independentStructure = a.structure;
					continue;
				}
				
				if (a.structure != independentStructure){
					structureDocument.parent.displayErrorMessage("Only parts of one structure can be moved independently from the rest of the display");
					structureDocument.parent.removeWaitScreen();
					return;
				}
			}
			catch (ClassCastException e){
//				System.out.println("component = " + atoms.get(i));
				atoms.remove(i);
			}
		}
		
		if (atoms.size() == 0) return;
		
		Structure structure = ((Atom)atoms.get(0)).structure;
		if (!initialCoordinates.containsKey(structure)){
			saveInitialCoordinates(structure);
		}
		
		independentGroup = new TransformGroupRenderable();

		
		//now ribbons vector contains all chains that have at least one residue covered by the atom set and have a ribbon
		//determine which ribbons should be removed altogether
		for (int i = 0; i < ribbons.size(); i++){
			Chain c = (Chain)ribbons.get(i);
			boolean delete = false;
			for (int j = 0; j < c.getResidueCount(); j++){
				Residue r = c.getResidue(j);
				boolean fail = false;
				for (int k = 0; k < r.getAtomCount(); k++){
					Atom a = r.getAtom(k);
					if (!atoms.contains(a)){
						fail = true;
						break;
					}
				}
				
				if (fail){
					delete = true;
					break;
				}
			}
			
			if (delete){
				//get rid of this ribbon
				removeRibbon(c, false);
			}
		}
		
		//whatever is left in ribbons vector, is supposed to go with the atoms set into the independentSet
		
		//same approach for any cluster renderables: if a cluster renderable is completely within the set,
		//it's moved together with it. If it's fully outside, it's left alone. Otherwise, it's deleted.
		Vector clusterList = new Vector();
		if (clusters.size() > 0){
			Set keys = clusters.keySet();
			Iterator it = keys.iterator();
			while (it.hasNext()){
				Cluster c = (Cluster)it.next();
				//check each chain
				Chain chain1 = c.chain1;
				Chain chain2 = c.chain2;
				
				if (chain1.structure != structure && chain2.structure != structure){
					continue;
				}
				
				//scan all atoms in this chain, and check whether any or all atoms are
				//in the current independent set
				boolean in = false;
				boolean out = false;
				for (int i = 0; i < chain1.structure.getStructureMap().getAtomCount(); i++){
					Atom a = chain1.structure.getStructureMap().getAtom(i);
					if (atoms.contains(a)){
						in = true;//inside the set
					}
					else{
						out = true;//outside of the independent set
						if (in) break;//partial coverage - get out and kill the renderable
					}
				}
				
				if (in){
					if (out){
						this.removeClusterRenderables(c, false);
					}
					else{
						//the cluster renderable for chain1 is fully in the set
						ClusterRenderable r = ((ClusterRenderable[])clusters.get(c))[0];
						independentGroup.addChild(r);
						renderablesList.remove(r);
						
					}
				}

				//check second chain
				in = false;
				out = false;
				for (int i = 0; i < chain2.structure.getStructureMap().getAtomCount(); i++){
					Atom a = chain2.structure.getStructureMap().getAtom(i);
					if (atoms.contains(a)){
						in = true;//inside the set
					}
					else{
						out = true;//outside of the independent set
						if (in) break;//partial coverage - get out and kill the renderable
					}
				}
				
				if (in){
					if (out){
						this.removeClusterRenderables(c, false);
					}
					else{
						//the cluster renderable for chain1 is fully in the set
						ClusterRenderable r = ((ClusterRenderable[])clusters.get(c))[1];
						independentGroup.addChild(r);
						renderablesList.remove(r);
						
					}
				}
				
				//if the cluster is not part of the independent set, leave it alone
			}
		}
		
		
		
		
		//check for associated surfaces
		Vector surfs = new Vector();
		for (int i = 0; i < surfaceObjects.size(); i++){
			SurfaceComponent sc = (SurfaceComponent)surfaceObjects.get(i);
			Vector sa = sc.getAtoms();
//			System.out.println("checking surface " + sc);
			int count = 0;
			//if most of surface's atoms are in the independent set, include the surface into the motion
			for (int j = 0; j < sa.size(); j++){
				if (atoms.contains(sa.get(j))) count++;
			}
//			System.out.println("count = " + count);
			if (count > sa.size()/2){
//				System.out.println("added surface");
				surfs.add(sc);
			}
		}
		
		//get the global atoms
		if (trackBumps){
			globalResidues.clear();
			
			Vector s = this.getLoadedStructures();
			for (int i = 0; i < s.size(); i++){
				Vector aaa = ((Structure)s.get(i)).getStructureMap().getResidues();
				globalResidues.addAll(aaa);
			}
		}

		//we should have a list of atoms now
//		System.out.println("atoms = "+ atoms.size());
		
		//now walk through the atoms and detect bonds. take into account possible
		//bonds with the rest of the display: they will have to be broken
		//along the way, get the value for the center of the set, to know where
		//to apply the rotation matrix
		
		double sumX = 0;
		double sumY = 0;
		double sumZ = 0;
		
		independentSet.clear();
		
		
		Vector rr = (Vector)renderables.get(((Atom)atoms.get(0)).structure);
		
		Hashtable hash = (Hashtable)objectHash.get(((Atom)atoms.get(0)).structure);
		
		if (ribbons.size() > 0){
			//add ribbon renderables
			for (int i = 0; i < ribbons.size(); i++){
				if (hiddenComponents.containsKey(ribbons.get(i))) continue;
				MbtRenderable r = (MbtRenderable)hash.get(ribbons.get(i));
				if (r != null){
					independentGroup.addChild(r);
					rr.remove(r);
					renderablesList.remove(r);
				}
			}
		}
		
		//add surfaces
		if (surfs.size() > 0){
			for (int i = 0; i < surfs.size(); i++){
				if (hiddenComponents.containsKey(surfs.get(i))) continue;
				MbtRenderable r = (MbtRenderable)hash.get(surfs.get(i));
				if (r != null){
					independentGroup.addChild(r);
					rr.remove(r);
					renderablesList.remove(r);
				}
			}
		}
		
		//check for cluster renderables
		if (clusters.size() > 0){
			Set keys = clusters.keySet();
			Iterator it = keys.iterator();
			while (it.hasNext()){
				Cluster c = (Cluster)it.next();
				ClusterRenderable[] list = (ClusterRenderable[])clusters.get(c);
				
			}
		}
		
		//scan over atoms and bonds to be included in the independent set
		Vector bonds = new Vector();
		Vector boundaryBonds = new Vector();
		for (int i = 0; i < atoms.size(); i++){
			Atom a = (Atom)atoms.get(i);
			sumX += a.coordinate[0];
			sumY += a.coordinate[1];
			sumZ += a.coordinate[2];

			transformedCoordinates.put(a, new double[]{ a.coordinate[0], a.coordinate[1], a.coordinate[2] });

			independentSet.add(a);
			
			
			if (hash.get(a) != null){
				if (hiddenComponents.containsKey(a)) continue;
				independentGroup.addChild((GlRenderable)hash.get(a));
				renderablesList.remove(hash.get(a));
				rr.remove(hash.get(a));
			}
			
			if (atomToLabels.containsKey(a)){
				GlRenderable r = (GlRenderable)labels.get(atomToLabels.get(a));
				independentGroup.addChild(r);
				renderablesList.remove(r);
				rr.remove(r);
			}

			if (atomToResidueLabels.containsKey(a)){
				GlRenderable r = (GlRenderable)labels.get(atomToResidueLabels.get(a));
				independentGroup.addChild(r);
				renderablesList.remove(r);
				rr.remove(r);
			}

			Vector bb = a.structure.getStructureMap().getBonds(a);
			if (bb == null) continue;
			for (int j = 0; j < bb.size(); j++){
				Bond b = (Bond)bb.get(j);
				if (bonds.contains(b)) continue;
				independentSet.add(b);
				if (hash.get(b) != null && !bonds.contains(b)){
					if (hiddenComponents.containsKey(b)) continue;
					independentGroup.addChild((GlRenderable)hash.get(b));
					rr.remove(hash.get(b));
					renderablesList.remove(hash.get(b));
				}
				if (atoms.contains(b.getAtom(0)) && atoms.contains(b.getAtom(1))){
					//the bond is within the set
					if (!bonds.contains(b)) bonds.add(b);
				}
				else{
					if (!boundaryBonds.contains(b)) boundaryBonds.add(b);
				}
			}
		}
		
		for (int i = 0; i < independentSet.size(); i++){
			try{
				Atom a = (Atom)independentSet.get(i);
				if (atomToMonitors.containsKey(a)){
					Vector mm = (Vector)atomToMonitors.get(a);
					for (int j = 0; j < mm.size(); j++){
						MonitorComponent c = (MonitorComponent)mm.get(j);
						if (c.atom1 == a){
							if (independentSet.contains(c.atom2)){
								//the monitor should be added
								independentGroup.addChild((GlRenderable)monitors.get(c));
								renderablesList.remove(monitors.get(c));
								rr.remove(monitors.get(c));
							}
							else{
								/**
								 * TODO handle changing length of the distance marker
								 */
							}
						}
						else if (c.atom2 == a){
							if (independentSet.contains(c.atom1)){
								//the monitor should be added
								independentGroup.addChild((GlRenderable)monitors.get(c));
								renderablesList.remove(monitors.get(c));
								rr.remove(monitors.get(c));
							}
							else{
								//change of distance as the group rotates
							}
						}

					}
				}
				
				if (atomToHBonds.containsKey(a)){
					Vector mm = (Vector)atomToHBonds.get(a);
					for (int j = 0; j < mm.size(); j++){
						HydrogenBondComponent c = (HydrogenBondComponent)mm.get(j);
						if (c.atom1 == a){
							if (independentSet.contains(c.atom2)){
								//the monitor should be added
								independentGroup.addChild((GlRenderable)hBonds.get(c));
								renderablesList.remove(hBonds.get(c));
								rr.remove(hBonds.get(c));
							}
							else{
								//remove HB
								removeHBond(c, false);
							}
						}
						else if (c.atom2 == a){
							if (independentSet.contains(c.atom1)){
								//the monitor should be added
								independentGroup.addChild((GlRenderable)hBonds.get(c));
								renderablesList.remove(hBonds.get(c));
								rr.remove(hBonds.get(c));
							}
							else{
								//remove HB
								removeHBond(c, false);
							}
						}

					}
				}

				if (atomToBumps.containsKey(a)){
					Vector mm = (Vector)atomToBumps.get(a);
					for (int j = 0; j < mm.size(); j++){
						StericBumpComponent c = (StericBumpComponent)mm.get(j);
						if (c.atom1 == a){
							if (independentSet.contains(c.atom2)){
								//the bump should be added
								independentGroup.addChild((GlRenderable)bumps.get(c));
								renderablesList.remove(bumps.get(c));
								rr.remove(bumps.get(c));
							}
							else{
								//remove HB
								removeBump(c, false);
							}
						}
						else if (c.atom2 == a){
							if (independentSet.contains(c.atom1)){
								//the bump should be added
								independentGroup.addChild((GlRenderable)bumps.get(c));
								renderablesList.remove(bumps.get(c));
								rr.remove(bumps.get(c));
							}
							else{
								//remove HB
								removeBump(c, false);
							}
						}

					}
				}

			}
			catch (ClassCastException e){}
		}
		
		
		motionCenter = new double[]{ sumX/atoms.size(), sumY/atoms.size(), sumZ/atoms.size() };
		initialMotionCenter = new double[]{ sumX/atoms.size(), sumY/atoms.size(), sumZ/atoms.size() };
		
		double maxRadius = 3;
		//now get the maximum sphere radius
		for (int i = 0; i < atoms.size(); i++){
			Atom a = (Atom)atoms.get(i);
			double dist = Algebra.distance(motionCenter, a.coordinate);
			if (dist > maxRadius) maxRadius = dist;

		}
		
		//adjust maxRadius to make the virtual sphere a bit slower
		maxRadius *= 1.5;
		
		//add group to the list
		renderablesList.add(independentGroup);

		//assign the group to 0-th structure
		rr.add(independentGroup);
		
		//initialize coordinate matrix
		coordinateMatrix[0] = 1.0;
		coordinateMatrix[1] = 0.0;
		coordinateMatrix[2] = 0.0;
		coordinateMatrix[3] = 0.0;
		coordinateMatrix[4] = 0.0;
		coordinateMatrix[5] = 1.0;
		coordinateMatrix[6] = 0.0;
		coordinateMatrix[7] = 0.0;
		coordinateMatrix[8] = 0.0;
		coordinateMatrix[9] = 0.0;
		coordinateMatrix[10] = 1.0;
		coordinateMatrix[11] = 0.0;
		coordinateMatrix[12] = 0.0;
		coordinateMatrix[13] = 0.0;
		coordinateMatrix[14] = 0.0;
		coordinateMatrix[15] = 1.0;
		
		
		geometryViewer.setIndependentMotion(true, motionCenter, maxRadius);
		
//		System.out.println("Size of independent set after setting motion = " + independentSet.size());
		
		structureDocument.parent.setSeparateMotion(true);
		
		geometryViewer.updateView();
		
//		updateAppearance();
		structureDocument.parent.removeWaitScreen();
}

	public final boolean isTrackBumps() {
		return trackBumps;
	}

	public final void setTrackBumps(boolean trackBumps) {
		this.trackBumps = trackBumps;
	}
	
	public StructureDocument getStructureDocument(){
		return structureDocument;
	}
	
	public Structure getStructure(Entry e){
		return (Structure)structures.get(e);
	}
	
	public void renameStructure(Structure structure, String name){
		//get the entry and call structure document
		Entry e = (Entry)entries.get(structure);
		structureDocument.parent.renameEntry(e, name);
	}
	
	/**
	 * Checks whether there is a ribbon associated with this chain. If none, returns -1, otherwise the integer ribbon type
	 * @param chain
	 * @return
	 */
	public int hasRibbon(Chain chain){
		Hashtable structureHash = (Hashtable)objectHash.get(chain.structure);
		if (structureHash.containsKey(chain)){
			MbtRenderable r = (MbtRenderable)structureHash.get(chain);
			if (r != null){
				if (r.status){
					return chain.structure.getStructureMap().getStructureStyles().getRibbonType(chain);
				}
				else{
					return -1;
				}
			}
		}
		
		return -1;
	}
	
	public HashMap getMonitors(){
		return monitors;
	}
	
	public HashMap getHBonds(){
		return hBonds;
	}
	
	public HashMap getBumps(){
		return bumps;
	}
	
	public HashMap getLabels(){
		return labels;
	}
	
	public void superimpose(StructureComponent[] set1, StructureComponent[] set2){
		
		if (StylesPreferences.undoEnabled) this.saveStateForUndo();
		
		//some of these may be Chains if ribbon was clicked
		//get the atoms
		Vector atoms1 = new Vector();
		for (int i = 0; i < set1.length; i++){
			try{
				Atom a = (Atom)set1[i];
				atoms1.add(a);
			}
			catch (ClassCastException e){
				try{
					Residue r = (Residue)set1[i];
					Atom a = r.getAlphaAtom();
					if (a == null) a = r.getAtom(0);
					atoms1.add(a);
				}
				catch (ClassCastException ex){
					ex.printStackTrace();
				}
			}
		}
		
		Vector atoms2 = new Vector();
		for (int i = 0; i < set2.length; i++){
			try{
				Atom a = (Atom)set2[i];
				atoms2.add(a);
			}
			catch (ClassCastException e){
				try{
					Residue r = (Residue)set2[i];
					Atom a = r.getAlphaAtom();
					if (a == null) a = r.getAtom(0);
					atoms2.add(a);
				}
				catch (ClassCastException ex){
					ex.printStackTrace();
				}
			}
		}
		if (atoms1.size() < 3 || atoms2.size() < 3){
			structureDocument.parent.displayErrorMessage("Each set must contain three atoms for unambiguous superposition");
			return;
		}
		//check structures
		Structure structure1 = ((Atom)atoms1.get(0)).structure;
		Structure structure2 = ((Atom)atoms2.get(0)).structure;
		
		if (((Atom)atoms1.get(1)).structure != structure1 || ((Atom)atoms1.get(2)).structure != structure1){
			structureDocument.parent.displayErrorMessage("Atoms within each set must belong to one structure");
			return;
		}
		
		if (((Atom)atoms2.get(1)).structure != structure2 || ((Atom)atoms2.get(2)).structure != structure2){
			structureDocument.parent.displayErrorMessage("Atoms within each set must belong to one structure");
			return;
		}
		
		if (independentStructure == structure1 || independentStructure == structure2){
			setCommonMotion(false);
		}
				
		//get the atom set for the second structure
		Vector atoms = structure2.getStructureMap().getAtoms();
		
		//create Location objects
		double[] a1 = Algebra.getVector(((Atom)atoms1.get(0)).coordinate, ((Atom)atoms1.get(1)).coordinate);
		double[] b1 = Algebra.getVector(((Atom)atoms1.get(0)).coordinate, ((Atom)atoms1.get(2)).coordinate);
		double[] c1 = Algebra.getVector(((Atom)atoms1.get(1)).coordinate, ((Atom)atoms1.get(2)).coordinate);
		
		double[] a2 = Algebra.getVector(((Atom)atoms2.get(0)).coordinate, ((Atom)atoms2.get(1)).coordinate);
		double[] b2 = Algebra.getVector(((Atom)atoms2.get(0)).coordinate, ((Atom)atoms2.get(2)).coordinate);
		double[] c2 = Algebra.getVector(((Atom)atoms2.get(1)).coordinate, ((Atom)atoms2.get(2)).coordinate);
		
		
		//first, move the structure so that a's coincide
		//displacement vector
		double[] translation = new double[]{ ((Atom)atoms1.get(0)).coordinate[0] - ((Atom)atoms2.get(0)).coordinate[0], 
				((Atom)atoms1.get(0)).coordinate[1] - ((Atom)atoms2.get(0)).coordinate[1], 
				((Atom)atoms1.get(0)).coordinate[2] - ((Atom)atoms2.get(0)).coordinate[2] };
		
		double[] matrix = StructureMath.getLinearTranslationMatrix(translation);
		
		
		//now a's a in the same position
		//rotate the a2 vector so that it's colinear with a1
		//get the angle
		double angle = Algebra.getAngleBetweenVectors(a1, a2);
		double[] axis = Algebra.crossProduct(a1, a2);
		Algebra.normalizeVector(axis);
		
		double[][] rotation1 = StructureMath.getRotationMatrix(-angle, axis);
		double[] toOrigin = StructureMath.getToOriginMatrix(((Atom)atoms1.get(0)).coordinate);
		double[] fromOrigin = StructureMath.getFromOriginMatrix(((Atom)atoms1.get(0)).coordinate);
		
		//use it to transformn coordinates: combine translation and rotation in a single iteration
		for (int i = 0; i < atoms.size(); i++){
			Atom a = (Atom)atoms.get(i);
			StructureMath.transformCoordinates(a.coordinate, matrix);
			
			StructureMath.transformCoordinates(a.coordinate, toOrigin);
			StructureMath.transformCoordinates(a.coordinate, rotation1);
			StructureMath.transformCoordinates(a.coordinate, fromOrigin);
			
		}
		
		//now the vectors have changed and the coordinates of the second set of reference atoms are different
		//check whether the second atom in second structure is away from the second atom in the first structure, i.e. whether
		//a dual shift is needed
		double[] shift = Algebra.getVector(((Atom)atoms1.get(1)).coordinate, ((Atom)atoms2.get(1)).coordinate);
		
		if (Algebra.vectorLength(shift) > 0){
			//shift the coordinates by half of the vector's length to place the new structure symmetrical to the old one
			shift[0] *= -0.5;
			shift[1] *= -0.5;
			shift[2] *= -0.5;
			
			double[] t = StructureMath.getLinearTranslationMatrix(shift);
			for (int i = 0; i < atoms.size(); i++){
				Atom a = (Atom)atoms.get(i);
				StructureMath.transformCoordinates(a.coordinate, t);
				
			}
		}
		
		//recompute the vectors
		a2 = Algebra.getVector(((Atom)atoms2.get(0)).coordinate, ((Atom)atoms2.get(1)).coordinate);
		b2 = Algebra.getVector(((Atom)atoms2.get(0)).coordinate, ((Atom)atoms2.get(2)).coordinate);
		c2 = Algebra.getVector(((Atom)atoms2.get(1)).coordinate, ((Atom)atoms2.get(2)).coordinate);

		
		//now the c points need to be in the same plane, so figure out the angle between the abc planes
		//it has to be calculated as a dihedral angle to get the correct sign for rotation operation
		
		double angle2 = Algebra.dihedralAngle(((Atom)atoms1.get(2)).coordinate, ((Atom)atoms1.get(0)).coordinate, 
				((Atom)atoms2.get(1)).coordinate, ((Atom)atoms2.get(2)).coordinate);
		
		if (angle2 != 0){
			//axis of rotation will be the a2 vector
			double[] rotation2 = StructureMath.getLinearRotationMatrix(angle2, a2);
			
			toOrigin = StructureMath.getToOriginMatrix(((Atom)atoms2.get(1)).coordinate);
			fromOrigin = StructureMath.getFromOriginMatrix(((Atom)atoms2.get(1)).coordinate);
			
			for (int i = 0; i < atoms.size(); i++){
				Atom a = (Atom)atoms.get(i);
				StructureMath.transformCoordinates(a.coordinate, toOrigin);
				StructureMath.transformCoordinates(a.coordinate, rotation2);
				StructureMath.transformCoordinates(a.coordinate, fromOrigin);
			}
		}
		
		//now all three points should be in the same plane
		//calculate vector from c2 to c1 and then shift everything by half of that vector
		double[] shift2 = Algebra.getVector(((Atom)atoms2.get(2)).coordinate, ((Atom)atoms1.get(2)).coordinate);
		
		if (Algebra.vectorLength(shift2) > 0){
			//shift the coordinates by half of the vector's length to place the new structure symmetrical to the old one
			shift2[0] *= 0.5;
			shift2[1] *= 0.5;
			shift2[2] *= 0.5;
			
			double[] t = StructureMath.getLinearTranslationMatrix(shift2);
			for (int i = 0; i < atoms.size(); i++){
				Atom a = (Atom)atoms.get(i);
				StructureMath.transformCoordinates(a.coordinate, t);
				
			}
		}
		
		updateAppearance();
	}
	
	public void computeDistance(Atom atom1, Atom atom2){
		
		//check whether there is already distance monitor between these two atoms
		Set keys = monitors.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			MonitorComponent c = (MonitorComponent)it.next();
			if (c.atom1 == atom1 && c.atom2 == atom2){
				return;
			}
			if (c.atom1 == atom2 && c.atom2 == atom1){
				return;
			}
		}
		
		double[] a1 = new double[3];
		double[] a2 = new double[3];
		if (independentSet.contains(atom1)){
			a1 = (double[])transformedCoordinates.get(atom1);
		}
		else{
			a1 = atom1.coordinate;
		}
		
		if (independentSet.contains(atom2)){
			a2 = (double[])transformedCoordinates.get(atom2);
		}
		else{
			a2 = atom2.coordinate;
		}
		
		double distance = Algebra.distance(a1, a2);
		
		if (distance == 0.0){
			structureDocument.parent.displayMessage("Distance between selected atoms is zero.");
			return;
		}
		
		String res = (new Double(distance)).toString();
		int index = res.indexOf(".");
		String result = null;
		try{
			result = res.substring(0, index+3);//two decimal places after the dot
		}
		catch (Exception ex){
			//if it has only one digit after the dot to begin with
			result = res.substring(0, index+2);
		}
		
		//create the monitor
		createMonitor(atom1, atom2, result, null, true);

		structureDocument.parent.updateMonitorDialog();
	}
	
	public void computeAngle(Vector atoms){
		
		Vector bonds = new Vector();//Vector of Vectors
		for (int i = 0; i < atoms.size(); i++){
			//get the bonds
			bonds.add(((Atom)atoms.get(i)).structure.getStructureMap().getBonds((Atom)atoms.get(i)));
		}
		
		//search one by one and choose as central the atom with two bonds common to the entire set
		Atom central = null;
		Vector others = new Vector();//the two peripheral atoms
		for (int i = 0; i < atoms.size(); i++){
			int counter = 0;
			for (int j = 0; j < ((Vector)bonds.get(i)).size(); j++){
				Bond b = (Bond)((Vector)bonds.get(i)).elementAt(j);
				//now iterate over the other Bond Vectors
				for (int k = 0; k < bonds.size(); k++){
					if (i != k){//don't count itself
						if (((Vector)bonds.elementAt(k)).contains(b)){
							counter++;
						}
					}
				}
			}
			if (counter == 2){
				central = (Atom)atoms.elementAt(i);
				for (int f = 0; f < atoms.size(); f++){
					if ((Atom)atoms.elementAt(f) != central){
						others.add(atoms.elementAt(f));
					}
				}
				break;
			}
		}
		
		//if the three atoms are not immediately adjacent, bail out
		if ((central == null)||(others.size() < 2)){
			structureDocument.parent.displayErrorMessage("Invalid set of atoms for bond angle measurement.");
			return;
		}
			
		//now we have the atoms. do the math
		double angle = Algebra.getAngle(Algebra.getAtomCoordinates((Atom)others.elementAt(0)), Algebra.getAtomCoordinates(central), Algebra.getAtomCoordinates((Atom)others.elementAt(1)));
		
		String res = (new Double(angle)).toString();
		int index = res.indexOf(".");
		String result = null;
		try{
			result = res.substring(0, index+3);//two decimal places after the dot
		}
		catch (Exception ex){
			result = res.substring(0, index+2);
		}
//			System.out.println("Angle = " + result);
		
		structureDocument.parent.displayMessage("Bond angle = " + result + " degrees.");

	}
	
	public void setSelectionArea(Residue residue, double distance, boolean fullResidues){
		
		double maxDistance = distance + 7;//maximum distance from the center of the residue to be considered
		
		if (residue == null){
			//use current selection
			if (fullResidues){
				
				Vector passedResidues = new Vector();
				
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					StructureMap map = styles.getStructureMap();
					
					Enumeration selectedAtoms = styles.getSelection().keys();
					
					Vector residues = new Vector();
					Vector atoms = new Vector();
					
					//run residues first, then leftover atoms
					while (selectedAtoms.hasMoreElements()){
						StructureComponent sc = (StructureComponent)selectedAtoms.nextElement();
						try{
							Residue r = (Residue)sc;
							if (!residues.contains(r)) residues.add(r);
						}
						catch (ClassCastException e){
							try{
								Atom a = (Atom)sc;
								if (!atoms.contains(a)) atoms.add(a);
							}
							catch (Exception ex){}
						}
					}
					
					//go over residues first
					for (int j = 0; j < residues.size(); j++){
						Residue r = (Residue)residues.get(j);//r is a residue in the input set
						
						//run through the atoms in this residue
						
						for (int n = 0; n < r.getAtomCount(); n++){
							Atom a = r.getAtom(n);
							for (int k = 0; k < map.getResidueCount(); k++){
								Residue target = map.getResidue(k);
								
								if (passedResidues.contains(target) || residues.contains(target)) continue;
								if (target == r) continue;//itself
								
								//get the rough estimate of the distance
								Atom center = target.centerAtom;
								double dist = Algebra.distance(center.coordinate, a.coordinate);
								if (dist <= distance){
									//this center atom is within range
									passedResidues.add(target);
								}
								else if (dist <= maxDistance){
									//check all atoms, because some of them might still catch the range
									for (int m = 0; m < target.getAtomCount(); m++){
										Atom aa = target.getAtom(m);
										if (Algebra.distance(aa.coordinate, a.coordinate) <= distance){
											passedResidues.add(target);
											break;
										}
									}
								}
							}
						}		
					}
					
					//run through the lone atoms
					for (int j = 0; j < atoms.size(); j++){
						Atom a = (Atom)atoms.get(j);
						for (int k = 0; k < map.getResidueCount(); k++){
							Residue r = map.getResidue(k);
							if (passedResidues.contains(r)) continue;
							if (residues.contains(r)) continue;
							if (r.getCompoundCode().equals("HOH") || r.getCompoundCode().equals("WAT")){
								if (!r.visible){
									continue;
								}
							}
							
							//get the rough estimate of the distance
							Atom center = r.centerAtom;
							double dist = Algebra.distance(center.coordinate, a.coordinate);
							if (dist <= distance){
								//this center atom is within range
								passedResidues.add(r);
							}
							else if (dist <= maxDistance){
								//check all atoms, because some of them might still catch the range
								for (int n = 0; n < r.getAtomCount(); n++){
									Atom aa = r.getAtom(n);
									if (Algebra.distance(aa.coordinate, a.coordinate) <= distance){
										passedResidues.add(r);
										break;
									}
								}
							}
						}
						
					}
					
					Vector chains = new Vector();//affected chains
										
					//set selection
					for (int j = 0; j < passedResidues.size(); j++){
						Residue r = (Residue)passedResidues.get(j);
						styles.setSelected(r, true, true, true);
						Chain c = r.structure.getStructureMap().getChain(r.getAtom(0));
						if (!chains.contains(c)) chains.add(c);
					}
					
					for (int j = 0; j < chains.size(); j++){
						Chain c = (Chain)chains.get(j);
						c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
//						selectedChains.add(c);
					}

				}
				
				structureDocument.parent.updateView();
				
			}
			else{
				//selection-based with no residue object - use existing selection, and cut through the residues
				
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Vector passedAtoms = new Vector();

					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					StructureMap map = styles.getStructureMap();
					
					Enumeration selectedAtoms = styles.getSelection().keys();
					
					Vector residues = new Vector();
					Vector atoms = new Vector();
					
					//run residues first, then leftover atoms
					while (selectedAtoms.hasMoreElements()){
						StructureComponent sc = (StructureComponent)selectedAtoms.nextElement();
						try{
							Residue r = (Residue)sc;
							if (!residues.contains(r)) residues.add(r);
						}
						catch (ClassCastException e){
							try{
								Atom a = (Atom)sc;
								if (!atoms.contains(a)) atoms.add(a);
							}
							catch (Exception ex){}
						}
					}
					
					//go over residues first
					for (int j = 0; j < residues.size(); j++){
						Residue res = (Residue)residues.get(j);//r is a residue in the input set
						
						//run through the atoms in this residue
						
						for (int k = 0; k < res.getAtomCount(); k++){
							Atom a = res.getAtom(k);
							for (int n = 0; n < map.getResidueCount(); n++){
								Residue r = map.getResidue(n);
								if (r == res) continue;
								if (r.getCompoundCode().equals("HOH") || r.getCompoundCode().equals("WAT")){
									if (!r.visible){
										continue;
									}
								}
								
								//get the rough estimate of the distance
								Atom center = r.centerAtom;
								double dist = Algebra.distance(center.coordinate, a.coordinate);
								if (dist > maxDistance){
									//this center atom is outside of the range, so it's unlikely that any atoms will be close
									continue;
								}
								else{
									//check all atoms, because some of them might catch the range
									for (int m = 0; m < r.getAtomCount(); m++){
										Atom aa = r.getAtom(m);
										if (Algebra.distance(aa.coordinate, a.coordinate) <= distance){
											if (!passedAtoms.contains(aa)) passedAtoms.add(aa);
										}
									}
								}
							}
							
						}
					}
					
					//run through the lone atoms
					for (int j = 0; j < atoms.size(); j++){
						Atom a = (Atom)atoms.get(j);
						for (int k = 0; k < map.getResidueCount(); k++){
							Residue r = map.getResidue(k);

							if (residues.contains(r)) continue;
							
							//get the rough estimate of the distance
							Atom center = r.centerAtom;
							double dist = Algebra.distance(center.coordinate, a.coordinate);
							if (dist > maxDistance){
								//this center atom is outside of the range, so it's unlikely that any atoms will be close
								continue;
							}
							else{
								//check all atoms, because some of them might catch the range
								for (int m = 0; m < r.getAtomCount(); m++){
									Atom aa = r.getAtom(m);
									if (Algebra.distance(aa.coordinate, a.coordinate) <= distance){
										if (!passedAtoms.contains(aa)) passedAtoms.add(aa);
									}
								}
							}
						}
						
					}
					
//					System.out.println("passedAtoms = " + passedAtoms.size());
										
					//set selection
					for (int j = 0; j < passedAtoms.size(); j++){
						styles.setSelected((Atom)passedAtoms.get(j), true, true, true);
					}
				}
				
				structureDocument.parent.updateView();

			}
		}
		else{
			//residue is specified
			if (fullResidues){
				Vector passedResidues = new Vector();
				StructureMap map = residue.structure.getStructureMap();
				for (int i = 0; i < residue.getAtomCount(); i++){
					Atom a = residue.getAtom(i);
					for (int j = 0; j < map.getResidueCount(); j++){
						Residue r = map.getResidue(j);
						if (passedResidues.contains(r)) continue;
						if (r == residue) continue;
						
						if (r.getCompoundCode().equals("HOH") || r.getCompoundCode().equals("WAT")){
							if (!r.visible){
								continue;
							}
						}
						
						//get the rough estimate of the distance
						Atom center = r.centerAtom;
						double dist = Algebra.distance(center.coordinate, a.coordinate);
						if (dist <= distance){
							//this center atom is within range
							passedResidues.add(r);
						}
						else if (dist <= maxDistance){
							//check all atoms, because some of them might still catch the range
							for (int k = 0; k < r.getAtomCount(); k++){
								Atom aa = r.getAtom(k);
								if (Algebra.distance(aa.coordinate, a.coordinate) <= distance){
									passedResidues.add(r);
									break;
								}
							}
						}
					}
					
				}
				
				//select all passed residues
				Vector chains = new Vector();//affected chains
				
				//set selection
				for (int j = 0; j < passedResidues.size(); j++){
					Residue r = (Residue)passedResidues.get(j);
					r.structure.getStructureMap().getStructureStyles().setSelected(r, true, true, true);
					Chain c = r.structure.getStructureMap().getChain(r.getAtom(0));
					if (!chains.contains(c)) chains.add(c);
				}
				
				for (int j = 0; j < chains.size(); j++){
					Chain c = (Chain)chains.get(j);
					c.structure.getStructureMap().getStructureStyles().updateChain(c, true);
//					selectedChains.add(c);
				}

				
				structureDocument.parent.updateView();
			}
			else{
				//cut the residues and select only the close atoms
				Vector passedAtoms = new Vector();
				StructureMap map = residue.structure.getStructureMap();
				for (int i = 0; i < residue.getAtomCount(); i++){
					Atom a = residue.getAtom(i);
					for (int j = 0; j < map.getResidueCount(); j++){
						Residue r = map.getResidue(j);
						if (r == residue) continue;
						if (r.getCompoundCode().equals("HOH") || r.getCompoundCode().equals("WAT")){
							if (!r.visible){
								continue;
							}
						}
						
						//get the rough estimate of the distance
						Atom center = r.centerAtom;
						double dist = Algebra.distance(center.coordinate, a.coordinate);
						if (dist > maxDistance){
							//this center atom is outside of the range, so it's unlikely that any atoms will be close
							continue;
						}
						else{
							//check all atoms, because some of them might catch the range
							for (int k = 0; k < r.getAtomCount(); k++){
								Atom aa = r.getAtom(k);
								if (Algebra.distance(aa.coordinate, a.coordinate) <= distance){
									passedAtoms.add(aa);
								}
							}
						}
					}
				}
				
				for (int i = 0; i < passedAtoms.size(); i++){
					map.getStructureStyles().setSelected((Atom)passedAtoms.get(i), true, true, true);
				}
				structureDocument.parent.updateView();
			}
		}
	}
	
	public void setFormalCharge(StructureComponent sc, String label, short charge){
		
		if (sc == null && (label == null || label.length() == 0)) return;
		
		Atom atom = null;
		if (sc == null){
			sc = (StructureComponent)this.labelToObject(label);
		}
		
		if (sc == null){
			structureDocument.parent.displayErrorMessage("Atom could not be identified. Please try again");
			return;
		}
		
		
		
		try{
			atom = (Atom)sc;
		}
		catch (ClassCastException ex){
			structureDocument.parent.displayErrorMessage("An atom must be picked for this operation");
			return;
		}
		
		if (atom == null){
			structureDocument.parent.displayErrorMessage("Atom could not be identified. Please try again");
			return;
		}
		
		atom.formalCharge = charge;
		
		StructureMath.checkHydrogens(atom, this, 7.0f, false);
		
		//here it would be appropriate to display a label
		
		/**
		 * TODO label, once the labeling is worked out
		 */
		
		if (atomToLabels.containsKey(atom)){
			LabelComponent c = (LabelComponent)atomToLabels.get(atom);
			GlRenderable r = (GlRenderable)labels.get(c);
			r.setDirty();
			
			MonitorDialog md = structureDocument.parent.getMonitorDialog();
			if (md != null) md.updateTree();
		}
		
		structureDocument.parent.updateView();
	}
	
	public void clearAnnotationSelection(){
		
		Set keys = monitors.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			MonitorComponent mc = (MonitorComponent)it.next();
			mc.setSelected(false);
			MonitorRenderable mr = (MonitorRenderable)monitors.get(mc);
			if (mr != null){
				mr.setDirty();
			}
		}
		
		keys = hBonds.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			HydrogenBondComponent hc = (HydrogenBondComponent)it.next();
			hc.setSelected(false);
			MonitorRenderable mr = (MonitorRenderable)hBonds.get(hc);
			if (mr != null){
				mr.setDirty();
			}
		}
		
		keys = bumps.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			StericBumpComponent bc = (StericBumpComponent)it.next();
			bc.setSelected(false);
			MonitorRenderable mr = (MonitorRenderable)bumps.get(bc);
			if (mr != null){
				mr.setDirty();
			}
		}
		
		keys = labels.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			Object component = it.next();
			try{
				LabelComponent bc = (LabelComponent)component;
				bc.setSelected(false);
				MonitorRenderable mr = (MonitorRenderable)labels.get(bc);
				if (mr != null){
					mr.setDirty();
				}
			}
			catch (ClassCastException e){
				ResidueLabelComponent bc = (ResidueLabelComponent)component;
				bc.setSelected(false);
				MonitorRenderable mr = (MonitorRenderable)labels.get(bc);
				if (mr != null){
					mr.setDirty();
				}
			}
		}

		structureDocument.parent.updateView();
		
	}
	
	public void setAnnotationVisibility(boolean visible, boolean batch){
		
		MonitorDialog md = structureDocument.parent.getMonitorDialog();
		
		Set keys = monitors.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			MonitorComponent mc = (MonitorComponent)it.next();
			setAnnotationVisibility(mc, visible, batch);
			if (md != null) md.setVisibility(mc, visible, true);
		}
		
		keys = hBonds.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			HydrogenBondComponent hc = (HydrogenBondComponent)it.next();
			setAnnotationVisibility(hc, visible, batch);
			if (md != null) md.setVisibility(hc, visible, true);
		}
		
		keys = bumps.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			StericBumpComponent bc = (StericBumpComponent)it.next();
			setAnnotationVisibility(bc, visible, batch);
			if (md != null) md.setVisibility(bc, visible, true);
		}
		
		keys = labels.keySet();
		it = keys.iterator();
		while (it.hasNext()){
			LabelComponent bc = (LabelComponent)it.next();
			setAnnotationVisibility(bc, visible, batch);
			if (md != null) md.setVisibility(bc, visible, true);
		}
		
	}
	
	public void setAnnotationVisibility(AnnotationComponent ac, boolean visible, boolean batch){
		
		MonitorDialog md = structureDocument.parent.getMonitorDialog();

		int type = ac.getType();
		if (type == AnnotationComponentRegistry.TYPE_MONITOR){
			MonitorRenderable r = (MonitorRenderable)monitors.get(ac);
			if (r != null){
				if (visible){
					if (independentSet != null && (independentSet.contains(((MonitorComponent)ac).atom1) || 
							independentSet.contains(((MonitorComponent)ac).atom2))){
						independentGroup.addChild(r);
					}
					if (rotatedSet != null && (rotatedSet.contains(((MonitorComponent)ac).atom1) || 
							rotatedSet.contains(((MonitorComponent)ac).atom2))){
						rotationGroup.addChild(r);
					}
					else if (!renderablesList.contains(r)){
						renderablesList.add(r);
					}
				}
				else{
					if (renderablesList.contains(r)){
						renderablesList.remove(r);
					}
					else if (rotationGroup != null && rotationGroup.containsChild(r)){
						rotationGroup.removeChild(r);
					}
					else if (independentGroup != null && independentGroup.containsChild(r)){
						independentGroup.removeChild(r);
					}
				}
				
			}
		}
		
		if (type == AnnotationComponentRegistry.TYPE_HYDROGEN_BOND){
			MonitorRenderable r = (MonitorRenderable)hBonds.get(ac);
			if (r != null){
				if (visible){
					if (independentSet != null && (independentSet.contains(((HydrogenBondComponent)ac).atom1) || 
							independentSet.contains(((HydrogenBondComponent)ac).atom2))){
						independentGroup.addChild(r);
					}
					if (rotatedSet != null && (rotatedSet.contains(((HydrogenBondComponent)ac).atom1) || 
							rotatedSet.contains(((HydrogenBondComponent)ac).atom2))){
						rotationGroup.addChild(r);
					}
					else if (!renderablesList.contains(r)){
						renderablesList.add(r);
					}
				}
				else{
					if (renderablesList.contains(r)){
						renderablesList.remove(r);
					}
					else if (rotationGroup != null && rotationGroup.containsChild(r)){
						rotationGroup.removeChild(r);
					}
					else if (independentGroup != null && independentGroup.containsChild(r)){
						independentGroup.removeChild(r);
					}
				}
			}
		}

		if (type == AnnotationComponentRegistry.TYPE_STERIC_BUMP){
			MonitorRenderable r = (MonitorRenderable)bumps.get(ac);
			if (r != null){
				if (visible){
					if (independentSet != null && (independentSet.contains(((StericBumpComponent)ac).atom1) || 
							independentSet.contains(((StericBumpComponent)ac).atom2))){
						independentGroup.addChild(r);
					}
					if (rotatedSet != null && (rotatedSet.contains(((StericBumpComponent)ac).atom1) || 
							rotatedSet.contains(((StericBumpComponent)ac).atom2))){
						rotationGroup.addChild(r);
					}
					else if (!renderablesList.contains(r)){
						renderablesList.add(r);
					}
				}
				else{
					if (renderablesList.contains(r)){
						renderablesList.remove(r);
					}
					else if (rotationGroup != null && rotationGroup.containsChild(r)){
						rotationGroup.removeChild(r);
					}
					else if (independentGroup != null && independentGroup.containsChild(r)){
						independentGroup.removeChild(r);
					}
				}
			}
		}
		
		if (type == AnnotationComponentRegistry.TYPE_LABEL){
			MonitorRenderable r = (MonitorRenderable)labels.get(ac);
			if (r != null){
				if (visible){
					if (independentSet != null && independentSet.contains(((LabelComponent)ac).atom)){
						independentGroup.addChild(r);
					}
					if (rotatedSet != null && (rotatedSet.contains(((LabelComponent)ac).atom) || 
							rotatedSet.contains(((LabelComponent)ac).atom))){
						rotationGroup.addChild(r);
					}
					else if (!renderablesList.contains(r)){
						renderablesList.add(r);
					}
				}
				else{
					if (renderablesList.contains(r)){
						renderablesList.remove(r);
					}
					else if (rotationGroup != null && rotationGroup.containsChild(r)){
						rotationGroup.removeChild(r);
					}
					else if (independentGroup != null && independentGroup.containsChild(r)){
						independentGroup.removeChild(r);
					}
				}
			}
		}

		if (type == AnnotationComponentRegistry.TYPE_RESIDUE_LABEL){
			MonitorRenderable r = (MonitorRenderable)labels.get(ac);
			if (r != null){
				if (visible){
					if (independentSet != null && independentSet.contains(((ResidueLabelComponent)ac).reference)){
						independentGroup.addChild(r);
					}
					if (rotatedSet != null && (rotatedSet.contains(((ResidueLabelComponent)ac).reference) || 
							rotatedSet.contains(((ResidueLabelComponent)ac).reference))){
						rotationGroup.addChild(r);
					}
					else if (!renderablesList.contains(r)){
						renderablesList.add(r);
					}
				}
				else{
					if (renderablesList.contains(r)){
						renderablesList.remove(r);
					}
					else if (rotationGroup != null && rotationGroup.containsChild(r)){
						rotationGroup.removeChild(r);
					}
					else if (independentGroup != null && independentGroup.containsChild(r)){
						independentGroup.removeChild(r);
					}
				}
			}
		}

		if (md != null) md.setVisibility(ac, visible, true);

		geometryViewer.setRenderables(renderablesList);
		if (!batch) geometryViewer.updateView();

	}
	
	/**
	 * This method is designed for use with applets where local installation of structure alignment
	 * software is not available. The applet then calls the appropriate servlet and submits the two
	 * pdb files. The return is two text entries: command line output of TMalign and the produced
	 * rasmol input style file
	 * @param structure1
	 * @param structure2
	 */
	public void alignStructuresRemotely(Structure structure1, Structure structure2){
		
		//convert each structure into a text pdb file
		String pdb1 = IOHandler.convertStructureToPdb(structure1, structureDocument.parent, true);
		String pdb2 = IOHandler.convertStructureToPdb(structure2, structureDocument.parent, true);
		
		String name1 = this.getStructureName(structure1) + ".pdb";
		String name2 = this.getStructureName(structure2) + ".pdb";
		
		Vector out = new Vector();
		String[] map1 = new String[2];
		map1[0] = name1;
		map1[1] = pdb1;
		out.add(map1);
		
		String[] map2 = new String[2];
		map2[0] = name2;
		map2[1] = pdb2;
		out.add(map2);
		
		//show processing flag while working
		structureDocument.parent.displayWaitScreen();

		
		//now call the servlet with these input strings
		try{
			URL servletURL = new URL(DataService.servletHost + "/servlet/AlignmentDispatcher");//don't translate
			URLConnection uc = servletURL.openConnection();
			uc.setDoOutput(true);
			uc.setDoInput(true);
			uc.setUseCaches(false);
			uc.setRequestProperty("Content-type", "application/octet-stream");//don't translate
	
			ObjectOutputStream objOut = new ObjectOutputStream(new GZIPOutputStream(uc.getOutputStream()));
			objOut.writeObject(out);
			objOut.flush();
			objOut.close();
			
			ObjectInputStream objIn = new ObjectInputStream(new GZIPInputStream(uc.getInputStream()));
			Vector rtn =  (Vector)objIn.readObject();
			objIn.close();
			
			String output = (String)rtn.get(0);
			String sup = (String)rtn.get(1);
			
//			System.out.println("output = " + output);
//			System.out.println("sup = " + sup);
			
			
			//now proceed with the processing just like for the local version
			//process command line output first
			String[] dump = new String[2];
			boolean append = false;
			boolean passed = false;
			int i = 0;
			StringTokenizer tok = new StringTokenizer(output, "\n", false);
			while (tok.hasMoreTokens()){
				String linea = tok.nextToken();
				if (append){
					dump[i] = linea;
					i++;
					append = false;
					passed = true;
					continue;
				}
				if (linea.startsWith("(")) append = true;
				if (passed) append = true;
			}

			//the two new sequences are in the dump array
			//take care of the sequence record
			Entry e1 = (Entry)entries.get(structure1);
			Entry e2 = (Entry)entries.get(structure2);
			
			if (e1 == null || e2 == null){
				System.out.println("Unable to update sequence");
			}
			else{
				structureDocument.parent.openSequence();
				
				HashMap set = new HashMap();
				set.put(e1, dump[0]);
				set.put(e2, dump[1]);
				
				Vector order = new Vector();
				order.add(e1);
				order.add(e2);
				
				structureDocument.parent.getSequenceViewer().setSequences(set, order);
//				structureDocument.parent.getSequenceViewer().setSequence(e2, dump[1], true);
			}
			
			//read the content of the output file
			String liner = null;
			boolean read = false;
			
			HashMap map = new HashMap();//residue number (String) -> double[] coordinates of CA
			
			String[] numbers = new String[4];
			Vector result = new Vector();//resulting coordinates
			int j = 0;
			StringTokenizer tokenizer = new StringTokenizer(sup, "\n", false);
			while (tokenizer.hasMoreTokens()){
				liner = tokenizer.nextToken();
				if (liner.startsWith("REMARK Aligned")){//don't translate
					read = true;
					continue;
				}
				
				if (liner.startsWith("CONECT")){//don't translate
					break;
				}
				
				if (j == 4) break;
				
				if (read){
					//read in the record for the current CA
					if (liner.startsWith("ATOM")){//don't translate
						String number = liner.substring(22,26);
						String xs = liner.substring(30,38);
						String ys = liner.substring(38,46);
						String zs = liner.substring(46,52);
						
						try{
							double x = Double.parseDouble(xs);
							double y = Double.parseDouble(ys);
							double z = Double.parseDouble(zs);
							
							numbers[j] = number.trim();
							result.add(new double[]{ x, y, z });
							j++;
						}
						catch (NumberFormatException ex){
							System.out.println("error parsing atom record");
						}
					}
				}
			}
			
			
			//generate the three vectors and make the corresponding vectors from the same atoms before
			//the transformation
			Vector initial = new Vector();//initial coordinates
			
			//scan through all residues in the initial structure to make sure the correct CA's are chosen
			int found = 0;//how many residues have been matched
			for (int n = 0; n < structure1.getStructureMap().getResidueCount(); n++){
				Residue r = structure1.getStructureMap().getResidue(n);
				
				int num = r.getResidueId();
				
				String Num = (new Integer(num)).toString();
				for (int k = 0; k < numbers.length; k++){
					if (Num.equals((String)numbers[k])){
						found++;
						Atom ca = r.getAlphaAtom();
						if (ca == null) break;
						initial.add(k, ca.coordinate);
						break;
					}
				}
				
				if (found == 4) break;
					
					
			}
			
			//now get the three vectors to be used to determine the transformation matrix.
			//0 -> 1, 0 -> 2, 0 -> 3
			Vector initialVectors = new Vector();
			double[] start1 = (double[])initial.get(0);
			for (int k = 1; k < initial.size(); k++){
				double[] end = (double[])initial.get(k);
				double[] v = new double[]{ end[0] - start1[0], end[1] - start1[1], end[2] - start1[2] };
				initialVectors.add(v);
			}
			
			Vector resultVectors = new Vector();
			double[] start2 = (double[])result.get(0);
			for (int k = 1; k < result.size(); k++){
				double[] end = (double[])result.get(k);
				double[] v = new double[]{ end[0] - start2[0], end[1] - start2[1], end[2] - start2[2] };
				resultVectors.add(v);
			}
			
			//now with this set of vectors, calculate the matrix
			Location start = new Location((double[])initialVectors.get(0), (double[])initialVectors.get(1), start1);
			Location target = new Location((double[])resultVectors.get(0), (double[])resultVectors.get(1), start2);
			
			StructureMath.transformStructure(start, target, structure1);
			
			structureDocument.parent.removeWaitScreen();

			
			resetView();
			updateAppearance();
		

		}
		catch (Exception e){
			structureDocument.parent.removeWaitScreen();
			e.printStackTrace();
			structureDocument.parent.displayErrorMessage("Error running remote alignment");
			return;
		}
	}
	
	/**
	 * This method uses a local copy of compiled CE executable.
	 * It saves the structures in temporary files in the temp directory under the application
	 * folder, then starts CE as an external process giving it the file names and chain ids.
	 * After the alignment has finished, the matrix is read in from the output, and the coordinates
	 * of the second structure are transformed.
	 * @param chain1
	 * @param chain2
	 */
	public void alignStructures(Structure structure1, int subset1, String set1, Structure structure2, int subset2, String set2, 
			StructureAlignmentDialog dialog){
		
//		System.out.println("local structure alignment");
		
		//get the location of the TM directory
		Preferences root = Preferences.userRoot();
		final Preferences node = root.node("/edu/sdsc/sirius/config");//don't translate
		String path = node.get("installDir", null);

		if (path == null){
			structureDocument.parent.displayErrorMessage("Unable to locate TM-align installation directory");
			return;
		}
		
		String tm = path + File.separator + "tm" + File.separator;
		
//		String tm = "/opt/Sirius/tm/";
//		System.out.println("tm = " + tm);
		
		
//		Structure structure1 = chain1.structure;
//		Structure structure2 = chain2.structure;
		String name1 = tm + this.getStructureName(structure1) + ".pdb";
		String name2 = tm + this.getStructureName(structure2) + ".pdb";
		
		//determine architecture of the environment, which will define the binary to be called
		String os = System.getProperty("os.name");//don't translate
		String arch = System.getProperty("os.arch");//don't translate
		
//		System.out.println("os = " + os + ", arch = " + arch);
		
		String rmsd = null;
		
		String binary = null;
		if (os.startsWith("Win")){//don't translate
			binary = "TMalignWin.exe";
		}
		else if (os.startsWith("Linux")){//don't translate
			binary = "TMalign_32";
		}
		else if (os.startsWith("Mac")){//don't translate
			if (arch.startsWith("x86")){
				binary = "TMalignIntel";
			}
			else{
				binary = "TMalignPPC";
			}
		}
		
		if (binary == null){
			structureDocument.parent.displayErrorMessage("Unable to find TM-align executable");
			return;
		}
		
		//these are pieces of sequence before and after each fragment of structure submitted for alignment (in case incomplete structure is requested)
		//they are added to the structure after the alignment to keep sequence viewer happy
		String pre1 = "";
		String post1 = "";
		String pre2 = "";
		String post2 = "";
		
//		System.out.println("binary = " + binary);
		
		try{
			if (subset1 == StructureAlignmentDialog.USE_SELECTION){
				
				//check if anything is even selected
				Enumeration selection = structure1.getStructureMap().getStructureStyles().getSelection().keys();
				if (!selection.hasMoreElements()){
					//nothing is selected
					structureDocument.parent.displayErrorMessage("Nothing is selected in reference structure. Check selection state and try again");
					dialog.processAlignment("");
					return;
				}

				Vector residues = new Vector();
				while (selection.hasMoreElements()){
					try{
						Residue r = (Residue)selection.nextElement();
						residues.add(r);
					}
					catch (ClassCastException ex){
//						ex.printStackTrace();
					}
				}
				
				if (residues.size() == 0){
					structureDocument.parent.displayErrorMessage("Selection in reference structure must only include full residues.");
					dialog.processAlignment("");
					return;
				}
				
				
				StringBuffer pre = new StringBuffer();
				StringBuffer post = new StringBuffer();
				//check for consecutive order
				boolean start = false;
				boolean end = false;
				for (int i = 0; i < structure1.getStructureMap().getResidueCount(); i++){
					Residue r = structure1.getStructureMap().getResidue(i);
					String code = r.getCompoundCode();
					if (residues.contains(r)){
						if (end){
							//a stretch of residues has already been passed
							structureDocument.parent.displayErrorMessage("Selected residues in reference structure must be contiguous.");
							dialog.processAlignment("");
							return;
						}
						if (!start) start = true;
					}
					else{
						if (!start){
							if (r.getClassification() == Residue.COMPOUND_AMINO_ACID){
								pre.append(ProteinProperties.getSingleLetterAminoAcidName(code));
							}
							else if (r.getClassification() == Residue.COMPOUND_NUCLEIC_ACID){
								if (code.length() == 1){
									pre.append(code);
								}
								else{
									pre.append(DNAProperties.getSymbolFromThreeLetters(code));
								}
							}
						}
						
						if (start) end = true;
						
						if (end){
							if (r.getClassification() == Residue.COMPOUND_AMINO_ACID){
								post.append(ProteinProperties.getSingleLetterAminoAcidName(code));
							}
							else if (r.getClassification() == Residue.COMPOUND_NUCLEIC_ACID){
								if (code.length() == 1){
									post.append(code);
								}
								else{
									post.append(DNAProperties.getSymbolFromThreeLetters(code));
								}
							}
						}
					}
				}
				
				pre1 = pre.toString();
				post1 = post.toString();
				
				IOHandler.selection = true;
				IOHandler.savePdb(structure1, name1, structureDocument.parent, null, false, false);
				IOHandler.selection = false;
			}
			else if (subset1 == StructureAlignmentDialog.USE_SET){
				
			}
			else{
				IOHandler.savePdb(structure1, name1, structureDocument.parent, null, false, false);
			}
			
			
			
			if (subset2 == StructureAlignmentDialog.USE_SELECTION){
				
//				System.out.println("subset2 selection option");
				//check if anything is even selected
				Enumeration selection = structure2.getStructureMap().getStructureStyles().getSelection().keys();
				if (!selection.hasMoreElements()){
					//nothing is selected
					structureDocument.parent.displayErrorMessage("Nothing is selected in aligned structure. Check selection state and try again");
					dialog.processAlignment("");
					return;
				}

				Vector residues = new Vector();
				while (selection.hasMoreElements()){
					try{
						Residue r = (Residue)selection.nextElement();
						residues.add(r);
					}
					catch (ClassCastException ex){}
				}
				
				if (residues.size() == 0){
					structureDocument.parent.displayErrorMessage("Selection in aligned structure must only include full residues.");
					dialog.processAlignment("");
					return;
				}
				
				//check for consecutive order
				StringBuffer pre = new StringBuffer();
				StringBuffer post = new StringBuffer();
				boolean start = false;
				boolean end = false;
				for (int i = 0; i < structure2.getStructureMap().getResidueCount(); i++){
					Residue r = structure2.getStructureMap().getResidue(i);
					String code = r.getCompoundCode();
					if (residues.contains(r)){
						if (end){
							//a stretch of residues has already been passed
							structureDocument.parent.displayErrorMessage("Selected residues in aligned structure must be contiguous.");
							dialog.processAlignment("");
							return;
						}
						if (!start) start = true;
					}
					else{
						if (!start){
							if (r.getClassification() == Residue.COMPOUND_AMINO_ACID){
								pre.append(ProteinProperties.getSingleLetterAminoAcidName(code));
							}
							else if (r.getClassification() == Residue.COMPOUND_NUCLEIC_ACID){
								if (code.length() == 1){
									pre.append(code);
								}
								else{
									pre.append(DNAProperties.getSymbolFromThreeLetters(code));
								}
							}
						}
						if (start) end = true;
						
						if (end){
							if (r.getClassification() == Residue.COMPOUND_AMINO_ACID){
								post.append(ProteinProperties.getSingleLetterAminoAcidName(code));
							}
							else if (r.getClassification() == Residue.COMPOUND_NUCLEIC_ACID){
								if (code.length() == 1){
									post.append(code);
								}
								else{
									post.append(DNAProperties.getSymbolFromThreeLetters(code));
								}
							}
						}
					}
				}
				
				pre2 = pre.toString();
				post2 = post.toString();

				IOHandler.selection = true;
				IOHandler.savePdb(structure2, name2, structureDocument.parent, null, false, false);
				IOHandler.selection = false;
			}
			else if (subset2 == StructureAlignmentDialog.USE_SET){
				
			}
			else{
				IOHandler.savePdb(structure2, name2, structureDocument.parent, null, false, false);
			}
			
			
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception saving files for alignment", ex);
			dialog.processAlignment("");
			return;
		}
		
		//now launch TMalign with the structure files and chain ids as arguments
		//temp directory is used as a scratch location
		
		//show processing flag while working
		structureDocument.parent.displayWaitScreen();
		
		File output = null;
		
		try{
			
			String[] c = new String[5];
			c[0] = tm + binary;
			c[1] = name1;
			c[2] = name2;
			c[3] = "-o";
			c[4] = tm + "tm.sup";
						
			Process process = Runtime.getRuntime().exec(c);
			
			InputStream in = process.getInputStream();
			BufferedReader reader1 = new BufferedReader(new InputStreamReader(in));
			String linea = null;
			String[] dump = new String[2];
			boolean append = false;
			boolean passed = false;
			int i = 0;
			while ((linea = reader1.readLine()) != null){
//				System.out.println(linea);
				if (append){
					dump[i] = linea;
					i++;
					append = false;
					passed = true;
					continue;
				}
				if (linea.startsWith("(")) append = true;
				if (passed) append = true;
			}
	        in.close();
	        
	        //check for output file
			output = new File(tm + "tm.sup");
			
			if (output.exists()){
				
				//take care of the sequence record
				Entry e1 = (Entry)entries.get(structure1);
				Entry e2 = (Entry)entries.get(structure2);
				
				if (e1 == null || e2 == null){
					System.out.println("unable to update sequence");
				}
				else{
					structureDocument.parent.openSequence();
					
					String seq1 = dump[0];
					String seq2 = dump[1];
					
//					System.out.println(seq1);
//					System.out.println(seq2);
					
					//the lengths are the same, so pad the pre and post sequences to maintain the alignment
					if (pre1.length() > 0 || pre2.length() > 0){
						//need to prepend
						if (pre1.length() == pre2.length()){
							//just add them
							seq1 = pre1 + seq1 + post1;
							seq2 = pre2 + seq2 + post2;
						}
						else if (pre1.length() > pre2.length()){
							//add padding to pre2
							seq1 = pre1 + seq1 + post1;
							seq2 = StringUtils.leftPadded(pre2, pre1.length(), "-") + seq2 + post2;
						}
						else{
							//pre2 is longer
							seq1 = StringUtils.leftPadded(pre1, pre2.length(), "-") + seq1 + post1;
							seq2 = pre2 + seq2 + post2;
						}
					}
					
					if (seq1.length() > seq2.length()){
						//pad seq2 at the end
						seq2 = StringUtils.rightPadded(seq2, seq1.length(), "-");
					}
					else if (seq2.length() > seq1.length()){
						seq1 = StringUtils.rightPadded(seq1, seq2.length(), "-");
					}
					
					HashMap set = new HashMap();
					set.put(e1, seq1);
					set.put(e2, seq2);
					
//					System.out.println(seq1);
//					System.out.println(seq2);
					
					Vector order = new Vector();
					order.add(e1);
					order.add(e2);
					
//					System.out.println("setting sequences in the sequence viewer");
					
					try{
						structureDocument.parent.getSequenceViewer().setSequences(set, order);
					}
					catch (Exception exx){
						exx.printStackTrace();
					}
//					structureDocument.parent.getSequenceViewer().setSequence(e2, dump[1], true);
				}
				
				
				//read the content
				BufferedReader reader = new BufferedReader(new FileReader(output));
				String liner = null;
				boolean read = false;
				
				HashMap map = new HashMap();//residue number (String) -> double[] coordinates of CA
				
				String[] numbers = new String[4];
				Vector result = new Vector();//resulting coordinates
				int j = 0;
				while ((liner = reader.readLine()) != null){
					if (liner.startsWith("REMARK Aligned")){//don't translate
						
						//read rmsd
						int p = liner.indexOf("RMSD");
						String mm = liner.substring(p);
						rmsd = mm.substring(mm.indexOf("=")+1, mm.indexOf(",")).trim();
						
						
						
						read = true;
						continue;
					}
					
					if (liner.startsWith("CONECT")){//don't translate
						break;
					}
					
					if (j == 4) break;
					
					if (read){
						//read in the record for the current CA
						if (liner.startsWith("ATOM")){//don't translate
							String number = liner.substring(22,26);
							String xs = liner.substring(30,38);
							String ys = liner.substring(38,46);
							String zs = liner.substring(46,52);
							
							try{
								double x = Double.parseDouble(xs);
								double y = Double.parseDouble(ys);
								double z = Double.parseDouble(zs);
								
								numbers[j] = number.trim();
								result.add(new double[]{ x, y, z });
								j++;
							}
							catch (NumberFormatException ex){
								System.out.println("error parsing atom record");
							}
						}
					}
				}
				
				reader.close();

				//generate the three vectors and make the corresponding vectors from the same atoms before
				//the transformation
				Vector initial = new Vector();//initial coordinates
				
				//scan through all residues in the initial structure to make sure the correct CA's are chosen
				int found = 0;//how many residues have been matched
				for (int n = 0; n < structure1.getStructureMap().getResidueCount(); n++){
					Residue r = structure1.getStructureMap().getResidue(n);
					int num = r.getResidueId();
					
//					System.out.println("r = " + r.getCompoundCode() + ", num = " + num);
					
					String Num = (new Integer(num)).toString();
					for (int k = 0; k < numbers.length; k++){
						if (Num.equals((String)numbers[k])){
							Atom ca = r.getAlphaAtom();
							if (ca == null) break;
//							System.out.println("found");
							found++;
							initial.add(ca.coordinate);
							break;
						}
					}
					
					if (found == 4) break;
						
						
				}
				
				//now get the three vectors to be used to determine the transformation matrix.
				//0 -> 1, 0 -> 2, 0 -> 3
				Vector initialVectors = new Vector();
//				System.out.println("initial size = " + initial.size());
				double[] start1 = (double[])initial.get(0);
				for (int k = 1; k < initial.size(); k++){
					double[] end = (double[])initial.get(k);
					double[] v = new double[]{ end[0] - start1[0], end[1] - start1[1], end[2] - start1[2] };
					initialVectors.add(v);
				}
				
				Vector resultVectors = new Vector();
				double[] start2 = (double[])result.get(0);
				for (int k = 1; k < result.size(); k++){
					double[] end = (double[])result.get(k);
					double[] v = new double[]{ end[0] - start2[0], end[1] - start2[1], end[2] - start2[2] };
					resultVectors.add(v);
				}
				
				//now with this set of vectors, calculate the matrix
				Location start = new Location((double[])initialVectors.get(0), Algebra.crossProduct((double[])initialVectors.get(0), 
						(double[])initialVectors.get(1)), start1);
				Location target = new Location((double[])resultVectors.get(0), Algebra.crossProduct((double[])resultVectors.get(0), 
						(double[])resultVectors.get(1)), start2);
				
				StructureMath.transformStructure(start, target, structure1);
				
				resetView();
				updateAppearance();
			}
			else{
				structureDocument.parent.displayErrorMessage("Alignment produced no results");
			}
			
			dialog.processAlignment(rmsd);
			
		}
		catch (Exception ex){
			structureDocument.parent.removeWaitScreen();
			structureDocument.parent.displayExceptionMessage("Exception aligning structures", ex);
			dialog.processAlignment("");
			return;
		}
		finally{
			if (output != null) output.delete();
			
			File n1 = new File(name1);
			n1.delete();
			
			File n2 = new File(name2);
			n2.delete();
		}
		
		structureDocument.parent.removeWaitScreen();		
		
	}
	
	/**
	 * This method transforms coordinates of the second structure to be as close in 3D as possible to the first
	 * structure. Coordinates of CA atoms are used in an iterative process. CA's included in the computation
	 * are determined from the option specified by the useAll argument. If true, the entire sequence alignment is
	 * used (all positions that have residues in both sequences), if false, then only selected positions are used.
	 * @param structure1
	 * @param structure2
	 * @param useAll
	 */
	public void superimposeStructures(Structure structure1, Structure structure2, boolean useAll){
		
		//get the set of Atoms from the sequence viewer
		//get Entry objects first
		Entry entry1 = (Entry)entries.get(structure1);
		Entry entry2 = (Entry)entries.get(structure2);
		Vector residues1 = structureDocument.parent.getSequenceViewer().getAlignedResidues(entry1);
		Vector residues2 = structureDocument.parent.getSequenceViewer().getAlignedResidues(entry2);
		
//		System.out.println("r1 = " + residues1.size() + ", r2 = " + residues2.size());

		if (residues1.size() != residues2.size()){
			structureDocument.parent.displayErrorMessage("Primary sequences of the specified structures appear to be unaligned. Please run alignment and try again");
			return;
		}
		
		Vector atoms1 = new Vector();
		Vector atoms2 = new Vector();
		
		//now form to Vectors of Atom objects that represent CA's in each alignment
		for (int i = 0; i < residues1.size(); i++){
			Residue r1 = (Residue)residues1.get(i);
			Residue r2 = (Residue)residues2.get(i);
			if (r1 == null || r2 == null) continue;
			
			if (!ProteinProperties.isAminoAcid(r1.getCompoundCode()) || !ProteinProperties.isAminoAcid(r2.getCompoundCode())){
				continue;
			}
			
			Atom atom1 = r1.getAlphaAtom();
			Atom atom2 = r2.getAlphaAtom();
			
			if (atom1 == null || atom2 == null) continue;
			
			atoms1.add(atom1);
			atoms2.add(atom2);
			
		}
		
		if (atoms1.size() != atoms2.size()){
			structureDocument.parent.displayErrorMessage("Unable to assemble alpha carbon set correctly. Please try again.");
		}
		
//		System.out.println("size = " + atoms1.size());
		
		//call a utility method to perform superposition
		StructureMath.superimpose(structure1, atoms1, structure2, atoms2);
		
		updateAppearance();
	}
	
	public HashMap getAtomToLabels(){
		return atomToLabels;
	}
	
	public HashMap getAtomToResidueLabels(){
		return atomToResidueLabels;
	}
	
	public void deleteSelectedAtoms(){
		
		Vector atoms = new Vector();
		Vector residues = new Vector();
		
		//walk through the loaded structures and check all selected items
		Vector s = getLoadedStructures();
		for (int i = 0; i < s.size(); i++){
			Structure structure = (Structure)s.get(i);
			StructureStyles styles = structure.getStructureMap().getStructureStyles();
			
			//process individual atoms and bonds
			Enumeration selectedAtoms = styles.getSelection().keys();
			while (selectedAtoms.hasMoreElements()){
				try{
					residues.add((Residue)selectedAtoms.nextElement());
				}
				catch (Exception ex){
					continue;
				}
			}
			
//			System.out.println("residues1 = " + residues1.size());
			
			//whatever is left of selectedAtoms contains actual atoms
			selectedAtoms = styles.getSelection().keys();
			while (selectedAtoms.hasMoreElements()){
				try{
					Atom a = (Atom)selectedAtoms.nextElement();
					if (residues.contains(a.structure.getStructureMap().getResidue(a)))continue;
					atoms.add(a);
				}
				catch (Exception ex){
					continue;
				}
			}
			
		}
		
		if (atoms.size() == 0 && residues.size() == 0){
			return;
		}
		

		//walk through the residues first, then finish the atoms
		for (int i = 0; i < residues.size(); i++){
			Residue r = (Residue)residues.get(i);
			r.structure.getStructureMap().getStructureStyles().deleteStructureComponent(r, true, true);
		}
		
		for (int i = 0; i < atoms.size(); i++){
			Atom a = (Atom)atoms.get(i);
			a.structure.getStructureMap().getStructureStyles().deleteStructureComponent(a, true, true);
		}

		structureDocument.parent.updateView();
		
	}
	
	public void selectAtomSet(String input){
		
		Vector atomset = (Vector)atomSets.get(input);
		
		if (atomset == null) return;
		
		//since atom sets can contain both residues and atoms, process it to make sure we have a uniform Atom list
		Vector list = new Vector();
		for (int i = 0; i < atomset.size(); i++){
			try{
				Atom a = (Atom)atomset.get(i);
				list.add(a);
			}
			catch (ClassCastException ex){
				Residue r = (Residue)atomset.get(i);
				for (int j = 0; j < r.getAtomCount(); j++){
					Atom aa = r.getAtom(j);
					list.add(aa);
				}
			}
		}

		
		for (int j = 0; j < this.getLoadedStructures().size(); j++){
			Structure structure = (Structure)this.getLoadedStructures().get(j);
			StructureStyles styles = structure.getStructureMap().getStructureStyles();
			
			if (StylesPreferences.selectionMode != StylesPreferences.SELECTION_ADD){
				styles.selectNone(true, false);
			}
			
			StructureMap map = structure.getStructureMap();
			
			//first, run over residues and if a residue ends up completely selected,
			//fire a residue selection event. if any atoms are left over, select
			//them individually
			HashMap done = new HashMap();//atoms already selected through their residues
			for (int i = 0; i < map.getResidueCount(); i++){
				Residue r = map.getResidue(i);
				boolean selected = true;
				for (int k = 0; k < r.getAtomCount(); k++){
					Atom a = r.getAtom(k);
					if (!list.contains(a)){
						selected = false;
						break;
					}
				}
				
				if (selected){
					//select the entire residue and remove the corresponding atoms from the list
					styles.setSelected(r, true, true, true);
					for (int k = 0; k < r.getAtomCount(); k++){
						done.put(r.getAtom(k), null);
					}
				}
			}
			
			for (int i = 0; i < map.getAtomCount(); i++){
				Atom a = map.getAtom(i);
				if (done.containsKey(a)) continue;
				if (list.contains(a)){
					styles.setSelected(a, true, true, true);
				}
			}
		}
		
		structureDocument.parent.updateView();
	}
	
	public void selectAtomSet(){
		
		if (atomSetNames == null || atomSetNames.size() == 0){
			structureDocument.parent.displayErrorMessage("No atom sets are defined");
			return;
		}
		
		//display a dialog box with available choices
		String[] choices = new String[atomSetNames.size()];
		for (int i = 0; i < atomSetNames.size(); i++){
			choices[i] = (String)atomSetNames.get(i);
		}
		
		String input = (String)JOptionPane.showInputDialog(structureDocument.parent.getApplicationFrame(), "Please select the atom set", 
				"Defined atom sets", JOptionPane.INFORMATION_MESSAGE, null, choices, (String)atomSetNames.get(0));

		if (input == null) return;
		
		selectAtomSet(input);
	}
	
	/**
	 * this method places camera at 15 A from the specified atom and focus view on it
	 * @param atom
	 */
	public void focusView(Atom atom){
		
		double[] lookAtVector = geometryViewer.getLookAt();
		double[] center = atom.coordinate;
		
		double[] direction = new double[3];
		direction[0] = -lookAtVector[0];
		direction[1] = -lookAtVector[1];
		direction[2] = -lookAtVector[2];
		
		//check for fog back pplane position
		float d = geometryViewer.getFogFar() - 2;//maximum allowed distance from the camera
		
		double[] target = StructureMath.getPointOnVector(center, direction, 20.0);
		//check the current distance: target (eye position) and center
		double distance = Algebra.distance(target, center);
		
		if (distance > d){
			//recalculate target to be at d angstroms from center
			target = StructureMath.getPointOnVector(center, direction, d);
		}
		
		geometryViewer.lookAt(target, center);
		geometryViewer.updateView();
	}
	
	public void addRibbon(Chain chain, int ribbonType, float ribbonQuality, float ribbonDiameter, boolean update){
		
		Structure structure = chain.structure;
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector rr = (Vector)renderables.get(structure);
		StructureStyles styles = structure.getStructureMap().getStructureStyles();


		styles.setRibbonType(chain, ribbonType);
		styles.setRibbonQuality(chain, ribbonQuality);
		styles.setRibbonDiameter(chain, ribbonDiameter);
		styles.setRibbonVisible(chain, true, false, false);
		
		/////A hack to get rid of inter-chain ribbon fragments
		//mark all residues that should not
		
		Residue lastResidue = null;
		for (int i = 0; i < chain.getResidueCount(); i++){
			Residue res = chain.getResidue(i);
			
			try{
				if (res.getClassification().equals(Residue.COMPOUND_AMINO_ACID) ||
						res.getClassification().equals(Residue.COMPOUND_NUCLEIC_ACID)){
					//check the distance
					if (lastResidue != null){
						if (Algebra.distance(lastResidue.getAlphaAtom().coordinate, res.getAlphaAtom().coordinate) > 5){
							lastResidue.ribbon = false;//to avoid long ribbon fragments
							res.ribbon = false;
						}
						else{
							res.ribbon = true;
						}
					}
					else{
						res.ribbon = true;
					}
				}
				else{
					lastResidue.ribbon = false;
					res.ribbon = false;
				}
			}
			catch (Exception e){
//				e.printStackTrace();
				res.ribbon = false;
			}
			lastResidue = res;
		}
		
//		System.out.println("creating ribbon for " + chain.getChainId());
		MbtRenderable r = new MbtRenderable( chain, structure.getStructureMap().getStructureStyles(), 
				new ChainGeometry());
				
		//now check whether this chain is being moved independently
		if (independentGroup != null){
			//check the independent components
			Vector residues = new Vector();
			for (int j = 0; j < independentComponents.size(); j++){
				try{
					Residue res = (Residue)independentComponents.get(j);
					if (!residues.contains(res)) residues.add(res);
				}
				catch (ClassCastException ex){}
			}
			
			//check whether movable residue count in the chain is the same as the total residue count
			int count = 0;
			for (int j = 0; j < structure.getStructureMap().getChildren(chain).size(); j++){
				Fragment f = (Fragment)structure.getStructureMap().getChildren(chain).get(j);
				count += f.structure.getStructureMap().getChildren(f).size();
			}

			if (count == residues.size()){
				independentGroup.addChild(r);
			}
			else{
				rr.add(r);
				renderablesList.add(r);
			}
		}
		else{
			rr.add(r);
			renderablesList.add(r);
		}
		structureHash.put(chain, r);
		
		if (update){
			geometryViewer.setRenderables(renderablesList);
			geometryViewer.updateView();
		}
		
//		System.out.println("out status = " + r.status);

	}
	
	public void removeRibbon(Chain chain, boolean update){
		
		Structure structure = chain.structure;
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector rr = (Vector)renderables.get(structure);

		if (!structureHash.containsKey(chain)) return;
		GlRenderable r = (GlRenderable)structureHash.get(chain);
		if (independentGroup != null && independentGroup.containsChild(r)){
			independentGroup.removeChild(r);
		}
		else{
			rr.remove(r);
			renderablesList.remove(r);
		}
		
		for (int i = 0; i < chain.getResidueCount(); i++){
			Residue res = chain.getResidue(i);
			if (res.getClassification().equals(Residue.COMPOUND_AMINO_ACID) ||
					res.getClassification().equals(Residue.COMPOUND_NUCLEIC_ACID)){
				res.ribbon = false;
			}
		}
		
		structureHash.remove(chain);
		selectedChains.remove(chain);
		structure.getStructureMap().getStructureStyles().clearRibbon(chain);
		structure.getStructureMap().getStructureStyles().setRibbonVisible(chain, false, false, false);

		if (update){
			geometryViewer.setRenderables(renderablesList);
			geometryViewer.updateView();
		}
	}
	
	public void colorRibbon(Chain chain, int colorType, Color rColor){
		
		RibbonColor ribbonColor = null;
		ResidueColor residueColor = null;//in case common coloring is requested
		
		if (colorType == RibbonColorDialog.COLOR_CUSTOM){
			Color structureColor = rColor;
			ribbonColor = RibbonColorFactory.getRibbonColor(structureColor);
			residueColor = ResidueColorFactory.getResidueColor(structureColor);
		}
		else{
			//color by default
			ribbonColor = RibbonColorDefault.create();
			residueColor = ResidueColorByElement.create();
		}
						
		if (chain == null) return;
		
		Structure structure = chain.structure;
		StructureMap structureMap = chain.structure.getStructureMap();
		Hashtable structureHash = (Hashtable)objectHash.get(chain.structure);
		
		StructureStyles structureStyles = structureMap.getStructureStyles();
		
		if (StylesPreferences.commonRibbonColoring){
			structureStyles.setSelected(chain, false, false, true);
		}
		else{
			structureStyles.setSelected(chain, false, true, true);
		}
		
		//take care of the styles
		for (int i = 0; i < chain.getResidueCount(); i++){
			Residue r = chain.getResidue(i);
			structureStyles.setRibbonColor(r, ribbonColor, false, true);
			if (StylesPreferences.commonRibbonColoring){
				structureStyles.setResidueColor(r, residueColor, true, true);
			}
		}
		
		structureStyles.updateChain(chain, true);
		
		structureDocument.parent.updateView();


	}
	
	private void createStructureRenderables(Structure structure){
		
//		System.out.println("createRenderables called");
		
		StructureMap structureMap = structure.getStructureMap();
		StructureStyles structureStyles = structureMap.getStructureStyles();
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector localRenderables = (Vector)renderables.get(structure);
		if (localRenderables == null) localRenderables = new Vector();
		
		int total = structureMap.getBondCount();
		
		if (StylesPreferences.structureView != StylesPreferences.RENDERING_LINES){
			total += structureMap.getAtomCount();
		}
		
//		System.out.println("total = " + total);
		
		int counter = 0;
		int onePercent = Math.round(total/100);
		if (onePercent == 0) onePercent = 1;
		
		if (StylesPreferences.structureView != StylesPreferences.RENDERING_LINES){
			int atomCount = structureMap.getAtomCount( );
			
			try{
				if (StylesPreferences.structureView != StylesPreferences.RENDERING_RIBBON){
					
					AtomGeometry atomGeometry = (AtomGeometry)defaultGeometry.get("AtomGeometry");//don't translate
					for ( int atomIndex=0; atomIndex<atomCount; atomIndex++ )
					{
						Atom atom = structureMap.getAtom( atomIndex );
//						System.out.println("Existing atom.render = " + atom.render);
						
						if (atom.compound.equals("HOH") && !StylesPreferences.showBoundWaters) continue;
						
		
						//
						// Atom Geometry
						//
						
						if (!structureHash.containsKey(atom)){
							
//							System.out.println("Creating atom");
							
							MbtRenderable renderable = new MbtRenderable( atom, structureStyles, atomGeometry );
							atom.render = StylesPreferences.structureView;
							structureHash.put( atom, renderable );
							if (atom.visible){
								localRenderables.add(renderable);
								renderablesList.add(renderable);
							}
							else{
								hiddenComponents.put(atom, renderable);
							}
							
							Vector bonds = atom.structure.getStructureMap().getBonds(atom);
							if (StylesPreferences.structureView == StylesPreferences.RENDERING_BALL_STICK){
								if (bonds != null){
									for (int i = 1; i < bonds.size(); i++){
										structureStyles.setBondRadius((Bond)bonds.get(i), BondRadiusAsStick.create());
									}
								}
	
								if (StylesPreferences.ballRadiusOption == StylesPreferences.ATOMIC_RADIUS){
									structureStyles.setAtomRadius(atom, AtomRadiusRegistry.get(AtomRadiusByScaledCpk.NAME));
								}
								else{
									AtomRadiusByConstant r = (AtomRadiusByConstant)AtomRadiusRegistry.get(AtomRadiusByConstant.NAME);
									r.setRadius(StylesPreferences.ballRadius*StylesPreferences.atomRadiusScale);
									structureStyles.setAtomRadius(atom, r);
								}
							}
							else if (StylesPreferences.structureView == StylesPreferences.RENDERING_STICK){
								AtomRadiusByConstant r = (AtomRadiusByConstant)AtomRadiusRegistry.get(AtomRadiusByConstant.NAME);
								r.setRadius(StylesPreferences.stickSize);
								structureStyles.setAtomRadius(atom, r);
							}
							else if (StylesPreferences.structureView == StylesPreferences.RENDERING_CPK){
								
	//							structureStyles.setRenderingStyle(atom, StylesPreferences.RENDERING_CPK, quality, true);
								Vector bbb = atom.structure.getStructureMap().getBonds(atom);
								if (bbb != null){
									for (int i = 1; i < bbb.size(); i++){
										structureStyles.setBondRadius((Bond)bbb.get(i), BondRadiusAsStick.create());
									}
								}
								structureStyles.setAtomRadius(atom, AtomRadiusRegistry.get(AtomRadiusByCpk.NAME));
	
							}
	
						}
						
						counter++;
						
						if (counter % onePercent == 0){
							float result = (float) counter / (float) total;
							Status.progress( result, "Loading geometry" );

						}
						
//						System.out.println("ending atom.render = " + atom.render);

					}
				}
			}
			catch (OutOfMemoryError e){
				System.err.println("Ran out of memory while loading structure");
			}
		}
		
		
		//Bonds
		int bondCount = structureMap.getBondCount( );

		BondGeometry bondGeometry = (BondGeometry)defaultGeometry.get("BondGeometry");//don't translate
		for ( int bondIndex=0; bondIndex<bondCount; bondIndex++ )
		{
			if (StylesPreferences.structureView != StylesPreferences.RENDERING_CPK){
				
				Bond bond = structureMap.getBond( bondIndex );
//				System.out.println("structureView = " + StylesPreferences.structureView);
				
				bond.quality = (short)StylesPreferences.startupRenderingQuality;
				
//				System.out.println("bond.render = " + bond.render);
				
				if (!structureHash.containsKey(bond)){
					MbtRenderable m = new MbtRenderable( bond, structureStyles, bondGeometry );
					structureHash.put(bond, m);
					bond.render = (short)StylesPreferences.structureView;
					if (bond.visible){
						localRenderables.add(m);
						renderablesList.add(m);
					}
					else{
						hiddenComponents.put(bond, m);
					}

					if (StylesPreferences.structureView == StylesPreferences.RENDERING_STICK){
						structureStyles.setBondRadius(bond, BondRadiusByAtomRadius.create());
					}
					else if (StylesPreferences.structureView == StylesPreferences.RENDERING_BALL_STICK){
						structureStyles.setBondRadius(bond, BondRadiusAsStick.create());
					}
				}
				
				counter++;
				
//				System.out.println("counter = " + counter);
				if (counter % onePercent == 0){
					float result = (float) counter / (float) total;
					Status.progress( result, "Loading geometry" );

				}

			}
		}
				
		this.checkDummyAtoms(structure, false);
		
		Status.progress( 1.0f, null );

		
		if (StylesPreferences.renderingMode != StylesPreferences.RENDERING_LINES){
			structureStyles.setRenderingStyle(StylesPreferences.renderingMode, StylesPreferences.startupRenderingQuality);
		}
	}
	
	private void createAtomRenderable(Atom atom){
		
		StructureMap structureMap = atom.structure.getStructureMap();
		StructureStyles structureStyles = structureMap.getStructureStyles();
		Hashtable structureHash = (Hashtable)objectHash.get(atom.structure);
		Vector localRenderables = (Vector)renderables.get(atom.structure);
		if (localRenderables == null) localRenderables = new Vector();
		
		if (StylesPreferences.renderingMode != StylesPreferences.RENDERING_LINES){

			AtomGeometry atomGeometry = (AtomGeometry)defaultGeometry.get("AtomGeometry");//don't translate
			
//			if (atom.compound.equals("HOH") && !StylesPreferences.showBoundWaters) return;

			if (!structureHash.containsKey(atom)){
				MbtRenderable renderable = new MbtRenderable( atom, structureStyles, atomGeometry );
				structureHash.put( atom, renderable );
				if (atom.visible){
					localRenderables.add(renderable);
					renderablesList.add(renderable);
				}
				else{
					hiddenComponents.put(atom, renderable);
				}
				
				Vector bonds = atom.structure.getStructureMap().getBonds(atom);
				if (StylesPreferences.structureView == StylesPreferences.RENDERING_BALL_STICK){
					if (bonds != null){
						for (int i = 1; i < bonds.size(); i++){
							structureStyles.setBondRadius((Bond)bonds.get(i), BondRadiusAsStick.create());
						}
					}

					if (StylesPreferences.ballRadiusOption == StylesPreferences.ATOMIC_RADIUS){
						structureStyles.setAtomRadius(atom, AtomRadiusRegistry.get(AtomRadiusByScaledCpk.NAME));
					}
					else{
						AtomRadiusByConstant r = (AtomRadiusByConstant)AtomRadiusRegistry.get(AtomRadiusByConstant.NAME);
						r.setRadius(StylesPreferences.ballRadius*StylesPreferences.atomRadiusScale);
						structureStyles.setAtomRadius(atom, r);
					}
				}
				else if (StylesPreferences.structureView == StylesPreferences.RENDERING_STICK){
					AtomRadiusByConstant r = (AtomRadiusByConstant)AtomRadiusRegistry.get(AtomRadiusByConstant.NAME);
					r.setRadius(StylesPreferences.stickSize);
					structureStyles.setAtomRadius(atom, r);
				}
				else if (StylesPreferences.structureView == StylesPreferences.RENDERING_CPK){
					
					Vector bbb = atom.structure.getStructureMap().getBonds(atom);
					if (bbb != null){
						for (int i = 1; i < bbb.size(); i++){
							structureStyles.setBondRadius((Bond)bbb.get(i), BondRadiusAsStick.create());
						}
					}
					structureStyles.setAtomRadius(atom, AtomRadiusRegistry.get(AtomRadiusByCpk.NAME));

				}

			}
		}

		
		
	}
	
	public void createSurface(){
		Structure structure = (Structure)this.getLoadedStructures().get(0);
		if (structure == null) return;
		
		boolean arrows = false;
		
		if (arrows){
			SurfaceComponent surface = new SurfaceComponent(structure.getStructureMap().getAtoms(), null, StylesPreferences.SURFACE_QUALITY_MEDIUM, true);
			HashMap points = surface.getPoints();
			
			for (int i = 0; i < structure.getStructureMap().getAtomCount(); i++){
				Atom a = structure.getStructureMap().getAtom(i);
				Vector p = (Vector)points.get(a);
				if (p == null) continue;
				
				for (int j = 0; j < p.size(); j++){
					double[] data = (double[])p.get(j);
					double[] point = new double[]{ data[0], data[1], data[2] };
					double[] normal = new double[]{ data[3], data[4], data[5] };
					
					double[] target = new double[]{ point[0] + normal[0], point[1] + normal[1], point[2] + normal[2] };
					
					//create an arrow
					MonitorRenderable r = new MonitorRenderable(new ArrowComponent(point, target, 0.05, null),
							(AnnotationGeometry)defaultGeometry.get("ArrowGeometry"));//don't translate
					
					renderablesList.add(r);
					
				}
			}
		}
		else{
			MbtRenderable r = new MbtRenderable(new SurfaceComponent(structure.getStructureMap().getAtoms(), null, StylesPreferences.SURFACE_QUALITY_MEDIUM, true),
					structure.getStructureMap().getStructureStyles(), (SurfaceGeometry)defaultGeometry.get("SurfaceGeometry"));//don't translate
			
			renderablesList.add(r);
		}
	
		geometryViewer.updateView();
	}
	
	public void createSurface(StructureComponent comp, String l, int sf, int tf, int qf, boolean iso){
		
		final StructureComponent component = comp;
		final int setFlag = sf;
		final String label = l;
		final int typeFlag = tf;
		final int qualityFlag = qf;
		final boolean isolated = iso;
		
		Thread runner = new Thread(){
			public void run(){
				//first, determine what set of atoms the surface should be applied to
				Atom atom = null;
				try{
					atom = (Atom)component;
				}
				catch (ClassCastException e){}
				
				if (setFlag != DialogConstants.APPLY_SELECTION){
					if (label.equals("") && atom == null){
						return;
					}
				}
				
				Vector atoms = new Vector();//atoms to be covered by the surface
				
				Structure check = null;
				if (atomSetNames.contains(label)){
					//a set has been selected
					
					Vector atomSet = (Vector)atomSets.get(label);
					for (int i = 0; i < atomSet.size(); i++){
						try{
							Residue r = (Residue)atomSet.get(i);
							if (check == null) check = r.structure;
							
							if (r.structure != check){
								structureDocument.parent.displayErrorMessage("Surface cannot span multiple structures.");
								return;
							}
							for (int j = 0; j < r.getAtomCount(); j++){
								atoms.add(r.getAtom(j));
							}
						}
						catch (ClassCastException e){
							Atom a = (Atom)atomSet.get(i);
							if (check == null) check = a.structure;
							if (a.structure != check){
								structureDocument.parent.displayErrorMessage("Surface cannot span multiple structures.");
								return;
							}
							atoms.add(atomSet.get(i));
						}
					}
				}
				else{

					if (setFlag == DialogConstants.APPLY_ATOM){
						//get atom object out of the label
						if (atom == null){
							atom = (Atom)(labelToObject(label));
						}
						
						if (atom == null){
							return;
						}
						atoms.add(atom);
					}
					else if (setFlag == DialogConstants.APPLY_RESIDUE){
						Residue residue = null;
						if (atom == null){
							try{
								int index = label.lastIndexOf(":");
								String newLabel = label.substring(0, index);
							
								residue = (Residue)(labelToObject(newLabel));
							}
							catch (ClassCastException ex){
								//happens when the labels ends with the residue record
								residue = (Residue)(labelToObject(label));
							}
						}
						else{
							residue = atom.structure.getStructureMap().getResidue(atom);
						}
						
						if (residue == null) return;
						
						for (int j = 0; j < residue.getAtomCount(); j++){
							atoms.add(residue.getAtom(j));
						}
					}
					else if (setFlag == DialogConstants.APPLY_CHAIN){
						Chain chain = null;
						
						if (component.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
							chain = (Chain)component;
						}
						else{
							if (atom == null){
								try{
									int index = label.lastIndexOf(":");
									String newLabel = label.substring(0, index);
									int index2 = newLabel.lastIndexOf(":");
								
									chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
								}
								catch (ClassCastException ex){
									//happens when the labels ends with the residue record
									chain = (Chain)(labelToObject(label));
								}
							}
							else{
								chain = atom.structure.getStructureMap().getChain(atom);
							}
						}
						
						if (chain == null) return;
						for (int i = 0; i < chain.getResidueCount(); i++){
							Residue r = chain.getResidue(i);
							for (int j = 0; j < r.getAtomCount(); j++){
								atoms.add(r.getAtom(j));
							}
						}
			
					}
					else if (setFlag == DialogConstants.APPLY_STRUCTURE){
						Structure structure = null;
						if (atom == null){
							//no matter what information is contained in the label, pick only the first fragment
							int index = label.indexOf(":");
							
							String newLabel = "";
							if (index == -1){
								newLabel = label;
							}
							else{
								newLabel = label.substring(0,index);
							}
							
							try{
								structure = (Structure)(labelToObject(newLabel));
							}
							catch (ClassCastException ex){
								return;
							}
						}
						else{
							structure = atom.structure;
						}
						
						if (structure == null){
							return;
						}
						
						for (int i = 0; i < structure.getStructureMap().getAtomCount(); i++){
							atoms.add(structure.getStructureMap().getAtom(i));
						}
					}
					else if (setFlag == DialogConstants.APPLY_SELECTION){
						
						//walk through the loaded structures and check all selected items
						Vector s = getLoadedStructures();
						for (int i = 0; i < s.size(); i++){
							Structure structure = (Structure)s.get(i);
							StructureStyles styles = structure.getStructureMap().getStructureStyles();
							
							Vector res = new Vector();
							Enumeration selectedAtoms = styles.getSelection().keys();

							while (selectedAtoms.hasMoreElements()){
								try{
									Residue r = (Residue)selectedAtoms.nextElement();
									if (check == null) check = r.structure;
									if (r.structure != check){
										structureDocument.parent.displayErrorMessage("Surface cannot span multiple structures");
										return;
									}
									for (int j = 0; j < r.getAtomCount(); j++){
										atoms.add(r.getAtom(j));
									}
									res.add(r);
								}
								catch (Exception ex){
									continue;
								}
							}
							
							selectedAtoms = styles.getSelection().keys();
							while (selectedAtoms.hasMoreElements()){
								try{
									Atom a = (Atom)selectedAtoms.nextElement();
									if (check == null) check = a.structure;
									if (a.structure != check){
										structureDocument.parent.displayErrorMessage("Surface cannot span multiple structures.");
										return;
									}
									if (res.contains(a.residue)) continue;
									atoms.add(a);
								}
								catch (Exception ex){
									continue;
								}
							}
						}
						
					}
				}
				
				createSurface(atoms, qualityFlag, isolated);

			}
		};
		runner.start();
	}
	
	public void createSurface(Vector atoms, int quality, boolean isolated){
		
		if (atoms.size() == 0){
			structureDocument.parent.displayErrorMessage("No atoms in the set for surface generation");
			return;
		}
		
		Structure structure = ((Atom)atoms.get(0)).structure;

		
		//check whether there are already surfaces that cover this set of atoms
		for (int i = 0; i < surfaceObjects.size(); i++){
			SurfaceComponent sc = (SurfaceComponent)surfaceObjects.get(i);
			if (sc.structure != structure) continue;//different structures - clearly a different surface
			
			Vector aa = sc.getAtoms();
			
			//scan the new atom set to determine whether it's really only a subset of the existing one
			boolean overlap = true;
			for (int j = 0; j < atoms.size(); j++){
				if (!aa.contains(atoms.get(j))){
					overlap = false;
					break;
				}
			}
			
			if (overlap){
				structureDocument.parent.displayErrorMessage("A surface spanning the selected set of atoms already exists");
				return;
			}
		}
		
		
		//atoms should now have the entire set that should be surfaced
		
		
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		Vector rr = (Vector)renderables.get(structure);
		
		SurfaceComponent sc = new SurfaceComponent(atoms, structure, quality, isolated);
		MbtRenderable r = new MbtRenderable(sc,	structure.getStructureMap().getStructureStyles(), 
				(SurfaceGeometry)defaultGeometry.get("SurfaceGeometry"));//don't translate
		
		renderablesList.add(r);
		rr.add(r);
		structureHash.put(sc, r);
		
		surfaceObjects.add(sc);
			
		geometryViewer.updateView();
		
		
		
		
	}
	
	public void deleteSurfaces(boolean update){
		
		for (int i = 0; i < surfaceObjects.size(); i++){
			SurfaceComponent comp = (SurfaceComponent)surfaceObjects.get(i);
			deleteSurface(comp, update);
		}
	}
	
	public void deleteSurface(SurfaceComponent sc, boolean update){
		
		if (sc == null) return;
		if (!surfaceObjects.contains(sc)) return;
		
		Structure structure = sc.structure;
		Vector rr = (Vector)renderables.get(structure);
		Hashtable structureHash = (Hashtable)objectHash.get(structure);
		
		MbtRenderable sr = (MbtRenderable)structureHash.get(sc);
		
		rr.remove(sr);
		renderablesList.remove(sr);
		if (independentGroup != null){
			independentGroup.removeChild(sr);
		}
		
		if (rotationGroup != null){
			rotationGroup.removeChild(sr);
		}
		
		surfaceObjects.remove(sc);
		structureHash.remove(sc);
		
		removeRenderable(sr);
		
		//deselect all atoms in this surface
		Vector atoms = sc.getAtoms();
		for (int i = 0; i < atoms.size(); i++){
			structure.getStructureMap().getStructureStyles().setSelected((Atom)atoms.get(i), false, true, true);
		}
		
		if (update) geometryViewer.updateView();
	}

	public Vector getSurfaceObjects(){
		return surfaceObjects;
	}
	
	public Hashtable getObjectHash(){
		return objectHash;
	}
	
	public void setSelectedChains(Vector chains){
		selectedChains.clear();
		
		for (int i = 0; i < chains.size(); i++){
			selectedChains.add(chains.get(i));
		}
	}
	
	public void setSelectedChain(Chain chain){
		selectedChains.clear();
		selectedChains.add(chain);
		
	}

	public Vector getSelectedChains(){
		return selectedChains;
	}
	
	public void setVisibilityInSelection(int action){
		
//		repaintMonitors = false;
		Vector s = getLoadedStructures();
		for (int i = 0; i < s.size(); i++){
			Structure structure = (Structure)s.get(i);
			StructureStyles styles = structure.getStructureMap().getStructureStyles();
			
			//check special cases
			int flag = styles.getSelectionFlag();
			if (flag == StructureStyles.FLAG_NONE){
				//nothing selected here, but hide the structure if show-only is chosen
				if (action == VisibilityDialog.VIS_SHOW_ONLY){
					styles.hideAll(true);
				}
				continue;
			}
			else if (flag == StructureStyles.FLAG_ALL){
				//the entire structure is selected
				if (action == VisibilityDialog.VIS_HIDE){
					styles.hideAll(true);
				}
				else if (action == VisibilityDialog.VIS_SHOW){
					styles.showAll(true);
				}
				else if (action == VisibilityDialog.VIS_SHOW_ONLY){
					//other structures are hidden if they are not selected
					styles.showAll(true);
				}
				continue;
			}
			
			stopCheckDummyAtoms = true;
			//since no wholesale flags are hit, process individual atoms and bonds
			Enumeration selectedAtoms = styles.getSelection().keys();
			
			//in case it's a show only, hide everything, and then process
			//selection as show
			if (action == VisibilityDialog.VIS_SHOW_ONLY){
				styles.hideAll(true);
			}
			
			Vector residues = new Vector();
			//run residues first, then leftover atoms
			while (selectedAtoms.hasMoreElements()){
				try{
					Residue r = (Residue)selectedAtoms.nextElement();
					if (styles.isSelected(r)){
						if (action == VisibilityDialog.VIS_HIDE){
							styles.setVisible(r, false, true, true);
						}
						else{
							styles.setVisible(r, true, true, true);
						}
					}
					residues.add(r);
				}
				catch (Exception ex){
					continue;
				}
			}
			
			//run through the lone atoms
			selectedAtoms = styles.getSelection().keys();
			while (selectedAtoms.hasMoreElements()){
				try{
					
					Atom a = (Atom)selectedAtoms.nextElement();
					if (residues.contains(a.structure.getStructureMap().getResidue(a))) continue;
					if (styles.isSelected(a)){
						if (action == VisibilityDialog.VIS_HIDE){
							styles.setVisible(a, false, true, true);
						}
						else{
							styles.setVisible(a, true, true, true);
						}
					}
				}
				catch (ClassCastException ex){}
			}
			
			stopCheckDummyAtoms = false;
			checkDummyAtomsSelection(styles);
		}
		
		if (repaintMonitors){
			MonitorDialog md = structureDocument.parent.getMonitorDialog();
			if (md != null) md.repaintTree();
		}

	}

	public void setRibbonInSelection(boolean status, int ribbonType, float ribbonDiameter, float ribbonQuality){
		
		Vector s = getLoadedStructures();
		for (int i = 0; i < s.size(); i++){
			Structure ss = (Structure)s.get(i);
			StructureMap map = ss.getStructureMap();
			StructureStyles styles = map.getStructureStyles();
			
			Vector selection = new Vector();//chains
			
			for (int j = 0; j < map.getChainCount(); j++){
				Chain ch = map.getChain(j);
				
				for (int m = 0; m < ch.getResidueCount(); m++){
					Residue res = ch.getResidue(m);
					if (res.getClassification().equals(Residue.COMPOUND_AMINO_ACID)){
						if (styles.isSelected(res)){
							res.ribbon = status;
							if (!selection.contains(ch)) selection.add(ch);
						}
						else{
							boolean sel = true;
							for (int k = 0; k < res.getAtomCount(); k++){
								Atom a = res.getAtom(k);
								if (a.backbone){
									if (!styles.isSelected(a)){
										sel = false;
										break;
									}
								}
							}
							
							if (sel){
								res.ribbon = status;
								if (!selection.contains(ch)) selection.add(ch);
							}
						}
						
					}
					else if (res.getClassification().equals(Residue.COMPOUND_NUCLEIC_ACID)){
						if (styles.isSelected(res)){
							res.ribbon = status;
							if (!selection.contains(ch)) selection.add(ch);
						}
						else{
							boolean sel = true;
							for (int k = 0; k < res.getAtomCount(); k++){
								Atom a = res.getAtom(k);
								if (a.backbone){
									if (!styles.isSelected(a)){
										sel = false;
										break;
									}
								}
							}
							
							if (sel){
								res.ribbon = status;
								if (!selection.contains(ch)) selection.add(ch);
							}
							
						}
					}

				}
				
			}
			
			Hashtable structureHash = (Hashtable)objectHash.get(ss);
			Vector rr = (Vector)renderables.get(ss);
			
			//ribbon gets completely removed only if no residues are shown						
			
			for (int j = 0 ; j < selection.size(); j++){
				Chain chain = (Chain)selection.get(j);
				
				boolean delete = true;
				for (int k = 0; k < chain.getResidueCount(); k++){
					Residue res = chain.getResidue(k);
					if (res.ribbon){
						delete = false;
						break;
					}
				}
				
				//if ribbon is kept but the event was "hide", keep the old styles
				if (!delete){
				
					//show a ribbon
					if (structureHash.containsKey(chain)){
						
						//check whether the ribbon is hidden
						if (hiddenComponents.containsKey(chain)){
							rr.add(structureHash.get(chain));
							renderablesList.add(structureHash.get(chain));
							hiddenComponents.remove(chain);
						}
						
						if (status){
							styles.setRibbonType(chain, ribbonType);
							styles.setRibbonQuality(chain, ribbonQuality);
							styles.setRibbonDiameter(chain, ribbonDiameter);
						}
						GlRenderable r = (GlRenderable)structureHash.get(chain);
						r.setDirty();
						
						geometryViewer.updateView();
						
						continue;
						
					}
					
//					System.out.println("viewer: ribbon type = " + ribbonType);
					
					styles.setRibbonType(chain, ribbonType);
					styles.setRibbonQuality(chain, ribbonQuality);
					styles.setRibbonDiameter(chain, ribbonDiameter);
					styles.setRibbonVisible(chain, true, false, false);

					MbtRenderable r = new MbtRenderable( chain, styles, new ChainGeometry());
					
					
					//now check whether this chain is being moved independently
					if (independentGroup != null){
						//check the independent components
						Vector residues = new Vector();
						for (int k = 0; k < independentComponents.size(); k++){
							try{
								Residue res = (Residue)independentComponents.get(k);
								if (!residues.contains(res)) residues.add(res);
							}
							catch (ClassCastException ex){}
						}
						
						//check whether movable residue count in the chain is the same as the total residue count
						int count = 0;
						for (int k = 0; k < map.getChildren(chain).size(); k++){
							Fragment f = (Fragment)map.getChildren(chain).get(k);
							count += f.structure.getStructureMap().getChildren(f).size();
						}

						if (count == residues.size()){
							independentGroup.addChild(r);
						}
						else{
							rr.add(r);
							renderablesList.add(r);
						}
					}
					else{
						rr.add(r);
						renderablesList.add(r);
					}
					
					structureHash.put(chain, r);
				}
				else{
					//remove the ribbon - move to hiddenComponents
					if (!structureHash.containsKey(chain)) return;
					GlRenderable r = (GlRenderable)structureHash.get(chain);
					
					//hide it
					hiddenComponents.put(chain, r);
					renderablesList.remove(r);
					rr.remove(r);
					
					
					if (independentGroup != null && independentGroup.containsChild(r)){
						independentGroup.removeChild(r);
					}
					else{
						rr.remove(r);
						renderablesList.remove(r);
					}
					styles.setRibbonVisible(chain, false, false, false);
				}
			}
			
			for (int j = 0; j < ss.getStructureMap().getChainCount(); j++){
				ss.getStructureMap().getStructureStyles().updateChain(ss.getStructureMap().getChain(j), true);
			}
		}
		
		

	}
	
	public void setRibbonInVisible(boolean status, int ribbonType, float ribbonDiameter, float ribbonQuality){
		
		Vector s = getLoadedStructures();
		for (int i = 0; i < s.size(); i++){
			Structure ss = (Structure)s.get(i);
			StructureMap map = ss.getStructureMap();
			StructureStyles styles = map.getStructureStyles();
			
			Vector selection = new Vector();//chains
			
			for (int j = 0; j < map.getChainCount(); j++){
				Chain ch = map.getChain(j);
				
				for (int m = 0; m < ch.getResidueCount(); m++){
					Residue res = ch.getResidue(m);
					if (res.ribbon){
						if (!selection.contains(ch)) selection.add(ch);
					}
				}
				
			}
			
//			System.out.println("selection = " + selection.size());
			
			Hashtable structureHash = (Hashtable)objectHash.get(ss);
			Vector rr = (Vector)renderables.get(ss);
			
			//ribbon gets completely removed only if no residues are shown						
			
			for (int j = 0 ; j < selection.size(); j++){
				Chain chain = (Chain)selection.get(j);
				
				boolean delete = true;
				for (int k = 0; k < chain.getResidueCount(); k++){
					Residue res = chain.getResidue(k);
					if (res.ribbon){
						delete = false;
						break;
					}
				}
				
				//if ribbon is kept but the event was "hide", keep the old styles
				
				
				if (!delete){
				
					//show a ribbon
					if (structureHash.containsKey(chain)){
						
						//check whether the ribbon is hidden
						if (hiddenComponents.containsKey(chain)){
							rr.add(structureHash.get(chain));
							renderablesList.add(structureHash.get(chain));
							hiddenComponents.remove(chain);
						}
						
						if (status){
							styles.setRibbonType(chain, ribbonType);
							styles.setRibbonQuality(chain, ribbonQuality);
							styles.setRibbonDiameter(chain, ribbonDiameter);
						}
						GlRenderable r = (GlRenderable)structureHash.get(chain);
						r.setDirty();
						
						geometryViewer.updateView();
						
						continue;
						
					}
					
//					System.out.println("viewer: ribbon type = " + ribbonType);
					
					styles.setRibbonType(chain, ribbonType);
					styles.setRibbonQuality(chain, ribbonQuality);
					styles.setRibbonDiameter(chain, ribbonDiameter);
					styles.setRibbonVisible(chain, true, false, false);

					MbtRenderable r = new MbtRenderable( chain, styles, new ChainGeometry());
					
					
					//now check whether this chain is being moved independently
					if (independentGroup != null){
						//check the independent components
						Vector residues = new Vector();
						for (int k = 0; k < independentComponents.size(); k++){
							try{
								Residue res = (Residue)independentComponents.get(k);
								if (!residues.contains(res)) residues.add(res);
							}
							catch (ClassCastException ex){}
						}
						
						//check whether movable residue count in the chain is the same as the total residue count
						int count = 0;
						for (int k = 0; k < map.getChildren(chain).size(); k++){
							Fragment f = (Fragment)map.getChildren(chain).get(k);
							count += f.structure.getStructureMap().getChildren(f).size();
						}

						if (count == residues.size()){
							independentGroup.addChild(r);
						}
						else{
							rr.add(r);
							renderablesList.add(r);
						}
					}
					else{
						rr.add(r);
						renderablesList.add(r);
					}
					
					structureHash.put(chain, r);
				}
				else{
					//remove the ribbon - move to hiddenComponents
					if (!structureHash.containsKey(chain)) return;
					GlRenderable r = (GlRenderable)structureHash.get(chain);
					
					//hide it
					hiddenComponents.put(chain, r);
					renderablesList.remove(r);
					rr.remove(r);
					
					
					if (independentGroup != null && independentGroup.containsChild(r)){
						independentGroup.removeChild(r);
					}
					else{
						rr.remove(r);
						renderablesList.remove(r);
					}
					styles.setRibbonVisible(chain, false, false, false);
				}
			}
		}

	}
	
	private Vector getIndependentAtomSet(Atom atom, String label, int setFlag){
		
		Vector atoms = new Vector();
		
		if (atomSetNames.contains(label)){
			//a set has been selected
			
			Vector atomSet = (Vector)atomSets.get(label);
			for (int i = 0; i < atomSet.size(); i++){
				try{
					Residue r = (Residue)atomSet.get(i);
					independentComponents.add(r);
					for (int j = 0; j < r.getAtomCount(); j++){
						Atom a = r.getAtom(j);
						atoms.add(a);
					}
				}
				catch (ClassCastException e){
					atoms.add(atomSet.get(i));
					independentComponents.add(atomSet.get(i));
				}
			}
		}
		else{
		
			if (atom == null){
				Object sc = labelToObject(label);
				if (sc instanceof Structure){
					atom = ((Structure)sc).getStructureMap().getAtom(0);
				}
			}
			
			
			if (setFlag != DialogConstants.APPLY_SELECTION){
				if (atom == null){
					return null;
				}
			}
			if (setFlag == DialogConstants.APPLY_ATOM){
				//get atom object out of the label
				atoms.add(atom);
				independentComponents.add(atom);
			}
			else if (setFlag == DialogConstants.APPLY_RESIDUE){
				Residue residue = null;
				if (atom == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
					
						residue = (Residue)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						residue = (Residue)(labelToObject(label));
					}
				}
				else{
					residue = atom.structure.getStructureMap().getResidue(atom);
				}
				
				if (residue == null){
					return null;
				}
				
				independentComponents.add(residue);
				for (int i = 0; i < residue.getAtomCount(); i++){
					atoms.add(residue.getAtom(i));
				}

				
			}
			else if (setFlag == DialogConstants.APPLY_CHAIN){
				Chain chain = null;
				if (atom == null){
					try{
						int index = label.lastIndexOf(":");
						String newLabel = label.substring(0, index);
						int index2 = newLabel.lastIndexOf(":");
					
						chain = (Chain)(labelToObject(newLabel.substring(0, index2)));
					}
					catch (ClassCastException ex){
						//happens when the labels ends with the residue record
						chain = (Chain)(labelToObject(label));
					}
				}
				else{
					chain = atom.structure.getStructureMap().getChain(atom);
				}
				
				if (chain == null){
					return null;
				}
				
				StructureMap map = chain.structure.getStructureMap();
				//add chain atoms to the vector
				for (int i = 0; i < map.getAtomCount(); i++){
					Atom a = map.getAtom(i);
					if (a.chain_id.equals(chain.getChainId())){
						atoms.add(a);
					}
				}
				
				for (int i = 0; i < map.getResidueCount(); i++){
					Residue r = map.getResidue(i);
					if (r.getChainId().equals(chain.getChainId())) independentComponents.add(r);
				}
				
			}
			else if (setFlag == DialogConstants.APPLY_STRUCTURE){
				Structure structure = null;
				if (atom == null){
					//no matter what information is contained in the label, pick only the first fragment
					int index = label.indexOf(":");
					
					String newLabel = "";
					if (index == -1){
						newLabel = label;
					}
					else{
						newLabel = label.substring(0,index);
					}
					
					try{
						structure = (Structure)(labelToObject(newLabel));
					}
					catch (ClassCastException ex){
						return null;
					}
				}
				else{
					structure = atom.structure;
				}
				
				if (structure == null){
					return null;
				}
				
				for (int i = 0; i < structure.getStructureMap().getAtomCount(); i++){
					atoms.add(structure.getStructureMap().getAtom(i));
				}
				for (int i = 0; i < structure.getStructureMap().getResidueCount(); i++){
					independentComponents.add(structure.getStructureMap().getResidue(i));
				}
				
			}
			else if (setFlag == DialogConstants.APPLY_SELECTION){
				
				//walk through the loaded structures and check all selected items
				Vector s = getLoadedStructures();
				for (int i = 0; i < s.size(); i++){
					Structure structure = (Structure)s.get(i);
					StructureStyles styles = structure.getStructureMap().getStructureStyles();
					
					//process individual atoms and bonds
					Vector res = new Vector();
					Enumeration selectedAtoms = styles.getSelection().keys();
					while (selectedAtoms.hasMoreElements()){
						try{
							Residue r = (Residue)selectedAtoms.nextElement();
							independentComponents.add(r);
							res.add(r);
							for (int j = 0; j < r.getAtomCount(); j++){
								Atom a = r.getAtom(j);
								atoms.add(a);
							}
						}
						catch (ClassCastException e){
							continue;
						}
					}
					
					selectedAtoms = styles.getSelection().keys();
					while (selectedAtoms.hasMoreElements()){
						try{
							Atom a = (Atom)selectedAtoms.nextElement();
							if (res.contains(a.residue)) continue;
							atoms.add(a);
							independentComponents.add(a);
						}
						catch (ClassCastException e){
							continue;
						}
					}

				}
				
			}
		}
		
		return atoms;

	}
	
	public void saveInitialCoordinates(Structure structure){
		if (initialCoordinates.containsKey(structure)) return;
		
		HashMap map = new HashMap();
		for (int i = 0; i < structure.getStructureMap().getAtomCount(); i++){
			Atom a = structure.getStructureMap().getAtom(i);
			double[] copy = new double[]{ a.coordinate[0], a.coordinate[1], a.coordinate[2] };
			map.put(a, copy);
		}
		
		initialCoordinates.put(structure, map);
	}
	
	public void restoreInitialCoordinates(Structure structure){
		if (!initialCoordinates.containsKey(structure)) return;
		HashMap map = (HashMap)initialCoordinates.get(structure);
		
		for (int i = 0; i < structure.getStructureMap().getAtomCount(); i++){
			Atom a = structure.getStructureMap().getAtom(i);
			a.coordinate = (double[])map.get(a);
		}
		map.clear();
		initialCoordinates.remove(structure);
	}
	
	public HashMap getInitialCoordinates(Structure structure){
		return (HashMap)initialCoordinates.get(structure);
	}
	
	public Entry getEntry(Structure structure){
		return (Entry)entries.get(structure);
	}
	
	public void zoomSelection(){
		
		//the action is the same as for fit all to display, except that only
		//selected components are taken into account
		//Note: watch for ribbons with no structure
		

		
		//make sure ribbon geometry is included even if atoms are invisible
		try{
			
			
			//prepare directional vectors
			double[] up = getGeometryViewer().getUpVector();
			double[] down = Algebra.getReverseVector(up);
			double[] look = getGeometryViewer().getLookAt();
			double[] right = Algebra.crossProduct(look, up);
			Algebra.normalizeVector(right);
			double[] left = Algebra.getReverseVector(right);
			
			//maximum distances from the geometric center of display when looking from camera
			double maxUp = 0;
			double maxDown = 0;
			double maxLeft = 0;
			double maxRight = 0;
			
			Vector residues = new Vector();//residues to be included in calculation
			
			double[] center = new double[3];
			if (structures.size() > 0){
				
				for (int i = 0 ; i < structureList.size(); i++){
					Structure s = (Structure)structureList.get(i);
					StructureStyles styles = s.getStructureMap().getStructureStyles();
					for ( int j = 0; j < s.getStructureMap().getResidueCount(); j++ ){
						
						Residue res = s.getStructureMap().getResidue(j);
						boolean process = false;
						
						//check if at least one atom is selected
						boolean selected = false;
						for (int k = 0; k < res.getAtomCount(); k++){
							Atom a = res.getAtom(k);
							if (styles.isSelected(a)){
								selected = true;
								break;
							}
						}
						
						if (!selected) continue;
						
						if (!res.visible){
							if (res.getCompoundCode().equals("HOH") || res.getCompoundCode().equals("WAT")) continue;
							//check its ribbon status
							if (res.ribbon){
								//use CA as the reference
								process = true;
							}
						}
						else{
							process = true;
						}
						
						if (process){
							residues.add(res);
							
							//include this residue in the center calculation
							center[0] += res.centerAtom.coordinate[0];
							center[1] += res.centerAtom.coordinate[1];
							center[2] += res.centerAtom.coordinate[2];							
						}
					}
				}
			}
			
			if (residues.size() == 0) return;//nothing selected
			
			center[0] /= residues.size();
			center[1] /= residues.size();
			center[2] /= residues.size();
			
			for (int i = 0; i < residues.size(); i++){
				Residue res = (Residue)residues.get(i);
						
				for (int k = 0; k < res.getAtomCount(); k++){
					Atom atom = res.getAtom(k);
					//determine vector from center to the atom
					double[] direction = Algebra.getVector(center, atom.coordinate);
					
					//angle between up vector and direction
					double angle = Algebra.getAngleBetweenVectors(up, direction);
					if (angle < 0 || angle > 90){
						//compute the down directed angle
						angle = Algebra.getAngleBetweenVectors(down, direction);
						double h = Algebra.vectorLength(direction)*Math.cos(Math.toRadians(angle));//projection on to the down vector
						if (h > maxDown) maxDown = h;
					}
					else{
						double h = Algebra.vectorLength(direction)*Math.cos(Math.toRadians(angle));//projection on to the up vector
						if (h > maxUp) maxUp = h;
					}
					
					//same for left-right
					angle = Algebra.getAngleBetweenVectors(left, direction);
					if (angle < 0){
						//compute the down directed angle
						angle = Algebra.getAngleBetweenVectors(right, direction);
						double h = Algebra.vectorLength(direction)*Math.cos(Math.toRadians(angle));//projection on to the down vector
						if (h > maxRight) maxRight = h;
					}
					else{
						double h = Algebra.vectorLength(direction)*Math.cos(Math.toRadians(angle));//projection on to the up vector
						if (h > maxLeft) maxLeft = h;
					}
				}
				
			}

				
		
			//calculate bounds: we now have maximum reach of the structure(s) in all four directions
			//perpendicular to the lookAt vector
			double maxVertical = maxUp > maxDown ? maxUp : maxDown;
			double maxHorizontal = maxLeft > maxRight ? maxLeft : maxRight;
			
			double ratio = maxVertical/maxHorizontal;
			double radius = 20;
			//compare to the current aspect ratio
			if (ratio < getGeometryViewer().getAspectRatio()){
				radius = maxHorizontal;
			}
			else{
				radius = maxVertical;
			}
			
			geometryViewer.fitView(center, radius);
			
		}
		catch (Exception ex){
			structureDocument.parent.displayExceptionMessage("Exception resetting the view", ex);
		}
		
		
		
		
		
		
		
	}
	
}

