import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.prefs.Preferences;

import com.jgoodies.looks.*;
import com.jgoodies.looks.demo.*;
import com.jgoodies.looks.common.*;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.uif_lite.component.Factory;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;

import edu.sdsc.mbt.util.*;
import edu.sdsc.mbt.viewables.*;

import edu.sdsc.mbt.*;
import edu.sdsc.sirius.ray.*;

import javax.help.*;

import edu.sdsc.sirius.md.*;
import edu.sdsc.sirius.viewers.TreeViewer.*;
import edu.sdsc.sirius.lsp.*;


import edu.sdsc.sirius.builder.*;
import edu.sdsc.sirius.dialogs.*;
import edu.sdsc.sirius.export.*;

import edu.sdsc.sirius.io.*;
import edu.sdsc.sirius.monitors.*;
import edu.sdsc.sirius.search.*;
import edu.sdsc.sirius.util.*;
import edu.sdsc.sirius.rasmol.*;
import edu.sdsc.sirius.viewers.*;
import edu.sdsc.sirius.viewers.RamachandranViewerImpl.*;
import edu.sdsc.sirius.contact.*;


public class Viewer extends JFrame implements Manager, ElementSettable, com.install4j.api.launcher.StartupNotification.Listener {
	
	private boolean trial = false;
	
	private Container container;
    private Settings settings;
    
    private JFrame applicationFrame;
    private JPanel structurePanel;
    private JPanel statusPanel;
    
	private SequenceViewer sequenceViewer;
    private Viewer parent;
	private JFileChooser jFileChooser;
	
	public SearchServicePanel activeSearchServicePanel;
	
	private boolean searchOpen = false;
	private boolean sequenceOpen = false;
	
	
    private Vector viewers = new Vector();
    
    private StructureDocument structureDocument;
    
    private StructureViewer structureViewer;
    
    
	private Vector idCodes;//vector of PDB ids
	private String pdbId;//stores id of the currently selected structure to load from PDB

	private SplashWindow w;
	private DisplayDialog displayDialog;
	private boolean displayDialogStatus = false;
	
	private JCheckBoxMenuItem menuViewSelectionAtom;
	private JCheckBoxMenuItem menuViewSelectionResidue;
	private JCheckBoxMenuItem menuViewSelectionReplace;
	private JCheckBoxMenuItem menuViewSelectionAdd;
	
	private JCheckBoxMenuItem menuViewModeMove;
	private JCheckBoxMenuItem menuViewModeZoom;
	
	private JCheckBoxMenuItem menuOptionsOpenBuilder;
	private JCheckBoxMenuItem menuGeometryOpenMonitors;
	private JCheckBoxMenuItem menuComponentsStructureBrowser;
	private JCheckBoxMenuItem menuComponentsDataAccess;
	private JCheckBoxMenuItem menuComponentsCommand;
	private JCheckBoxMenuItem menuComponentsOpenSequence;
	private JCheckBoxMenuItem menuComponentsMD;
	private JCheckBoxMenuItem menuComponentsAutodock;
	private JCheckBoxMenuItem menuComponentsAutodockSetup;
	private JCheckBoxMenuItem menuAbraxisDataManager;
	
	private JCheckBoxMenuItem menuViewResetOnLoad;
	private JCheckBoxMenuItem menuViewListScan;
	private JCheckBoxMenuItem menuViewAntialiasing;
	
	private String installationHome;
	
	
	private JMenuItem menuViewUndo;
	
	private JCheckBoxMenuItem commonSelection;
	private JCheckBoxMenuItem commonColoring;
	
	private static final int DEFAULT_WIDTH = 700;
	private static final int DEFAULT_HEIGHT = 600;
	private Preferences node;
	
	private JComponent structureViewerComponent;
	private JComponent sequenceViewerComponent;
	private JComponent structureBrowserComponent;
	
	private JComponent splitDesktop;
	private JComponent upperSplitDesktop;
	
	private StylesPreferences prefs;
	
	private JPanel basePanel;
	
	private AboutDialog about;
	
	private BuilderDialog builderDialog;
	private MonitorDialog monitorDialog;
	private StructureBrowser structureBrowser;
	private DataAccessPanel dataAccessPanel;
	private CommandPanel commandPanel;
	
	private JCheckBoxMenuItem menuViewMotionCommon;
	private JCheckBoxMenuItem menuViewMotionSeparate;
	
	private JToolBar toolBar;
	private JScrollPane toolHolder;
	private boolean toolbarAdded = false;
	
	private ToolTipManager tipManager; 
	
	private JButton openButton;
	private JButton pdbButton;
	private JButton saveButton;
	private JButton clearButton;
	private JButton displayButton;
	private JButton renderButton;
	private JButton colorButton;
	private JButton labelsButton;
	private JButton centerButton;
	private JButton separateButton;
	private JButton commonButton;
	private JButton fogButton;
	private JButton undoButton;
	private JButton distanceButton;
	private JButton angleButton;
	private JButton dihedralButton;
	
	private JButton preferencesButton;
	private JButton resetButton;
	
	private HelpSet helpSet;
	private HelpBroker helpBroker;
	
	private JMenu closeMenu;
	
	private ImagePreviewPanel imagePreviewPanel;
	
	private String startup = "init";
	
	private Vector closeListeners = new Vector();
	
	private MDPanel mdPanel;
	private ClusterPanel clusterPanel;
	
	private RasmolReader rasmolReader;
	
	private boolean superimpose = false;//used by sequence viewer to decide how to send selected residues
	
	public static boolean resetViewOnLoad = true;
	
	private String lastWorkingDirectory = StylesPreferences.workingDirectory;//to return to the same location

	
	private HashMap ramaReference = new HashMap();//RamachandranViewer->Ramachandran plot dialog (there should be only one dialog per structure)

	private ContactMapViewer contactMapViewer;
	
	public Viewer(){
		
		super("Sirius 1.2");
		initialize();
		setVisible(true);

	}
	
	public ContactMapViewer getContactMapViewer(){
		return contactMapViewer;
	}
	
	public void startupPerformed(String string){
		startup = string;
		if (startup != null && startup.length() > 0){
			startup = startup.substring(1, startup.length()-1);
			if (startup.endsWith("vsf")){//don't translate
    			//it's a state file
    			final String fname = startup;
    			Thread runner = new Thread(){
    				public void run(){
    					StateHandler.importState(parent, structureViewer, sequenceViewer, fname);
    				}
    			};
    			runner.start();
    		}
    		else{
    			loadFile(new File(startup));
    		}

		}
		else{
			//only one instance can be run at a time
			displayErrorMessage("Only one instance of Sirius can be run at a time");
		}
	}
	
	public String getInstallationHome(){
		return installationHome;
	}
	
	public String getLastUsedDirectory(){
		return this.lastWorkingDirectory;
	}
	
	public void setLastUsedDirectory(String dir){
		this.lastWorkingDirectory = dir;
	}
	
	private boolean expressScan = true;
	
	public boolean getListScanMode(){
		return expressScan;
	}
	
	public void setListScanMode(boolean mode){
		expressScan = mode;
		menuViewListScan.setSelected(mode);
	}
	
	public void initialize(){
		
        this.settings = createSettings();

        applicationFrame = this;
        parent = this;
        
        String os = System.getProperty("os.name");//don't translate
		getContentPane().setBackground(Color.BLACK);
		
		JPopupMenu.setDefaultLightWeightPopupEnabled( false );
        
        tipManager = ToolTipManager.sharedInstance();
        if (!os.startsWith("Mac")) tipManager.setLightWeightPopupEnabled(false);//don't translate
        
        
		//get the width, height and location from preferences
		Preferences r = Preferences.userRoot();
		node = r.node("/edu/sdsc/sirius/config");//don't translate
		int width = node.getInt("width", DEFAULT_WIDTH);//don't translate
		int height = node.getInt("height", DEFAULT_HEIGHT);//don't translate
		int left = node.getInt("left", 0);//don't translate
		int top = node.getInt("top", 0);//don't translate


		Preferences root = Preferences.userRoot();
		final Preferences node = root.node("/edu/sdsc/sirius/config");//don't translate
		installationHome = node.get("installDir", "C:\\Program files\\Sirius");
		
//		System.out.println("home = " + installationHome);
		
		
		//just to make sure the restored window is not filling the screen completely
		Dimension dim = getToolkit().getScreenSize();
		if (width > (dim.width - 5)){
			width -= 10;
		}
		if (height > (dim.height - 5)){
			height -= 10;
		}

		//read the configuration file and set everything accordingly
		prefs = new StylesPreferences("/edu/sdsc/sirius/viewer");//don't translate
		try{
			prefs.readPreferences();
			StylesPreferences.magnificationMode = StylesPreferences.startupMagnificationMode;
			ElementPreferences preferences = new ElementPreferences();
			preferences.getCurrentConfiguration();//at least temporarily, to have defaults
			preferences.readPreferences();
			preferences.applyConfiguration();
			
			if (StylesPreferences.LAF == StylesPreferences.NATIVE_LAF && os.startsWith("Mac")){//don't translate
				//check font sizes
				int f = StylesPreferences.menuFontSize;
				if (f != 0){
					//make adjustments
					int ff = 11;
					if (os.startsWith("Mac")){//don't translate
						ff = 12;
					}
					ff += f;
					
					//apply the new size to the font values - //don't translate
					UIManager.put("Label.font", new Font("Dialog",Font.PLAIN,ff));
					UIManager.put("MenuItem.font", new Font("Dialog",Font.PLAIN,ff));
					UIManager.put("CheckBoxMenuItem.font", new Font("Dialog",Font.PLAIN,ff));
					UIManager.put("RadioButton.font", new Font("Dialog",Font.PLAIN,ff));
					UIManager.put("Menu.font", new Font("Dialog",Font.PLAIN,ff));
					UIManager.put("Button.font", new Font("Dialog",Font.PLAIN,ff));
					UIManager.put("TabbedPane.font", new Font("Dialog",Font.PLAIN,ff));
				}
				else{
					//no adjustments are requested, except for the default change for MacOS X - //don't translate
					if (os.startsWith("Mac")){
						UIManager.put("Label.font", new Font("Dialog",Font.PLAIN,12));
						UIManager.put("MenuItem.font", new Font("Dialog",Font.PLAIN,12));
						UIManager.put("CheckBoxMenuItem.font", new Font("Dialog",Font.PLAIN,12));
						UIManager.put("RadioButton.font", new Font("Dialog",Font.PLAIN,12));
						UIManager.put("Menu.font", new Font("Dialog",Font.PLAIN,12));
						UIManager.put("Button.font", new Font("Dialog",Font.PLAIN,12));
						UIManager.put("TabbedPane.font", new Font("Dialog",Font.PLAIN,12));
					}
				}
			}
		}
		catch (Exception ex){
			displayExceptionMessage("Unable to set preferences", ex);
		}

    	if (StylesPreferences.LAF == StylesPreferences.SMOOTH_LAF){
 	        UIManager.getDefaults().put("ClassLoader", Viewer.class.getClassLoader());//don't translate
	        configureUI();
	        ShadowPopupFactory.uninstall();
    	}
    	else{
       		try{
    			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    		}
    		catch (Exception e){
    			displayExceptionMessage("Unable to set system-specific look and feel", e);
    		}
    	}

        	
		this.lastWorkingDirectory = StylesPreferences.workingDirectory;

        container = getContentPane();
        container.setLayout(new BorderLayout());
        
      //other panels
        sequenceViewer = new SequenceViewer(this);
 
        /*        pubmedPanel = new JPanel();
        pubmedPanel.setPreferredSize(new Dimension((int)(width*0.3), (int)(height - sequencePanel.getHeight())));
        pubmedPanel.setBackground(Color.RED);
        sequencePanel.setBackground(Color.yellow);
*/        //create the viewers

        
        //take care of the panel holding the structure viewer and the status line
        structurePanel = new JPanel();
		structurePanel.setLayout(new BorderLayout());
		structurePanel.setBackground(Color.black);
		
		// Create a StatusPanel
		statusPanel = new StatusPanel( );
		structurePanel.add( BorderLayout.SOUTH, statusPanel );
		
		structureDocument = new StructureDocument(this);
		
		toolBar = createToolBar();
		toolBar.setFloatable(false);
		
		structureViewer = new StructureViewer( );
		structurePanel.add( BorderLayout.CENTER, structureViewer );
		structureDocument.addViewer( structureViewer );
		
		java.awt.dnd.DropTarget target = new java.awt.dnd.DropTarget(this, new FileDropListener(this));
		
		toolHolder = new JScrollPane(toolBar);
		toolHolder.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
		
		rasmolReader = new RasmolReader(structureViewer);
		
		if (StylesPreferences.displayToolbar){
			if (StylesPreferences.toolbarPosition == StylesPreferences.POSITION_LEFT){
				structurePanel.add(BorderLayout.WEST, toolHolder);
				
			}
			else{
				structurePanel.add(BorderLayout.NORTH, toolHolder);
			}
			toolbarAdded = true;
		}

		// Java3D's Canvas3D is heavyweight, so menus must so also
		// be so that they can draw over the top of the 3D content...
		JPopupMenu.setDefaultLightWeightPopupEnabled( false );

		viewers.add(structureViewer);
        
		about = new AboutDialog(applicationFrame, null);
		
		
		//configure help
		try {
			URL hsURL = getClass().getResource("/edu/sdsc/sirius/help/helpset.hs");//don't translate
			helpSet = new HelpSet(null, hsURL);
		}
		catch (Exception ee) {
			System.err.println("ERROR: HelpSet not found");
		}
		
	    // create HelpBroker from HelpSet
	    helpBroker = helpSet.createHelpBroker();
	    
	    // enable function key F1
	    helpBroker.enableHelpKey(getRootPane(), "overview", helpSet);


		
        JMenuBar menuBar = createMenuBar( );
        container.add(menuBar, BorderLayout.NORTH);

        structureViewerComponent = buildStructureViewerComponent();
        sequenceViewerComponent = buildSequenceViewerComponent();
        
//		builderPanel = new BuilderPanel(this);

		basePanel = new JPanel();
		basePanel.setLayout(new BorderLayout());
		basePanel.setBackground(Color.BLACK);
		basePanel.add(structureViewerComponent, BorderLayout.CENTER);
//		basePanel.add(sequencePanel, BorderLayout.SOUTH);
//		basePanel.add(pubmedPanel, BorderLayout.EAST);
		
		container.add(basePanel, BorderLayout.CENTER);

		// Make sure we clean up if the user hits the close box
		WindowAdapter closer = new WindowAdapter(){
			public void windowClosing( WindowEvent event ){
				
				//save the position of the frame - //don't translate
				node.putInt("width", applicationFrame.getWidth());
				node.putInt("height", applicationFrame.getHeight());
				node.putInt("left", applicationFrame.getLocation().x);
				node.putInt("top", applicationFrame.getLocation().y);
				
				prefs.writePreferences();
				
				destructor();
			}
		};
		applicationFrame.addWindowListener( closer );
		
		ImageIcon frameIcon = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/corner.gif"));//don't translate
		applicationFrame.setIconImage(frameIcon.getImage());

				
		applicationFrame.setSize( width, height );
		applicationFrame.setLocation(new Point(left, top));
		
		
		com.install4j.api.launcher.StartupNotification.registerStartupListener(this);
		
		//check if there is already a custom fragment directory
		String userHome = System.getProperty("user.home");//don't translate
		String customName = userHome + "/.sirius/ext/fragments_custom.dic";
		File customFile = new File(customName);
		if (customFile.exists()){
			//load the custom panel
			FragmentRegistry.customFragmentsDefined = true;
		}
		
		if (StylesPreferences.displayToolbar){
			if (StylesPreferences.toolbarPosition == StylesPreferences.POSITION_LEFT){
				DialogConstants.toolbarWidth = toolBar.getPreferredSize().width;
				DialogConstants.toolbarHeight = 0;
			}
			else{
				DialogConstants.toolbarWidth = 0;
				DialogConstants.toolbarHeight = toolBar.getPreferredSize().height;
			}
		}
		else{
			DialogConstants.toolbarWidth = 0;
			DialogConstants.toolbarHeight = 0;
		}
		
	}
	
    private static Settings createSettings() {
        Settings settings = Settings.createDefault();
        
        // Configure the settings here.
        return settings;
    }

    private JComponent buildStructureViewerComponent() {
        SimpleInternalFrame sif = new SimpleInternalFrame("Structure Viewer");
        sif.setPreferredSize(new Dimension(600, 400));
        sif.add(structurePanel);
        return sif;
    }

    private JComponent buildSequenceViewerComponent() {
        SimpleInternalFrame sif = new SimpleInternalFrame("Sequence Viewer");
        sif.setPreferredSize(new Dimension(800, 160));
        sif.add(sequenceViewer);
        return sif;
    }
   
    private JComponent buildStructureBrowserComponent() {
        SimpleInternalFrame sif = new SimpleInternalFrame("Structure Browser");
        sif.setPreferredSize(new Dimension(200, 250));
        if (structureBrowser == null){
        	structureBrowser = new StructureBrowser(this);
        	structureDocument.addViewer(structureBrowser);
        }
        sif.add(structureBrowser);
        return sif;
    
    }

    private void configureUI() {
        Options.setDefaultIconSize(new Dimension(18, 18));

        // Set font options	
        UIManager.put(
            Options.USE_SYSTEM_FONTS_APP_KEY,
            settings.isUseSystemFonts());
        Options.setGlobalFontSizeHints(settings.getFontSizeHints());
        Options.setUseNarrowButtons(settings.isUseNarrowButtons());
        
        // Global options
        Options.setTabIconsEnabled(settings.isTabIconsEnabled());
        UIManager.put(Options.POPUP_DROP_SHADOW_ENABLED_KEY, 
                settings.isPopupDropShadowEnabled());
        

        // Swing Settings
        LookAndFeel selectedLaf = settings.getSelectedLookAndFeel();
        if (selectedLaf instanceof PlasticLookAndFeel) {
            PlasticLookAndFeel.setMyCurrentTheme(settings.getSelectedTheme());
            PlasticLookAndFeel.setTabStyle(settings.getPlasticTabStyle());
            PlasticLookAndFeel.setHighContrastFocusColorsEnabled(
                settings.isPlasticHighContrastFocusEnabled());
        } else if (selectedLaf.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        
        // Work around caching in MetalRadioButtonUI
        JRadioButton radio = new JRadioButton();
        radio.getUI().uninstallUI(radio);
        JCheckBox checkBox = new JCheckBox();
        checkBox.getUI().uninstallUI(checkBox);

        try {
            UIManager.setLookAndFeel(selectedLaf);
        } catch (Exception e) {
            System.out.println("Can't change L&F: " + e);
        }

    }
    
    private JToolBar createToolBar(){
    	
    	JToolBar toolbar = new JToolBar();
    	if (StylesPreferences.toolbarPosition == StylesPreferences.POSITION_LEFT){
    		toolbar.setOrientation(JToolBar.VERTICAL);
    	}
    	else{
    		toolbar.setOrientation(JToolBar.HORIZONTAL);
    	}
    	ImageIcon iconOpen = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/open_struct.gif"));//don't translate
    	Action openAction = new AbstractAction("Open...", iconOpen){
    		public void actionPerformed(ActionEvent e){
    			openFileAction();
    		}
    	};
    	openButton = toolbar.add(openAction);
    	openButton.setMargin(new Insets(0,0,0,0));
    	if (StylesPreferences.showToolbarTips) openButton.setToolTipText("Open file");
    	
    	if (StylesPreferences.toolbarPDB){
	    	ImageIcon iconPdb = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/open_pdb.gif"));//don't translate
	    	Action pdbAction = new AbstractAction("PDB...", iconPdb){
	    		public void actionPerformed(ActionEvent e){
	    			loadPdbAction();
	    		}
	    	};
	    	pdbButton = toolbar.add(pdbAction);
	    	pdbButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) pdbButton.setToolTipText("Load structure from PDB");
    	}
    	
    	ImageIcon iconSave = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/save.gif"));//don't translate
    	Action saveAction = new AbstractAction("Save...", iconSave){
    		public void actionPerformed(ActionEvent e){
    			saveStructureAction();
    		}
    	};
    	saveButton = toolbar.add(saveAction);
    	saveButton.setMargin(new Insets(0,0,0,0));
    	if (StylesPreferences.showToolbarTips) saveButton.setToolTipText("Save structure");
    	
    	ImageIcon iconClear = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/close2.gif"));//don't translate
    	Action clearAction = new AbstractAction("Clear", iconClear){
    		public void actionPerformed(ActionEvent e){
    			clearAction();
    		}
    	};
    	clearButton = toolbar.add(clearAction);
    	clearButton.setMargin(new Insets(0,0,0,0));
    	if (StylesPreferences.showToolbarTips) clearButton.setToolTipText("Close all");
    	


    	
/*    	if (StylesPreferences.toolbarUndo){
	    	ImageIcon iconUndo = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/undo.gif"));
	    	Action undoAction = new AbstractAction("Undo last change", iconUndo){
	    		public void actionPerformed(ActionEvent e){
	    			undoAction();
	    		}
	    	};
	    	undoButton = toolbar.add(undoAction);
	    	undoButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) undoButton.setToolTipText("Undo last change");
    	}
*/    	
    	if (StylesPreferences.toolbarVisibility){
    		ImageIcon iconDisplay = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/hide_show.gif"));//don't translate
    		Action displayAction = new AbstractAction("Display", iconDisplay){
    			public void actionPerformed(ActionEvent e){
    				displayAction();
    			}
    		};
	    	displayButton = toolbar.add(displayAction);
	    	displayButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) displayButton.setToolTipText("Structure visibility");
    	}
    	
    	if (StylesPreferences.toolbarRendering){
	    	ImageIcon iconRender = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/struct_render.gif"));//don't translate
	    	Action renderAction = new AbstractAction("Rendering", iconRender){
	    		public void actionPerformed(ActionEvent e){
	    			renderingAction();
	    		}
	    	};
	    	renderButton = toolbar.add(renderAction);
	    	renderButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) renderButton.setToolTipText("Structure rendering");
    	}

    	if (StylesPreferences.toolbarColoring){
	    	ImageIcon iconColor = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/struct_color.gif"));//don't translate
	    	Action colorAction = new AbstractAction("Color", iconColor){
	    		public void actionPerformed(ActionEvent e){
	    			colorAction();
	    		}
	    	};
	    	colorButton = toolbar.add(colorAction);
	    	colorButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) colorButton.setToolTipText("Structure coloring");
    	}
    	
    	if (StylesPreferences.toolbarLabels){
	    	ImageIcon iconLabel = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/labels.gif"));//don't translate
	    	Action labelAction = new AbstractAction("Label", iconLabel){
	    		public void actionPerformed(ActionEvent e){
	    			labelAction();
	    		}
	    	};
	    	labelsButton = toolbar.add(labelAction);
	    	labelsButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) labelsButton.setToolTipText("Atom labels");
    	}

    	
    	if (StylesPreferences.toolbarCenter){
	    	ImageIcon iconCenter = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/center_view.gif"));//don't translate
	    	Action centerAction = new AbstractAction("Center view", iconCenter){
	    		public void actionPerformed(ActionEvent e){
	    			centerAction();
	    		}
	    	};
	    	centerButton = toolbar.add(centerAction);
	    	centerButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) centerButton.setToolTipText("Center view");
    	}

    	if (StylesPreferences.toolbarSeparate){
	    	ImageIcon iconSeparate = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/motion_separate.gif"));//don't translate
	    	Action separateAction = new AbstractAction("Separate motion", iconSeparate){
	    		public void actionPerformed(ActionEvent e){
	    			separateMotionAction();
	    		}
	    	};
	    	separateButton = toolbar.add(separateAction);
	    	separateButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) separateButton.setToolTipText("Set independent motion");
    	}

    	if (StylesPreferences.toolbarCommon){
	    	ImageIcon iconCommon = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/motion_common.gif"));//don't translate
	    	Action commonAction = new AbstractAction("Common motion", iconCommon){
	    		public void actionPerformed(ActionEvent e){
	    			commonMotionAction();
	    		}
	    	};
		   	commonButton = toolbar.add(commonAction);
		   	commonButton.setMargin(new Insets(0,0,0,0));
		   	if (StylesPreferences.showToolbarTips) commonButton.setToolTipText("Set common motion");
    	}

    	if (StylesPreferences.toolbarDistance){
	    	ImageIcon iconDistance = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/distance.gif"));//don't translate
	    	Action distanceAction = new AbstractAction("Measure distance", iconDistance){
	    		public void actionPerformed(ActionEvent e){
	    			distanceAction();
	    		}
	    	};
	    	distanceButton = toolbar.add(distanceAction);
	    	distanceButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) distanceButton.setToolTipText("Measure distance");
    	}

    	if (StylesPreferences.toolbarAngle){
	    	ImageIcon iconAngle = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/angle.gif"));//don't translate
	    	Action angleAction = new AbstractAction("Measure bond angle", iconAngle){
	    		public void actionPerformed(ActionEvent e){
	    			angleAction();
	    		}
	    	};
	    	angleButton = toolbar.add(angleAction);
	    	angleButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) angleButton.setToolTipText("Measure bond angle");
    	}

    	if (StylesPreferences.toolbarDihedral){
	    	ImageIcon iconDihedral = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/dihedralangle.gif"));//don't translate
	    	Action dihedralAction = new AbstractAction("Measure dihedral angle", iconDihedral){
	    		public void actionPerformed(ActionEvent e){
	    			dihedralAngleAction();
	    		}
	    	};
	    	dihedralButton = toolbar.add(dihedralAction);
	    	dihedralButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) dihedralButton.setToolTipText("Measure dihedral angle");
    	}
	   	
	   	ImageIcon iconReset = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/reset_view.gif"));//don't translate
    	Action resetAction = new AbstractAction("Reset view", iconReset){
    		public void actionPerformed(ActionEvent e){
    			fitDisplay();
    		}
    	};
    	resetButton = toolbar.add(resetAction);
    	resetButton.setMargin(new Insets(0,0,0,0));
    	if (StylesPreferences.showToolbarTips) resetButton.setToolTipText("Fit all to display");

    	
    	if (StylesPreferences.toolbarFog){
		   	ImageIcon iconFog = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/fog.gif"));//don't translate
	    	Action fogAction = new AbstractAction("Depth perception", iconFog){
	    		public void actionPerformed(ActionEvent e){
	    			fogAction();
	    		}
	    	};
	    	fogButton = toolbar.add(fogAction);
	    	fogButton.setMargin(new Insets(0,0,0,0));
	    	if (StylesPreferences.showToolbarTips) fogButton.setToolTipText("Depth perception");
    	}
    	
    	
	   	ImageIcon iconPreferences = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/prefs.gif"));//don't translate
    	Action preferencesAction = new AbstractAction("Preferences", iconPreferences){
    		public void actionPerformed(ActionEvent e){
    			preferencesAction();
    		}
    	};
    	preferencesButton = toolbar.add(preferencesAction);
    	preferencesButton.setMargin(new Insets(0,0,0,0));
    	if (StylesPreferences.showToolbarTips) preferencesButton.setToolTipText("Preferences");

    	
    	
    	return toolbar;
    }
    
    private void openFileAction(){
//		Thread runner = new Thread(){
//			public void run(){
				try{
					
					fileOpen();
				}
				catch (Exception ex){
					displayExceptionMessage("Exception opening file", ex);
				}
//			}
//		};
//		runner.start();
    }
    
    private void loadPdbAction(){
		if (displayDialogStatus){
			return;
		}
		
		
		Thread runner = new Thread(){
			public void run(){
				try{
//					loadIdCodes();
//					System.out.println("Displaying the pdb dialog");
					displayDialogStatus = true;
					DisplayDialog displayDialog = new PdbLoadDialog(applicationFrame, parent);
					displayDialogStatus = false;
				}
				catch (Exception ex){
					displayExceptionMessage("Unable to connect to PDB: Connection error.", ex);
					displayDialogStatus = false;
					displayDialog = null;
					return;
				}
			}
		};
		runner.start();
    }
    
    private void saveStructureAction(){
    	
		//first, check if any entries are loaded
		int count = structureDocument.getEntryCount();
		
		if (count == 0) return;
		if (count > 1){
			try{
				IOHandler.selection = false;
				EntryListerDialog load = new EntryListerDialog(applicationFrame, parent, true, structureDocument, EntryListerDialog.SAVE_ENTRY);
			}
			catch (Exception ex){
				displayExceptionMessage("Exception saving a structure", ex);
			}
		}
		else{
			//there is only one entry
			Entry e = structureDocument.getEntry(0);
			if (e.TYPE == Entry.STRUCTURE_ENTRY || e.TYPE == Entry.FRAGMENT_ENTRY){
				StructureEntry se = (StructureEntry)e;
				IOHandler.selection = false;
				IOHandler.saveStructureFile(se, parent);
			}
			else if (e.TYPE == Entry.SEQUENCE_ENTRY){
				SequenceEntry se = (SequenceEntry)e;
				IOHandler.selection = false;
				Vector sequences = new Vector();
				//save the sequence entry
				for (int i = 0; i < se.getSequenceCount(); i++){
					Sequence s = se.getSequence(i);
					sequences.add(s.getCells());
				}
				
				IOHandler.saveAlignment(sequences, parent);
			}

		}
    }
    
    private void clearAction(){
		structureViewer.removeMonitors();
		try{
			clearEntries(false);
			ResidueColorFactory.clearResidueColors();
			AtomColorFactory.cache.clear();
		}
		catch (Exception ex){
			displayExceptionMessage("Exception closing entries", ex);
		}
    }
    
    public void colorAction(){
		if (displayDialogStatus){
			return;
		}
		
		Thread runner = new Thread(){
			public void run(){
//				System.out.println("Running");
				try{
					displayDialog = new ColorDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception processing color change", ex);
				}
			}
		};
		runner.start();				

    }
    
    private void labelAction(){
		if (displayDialogStatus){
			return;
		}
		
		Thread runner = new Thread(){
			public void run(){
				try{
					displayDialog = new LabelDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception processing labeling", ex);
				}
			}
		};
		runner.start();				

    }

    private void residueLabelAction(){
		if (displayDialogStatus){
			return;
		}
		
		Thread runner = new Thread(){
			public void run(){
				try{
					displayDialog = new ResidueLabelDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception processing residue labeling", ex);
				}
			}
		};
		runner.start();				

    }
   
    public void displayAction(){
		if (displayDialogStatus){
			return;
		}
		
		Thread runner = new Thread(){
			public void run(){
				try{
					displayDialog = new VisibilityDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception processing display adjustment", ex);
				}
			}
		};
		runner.start();

    }
    
    public void ribbonDisplayAction(){
		if (displayDialogStatus){
			return;
		}
		
		Thread runner = new Thread(){
			public void run(){
				try{
					displayDialog = new RibbonDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception processing ribbon visibility", ex);
				}
			}
		};
		runner.start();

    }
    
    public void surfaceAction(){
		if (displayDialogStatus){
			return;
		}
		Thread runner = new Thread(){
    		public void run(){
				try{
					displayDialog = new SurfaceDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception processing ribbon visibility", ex);
				}
    		}
    	};
    	runner.start();
    }

    
    public void renderingAction(){
		if (displayDialogStatus){
			return;
		}
		
		//display rendering dialog
		Thread runner = new Thread(){
			public void run(){
				try{
					displayDialog = new RenderingDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception rendering structure", ex);
				}
			}
		};
		runner.start();

    }
    
    private void separateMotionAction(){
		if (displayDialogStatus){
			return;
		}
		menuViewMotionSeparate.setSelected(false);//only the feedback from the dialog will set it

		Thread runner = new Thread(){
			public void run(){
				try{
					displayDialog = new MotionDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception setting separate motion", ex);
				}
			}
		};
		runner.start();

    }
    
    private void commonMotionAction(){
		menuViewMotionSeparate.setSelected(false);
		Thread runner = new Thread(){
			public void run(){
				structureViewer.setCommonMotion(true);
				menuViewMotionCommon.setSelected(true);
			}
		};
		runner.start();

    }
    
    private void centerAction(){
		if (displayDialogStatus){
			return;
		}

		Thread runner = new Thread(){
			public void run(){
				try{
					displayDialog = new CenterDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception centering view", ex);
				}
			}
		};
		runner.start();

    }
    
    private void zoomAction(){

		Thread runner = new Thread(){
			public void run(){
				try{
					structureViewer.zoomSelection();
				}
				catch (Exception ex){
					displayExceptionMessage("Exception zooming at selection", ex);
				}
			}
		};
		runner.start();

    }

    
    private void fogAction(){
		if (displayDialogStatus){
			return;
		}
		
		Thread runner = new Thread(){
			public void run(){
//				System.out.println("Running");
				try{
					displayDialog = new FogDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception adjusting depth perception parameters", ex);
				}
			}
		};
		runner.start();

    }
    
    private void undoAction(){
    	this.displayMessage("Undo has been disabled until its function is improved. An updated version will be released shortly.");
/*		try{
			if (!menuViewUndo.isEnabled()) return;
			sequenceViewer.setUndoMode(true);
			structureViewer.undo( );
			sequenceViewer.setUndoMode(false);
		}
		catch (Exception ex){
			displayExceptionMessage("Exception reverting to the previous state", ex);
		}
*/    }
    
    private void distanceAction(){
		if (displayDialogStatus){
			return;
		}
		
		Thread runner = new Thread(){
			public void run(){
				try{
					if (StylesPreferences.fastGeometry){
						//check how many selected atoms are displayed
						Vector atoms = new Vector();
						for (int i = 0; i < structureViewer.getLoadedStructures().size(); i++){
							Structure structure = (Structure)structureViewer.getLoadedStructures().get(i);
							Hashtable selection = structure.getStructureMap().getStructureStyles().getSelection();
							
							//check if the two selected items are actually atoms
							Set keys = selection.keySet();
							Iterator it = keys.iterator();
							while (it.hasNext()){
								try{
									Atom a = (Atom)it.next();
									atoms.add(a);
								}
								catch (Exception ex){
									break;
								}
							}
						}
						
						
						if (atoms.size() == 2){
							
							//proceed with distance
							Atom a1 = (Atom)atoms.get(0);
							Atom a2 = (Atom)atoms.get(1);
							structureViewer.computeDistance(a1, a2);
						}
						else{
							displayDialog = new DistanceDialog(applicationFrame, parent, structureViewer);
						}
					}
					else{
						displayDialog = new DistanceDialog(applicationFrame, parent, structureViewer);
					}
				}
				catch (Exception ex){
					displayExceptionMessage("Exception measuring distance", ex);
				}
			}
		};
		runner.start();
    }
    
    private void angleAction(){
		if (displayDialogStatus){
			return;
		}
		
		Thread runner = new Thread(){
			public void run(){
				try{
					if (StylesPreferences.fastGeometry){
						//check how many selected atoms are displayed
						Vector atoms = new Vector();
						for (int i = 0; i < structureViewer.getLoadedStructures().size(); i++){
							Structure structure = (Structure)structureViewer.getLoadedStructures().get(i);
							Hashtable selection = structure.getStructureMap().getStructureStyles().getSelection();
							
							//check if the two selected items are actually atoms
							Set keys = selection.keySet();
							Iterator it = keys.iterator();
							while (it.hasNext()){
								try{
									Atom a = (Atom)it.next();
									atoms.add(a);
								}
								catch (Exception ex){
									break;
								}
							}
						}
						
						
						if (atoms.size() == 3){
							
							//proceed with distance
							structureViewer.computeAngle(atoms);
						}
						else{
							displayDialog = new AngleDialog(applicationFrame, parent, structureViewer);
						}
					}
					else{
						displayDialog = new AngleDialog(applicationFrame, parent, structureViewer);
					}
				}
				catch (Exception ex){
					displayExceptionMessage("Exception measuring bond angle", ex);
				}
			}
		};
		runner.start();
	}
    
    private void dihedralAngleAction(){
		if (displayDialogStatus){
			return;
		}
		
		Thread runner = new Thread(){
			public void run(){
				try{
					displayDialog = new DihedralDialog(applicationFrame, parent, structureViewer);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception measuring dihedral angle", ex);
				}
			}
		};
		runner.start();
    }
    
    private void preferencesAction(){
		Thread runner = new Thread(){
			public void run(){
				try{
					PreferencesDialog preferences = new PreferencesDialog(applicationFrame, parent);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception setting preferences", ex);
				}
			}
		};
		runner.start();
    }
    
    private void resetAction(){
		try{
			structureViewer.resetView( );
		}
		catch (Exception ex){
			displayExceptionMessage("Exception resetting view", ex);
		}
    }
    
    /**
     * This method causes the camera to move toward or from the structure to display the entire content
     *
     */
    private void fitDisplay(){
    	structureViewer.fitDisplay();
    }
    
	public void removeRamachandranDialog(edu.sdsc.sirius.viewers.Viewer viewer){
		RamachandranViewerDialog d = (RamachandranViewerDialog)ramaReference.get(viewer);
		if (d == null) return;
		d.setVisible(false);
		d.dispose();
		
		ramaReference.remove(viewer);
	}
	
	public void removeRamachandranDialog(Structure structure){
		//check whether this structure has a plot open
		RamachandranViewer vvv = null;
		Set keys = ramaReference.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			RamachandranViewerDialog d = (RamachandranViewerDialog)ramaReference.get(it.next());
			if (d.getViewer().getStructure() == structure){
				//delete this one
				vvv = d.getViewer();
				break;
			}
		}
		
		if (vvv != null){
			structureDocument.removeViewer(vvv);
		}
	}
	
	public RamachandranViewer getRamachandranViewer(Structure structure){
		RamachandranViewer vvv = null;
		Set keys = ramaReference.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			RamachandranViewerDialog d = (RamachandranViewerDialog)ramaReference.get(it.next());
			if (d.getViewer().getStructure() == structure){
				return d.getViewer();
			}
		}
		return null;
	}


	private JMenuBar createMenuBar( ){

		JMenuBar menuBar = new JMenuBar();
		JMenu menuFile = new JMenu("File");
		menuFile.setMnemonic('f');
		
		JMenuItem menuFileOpenfile = new JMenuItem();
		menuFileOpenfile.setText("Open file...");
		menuFileOpenfile.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, KeyEvent.CTRL_MASK, false));
				
		menuFileOpenfile.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				openFileAction();
			}
		});
		
		
		JMenuItem menuFilePdb = new JMenuItem("Load from PDB...");
		menuFilePdb.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, KeyEvent.CTRL_MASK, false));
				
		menuFilePdb.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent actionEvent){
				loadPdbAction();
			}
		});
		
		JMenuItem menuFileSave = new JMenuItem("Save structure...");
		menuFileSave.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, KeyEvent.CTRL_MASK, false));
				
		ActionListener fileSaveListener = new ActionListener(){
			public void actionPerformed(ActionEvent actionEvent){
				saveStructureAction();
			}
		};

		menuFileSave.addActionListener(fileSaveListener);
		
		JMenuItem menuFileSaveSelection = new JMenuItem("Save selected subset...");
		menuFileSaveSelection.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent actionEvent){
				//this method opens result set loading dialog
					
				//first, check if any structures are loaded
				int count = structureDocument.getEntryCount();
				if (count > 1){
					//check if anything is selected
					//check if there is more than one structure loaded
					try{
						IOHandler.selection = true;
						EntryListerDialog load = new EntryListerDialog(applicationFrame,parent,true, structureDocument, EntryListerDialog.SAVE_ENTRY);
					}
					catch (Exception ex){
						displayExceptionMessage("Exception saving a structure", ex);
					}
				}
				else{
					//there is only one structure
					Entry e = structureDocument.getEntry(0);
					try{
						StructureEntry se = (StructureEntry)e;
						IOHandler.selection = true;
						IOHandler.saveStructureFile(se, parent);
					}
					catch (ClassCastException ex){
						SequenceEntry sse = (SequenceEntry)e;
						IOHandler.selection = true;
						Vector sequences = new Vector();
						//save the sequence entry
						for (int i = 0; i < sse.getSequenceCount(); i++){
							Sequence s = sse.getSequence(i);
							sequences.add(s.getCells());
						}
						
						IOHandler.saveAlignment(sequences, parent);
						
					}
				}
			}
		});
		
		JMenuItem menuFileSaveImage = new JMenuItem("Export as image...");
		menuFileSaveImage.setEnabled(true);
		menuFileSaveImage.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_I, KeyEvent.CTRL_MASK, false));
		menuFileSaveImage.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent actionEvent){
				//this method opens result set loading dialog
				Thread runner = new Thread(){
					public void run(){
						//ask the user for image resolution
						String[] choices = new String[]{ "Screen", "150 dpi", "300 dpi" };
						String input = (String)JOptionPane.showInputDialog(applicationFrame, 
								"Please select desired image resolution", "Select resolution", 
								JOptionPane.INFORMATION_MESSAGE, null, choices, "Screen");
						if (input == null) return;
						if (input.equals("Screen")){
							structureViewer.saveImage(0, 0, 0, 0, 96);
						}
						else{
							try{
								
								int res = Integer.parseInt(input.substring(0,3));
								structureViewer.saveImage(0, 0, 0, 0, res);
							}
							catch (NumberFormatException ex){
								displayErrorMessage("Resolution must be an integer");
							}
						}
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuFileSaveRayImage = new JMenuItem("Create ray-traced image...");
		menuFileSaveRayImage.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, KeyEvent.CTRL_MASK, false));
		menuFileSaveRayImage.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent actionEvent){
				
				Thread runner = new Thread(){
					public void run(){
						
						//get the dimensions of the image from the user in pixels
						if (displayDialog != null) return;
						
						displayDialog = new RayTracerDialog(applicationFrame, parent, structureViewer);
						
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuFileSavePovray = new JMenuItem("Save view as POV-Ray input file...");
		menuFileSavePovray.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent actionEvent){
				
				Thread runner = new Thread(){
					public void run(){
						
						//get the dimensions of the image from the user in pixels
						if (displayDialog != null) return;
						
						//ask the user for file location and pass it to the RayTraceUtil
						try{
							String filename = RayTraceUtil.getPOVContent(structureViewer, parent, structureViewer.getGeometryViewer().getWidth(), 
									structureViewer.getGeometryViewer().getHeight(), -1, false, null);
							if (filename == null){
								parent.displayErrorMessage("Unable to create POV-Ray scene file.");
								return;
							}

							
							//save the pov-ray file to the location of user's choice
							JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
							chooser.setDialogTitle("Save POV-Ray file");

							chooser.setDialogType(JFileChooser.SAVE_DIALOG);
							
							FileFilter pov = new FileNameFilter("pov", "POV-Ray format");
							chooser.addChoosableFileFilter( pov );
							chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
							int result = chooser.showSaveDialog(parent.getApplicationFrame());
							if (result == JFileChooser.CANCEL_OPTION){
								return;
							}
							File f = chooser.getSelectedFile();
							String fname = f.toString();
							int dot = fname.lastIndexOf(".");

							if (dot <= 0){
								//no extension supplied
								fname += "." + pov.toString();
							}
							
							File ff = new File(fname);
							if (ff.exists()){
								if (ff.isDirectory()){
									parent.displayErrorMessage("Selected destination is a directory");
									return;
								}
								//ask if the file should be overwritten
								if (JOptionPane.showConfirmDialog(
										parent.getApplicationFrame(), "File with this name exists. Overwrite?", "Confirmation",
										JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION){
									return;
								}
							}
							
							//copy the file from the temporary location to the user-designated file
							 FileTransfer ft = new FileTransfer();
							 ft.copy(new File(filename), new File(fname));
							 
							 //delete the original file
							 File fff = new File(filename);
							 fff.delete();
						}
						catch (Exception ee){
							displayExceptionMessage("Exception while exporting image", ee);
						}


					}
				};
				runner.start();
			}
		});
		
		

		
		JMenuItem menuFileExport = new JMenuItem("Export as state...");
		menuFileExport.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						//get the file name first
						String fname = getStateFilename();
						if (fname == null) return;
						
						if (fname.endsWith("vsf")){
							StateHandler.exportState(structureViewer, sequenceViewer, fname);
						}



					}
				};
				runner.start();
				
			}
		});
		
		JMenuItem menuFileExportApplet = new JMenuItem("Export as Java applet...");
		menuFileExportApplet.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						//get the file name first
						if (structureDocument.getEntryCount() == 0){
							displayErrorMessage("No structures are currently loaded");
							return;
						}
						
						//get the desired file name
						JFileChooser chooser = new JFileChooser(parent.lastWorkingDirectory);
						chooser.setDialogTitle("Export view as applet");

						chooser.setDialogType(JFileChooser.SAVE_DIALOG);

						
						chooser.addChoosableFileFilter( new FileNameFilter("html", "HTML File Format") );
						
						chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
						int result = chooser.showSaveDialog(applicationFrame);
						if (result == JFileChooser.CANCEL_OPTION){
							return;
						}
						File filename = chooser.getSelectedFile();
						parent.lastWorkingDirectory = filename.getParent();
						String fname = filename.toString();
						
						int dot = fname.lastIndexOf(".");

						//get the desired file type
						FileFilter filter = chooser.getFileFilter();
						
						if (dot <= 0){
							//no extension supplied
							fname += "." + filter.toString();
						}
						
						//at this point, fname is an html file that should have the tags for the applet and
						//location of the VSF file to be displayed
						//let's save the vsf to that directory and give it the same name as html, but with the vsf 
						//extension
						String vsf = fname.replaceAll("html", "vsf");
						
						try{
							StateHandler.exportState(structureViewer, sequenceViewer, vsf);
							
							//write out the applet file - //don't translate
							PrintWriter printer = new PrintWriter(new FileWriter(fname));
							printer.println("<html>\n<head>\n<title>Sirius3D</title>\n</head>");
							printer.println("<body>\n<applet code=\"com.sun.opengl.util.JOGLAppletLauncher\"\n\tcodebase=\".\"");
							printer.println("\tarchive=\"sirius_3d_signed.jar, looks-1.3_signed.jar, jogl.jar\"");
							printer.println("\tname=\"Sirius3D\"");
							printer.println("\twidth=\"100%\"\n\theight=\"100%\"\n\tmayscript=\"true\">");
							printer.println("\t<param name=\"subapplet.classname\" value=\"Viewer3D\">");
							printer.println("\t<param name=\"subapplet.displayname\" value=\"Sirius3D\">");
							printer.println("\t<param name=\"progressbar\" value=\"true\">");
							printer.println("\t<param name=\"cache_archive\" value=\"sirius_3d_signed.jar, jogl.jar, looks-1.3_signed.jar\">");
							printer.println("\t<param name=\"dataSource\" value=\"file\">");
							printer.println("\t<param name=\"fileURL\" value=\"" + vsf + "\">");
							printer.println("</applet>\n</body>\n</html>");
							printer.flush();
							printer.close();
	
							
							
	
							//now copy the necessary files from the Sirius installation directory to the
							//location of the applet files
							
							//get the Sirius installation directory
							String source = parent.getInstallationHome() + File.separator + "applet";
//							System.out.println("source = " + source);
							
							String destinationDir = vsf.substring(0, vsf.lastIndexOf(File.separator));
//							System.out.println("Destination directory = " + destinationDir);
							
							//first, check whether the needed files are already there
							//maybe, it's not the first file of the presentation
							File siriusJar = new File(destinationDir + File.separator + "sirius_3d_signed.jar");
							File looksJar = new File(destinationDir + File.separator + "looks-1.3_signed.jar");
							File joglJar = new File(destinationDir + File.separator + "jogl.jar");
							File winJar = new File(destinationDir + File.separator + "jogl-natives-windows-i586.jar");
							File macJar = new File(destinationDir + File.separator + "jogl-natives-macosx-universal.jar");
							
							if (!siriusJar.exists()){
								FileTransfer transfer = new FileTransfer();
								transfer.copy(new File(source + File.separator + "sirius_3d_signed.jar"), siriusJar);
							}
	
							if (!looksJar.exists()){
								FileTransfer transfer = new FileTransfer();
								transfer.copy(new File(source + File.separator + "looks-1.3_signed.jar"), looksJar);
							}
							
							if (!joglJar.exists()){
								FileTransfer transfer = new FileTransfer();
								transfer.copy(new File(source + File.separator + "jogl.jar"), joglJar);
							}
							
							if (System.getProperty("os.name").startsWith("Win")){//don't translate
								if (!winJar.exists()){
									FileTransfer transfer = new FileTransfer();
									transfer.copy(new File(source + File.separator + "jogl-natives-windows-i586.jar"), winJar);
								}
							}
							else if (System.getProperty("os.name").startsWith("Mac")){//don't translate
								if (!macJar.exists()){
									FileTransfer transfer = new FileTransfer();
									transfer.copy(new File(source + File.separator + "jogl-natives-macosx-universal.jar"), macJar);
								}
							}
							
							
							parent.displayMessage("View export to an applet is completed");
						}
						catch (Exception ex){
							parent.displayExceptionMessage("Exception saving applet files", ex);
						}
					}
				};
				runner.start();
				
			}
		});

		
		JMenuItem menuFileImport = new JMenuItem("Import state from file...");
		menuFileImport.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						//get the file name first
						openState();
					}
				};
				runner.start();
				
			}
		});

		closeMenu = new JMenu("Close entry");
		closeMenu.setEnabled(false);

		JMenuItem menuFileClear = new JMenuItem("Close all entries");
		menuFileClear.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, KeyEvent.CTRL_MASK, false));
		menuFileClear.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				clearAction();
			}
		});
		
		
		JMenuItem menuFileExit = new JMenuItem("Exit");
		menuFileExit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, KeyEvent.CTRL_MASK, false));
		menuFileExit.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				if (JOptionPane.showConfirmDialog(applicationFrame, "Are you sure you want to exit?", "Exit confirmation", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION){
					//save the position of the frame - //don't translate
					node.putInt("width", applicationFrame.getWidth());
					node.putInt("height", applicationFrame.getHeight());
					node.putInt("left", applicationFrame.getLocation().x);
					node.putInt("top", applicationFrame.getLocation().y);
					
					destructor();
				}
			}
		});

		JMenu menuView = new JMenu("View");
		menuView.setMnemonic('v');
		JMenuItem menuViewColor = new JMenuItem("Structure color...");
		menuViewColor.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				colorAction();
			}
		});
		
		JMenuItem menuViewDisplay = new JMenuItem("Show/hide atomic structure...");
		menuViewDisplay.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				displayAction();
			}
		});

		JMenuItem menuViewRibbonDisplay = new JMenuItem("Show/hide ribbon...");
		menuViewRibbonDisplay.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ribbonDisplayAction();
			}
		});
		
		JMenuItem menuViewRendering = new JMenuItem("Structure rendering...");
		menuViewRendering.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				renderingAction();
			}
		});
		
		JMenuItem menuViewSurface = new JMenuItem("Create dot surface...");
		menuViewSurface.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				surfaceAction();
			}
		});
		
		JMenuItem menuViewEditSurface = new JMenuItem("Manage surfaces...");
		menuViewEditSurface.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}

				if (structureViewer.getSurfaceObjects().size() == 0){
					displayErrorMessage("No surfaces have been created: nothing to edit.");
					return;
				}
				
		    	Thread runner = new Thread(){
		    		public void run(){
						try{
							displayDialog = new SurfaceEditDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception editing surfaces", ex);
						}
		    		}
		    	};
		    	runner.start();

			}
		});
		
		

		JMenu menuViewSelection = new JMenu("Mouse pick selection level");
		menuViewSelectionAtom = new JCheckBoxMenuItem("Atom");
		menuViewSelectionAtom.setState(StylesPreferences.selectionLevel == StylesPreferences.SELECTION_ATOM);
		menuViewSelectionAtom.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				StylesPreferences.selectionLevel = StylesPreferences.SELECTION_ATOM;
				menuViewSelectionAtom.setState(true);
				menuViewSelectionResidue.setState(false);
			}
		});

		menuViewSelectionResidue = new JCheckBoxMenuItem("Residue");
		menuViewSelectionResidue.setState(StylesPreferences.selectionLevel == StylesPreferences.SELECTION_RESIDUE);
		menuViewSelectionResidue.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				StylesPreferences.selectionLevel = StylesPreferences.SELECTION_RESIDUE;
				menuViewSelectionAtom.setState(false);
				menuViewSelectionResidue.setState(true);
			}
		});
		

		JMenu menuViewSelectionMode = new JMenu("Selection mode");
		menuViewSelectionReplace = new JCheckBoxMenuItem("Replace existing selection");
		menuViewSelectionReplace.setState(StylesPreferences.selectionMode == StylesPreferences.SELECTION_REPLACE);
		menuViewSelectionReplace.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				StylesPreferences.selectionMode = StylesPreferences.SELECTION_REPLACE;
				menuViewSelectionReplace.setState(true);
				menuViewSelectionAdd.setState(false);
			}
		});

		menuViewSelectionAdd = new JCheckBoxMenuItem("Add to existing selection");
		menuViewSelectionAdd.setState(StylesPreferences.selectionMode == StylesPreferences.SELECTION_ADD);
		menuViewSelectionAdd.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				StylesPreferences.selectionMode = StylesPreferences.SELECTION_ADD;
				menuViewSelectionReplace.setState(false);
				menuViewSelectionAdd.setState(true);
			}
		});
		
		menuViewSelectionMode.add(menuViewSelectionReplace);
		menuViewSelectionMode.add(menuViewSelectionAdd);
		
		
		JMenuItem menuViewSelectionClear = new JMenuItem("Clear selection");
		menuViewSelectionClear.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.clearAllSelection();
				sequenceViewer.clearCellSelection(false);
				updateView();
			}
		});
		
		JMenuItem menuViewRibbon = new JMenuItem("Protein ribbon properties...");
		menuViewRibbon.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new RibbonDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception generating a ribbon", ex);
						}
					}
				};
				runner.start();
				
				
			}
		});

		JMenuItem menuViewRibbonColor = new JMenuItem("Protein ribbon color...");
		menuViewRibbonColor.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new RibbonColorDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception coloring ribbon", ex);
						}
					}
				};
				runner.start();
				
				
			}
		});

	
		JMenuItem menuViewRecenter = new JMenuItem("Recenter");
		JMenuItem menuViewStereo = new JMenuItem("Stereo view");
		
		JMenu menuViewMode = new JMenu("Magnification mode");
		menuViewModeMove = new JCheckBoxMenuItem("Move structure");
		menuViewModeZoom = new JCheckBoxMenuItem("Zoom structure");

		menuViewModeMove.setSelected(StylesPreferences.magnificationMode == StylesPreferences.MAGNIFICATION_MOVE);
		menuViewModeMove.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				StylesPreferences.magnificationMode = StylesPreferences.MAGNIFICATION_MOVE;
				menuViewModeMove.setState(true);
				menuViewModeZoom.setSelected(false);
			}
		});
		
		menuViewModeZoom.setSelected(StylesPreferences.magnificationMode == StylesPreferences.MAGNIFICATION_ZOOM);
		menuViewModeZoom.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				StylesPreferences.magnificationMode = StylesPreferences.MAGNIFICATION_ZOOM;
				menuViewModeMove.setSelected(false);
				menuViewModeZoom.setState(true);
			}
		});
		
		menuViewMode.add(menuViewModeMove);
		menuViewMode.add(menuViewModeZoom);
		
		
		menuViewMotionSeparate = new JCheckBoxMenuItem("Move objects separately...");
		menuViewMotionSeparate.setSelected(false);
		menuViewMotionSeparate.setEnabled(true);
		menuViewMotionSeparate.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				separateMotionAction();
			}
		});
		
		menuViewMotionCommon = new JCheckBoxMenuItem("Move entire view");
		menuViewMotionCommon.setSelected(true);
		menuViewMotionCommon.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				commonMotionAction();
			}
		});
				
		JMenuItem menuViewCenter = new JMenuItem("Center view on atom...");
		menuViewCenter.addActionListener(new ActionListener(){
			public void actionPerformed( ActionEvent actionEvent ){
				centerAction();
			}
		});
		
		JMenuItem menuViewZoom = new JMenuItem("Zoom at current selection");
		menuViewZoom.addActionListener(new ActionListener(){
			public void actionPerformed( ActionEvent actionEvent ){
				zoomAction();
			}
		});
		
		
		JMenuItem menuViewFit = new JMenuItem("Fit all to display");
		menuViewFit.addActionListener(new ActionListener(){
			public void actionPerformed( ActionEvent actionEvent ){
				fitDisplay();
			}
		});

		JMenuItem menuViewReset = new JMenuItem("Reset view");
		menuViewReset.addActionListener(new ActionListener(){
			public void actionPerformed( ActionEvent actionEvent ){
				resetAction();
			}
		});
		
		menuViewResetOnLoad = new JCheckBoxMenuItem("Reset view on load");
		menuViewResetOnLoad.setSelected(resetViewOnLoad);
		menuViewResetOnLoad.addActionListener(new ActionListener(){
			public void actionPerformed( ActionEvent actionEvent ){
				resetViewOnLoad = (menuViewResetOnLoad.isSelected());
			}
		});

		menuViewListScan = new JCheckBoxMenuItem("Scan mode of structure lists");
		menuViewListScan.setSelected(expressScan);
		menuViewListScan.addActionListener(new ActionListener(){
			public void actionPerformed( ActionEvent actionEvent ){
				expressScan = (menuViewListScan.isSelected());
			}
		});

		menuViewUndo = new JMenuItem("Undo previous action");
		menuViewUndo.setEnabled(false);
		menuViewUndo.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				undoAction();
			}
		});

		
		/**
		 * TODO selection menu
		 * 
		 */
		
		JMenu menuSelection = new JMenu("Selection");
		menuSelection.setMnemonic('s');

		JMenuItem menuSelectionArea = new JMenuItem("Define selection area...");
		menuSelectionArea.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}

				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new SelectionAreaDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception centering view", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuSelectionList = new JMenuItem("Define selection as list...");
		menuSelectionList.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}

				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new SelectListDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception centering view", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuSelectionVis = new JMenuItem("Select all visible");
		menuSelectionVis.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByVisibility(true);
			}
		});
		
		JMenuItem menuSelectionInvis = new JMenuItem("Select all invisible");
		menuSelectionInvis.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByVisibility(false);
			}
		});
		
		JMenuItem menuSelectionBackbone = new JMenuItem("Select protein/DNA backbone");
		menuSelectionBackbone.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						structureViewer.selectBackbone();
					}
				};
				runner.start();
			}
		});

		JMenuItem menuSelectionInvert = new JMenuItem("Invert selection");
		menuSelectionInvert.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.invertSelection();
			}
		});
		
		JMenuItem menuSelectionSet = new JMenuItem("Select atom set...");
		menuSelectionSet.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectAtomSet();
			}
		});

		
		JMenuItem menuSelectionByElement = new JMenuItem("By element...");
		menuSelectionByElement.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						ElementSelectionDialog d = new ElementSelectionDialog(applicationFrame, "Selection by element", (ElementSettable)parent);
					}
				};
				runner.start();

			}
		});
		
		JMenuItem menuSelectionByAtomName = new JMenuItem("By atom name...");
		menuSelectionByAtomName.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						displayDialog = new AtomDialog(applicationFrame, parent, structureViewer, StructureEventRegistry.SELECT_ATOM);
					}
				};
				runner.start();

			}
		});

		JMenu menuSelectionResidue = new JMenu("By Amino Acid");
		JMenuItem menuSelectionResidueAla = new JMenuItem("Ala");
		menuSelectionResidueAla.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("ALA");//don't translate - as well as all similar entries below (these are coded keys)
			}
		});
		JMenuItem menuSelectionResidueCys = new JMenuItem("Cys");
		menuSelectionResidueCys.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("CYS");
			}
		});
		JMenuItem menuSelectionResidueAsp = new JMenuItem("Asp");
		menuSelectionResidueAsp.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("ASP");
			}
		});
		JMenuItem menuSelectionResidueAsn = new JMenuItem("Asn");
		menuSelectionResidueAsn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("ASN");
			}
		});
		JMenuItem menuSelectionResiduePhe = new JMenuItem("Phe");
		menuSelectionResiduePhe.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("PHE");
			}
		});
		JMenuItem menuSelectionResidueGly = new JMenuItem("Gly");
		menuSelectionResidueGly.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("GLY");
			}
		});
		
		JMenuItem menuSelectionResidueHis = new JMenuItem("His");
		menuSelectionResidueHis.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("HIS");
			}
		});
		JMenuItem menuSelectionResidueIle = new JMenuItem("Ile");
		menuSelectionResidueIle.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("ILE");
			}
		});
		JMenuItem menuSelectionResidueLys = new JMenuItem("Lys");
		menuSelectionResidueLys.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("LYS");
			}
		});
		JMenuItem menuSelectionResidueLeu = new JMenuItem("Leu");
		menuSelectionResidueLeu.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("LEU");
			}
		});
		JMenuItem menuSelectionResidueMet = new JMenuItem("Met");
		menuSelectionResidueMet.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("MET");
			}
		});
		JMenuItem menuSelectionResidueGln = new JMenuItem("Gln");
		menuSelectionResidueGln.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("GLN");
			}
		});
		JMenuItem menuSelectionResiduePro = new JMenuItem("Pro");
		menuSelectionResiduePro.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("PRO");
			}
		});
		JMenuItem menuSelectionResidueGlu = new JMenuItem("Glu");
		menuSelectionResidueGlu.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("GLU");
			}
		});
		JMenuItem menuSelectionResidueArg = new JMenuItem("Arg");
		menuSelectionResidueArg.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("ARG");
			}
		});
		JMenuItem menuSelectionResidueSer = new JMenuItem("Ser");
		menuSelectionResidueSer.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("SER");
			}
		});
		JMenuItem menuSelectionResidueThr = new JMenuItem("Thr");
		menuSelectionResidueThr.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("THR");
			}
		});
		JMenuItem menuSelectionResidueVal = new JMenuItem("Val");
		menuSelectionResidueVal.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("VAL");
			}
		});
		JMenuItem menuSelectionResidueTrp = new JMenuItem("Trp");
		menuSelectionResidueTrp.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("TRP");
			}
		});
		JMenuItem menuSelectionResidueTyr = new JMenuItem("Tyr");
		menuSelectionResidueTyr.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("TYR");
			}
		});
		
		JMenu menuSelectionDNA = new JMenu("By nucleic acid");
		JMenuItem menuSelectionDNAA = new JMenuItem("Adenine");
		menuSelectionDNAA.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("A");
			}
		});
		JMenuItem menuSelectionDNAT = new JMenuItem("Thymine");
		menuSelectionDNAT.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("T");
			}
		});
		JMenuItem menuSelectionDNAC = new JMenuItem("Cytosine");
		menuSelectionDNAC.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("C");
			}
		});
		JMenuItem menuSelectionDNAG = new JMenuItem("Guanine");
		menuSelectionDNAG.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.selectByResidue("G");
			}
		});
		
		
		
		
		
		JMenu menuStructure = new JMenu("Structure");
		menuStructure.setMnemonic('t');
		
		JMenuItem menuStructureRama = new JMenuItem("Ramachandran plot...");
		menuStructureRama.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (structureViewer.getLoadedStructures().size() == 0){
					displayErrorMessage("No structures are loaded");
					return;
				}
				
				if (structureViewer.getLoadedStructures().size() == 1){
					Thread runner = new Thread(){
						public void run(){
							try{
								displayRamachandranPlot((Structure)structureViewer.getLoadedStructures().get(0));
							}
							catch (Exception ex){
								displayExceptionMessage("Exception creating Ramachandran plot", ex);
							}
						}
					};
					runner.start();
				}
				else {
					//provide a selection dialog to choose the structure for which Ramachandran plot should be created
					if (displayDialogStatus){
						return;
					}

					Thread runner = new Thread(){
						public void run(){
							try{
								displayDialog = new StructureSelectionDialog(applicationFrame, parent, structureViewer);
							}
							catch (Exception ex){
								displayExceptionMessage("Exception creating Ramachandran plot", ex);
							}
						}
					};
					runner.start();

				}
			}
		});
		
		JMenuItem menuStructureGraph = new JMenuItem("Compare Local Spatial Patterns...");
		menuStructureGraph.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							if (displayDialogStatus){
								return;
							}
							
							displayDialog = new GraphDialog(parent);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception comparing structures", ex);
						}
					}
				};
				runner.start();
			}
		});

		
		JMenu menuStructureSuperimpose = new JMenu("Structure superposition");
		
		JMenuItem menuStructureSuperimposeAnchor = new JMenuItem("Anchor atom-based superposition...");
		menuStructureSuperimposeAnchor.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							superimpose = true;
							displayDialog = new SuperimposeDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							superimpose = false;
							displayExceptionMessage("Exception superimposing structures", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuStructureSuperimposeAlignment = new JMenuItem("Alignment-based superposition...");
		menuStructureSuperimposeAlignment.setEnabled(false);
		menuStructureSuperimposeAlignment.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							superimpose = true;
							displayDialog = new StructureSuperpositionAlignDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							superimpose = false;
							displayExceptionMessage("Exception superimposing structures", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		menuStructureSuperimpose.add(menuStructureSuperimposeAnchor);
		menuStructureSuperimpose.add(menuStructureSuperimposeAlignment);
		
		JMenuItem menuStructureContacts = new JMenuItem("Residue contact map...");
		menuStructureContacts.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new ContactMapDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception computing interaction map", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuStructureAlignment = new JMenuItem("Protein structure alignment/RMSD...");
		menuStructureAlignment.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							//check the number of loaded structures
							if (structureViewer.getLoadedStructures().size() < 2){
								displayErrorMessage("At least two structures must be loaded for alignment");
								return;
							}
							displayDialog = new StructureAlignmentDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception aligning structures", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuStructureModel = new JMenuItem("Build homology model...");
		menuStructureModel.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							//check the number of loaded structures
							if (structureViewer.getLoadedStructures().size() == 0){
								displayErrorMessage("At least one structure must be loaded as the template for model building.");
								return;
							}
							displayDialog = new HomologyModelDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception building homology model. Make sure the input sequences aree aligned.", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuGeometryBump = new JMenuItem("Detect steric clashes...");
		menuGeometryBump.setEnabled(true);
		menuGeometryBump.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new BumpDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception detecting steric clashes", ex);
						}
					}
				};
				runner.start();
			}
		});
	
		JMenuItem menuGeometryHBond = new JMenuItem("Detect hydrogen bonds...");
		menuGeometryHBond.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new HBDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception detecting hydrogen bonds", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		
		
	
		JMenuItem menuStructureBondOrder = new JMenuItem("Set bond order...");
		menuStructureBondOrder.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new BondOrderDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception setting bond order", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		
		JMenuItem menuStructureEdit = new JMenuItem("Edit structure objects...");
		menuStructureEdit.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new StructureEditDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception editing structure", ex);
						}
					}
				};
				runner.start();
				
			}			
		});
		
		JMenuItem menuStructureRename = new JMenuItem("Rename structure...");
		menuStructureRename.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new StructureRenameDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception editing structure", ex);
						}
					}
				};
				runner.start();
				
			}			
		});
		
		
		JMenuItem menuStructureSet = new JMenuItem("Define/edit atom set...");
		menuStructureSet.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							if (structureViewer.getLoadedStructures().size() == 0){
								displayErrorMessage("No structures are loaded. No set to define.");
								return;
							}
							displayDialog = new StructureSetDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception defining an atom set", ex);
						}
					}
				};
				runner.start();
				
			}			
		});
		
		
		JMenuItem menuStructureReplaceResidue = new JMenuItem("Replace amino acid...");
		menuStructureReplaceResidue.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new ReplaceResidueDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception replacing amino acid", ex);
						}
					}
				};
				runner.start();
				
			}
		});
		
		JMenuItem menuStructureWeight = new JMenuItem("Compute molecular weight...");
		menuStructureWeight.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new WeightDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception computing molecular weight", ex);
						}
					}
				};
				runner.start();
				
			}
		});
		
		JMenuItem menuStructureBonds = new JMenuItem("Count rotatable bonds...");
		menuStructureBonds.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new CountBondsDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception counting rotatable bonds", ex);
						}
					}
				};
				runner.start();
			}
		});
		

		JMenuItem menuViewLabel = new JMenuItem("Atom labels...");
		menuViewLabel.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				labelAction();
			}
		});
		
		JMenuItem menuViewResidueLabel = new JMenuItem("Residue labels...");
		menuViewResidueLabel.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				residueLabelAction();
			}
		});
		
		JMenuItem menuGeometryDistance = new JMenuItem("Measure distance...");
		menuGeometryDistance.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				distanceAction();
			}
		});
		
		JMenuItem menuGeometryAngle = new JMenuItem("Bond angle...");
		menuGeometryAngle.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				angleAction();
			}
		});
		
		JMenuItem menuGeometryDihedral = new JMenuItem("Dihedral angle...");
		menuGeometryDihedral.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				dihedralAngleAction();
			}
		});

		
		JMenuItem menuGeometryMonitors = new JMenuItem("Remove all markers");
		menuGeometryMonitors.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				structureViewer.removeMonitors();
			}		
		});
		
		JMenuItem menuStructureRibbon = new JMenuItem();
		menuStructureRibbon.setText("Protein ribbon display...");
		menuStructureRibbon.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new RibbonDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception generating a ribbon", ex);
						}
					}
				};
				runner.start();
				
				
			}
		});

		JMenuItem menuStructureRibbonColor = new JMenuItem();
		menuStructureRibbonColor.setText("Protein ribbon color...");
		menuStructureRibbonColor.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new RibbonColorDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception coloring ribbon", ex);
						}
					}
				};
				runner.start();
				
				
			}
		});

		
		JMenu menuGeometry = new JMenu("Geometry");
		menuGeometry.setMnemonic('g');
		
		menuGeometryOpenMonitors = new JCheckBoxMenuItem("Manage interactions and monitors");
		menuGeometryOpenMonitors.setSelected(false);
		menuGeometryOpenMonitors.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent itemEvent ){
				if (itemEvent.getStateChange() == ItemEvent.SELECTED){
					openMonitorDialog();
				}
				else{
					closeMonitorDialog();
				}
			}
		});

/*		menuComponentsStructureBrowser = new JCheckBoxMenuItem("Structure browser");
		menuComponentsStructureBrowser.setSelected(false);
		menuComponentsStructureBrowser.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent itemEvent ){
				if (itemEvent.getStateChange() == ItemEvent.SELECTED){
					openStructureBrowser();
				}
				else{
					closeStructureBrowser();
				}
			}
		});
*/
		menuComponentsDataAccess = new JCheckBoxMenuItem("Data Access Panel");
		menuComponentsDataAccess.setSelected(false);
		menuComponentsDataAccess.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent itemEvent ){
				if (itemEvent.getStateChange() == ItemEvent.SELECTED){
					openDataAccessPanel();
				}
				else{
					closeDataAccessPanel();
				}
			}
		});
		
		menuComponentsCommand = new JCheckBoxMenuItem("Command Panel");
		menuComponentsCommand.setSelected(false);
		menuComponentsCommand.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent itemEvent ){
				if (itemEvent.getStateChange() == ItemEvent.SELECTED){
					openCommandPanel();
				}
				else{
					closeCommandPanel();
				}
			}
		});
		
		menuOptionsOpenBuilder = new JCheckBoxMenuItem("Fragment library");
		menuOptionsOpenBuilder.setSelected(false);
		menuOptionsOpenBuilder.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent itemEvent ){
				if (itemEvent.getStateChange() == ItemEvent.SELECTED){
					openBuilderDialog();
				}
				else{
					closeBuilderDialog();
					FragmentRegistry.activeFragment = null;
				}
			}
		});

		menuComponentsOpenSequence = new JCheckBoxMenuItem("Sequence Viewer");
		menuComponentsOpenSequence.setSelected(false);
		menuComponentsOpenSequence.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent itemEvent ){
				if (itemEvent.getStateChange() == ItemEvent.SELECTED){
					openSequencePanel();
				}
				else{
					closeSequencePanel();
				}
			}
		});
		
		menuComponentsMD = new JCheckBoxMenuItem("Molecular Dynamics Panel");
		menuComponentsMD.setSelected(false);
		menuComponentsMD.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent itemEvent ){
				if (itemEvent.getStateChange() == ItemEvent.SELECTED){
					openMDPanel();
				}
				else{
					closeMDPanel();
				}
			}
		});
		
		

		menuComponentsStructureBrowser = new JCheckBoxMenuItem("Structure Browser");
		menuComponentsStructureBrowser.setSelected(false);
		menuComponentsStructureBrowser.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent itemEvent ){
				if (itemEvent.getStateChange() == ItemEvent.SELECTED){
					openStructureBrowserPanel();
				}
				else{
					closeStructureBrowserPanel();
				}
			}
		});
		
		commonSelection = new JCheckBoxMenuItem("Common selection");
		commonSelection.setSelected(StylesPreferences.commonSelection);
		commonSelection.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent e){
				StylesPreferences.commonSelection = commonSelection.isSelected();
			}
		});
		
		commonColoring = new JCheckBoxMenuItem("Common coloring");
		commonColoring.setSelected(StylesPreferences.commonColoring);
		commonColoring.addItemListener(new ItemListener(){
			public void itemStateChanged( ItemEvent e){
				StylesPreferences.commonSelection = commonColoring.isSelected();
			}
		});

		JMenu menuComponents = new JMenu("Tools");
		menuComponents.setMnemonic('t');

		menuComponents.add(menuComponentsOpenSequence);
		menuComponents.add(menuComponentsStructureBrowser);
		menuComponents.add(menuComponentsCommand);
		menuComponents.add(new JSeparator());
		menuComponents.add(menuComponentsMD);
		menuComponents.add(menuComponentsDataAccess);
//		menuComponents.add(new JSeparator());

		JMenuItem menuOptionsFog = new JMenuItem("Set depth perception...");
		menuOptionsFog.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				fogAction();
			}
		});
		
		menuViewAntialiasing = new JCheckBoxMenuItem("Smooth bond lines");
		menuViewAntialiasing.setSelected(StylesPreferences.antialiasing);
		menuViewAntialiasing.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				StylesPreferences.antialiasing = menuViewAntialiasing.isSelected();
				structureViewer.updateAppearance();
			}
		});

		JMenuItem menuOptionsEnvironment = new JMenuItem("Preferences");
		menuOptionsEnvironment.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				preferencesAction();
			}
		});
		
		menuComponents.add(new JSeparator());
		menuComponents.add(menuOptionsEnvironment);
		
		JMenu menuHelp = new JMenu("Help");
		menuHelp.setMnemonic('h');
		JMenuItem menuHelpAbout = new JMenuItem("About Sirius...");
		menuHelpAbout.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				parent.displayMessage("Sirius is a visualization and analysis desktop environment developed at San Diego Supercomputer Center\n" +
						"             by Oleksandr (Sasha) Buzko. This is an update as of October 12, 2010.\n");
			}
		});
		
		JMenuItem menuHelpHelp = new JMenuItem("Sirius help...");

		menuHelpHelp.addActionListener(new CSH.DisplayHelpFromSource(helpBroker));
		
		JMenuItem menuHelpUpdate = new JMenuItem("Update Sirius...");
		menuHelpUpdate.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				updater();
			}
		});
		
		JMenu menuBuild = new JMenu("Builder");
		menuBuild.setMnemonic('b');

		JMenuItem menuBuildTypes = new JMenuItem("Assign atom types");
		menuBuildTypes.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (structureViewer.getLoadedStructures().size() != 1) return;
				Structure s = (Structure)structureViewer.getLoadedStructures().get(0);
				
				StructureMap map = s.getStructureMap();
				for (int i = 0; i < map.getAtomCount(); i++){
					Atom a = map.getAtom(i);
//					System.out.println(a.name + " -> " + a.forceFieldType);
				}
			}
		});
		
		
		JMenuItem menuBuildReplaceAtom = new JMenuItem("Replace atom...");
		menuBuildReplaceAtom.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new ReplaceAtomDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception replacing atom", ex);
						}
					}
				};
				runner.start();
				
			}
		});
		
		JMenuItem menuBuildAddH = new JMenuItem("Add/remove hydrogens...");
		menuBuildAddH.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new HydrogenDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception checking hydrogens", ex);
						}
					}
				};
				runner.start();
				
			}
		});
		
		JMenuItem menuBuildBonds = new JMenuItem("Detect missing bonds");
		menuBuildBonds.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						try{
							if (structureDocument.getEntryCount() == 0) return;
							for (int i = 0; i < structureDocument.getEntryCount(); i++){
								Entry entry = structureDocument.getEntry(i);
								if (entry.TYPE == Entry.STRUCTURE_ENTRY){
									Structure s = ((StructureEntry)entry).getStructure();
									Vector bonds = s.getStructureMap().detectBonds();
									if (bonds == null){
										parent.displayMessage("No bonds were detected");
										return;
									}
									structureViewer.addBonds(bonds, true, true, true);
								}
							}
						}
						catch (Exception ex){
							displayExceptionMessage("Exception detecting bonds", ex);
						}
					}
				};
				runner.start();
				
			}
		});
		
		JMenuItem menuBuildOverlaps = new JMenuItem("Detect overlapping atoms");
		menuBuildOverlaps.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						try{
							boolean found = false;
							if (structureDocument.getEntryCount() == 0) return;
							parent.displayWaitScreen();

							for (int i = 0; i < structureDocument.getEntryCount(); i++){
								Entry entry = structureDocument.getEntry(i);
								if (entry.TYPE == Entry.STRUCTURE_ENTRY){
									Structure s = ((StructureEntry)entry).getStructure();
									StructureMap map = s.getStructureMap();
									
									for (int j = 0; j < map.getAtomCount(); j++){
										for (int k = 0; k < map.getAtomCount(); k++){
											if (j == k) continue;
											
											Atom a = map.getAtom(j);
											Atom b = map.getAtom(k);
											double distance = Algebra.distance(a.coordinate, b.coordinate);
											if (distance < 0.7){
												found = true;
												//select both atoms
												map.getStructureStyles().setSelected(a, true, false, false);
												map.getStructureStyles().setSelected(b, true, false, false);
											}
										}
									}

								}
							}
							
							structureViewer.updateAppearance();
							
							parent.removeWaitScreen();
							if (!found) parent.displayMessage("No overlapping atoms found");
						}
						catch (Exception ex){
							displayExceptionMessage("Exception detecting bonds", ex);
						}
					}
				};
				runner.start();
				
			}
		});

		
		
		JMenuItem menuBuildHybrid = new JMenuItem("Set hybridization state...");
		menuBuildHybrid.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new HybridizationDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception setting hybridization", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuBuildCharge = new JMenuItem("Set formal charge...");
		menuBuildCharge.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new ChargeDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception setting charge", ex);
						}
					}
				};
				runner.start();
			}
		});

		JMenuItem menuBuildDeleteAtom = new JMenuItem("Delete atom...");
		menuBuildDeleteAtom.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new AtomDialog(applicationFrame, parent, structureViewer, StructureEventRegistry.DELETE_ATOM);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception deleting atom", ex);
						}
					}
				};
				runner.start();
				
			}
		});
		
		JMenuItem menuBuildDeleteSelection = new JMenuItem("Delete selected atoms");
		menuBuildDeleteSelection.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				//call delete selection method
				Thread runner = new Thread(){
					public void run(){
						structureViewer.deleteSelectedAtoms();
					}
				};
				runner.start();
				
				
			}
		});

		JMenuItem menuBuildBond = new JMenuItem("Create bond...");
		menuBuildBond.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new CreateBondDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception creating bond", ex);
						}
					}
				};
				runner.start();
			}
		});

		JMenuItem menuBreakBond = new JMenuItem("Break bond...");
		menuBreakBond.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new BreakBondDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception creating bond", ex);
						}
					}
				};
				runner.start();
			}
		});

		JMenuItem menuRotateBond = new JMenuItem("Rotate around bond...");
		menuRotateBond.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new RotateBondDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception creating bond", ex);
						}
					}
				};
				runner.start();
			}
		});

		JMenu menuMinimizeStructure = new JMenu("Minimize structure");
		JMenuItem menuMinimize = new JMenuItem("Minimize structure");
		menuMinimize.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						StructureEntry e = (StructureEntry)structureDocument.getEntry(0);
//						MolecularMechanics m = new MolecularMechanics(structureViewer, null);
//						m.minimize(e.getStructure(), MolecularMechanics.STEEPEST_DESCENT, 100, 0.01);
					}
				};
				runner.start();
			}
		});
		
		JMenuItem menuMinimizeConjugate = new JMenuItem("Conjugate gradient");
		menuMinimizeConjugate.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Thread runner = new Thread(){
					public void run(){
						StructureEntry e = (StructureEntry)structureDocument.getEntry(0);
//						MolecularMechanics m = new MolecularMechanics(structureViewer, null);
//						m.minimize(e.getStructure(), MolecularMechanics.CONJUGATE_GRADIENT, 100, 0.01);
					}
				};
				runner.start();
			}
		});
		
//		menuMinimizeStructure.add(menuMinimizeSteepest);
		menuMinimizeStructure.add(menuMinimizeConjugate);
		
		
		JMenuItem menuBuildAddFragment = new JMenuItem("Save as custom fragment...");
		menuBuildAddFragment.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (displayDialogStatus){
					return;
				}
				
				Thread runner = new Thread(){
					public void run(){
						try{
							displayDialog = new SaveFragmentDialog(applicationFrame, parent, structureViewer);
						}
						catch (Exception ex){
							displayExceptionMessage("Exception saving fragment", ex);
						}
					}
				};
				runner.start();
			}
		});
		
		JMenu menuAppearance = new JMenu("Appearance");
		menuAppearance.setMnemonic('a');

		
		//now set them up
		menuBar.setVisible(true);

		
		//add things
		menuBar.add(menuFile);
		menuBar.add(menuAppearance);
		menuBar.add(menuView);
		menuBar.add(menuSelection);
		menuBar.add(menuStructure);
		menuBar.add(menuGeometry);
		menuBar.add(menuBuild);
		menuBar.add(menuComponents);
		menuBar.add(menuHelp);
		
		menuFile.add(menuFileOpenfile);
		menuFile.add(menuFilePdb);
		menuFile.add(new JSeparator());
		menuFile.add(menuFileSave);
		menuFile.add(menuFileSaveSelection);
		menuFile.add(new JSeparator());
		menuFile.add(menuFileSaveImage);
		if (System.getProperty("os.name").startsWith("Win")){//don't translate
			menuFile.add(menuFileSaveRayImage);
		}
		else if (System.getProperty("os.name").startsWith("Linux")){//don't translate
			if (System.getProperty("os.arch").startsWith("i386") || System.getProperty("os.arch").startsWith("x86_64")){//don't translate
				menuFile.add(menuFileSaveRayImage);
			}
		}
		
		menuFile.add(menuFileSavePovray);
		menuFile.add(new JSeparator());
		menuFile.add(menuFileImport);
		menuFile.add(menuFileExport);
		menuFile.add(menuFileExportApplet);
		menuFile.add(new JSeparator());
		menuFile.add(closeMenu);
		menuFile.add(menuFileClear);
		menuFile.add(new JSeparator());
		menuFile.add(menuFileExit);
		
		menuAppearance.add(menuViewDisplay);
		menuAppearance.add(menuViewRendering);
		menuAppearance.add(menuViewColor);
		menuAppearance.add(new JSeparator());
		menuAppearance.add(menuViewRibbonDisplay);
		menuAppearance.add(menuViewRibbonColor);
		menuAppearance.add(new JSeparator());
		menuAppearance.add(menuViewSurface);
		menuAppearance.add(menuViewEditSurface);
		menuAppearance.add(new JSeparator());
		menuAppearance.add(menuViewLabel);
		menuAppearance.add(menuViewResidueLabel);
		
		

		menuView.add(menuViewAntialiasing);
		menuView.add(new JSeparator());
		menuView.add(menuViewMotionCommon);
		menuView.add(menuViewMotionSeparate);
		menuView.add(new JSeparator());
		menuView.add(menuViewCenter);
		menuView.add(menuOptionsFog);
		menuView.add(new JSeparator());
		menuView.add(menuViewZoom);
		menuView.add(menuViewFit);
		menuView.add(menuViewReset);
		menuView.add(new JSeparator());
		menuView.add(menuViewResetOnLoad);
		menuView.add(menuViewListScan);
//		menuView.add(menuViewUndo);
		
		menuSelection.add(menuSelectionArea);
		menuSelection.add(menuSelectionList);
//		menuSelection.add(new JSeparator());
//		menuSelection.add(menuSelectionVis);
//		menuSelection.add(menuSelectionInvis);
//		menuSelection.add(menuSelectionInvert);
		menuSelection.add(menuSelectionSet);
		menuSelection.add(new JSeparator());
		menuSelection.add(menuSelectionResidue);
		menuSelectionResidue.add(menuSelectionResidueGly);
		menuSelectionResidue.add(menuSelectionResidueAla);
		menuSelectionResidue.add(menuSelectionResidueLeu);
		menuSelectionResidue.add(menuSelectionResidueIle);
		menuSelectionResidue.add(menuSelectionResidueVal);
		menuSelectionResidue.add(menuSelectionResidueSer);
		menuSelectionResidue.add(menuSelectionResidueThr);
		menuSelectionResidue.add(menuSelectionResidueCys);
		menuSelectionResidue.add(menuSelectionResidueMet);
		menuSelectionResidue.add(menuSelectionResiduePro);
		menuSelectionResidue.add(menuSelectionResidueAsp);
		menuSelectionResidue.add(menuSelectionResidueAsn);
		menuSelectionResidue.add(menuSelectionResidueGln);
		menuSelectionResidue.add(menuSelectionResidueGlu);
		menuSelectionResidue.add(menuSelectionResiduePhe);
		menuSelectionResidue.add(menuSelectionResidueTrp);
		menuSelectionResidue.add(menuSelectionResidueTyr);
		menuSelectionResidue.add(menuSelectionResidueHis);
		menuSelectionResidue.add(menuSelectionResidueLys);
		menuSelectionResidue.add(menuSelectionResidueArg);
		
		menuSelection.add(menuSelectionDNA);
		menuSelectionDNA.add(menuSelectionDNAA);
		menuSelectionDNA.add(menuSelectionDNAT);
		menuSelectionDNA.add(menuSelectionDNAC);
		menuSelectionDNA.add(menuSelectionDNAG);
		menuSelection.add(menuSelectionByElement);
		menuSelection.add(menuSelectionByAtomName);
		menuSelection.add(menuSelectionBackbone);
		
		menuSelection.add(new JSeparator());
		menuViewSelection.add(menuViewSelectionAtom);
		menuViewSelection.add(menuViewSelectionResidue);
		menuSelection.add(menuViewSelection);
		
		menuSelection.add(menuViewSelectionMode);
		menuSelection.add(new JSeparator());
		menuSelection.add(menuViewSelectionClear);
		
		
		menuStructure.add(menuStructureRename);
		menuStructure.add(menuStructureSet);
		menuStructure.add(menuStructureEdit);
		menuStructure.add(new JSeparator());
		menuStructure.add(menuStructureReplaceResidue);
		menuStructure.add(menuStructureWeight);
		menuStructure.add(menuStructureBonds);
		menuStructure.add(new JSeparator());
		menuStructure.add(menuStructureRama);
		menuStructure.add(menuStructureGraph);
//		menuStructure.add(new JSeparator());
		menuStructure.add(menuStructureAlignment);
		menuStructure.add(menuStructureModel);
		menuStructure.add(menuStructureSuperimpose);

//		menuStructure.add(menuStructureRMSD);
		
//		menuOptions.add(menuOptionsEnvironment);
//		menuGeometry.add(menuBuildTypes);
//		menuGeometry.add(menuMinimize);
//		menuGeometry.add(new JSeparator());
		menuGeometry.add(menuGeometryDistance);
		menuGeometry.add(menuGeometryAngle);
		menuGeometry.add(menuGeometryDihedral);
		menuGeometry.add(new JSeparator());
		menuGeometry.add(menuGeometryHBond);
		menuGeometry.add(menuGeometryBump);
//		menuGeometry.add(menuGeometryMicrospecies);
		menuGeometry.add(new JSeparator());
		menuGeometry.add(menuGeometryOpenMonitors);
		menuGeometry.add(menuGeometryMonitors);
		
		menuHelp.add(menuHelpHelp);
		menuHelp.add(new JSeparator());
		menuHelp.add(menuHelpAbout);
		
		menuBuild.add(menuOptionsOpenBuilder);
		menuBuild.add(new JSeparator());
		menuBuild.add(menuBuildBond);
		menuBuild.add(menuStructureBondOrder);
		menuBuild.add(menuRotateBond);
		menuBuild.add(menuBreakBond);
		menuBuild.add(new JSeparator());
		menuBuild.add(menuBuildReplaceAtom);
		menuBuild.add(menuBuildDeleteAtom);
		menuBuild.add(menuBuildDeleteSelection);
		menuBuild.add(new JSeparator());
		menuBuild.add(menuBuildCharge);
		menuBuild.add(menuBuildHybrid);
		menuBuild.add(new JSeparator());
		menuBuild.add(menuBuildAddH);
		menuBuild.add(menuBuildBonds);
		menuBuild.add(menuBuildOverlaps);
		menuBuild.add(new JSeparator());
		menuBuild.add(menuBuildAddFragment);
//		menuBuild.add(menuBuildTypes);
//		menuBuild.add(menuMinimizeStructure);
//		menuBuild.add(menuStructureDeriveBondOrder);
		return menuBar;
	}
	
	public Vector getEntryListers(){
		return listers;
	}
	
	private Vector listers = new Vector();
	
	public void addEntryLister(EntryLister lister){
		if (listers.contains(lister)) return;
		
		listers.add(lister);
	}
	
	public void removeEntryLister(EntryLister lister){
		if (!listers.contains(lister)) return;
		listers.remove(lister);
	}
	
	private void fileOpen( ){
		if ( jFileChooser == null ){
			jFileChooser = new JFileChooser(this.lastWorkingDirectory);
			String loaders[] = EntryFactory.getFileEntryLoaderNames( );
			FileFilter defaultFilter = null;
			for ( int i=0; i<loaders.length; i++ ){
				final FileEntryLoader loader = EntryFactory.getFileEntryLoader( loaders[i] );
				final String loaderName = loader.getLoaderName( );

				//take care of the upper and lower case extensions
//				for (int j = 0; j < 2; j++){
					FileFilter structureFilter = new FileFilter( ){
						private FileEntryLoader fsLoader = null;
						private String fslName = null;
	
						// public FileFilter( ) // anonymous constructor
						{
							fsLoader = loader;
							fslName = loaderName;
						}
	
						public boolean accept( File file ){
							if ( loader.canLoad( file ) ) return true;
							if ( file.isDirectory() ) return true;
							return false;
						}
						
						public String getDescription( ){
							return loaderName;
						}
					};
					
					jFileChooser.addChoosableFileFilter( structureFilter );
//				}
				if (i == 0){
					defaultFilter = structureFilter;
				}
				
			}
			jFileChooser.addChoosableFileFilter(new FileNameFilter("ras", "RasMol Script File"));
			jFileChooser.setFileFilter(defaultFilter);
		}
		else{
			jFileChooser.setCurrentDirectory(new File(this.lastWorkingDirectory));
		}
		
		int returnVal = jFileChooser.showOpenDialog( applicationFrame );
		if ( returnVal == JFileChooser.APPROVE_OPTION ){
			
			File file = jFileChooser.getSelectedFile( );
			
			loadFile(file);
			
		}
	}
	
	public void loadFile(File f){
		
		if (!f.exists()){
			displayErrorMessage("File either does not exist or is unreadable");
			return;
		}
		
		final File file = f;
		
		//load sequence files in the main thread, since otherwise they crash the JVM on Linux
		if (file.toString().endsWith("aln") || file.toString().endsWith("ALN") || file.toString().endsWith("fst") || 
				file.toString().endsWith("fasta") || file.toString().endsWith("msf")){
			//this is a sequence file
			if (!sequenceOpen){
				//open it first, and then load the file
				openSequencePanel();
			}
		}
		
		Thread runner = new Thread(){
			public void run(){
				
				//check whether ths file is a multipart data
				if (file.toString().endsWith("sdf") || file.toString().endsWith("SDF")
						|| file.toString().endsWith("mol") || file.toString().endsWith("MOL") ){
					SDFEntryLoader loader = new SDFEntryLoader();
					//get the list of items in the file
					//check the file size: if it's more than 500 kb, show splash screen
					Vector headers = loader.readHeaders(file);
					
					
//					System.out.println("headers = " + headers.size());
					if (headers == null){
						parent.displayErrorMessage("Error occurred while reading structure headers");
						return;
					}
					
					if (headers.size() == 0){
						parent.displayErrorMessage("No structure records found");
						return;
					}
					else if (headers.size() == 1){
						Entry e = loader.load(file, 0);
						if (e == null){
							parent.displayErrorMessage("Unable to load structure");
							return;
						}
						
						//check entry
						Structure s = ((StructureEntry)e).getStructure();
						if (s.getStructureMap().getAtomCount() == 0){
							parent.displayErrorMessage("The file appears to be in an incorrect format. No atom records are read.");
							return;
						}

						if (e.getSourceUrl() == null || e.getSourceUrl().equals("null")){//don't translate
							try{
								e.setSourceUrl(file.toURL());
							}
							catch (MalformedURLException ex){}
						}
						addEntry(e, true, true);
					}
					else{
						//fire up a record viewer for the user to select which ones to load
						EntryLister e = new DataListerDialog(applicationFrame, parent, structureDocument, loader, headers, file);
						addEntryLister(e);
					}
					
				}
				else if (file.toString().endsWith("pdb") || file.toString().endsWith("PDB") ){
					//check whether this pdb file contains only one structure or is it an NMR record with multiple
					//models
					PdbEntryLoader loader = new PdbEntryLoader();
					Vector models = loader.readHeaders(file);
//					System.out.println("models = " + models);
					if (models == null || models.size() < 2){
						//regular loader
						try{
							Entry entry = EntryFactory.load( file, -1 );

							if (entry == null){
								displayErrorMessage("Unable to load specified file: " + file.toString());
								return;
							}
					
							//check entry
							Structure s = ((StructureEntry)entry).getStructure();
							if (s.getStructureMap().getAtomCount() == 0){
								parent.displayErrorMessage("The file appears to be in an incorrect format. No atom records are read.");
								return;
							}

							if (entry.getSourceUrl() == null || entry.getSourceUrl().equals("null")){//don't translate
								try{
									entry.setSourceUrl(file.toURL());
								}
								catch (MalformedURLException ex){}
							}
							addEntry(entry, true, true);
						}
						catch (NumberFormatException e){
							displayErrorMessage("Incorrect file format: " + file.toString());
							return;
						}
						
					}
					else{
						//there are multiple models in the file: load a dialog
						EntryLister e = new DataListerDialog(applicationFrame, parent, structureDocument, loader, models, file);
						addEntryLister(e);
					}
					
					
				}
				else if (file.toString().endsWith("ras")){
					//this file is a RasMol script
					if (structureViewer.getLoadedStructures().size() > 0){
						if (JOptionPane.showConfirmDialog(
								applicationFrame, "Currently loaded entries will be closed to load selected RasMol script. Continue?", "Confirmation",
								JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION){
							return;
						}
						else{
							//unload the current view
							structureViewer.removeMonitors();
							try{
								clearEntries(false);
							}
							catch (Exception ex){
								displayExceptionMessage("Exception closing entries", ex);
								return;
							}
						}
					}
					
					loadRasmolFile(file);

				}
				else if (file.toString().endsWith("vsf")){
					
					StateHandler.importState(parent, structureViewer, sequenceViewer, file.toString());
				}
				else{
					Entry entry = null;
					try{
						entry = EntryFactory.load( file, -1 );
					}
					catch (NumberFormatException e){
						displayErrorMessage("Incorrect file format: " + file.toString());
						return;
					}
					catch (Error e){
						System.err.println("Error = " + e);
					}
					
					if (entry == null){
						displayErrorMessage("Unable to load specified file: " + file.toString());
						return;
					}
					
					try{
						//check entry
						Structure s = ((StructureEntry)entry).getStructure();
						if (s.getStructureMap().getAtomCount() == 0){
							parent.displayErrorMessage("The file appears to be in an incorrect format. No atom records are read.");
							return;
						}
					}
					catch (ClassCastException ex){}//this happens if the entry is a sequence - leave it alone
			
					if (entry.getSourceUrl() == null || entry.getSourceUrl().equals("null")){//don't translate
						try{
							entry.setSourceUrl(file.toURL());
						}
						catch (MalformedURLException ex){}
					}
					addEntry(entry, true, true);
				}
				
				//save the used directory
				String dir = file.getParentFile().toString();
				parent.setLastUsedDirectory(dir);
			}
		};
		runner.start();
		
	}
	
	public void displayErrorMessage(String t){
		JOptionPane.showMessageDialog(applicationFrame, t, "Error", JOptionPane.ERROR_MESSAGE);
	}

	public void displayExceptionMessage(String t, Exception ex){
		Object[] options = new Object[2];
		options[0] = "OK";
		options[1] = "Details...";
		int result = JOptionPane.showOptionDialog(applicationFrame, t, "Error", 
				JOptionPane.YES_NO_OPTION, JOptionPane.ERROR_MESSAGE  , null, options, "OK");
		if (result == 1){
			final Exception e = ex;
			Thread tt = new Thread(){
				public void run(){
					StackTraceElement[] stack = e.getStackTrace();
					StringBuffer buffer = new StringBuffer();
					for (int i = 0; i < stack.length; i++){
						buffer.append(stack[i].toString() + "\n");
					}
					MessageDialog d = new MessageDialog(applicationFrame, e.toString() + "\n" + buffer.toString());
				}
			};
			tt.start();
			
		}
	}
	
	public void displayTextMessage(String title, String text){
		final String t = title;
		final String ttt = text;
		Thread tt = new Thread(){
			public void run(){
				MessageDialog d = new MessageDialog(applicationFrame, ttt, t);
			}
		};
		tt.start();
			
	}

	
	
	public void displayWaitScreen(){
		if (w != null){
			w.setVisible(true);
		}
		else{
			w = new SplashWindow(applicationFrame, 300);
		}
	}
	
	public void removeWaitScreen(){
		if (w == null)return;
		w.setVisible(false);
	}
	
	public void displayMessage(String text){
		JOptionPane.showMessageDialog(applicationFrame, text);
	}

	public JFrame getApplicationFrame(){
		return applicationFrame;
	}
	
	public void destructor(){
		prefs.writePreferences();//in case something was changed during this session
		structureViewer.removeMonitors();
		try{
			clearEntries(true);
		}
		catch (Exception ex){
			displayExceptionMessage("Exception closing entries", ex);
		}
		
		System.exit(0);
	}
	
	private void openSequencePanel(){
		
		if (sequenceOpen) return;

		if (searchOpen){

			basePanel.remove(upperSplitDesktop);
			
		    splitDesktop = Factory.createStrippedSplitPane(
		            JSplitPane.VERTICAL_SPLIT,
		            upperSplitDesktop,
		            sequenceViewerComponent,
		            0.8f);
		    
		    if (!menuComponentsOpenSequence.isSelected()){
		    	menuComponentsOpenSequence.setSelected(true);
		    }

		    basePanel.add(splitDesktop, BorderLayout.CENTER);
		    basePanel.revalidate();
		    basePanel.repaint();
		    
		}
		else{
			//no search
			try{
				splitDesktop = Factory.createStrippedSplitPane(
			            JSplitPane.VERTICAL_SPLIT,
			            structureViewerComponent,
			            sequenceViewerComponent,
			            0.8f);
			}
			catch (Error e){
				System.out.println("error = " + e);
			}

		    basePanel.remove(structureViewerComponent);
		    basePanel.add(splitDesktop, BorderLayout.CENTER);
		    basePanel.revalidate();
		    basePanel.repaint();
		}
		
		sequenceOpen = true;
	    menuComponentsOpenSequence.setSelected(true);
		structureDocument.addViewer( sequenceViewer );

	}
	
	public void closeSequencePanel(){
		
		if (searchOpen){
//			System.out.println("search present");
			basePanel.remove(splitDesktop);
			basePanel.add(upperSplitDesktop, BorderLayout.CENTER);
		}
		else {
			basePanel.remove(splitDesktop);
			basePanel.add(structureViewerComponent, BorderLayout.CENTER);
		}
		
		structureDocument.removeViewer( sequenceViewer );
	    menuComponentsOpenSequence.setSelected(false);
	    basePanel.revalidate();
	    repaint();
		sequenceOpen = false;
		
	}

	
	private void openBuilderDialog(){
		if (builderDialog == null){
			builderDialog = new BuilderDialog(applicationFrame, parent);
		}
		else{
			builderDialog.setVisible(true);
		}
		menuOptionsOpenBuilder.setSelected(true);
	}
	
	
	public void closeBuilderDialog(){
		if (builderDialog == null) return;
		builderDialog.setVisible(false);
		menuOptionsOpenBuilder.setSelected(false);
	}
	
	public void openMDPanel(){
		if (mdPanel == null){
			mdPanel = new MDPanel(applicationFrame, structureDocument);
		}
		else{
			mdPanel.setVisible(true);
		}
	}
	
	
	public void closeMDPanel(){
		if (mdPanel == null) return;
		mdPanel.setVisible(false);
		menuComponentsMD.setSelected(false);
	}
	
	
	
	public MDPanel getMDPanel(){
		return mdPanel;
	}

	public void openClusterPanel(Vector list){
		if (clusterPanel == null){
			clusterPanel = new ClusterPanel(applicationFrame, this, list);
		}
		else{
			clusterPanel.setData(list);
			clusterPanel.setVisible(true);
		}
	}
	
	
	public void closeClusterPanel(){
		if (clusterPanel == null) return;
		clusterPanel.destructor();
		clusterPanel = null;
	}
	
	public ClusterPanel getClusterPanel(){
		return clusterPanel;
	}

	
/*	private void openStructureBrowser(){
		if (structureBrowser == null){
			structureBrowser = new StructureBrowser(applicationFrame, parent);
			structureDocument.addViewer(structureBrowser);
		}
		else{
			structureBrowser.setVisible(true);
		}
		menuComponentsStructureBrowser.setSelected(true);
	}
	
	
	public void closeStructureBrowser(){
		if (structureBrowser == null) return;
		structureBrowser.setVisible(false);
		menuComponentsStructureBrowser.setSelected(false);
	}
*/
	private void openDataAccessPanel(){
		if (dataAccessPanel == null){
			dataAccessPanel = new DataAccessPanel(applicationFrame, parent);
		}
		else{
			dataAccessPanel.setVisible(true);
		}
		menuComponentsDataAccess.setSelected(true);
	}
	
	
	public void closeDataAccessPanel(){
		if (dataAccessPanel == null) return;
		dataAccessPanel.setVisible(false);
		menuComponentsDataAccess.setSelected(false);
	}
	
	private void openCommandPanel(){
		if (commandPanel == null){
			commandPanel = new CommandPanel(applicationFrame, parent);
		}
		else{
			commandPanel.setVisible(true);
		}
		menuComponentsCommand.setSelected(true);
	}
	
	
	public void closeCommandPanel(){
		if (commandPanel == null) return;
		commandPanel.setVisible(false);
		menuComponentsCommand.setSelected(false);
	}

	private void openMonitorDialog(){
		if (monitorDialog == null){
			monitorDialog = new MonitorDialog(applicationFrame, parent);
		}
		else{
			monitorDialog.setVisible(true);
		}
		menuGeometryOpenMonitors.setSelected(true);
	}
	
	
	public void closeMonitorDialog(){
		if (monitorDialog == null) return;
		monitorDialog.setVisible(false);
		menuGeometryOpenMonitors.setSelected(false);
	}

	public void updateBuilderDialog(){
		if (builderDialog == null) builderDialog = new BuilderDialog(applicationFrame, parent);
		builderDialog.updatePanels();
	}
	
	public void updateMonitorDialog(){
		if (monitorDialog != null) monitorDialog.updateTree();
	}
	
	public MonitorDialog getMonitorDialog(){
		return monitorDialog;
	}
	
	private void openStructureBrowserPanel(){
		
        if (structureBrowserComponent == null) structureBrowserComponent = buildStructureBrowserComponent();

		//determine the parent of the structureViewerComponent and insert a split pane
		//between it and the structure viewer. the other component in the split pane
		//will be the search panel
		if (sequenceOpen){
			
			//there is sequence viewer displayed
			//remove structureViewerComponent from the top part of the splitDesktop
			basePanel.remove(splitDesktop);

		    upperSplitDesktop = Factory.createStrippedSplitPane(
		            JSplitPane.HORIZONTAL_SPLIT,
		            structureViewerComponent,
		            structureBrowserComponent,
		            0.7f);

		    
		    splitDesktop = Factory.createStrippedSplitPane(
		            JSplitPane.VERTICAL_SPLIT,
		            upperSplitDesktop,
		            sequenceViewerComponent,
		            0.8f);

		    
		    basePanel.add(splitDesktop, BorderLayout.CENTER);
		}
		else {
			
			basePanel.remove(structureViewerComponent);
		    upperSplitDesktop = Factory.createStrippedSplitPane(
		            JSplitPane.HORIZONTAL_SPLIT,
		            structureViewerComponent,
		            structureBrowserComponent,
		            0.7f);

		    //get the upper component of the split pane
		    
		    basePanel.add(upperSplitDesktop, BorderLayout.CENTER);
			
		}
		
	    basePanel.revalidate();
	    repaint();
		menuComponentsStructureBrowser.setSelected(true);
		searchOpen = true;
	}
	
	
	public void closeStructureBrowserPanel(){
		
		if (sequenceOpen){
			
			basePanel.remove(splitDesktop);
			
			splitDesktop = Factory.createStrippedSplitPane(
		            JSplitPane.VERTICAL_SPLIT,
		            structureViewerComponent,
		            sequenceViewerComponent,
		            0.8f);
			basePanel.add(splitDesktop, BorderLayout.CENTER);
			
			
		}
		else {
			basePanel.remove(upperSplitDesktop);
			basePanel.add(structureViewerComponent);
			
		}
		
		basePanel.revalidate();
		repaint();
		menuComponentsStructureBrowser.setSelected(false);
		searchOpen = false;
	}
		
	public void loadIdCodes( ){
		
		//the method is changed to use Web Services
		if (idCodes != null) return;
		
		displayWaitScreen();
		
			
			URL url = null;
			try
			{
				url = new URL( "ftp://beta.rcsb.org/pub/pdb/uniformity/data/mmCIF.gz/all/" );
			}
			catch ( MalformedURLException e )
			{
				removeWaitScreen();
				displayExceptionMessage("Exception retrieving PDB id codes", e);
				return;
			}
			catch (Exception e){
				removeWaitScreen();
				displayExceptionMessage("Exception retrieving PDB id codes", e);
			}

			
			InputStream inputStream = null;
			try
			{
				inputStream = url.openStream( );
			}
			catch ( java.io.IOException e )
			{
				removeWaitScreen();
				displayExceptionMessage("Exception retrieving PDB id codes", e);
				return;
			}
			catch (Exception e){
				removeWaitScreen();
				displayExceptionMessage("Exception retrieving PDB id codes", e);
			}

			InputStreamReader inputStreamReader = new InputStreamReader( inputStream );
			BufferedReader bufferedReader = new BufferedReader( inputStreamReader );
			int available = 0;
			idCodes = new Vector( );
			do
			{
				try
				{
					available = inputStream.available( );
					String line = bufferedReader.readLine( );
					if ( ! line.endsWith( ".gz" ) ) continue;
					int lastSpace = line.lastIndexOf( ' ' );
					line = line.substring( lastSpace+1 );
					int period = line.indexOf( '.' );
					line = line.substring( 0, period );
//					if (line.startsWith("4")){
//						System.out.println("line = " + line);
//					}
					idCodes.add( line );
				}
				catch ( java.io.IOException e )
				{
					removeWaitScreen();
					displayExceptionMessage("Exception retrieving PDB ids", e);
					available = 0;
				}
			} while ( available > 0 );
			
		
//			System.out.println("size = " + idCodes.size());
		removeWaitScreen();

	}

	public void doRcsbLoad(String in)
	{
		
		if ( in == null ){
			displayErrorMessage("Specified structure id not found.");
			return;
		}
		String str = in.toUpperCase();
		pdbId = str.toLowerCase( );
		Thread runner = new Thread(){
			public void run(){
				Status.output( Status.LEVEL_ERROR, "Loading " + pdbId + "...");
				try{
					//check first whether it's an NMR model set
					PdbEntryLoader loader = new PdbEntryLoader();
					URL url = new URL( "http://www.pdb.org/pdb/files/" + pdbId + ".pdb.gz" );
//					System.out.println("url = " + url);
					Vector headers = loader.readHeaders(url);
					
//					System.out.println("Headers = " + headers);
					
					if (headers == null || headers.size() < 2){
						Entry entry = EntryFactory.load( url, -1);
						if (entry == null){
							parent.displayErrorMessage("Unable to load PDB entry. Check the PDB id and try again.");
							Status.progress(0.0f, null);
							return;
						}
						if (entry.TYPE == Entry.STRUCTURE_ENTRY){
							Structure structure = ((StructureEntry)entry).getStructure();
							try{
								StructureMath.updateBondOrders(structure);
							}
							catch (Exception ex){
								parent.displayExceptionMessage("Exception assigning bond orders", ex);
							}
						}
						addEntry( entry, true, true );
					}
					else{
						//it's an NMR set. start the selection dialog
						EntryLister e = new DataListerDialog(applicationFrame, parent, structureDocument, loader, headers, url);
						addEntryLister(e);
					}
				}
				catch ( MalformedURLException e ){
					displayExceptionMessage(e.toString(), e );
				}
				catch (Exception ex){
					displayExceptionMessage("Exception loading a PDB entry", ex);
				}
				Status.output(Status.LEVEL_ERROR, "");
			}
		};
		runner.start();
	}
	
	public boolean isResetView(){
		return resetViewOnLoad;
	}
	
	public void setResetViewOnLoad(boolean reset){
		resetViewOnLoad = reset;
		menuViewResetOnLoad.setSelected(reset);
	}

	public void addEntry( Entry entry, boolean updateDisplay, boolean resetView ){
		if ( entry == null ){
			displayErrorMessage("Unable to load requested entry");
			return;
		}
		
		holdDisplayUpdate = !updateDisplay;
		structureViewer.getGeometryViewer().hold = holdDisplayUpdate;
		
		structureDocument.addEntry( entry );
		
		if (resetView && resetViewOnLoad)structureViewer.resetView();
		
		if (entry.TYPE == Entry.SEQUENCE_ENTRY){
			//check whether the sequence viewer is open. if not, open it
			if (!sequenceOpen){
//				System.out.println("Setting selected");
//				openSequencePanel();
//				menuComponentsOpenSequence.setSelected(true);
			}
		}
		
		//add entry to the close menu
		final JMenuItem item = new JMenuItem(entry.getName());
		FileCloseListener listener = new FileCloseListener(this, structureDocument, entry, item);
		item.addActionListener(listener);
		closeMenu.add(item);
		closeMenu.setEnabled(true);
		closeListeners.add(listener);
		
		if (entry.getSourceUrl() != null && !entry.getSourceUrl().equals("null")){//don't translate
			String t = entry.getSourceUrl().toString();
			if (t.startsWith("file:/")){//don't translate
				setTitle("Sirius 1.2: " + t.substring(6));
			}
			else{
				setTitle("Sirius 1.2: " + entry.getSourceUrl());
			}
		}
	}
	
	public void removeEntry(Entry entry){
		structureDocument.removeEntry(entry);
		if (structureDocument.getEntryCount() == 0){
			setTitle("Sirius 1.2");
		}
		else{
			Entry e = structureDocument.getEntry(0);
			if (e.getSourceUrl() != null && !entry.getSourceUrl().equals("null")){//don't translate
				setTitle("Sirius 1.2: " + e.getSourceUrl());
			}
		}
	}
	
	private boolean holdDisplayUpdate = false;
	
	public boolean getHoldDisplayUpdate(){
		return holdDisplayUpdate;
	}
	
	public void clearHoldDisplayUpdate(){
		holdDisplayUpdate = false;
		structureViewer.getGeometryViewer().hold = false;
		structureViewer.getGeometryViewer().updateView();
	}
	
	public void openSequence(){
		if (!sequenceOpen){
			menuComponentsOpenSequence.setSelected(true);
		}
	}
	
	/**
	 * Called by the structure or sequence viewer when an entry is added or removed internally, without clicking the 
	 * close menu items
	 *
	 */
	public void removeCloseListener(Entry entry){
		for (int i = closeListeners.size()-1; i >= 0; i--){
			FileCloseListener listener = (FileCloseListener)closeListeners.get(i);
			if (entry == listener.getEntry()){
				removeCloseMenuItem(listener);
			}
		}
	}
	
	public void removeCloseMenuItem(FileCloseListener listener){
		closeListeners.remove(listener);
		JMenuItem item = listener.getItem();
		closeMenu.remove(item);
		if (closeListeners.size() == 0) closeMenu.setEnabled(false);
		closeMenu.revalidate();
		closeMenu.repaint();
	}
    
	public void clearEntries(boolean silent){
		
					
		int count = structureDocument.getEntryCount();
		final int start = count - 1;
				
		if (count == 0){
			if (!silent){
				JOptionPane.showMessageDialog(applicationFrame, "No structures are currently loaded", "Error", JOptionPane.ERROR_MESSAGE);
			}
		}
		else{
			//start counting from the end, because after each pass
			//the vector indices move down and the next j ends up
			//where a Structure used to be, but has been moved down as 
			//the previous one got removed
			try{
				for (int j = start; j >= 0; j--){
					Entry ss = structureDocument.getEntry(j);
					structureDocument.removeEntry(ss);
					ss = null;
				}
			}
			catch (Exception ex){
				displayExceptionMessage("Exception removing entries", ex);
			}
		
		}
		
//		SsGeometry.colorReference.clear();
		
		setTitle("Sirius 1.2");
		
		closeListeners.clear();
		closeMenu.setEnabled(false);
		closeMenu.removeAll();
		closeMenu.revalidate();
		closeMenu.repaint();
	}
	
	public void clearStructureEntries(){
		
		int count = structureDocument.getEntryCount();
		int start = count - 1;
				

		if (count > 0){
			//start counting from the end, because after each pass
			//the vector indices move down and the next j ends up
			//where a Structure used to be, but has been moved down as 
			//the previous one got removed
			try{
				for (int j = start; j >= 0; j--){
					Entry ss = structureDocument.getEntry(j);
					if (ss.TYPE == Entry.STRUCTURE_ENTRY || ss.TYPE == Entry.FRAGMENT_ENTRY){
						structureDocument.removeEntry(ss);
					}
					
					String name = ss.getName();
					for (int i = 0; i < closeListeners.size(); i++){
						FileCloseListener a = (FileCloseListener)closeListeners.get(i);
						if (a.getName().equals(name)){
							closeListeners.remove(a);
							closeMenu.remove(a.getItem());
						}
					}
				}
				if (closeListeners.size() == 0) closeMenu.setEnabled(false);
				closeMenu.revalidate();
				closeMenu.repaint();
			}
			catch (Exception ex){
				displayExceptionMessage("Exception removing entries", ex);
			}
		
		}
		
		
		
	}

	public Rectangle getContainerBounds(){
		return new Rectangle(applicationFrame.getX(), applicationFrame.getY(), applicationFrame.getSize().width, applicationFrame.getSize().height);
	}
	
	public DisplayDialog getDisplayDialog(){
		return displayDialog;
	}

	public boolean getDisplayDialogStatus(){
//		System.out.println("dialog status = " + displayDialogStatus);
		return displayDialogStatus;
	}

	public void setBackgroundColor(float[] color){
		structureViewer.setBackgroundColor(color);
	}
	
	public void setSelectionMode(int mode){
		if (mode == StylesPreferences.SELECTION_ATOM){
			menuViewSelectionAtom.setState(true);
			menuViewSelectionResidue.setState(false);
		}
		else{
			menuViewSelectionAtom.setState(false);
			menuViewSelectionResidue.setState(true);
		}
	}

	public void setDisplayDialogStatus(boolean f){
		displayDialogStatus = f;
		if (!f){
			displayDialog = null;
		}
	}
	
	public void setDisplayDialogStatus(boolean f, DisplayDialog displayDialog){
		displayDialogStatus = f;
		if (!f){
			displayDialog = null;
		}
		this.displayDialog = displayDialog;
	}

	public void updateAppearance(){
		structureViewer.updateAppearance();
		sequenceViewer.updateView();
	}
	
	/**
	 * This method is different from updateAppearance, in that it doesn't mark all
	 * renderables as dirty, but only forces the geometry viewer to update the view
	 * by calling its display method.
	 *
	 */
	public void updateView(){
		structureViewer.getGeometryViewer().updateView();
		sequenceViewer.updateView();
		if (structureBrowser != null) structureBrowser.updateView();
	}
	
	public StylesPreferences getPreferences(){
		return prefs;
	}
	
	public StructureViewer getStructureViewer(){
		return structureViewer;
	}
	
	public SequenceViewer getSequenceViewer(){
		return sequenceViewer;
	}
	
	public StructureBrowser getStructureBrowser(){
		return structureBrowser;
	}
	
	public static void main(String[] args){
				
    	final Viewer viewer = new Viewer();
    	if (args.length > 0){
    		if (args[0].endsWith("vsf")){
    			//it's a state file
    			final String fname = args[0];
    			Thread runner = new Thread(){
    				public void run(){
    					StateHandler.importState(viewer, viewer.structureViewer, viewer.sequenceViewer, fname);
    				}
    			};
    			runner.start();
    		}
    		else{
    			viewer.loadFile(new File(args[0]));
    		}
	    }
		
     }
	

	public void loadFragment(String id){
		Entry entry = EntryFactory.loadFragment(id);
		String loaded = entry.getName();
		//check whether there are already entries with the same name.
		//if so, add a numeric extension
		boolean load = true;
		int identicals = 0;
		Vector entries = structureDocument.getEntryNames();
		for (int i = 0; i < entries.size(); i++){
			String name = (String)entries.get(i);
			if (name.startsWith(loaded)){
				if (name.equals(loaded)){
					identicals++;
					load = false;
				}
				else if (name.startsWith(loaded + "_")){
					identicals++;
					load = false;
				}
				
			}
		}
		
		if (!load){
			//append the number
			loaded += "_" + (new Integer(identicals)).toString();
			entry.setName(loaded);
		}
		
		addEntry(entry, true, false);
	}
	
	private String getStateFilename(){
		
		if (structureDocument.getEntryCount() == 0){
			displayErrorMessage("No structures are currently loaded");
			return null;
		}
		
		//get the desired file name
		JFileChooser chooser = new JFileChooser(this.lastWorkingDirectory);
		chooser.setDialogTitle("Export state of display");

		chooser.setDialogType(JFileChooser.SAVE_DIALOG);

		
		chooser.addChoosableFileFilter( new FileNameFilter("vsf", "VSF View State Format") );
		
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		int result = chooser.showSaveDialog(applicationFrame);
		if (result == JFileChooser.CANCEL_OPTION){
			return null;
		}
		File filename = chooser.getSelectedFile();
		this.lastWorkingDirectory = filename.getParent();
		String fname = filename.toString();
		
		int dot = fname.lastIndexOf(".");
		
		//get the desired file type
		FileFilter filter = chooser.getFileFilter();
		
		if (dot <= 0){
			//no extension supplied
			fname += "." + filter.toString();
		}
		
		//if typed name doesn't match selected format, go with the typed/formed string anyway
		//respect user's judgement :)
		
		File f = new File(fname);
		if (f.exists()){
			if (f.isDirectory()){
				displayErrorMessage("Selected destination is a directory");

			}
			if (!f.canWrite()){
				displayErrorMessage("Selected file is not writable");
			}
			else{
				//ask the user if it's ok to overwrite the file
				if (JOptionPane.showConfirmDialog(
						applicationFrame, "File with this name exists. Overwrite?", "Confirmation",
						JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION){
					return null;
				}
			}
		}
		
		//output file does not exist. check if the directory is writable
		String path = f.getPath();
		String fsep = File.separator;
		int separatorIndex = path.lastIndexOf(fsep);
		if (separatorIndex < 1){
			//entered file is in the current directory
			File currentDir = new File(".");
			if (!currentDir.canWrite()){
				parent.displayErrorMessage("Current directory is not writable");
			}
		}
		else{
			//entered file is in another directory
			String out_dir = path.substring(0,separatorIndex);
			File outDir = new File(out_dir);
			if (!outDir.canWrite()){
				parent.displayErrorMessage("Output directory is not writable");
			}
		}
		
		return fname;
		
	}
	
	private void openState(){
		
		if (structureDocument.getEntryCount() > 0){
			if (JOptionPane.showConfirmDialog(
					applicationFrame, "Currently loaded entries will be closed to load the view. Continue?", "Confirmation",
					JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION){
				return;
			}
			else{
				//unload the current view
				structureViewer.removeMonitors();
				try{
					clearEntries(false);
				}
				catch (Exception ex){
					displayExceptionMessage("Exception closing entries", ex);
					return;
				}
				
			}
		}
		
		
		JFileChooser chooser = new JFileChooser(this.lastWorkingDirectory);
		chooser.setDialogType(JFileChooser.OPEN_DIALOG);
		chooser.setDialogTitle("Import state of display");


		
		chooser.addChoosableFileFilter( new FileNameFilter("vsf", "VSF View State Format") );
		
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		int result = chooser.showSaveDialog(applicationFrame);
		if (result == JFileChooser.CANCEL_OPTION){
			return;
		}
		File filename = chooser.getSelectedFile();
		this.lastWorkingDirectory = filename.getParent();
		String fname = filename.toString();
		
		StateHandler.importState(this, structureViewer, sequenceViewer, fname);
		
	}
	

	
	public void updateBoundWaters(){
		structureViewer.updateBoundWaters(true);
	}
	
	public void updateMouseResponse(int f){
		structureViewer.updateMouseResponse(f);
	}
	
	public void setSeparateMotion(boolean flag){
		menuViewMotionSeparate.setSelected(flag);
		menuViewMotionCommon.setSelected(!flag);
	}
	
	public void setActiveSearchServicePanel(SearchServicePanel panel){
		activeSearchServicePanel = panel;
	}
	
	public SearchServicePanel getActiveSearchServicePanel(){
		return activeSearchServicePanel;
	}
	
	public void setUndo(boolean enabled){
		menuViewUndo.setEnabled(enabled);
	}
	
	public void updateToolbar(){
		if (StylesPreferences.showToolbarTips){
			openButton.setToolTipText("Open file");
			if (pdbButton != null) pdbButton.setToolTipText("Load structure from PDB");
			saveButton.setToolTipText("Save structure");
			clearButton.setToolTipText("Close all");
			if (displayButton != null) displayButton.setToolTipText("Structure visibility");
			if (renderButton != null) renderButton.setToolTipText("Structure rendering");
			if (colorButton != null) colorButton.setToolTipText("Structure coloring");
			if (labelsButton != null) labelsButton.setToolTipText("Atom labels");
			if (centerButton != null) centerButton.setToolTipText("Center view");
			if (separateButton != null) separateButton.setToolTipText("Set independent motion");
			if (commonButton != null) commonButton.setToolTipText("Set common motion");
			if (distanceButton != null) distanceButton.setToolTipText("Measure distance");
			if (angleButton != null) angleButton.setToolTipText("Measure bond angle");
			if (dihedralButton != null) dihedralButton.setToolTipText("Measure dihedral angle");
			if (fogButton != null) fogButton.setToolTipText("Depth perception");
			if (resetButton != null) resetButton.setToolTipText("Reset view");
			if (preferencesButton != null) preferencesButton.setToolTipText("Preferences");
		}
		else{
			openButton.setToolTipText(null);
			if (pdbButton != null) pdbButton.setToolTipText(null);
			saveButton.setToolTipText(null);
			clearButton.setToolTipText(null);
//			if (undoButton != null) undoButton.setToolTipText(null);
			if (displayButton != null) displayButton.setToolTipText(null);
			if (renderButton != null) renderButton.setToolTipText(null);
			if (colorButton != null) colorButton.setToolTipText(null);
			if (labelsButton != null) labelsButton.setToolTipText(null);
			if (centerButton != null) centerButton.setToolTipText(null);
			if (separateButton != null) separateButton.setToolTipText(null);
			if (commonButton != null) commonButton.setToolTipText(null);
			if (distanceButton != null) distanceButton.setToolTipText(null);
			if (angleButton != null) angleButton.setToolTipText(null);
			if (dihedralButton != null) dihedralButton.setToolTipText(null);
			if (fogButton != null) fogButton.setToolTipText(null);
			if (resetButton != null) resetButton.setToolTipText(null);
			if (preferencesButton != null) preferencesButton.setToolTipText(null);
		}
		
		if (StylesPreferences.displayToolbar){
			
			//check if toolbar layout needs to be updated
			if (StylesPreferences.toolbarChanged){
				
				toolBar.removeAll();
				
				toolBar.add(openButton);
				if (StylesPreferences.toolbarPDB){
					if (pdbButton == null){
				    	ImageIcon iconPdb = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/open_pdb.gif"));//don't translate
				    	Action pdbAction = new AbstractAction("PDB...", iconPdb){
				    		public void actionPerformed(ActionEvent e){
				    			loadPdbAction();
				    		}
				    	};
				    	pdbButton = toolBar.add(pdbAction);
				    	pdbButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) pdbButton.setToolTipText("Load structure from PDB");
					}
					else{
						toolBar.add(pdbButton);
					}
				}
				toolBar.add(saveButton);
				toolBar.add(clearButton);
				
/*				if (StylesPreferences.toolbarUndo){
					if (undoButton == null){
				    	ImageIcon iconUndo = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/undo.gif"));
				    	Action undoAction = new AbstractAction("Undo last change", iconUndo){
				    		public void actionPerformed(ActionEvent e){
				    			undoAction();
				    		}
				    	};
				    	undoButton = toolBar.add(undoAction);
				    	undoButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) undoButton.setToolTipText("Undo last change");
					}
					else{
						toolBar.add(undoButton);
					}
				}
*/				if (StylesPreferences.toolbarVisibility){
					if (displayButton == null){
			    		ImageIcon iconDisplay = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/hide_show.gif"));//don't translate
			    		Action displayAction = new AbstractAction("Display", iconDisplay){
			    			public void actionPerformed(ActionEvent e){
			    				displayAction();
			    			}
			    		};
				    	displayButton = toolBar.add(displayAction);
				    	displayButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) displayButton.setToolTipText("Structure visibility");
						
					}
					else{
						toolBar.add(displayButton);
					}
				}
				if (StylesPreferences.toolbarRendering){
					if (renderButton == null){
				    	ImageIcon iconRender = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/struct_render.gif"));//don't translate
				    	Action renderAction = new AbstractAction("Rendering", iconRender){
				    		public void actionPerformed(ActionEvent e){
				    			renderingAction();
				    		}
				    	};
				    	renderButton = toolBar.add(renderAction);
				    	renderButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) renderButton.setToolTipText("Structure rendering");
					}
					else{
						toolBar.add(renderButton);
					}
				}
				if (StylesPreferences.toolbarColoring){
					if (colorButton == null){
				    	ImageIcon iconColor = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/struct_color.gif"));//don't translate
				    	Action colorAction = new AbstractAction("Color", iconColor){
				    		public void actionPerformed(ActionEvent e){
				    			colorAction();
				    		}
				    	};
				    	colorButton = toolBar.add(colorAction);
				    	colorButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) colorButton.setToolTipText("Structure coloring");
					}
					else{
						toolBar.add(colorButton);
					}
				}
				if (StylesPreferences.toolbarLabels){
					if (labelsButton == null){
				    	ImageIcon iconLabel = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/labels.gif"));//don't translate
				    	Action labelAction = new AbstractAction("Color", iconLabel){
				    		public void actionPerformed(ActionEvent e){
				    			labelAction();
				    		}
				    	};
				    	labelsButton = toolBar.add(labelAction);
				    	labelsButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) labelsButton.setToolTipText("Atom labels");
					}
					else{
						toolBar.add(labelsButton);
					}
				}

				if (StylesPreferences.toolbarCenter){
					if (centerButton == null){
				    	ImageIcon iconCenter = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/center_view.gif"));//don't translate
				    	Action centerAction = new AbstractAction("Center view", iconCenter){
				    		public void actionPerformed(ActionEvent e){
				    			centerAction();
				    		}
				    	};
				    	centerButton = toolBar.add(centerAction);
				    	centerButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) centerButton.setToolTipText("Center view");
					}
					else{
						toolBar.add(centerButton);
					}
				}
				if (StylesPreferences.toolbarSeparate){
					if (separateButton == null){
				    	ImageIcon iconSeparate = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/motion_separate.gif"));//don't translate
				    	Action separateAction = new AbstractAction("Separate motion", iconSeparate){
				    		public void actionPerformed(ActionEvent e){
				    			separateMotionAction();
				    		}
				    	};
				    	separateButton = toolBar.add(separateAction);
				    	separateButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) separateButton.setToolTipText("Set independent motion");
					}
					else{
						toolBar.add(separateButton);
					}
				}
				if (StylesPreferences.toolbarCommon){
					if (commonButton == null){
				    	ImageIcon iconCommon = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/motion_common.gif"));//don't translate
				    	Action commonAction = new AbstractAction("Common motion", iconCommon){
				    		public void actionPerformed(ActionEvent e){
				    			commonMotionAction();
				    		}
				    	};
					   	commonButton = toolBar.add(commonAction);
					   	commonButton.setMargin(new Insets(0,0,0,0));
					   	if (StylesPreferences.showToolbarTips) commonButton.setToolTipText("Set common motion");
					}
					else{
						toolBar.add(commonButton);
					}
				}
				if (StylesPreferences.toolbarDistance){
					if (distanceButton == null){
				    	ImageIcon iconDistance = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/distance.gif"));//don't translate
				    	Action distanceAction = new AbstractAction("Measure distance", iconDistance){
				    		public void actionPerformed(ActionEvent e){
				    			distanceAction();
				    		}
				    	};
				    	distanceButton = toolBar.add(distanceAction);
				    	distanceButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) distanceButton.setToolTipText("Measure distance");
					}
					else{
						toolBar.add(distanceButton);
					}
				}
				if (StylesPreferences.toolbarAngle){
					if (angleButton == null){
				    	ImageIcon iconAngle = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/angle.gif"));//don't translate
				    	Action angleAction = new AbstractAction("Measure bond angle", iconAngle){
				    		public void actionPerformed(ActionEvent e){
				    			angleAction();
				    		}
				    	};
				    	angleButton = toolBar.add(angleAction);
				    	angleButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) angleButton.setToolTipText("Measure bond angle");
					}
					else{
						toolBar.add(angleButton);
					}
				}
				if (StylesPreferences.toolbarDihedral){
					if (dihedralButton == null){
				    	ImageIcon iconDihedral = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/dihedralangle.gif"));//don't translate
				    	Action dihedralAction = new AbstractAction("Measure dihedral angle", iconDihedral){
				    		public void actionPerformed(ActionEvent e){
				    			dihedralAngleAction();
				    		}
				    	};
				    	dihedralButton = toolBar.add(dihedralAction);
				    	dihedralButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) dihedralButton.setToolTipText("Measure dihedral angle");
					}
					else{
						toolBar.add(dihedralButton);
					}
				}
				
				if (resetButton == null){
				   	ImageIcon iconReset = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/reset_view.gif"));//don't translate
			    	Action resetAction = new AbstractAction("Reset view", iconReset){
			    		public void actionPerformed(ActionEvent e){
			    			resetAction();
			    		}
			    	};
			    	resetButton = toolBar.add(resetAction);
			    	resetButton.setMargin(new Insets(0,0,0,0));
			    	if (StylesPreferences.showToolbarTips) resetButton.setToolTipText("Reset view");
				}
				else{
					toolBar.add(resetButton);
				}
		    	
				if (StylesPreferences.toolbarFog){
					if (fogButton == null){
					   	ImageIcon iconFog = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/fog.gif"));//don't translate
				    	Action fogAction = new AbstractAction("Depth perception", iconFog){
				    		public void actionPerformed(ActionEvent e){
				    			fogAction();
				    		}
				    	};
				    	fogButton = toolBar.add(fogAction);
				    	fogButton.setMargin(new Insets(0,0,0,0));
				    	if (StylesPreferences.showToolbarTips) fogButton.setToolTipText("Depth perception");
					}
					else{
						toolBar.add(fogButton);
					}
				}

				if (preferencesButton == null){
				   	ImageIcon iconPreferences = new ImageIcon(getClass().getResource("/edu/sdsc/sirius/image/toolbar/preferences.gif"));//don't translate
			    	Action preferencesAction = new AbstractAction("Preferences", iconPreferences){
			    		public void actionPerformed(ActionEvent e){
			    			preferencesAction();
			    		}
			    	};
			    	preferencesButton = toolBar.add(preferencesAction);
			    	preferencesButton.setMargin(new Insets(0,0,0,0));
			    	if (StylesPreferences.showToolbarTips) preferencesButton.setToolTipText("Preferences");
				}
				else{
					toolBar.add(preferencesButton);
				}
				
				StylesPreferences.toolbarChanged = false;
			}
			
			if (!toolbarAdded){
				if (StylesPreferences.toolbarPosition == StylesPreferences.POSITION_LEFT){
					toolBar.setOrientation(JToolBar.VERTICAL);
					structurePanel.add(BorderLayout.WEST, toolHolder);
					DialogConstants.toolbarWidth = toolBar.getPreferredSize().width;
					DialogConstants.toolbarHeight = 0;
				}
				else{
					toolBar.setOrientation(JToolBar.HORIZONTAL);
					structurePanel.add(BorderLayout.NORTH, toolHolder);
					DialogConstants.toolbarWidth = 0;
					DialogConstants.toolbarHeight = toolBar.getPreferredSize().height;

				}
				toolbarAdded = true;
				structurePanel.revalidate();
			}
			else{
				
				//change its orientation if necessary
				int orientation = toolBar.getOrientation();
				if (orientation == JToolBar.VERTICAL && StylesPreferences.toolbarPosition == StylesPreferences.POSITION_TOP){
					//relocate toolbar to the top
					structurePanel.remove(toolHolder);
					toolBar.setOrientation(JToolBar.HORIZONTAL);
					structurePanel.add(BorderLayout.NORTH, toolHolder);
					DialogConstants.toolbarWidth = 0;
					DialogConstants.toolbarHeight = toolBar.getPreferredSize().height;
					structurePanel.revalidate();
				}
				else if (orientation == JToolBar.HORIZONTAL && StylesPreferences.toolbarPosition == StylesPreferences.POSITION_LEFT){
					//relocate to the left
					structurePanel.remove(toolHolder);
					toolBar.setOrientation(JToolBar.VERTICAL);
					structurePanel.add(BorderLayout.WEST, toolHolder);
					DialogConstants.toolbarWidth = toolBar.getPreferredSize().width;
					DialogConstants.toolbarHeight = 0;
					structurePanel.revalidate();
				}

			}
			
			repaint();
		}
		else{
			if (toolbarAdded){
				//remove it
				structurePanel.remove(toolHolder);
				toolbarAdded = false;
				structurePanel.revalidate();
				DialogConstants.toolbarWidth = 0;
				DialogConstants.toolbarHeight = 0;
			}
		}
		
	}
	
	public void displayRamachandranPlot(Structure structure){

		boolean result = structure.getStructureMap().computePhiPsi();
		if (!result){
			displayErrorMessage("Selected structure contains no amino acids.");
			return;
		}
		
		//check whether this structure already has a rama viewer
		Set keys = ramaReference.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			try{
				RamachandranViewer v = (RamachandranViewer)it.next();
				if (v.getStructure() == structure){
					displayErrorMessage("A Ramachandran Plot for selected structure is already displayed");
					return;
				}
			}
			catch (Exception ex){}
		}
		
		//launch the viewer
		RamachandranViewer rv = new RamachandranViewer( structure );
		structureDocument.addViewer( rv );
		RamachandranViewerDialog d = new RamachandranViewerDialog(applicationFrame, rv);
		ramaReference.put(rv, d);

	}
	
	public void displayContactMap(Structure structure, Structure structure21){

		//check whether this structure already has a rama viewer
		Set keys = ramaReference.keySet();
		Iterator it = keys.iterator();
		while (it.hasNext()){
			try{
				RamachandranViewer v = (RamachandranViewer)it.next();
				if (v.getStructure() == structure){
					displayErrorMessage("A Ramachandran Plot for selected structure is already displayed");
					return;
				}
			}
			catch (Exception ex){}
		}
		
		//launch the viewer
		RamachandranViewer rv = new RamachandranViewer( structure );
		structureDocument.addViewer( rv );
		RamachandranViewerDialog d = new RamachandranViewerDialog(applicationFrame, rv);
		ramaReference.put(rv, d);

	}

	
	public boolean getSuperimpose(){
		return superimpose;
	}
	
	public void setSuperimpose(boolean flag){
		superimpose = flag;
	}
	
	public void renameEntry(Entry e, String name){
		//now revalidate the relevant close menu
		for (int i = 0; i < closeListeners.size(); i++){
			FileCloseListener a = (FileCloseListener)closeListeners.get(i);
			if (a.getName().equals(e.getName())){
				a.setName(name);
				JMenuItem item = a.getItem();
				item.setText(name);
				closeMenu.revalidate();
				closeMenu.repaint();
				break;
			}
		}
		structureDocument.renameEntry(e, name);
		
	}
	
	/**
	 * This method is called by element palette to set element selection
	 */
	public void setElement(String element){
		structureViewer.selectByElement(element);
	}
	
	
	/**
	 * put on hold for now...
	 *
	 */
	private void updater(){
		
		Thread runner = new Thread(){

			public void run(){
				
				displayWaitScreen();

				//read the preferences first
				Preferences prefs = Preferences.userRoot();
				Preferences node = prefs.node("/edu/sdsc/sirius/config");//don't translate
				String releaseDate = node.get("releaseDate", "10012006");
				String installDir = node.get("installDir", "");
	
				//get the record from the server
				
				
				
				removeWaitScreen();
			}
			
		};
		
		runner.start();
	}
	
	public void openImagePreviewPanel(String f){
		
		final String filename = f;
		
		//open the output file in a panel to show the result to the user
		Thread runner = new Thread(){
			public void run(){
				if (imagePreviewPanel == null){
					imagePreviewPanel = new ImagePreviewPanel(applicationFrame, parent, filename);
				}
				else{
					imagePreviewPanel.updateContent(filename);
				}
			}
		};
		runner.start();

	}
	
	public void closeImagePreviewPanel(){
		imagePreviewPanel.setVisible(false);
		imagePreviewPanel.dispose();
		imagePreviewPanel = null;
	}
	
	private void loadRasmolFile(File file){
		
		//read the file line by line and perform the described action
		try{
			StringBuffer result = new StringBuffer();
			BufferedReader reader = new BufferedReader(new FileReader(file));
			String line = null;
			while ((line = reader.readLine()) != null){
				String outcome = rasmolReader.readLine(this, line, file.getAbsolutePath(), true);
				if (outcome != null){
					result.append(outcome);
					result.append("\n");
					
					if (outcome.startsWith("load")){//don't translate
						displayErrorMessage("Errors loading the structure specified in the script");
						break;
					}
				}
			}
			
			rasmolReader.clearSelection();
			rasmolReader.clear();
			
			if (result.length() > 0){
				displayTextMessage("RasMol script import errors", result.toString());
			}
		}
		catch (Exception ex){
			displayExceptionMessage("Exception reading a rasmol script", ex);
		}
		
	}
	
	public RasmolReader getRasmolReader(){
		return rasmolReader;
	}
	
	public void openContactMapViewer(Structure structure1, Structure structure2){
		if (contactMapViewer == null){
			contactMapViewer = new ContactMapViewer(this);
			structureDocument.addViewer(contactMapViewer);
		}
		
		contactMapViewer.setStructures(structure1, structure2);
		contactMapViewer.setVisible(true);
		
	}
	
	/**
	 * This method takes the path to the temp directory where homology model was built
	 * @param path - path to the new pdb file directory
	 * The new pdb file is loaded with the original name, but the existing (presumably, aligned)
	 * sequence is preserved and reset after the structure is aligned, to keep the previous alignment
	 * intact. The previous sequence is unloaded.
	 */
	public void processHomologyModel(String path, String original, int start, int end){
//		System.out.println("Processing model in " + path);
//		System.out.println("original = " + original);
		
		//get the path to the file
		File dir = new File(path);
		File[] files = dir.listFiles();
		File model = null;
		for (int i = 0; i < files.length; i++){
			String n = files[i].getName();
			if (n.startsWith("model") && n.endsWith("pdb")){//don't translate
				//this is the file
				model = files[i];
				break;				
			}
		}
		
		if (model == null || !model.exists()){
			displayErrorMessage("Homology model not found. Try again.");
			return;
		}
		
		//save the original sequence for the initial entry
		Vector sequences = this.getSequenceViewer().getSequenceObjects();
		Sequence target = null;
		for (int i = 0; i < sequences.size(); i++){
			Sequence s = (Sequence)sequences.get(i);
			if (s.getName().equals(original)){
				//use this sequence and delete it afterwards
				target = s;
				break;
			}
		}
		
		if (target == null){
			displayErrorMessage("Unable to associate the model with a loaded sequence.");
			return;
		}
		
		SequenceViewer sv = getSequenceViewer();
		String sequence = target.getSequence();
		Entry doomed = sv.getEntry(target);
		
		PdbEntryLoader loader = new PdbEntryLoader();
		if (!loader.canLoad(model)){
			displayErrorMessage("Unable to load model PDB file");
			return;
		}
		
		StructureEntry e = (StructureEntry)loader.load(model, -1);
		e.setName(original);
		Structure structure = e.getStructure();

		//load it without resetting the view
		addEntry(e, true, false);
		
		
		//updateSequence method in SequenceViewer
		//first, find what Sequence object is assigned to the newly loaded Structure
		for (int i = 0; i < sv.getSequenceObjects().size(); i++){
			Sequence ss = (Sequence)sv.getSequenceObjects().get(i);
			if (sv.getStyleMap().containsKey(ss)){
				//check whether it's this Structure
				StructureStyles styles = (StructureStyles)getSequenceViewer().getStyleMap().get(ss);
				if (styles.getStructureMap().getStructure() == structure){
					//this is the one
					//update its sequence
					sv.updateSequenceFromHomologyModel(ss, sequence, start, end);
					break;
				}
			}
		}
		
		
		//unload the original
		sv.clearCellSelection(false);
//		System.out.println("removing " + doomed);
		structureDocument.removeEntry(doomed);
		
		//rerun sequence alignment
		sv.performAlignment();
		
		//delete the temporary directory
		File temp = new File(path);
		File[] list = temp.listFiles();
		for (int i = 0; i < list.length; i++){
			list[i].delete();
		}
		temp.delete();
		
		this.updateView();
	}
	
	
}