//$Id: AboutDialog.java,v 1.3 2007/05/05 01:30:04 Sasha Buzko Exp $
//
//Copyright (c) 2000-2003 San Diego Supercomputer Center (SDSC),
//a facility operated jointly by the University of California,
//San Diego (UCSD) and General Atomics, San Diego, California, USA.
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software. License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC. This source is provided "AS IS" without express
//or implied warranty of any kind.
// 
//For further information, please see: <http://mbt.sdsc.edu>
// 
//History:
//$Log: AboutDialog.java,v $
//Revision 1.3  2007/05/05 01:30:04  Sasha Buzko
//*** empty log message ***
//
//Revision 1.2  2006/10/21 18:41:25  Sasha Buzko
//*** empty log message ***
//
//Revision 1.1  2006/10/21 17:52:13  Sasha Buzko
//Refactored the project to move all new code to edu.sdsc.sirius package.
//
//Revision 1.1  2006/05/20 17:02:00  Sasha Buzko
//Updated version
//
//Revision 1.1  2006/04/30 20:13:56  Sasha Buzko
//New version of the app
//
//Revision 1.1  2006/04/15 19:42:18  Sasha Buzko
//Initial commit
//
//Revision 1.2  2006/02/05 22:01:43  Administrator
//*** empty log message ***
//
//Revision 1.1  2005/11/13 04:35:23  Administrator
//*** empty log message ***
//
//Revision 1.2 2003/05/15 23:44:54 moreland
//Cleaned up code a bit for a preliminary release to obuzko.
//
//Revision 1.1 2003/05/15 22:42:45 moreland
//An application which incorporates more MBT GUI layer components.
//
//Revision 1.0 2003/05/05 16:06:13 moreland
//First version.
// 

package edu.sdsc.sirius.dialogs;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.net.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import edu.sdsc.sirius.util.BrowserControl;
import edu.sdsc.sirius.util.BrowserLauncher;

public class AboutDialog extends JDialog {
	
	private JFrame parent = null;
	private JDialog parentDialog = null;
	private String message = null;
	
	private Container contentPane = null;
	private JScrollPane scrollPane = null;
	private JEditorPane textPane = null;
	
	public AboutDialog(JFrame parent, String message){
		
		super(parent, "About Sirius", true);
		this.parent = parent;
		if (message != null){
			this.message = message;
			setTitle("Message");
		}
		initialize();
	}
	
	public AboutDialog(JDialog parent, String message){
		
		super(parent, "About GemViewer", true);
		this.parentDialog = parent;
		if (message != null){
			this.message = message;
			setTitle("Message");
		}
		
		initialize();
	}
	
	private void initialize(){
		contentPane = getContentPane();
		
		JPanel base = new JPanel();
		base.setLayout(new BorderLayout());
		
		JPanel messagePanel = new JPanel();
		messagePanel.setLayout(new BorderLayout());
//		messagePanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		
		textPane = new JEditorPane();
		textPane.setSelectionColor(new Color(0,50,190));
		textPane.setBackground(Color.WHITE);
		textPane.setEditable(false);
		if (message != null){
			textPane.setText(message);
		}
		else{
			try{
				URL u = getClass().getResource("/edu/sdsc/sirius/dialogs/misc/about_explorer.html");
				textPane.setPage(u);
				textPane.addHyperlinkListener(new Hyperactive());
			}
			catch (Exception ex){
				System.out.println("Exception: " + ex);
			}
		}
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				if (message != null){
					textPane.setText(message);
				}
				else{
					try{
						URL u = getClass().getResource("/edu/sdsc/sirius/dialogs/misc/about_explorer.html");
						textPane.setPage(u);
						textPane.addHyperlinkListener(new Hyperactive());
					}
					catch (Exception ex){
						System.out.println("Exception: " + ex);
					}
				}
			}
		});
		scrollPane = new JScrollPane();
		JViewport vp = scrollPane.getViewport();
		vp.setView(textPane);
		
		messagePanel.add(scrollPane, BorderLayout.CENTER);
		
		JPanel buttonPanel = new JPanel();
		
		JButton button = new JButton("OK");
		button.setPreferredSize(new Dimension(70,25));
		button.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				if (message != null){
					textPane.setText(message);
				}
				else{
					try{
						textPane.setPage(getClass().getResource("/edu/sdsc/sirius/dialogs/misc/about_explorer.html"));
						textPane.addHyperlinkListener(new Hyperactive());
					}
					catch (Exception ex){
						System.out.println("Exception: " + ex);
					}
				}
			}
		});
		buttonPanel.add(button);
		
		base.add(messagePanel, BorderLayout.CENTER);
		base.add(buttonPanel, BorderLayout.SOUTH);
		
		contentPane.add(base);
		
		setSize(410,410);
		
		setLocationRelativeTo(null);
		
//		setVisible(true);
		
		
	}
	
//	public static void main(String[] args){
//		AboutDialog d = new AboutDialog((JFrame)null, null);
//	}

	class Hyperactive implements HyperlinkListener {
		 
         public void hyperlinkUpdate(HyperlinkEvent e) {
 	          if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
 		      JEditorPane pane = (JEditorPane) e.getSource();
 		      final URL address = e.getURL();
 		      if (e instanceof HTMLFrameHyperlinkEvent) {
 		          HTMLFrameHyperlinkEvent  evt = (HTMLFrameHyperlinkEvent)e;
 		          HTMLDocument doc = (HTMLDocument)pane.getDocument();
 		          doc.processHTMLFrameHyperlinkEvent(evt);
 		      } else {
 		          try {
 					Thread runner = new Thread(){
 						public void run(){
 							try{	
 								String os = System.getProperty("os.name");
 								if (os.startsWith("Win")){
//		 									System.out.println("Using BrowserControl...");
 									BrowserControl.displayURL(address.toString());
 								}
 								else{
//		 									System.out.println("Using BrowserLauncher...");
 									BrowserLauncher.openURL(address.toString());
 								}
 							}
 							catch (Exception e){
 								JOptionPane.showMessageDialog(AboutDialog.this, "Unable to display the requested address.", "Error", JOptionPane.ERROR_MESSAGE);
 								return;
 							}
 						}
 					};
 					runner.start();
 		          } catch (Throwable t) {
 			      t.printStackTrace();
 		          }
 		      }
 	          }
 	      }
     }

		 


}