package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.search.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.util.DialogLayout;

import java.util.*;

public class AlignmentSettingsDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private Border border1 = null;
	private TitledBorder border2 = null;
	private Border border = null;

	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
		
	public AlignmentSettingsDialog(JFrame f, Manager p){
	
		super(f, "Change alignment settings", true);
	
		parentFrame = f;
		parent = p;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		JPanel basePanel = new JPanel();
		basePanel.setPreferredSize(new Dimension(310, 190));
		basePanel.setBorder(new BevelBorder(BevelBorder.RAISED));
		basePanel.setLocation(new Point(5,5));
		basePanel.setBounds(5, 5, 310, 190);
		basePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " BLAST settings ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		
		base.setPreferredSize(new Dimension(300, 180));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 300, 180);
		base.setLayout(new DialogLayout());
		base.setBorder(border);

		JLabel a1 = new JLabel("Matrix:");
		JLabel a2 = new JLabel("Expectation:");
		JLabel a3 = new JLabel("Number of scores:");
		JLabel a4 = new JLabel("Number of alignments:");
		JLabel a5 = new JLabel("Sensitivity:");
		JLabel a6 = new JLabel("Filter:");
		JLabel a7 = new JLabel("Sort order:");
		JLabel a8 = new JLabel("Statistics:");
		
		Vector matrix = new Vector();
		matrix.add("blosum62");
		matrix.add("blosum30");
		matrix.add("blosum35");
		matrix.add("blosum50");
		matrix.add("blosum100");
		matrix.add("pam10");
		matrix.add("pam20");
		matrix.add("pam50");
		matrix.add("pam100");
		matrix.add("pam500");

		final JComboBox b1 = new JComboBox(matrix);
		b1.setPreferredSize(new Dimension(80,20));
		b1.setSelectedItem(BlastSettings.matrix);
		
		Vector exp = new Vector();
		exp.add("1.0");
		exp.add("10");
		exp.add("100");
		exp.add("1000");
		
		final JComboBox b2 = new JComboBox(exp);
		b2.setPreferredSize(new Dimension(80,20));
		if (BlastSettings.exp == 1.0){
			b2.setSelectedIndex(0);
		}
		else if (BlastSettings.exp == 10){
			b2.setSelectedIndex(1);
		}
		else if (BlastSettings.exp == 100){
			b2.setSelectedIndex(2);
		}
		else if (BlastSettings.exp == 1000){
			b2.setSelectedIndex(3);
		}
		
		
		Vector sensitivity = new Vector();
		sensitivity.add("low");
		sensitivity.add("medium");
		sensitivity.add("normal");
		sensitivity.add("high");
		
		final JComboBox b5 = new JComboBox(sensitivity);
		b5.setSelectedItem("medium");
		b5.setPreferredSize(new Dimension(80,20));
		
		Vector filter = new Vector();
		filter.add("none");
		filter.add("seg");
		filter.add("xnu");
		filter.add("seg+xnu");
		
		final JComboBox b6 = new JComboBox(filter);
		b6.setPreferredSize(new Dimension(80,20));
		
		Vector sort = new Vector();
		sort.add("pvalue");
		sort.add("count");
		sort.add("highscore");
		sort.add("totalscore");
		
		final JComboBox b7 = new JComboBox(sort);
		b7.setPreferredSize(new Dimension(80,20));
		
	
		Vector stats = new Vector();
		stats.add("sump");
		stats.add("poisson");
		stats.add("kap");
		
		final JComboBox b8 = new JComboBox(stats);
		b8.setPreferredSize(new Dimension(80,20));
		
		base.add(a1);
		base.add(b1);
		base.add(a2);
		base.add(b2);
		base.add(a5);
		base.add(b5);
		base.add(a6);
		base.add(b6);
		base.add(a7);
		base.add(b7);
		base.add(a8);
		base.add(b8);
		
		basePanel.add(base);
		
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(70, 200));
		okButton.setBounds(70, 200, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
			
				try{
					
					BlastSettings.matrix = (String)b1.getSelectedItem();
					try{
						BlastSettings.exp = Float.parseFloat((String)b2.getSelectedItem());
					}
					catch (NumberFormatException e){
						
						e.printStackTrace();
					}
					
					
					BlastSettings.sensitivity = (String)b5.getSelectedItem();
					BlastSettings.filter = (String)b6.getSelectedItem();
					BlastSettings.sort = (String)b7.getSelectedItem();
					BlastSettings.stats = (String)b8.getSelectedItem();
					
					parent.setDisplayDialogStatus(false);
				}
				catch (Exception e){
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					e.printStackTrace();
				}

				dispose();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(170, 200));
		cancelButton.setBounds(170, 200, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(basePanel);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
		});
		
		
		
		setSize(325, 260);

		if (parentFrame == null){
			setLocationRelativeTo(null);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);

			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		setVisible(true);
		


	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
	
}
