//Copyright (c) 2000-2002  San Diego Supercomputer Center (SDSC),
//a facility operated jointly by the University of California,
//San Diego (UCSD) and General Atomics, San Diego, California, USA.
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

/**
 *  This class impements a dialog box used to input the three atoms required to calculate a bond angle.
 *  <P>
 *  @see edu.sdsc.sirius.viewers.StructureViewer
 *  @see edu.sdsc.sirius.dialogs.DisplayDialog
 *  <P>
 *  @author Oleksandr V. Buzko
 */

public class AngleDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	
	private Atom[] atoms = new Atom[3];
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	
	private JLabel label1 = new JLabel();
	private JTextField field1 = new JTextField(30);
	private JLabel label2 = new JLabel();
	private JTextField field2 = new JTextField(30);
	private JLabel label3 = new JLabel();
	private JTextField field3 = new JTextField(30);
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JTextField activeField = field1;//is used to figure out which field should accept pick input from StructureViewer
	
	/**
	 * This method creates an instance of the AngleDialog class.
	 * @see edu.sdsc.sirius.dialogs.DisplayDialog
	 * @param f
	 * @param p
	 * @param s
	 */
	public AngleDialog(JFrame f, Manager p, StructureViewer s){
	
		super(f, "Measure bond angle", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 180));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 180);
		base.setLayout(null);
		
		
		//object field
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 12));
		label1.setText("1st atom: enter name or click");
		label1.setPreferredSize(new Dimension(170,20));
		label1.setBounds(15,15,190,20);
		label1.setLocation(new Point(15,15));
		label1.setVisible(true);
		
		field1.setPreferredSize(new Dimension(170,20));
		field1.setBounds(15,40,170,20);
		field1.setLocation(new Point(15,40));
		field1.setEditable(true);
		field1.setEnabled(true);
		field1.setVisible(true);
		field1.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field1;
			}
		});
		
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 12));
		label2.setText("2nd atom: enter name or click");
		label2.setPreferredSize(new Dimension(190,20));
		label2.setBounds(15,65,190,20);
		label2.setLocation(new Point(15,65));
		label2.setVisible(true);
		
		field2.setPreferredSize(new Dimension(170,20));
		field2.setBounds(15,90,170,20);
		field2.setLocation(new Point(15,90));
		field2.setEditable(true);
		field2.setEnabled(true);
		field2.setVisible(true);
		field2.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field2;
			}
		});
		
		label3.setForeground(Color.black);
		label3.setFont(new Font("Dialog", Font.PLAIN, 12));
		label3.setText("3rd atom: enter name or click");
		label3.setPreferredSize(new Dimension(190,20));
		label3.setBounds(15,115,190,20);
		label3.setLocation(new Point(15,115));
		label3.setVisible(true);
		
		field3.setPreferredSize(new Dimension(170,20));
		field3.setBounds(15,140,170,20);
		field3.setLocation(new Point(15,140));
		field3.setEditable(true);
		field3.setEnabled(true);
		field3.setVisible(true);
		field3.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field3;
			}
		});
		
		
		base.add(label1);
		base.add(field1);
		base.add(label2);
		base.add(field2);
		base.add(label3);
		base.add(field3);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 190));
		okButton.setBounds(20, 190, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
			
				//add error checking for selection bounds
				//eg., selection level is residue, but entered only structure name
				try{
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					if (atoms[0] == null || atoms[1] == null || atoms[2] == null){
						parent.displayErrorMessage("Three atoms must be selected");
					}
					else{
						GeometryEvent event = new GeometryEvent(itself);
						event.atomLabels.add(field1.getText());
						event.atomLabels.add(field2.getText());
						event.atomLabels.add(field3.getText());
						event.atoms.add(atoms[0]);
						event.atoms.add(atoms[1]);
						event.atoms.add(atoms[2]);
						
						
						sv.processDisplayDialogEvent(event);
					}
				}
				catch (Exception e){
					parent.setDisplayDialogStatus(false);
					parent.displayExceptionMessage("Exception measuring angle", e);
				}

				dispose();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 190));
		cancelButton.setBounds(120, 190, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(230, 250);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		setVisible(true);
	}
	
	/**
	 * This method is called by StructureViewer in response to a mouse click and sets the currently
	 * active text field to the String representation of the clicked StructureComponent.
	 * @see edu.sdsc.sirius.viewers.StructureViewer
	 * @see edu.sdsc.mbt.StructureComponent
	 */
	public void processPick(String data, StructureComponent structureComponent){
		activeField.setText(data);
		//move focus only if something has been picked
		if (data.length() > 0){
			if (activeField == field1){
				atoms[0] = (Atom)structureComponent;
				activeField = field2;
				field2.requestFocus();
			}
			else if (activeField == field2){
				atoms[1] = (Atom)structureComponent;
				activeField = field3;
				field3.requestFocus();
			}
			else{
				atoms[2] = (Atom)structureComponent;
			}
		}
	}
	
}
