package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.viewers.*;

public class AngleMonitorDialog extends JDialog  {

	private JFrame parentFrame = null;
	private StructureViewer sv = null;
	
	private StructureComponent structureComponent;
	
	private AngleMonitorDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	
	
	private JLabel label = new JLabel();
	private JTextField field = new JTextField(30);
	
	private JButton okButton = new JButton("Accept");
	private JButton cancelButton = new JButton("Cancel");
		
	public AngleMonitorDialog(JFrame f, StructureViewer s){
	
		super(f, "Rotate around bond", false);
	
		parentFrame = f;
		sv = s;
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 40));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 40);
		base.setLayout(null);
		
		
		//object field
		label.setForeground(Color.black);
		label.setFont(new Font("Dialog", Font.PLAIN, 14));
		label.setText("Angle:");
		label.setPreferredSize(new Dimension(80,20));
		label.setBounds(20,10,80,20);
		label.setLocation(new Point(20,10));
		label.setVisible(true);
		
		field.setPreferredSize(new Dimension(100,20));
		field.setBounds(90,10,100,20);
		field.setLocation(new Point(90,10));
		field.setEditable(true);
		field.setEnabled(true);
		field.setVisible(true);
		field.setText("0.0");
		
		base.add(label);
		base.add(field);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 55));
		okButton.setBounds(20, 55, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				sv.acceptRotation(Double.parseDouble(field.getText()));
			}
		});
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 55));
		cancelButton.setBounds(120, 55, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				sv.cancelRotation();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				sv.cancelRotation();
			}
		});
		
		setSize(230, 115);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

	}
	
	public void setAngle(double angle){
		String text = (new Double(angle)).toString();
		//trim the text
		int index = text.indexOf(".");
		int limit = Math.min(index+2, text.length());
		
		field.setText(text.substring(0, limit));
	}
	
	public void showDialog(boolean show){
		if (show){
			field.setText("0.0");
		}
		setVisible(show);
	}
	
}
