package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

/**
 * This class serves two purposes: specify an atom to delete or get a name of the atom(s) to be selected.
 * @author Sasha Buzko
 *
 */
public class AtomDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private Atom[] atoms = new Atom[2];
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	
	private JLabel label = new JLabel();
	private JTextField field = new JTextField(30);
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private int type = -1;
	
	private AtomDialog atomDialog;
	
	
	public AtomDialog(JFrame f, Manager p, StructureViewer s, int type){
	
		super(f, "Delete atom", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		this.type = type;
		
		atomDialog = this;
		
//		System.out.println("Starting");
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		if (type == StructureEventRegistry.DELETE_ATOM){
			setTitle("Delete atom");
		}
		else if (type == StructureEventRegistry.SELECT_ATOM){
			setTitle("Select atom by name");
		}
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 70));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 70);
		base.setLayout(null);
		
		
		//object field
		label.setForeground(Color.black);
		label.setFont(new Font("Dialog", Font.PLAIN, 12));
		label.setText("Enter atom name or click");
		label.setPreferredSize(new Dimension(170,20));
		label.setBounds(15,10,170,20);
		label.setLocation(new Point(15,10));
		label.setVisible(true);
		
		field.setPreferredSize(new Dimension(170,20));
		field.setBounds(15,35,170,20);
		field.setLocation(new Point(15,35));
		field.setEditable(true);
		field.setEnabled(true);
		field.setVisible(true);
		field.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					parent.setDisplayDialogStatus(false);
					setVisible(false);
					dispose();
				}
			}
		});
		
		base.add(label);
		base.add(field);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 80));
		okButton.setBounds(20, 80, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 80));
		cancelButton.setBounds(120, 80, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(230, 135);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}



		setVisible(true);

	}
	
	private void process(){
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		try{
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			if (atoms[0] == null && field.getText().length() == 0 ){
				parent.displayErrorMessage("No information has been entered.");
			}
			else{
				StructureEvent event = new StructureEvent(itself);
				event.atomLabels.add(field.getText());
				event.atoms.add(atoms[0]);
				event.eventType = atomDialog.type;
				sv.processDisplayDialogEvent(event);
			}
		}
		catch (Exception e){
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception processing atom", e);

		}

		dispose();
		
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		
		field.setText(data);
		atoms[0] = (Atom)structureComponent;
	}
	
}
