package edu.sdsc.sirius.dialogs;


// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class BondOrderDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	
	private Atom[] atoms = new Atom[2];
	
	
	private JLabel label1 = new JLabel();
	private JTextField field1 = new JTextField(30);
	private JLabel label2 = new JLabel();
	private JTextField field2 = new JTextField(30);
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton button1 = new JRadioButton("Single");
	private JRadioButton button2 = new JRadioButton("Aromatic/partial double");
	private JRadioButton button3 = new JRadioButton("Double");
	private JRadioButton button4 = new JRadioButton("Triple");
	
	private float selectedOrder = 1.0f;
	
	private JCheckBox box;
	private boolean keepOpen = false;
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JTextField activeField = field1;//is used to figure out which field should accept pick input from StructureViewer
	
	
	public BondOrderDialog(JFrame f, Manager p, StructureViewer s){
	
		super(f, "Set bond order", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
//		System.out.println("Starting");
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 295));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 295);
		base.setLayout(null);
		
		JPanel base1 = new JPanel();
		base1.setPreferredSize(new Dimension(200, 125));
		base1.setBounds(5,5,200,125);
		base1.setLocation(new Point(5,5));
		base1.setVisible(true);
		base1.setLayout(null);
		
		base1.setBorder(createTitledBorder("Bond"));

		
		//object field
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 12));
		label1.setText("1st atom: enter name or click");
		label1.setPreferredSize(new Dimension(170,20));
		label1.setBounds(10,20,190,20);
		label1.setLocation(new Point(10,20));
		label1.setVisible(true);
		
		field1.setPreferredSize(new Dimension(170,20));
		field1.setBounds(10,40,170,20);
		field1.setLocation(new Point(10,40));
		field1.setEditable(true);
		field1.setEnabled(true);
		field1.setVisible(true);
		field1.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field1;
			}
		});
		
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 12));
		label2.setText("2nd atom: enter name or click");
		label2.setPreferredSize(new Dimension(190,20));
		label2.setBounds(10,70,190,20);
		label2.setLocation(new Point(10,70));
		label2.setVisible(true);
		
		field2.setPreferredSize(new Dimension(170,20));
		field2.setBounds(10,90,170,20);
		field2.setLocation(new Point(10,90));
		field2.setEditable(true);
		field2.setEnabled(true);
		field2.setVisible(true);
		field2.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field2;
			}
		});
		
		
		
		base1.add(label1);
		base1.add(field1);
		base1.add(label2);
		base1.add(field2);
		
		base.add(base1);
		
		JPanel base2 = new JPanel();
		base2.setPreferredSize(new Dimension(200, 110));
		base2.setBounds(5,130,200,110);
		base2.setLocation(new Point(5,130));
		base2.setVisible(true);
		base2.setLayout(null);
		
		base2.setBorder(createTitledBorder("Bond order"));

		button1.setFont(new Font("Dialog", Font.PLAIN, 12));
		button1.setPreferredSize(new Dimension(100,20));
		button1.setLocation(new Point(20,20));
		button1.setBounds(20,20,100,20);
		button1.setVisible(true);
		button1.setSelected(true);
		button1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				selectedOrder = 1.0f;
			}
		});
		
		button2.setFont(new Font("Dialog", Font.PLAIN, 12));
		button2.setPreferredSize(new Dimension(150,20));
		button2.setLocation(new Point(20,40));
		button2.setBounds(20,40,170,20);
		button2.setVisible(true);
		button2.setSelected(false);
		button2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				selectedOrder = 1.5f;
			}
		});
		
		button3.setFont(new Font("Dialog", Font.PLAIN, 12));
		button3.setPreferredSize(new Dimension(100,20));
		button3.setLocation(new Point(20,60));
		button3.setBounds(20,60,100,20);
		button3.setVisible(true);
		button3.setSelected(false);
		button3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				selectedOrder = 2.0f;
			}
		});
		
		button4.setFont(new Font("Dialog", Font.PLAIN, 12));
		button4.setPreferredSize(new Dimension(100,20));
		button4.setLocation(new Point(20,80));
		button4.setBounds(20,80,100,20);
		button4.setVisible(true);
		button4.setSelected(false);
		button4.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				selectedOrder = 3.0f;
			}
		});
		
		group.add(button1);
		group.add(button2);
		group.add(button3);
		group.add(button4);
		
		
		base2.add(button1);
		base2.add(button2);
		base2.add(button3);
		base2.add(button4);
		
		base.add(base2);

		JPanel base3 = new JPanel();
		base3.setPreferredSize(new Dimension(200, 50));
		base3.setBounds(5,240,200,50);
		base3.setLocation(new Point(5,240));
		base3.setVisible(true);
		base3.setLayout(null);
		
		base3.setBorder(createTitledBorder("Batch operation"));
		box = new JCheckBox("Keep open after operation");
		box.setPreferredSize(new Dimension(170,20));
		box.setLocation(new Point(20,20));
		box.setBounds(20,20,170,20);
		box.setVisible(true);
		box.setSelected(false);
		box.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				keepOpen = box.isSelected();
			}
		});
		base3.add(box);
		
		base.add(base3);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 305));
		okButton.setBounds(20, 305, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
			
				//add error checking for selection bounds
				//eg., selection level is residue, but entered only structure name
				try{
					if ((atoms[0] == null && field1.getText().length() == 0) || (atoms[1] == null && field2.getText().length() == 0)){
						setVisible(false);
						parent.setDisplayDialogStatus(false);
						dispose();
						parent.displayErrorMessage("Two atoms must be selected to define a bond");
					}
					else{
						GeometryEvent event = new GeometryEvent(itself);
						event.atoms.add(atoms[0]);
						event.atoms.add(atoms[1]);
						
						event.atomLabels.add(field1.getText());
						event.atomLabels.add(field2.getText());
						event.bondOrder = selectedOrder;
						
						sv.processDisplayDialogEvent(event);
					}
					
					atoms[0] = null;
					atoms[1] = null;
					if (!keepOpen){
						setVisible(false);
						parent.setDisplayDialogStatus(false);
						dispose();
					}
					else{
						field1.setText("");
						field2.setText("");
						field1.requestFocus();
						activeField = field1;
					}
				}
				catch (Exception e){
					parent.setDisplayDialogStatus(false);
					parent.displayExceptionMessage("Exception setting bond order", e);

				}

			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 305));
		cancelButton.setBounds(120, 305, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(230, 360);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}



		setVisible(true);
		


	}
	
	public void processPick(String data, StructureComponent structureComponent) {
		
		activeField.setText(data);
		//move focus along only if something has been picked
		if (data.length() > 0){
			if (activeField == field1){
				atoms[0] = (Atom)structureComponent;
				activeField = field2;
				field2.requestFocus();
			}
			else{
				atoms[1] = (Atom)structureComponent;
			}
		}
	}
	
	private Border createTitledBorder(String title){
		
		Border border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		TitledBorder border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " " + title + " ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		Border border = BorderFactory.createCompoundBorder(border1, border2);

		return border;
	}

	
}
