//$Id: CancelDialog.java,v 1.2 2007/05/11 19:06:52 Sasha Buzko Exp $
//
//Copyright (c) 2000-2003 San Diego Supercomputer Center (SDSC),
//a facility operated jointly by the University of California,
//San Diego (UCSD) and General Atomics, San Diego, California, USA.
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software. License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC. This source is provided "AS IS" without express
//or implied warranty of any kind.
// 
//For further information, please see: <http://mbt.sdsc.edu>
// 
//History:
//$Log: CancelDialog.java,v $
//Revision 1.2  2007/05/11 19:06:52  Sasha Buzko
//*** empty log message ***
//
//Revision 1.1  2007/05/05 01:30:03  Sasha Buzko
//*** empty log message ***
//
//Revision 1.2  2006/10/21 18:41:25  Sasha Buzko
//*** empty log message ***
//
//Revision 1.1  2006/10/21 17:52:13  Sasha Buzko
//Refactored the project to move all new code to edu.sdsc.sirius package.
//
//Revision 1.1  2006/05/20 17:02:00  Sasha Buzko
//Updated version
//
//Revision 1.1  2006/04/30 20:13:56  Sasha Buzko
//New version of the app
//
//Revision 1.1  2006/04/15 19:42:18  Sasha Buzko
//Initial commit
//
//Revision 1.2  2006/02/05 22:01:43  Administrator
//*** empty log message ***
//
//Revision 1.1  2005/11/13 04:35:23  Administrator
//*** empty log message ***
//
//Revision 1.2 2003/05/15 23:44:54 moreland
//Cleaned up code a bit for a preliminary release to obuzko.
//
//Revision 1.1 2003/05/15 22:42:45 moreland
//An application which incorporates more MBT GUI layer components.
//
//Revision 1.0 2003/05/05 16:06:13 moreland
//First version.
// 

package edu.sdsc.sirius.dialogs;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

import edu.sdsc.sirius.util.*;

public class CancelDialog extends JDialog {
	
	private JFrame parent;
	private JDialog parentDialog;
	
	private Container contentPane;
	private JScrollPane scrollPane;
	private JEditorPane textPane;
	
	private CancelEventHandler acceptor;
	
	public CancelDialog(JFrame parent, CancelEventHandler acc){
		
		super(parent, "Processing...", true);
		this.parent = parent;
		this.acceptor = acc;

		contentPane = getContentPane();
		
		JPanel base = new JPanel();
		base.setLayout(null);
		
		JLabel label = new JLabel("Please wait...");
		label.setFont(new Font("Dialog", Font.BOLD, 14));
		label.setBounds(55,10,100,20);
		
		JButton button = new JButton("Cancel");
		button.setBounds(60,40,80,25);
		button.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				if (acceptor != null) acceptor.processCancelEvent();
				setVisible(false);
				dispose();
			}
		});
		
		this.addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e){
				dispose();
			}
		});
		
		base.add(label, BorderLayout.CENTER);
		base.add(button, BorderLayout.SOUTH);
		
		contentPane.add(base);
		
		setSize(200,100);
		setResizable(false);

		setLocationRelativeTo(parent);

	}
	
	public static void main(String[] args){
		CancelDialog d = new CancelDialog((JFrame)null, null);
	}
	


}