package edu.sdsc.sirius.dialogs;


// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;
import java.util.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class ChargeDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	
	private Atom[] atoms = new Atom[2];
	
	
	private JLabel label1 = new JLabel();
	private JTextField field1 = new JTextField(30);
	
	private JLabel label2 = new JLabel();
	
	private int selectedCharge = 0;
	
	private JCheckBox box;
	private boolean keepOpen = false;
	
	private JComboBox combo;
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	
	public ChargeDialog(JFrame f, Manager p, StructureViewer s){
	
		super(f, "Set atom hybridization state", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
//		System.out.println("Starting");
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 235));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 235);
		base.setLayout(null);
		
		JPanel base1 = new JPanel();
		base1.setPreferredSize(new Dimension(200, 80));
		base1.setBounds(5,5,200,80);
		base1.setLocation(new Point(5,5));
		base1.setVisible(true);
		base1.setLayout(null);
		
		base1.setBorder(createTitledBorder("Atom"));

		
		//object field
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 12));
		label1.setText("Enter name or click atom");
		label1.setPreferredSize(new Dimension(170,20));
		label1.setBounds(10,20,170,20);
		label1.setLocation(new Point(10,20));
		label1.setVisible(true);
		
		field1.setPreferredSize(new Dimension(170,20));
		field1.setBounds(10,40,170,20);
		field1.setLocation(new Point(10,40));
		field1.setEditable(true);
		field1.setEnabled(true);
		field1.setVisible(true);
		
		base1.add(label1);
		base1.add(field1);
		
		base.add(base1);
		
		JPanel base2 = new JPanel();
		base2.setPreferredSize(new Dimension(200, 95));
		base2.setBounds(5,85,200,95);
		base2.setLocation(new Point(5,85));
		base2.setVisible(true);
		base2.setLayout(null);
		
		base2.setBorder(createTitledBorder("Formal charge"));

		label2.setFont(new Font("Dialog", Font.PLAIN, 11));
		label2.setText("Select formal charge");
		label2.setBounds(20,20,150,20);

		Vector numbers = new Vector();
		numbers.add("+3");
		numbers.add("+2");
		numbers.add("+1");
		numbers.add("0");
		numbers.add("-1");
		numbers.add("-2");
		numbers.add("-3");
		
		combo = new JComboBox(numbers);
		combo.setSelectedIndex(3);
		combo.setBounds(20,50,80,20);
		
		base2.add(label2);
		base2.add(combo);
		
		base.add(base2);

		JPanel base3 = new JPanel();
		base3.setPreferredSize(new Dimension(200, 50));
		base3.setBounds(5,180,200,50);
		base3.setLocation(new Point(5,180));
		base3.setVisible(true);
		base3.setLayout(null);
		
		base3.setBorder(createTitledBorder("Batch operation"));
		box = new JCheckBox("Keep open after operation");
		box.setPreferredSize(new Dimension(170,20));
		box.setLocation(new Point(20,20));
		box.setBounds(20,20,170,20);
		box.setVisible(true);
		box.setSelected(false);
		box.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				keepOpen = box.isSelected();
			}
		});
		base3.add(box);
		
		base.add(base3);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 245));
		okButton.setBounds(20, 245, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
			
				//add error checking for selection bounds
				//eg., selection level is residue, but entered only structure name
				try{
					if (atoms[0] == null && field1.getText().length() == 0){
						setVisible(false);
						parent.setDisplayDialogStatus(false);
						dispose();
						parent.displayErrorMessage("Atom must be selected to set hybridization");
					}
					else{
						String selection = (String)combo.getSelectedItem();
						String value = null;
						if (selection.startsWith("+")){
							value = selection.substring(1);
						}
						else{
							value = selection;
						}
						
///						System.out.println("value = " + value + ", atoms[0] = " + atoms[0]);
						short charge = Short.parseShort(value);
						sv.setFormalCharge(atoms[0], field1.getText(), charge);
					}
					
					atoms[0] = null;
					if (!keepOpen){
						setVisible(false);
						parent.setDisplayDialogStatus(false);
						dispose();
					}
					else{
						field1.setText("");
						field1.requestFocus();
					}
				}
				catch (Exception e){
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					parent.displayExceptionMessage("Exception setting charge", e);
					dispose();
				}

			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 245));
		cancelButton.setBounds(120, 245, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(230, 300);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}



		setVisible(true);
		


	}
	
	public void processPick(String data, StructureComponent structureComponent) {
		
		field1.setText(data);
		//move focus along only if something has been picked
		if (data.length() > 0){
			atoms[0] = (Atom)structureComponent;
		}
	}
	
	private Border createTitledBorder(String title){
		
		Border border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		TitledBorder border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " " + title + " ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		Border border = BorderFactory.createCompoundBorder(border1, border2);

		return border;
	}

	
}
