//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs;

import java.util.*;
import javax.swing.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;
import javax.swing.event.*;

import edu.sdsc.sirius.dialogs.TableImpl.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.sirius.md.*;

import java.io.*;

public class ClusterMDFileListerDialog extends JDialog implements ResultPanelCallable {
	
	private Container contentPane;
	private JDialog self;
	
	private int width = 350;
	private int height = 425;
	
	public static final int TYPE_OUT = 0;
	public static final int TYPE_COORD = 1;
	
	private String workingDir = ".";
	
	public MDPanel parent;
	private JFrame parentFrame;
	
	private StructureDocument structureDocument;
	
	private Manager callable;
	
	private JPanel base = new JPanel();
	private JPanel buttonPanel = new JPanel();
	private JButton loadButton = new JButton("OK");
	private JButton closeButton = new JButton("Cancel");
	
	private JButton up = new JButton("Move up");
	private JButton down = new JButton("Move down");
	
	private File[] order;//new ordered list
	private HashMap indices = new HashMap();//DataBlock -> its position in the set
	
	private String[] list;
	
	private JList listObject;
	
	
	private JTextField numberField = new JTextField(10);
	private JTextField basenameField = new JTextField(30);
	private JTextField outdirField = new JTextField(40);
	private JButton outdirButton = new JButton("Browse...");
	private JTextField prmtopField = new JTextField(40);
	private JButton prmtopButton = new JButton("Browse...");
	
	private JRadioButton proteinButton = new JRadioButton("Protein");
	private JRadioButton dnaButton = new JRadioButton("DNA");
	
	/**
	 * Constructor that creates the dialog.
	 * @param f parent frame
	 * @param p Manager object that will process the RequestSet
	 * @param title dialog title
	 * @param modal whether the dialog is modal (other frames in the application will be inaccessible)
	 */
	public ClusterMDFileListerDialog (JFrame f, MDPanel parent, Manager c, File[] files){
	
		super(f, "Clustering options", false);
		this.parent = parent;
		parentFrame = f;
		
		this.callable = c;
		
		order = files;
		list = new String[files.length];
		
		for (int j = 0; j < files.length; j++){
			String ff = files[j].toString();
			String label = null;
			int index2 = ff.lastIndexOf(File.separator);
			if (index2 > 0){
				label = ff.substring(index2+1);
			}
			else{
				label = ff;
			}
			
			list[j] = label;
		}
		
		self = this;
		
		base.setBorder(new BevelBorder(BevelBorder.LOWERED));
		base.setLayout(new BorderLayout());
		
		JScrollPane sp = new JScrollPane();
		base.setBackground(new Color(200,200,240));
		
		listObject = new JList(list);
		listObject.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		sp.getViewport().add(listObject);
		base.add(sp, BorderLayout.CENTER);

		
		//add window listener
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				dispose();
			}
		});
		
		getContentPane().add(base, BorderLayout.CENTER);
		
		//add the manipulation panel
		JPanel controlPanel = new JPanel();
		controlPanel.setLayout(null);
		controlPanel.setPreferredSize(new Dimension(350, 190));
		up.setBounds(65, 15, 90, 20);
		up.setEnabled(false);
		up.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				int index = listObject.getSelectedIndex();
				
				//swap the current file with the previous one
				int last = index - 1;
				StringBuffer buffer = new StringBuffer();
				buffer.append(list[last]);
				String temp = buffer.toString();
				list[last] = list[index];
				list[index] = temp;
				listObject.setSelectedIndex(last);
				
				//make the same swap of File objects
				File f = order[last];
				order[last] = order[index];
				order[index] = f;
				
				listObject.revalidate();
				listObject.repaint();
			}
		});
		
		down.setBounds(195, 15, 100, 20);
		down.setEnabled(false);
		down.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				int index = listObject.getSelectedIndex();
				
				//swap the current file with the previous one
				int next = index + 1;
				StringBuffer buffer = new StringBuffer();
				buffer.append(list[next]);
				String temp = buffer.toString();
				list[next] = list[index];
				list[index] = temp;
				listObject.setSelectedIndex(next);
				
				//make the same swap of File objects
				File f = order[next];
				order[next] = order[index];
				order[index] = f;
				
				listObject.revalidate();
				listObject.repaint();


			}
		});
		
		listObject.addListSelectionListener(new ListSelectionListener(){
			public void valueChanged(ListSelectionEvent e){
				if (e.getValueIsAdjusting()) return;
				
				int index = listObject.getSelectedIndex();
				if (index == -1) return;
				
				if (index == 0){
					up.setEnabled(false);
					if (list.length > 1) down.setEnabled(true);
				}
				else if (index == list.length-1){
					if (list.length > 1) up.setEnabled(true);
					down.setEnabled(false);
				}
				else{
					up.setEnabled(true);
					down.setEnabled(true);
				}
			}
		});
		
		controlPanel.add(up);
		controlPanel.add(down);
		JSeparator separator = new JSeparator();
		separator.setBounds(5, 50, 340, 5);
		controlPanel.add(separator);
		
		//add other options
		JLabel numberLabel = new JLabel("Number of clusters:");
		numberLabel.setBounds(10, 65, 160, 20);
		
		numberField.setBounds(250, 65, 80, 20);
		numberField.setText("10");
		controlPanel.add(numberLabel);
		controlPanel.add(numberField);
		
		JLabel basenameLabel = new JLabel("Output basename:");
		basenameLabel.setBounds(10, 90, 120, 20);
		
		basenameField.setBounds(200, 90, 130, 20);
		
		controlPanel.add(basenameLabel);
		controlPanel.add(basenameField);
		
		JLabel prmtopLabel = new JLabel("prmtop/psf file:");
		prmtopLabel.setBounds(10, 115, 100, 20);
		
		prmtopField.setBounds(100, 115, 145, 20);
		prmtopButton.setBounds(250, 115, 80, 20);
		prmtopButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				
				JFileChooser chooser = new JFileChooser(callable.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int result = chooser.showOpenDialog(parentFrame);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				String newDirectory = filename.toString();
				prmtopField.setText(newDirectory);
				
			}
		});
		
		controlPanel.add(prmtopLabel);
		controlPanel.add(prmtopField);
		controlPanel.add(prmtopButton);

		JLabel outdirLabel = new JLabel("Output directory:");
		outdirLabel.setBounds(10, 140, 100, 20);
		
		outdirField.setBounds(100, 140, 145, 20);
		outdirButton.setBounds(250, 140, 80, 20);
		outdirButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				
				JFileChooser chooser = new JFileChooser(callable.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				int result = chooser.showOpenDialog(parentFrame);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				String newDirectory = filename.toString();
				outdirField.setText(newDirectory);
				
			}
		});
		
		controlPanel.add(outdirLabel);
		controlPanel.add(outdirField);
		controlPanel.add(outdirButton);
		
		proteinButton.setSelected(true);
		dnaButton.setSelected(false);
		
		ButtonGroup g = new ButtonGroup();
		g.add(proteinButton);
		g.add(dnaButton);
		
		proteinButton.setBounds(80, 165, 80, 20);
		dnaButton.setBounds(180, 165, 100, 20);
		
		controlPanel.add(proteinButton);
		controlPanel.add(dnaButton);
		
		base.add(controlPanel, BorderLayout.SOUTH);
		
		
		//panel that holds buttons and other options
		JPanel lowerPanel = new JPanel();
		lowerPanel.setLayout(new BorderLayout());
		JPanel borderPanel = new JPanel();
		borderPanel.setLayout(new BorderLayout());
		borderPanel.add(new JSeparator(), BorderLayout.NORTH);
		
		lowerPanel.add(borderPanel, BorderLayout.NORTH);
		
		buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 30, 5));
		
		loadButton.setPreferredSize(new Dimension(80,25));
		loadButton.setVisible(true);
		loadButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				
				Thread runner = new Thread(){
					public void run(){
						Vector out = new Vector();
						for (int i = 0; i < order.length; i++){
							File f = order[i];
							out.add(f.getAbsolutePath());
						}
						
						((ClusterMDFileListerDialog)self).parent.clusterTrajectoryFiles(out, numberField.getText().trim(), 
								basenameField.getText().trim(), outdirField.getText().trim(), prmtopField.getText().trim(), proteinButton.isSelected());
					}
				};
				runner.start();
				
				
				dispose();
			}
		});
		
		closeButton.setPreferredSize(new Dimension(80,25));
		closeButton.setVisible(true);
		closeButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				dispose();
			}
		});
		
		buttonPanel.add(loadButton);
		buttonPanel.add(closeButton);
		
		
		lowerPanel.add(buttonPanel, BorderLayout.CENTER);
		getContentPane().add(lowerPanel, BorderLayout.SOUTH);
		
		Dimension dim = getToolkit().getScreenSize();
		if (parentFrame == null){
			setLocationRelativeTo(null);
		}
		else{
			int x = parentFrame.getX() + (parentFrame.getWidth() - this.width)/2;
			int y = parentFrame.getY() + (parentFrame.getHeight() - this.height)/2;
			setBounds(x, y, width, height);
		}
		
		setSize(width, height);
		
		setVisible(true);
	}
	
	/**
	 * Sets the display to the given DataSet.
	 */
/*	public void setData(DataSet set){
		
		System.out.println("set data");
	
		if (contentPanel != null){
			return;
		}
		
		System.out.println("setting table");
		//used to show a table in a previously open frame
		//(after a new search initiated from this frame)
		contentPanel = new ResultPanel(this, set, callable, ResultPanel.NAVIGATION_TABLE, searchTypes, null);
		contentPane.remove(base);
		contentPane.add(contentPanel, BorderLayout.CENTER);
		
	}
*/	
	public void setNumberOfHits(int n){}
	
	public void setSelectedIndices(Vector v){}
}