package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.mbt.viewables.StylesPreferences;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class ClusterOptionsDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureComponent structureComponent;
	private StructureViewer viewer;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private JPanel topPanel = new JPanel();
	private JPanel colorPanel = new JPanel();
	private JPanel thicknessPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton solid = new JRadioButton("Solid lines", true);
	private JRadioButton dashed = new JRadioButton("Dashed lines", false);
	
		
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");

	
	private JComboBox combo = new JComboBox();
	
	private Color color1;
	private Color color2;
	
	private JButton colorButton1;
	private JButton colorButton2;
	
	private boolean dialog = false;//another dialog is open - do not bring this window to front
	
	public ClusterOptionsDialog(JFrame f, Manager p){

		super(f, "Define set of atoms", false);

		parentFrame = f;
		parent = p;
		viewer = parent.getStructureViewer();
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 250, 240);
		base.setLayout(null);
		
		topPanel.setBounds(5,5,240,80);
		topPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Graph line style ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		topPanel.setBorder(border);
		
	
		//define the radio buttons
		solid.setBounds(25,25,100,20);
		solid.setVisible(true);

		dashed.setBounds(25,50,120,20);
		dashed.setVisible(true);
		
		if (StylesPreferences.clusterLineStyle == StylesPreferences.CLUSTER_LINE_DASHED){
			dashed.setSelected(true);
			solid.setSelected(false);
		}
		else{
			dashed.setSelected(false);
			solid.setSelected(true);
		}
		
		group.add(solid);
		group.add(dashed);
		
		JLabel nameLabel = new JLabel("Name:");
		nameLabel.setFont(new Font("Dialog", Font.PLAIN, 11));
		nameLabel.setBounds(135,20,40,20);
		nameLabel.setVisible(true);
		
		

		topPanel.add(solid);
		topPanel.add(dashed);
		
		base.add(topPanel);
		
		
		colorPanel.setBounds(5,85,240,90);
		colorPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Line colors ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		colorPanel.setBorder(border);
		
		JLabel label1 = new JLabel("Graph 1:");
		label1.setBounds(25, 25, 50,20);
		
		JLabel label2 = new JLabel("Graph 2:");
		label2.setBounds(25,50,50,20);
		
		
		//color control buttons
		colorButton1 = new JButton(createImageIcon(StylesPreferences.clusterColor1));
		colorButton1.setBounds(100,25,70,20);
		colorButton1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				dialog = true;
				Color current = new Color(StylesPreferences.clusterColor1[0], StylesPreferences.clusterColor1[1], StylesPreferences.clusterColor1[2]);
				Color newColor = JColorChooser.showDialog(null, "Choose color of the first structure graph", current);
				if (newColor != null){
					//proceed with new color
					float[] color = newColor.getRGBColorComponents(null);
					StylesPreferences.clusterColor1[0] = color[0];
					StylesPreferences.clusterColor1[1] = color[1];
					StylesPreferences.clusterColor1[2] = color[2];
					colorButton1.setIcon(createImageIcon(color));
				}
				dialog = false;
			}
		});
		
		colorButton2 = new JButton(createImageIcon(StylesPreferences.clusterColor2));
		colorButton2.setBounds(100,50,70,20);
		colorButton2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				dialog = true;
				Color current = new Color(StylesPreferences.clusterColor2[0], StylesPreferences.clusterColor2[1], StylesPreferences.clusterColor2[2]);
				Color newColor = JColorChooser.showDialog(null, "Choose color of the second structure graph", current);
				if (newColor != null){
					//proceed with new color
					float[] color = newColor.getRGBColorComponents(null);
					StylesPreferences.clusterColor2[0] = color[0];
					StylesPreferences.clusterColor2[1] = color[1];
					StylesPreferences.clusterColor2[2] = color[2];
					colorButton2.setIcon(createImageIcon(color));
				}
				dialog = false;
			}
		});
		
		colorPanel.add(label1);
		colorPanel.add(label2);
		colorPanel.add(colorButton1);
		colorPanel.add(colorButton2);

		
		base.add(colorPanel);
		
		//line thickness panel
		
		thicknessPanel.setBounds(5,175,240,60);
		thicknessPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Graph line thickness ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		thicknessPanel.setBorder(border);
		
		JLabel label3 = new JLabel();
		label3.setForeground(Color.black);
		label3.setFont(new Font("Dialog", Font.PLAIN, 11));
		label3.setText("Line thickness in pixels:");
		label3.setBounds(25,25,120,20);
		label3.setVisible(true);
		
		//walk through the loaded structures
		Vector thick = new Vector();
		thick.add("1");
		thick.add("2");
		thick.add("3");
		thick.add("4");
		thick.add("5");
		
		combo = new JComboBox(thick);
		combo.setBounds(160,25,50,20);
		combo.setSelectedIndex(StylesPreferences.clusterLineWidth-1);
		
		
		
		//add panels to the base
		thicknessPanel.add(label3);
		thicknessPanel.add(combo);
		
		base.add(thicknessPanel);
		
		//buttons
		okButton.setBounds(30, 250, 80, 25);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setBounds(140, 250, 80, 25);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				if (!dialog) toFront();
			}
		});
				
		setSize(265, 310);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		setVisible(false);
		parent.setDisplayDialogStatus(false);
		
		
		if (solid.isSelected()){
			StylesPreferences.clusterLineStyle = StylesPreferences.CLUSTER_LINE_SOLID;
		}
		else{
			StylesPreferences.clusterLineStyle = StylesPreferences.CLUSTER_LINE_DASHED;
		}
		
		try{
			int width = Integer.parseInt((String)combo.getSelectedItem());
			StylesPreferences.clusterLineWidth = width;
		}
		catch (Exception ex){}
		
		
		//this method produces a list of Residues that are defined by the parameters
		//and passes them to the StructureViewer to its method instead of firing an event
		//to a handler method
		
		viewer.updateClusterRenderables();
		
	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
	private ImageIcon createImageIcon(float[] color){
		
		BufferedImage m_image = new BufferedImage(50,10, BufferedImage.TYPE_INT_RGB);
		Graphics g = m_image.createGraphics();
		
		g.setColor(new Color(color[0], color[1], color[2]));
		g.fillRect(0,0,50,10);
		g.setColor(Color.black);
		g.drawRect(0,0,49,9);
		
		return new ImageIcon(m_image);
	}
	
	private ImageIcon createImageIcon(Color color){
		
		BufferedImage m_image = new BufferedImage(50,10, BufferedImage.TYPE_INT_RGB);
		Graphics g = m_image.createGraphics();
		g.setColor(color);
		g.fillRect(0,0,50,10);
		g.setColor(Color.black);
		g.drawRect(0,0,49,9);
		
		return new ImageIcon(m_image);
	}

	
}
