//Copyright (c) 2000-2002  San Diego Supercomputer Center (SDSC),
//a facility operated jointly by the University of California,
//San Diego (UCSD) and General Atomics, San Diego, California, USA.
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs;

import java.awt.*;
import edu.sdsc.mbt.*;

/**
 *  This class impements a color event object storing the user selections from the ColorDialog.
 *  <P>
 *  @see edu.sdsc.sirius.viewers.StructureViewer
 *  @see edu.sdsc.sirius.dialogs.DisplayDialog
 *  <P>
 *  @author Oleksandr V. Buzko
 */

public class ColorEvent implements DisplayDialogEvent {

	private DisplayDialog parent = null;
	
	/**
	 * Variable that denotes the set of atoms/bonds to be colored.
	 */
	public int setFlag;
	
	/**
	 * Variable that denotes the type of coloring: by element, by specified color, etc.
	 */
	public int colorType;
	
	/**
	 * The actual value of the chosen color.
	 */
	public Color structureColor;
	
	/**
	 * String representation of the component picked in the StructureViewer.
	 */
	public String componentId;
	
	public StructureComponent structureComponent;
	
	/**
	 * The constructor initialized with the parent dialog.
	 * @param d
	 */
	public ColorEvent(DisplayDialog d){
	
		parent = d;
	}

	/**
	 * Returns the source of the event.
	 */
	public DisplayDialog getSource(){
		return parent;
	}
	
	public int getSetFlag(){
		return setFlag;
	}
	
}