package edu.sdsc.sirius.dialogs;

// Core
// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class ComponentRenderingDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel stylePanel = new JPanel();
	private JPanel qPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	public static short styleFlag = StylesPreferences.RENDERING_LINES;
	public static short qualityFlag = StylesPreferences.RENDERING_FAST;
	
	private ButtonGroup styleGroup = new ButtonGroup();
	private JRadioButton radio6 = new JRadioButton("Lines", true);
	private JRadioButton radio7 = new JRadioButton("Stick", false);
	private JRadioButton radio8 = new JRadioButton("Ball and stick", false);
	private JRadioButton radio9 = new JRadioButton("Space-filling", false);
	
	private ButtonGroup qGroup = new ButtonGroup();
	private JRadioButton radio10 = new JRadioButton("Fast", true);
	private JRadioButton radio11 = new JRadioButton("Best", false);

	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private int width = 230;
	private int height = 315;
	
	
	public ComponentRenderingDialog(JFrame f, Manager p, StructureViewer s, String title, StructureComponent sc){
	
		super(f, title, false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		structureComponent = sc;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//reset the static variables
		styleFlag = StylesPreferences.RENDERING_LINES;
		qualityFlag = StylesPreferences.RENDERING_FAST;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 240));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 240);
		base.setLayout(null);
		
		//style panel
		stylePanel.setPreferredSize(new Dimension(200, 130));
		stylePanel.setLocation(new Point(5,0));
		stylePanel.setBounds(5,5,200,130);
		stylePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  Rendering style ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		stylePanel.setBorder(border);
		
		//second button group
		radio6.setLocation(25,25);
		radio6.setBounds(25,25,100,20);
		radio6.setVisible(true);
		radio6.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				styleFlag = StylesPreferences.RENDERING_LINES;
			}
		});
		
		radio7.setLocation(25,45);
		radio7.setBounds(25,45,100,20);
		radio7.setVisible(true);
		radio7.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				styleFlag = StylesPreferences.RENDERING_STICK;
			}
		});
		
		radio8.setLocation(25,65);
		radio8.setBounds(25,65,100,20);
		radio8.setVisible(true);
		radio8.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				styleFlag = StylesPreferences.RENDERING_BALL_STICK;
			}
		});
		
		radio9.setLocation(25,85);
		radio9.setBounds(25,85,100,20);
		radio9.setVisible(true);
		radio9.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				styleFlag = StylesPreferences.RENDERING_CPK;
			}
		});
		
		styleGroup.add(radio6);
		styleGroup.add(radio7);
		styleGroup.add(radio8);
		styleGroup.add(radio9);
		
		stylePanel.add(radio6);
		stylePanel.add(radio7);
		stylePanel.add(radio8);
		stylePanel.add(radio9);
		stylePanel.add(radio10);
		stylePanel.add(radio11);
		
		//quality settings panel
		qPanel.setPreferredSize(new Dimension(200, 100));
		qPanel.setLocation(new Point(5,135));
		qPanel.setBounds(5,135,200,100);
		qPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  Rendering quality ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		qPanel.setBorder(border);
		
		
		//radio buttons
		radio10.setLocation(25,25);
		radio10.setBounds(25,25,100,20);
		radio10.setVisible(true);
		radio10.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				qualityFlag = StylesPreferences.RENDERING_FAST;
			}
		});
		
		radio11.setLocation(25,45);
		radio11.setBounds(25,45,100,20);
		radio11.setVisible(true);
		radio11.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				qualityFlag = StylesPreferences.RENDERING_BEST;
			}
		});
		
		qGroup.add(radio10);
		qGroup.add(radio11);
		
		qPanel.add(radio10);
		qPanel.add(radio11);
		
		
		base.add(stylePanel);
		base.add(qPanel);
		
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(10, 255));
		okButton.setBounds(10, 255, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(110, 255));
		cancelButton.setBounds(110, 255, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		Dimension dim = getToolkit().getScreenSize();
		if ((parentFrame.getX() + parentFrame.getWidth() + width) > dim.getWidth()){
			setBounds(dim.width - width, parentFrame.getY(), width, height);
		}
		else{
			setBounds(parentFrame.getX() + parentFrame.getWidth(), parentFrame.getY(), width, height);
		}
		
		setSize(width, height);
		setResizable(false);

		setVisible(true);
		


	}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		try{
			
			setVisible(false);
			if (structureComponent.getStructureComponentType() == StructureComponentRegistry.TYPE_CHAIN){
				Chain chain = (Chain)structureComponent;
				if (chain.getResidueCount() > 50){
					//try to work out some sort of waiting message
				}
			}
			
			parent.setDisplayDialogStatus(false);
			structureComponent.structure.getStructureMap().getStructureStyles().setRenderingStyle(structureComponent, styleFlag, qualityFlag, true);
			structureComponent.structure.getStructureMap().getStructureStyles().setSelected(structureComponent, false, true, false);

///			parent.removeWaitScreen();
			parent.updateView();
		}
		catch (Exception e){
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception applying rendering style", e);
		}

		dispose();

	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
