package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class ComponentRibbonDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel typePanel = new JPanel();
	private JPanel qPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
		
	private ButtonGroup typeGroup = new ButtonGroup();
	private JRadioButton type1 = new JRadioButton("Rendered cartoon", true);
	private JRadioButton type2 = new JRadioButton("Round cross-section", false);
	private JRadioButton type3 = new JRadioButton("Cylindrical helices", false);
	private JRadioButton type4 = new JRadioButton("Backbone trace", false);
	
	
	private JSlider ribbonSlider;
	
	private int width = 230;
	private int height = 270;
	
	private boolean addRibbon = true;
	private Chain chain;
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	public static boolean ribbonDisplay = true;
	private int ribbonType = StylesPreferences.RIBBON_RENDERED;
	
	public ComponentRibbonDialog(JFrame f, Manager p, StructureViewer s, String title, Chain c, boolean add){

		super(f, title, false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		addRibbon = add;
		chain = c;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//reset static variables
		ribbonDisplay = true;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 210, 200);
		base.setLayout(null);

		//ribbon type panel
		typePanel.setBounds(5,5,200,130);
		typePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Ribbon type ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		typePanel.setBorder(border);
		

		//define the radio buttons
		type1.setFont(new Font("Dialog", Font.PLAIN, 12));
		type1.setBounds(20,20,150,20);
		type1.setVisible(true);
		type1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ribbonType = StylesPreferences.RIBBON_RENDERED;
			}
		});
		
		type2.setFont(new Font("Dialog", Font.PLAIN, 12));
		type2.setBounds(20,45,150,20);
		type2.setVisible(true);
		type2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ribbonType = StylesPreferences.RIBBON_UNIFORM_ROUND;
			}
		});

		type3.setFont(new Font("Dialog", Font.PLAIN, 12));
		type3.setBounds(20,70,150,20);
		type3.setVisible(true);
		type3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ribbonType = StylesPreferences.RIBBON_CYLINDER_HELICES;
			}
		});
		
		type4.setFont(new Font("Dialog", Font.PLAIN, 12));
		type4.setBounds(20,95,150,20);
		type4.setVisible(true);
		type4.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ribbonType = StylesPreferences.RIBBON_LINE;
			}
		});
		
		
		typePanel.add(type1);
		typePanel.add(type2);
		typePanel.add(type3);
		typePanel.add(type4);
		
		typeGroup.add(type1);
		typeGroup.add(type2);
		typeGroup.add(type3);
		typeGroup.add(type4);
		
		
		//quality panel
		qPanel.setBounds(5,135,200,60);
		qPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Ribbon quality ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		qPanel.setBorder(border);

		ribbonSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, (int)StylesPreferences.ribbonQuality);
		ribbonSlider.setBounds(35,25,120,25);
		ribbonSlider.setVisible(true);
		ribbonSlider.setPaintTicks(true);
		ribbonSlider.setSnapToTicks(true);
		ribbonSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		ribbonSlider.setMajorTickSpacing(1);
		
		JLabel low = new JLabel("Low");
		low.setFont(new Font("Dialog", Font.PLAIN, 11));
		low.setBounds(10,20,25,20);
		
		JLabel high = new JLabel("High");
		high.setFont(new Font("Dialog", Font.PLAIN, 11));
		high.setBounds(165,20,30,20);

		qPanel.add(ribbonSlider);
		qPanel.add(low);
		qPanel.add(high);
		
		base.add(typePanel);
		base.add(qPanel);
		
		//buttons
		okButton.setBounds(20, 210, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setBounds(120, 210, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		Dimension dim = getToolkit().getScreenSize();
		if ((parentFrame.getX() + parentFrame.getWidth() + width) > dim.getWidth()){
			setBounds(dim.width - width, parentFrame.getY(), width, height);
		}
		else{
			setBounds(parentFrame.getX() + parentFrame.getWidth(), parentFrame.getY(), width, height);
		}
		
		setSize(width, height);
		setResizable(false);
		setVisible(true);
		setVisible(true);

	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		try{
			setVisible(false);
	
			parent.setDisplayDialogStatus(false);
			if (addRibbon){
				sv.addRibbon(chain, ribbonType, ribbonSlider.getValue(), 1.0f, true);
			}
		}
		catch (Exception e){
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			e.printStackTrace();
		}

		dispose();

	}
	
/*	public static void main(String[] args){
	
		RibbonDialog rr = new RibbonDialog();
	}
*/	
}
