package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;
import edu.sdsc.sirius.contact.*;

public class ContactMapDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private ContactMapDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel setPanel1 = new JPanel();
	private JPanel setPanel2 = new JPanel();
	
	private JPanel subsetPanel1 = new JPanel();
	private JPanel subsetPanel2 = new JPanel();
	
	private JPanel typePanel = new JPanel();//contains process button
	
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private int width = 440;
	private int height = 310;
	
	
	private ButtonGroup group1 = new ButtonGroup();
	private JRadioButton select1 = new JRadioButton("Select structure from list", true);
	private JRadioButton pick1 = new JRadioButton("Pick structure in display", false);
	
	private ButtonGroup group2 = new ButtonGroup();
	private JRadioButton select2 = new JRadioButton("Select structure from list", true);
	private JRadioButton pick2 = new JRadioButton("Pick structure in display", false);
	
	private JTextField field1 = new JTextField(30);
	private JTextField field2 = new JTextField(30);
	
	private Atom[] atoms = new Atom[2];

	private JLabel label11 = new JLabel();
	private JLabel label12 = new JLabel();
	
	private JLabel label21 = new JLabel();
	private JLabel label22 = new JLabel();
	
	private JRadioButton type1 = new JRadioButton("Single structure interaction map");
	private JRadioButton type2 = new JRadioButton("Comparison of two structures");
	private ButtonGroup typeGroup = new ButtonGroup();
	
	private JTextField activeField = field1;

	private JComboBox combo11 = new JComboBox();
	private Vector structures1 = new Vector();

	private JComboBox combo21 = new JComboBox();
	private Vector structures2 = new Vector();

	private Structure structure1;
	private Structure structure2;

	private Structure structureOut1;
	private Structure structureOut2;

	public ContactMapDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Calculate residue contact map", false);

		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(false);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 425, 240);
		base.setLayout(null);
		
		//mid panel
		typePanel.setBounds(5,5,415,80);
		typePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Type of operation ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		typePanel.setBorder(border);
		
		type1.setBounds(25,20,300,20);
		type1.setSelected(true);
		type1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				field2.setEnabled(false);
				combo21.setEnabled(false);
				pick2.setEnabled(false);
				select2.setEnabled(false);
			}
		});
		
		type2.setBounds(25,45,300,20);
		type2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				field2.setEnabled(true);
				if (structures2.size() > 1) combo21.setEnabled(true);
				pick2.setEnabled(true);
				select2.setEnabled(true);
			}
		});
		
		typePanel.add(type1);
		typePanel.add(type2);
		
		typeGroup.add(type1);
		typeGroup.add(type2);
		
		base.add(typePanel);

		
		
		setPanel1.setBounds(5,85,205,150);
		setPanel1.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " First structure ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel1.setBorder(border);
		

		label11.setForeground(Color.black);
		label11.setFont(new Font("Dialog", Font.PLAIN, 11));
		label11.setText("Structure:");
		label11.setBounds(25,50,60,20);
		label11.setVisible(true);
		
		//walk through the loaded structures
		structures1.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures1.add(sv.getStructureName(st));
		}
		
		combo11 = new JComboBox(structures1);
		combo11.setBounds(85,50,100,20);
		combo11.setVisible(true);
		if (structures1.size() == 1) combo11.setEnabled(false);
		combo11.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				try{
					structure1 = (Structure)sv.getLoadedStructures().get(combo11.getSelectedIndex() - 1);
				}
				catch (Exception ex){}
			}
		});
		
		
		label12.setForeground(Color.black);
		label12.setFont(new Font("Dialog", Font.PLAIN, 11));
		label12.setText("Chain:");
		label12.setBounds(30,80,40,20);
		label12.setVisible(true);

		
		select1.setBounds(20,20,180,20);
		select1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (structures1.size() > 1) combo11.setEnabled(true);
//				combo12.setEnabled(true);
				field1.setText("");
				field1.setEnabled(false);
				field1.setEditable(false);
			}
		});
		
		pick1.setBounds(20,80,150,20);
		pick1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				combo11.setEnabled(false);
				field1.setEnabled(true);
				field1.setEditable(true);
				field1.requestFocus();
				activeField = field1;
			}
		});
		
		field1.setBounds(85, 110, 100, 20);
		field1.setEnabled(false);
		field1.setEditable(false);
		field1.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field1;
			}
		});

		setPanel1.add(label11);
		setPanel1.add(combo11);
		setPanel1.add(select1);
		setPanel1.add(pick1);
		setPanel1.add(field1);
		
		group1.add(select1);
		group1.add(pick1);
		
		
		
		///second set panel
		setPanel2.setBounds(215,85,205,150);
		setPanel2.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Second structure ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel2.setBorder(border);
		
		label21.setForeground(Color.black);
		label21.setFont(new Font("Dialog", Font.PLAIN, 11));
		label21.setText("Structure:");
		label21.setBounds(25,50,60,20);
		label21.setVisible(true);
		
		//walk through the loaded structures
		structures2.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures2.add(sv.getStructureName(st));
		}
		
		combo21 = new JComboBox(structures2);
		combo21.setBounds(85,50,100,20);
		combo21.setVisible(true);
		if (structures2.size() == 1) combo21.setEnabled(false);
		combo21.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				try{
					structure2 = (Structure)sv.getLoadedStructures().get(combo21.getSelectedIndex() - 1);
				}
				catch (Exception ex){}
			}
		});
		
		label22.setForeground(Color.black);
		label22.setFont(new Font("Dialog", Font.PLAIN, 11));
		label22.setText("Chain:");
		label22.setBounds(30,80,40,20);
		label22.setVisible(true);

		select2.setBounds(20,20,180,20);
		select2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (structures2.size() > 1) combo21.setEnabled(true);
//				combo12.setEnabled(true);
				field2.setText("");
				field2.setEnabled(false);
				field2.setEditable(false);
			}
		});
		
		pick2.setBounds(20,80,150,20);
		pick2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				combo21.setEnabled(false);
				field2.setEnabled(true);
				field2.setEditable(true);
				field2.requestFocus();
				activeField = field2;
			}
		});
		
		field2.setBounds(85, 110, 100, 20);
		field2.setEnabled(false);
		field2.setEditable(false);
		field2.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field2;
			}
		});
		
		field2.setEnabled(false);
		combo21.setEnabled(false);
		pick2.setEnabled(false);
		select2.setEnabled(false);
		

		setPanel2.add(label21);
		setPanel2.add(combo21);
		setPanel2.add(select2);
		setPanel2.add(pick2);
		setPanel2.add(field2);
		
		group2.add(select2);
		group2.add(pick2);

		
		
		//add panels to the base
		base.add(setPanel1);
		base.add(setPanel2);
		
		
		
		contentPane.add(base);
		
		JButton okButton = new JButton("OK");
		okButton.setBounds(120,250,80,25);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				process();
			}
		});
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.setBounds(240,250,80,25);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
		});
				
		Dimension dim = getToolkit().getScreenSize();
		
		//position the panel next to the main window on the right
		//if it ends up being wider than screen, fit it to the width of the screen
		if ((parentFrame.getX() + parentFrame.getWidth() + width) > dim.getWidth()){
			setBounds(dim.width - width, parentFrame.getY(), width, height);
		}
		else{
			setBounds(parentFrame.getX() + parentFrame.getWidth(), parentFrame.getY(), width, height);
		}

		setResizable(false);
		setVisible(true);
		


	}
	
	private void process(){
		
		try{
			//add error checking for selection bounds
			//eg., selection level is residue, but entered only structure name
			
			
			//get the chains to be aligned
			if (select1.isSelected()){
				//get the choice from the combo box
				structureOut1 = structure1;
			}
			else if (pick1.isSelected()){
				//get the picked chain
				if (atoms[0] != null){
					structureOut1 = atoms[0].structure;
				}
				
				if (structureOut1 == null){
					//try getting it out of the text in the field
					structureOut1 = (Structure)sv.labelToObject(field1.getText());
				}
				
				if (structureOut1 == null){
					parent.displayErrorMessage("Unable to identify the first structure. Please try again");
					return;
				}
			}
			
			if (type2.isSelected()){
				if (select2.isSelected()){
					//get the choice from the combo box
					structureOut2 = structure2;
				}
				else if (pick2.isSelected()){
					//get the picked chain
					if (atoms[1] != null){
						structureOut2 = atoms[1].structure;
					}
					
					if (structureOut2 == null){
						//try getting it out of the text in the field
						structureOut2 = (Structure)sv.labelToObject(field2.getText());
					}
					
					if (structureOut2 == null){
						parent.displayErrorMessage("Unable to identify the second structure. Please try again");
						return;
					}
				}
			}
			
			
			if (structureOut1 == null && structureOut2 == null){
				parent.displayErrorMessage("Unable to identify one or both structures. Please try again.");
				return;
			}
			
			//check whether these structures are actually proteins
			//we need to have at least two amino acids in each of them
			if (structureOut1 != null){
				int count = 0;
				StructureMap map = structureOut1.getStructureMap();
				for (int i = 0; i < map.getResidueCount(); i++){
					Residue r = map.getResidue(i);
					if (r.getClassification().equals(Residue.COMPOUND_AMINO_ACID)){
						count++;
					}
				}
				
				if (count < 2){
					parent.displayErrorMessage("Structure(s) must contain at least two amino acids to generate an interaction map.");
					return;
				}
			}
			
			if (structureOut2 != null){
				int count = 0;
				StructureMap map = structureOut2.getStructureMap();
				for (int i = 0; i < map.getResidueCount(); i++){
					Residue r = map.getResidue(i);
					if (r.getClassification().equals(Residue.COMPOUND_AMINO_ACID)){
						count++;
					}
				}
				
				if (count < 2){
					parent.displayErrorMessage("Structure(s) must contain at least two amino acids to generate an interaction map.");
					return;
				}
			}
			
			
			//once the interaction maps are completed, start the viewer and close this dialog
			Thread runner = new Thread(){
				public void run(){
					ContactMapViewer viewer = parent.getContactMapViewer();
					parent.openContactMapViewer(structureOut1, structureOut2);
				}
			};
			runner.start();
			setVisible(false);
			dispose();
			
		}
		catch (Exception e){
			parent.setDisplayDialogStatus(false);
			dispose();
			parent.displayExceptionMessage("Exception in structure alignment", e);
		}
		
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		activeField.setText(data);
		//move focus along only if something has been picked
		if (data.length() > 0){
			if (activeField == field1){
				atoms[0] = (Atom)structureComponent;
				if (field2.isEnabled()){
					activeField = field2;
					field2.requestFocus();
				}
			}
			else{
				atoms[1] = (Atom)structureComponent;
			}
		}
	}
	
	
}
