package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class CreateBondDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	private Atom[] atoms = new Atom[2];
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	
	
	private JLabel label1 = new JLabel();
	private JTextField field1 = new JTextField(30);
	private JLabel label2 = new JLabel();
	private JTextField field2 = new JTextField(30);
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JTextField activeField = field1;//is used to figure out which field should accept pick input from StructureViewer
	
	
	public CreateBondDialog(JFrame f, Manager p, StructureViewer s){
	
		super(f, "Create bond", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
//		System.out.println("Starting");
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 130));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 130);
		base.setLayout(null);
		
		
		//object field
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 12));
		label1.setText("1st atom: enter name or click");
		label1.setPreferredSize(new Dimension(170,20));
		label1.setBounds(15,15,190,20);
		label1.setLocation(new Point(15,15));
		label1.setVisible(true);
		
		field1.setPreferredSize(new Dimension(170,20));
		field1.setBounds(15,40,170,20);
		field1.setLocation(new Point(15,40));
		field1.setEditable(true);
		field1.setEnabled(true);
		field1.setVisible(true);
		field1.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field1;
			}
		});
		
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 12));
		label2.setText("2nd atom: enter name or click");
		label2.setPreferredSize(new Dimension(190,20));
		label2.setBounds(15,65,190,20);
		label2.setLocation(new Point(15,65));
		label2.setVisible(true);
		
		field2.setPreferredSize(new Dimension(170,20));
		field2.setBounds(15,90,170,20);
		field2.setLocation(new Point(15,90));
		field2.setEditable(true);
		field2.setEnabled(true);
		field2.setVisible(true);
		field2.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field2;
			}
		});
		
		
		base.add(label1);
		base.add(field1);
		base.add(label2);
		base.add(field2);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 140));
		okButton.setBounds(20, 140, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
			
				//add error checking for selection bounds
				//eg., selection level is residue, but entered only structure name
				try{
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					if (atoms[0] == null || atoms[1] == null || field1.getText().length() == 0 || field2.getText().length() == 0){
						parent.displayErrorMessage("Two atoms must be selected to measure distance");
					}
					else{
						StructureEvent event = new StructureEvent(itself);
						event.atomLabels.add(field1.getText());
						event.atomLabels.add(field2.getText());
						event.atoms.add(atoms[0]);
						event.atoms.add(atoms[1]);
						event.eventType = StructureEventRegistry.CREATE_BOND;
						sv.processDisplayDialogEvent(event);
					}
				}
				catch (Exception e){
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					parent.displayExceptionMessage("Exception creating bond", e);

				}

				dispose();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 140));
		cancelButton.setBounds(120, 140, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(230, 195);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}



		setVisible(true);
		


	}
	
	public void processPick(String data, StructureComponent structureComponent){

		activeField.setText(data);
		//move focus along only if something has been picked
		if (data.length() > 0){
			if (activeField == field1){
				atoms[0] = (Atom)structureComponent;
				activeField = field2;
				field2.requestFocus();
			}
			else{
				atoms[1] = (Atom)structureComponent;
			}
		}
	}
	
}
