package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.io.*;
import edu.sdsc.sirius.util.Manager;

import edu.sdsc.sirius.viewers.SequenceViewerImpl.*;

public class CreateSequenceDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	
	
	private JLabel label1 = new JLabel();
	private JTextField field1 = new JTextField(30);
	private JLabel label2 = new JLabel();
	private JScrollPane pane;
	private JTextArea area = new JTextArea(7, 30);
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
		
	public CreateSequenceDialog(JFrame f, Manager p){
	
		super(f, "Create new sequence", true);
	
		parentFrame = f;
		parent = p;
		
//		System.out.println("Starting");
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(400, 250));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 400, 250);
		base.setLayout(null);
		
		
		//object field
		label1.setForeground(Color.black);
//		label1.setFont(new Font("Dialog", Font.PLAIN, 12));
		label1.setText("New sequence name: ");
		label1.setPreferredSize(new Dimension(150,20));
		label1.setBounds(15,20,150,20);
		label1.setLocation(new Point(15,20));
		label1.setVisible(true);
		
		field1.setPreferredSize(new Dimension(130,20));
		field1.setBounds(255,20,130,20);
		field1.setLocation(new Point(255,20));
		field1.setEditable(true);
		field1.setEnabled(true);
		field1.setVisible(true);
		
		label2.setForeground(Color.black);
//		label2.setFont(new Font("Dialog", Font.PLAIN, 12));
		label2.setText("Sequence:");
		label2.setPreferredSize(new Dimension(80,20));
		label2.setBounds(15,45,80,20);
		label2.setLocation(new Point(15,45));
		label2.setVisible(true);
		
		area.setEditable(true);
		area.setEnabled(true);
		area.setVisible(true);
		area.setFont(new Font( "Monospaced", Font.PLAIN, 14 ));
		
		pane = new JScrollPane(area);
		pane.setPreferredSize(new Dimension(370,150));
		pane.setBounds(15,70,370,150);
		pane.setLocation(new Point(15,70));
		pane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		pane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);

		
		
		base.add(label1);
		base.add(field1);
		base.add(label2);
		base.add(pane);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(110, 260));
		okButton.setBounds(110, 260, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
			
				try{
					if (area.getText().length() == 0){
						parent.displayErrorMessage("Sequence has not been specified.");
						return;
					}
					
					String name = field1.getText().trim();
					String sequence = area.getText().trim().toUpperCase();
					String description = "";
					
					if (name.length() == 0 && !sequence.startsWith(">")){
						parent.displayErrorMessage("Name has not been specified.");
						return;
					}
					
					if (name.length() == 0){
						//get the name out of the fasta formatted sequence
						int index = sequence.indexOf("\n");
						String start = sequence.substring(sequence.indexOf(">")+1, index);
						sequence = sequence.substring(index+1);
						
						//trim everything after the first space. if anything is left, make it a description
						int space = start.indexOf(" ");
						if (space == -1){
							//make it all name
							name = start;
						}
						else{
							name = start.substring(0, space);
							description = start.substring(space+1);
						}
					}
					
					//just in case: read only the first ">"-tagged sequence
					int j = sequence.indexOf(">");
					if (j != -1){
						sequence = sequence.substring(0, j);
					}
					
					//remove newlines from the sequence
					Pattern pattern = Pattern.compile("\n");
					Pattern pattern2 = Pattern.compile("\r");
					Matcher matcher = pattern.matcher(sequence);
					String compressed = matcher.replaceAll("");
					Matcher m = pattern2.matcher(compressed);
					String out = m.replaceAll("");

					//check the resulting string to make sure there are only allowed characters
					//(letters, * and #)
					char[] characters = out.toCharArray();
					for (int i = 0; i < characters.length; i++){
						char item = characters[i];
						if (item >= 'A' && item <= 'z') continue;
						else if (item == '*') continue;
						else if (item == '#') continue;
						else{
							parent.displayErrorMessage("Entered sequence contains illegal characters.");
							return;
						}
					}
					
					//create a SequenceEntry
					parent.setDisplayDialogStatus(false);
					
					SequenceEntry entry = new SequenceEntry();
					entry.setName(name);
					
					Sequence sequenceObject = new Sequence(name, out);
					//add cells to the sequence object
					Cell[] cells = new Cell[out.length()];
					for (int i = 0; i < out.length(); i++){
						cells[i] = new Cell(sequenceObject, i, out.substring(i, i+1));
					}
					sequenceObject.setCells(cells);
					
					entry.setSequence(sequenceObject);
					entry.setDescription(description);
					parent.addEntry(entry, true, false);
					
				}
				catch (Exception e){
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					parent.displayExceptionMessage("Exception creating sequence", e);

				}

				dispose();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(230, 260));
		cancelButton.setBounds(230, 260, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
		});
		
		
		
		setSize(420, 320);

		if (parentFrame == null){
			setLocationRelativeTo(null);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);

			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		setVisible(true);
		


	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
