//Copyright (c) 2000-2002  San Diego Supercomputer Center (SDSC),
//a facility operated jointly by the University of California,
//San Diego (UCSD) and General Atomics, San Diego, California, USA.
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs;

/**
 *  This class contains constants used by the dialogs originating from the SequenceViewer.
 *  <P>
 *  @see edu.sdsc.sirius.viewers.SequenceViewer
 *  @see edu.sdsc.sirius.dialogs.SequenceDialog
 *  <P>
 *  @author Oleksandr V. Buzko
 */
public class DialogConstants {

	/**
	 * Loading option: ignore sequence selection in the SequenceViewer.
	 */
	public static final int SELECTED_IGNORE = 0;

	/**
	 * Loading option: use selected sequences in the SequenceViewer.
	 */
	public static final int SELECTED_USE = 1;

	/**
	 * Loading option: omit selected sequences in the SequenceViewer.
	 */	
	public static final int SELECTED_OMIT = 2;
	
	/**
	 * Sequence set option: use sequences loaded in the SequenceViewer.
	 */
	public static final int USE_LOADED = 0;

	/**
	 * Sequence set option: use sequences from the database.
	 */	
	public static final int USE_DEFINED = 1;
	
	/**
	 * Reference sequence option: use selected sequence as reference.
	 */
	public static final int REFERENCE_SELECTED = 0;
	
	/**
	 * Reference sequence option: reference sequence is is typed in the dialog.
	 */
	public static final int REFERENCE_DEFINED = 1;
	
	/**
	 * Use the common ruler to define the residue numbers.
	 */
	public static final int REFERENCE_COMMON = 2;

	public static final int APPLY_SELECTION = 0;
	public static final int APPLY_ATOM = 4;
	public static final int APPLY_RESIDUE = 3;
	public static final int APPLY_CHAIN = 2;
	public static final int APPLY_STRUCTURE = 1;
	public static final int APPLY_ALL = 5;//apply to everything that's loaded in the viewer
	public static final int APPLY_VISIBLE = 6;//apply to everything that's loaded in the viewer
	
	public static final int ADD_SELECTION = 0;
	public static final int REPLACE_SELECTION = 1;
	
	
	public static int level = 74;//pixels from the top of the frame to the top of the dialog frame
	public static int toolbarWidth = 0;
	public static int toolbarHeight = 0;
	
	
}