package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class DihedralDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	
	private Atom[] atoms = new Atom[4];
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	
	
	private JLabel label1 = new JLabel();
	private JTextField field1 = new JTextField(30);
	private JLabel label2 = new JLabel();
	private JTextField field2 = new JTextField(30);
	private JLabel label3 = new JLabel();
	private JTextField field3 = new JTextField(30);
	private JLabel label4 = new JLabel();
	private JTextField field4 = new JTextField(30);
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JTextField activeField = field1;//is used to figure out which field should accept pick input from StructureViewer
	
	
	public DihedralDialog(JFrame f, Manager p, StructureViewer s){
	
		super(f, "Measure dihedral angle", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
//		System.out.println("Starting");
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 230));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 230);
		base.setLayout(null);
		
		
		//object field
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 12));
		label1.setText("1st atom: enter name or click");
		label1.setPreferredSize(new Dimension(170,20));
		label1.setBounds(15,15,190,20);
		label1.setLocation(new Point(15,15));
		label1.setVisible(true);
		
		field1.setPreferredSize(new Dimension(170,20));
		field1.setBounds(15,40,170,20);
		field1.setLocation(new Point(15,40));
		field1.setEditable(true);
		field1.setEnabled(true);
		field1.setVisible(true);
		field1.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field1;
			}
		});
		
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 12));
		label2.setText("2nd atom: enter name or click");
		label2.setPreferredSize(new Dimension(190,20));
		label2.setBounds(15,65,190,20);
		label2.setLocation(new Point(15,65));
		label2.setVisible(true);
		
		field2.setPreferredSize(new Dimension(170,20));
		field2.setBounds(15,90,170,20);
		field2.setLocation(new Point(15,90));
		field2.setEditable(true);
		field2.setEnabled(true);
		field2.setVisible(true);
		field2.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field2;
			}
		});
		
		label3.setForeground(Color.black);
		label3.setFont(new Font("Dialog", Font.PLAIN, 12));
		label3.setText("3rd atom: enter name or click");
		label3.setPreferredSize(new Dimension(190,20));
		label3.setBounds(15,115,190,20);
		label3.setLocation(new Point(15,115));
		label3.setVisible(true);
		
		field3.setPreferredSize(new Dimension(170,20));
		field3.setBounds(15,140,170,20);
		field3.setLocation(new Point(15,140));
		field3.setEditable(true);
		field3.setEnabled(true);
		field3.setVisible(true);
		field3.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field3;
			}
		});
		
		label4.setForeground(Color.black);
		label4.setFont(new Font("Dialog", Font.PLAIN, 12));
		label4.setText("4th atom: enter name or click");
		label4.setPreferredSize(new Dimension(190,20));
		label4.setBounds(15,165,190,20);
		label4.setLocation(new Point(15,165));
		label4.setVisible(true);
		
		field4.setPreferredSize(new Dimension(170,20));
		field4.setBounds(15,190,170,20);
		field4.setLocation(new Point(15,190));
		field4.setEditable(true);
		field4.setEnabled(true);
		field4.setVisible(true);
		field4.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field3;
			}
		});
		
		
		base.add(label1);
		base.add(field1);
		base.add(label2);
		base.add(field2);
		base.add(label3);
		base.add(field3);
		base.add(label4);
		base.add(field4);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 240));
		okButton.setBounds(20, 240, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
			
				//add error checking for selection bounds
				//eg., selection level is residue, but entered only structure name
			
				try{
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					if (atoms[0] == null || atoms[1] == null || atoms[2] == null || atoms[3] == null){
						parent.displayErrorMessage("Four atoms must be selected to compute a dihedral angle");
						return;
					}
					else{
						GeometryEvent event = new GeometryEvent(itself);
						event.atomLabels.add(field1.getText());
						event.atomLabels.add(field2.getText());
						event.atomLabels.add(field3.getText());
						event.atomLabels.add(field4.getText());
					
		
						event.atoms.add(atoms[0]);
						event.atoms.add(atoms[1]);
						event.atoms.add(atoms[2]);
						event.atoms.add(atoms[3]);
						sv.processDisplayDialogEvent(event);
					}
				}
				catch (Exception e){
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					parent.displayExceptionMessage("Exception measuring dihedral angle", e);

				}

				dispose();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 240));
		cancelButton.setBounds(120, 240, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(230, 300);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}



		setVisible(true);
		


	}
	
	public void processPick(String data, StructureComponent structureComponent){

		activeField.setText(data);
		//move focus only if something has been picked
		if (data.length() > 0){
			if (activeField == field1){
				atoms[0] = (Atom)structureComponent;
				activeField = field2;
				field2.requestFocus();
			}
			else if (activeField == field2){
				atoms[1] = (Atom)structureComponent;
				activeField = field3;
				field3.requestFocus();
			}
			else if (activeField == field3){
				atoms[2] = (Atom)structureComponent;
				activeField = field4;
				field4.requestFocus();
			}
			else{
				atoms[3] = (Atom)structureComponent;
			}
		}
	}
	
}
