//Copyright (c) 2000-2002  San Diego Supercomputer Center (SDSC),
//a facility operated jointly by the University of California,
//San Diego (UCSD) and General Atomics, San Diego, California, USA.
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs;
import java.awt.*;
import javax.swing.*;
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.mbt.util.*;

/**
 * Used in atom replacement dialog to pick the new element
 * @author Oleksandr V. Buzko
 *
 */
public class ElementSelectionDialog extends JDialog {
	
	private JFrame parent;
	private Container container;
	private JPanel basel;
	private ElementSelectionPanel pte;
	private ElementSettable settable;
	
	private ElementPreferences preferences = null;
	
	private final float[][] colors = new float[PeriodicTable.getElementCount()][3];
	
	public ElementSelectionDialog(JFrame p, String title, ElementSettable d){
	
		super( p, title, true );
		
		parent = p;
		settable = d;
		
		preferences = new ElementPreferences();
		preferences.getCurrentConfiguration();//at least temporarily, to have defaults
		preferences.readPreferences();
		preferences.applyConfiguration();
		
		container = getContentPane( );
		container.setLayout( new BorderLayout() );
		pte = new ElementSelectionPanel(this);
		container.add( pte, BorderLayout.CENTER );
		
		setSize( 640, 480 );

		if (parent == null){
//			setLocationRelativeTo(null);
			setBounds(200, 200, getSize().width, getSize().height);
		}
		else{
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parent.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);
		
			setBounds(x + parent.getX(), y + parent.getY(), d1.width, d1.height);
		}

		
		
		
		setVisible( true );
	
	
	}
	
	public void setElement(String element){
		settable.setElement(element);
		setVisible(false);
		dispose();
	}
	
}