//Copyright (c) 2000-2002  San Diego Supercomputer Center (SDSC),
//a facility operated jointly by the University of California,
//San Diego (UCSD) and General Atomics, San Diego, California, USA.
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.mbt.util.*;
import edu.sdsc.sirius.util.Manager;


public class ElementStylesDialog extends JDialog {
	
	private JFrame parent = null;
	private Manager callable = null;
	private Container container = null;
	private JPanel base = null;
	private ElementStylesEditor pte = null;
	private JPanel buttonPanel = new JPanel();
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	private JButton defaultButton = new JButton("Default");
	
	private ElementPreferences preferences = null;
	
	private final float[][] colors = new float[PeriodicTable.getElementCount()][3];
	
	public ElementStylesDialog(JFrame p, Manager c){
	
		super( p, "Element Color Editor", true );
		
		parent = p;
		callable = c;
		
		preferences = new ElementPreferences();
		preferences.getCurrentConfiguration();//at least temporarily, to have defaults
		preferences.readPreferences();
		preferences.applyConfiguration();
		
		container = getContentPane( );
		container.setLayout( new BorderLayout() );
		pte = new ElementStylesEditor( );
		container.add( pte, BorderLayout.CENTER );
		
		//get the colors before any changes in case "cancel" is clicked
		for (int i = 1; i < PeriodicTable.getElementCount(); i++){
			final float[] temp = ElementProperties.getElementColor(i);
			colors[i][0] = temp[0];
			colors[i][1] = temp[1];
			colors[i][2] = temp[2];
		}

		//take care of the buttons
		//panel that holds buttons
		JPanel lowerPanel = new JPanel();
		lowerPanel.setLayout(new BorderLayout());
		JPanel borderPanel = new JPanel();
		borderPanel.setLayout(new BorderLayout());
		borderPanel.add(new JSeparator(), BorderLayout.NORTH);
		
		lowerPanel.add(borderPanel, BorderLayout.NORTH);
		
		buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 40, 5));
		
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				//write the current settings in ElementStyles to preferences
				preferences.getCurrentConfiguration();
				preferences.writePreferences();
				callable.updateAppearance();
				setVisible(false);
				dispose();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				//restore defaults from the colors array
				for (int i = 1; i < colors.length; i++){
					ElementProperties.setElementColor(i, colors[i][0], colors[i][1], colors[i][2]);
				}
				preferences.getCurrentConfiguration();
				preferences.writePreferences();
				setVisible(false);
				dispose();
			}
		});
		
		defaultButton.setPreferredSize(new Dimension(80,25));
		defaultButton.setVisible(true);
		defaultButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ElementProperties.setDefaultElementColors();
				preferences.getCurrentConfiguration();
				preferences.writePreferences();
				callable.updateAppearance();
				setVisible(false);
				dispose();
			}
		});
		
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);
		buttonPanel.add(defaultButton);
		
		
		lowerPanel.add(buttonPanel, BorderLayout.CENTER);
		
//		contentPane.add(buttonPanel, BorderLayout.SOUTH);
		container.add(lowerPanel, BorderLayout.SOUTH);
	
		
		setSize( 640, 480 );

		if (parent == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parent.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);
		
			setBounds(x + parent.getX(), y + parent.getY(), d1.width, d1.height);
		}

		
		
		
		setVisible( true );
	
	
	}
	
	
}