package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;


public class FogDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();

	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	public JSlider fSlider;
	public JSlider bSlider;
	
	private float oldFogNear;
	private float oldFogFar;//to return to if "cancel" is hit
	
	private Border border1 = null;
	private TitledBorder border2 = null;
	private Border border = null;
	
	private JCheckBox check = null;
	private boolean initialCheckStatus = false;
	
	private double near = 0.0;
	private double far = 100.0;
	private double wall = 110;
	
	private float fogNear = 1.0f;
	private float fogFar = 100.0f;
	
	private final float fogMin = 1.0f;//minimum fog distance
	
		
	public FogDialog(JFrame f, Manager p, StructureViewer s){

//	public FogDialog(){

		super((JFrame)null, "Depth perception settings", false);
		
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//get the initial settings of the 3D environment
		near = sv.getGeometryViewer().getNearDistance();
		far = sv.getGeometryViewer().getFarDistance();
		
		fogNear = sv.getGeometryViewer().getFogNear();
		fogFar = sv.getGeometryViewer().getFogFar();
		
		oldFogNear = fogNear;
		oldFogFar = fogFar;
		
		//the extent of the presented space will be from the camera to the wall
		double span = far - near;
		wall = far + span/2;//extra space beyond the structure
		
		if (wall < fogFar) wall = fogFar + 1;
		
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(250, 200));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 250, 200);
		base.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Depth cue adjustment ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		base.setBorder(border);

		check = new JCheckBox("Enable depth cueing");
		check.setSelected(StylesPreferences.fogEnabled);
		initialCheckStatus = check.isSelected();
//		System.out.println("Initial check status = " + initialCheckStatus);
		check.setPreferredSize(new Dimension(200, 20));
		check.setLocation(new Point(15,25));
		check.setBounds(15, 25, 200, 20);
		check.setVisible(true);
		
		
		check.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				fSlider.setEnabled(check.isSelected());
				bSlider.setEnabled(check.isSelected());
				
				//update fog with the current settings
				if (check.isSelected()){
					//set fog with the current values
					sv.getGeometryViewer().setFog(true, fogNear, fogFar, true);
				}
				else{
					//remove fog
					sv.getGeometryViewer().setFog( false, fogNear, fogFar, true);
				}
				
			}
		});
		
				
		JLabel label1 = new JLabel("Front fog plane");
		label1.setFont(new Font("Dialog", Font.PLAIN, 11));
		label1.setPreferredSize(new Dimension(200,20));
		label1.setBounds(20,50,200,20);
		label1.setLocation(new Point(20,50));
		label1.setVisible(true);
		
		//calculate position for the front slider
		double fRatio = fogNear/wall;
		
		fSlider = new JSlider(JSlider.HORIZONTAL, 0, 100, (int)(100*fRatio));
		fSlider.setLocation(new Point(15, 70));
		fSlider.setBounds(15, 70, 215, 45);
		fSlider.setPreferredSize(new Dimension(215,45));
		fSlider.setVisible(true);
		fSlider.setMajorTickSpacing(20);
		fSlider.setMinorTickSpacing(10);
		fSlider.setPaintTicks(true);
		fSlider.setPaintLabels(true);
		fSlider.setEnabled(check.isSelected());
	    
		fSlider.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				int value = fSlider.getValue();
				if (value >= bSlider.getValue()){
					fSlider.setValue(bSlider.getValue()-1);
					value = fSlider.getValue();
					fSlider.updateUI();
				}
				fogNear = ((float)value/100)*(float)wall;	
				sv.getGeometryViewer().setFog(true, fogNear, fogFar, true);
			}
		});
		
		JLabel label2 = new JLabel("Back fog plane");
		label2.setFont(new Font("Dialog", Font.PLAIN, 11));
		label2.setPreferredSize(new Dimension(200,20));
		label2.setBounds(20,115,200,20);
		label2.setLocation(new Point(20,115));
		label2.setVisible(true);

		double bRatio = fogFar/wall;

		bSlider = new JSlider(JSlider.HORIZONTAL, 0, 100, (int)(100*bRatio));
		bSlider.setLocation(new Point(15, 135));
		bSlider.setBounds(15, 135, 215, 45);
		bSlider.setPreferredSize(new Dimension(215,45));
		bSlider.setVisible(true);
		bSlider.setMajorTickSpacing(20);
		bSlider.setMinorTickSpacing(10);
		bSlider.setPaintTicks(true);
		bSlider.setPaintLabels(true);
		bSlider.setEnabled(check.isSelected());
		    
		bSlider.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				int value = bSlider.getValue();
				if (value <= fSlider.getValue()){
					bSlider.setValue(fSlider.getValue()+1);
					bSlider.updateUI();
					value = bSlider.getValue();
				}
				fogFar = ((float)value/100)*(float)wall;				
				sv.getGeometryViewer().setFog(true, fogNear, fogFar, true);
			}
		});
		
		base.add(check);
		base.add(label1);
		base.add(fSlider);
		base.add(label2);
		base.add(bSlider);
		
		
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(40, 210));
		okButton.setBounds(40, 210, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				StylesPreferences.fogEnabled = check.isSelected();
				dispose();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(140, 210));
		cancelButton.setBounds(140, 210, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				sv.getGeometryViewer().setFog(true, oldFogNear, oldFogFar, true);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(265, 270);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			setLocationRelativeTo(null);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		
	}
	
	public void processPick(String data, StructureComponent c){}
	
}
