package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

import edu.sdsc.sirius.lsp.*;

public class GraphDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private GraphDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel setPanel1 = new JPanel();
	private JPanel setPanel2 = new JPanel();
	
	private JPanel subsetPanel1 = new JPanel();
	private JPanel subsetPanel2 = new JPanel();
	
	private JPanel midPanel = new JPanel();//contains process button
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton matrix1 = new JRadioButton("Relaxed residue similarity matrix", false);
	private JRadioButton matrix2 = new JRadioButton("Restrictive residue similarity matrix", true);
	private JRadioButton matrix3 = new JRadioButton("Identity matrix", false);
	
	private JPanel cutoffPanel = new JPanel();
	private ButtonGroup cutoffGroup = new ButtonGroup();
	private JRadioButton cutoff1 = new JRadioButton("10 A", false);
	private JRadioButton cutoff2 = new JRadioButton("12 A", false);
	private JRadioButton cutoff3 = new JRadioButton("15 A", true);
	private JRadioButton cutoff4 = new JRadioButton("20 A", false);
	
	
	
	private JPanel namePanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private int width = 440;
	private int height = 380;
	
	private String setName1;
	
	private Atom[] atoms = new Atom[2];

	private JLabel label11 = new JLabel();
	private JLabel label12 = new JLabel();
	
	private JLabel label21 = new JLabel();
	private JLabel label22 = new JLabel();
	
	private JButton cancelButton = new JButton("Cancel");
	private JButton okButton = new JButton("OK");
	
	private JLabel nameLabel1 = new JLabel("Kornev A.P., Haste N.M., Taylor S.S., Eyck L.F. Surface comparison of active ");
	private JLabel nameLabel2 = new JLabel("and inactive protein kinases identifies a conserved activation mechanism.");
	private JLabel nameLabel3 = new JLabel("Proc Natl Acad Sci U S A. 2006 Nov 21;103(47):17783-8");
	
	
	private JComboBox combo11 = new JComboBox();
	private Vector structures1 = new Vector();

	private JComboBox combo12 = new JComboBox();
	private Vector chains1 = new Vector();
	
	private JComboBox combo21 = new JComboBox();
	private Vector structures2 = new Vector();

	private JComboBox combo22 = new JComboBox();
	private Vector chains2 = new Vector();

	private Structure structure1;
	private Structure structure2;
	private Chain chain1;
	private Chain chain2;

	private Chain chainOut1;
	private Chain chainOut2;
	
	
	public GraphDialog(Manager p){

		super(p.getApplicationFrame(), "Compare two structures using local spatial patterns", false);

		parent = p;
		parentFrame = parent.getApplicationFrame();
		sv = parent.getStructureViewer();
		
		parent.setDisplayDialogStatus(false);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 425, 310);
		base.setLayout(null);
		
		
		setPanel1.setBounds(5,5,205,100);
		setPanel1.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " First structure ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel1.setBorder(border);
		

		label11.setForeground(Color.black);
		label11.setFont(new Font("Dialog", Font.PLAIN, 11));
		label11.setText("Structure:");
		label11.setBounds(25,25,60,20);
		label11.setVisible(true);
		
		//walk through the loaded structures
		structures1.add("Select");
		chains1.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures1.add(sv.getStructureName(st));
		}
		
		combo11 = new JComboBox(structures1);
		combo11.setBounds(85,25,100,20);
		combo11.setVisible(true);
		if (structures1.size() == 1) combo11.setEnabled(false);
		combo11.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo11.getSelectedItem();
				try{
					structure1 = (Structure)sv.getLoadedStructures().get(combo11.getSelectedIndex() - 1);
					//walk through the chains in the structure and add them
					chains1.clear();
					chains1.add("Select");
					StructureMap map = structure1.getStructureMap();
					for (int i = 0; i < map.getChainCount(); i++){
						chains1.add((map.getChain(i)).getChainId());
					}
					if (chains1.size() == 1){
						chains1.add("Default");
						combo12.setSelectedIndex(1);
					}
					combo12.setEnabled(true);
					combo12.setModel(new DefaultComboBoxModel(chains1));
				}
				catch (Exception ex){
					chains1.clear();
					chains1.add("Select");
					combo12.setEnabled(false);
					combo12.setSelectedIndex(0);
				}
				combo12.revalidate();
			}
		});
		
		
		label12.setForeground(Color.black);
		label12.setFont(new Font("Dialog", Font.PLAIN, 11));
		label12.setText("Chain:");
		label12.setBounds(25,60,40,20);
		label12.setVisible(true);

		combo12 = new JComboBox(chains1);
		combo12.setBounds(85,60,100,20);
		combo12.setVisible(true);
		combo12.setEnabled(false);
		combo12.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo12.getSelectedItem();
				try{
					chain1 = structure1.getStructureMap().getChain(combo12.getSelectedIndex() - 1);
				}
				catch (Exception ex){}
			}
		});
		
		

		setPanel1.add(label11);
		setPanel1.add(combo11);
		setPanel1.add(label12);
		setPanel1.add(combo12);
		
		
		
		///second set panel
		setPanel2.setBounds(210,5,210,100);
		setPanel2.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Second structure ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel2.setBorder(border);
		
		label21.setForeground(Color.black);
		label21.setFont(new Font("Dialog", Font.PLAIN, 11));
		label21.setText("Structure:");
		label21.setBounds(25,25,60,20);
		label21.setVisible(true);
		
		//walk through the loaded structures
		structures2.add("Select");
		chains2.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures2.add(sv.getStructureName(st));
		}
		
		combo21 = new JComboBox(structures2);
		combo21.setBounds(85,25,100,20);
		combo21.setVisible(true);
		if (structures2.size() == 1) combo21.setEnabled(false);
		combo21.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo21.getSelectedItem();
				try{
					structure2 = (Structure)sv.getLoadedStructures().get(combo21.getSelectedIndex() - 1);
					//walk through the chains in the structure and add them
					chains2.clear();
					chains2.add("Select");
					StructureMap map = structure2.getStructureMap();
					for (int i = 0; i < map.getChainCount(); i++){
						chains2.add((map.getChain(i)).getChainId());
					}
					if (chains2.size() == 1){
						chains2.add("Default");
						combo22.setSelectedIndex(1);
					}
					combo22.setEnabled(true);
					combo22.setModel(new DefaultComboBoxModel(chains2));
				}
				catch (Exception ex){
					chains2.clear();
					chains2.add("Select");
					combo22.setEnabled(false);
					combo22.setSelectedIndex(0);
				}
				combo22.revalidate();
			}
		});
		
		
		label22.setForeground(Color.black);
		label22.setFont(new Font("Dialog", Font.PLAIN, 11));
		label22.setText("Chain:");
		label22.setBounds(30,60,40,20);
		label22.setVisible(true);

		combo22 = new JComboBox(chains1);
		combo22.setBounds(85,60,100,20);
		combo22.setVisible(true);
		combo22.setEnabled(false);
		combo22.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo22.getSelectedItem();
				try{
					chain2 = structure2.getStructureMap().getChain(combo22.getSelectedIndex() - 1);
				}
				catch (Exception ex){}
			}
		});
		

		setPanel2.add(label21);
		setPanel2.add(combo21);
		setPanel2.add(label22);
		setPanel2.add(combo22);
		
		//add panels to the base
		base.add(setPanel1);
		base.add(setPanel2);
		
		
		
		

		//mid panel
		midPanel.setBounds(5,105,250,120);
		midPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Residue similarity matrix ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		midPanel.setBorder(border);
		
		matrix1.setBounds(25,25,220,20);
		matrix2.setBounds(25,50,220,20);
		matrix3.setBounds(25,75,220,20);
		
		group.add(matrix1);
		group.add(matrix2);
		group.add(matrix3);
		
		midPanel.add(matrix1);
		midPanel.add(matrix2);
		midPanel.add(matrix3);
		
		
		base.add(midPanel);
		
		//cutoff panel
		cutoffPanel.setBounds(255,105,165,120);
		cutoffPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " CA-CA distance cutoff ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		cutoffPanel.setBorder(border);
		
		cutoff1.setBounds(25,25,50,20);
		cutoff2.setBounds(25,45,50,20);
		cutoff3.setBounds(25,65,50,20);
		cutoff4.setBounds(25,85,50,20);
		
		cutoffGroup.add(cutoff1);
		cutoffGroup.add(cutoff2);
		cutoffGroup.add(cutoff3);
		cutoffGroup.add(cutoff4);
		
		cutoffPanel.add(cutoff1);
		cutoffPanel.add(cutoff2);
		cutoffPanel.add(cutoff3);
		cutoffPanel.add(cutoff4);
		

		base.add(cutoffPanel);
		
		
		//bottom panel
		///second set panel
		namePanel.setBounds(5,225,415,80);
		namePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Method reference ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		namePanel.setBorder(border);
		
		nameLabel1.setForeground(Color.black);
		nameLabel1.setFont(new Font("Dialog", Font.PLAIN, 11));
		nameLabel1.setBounds(20,20,380,20);
		nameLabel1.setVisible(true);
		
		nameLabel2.setForeground(Color.black);
		nameLabel2.setFont(new Font("Dialog", Font.PLAIN, 11));
		nameLabel2.setBounds(20,35,380,20);
		nameLabel2.setVisible(true);

		nameLabel3.setForeground(Color.black);
		nameLabel3.setFont(new Font("Dialog", Font.PLAIN, 11));
		nameLabel3.setBounds(20,50,380,20);
		nameLabel3.setVisible(true);

		namePanel.add(nameLabel1);
		namePanel.add(nameLabel2);
		namePanel.add(nameLabel3);
		
		base.add(namePanel);
		
		
		okButton.setBounds(120, 320, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setBounds(240, 320, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
		});
				
		Dimension dim = getToolkit().getScreenSize();
		
		setSize(width, height);
		
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		setResizable(false);
		setVisible(true);
		


	}
	
	private void process(){
		
		try{
			//add error checking for selection bounds
			//eg., selection level is residue, but entered only structure name
			parent.setDisplayDialogStatus(false);
			
			//get the chains to be aligned
			String chainId1 = (String)chains1.get(combo12.getSelectedIndex());
			String chainId2 = (String)chains2.get(combo22.getSelectedIndex());
			
			String s1 = (String)structures1.get(combo11.getSelectedIndex());
			String s2 = (String)structures2.get(combo21.getSelectedIndex());
			
			Structure ss1 = sv.getStructureByName(s1);
			Structure ss2 = sv.getStructureByName(s2);
			
			if (ss1 == null || ss2 == null){
				parent.displayErrorMessage("Unable to identify one or both chains. Please try again.");
				return;
			}
			
			if (ss1 == ss2){
				parent.displayErrorMessage("You are attempting to compare a structure to itself. Try again.");
				return;
			}

			chainOut1 = ss1.getStructureMap().getChain(chainId1);
			chainOut2 = ss2.getStructureMap().getChain(chainId2);
			
			if (chainOut1 == null || chainOut2 == null){
				parent.displayErrorMessage("Unable to identify one or both chains. Please try again.");
				return;
			}
			
			if (chainOut1 == chainOut2){
				parent.displayErrorMessage("You are attempting to compare a chain to itself. Please try again.");
				return;
			}

			int m = -1;
			if (matrix1.isSelected()){
				m = GraphUtils.SOFT_MATRIX;
			}
			else if (matrix2.isSelected()){
				m = GraphUtils.STRICT_MATRIX;
			}
			else{
				m = GraphUtils.IDENTITY_MATRIX;
			}
			
			final int matrix = m;
			
			int cutoff = 10;
			if (cutoff2.isSelected()){
				cutoff = 12;
			}
			else if (cutoff3.isSelected()){
				cutoff = 15;
			}
			else if (cutoff4.isSelected()){
				cutoff = 20;
			}
			
			final int cutoffOut = cutoff;
			
			Thread runner = new Thread(){
				public void run(){
					//create the graphs
					setVisible(false);
					
					parent.displayWaitScreen();
//					System.out.println("chain1 = " + chainOut1.getChainId() + ", chain2 = " + chainOut2.getChainId());

					StructureGraph graph1 = GraphUtils.buildGraph(chainOut1, cutoffOut);
					StructureGraph graph2 = GraphUtils.buildGraph(chainOut2, cutoffOut);
				
					//now do the comparison
					GraphUtils.compareGraphs(graph1, graph2, matrix, parent);
					
					parent.removeWaitScreen();
					
					dispose();
				}
			};
			runner.start();
		}
		catch (Exception e){
			parent.setDisplayDialogStatus(false);
			dispose();
			parent.displayExceptionMessage("Exception in structure alignment", e);
		}
		
	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
	
}
