package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class HBDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel setPanel1 = new JPanel();
	private JPanel setPanel2 = new JPanel();
	
	private JPanel topPanel = new JPanel();
	private JPanel overlapPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	public static int setF1 = DialogConstants.APPLY_SELECTION;
	public static int setF2 = DialogConstants.APPLY_STRUCTURE;
	
	public static final int INTRASET = 0;
	public static final int INTERSET = 1;
	
	public int interaction = INTRASET;
	
	private ButtonGroup group1 = new ButtonGroup();
	private JRadioButton selected1 = new JRadioButton("Currently selected", true);
	private JRadioButton structure1 = new JRadioButton("Structure", false);
	private JRadioButton chain1 = new JRadioButton("Chain", false);
	private JRadioButton residue1 = new JRadioButton("Residue", false);
	
	private ButtonGroup group2 = new ButtonGroup();
	private JRadioButton selected2 = new JRadioButton("Currently selected", true);
	private JRadioButton structure2 = new JRadioButton("Structure", false);
	private JRadioButton chain2 = new JRadioButton("Chain", false);
	private JRadioButton residue2 = new JRadioButton("Residue", false);
	
	private ButtonGroup group3 = new ButtonGroup();
	private JRadioButton intra = new JRadioButton("Detect within defined set", true);
	private JRadioButton inter = new JRadioButton("Detect hydrogen bonds between sets", false);


	private JTextField field1 = new JTextField(30);
	private JLabel header1 = new JLabel();
	private JLabel label1 = new JLabel();
	
	private JTextField field2 = new JTextField(30);
	private JLabel header2 = new JLabel();
	private JLabel label2 = new JLabel();
	
	private JTextField activeField = field1;

	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JLabel overlapLabel = new JLabel("Maximum interatomic distance:");
	private JTextField overlapText = new JTextField(20);
	
	private JLabel or1 = new JLabel("or");
	private JComboBox combo1 = new JComboBox();
	private Vector structures1 = new Vector();

	private JLabel or2 = new JLabel("or");
	private JComboBox combo2 = new JComboBox();
	private Vector structures2 = new Vector();

	
	private StericEvent event = null;
	
	private Atom[] atoms = new Atom[2];
	
	public HBDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Detection of hydrogen bonds", false);

		setF1 = DialogConstants.APPLY_SELECTION;
		setF2 = DialogConstants.APPLY_STRUCTURE;
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(425, 380));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 425, 380);
		base.setLayout(null);
		
		topPanel.setPreferredSize(new Dimension(415, 70));
		topPanel.setLocation(new Point(5,5));
		topPanel.setBounds(5,5,415,70);
		topPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Type of hydrogen bond detection ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		topPanel.setBorder(border);
		
	
		//define the radio buttons
		intra.setLocation(20,20);
		intra.setBounds(20,20,180,20);
		intra.setVisible(true);
		intra.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				interaction = INTRASET;
				
				//grey out the second panel, since the interaction is with the
				//rest of the same molecule
				selected2.setEnabled(false);
				structure2.setEnabled(false);
				chain2.setEnabled(false);
				residue2.setEnabled(false);
				field2.setEditable(false);
				field2.setEnabled(false);
				combo2.setEnabled(false);
			}
		});

		inter.setLocation(20,40);
		inter.setBounds(20,40,300,20);
		inter.setVisible(true);
		inter.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				interaction = INTERSET;
				
				//grey out the second panel, since the interaction is with the
				//rest of the same molecule
				selected2.setEnabled(true);
				structure2.setEnabled(true);
				chain2.setEnabled(true);
				residue2.setEnabled(true);
				combo2.setEnabled(true);
				if (!selected2.isSelected()){
					field2.setEditable(true);
					field2.setEnabled(true);
				}
			}
		});
		
		group3.add(intra);
		group3.add(inter);
		
		topPanel.add(intra);
		topPanel.add(inter);
		
		base.add(topPanel);
		
		
		
		
		setPanel1.setPreferredSize(new Dimension(205, 230));
		setPanel1.setLocation(new Point(5,75));
		setPanel1.setBounds(5,75,205,230);
		setPanel1.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " First set of atoms ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel1.setBorder(border);
		
		//text field
		header1.setForeground(Color.black);
		header1.setFont(new Font("Dialog", Font.PLAIN, 12));
		header1.setText("Pick object in display");
		header1.setPreferredSize(new Dimension(130,20));
		header1.setBounds(20,60,130,20);
		header1.setLocation(new Point(20,60));
		header1.setVisible(true);
		
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 11));
		label1.setText("Enter name or click");
		label1.setPreferredSize(new Dimension(130,20));
		label1.setBounds(20,140,130,20);
		label1.setLocation(new Point(20,140));
		label1.setVisible(true);
		
		field1.setPreferredSize(new Dimension(170,20));
		field1.setBounds(20,165,170,20);
		field1.setLocation(new Point(20,165));
		field1.setEditable(false);
		field1.setEnabled(false);
		field1.setVisible(true);
		field1.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				if (selected1.isSelected()){
					setF1 = DialogConstants.APPLY_RESIDUE;
					selected1.setSelected(false);
					residue1.setSelected(true);
				}
				field1.setText("");
				field1.setEditable(true);
				field1.setEnabled(true);
				activeField = field1;
				field1.requestFocus();
			}
		});
		field1.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});
					
		or1.setForeground(Color.black);
		or1.setFont(new Font("Dialog", Font.PLAIN, 11));
		or1.setPreferredSize(new Dimension(15,20));
		or1.setBounds(20,195,15,20);
		or1.setLocation(new Point(20,195));
		or1.setVisible(true);
		
		//walk through the loaded structures
		structures1.add("Select structure or set");
		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures1.add(sv.getStructureName(st));
		}

		Vector setNames = sv.getAtomSetNames();
		for (int i = 0; i < setNames.size(); i++){
			structures1.add(setNames.get(i));
		}
		
		combo1 = new JComboBox(structures1);
		combo1.setPreferredSize(new Dimension(155,20));
		combo1.setBounds(35,195,155,20);
		combo1.setLocation(new Point(35,195));
		combo1.setVisible(true);
		if (structures1.size() == 1) combo1.setEnabled(false);
		combo1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo1.getSelectedItem();
				if (choice.startsWith("Select")){
					field1.setText("");
				}
				else{
					field1.setText(choice);
				}
				setF1 = DialogConstants.APPLY_STRUCTURE;		
				structure1.setSelected(true);
			}
		});
		
		//define the radio buttons
		selected1.setLocation(20,25);
		selected1.setBounds(20,25,130,20);
		selected1.setVisible(true);
		selected1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setF1 = DialogConstants.APPLY_SELECTION;
				field1.setText("");
				field1.setEditable(false);
				field1.setEnabled(false);
			}
		});
		
		structure1.setLocation(20,80);
		structure1.setBounds(20,80,130,20);
		structure1.setVisible(true);
		structure1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setF1 = DialogConstants.APPLY_STRUCTURE;
				field1.setEditable(true);
				field1.setEnabled(true);
				activeField = field1;
				field1.requestFocus();
			}
		});
		
		chain1.setLocation(20,100);
		chain1.setBounds(20,100,130,20);
		chain1.setVisible(true);
		chain1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setF1 = DialogConstants.APPLY_CHAIN;
				field1.setEditable(true);
				field1.setEnabled(true);
				activeField = field1;
				field1.requestFocus();
			}
		});
		
		residue1.setLocation(20,120);
		residue1.setBounds(20,120,130,20);
		residue1.setVisible(true);
		residue1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setF1 = DialogConstants.APPLY_RESIDUE;
				field1.setEditable(true);
				field1.setEnabled(true);
				activeField = field1;
				field1.requestFocus();
			}
		});
		
		//draw a line between the radio buttons
		JSeparator line1 = new JSeparator();
		line1.setLocation(10,55);
		line1.setBounds(10,55,140,5);
		line1.setVisible(true);
		
		setPanel1.add(line1);
		setPanel1.add(header1);
		
		group1.add(selected1);
		group1.add(structure1);
		group1.add(chain1);
		group1.add(residue1);
		
		setPanel1.add(selected1);
		setPanel1.add(structure1);
		setPanel1.add(chain1);
		setPanel1.add(residue1);
		
		setPanel1.add(label1);
		setPanel1.add(field1);
		setPanel1.add(or1);
		setPanel1.add(combo1);
		
		///second set panel
		setPanel2.setPreferredSize(new Dimension(205, 230));
		setPanel2.setLocation(new Point(215,75));
		setPanel2.setBounds(215,75,205,230);
		setPanel2.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Second set of atoms ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel2.setBorder(border);
		
		//text field
		header2.setForeground(Color.black);
		header2.setFont(new Font("Dialog", Font.PLAIN, 12));
		header2.setText("Pick object in display");
		header2.setPreferredSize(new Dimension(130,20));
		header2.setBounds(20,60,130,20);
		header2.setLocation(new Point(20,60));
		header2.setVisible(true);
		
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 11));
		label2.setText("Enter name or click");
		label2.setPreferredSize(new Dimension(130,20));
		label2.setBounds(20,140,130,20);
		label2.setLocation(new Point(20,140));
		label2.setVisible(true);
		
		field2.setPreferredSize(new Dimension(170,20));
		field2.setBounds(20,165,170,20);
		field2.setLocation(new Point(20,165));
		field2.setEditable(false);
		field2.setEnabled(false);
		field2.setVisible(true);
		field2.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				if (selected2.isSelected()){
					setF2 = DialogConstants.APPLY_STRUCTURE;
					selected2.setSelected(false);
					structure2.setSelected(true);
				}
				field2.setText("");
				field2.setEditable(true);
				field2.setEnabled(true);
				activeField = field2;
				field2.requestFocus();
			}
		});
		field2.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});
					
		or2.setForeground(Color.black);
		or2.setFont(new Font("Dialog", Font.PLAIN, 11));
		or2.setPreferredSize(new Dimension(15,20));
		or2.setBounds(20,195,15,20);
		or2.setLocation(new Point(20,195));
		or2.setVisible(true);
		
		//walk through the loaded structures
		structures2.add("Select loaded structure");
		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures2.add(sv.getStructureName(st));
		}

		for (int i = 0; i < setNames.size(); i++){
			structures2.add(setNames.get(i));
		}

		combo2 = new JComboBox(structures2);
		combo2.setPreferredSize(new Dimension(155,20));
		combo2.setBounds(35,195,155,20);
		combo2.setLocation(new Point(35,195));
		combo2.setEnabled(false);
		combo2.setVisible(true);
		if (structures2.size() == 1) combo2.setEnabled(false);
		combo2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo2.getSelectedItem();
				if (choice.startsWith("Select")){
					field2.setText("");
				}
				else{
					field2.setText(choice);
				}
				setF2 = DialogConstants.APPLY_STRUCTURE;
				structure2.setSelected(true);
			}
		});
		
		//define the radio buttons
		selected2.setLocation(20,25);
		selected2.setBounds(20,25,130,20);
		selected2.setVisible(true);
		selected2.setEnabled(false);
		selected2.setSelected(true);
		selected2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setF2 = DialogConstants.APPLY_SELECTION;
				field2.setText("");
				field2.setEditable(false);
				field2.setEnabled(false);
				
			}
		});
		
		structure2.setLocation(20,80);
		structure2.setBounds(20,80,130,20);
		structure2.setVisible(true);
		structure2.setEnabled(false);
		structure2.setSelected(false);
		structure2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setF2 = DialogConstants.APPLY_STRUCTURE;
				field2.setEditable(true);
				field2.setEnabled(true);
				activeField = field2;
				field2.requestFocus();
			}
		});
		
		chain2.setLocation(20,100);
		chain2.setBounds(20,100,130,20);
		chain2.setVisible(true);
		chain2.setEnabled(false);
		chain2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setF2 = DialogConstants.APPLY_CHAIN;
				field2.setEditable(true);
				field2.setEnabled(true);
				activeField = field2;
				field2.requestFocus();
			}
		});
		
		residue2.setLocation(20,120);
		residue2.setBounds(20,120,130,20);
		residue2.setVisible(true);
		residue2.setEnabled(false);
		residue2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setF2 = DialogConstants.APPLY_RESIDUE;
				field2.setEditable(true);
				field2.setEnabled(true);
				activeField = field2;
				field2.requestFocus();
			}
		});
		
		//draw a line between the radio buttons
		JSeparator line2 = new JSeparator();
		line2.setLocation(10,55);
		line2.setBounds(10,55,140,5);
		line2.setVisible(true);
		
		setPanel2.add(line2);
		setPanel2.add(header2);
		
		group2.add(selected2);
		group2.add(structure2);
		group2.add(chain2);
		group2.add(residue2);
		
		setPanel2.add(selected2);
		setPanel2.add(structure2);
		setPanel2.add(chain2);
		setPanel2.add(residue2);
		
		setPanel2.add(label2);
		setPanel2.add(field2);
		setPanel2.add(or2);
		setPanel2.add(combo2);
		
		
		//add panels to the base
		base.add(setPanel1);
		base.add(setPanel2);
		
		
		//bottom panel
		///second set panel
		overlapPanel.setPreferredSize(new Dimension(415, 70));
		overlapPanel.setLocation(new Point(5,305));
		overlapPanel.setBounds(5,305,415,70);
		overlapPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Maximum hydrogen bond length ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		overlapPanel.setBorder(border);
		
		overlapLabel.setForeground(Color.black);
		overlapLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		overlapLabel.setPreferredSize(new Dimension(210,20));
		overlapLabel.setBounds(20,25,210,20);
		overlapLabel.setLocation(new Point(20,25));
		overlapLabel.setVisible(true);
		
		overlapText.setPreferredSize(new Dimension(50,20));
		overlapText.setBounds(230,25,50,20);
		overlapText.setLocation(new Point(230,25));
		overlapText.setEditable(true);
		overlapText.setEnabled(true);
		overlapText.setVisible(true);
		overlapText.setText("3.0");

		overlapPanel.add(overlapLabel);
		overlapPanel.add(overlapText);
		
		base.add(overlapPanel);
		
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(115, 390));
		okButton.setBounds(115, 390, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(225, 390));
		cancelButton.setBounds(225, 390, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(440, 450);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		try{
			setVisible(false);
			
			//first, check the number of tags
			int count = 0;
			StringTokenizer tok = new StringTokenizer(field1.getText(), ":", false);
			while (tok.hasMoreTokens()){
				Object o = tok.nextToken();
				count++;
			}
			
			if (setF1 != 0){
				if (count < setF1){
					setF1 = count;
				}
			}
	
			count = 0;
			StringTokenizer tok2 = new StringTokenizer(field2.getText(), ":", false);
			while (tok2.hasMoreTokens()){
				Object o = tok2.nextToken();
				count++;
			}
			
			if (setF2 != 0){
				if (count < setF2){
					setF2 = count;
				}
			}
	
			
			event = new StericEvent(itself);
			event.setFlags[0] = setF1;
			event.setFlags[1] = setF2;
			
			event.atoms[0] = atoms[0];
			event.atoms[1] = atoms[1];
			
			event.atomLabels.add(field1.getText());
			event.atomLabels.add(field2.getText());
	
			event.value = 3.0;
			try{
				event.value = Double.parseDouble(overlapText.getText());
			}
			catch (Exception ex){
				parent.displayErrorMessage("Entered overlap value is not a number");
				return;
			}
			
			event.type = interaction;
			
			Thread runner = new Thread(){
				public void run(){
					parent.setDisplayDialogStatus(false);
					sv.processDisplayDialogEvent(event);
				}
			};
			runner.start();
		}
		catch (Exception e){
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			e.printStackTrace();
		}

		
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		activeField.setText(data);
		//move focus along only if something has been picked
		if (data.length() > 0){
			if (activeField == field1){
				atoms[0] = (Atom)structureComponent;
				if (field2.isEnabled()){
					activeField = field2;
					field2.requestFocus();
				}
			}
			else{
				atoms[1] = (Atom)structureComponent;
			}
		}
	}
	
}
