package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.io.*;
import java.util.*;
import java.awt.image.BufferedImage;
import javax.imageio.*;
import javax.imageio.spi.*;
import javax.imageio.stream.*;

// MBT
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class ImageExportDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	
	private DisplayDialog itself = null;
	private JDialog thisFrame = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	private JPanel parameterPanel = new JPanel();
	private JPanel filePanel = new JPanel();
	
	private Border border1 = null;
	private TitledBorder border2 = null;
	private Border border = null;
		
	private JComboBox imageFormatComboBox = null;
	private JComboBox resolutionComboBox = null;

	private JTextField field = new JTextField(30);
	private JLabel formatLabel = new JLabel();
	private JLabel resLabel = new JLabel();
	
	private JButton fileButton = new JButton("Browse...");
	private JButton okButton = new JButton("Export");
	private JButton cancelButton = new JButton("Cancel");
	
	private String suffix = null;
	private File file = null;
	
	private boolean chooserFlag = false;
	
	private static Vector resolutions;
	private int resolution = 72;
	static{
		resolutions = new Vector();
		resolutions.add(new Integer(72));
		resolutions.add(new Integer(150));
		resolutions.add(new Integer(300));
	};
	
	
	
	public ImageExportDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Export image", false);
	
		parentFrame = f;
		parent = p;
		sv = s;

		resolution = ((Integer)resolutions.elementAt(0)).intValue();
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		thisFrame = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(360, 150));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 360, 150);
		base.setLayout(null);
		
		parameterPanel.setPreferredSize(new Dimension(350, 80));
		parameterPanel.setLocation(new Point(5,5));
		parameterPanel.setBounds(5,5,350,80);
		parameterPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Image parameters ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		parameterPanel.setBorder(border);
		
		//add the labels and combo boxes
		formatLabel.setText("Format:");
		formatLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		formatLabel.setPreferredSize(new Dimension(50,20));
		formatLabel.setLocation(new Point(15,30));
		formatLabel.setBounds(15,30,50,20);
		formatLabel.setVisible(true);
		
		parameterPanel.add(formatLabel);
		
		//the combo box
		Vector formats = getWriterFormats( );
		
		//get rid of the duplicate format
		int doomed = -1;
		for (int i = 0; i < formats.size(); i++){
			FormatDescriptor item = (FormatDescriptor)formats.elementAt(i);
			if (item.suffix.endsWith("jpeg")){
				doomed = i;
			}
		}
		if (doomed != -1){
			formats.removeElementAt(doomed);
		}
		
		suffix = ((FormatDescriptor)formats.elementAt(0)).suffix;

		imageFormatComboBox = new JComboBox( formats );
		final JComboBox cb = imageFormatComboBox;
		imageFormatComboBox.addActionListener( new ActionListener( )
		{
			public void actionPerformed( ActionEvent e )
			{
				FormatDescriptor fd =
					(FormatDescriptor) imageFormatComboBox.getSelectedItem( );
				suffix = fd.suffix;
				updateFileSuffix( suffix );
			}
		} );
		
		imageFormatComboBox.setPreferredSize(new Dimension(90,20));
		imageFormatComboBox.setLocation(new Point(65,30));
		imageFormatComboBox.setBounds(65,30,90,20);
		imageFormatComboBox.setVisible(true);
		
		parameterPanel.add(imageFormatComboBox);

		//resolution combo box
		resLabel.setText("Resolution (dpi):");
		resLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		resLabel.setPreferredSize(new Dimension(100,20));
		resLabel.setLocation(new Point(175,30));
		resLabel.setBounds(175,30,100,20);
		resLabel.setVisible(true);
		
		parameterPanel.add(resLabel);
		
		resolutionComboBox = new JComboBox(resolutions);
		resolutionComboBox.setPreferredSize(new Dimension(55,20));
		resolutionComboBox.setLocation(new Point(280,30));
		resolutionComboBox.setBounds(280,30,55,20);
		resolutionComboBox.setVisible(true);
		
		parameterPanel.add(resolutionComboBox);
		
		
		//structure panel
		filePanel.setPreferredSize(new Dimension(350, 60));
		filePanel.setLocation(new Point(5,85));
		filePanel.setBounds(5,85,350,60);
		filePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  Output file name ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		filePanel.setBorder(border);
		
		//take care of the file browsing button
		fileButton.setPreferredSize(new Dimension(90,20));
		fileButton.setLocation(new Point(245, 25));
		fileButton.setBounds(245,25,90,20);
		fileButton.setVisible(true);
		fileButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				//get the new directory from the user
				//browse the filesystem. select directories
				chooserFlag = true;
				JFileChooser chooser = new JFileChooser(StylesPreferences.workingDirectory);
				int result = chooser.showOpenDialog(null);
				chooserFlag = false;
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				file = chooser.getSelectedFile();
				field.setText(file.getPath());
				updateFileSuffix(suffix);
			}
		});
		
		
		field.setPreferredSize(new Dimension(220,20));
		field.setBounds(15,25,220,20);
		field.setLocation(new Point(15,25));
		field.setEditable(true);
		field.setEnabled(true);
		field.setVisible(true);
		field.requestFocus();
		
		filePanel.add(fileButton);
		filePanel.add(field);
		
		
		base.add(parameterPanel);
		base.add(filePanel);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(90, 160));
		okButton.setBounds(90, 160, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
			
				//add error checking for selection bounds
				//eg., selection level is residue, but entered only structure name
			
				setVisible(false);
				
				int index = resolutionComboBox.getSelectedIndex();
				int resolution = ((Integer)resolutions.elementAt(index)).intValue();
				
//				System.out.println("Resolution = " + resolution);
				
				Dimension dim = sv.getSize();
//				System.out.println("Dimensions of window: " + dim.width + " by " + dim.height);
		
				//get the desired dimensions of the BufferedImage
				int ratio = (int)(resolution/72);
				int width = ratio*dim.width;
				int height = ratio*dim.height;
				
//				System.out.println("Desired size: " + width + " by " + height);
				
				// Ask the StructureViewer to produce a BufferedImage object.
				try{
//					BufferedImage bufferedImage = sv.getBufferedImage(width, height);
	
					// Ask the user where and in what format to save the image file.
//					save( bufferedImage );
				}
				catch (OutOfMemoryError ex){
					parent.displayErrorMessage("Insufficient memory to complete operation.");
				}
				parent.setDisplayDialogStatus(false);
	

			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(200, 160));
		cancelButton.setBounds(200, 160, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			public void windowDeactivated(WindowEvent e){
				if (chooserFlag){
					return;
				}
				toFront();
			}
			
		});
		
		
		
		setSize(380, 215);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			setLocationRelativeTo(null);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5;
			int y = 45;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}
		
		setVisible(true);
		
	}
	
	public void processPick(String data, StructureComponent s){}
	

	/**
	 *  Describes a Format plug-in for use as a JFileChooser filter.
	 */
	static private class FormatDescriptor
	{
		public String suffix;
		public ImageWriter imageWriter;
		public String description;

		public FormatDescriptor( String suffix, ImageWriter imageWriter,
			String description )
		{
			this.suffix = suffix;
			this.imageWriter = imageWriter;
			this.description = description;
		}

		public String toString( )
		{
			return description;
		}
	}


	/**
	 *  Return a vector of FormatDescriptor objects, one for each
	 *  supported Image Format plug-ins.
	 */
	static private Vector getWriterFormats( )
	{
		Vector formats = new Vector( );
		Hashtable seen = new Hashtable( );

		String names[] = ImageIO.getWriterFormatNames( );
		for ( int i=0; i<names.length; ++i )
		{
			String name = names[i];
			Iterator writers = ImageIO.getImageWritersByFormatName( name );
			while ( writers.hasNext() )
			{
				ImageWriter iw = (ImageWriter) writers.next( );
				ImageWriterSpi iws = iw.getOriginatingProvider( );
				String suffixes[] = iws.getFileSuffixes( );
				boolean allseen = true;
				for ( int j=0; j<suffixes.length; ++j )
				{
					String suffix = suffixes[j];
					suffix = suffix.toLowerCase( );
					if ( ! seen.containsKey( suffix ) )
					{
						seen.put( suffix, suffix );
						String description = name + " (*." + suffix + ")";
						FormatDescriptor fd =
							new FormatDescriptor( suffix, iw, description );
						formats.addElement( fd );
					}
				}
			}
		}

		return formats;
	}
	
	public void updateFileSuffix(String suffix){
		
		if (file == null ){
			
			String typedName = field.getText();
			
//			if ( typedName == null ) return;
			int lp = typedName.lastIndexOf( "." );
			if ( lp == -1 ){
				//just add the dot and the suffix
				typedName = typedName + "." + suffix;
			}
			else{
				typedName = typedName.substring( 0, lp ) + "." + suffix;
			}
			field.setText( typedName );
		}
		else
		{
			if ( file == null ) return;
			String filename = file.getPath( );
			int lp = filename.lastIndexOf( "." );
			if ( lp == -1 ) return;
			filename = filename.substring( 0, lp ) + "." + suffix;
			field.setText( filename );
		}
				

	}
	
	/**
	 *  Prompt the user to save the given BufferedImage object, and,
	 *  if the user approves, save the file to the user-specified file.
	 */
	public void save( BufferedImage image )
	{

		try
		{
			updateFileSuffix(suffix);//as the last minute insurance against weird typed file names
			
//			if (file == null){
				file = new File(field.getText());
//			}
			// Get the currently-selected item in the combo box
			FormatDescriptor fd =
				(FormatDescriptor) imageFormatComboBox.getSelectedItem( );

			// Get the ImageWriter stored in this FormatDescriptor
			ImageWriter imageWriter = fd.imageWriter;

			// Get an output stream for the file
			FileOutputStream fout = new FileOutputStream( file );

			// Turn it into an ImageOutputStreamn
			ImageOutputStream ios = ImageIO.createImageOutputStream( fout );

			// Plug this stream into the ImageWriter
			imageWriter.setOutput( ios );

			// Write the image
			imageWriter.write( image );

			// Dont forget to close the file!
			fout.close();
			dispose();
		}
		catch( IOException ie )
		{
			parent.displayErrorMessage("Unable to save image");
		}
	}
}
