package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.search.*;
import edu.sdsc.sirius.util.Manager;

public class InterProDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel appPanel = new JPanel();
	private JPanel setPanel = new JPanel();
	
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
		
	private JCheckBox b1 = new JCheckBox("BlastProDom", InterProSettings.BlastProDom);
	private JCheckBox b2 = new JCheckBox("FPrintScan", InterProSettings.FPrintScan);
	private JCheckBox b3 = new JCheckBox("Gene3D", InterProSettings.gene3d);
	private JCheckBox b4 = new JCheckBox("HMMPIR", InterProSettings.HMMPIR);
	private JCheckBox b5 = new JCheckBox("HMMPfam", InterProSettings.HMMPfam);
	private JCheckBox b6 = new JCheckBox("HMMPanther", InterProSettings.HMMPanther);
	private JCheckBox b7 = new JCheckBox("HMMsmart", InterProSettings.HMMsmart);
	private JCheckBox b8 = new JCheckBox("HMMTigr", InterProSettings.HMMTigr);
	private JCheckBox b9 = new JCheckBox("TMHMM", InterProSettings.TMHMM);
	private JCheckBox b10 = new JCheckBox("ProfileScan", InterProSettings.ProfileScan);
	private JCheckBox b11 = new JCheckBox("SignalP", InterProSettings.SignalP);
	private JCheckBox b12 = new JCheckBox("SuperFamily", InterProSettings.SuperFamily);
	private JCheckBox b13 = new JCheckBox("ScanRegExp", InterProSettings.ScanRegExp);
	
	private JCheckBox a1 = new JCheckBox("Check precomputed results first", InterProSettings.crc);
	private JCheckBox a2 = new JCheckBox("Include GO terms", InterProSettings.go);
	
	private JComboBox combo;
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	
	public InterProDialog(JFrame f, Manager p){

		super(f, " InterPro Settings ", false);
	
		parentFrame = f;
		parent = p;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 210, 480);
		base.setLayout(null);
		
		appPanel.setBounds(5,5,200,355);
		appPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Applications ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		appPanel.setBorder(border);
		
		b1.setBounds(20,25,100,20);
		b2.setBounds(20,50,100,20);
		b3.setBounds(20,75,100,20);
		b4.setBounds(20,100,100,20);
		b5.setBounds(20,125,100,20);
		b6.setBounds(20,150,100,20);
		b7.setBounds(20,175,100,20);
		b8.setBounds(20,200,100,20);
		b9.setBounds(20,225,100,20);
		b10.setBounds(20,250,100,20);
		b11.setBounds(20,275,100,20);
		b12.setBounds(20,300,100,20);
		b13.setBounds(20,325,100,20);
		
		
		appPanel.add(b1);
		appPanel.add(b2);
		appPanel.add(b3);
		appPanel.add(b4);
		appPanel.add(b5);
		appPanel.add(b6);
		appPanel.add(b7);
		appPanel.add(b8);
		appPanel.add(b9);
		appPanel.add(b10);
		appPanel.add(b11);
		appPanel.add(b12);
		appPanel.add(b13);
		
		
		//structure panel
		setPanel.setBounds(5,360,200,115);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Other settings ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		a1.setBounds(20,25,175,20);
		a2.setBounds(20,50,150,20);

		JLabel label = new JLabel("Min ORF length (for DNA)");
		label.setForeground(Color.black);
		label.setFont(new Font("Dialog", Font.PLAIN, 11));
		label.setBounds(20,75,130,20);
		label.setVisible(true);
		
		Vector values = new Vector();
		values.add("20");
		values.add("30");
		values.add("40");
		values.add("50");
		values.add("80");
		values.add("100");
		values.add("130");
		values.add("150");
		
		
		//trlen selection
		combo = new JComboBox(values);
		combo.setBounds(150,75,40,20);
		combo.setVisible(true);
		
		setPanel.add(a1);
		setPanel.add(a2);
		

		setPanel.add(label);
		setPanel.add(combo);

		base.add(appPanel);
		base.add(setPanel);
		
		//buttons
		okButton.setBounds(20, 490, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setBounds(120, 490, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(230, 550);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
			
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		setVisible(true);

	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		try{
			setVisible(false);
	
			InterProSettings.BlastProDom = b1.isSelected();
			InterProSettings.FPrintScan = b2.isSelected();
			InterProSettings.gene3d = b3.isSelected();
			InterProSettings.HMMPIR = b4.isSelected();
			InterProSettings.HMMPfam = b5.isSelected();
			InterProSettings.HMMPanther = b6.isSelected();
			InterProSettings.HMMsmart = b7.isSelected();
			InterProSettings.HMMTigr = b8.isSelected();
			InterProSettings.TMHMM = b9.isSelected();
			InterProSettings.ProfileScan = b10.isSelected();
			InterProSettings.SignalP = b11.isSelected();
			InterProSettings.ScanRegExp = b12.isSelected();
			InterProSettings.SuperFamily = b13.isSelected();
			
			InterProSettings.crc = a1.isSelected();
			InterProSettings.go = a2.isSelected();
			try{
				InterProSettings.trlen = Integer.parseInt((String)combo.getSelectedItem());
			}
			catch (NumberFormatException e){}
			
			parent.setDisplayDialogStatus(false);
		}
		catch (Exception e){
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			e.printStackTrace();
		}

		dispose();

	}
	
/*	public static void main(String[] args){
	
		RibbonDialog rr = new RibbonDialog();
	}
*/	
}
