package edu.sdsc.sirius.dialogs;

// Core
import java.io.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.*;

import edu.sdsc.sirius.io.*;

public class LESMDSetupDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private JPanel inputPanel = new JPanel();
	private JPanel waterPanel = new JPanel();
	private JPanel optionsPanel = new JPanel();
	private JPanel outputPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private JTextField inputField1 = new JTextField(50);
	private JTextField inputField2 = new JTextField(50);
	
	private JTextField minResidue = new JTextField(50);
	private JTextField maxResidue = new JTextField(50);
	
	
	private JTextField dirField = new JTextField(50);
	
	private JTextField minSteps = new JTextField(30);
	private JTextField eqSteps = new JTextField(30);
	private JTextField threadCount = new JTextField(30);
	
	private JTextField totalRuns = new JTextField(30);
	private JTextField mdSteps = new JTextField(40);
	private JTextField saveFrequency = new JTextField(30);

	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	
	public LESMDSetupDialog(JFrame f, Manager p){

		super(f, "Prepare LES MD simulation", false);

		parentFrame = f;
		parent = p;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 495, 320);
		base.setLayout(null);
		
		//first panel - input files
		inputPanel.setBounds(5,5,485,85);
		inputPanel.setLayout(null);
		
		inputPanel.setBorder(createTitledBorder("Input files"));
		
		JLabel input1 = new JLabel("prmtop:");
		JLabel input2 = new JLabel("inpcrd:");
		
		input1.setBounds(20, 25, 60, 20);
		input2.setBounds(20, 50, 60, 20);
		
		inputField1.setBounds(90,25,275,20);
				
		JButton inputButton1 = new JButton("Browse...");
		inputButton1.setFont(new Font("Dialog", Font.PLAIN, 12));
		inputButton1.setBounds(370,25,90,20);
		inputButton1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				int result = chooser.showOpenDialog(parent.getApplicationFrame());
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				inputField1.setText(filename.toString());
				parent.setLastUsedDirectory(filename.toString());
			}
		});
		
		
		inputPanel.add(input1);
		inputPanel.add(inputField1);
		inputPanel.add(inputButton1);
		
		inputField2.setBounds(90,50,275,20);
		
		JButton inputButton2 = new JButton("Browse...");
		inputButton2.setFont(new Font("Dialog", Font.PLAIN, 12));
		inputButton2.setBounds(370,50,90,20);
		inputButton2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				int result = chooser.showOpenDialog(parent.getApplicationFrame());
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				inputField2.setText(filename.toString());
				parent.setLastUsedDirectory(filename.toString());
			}
		});

		inputPanel.add(input2);
		inputPanel.add(inputField2);
		inputPanel.add(inputButton2);
		
		
		base.add(inputPanel);
		
		//water
		waterPanel.setBounds(5,90,485,50);
		waterPanel.setLayout(null);
		
		waterPanel.setBorder(createTitledBorder("Flexible region of the structure"));
		
		JLabel minResidueLabel = new JLabel("Start:");
		minResidueLabel.setBounds(80, 20, 50, 20);
		
		minResidue.setBounds(140, 20, 60,20);
		
		JLabel maxResidueLabel = new JLabel("End:");
		maxResidueLabel.setBounds(260, 20, 50, 20);
		maxResidue.setBounds(320, 20, 60, 20);
		
		waterPanel.add(minResidueLabel);
		waterPanel.add(minResidue);
		waterPanel.add(maxResidueLabel);
		waterPanel.add(maxResidue);
		
		base.add(waterPanel);
		
		//parameters
		optionsPanel.setBounds(5,140,485,125);
		optionsPanel.setLayout(null);
		optionsPanel.setBorder(createTitledBorder("Simulation options"));
		
		JLabel minStepsLabel = new JLabel("Minimization steps:");
		minStepsLabel.setBounds(20,20,120,20);
		minSteps.setBounds(150, 20, 50, 20);
		minSteps.setText("10000");
		
		JLabel eqStepsLabel = new JLabel("Equilibration steps:");
		eqStepsLabel.setBounds(20, 45, 120, 20);
		eqSteps.setBounds(150, 45, 50, 20);
		eqSteps.setText("10000");
		
		JLabel threadCountLabel = new JLabel("Number of threads:");
		threadCountLabel.setBounds(20, 70, 120, 20);
		threadCount.setBounds(150, 70, 50, 20);
		threadCount.setText("4");
		
		JLabel totalRunsLabel = new JLabel("Total MD runs:");
		totalRunsLabel.setBounds(20, 95, 120, 20);
		totalRuns.setBounds(150, 95, 50, 20);
		totalRuns.setText("10");
		
		JLabel mdStepsLabel = new JLabel("Steps in each run:");
		mdStepsLabel.setBounds(240, 20, 120, 20);
		mdSteps.setBounds(370, 20, 50, 20);
		mdSteps.setText("250000");
		
		JLabel saveFrequencyLabel = new JLabel("Save frequency:");
		saveFrequencyLabel.setBounds(240, 45, 120, 20);
		saveFrequency.setBounds(370, 45, 50, 20);
		saveFrequency.setText("250");
		
		optionsPanel.add(minStepsLabel);
		optionsPanel.add(minSteps);
		optionsPanel.add(eqStepsLabel);
		optionsPanel.add(eqSteps);
		optionsPanel.add(threadCountLabel);
		optionsPanel.add(threadCount);
		optionsPanel.add(totalRunsLabel);
		optionsPanel.add(totalRuns);
		optionsPanel.add(mdStepsLabel);
		optionsPanel.add(mdSteps);
		optionsPanel.add(saveFrequencyLabel);
		optionsPanel.add(saveFrequency);
		
		
		
		
		base.add(optionsPanel);
		
		//output directory
		outputPanel.setBounds(5,265,485,50);
		outputPanel.setLayout(null);
		outputPanel.setBorder(createTitledBorder("Output directory"));

		dirField.setBounds(25,20,335,20);
		
		JButton dirButton = new JButton("Browse...");
		dirButton.setFont(new Font("Dialog", Font.PLAIN, 12));
		dirButton.setBounds(370,20,90,20);
		dirButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				int result = chooser.showOpenDialog(parent.getApplicationFrame());
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				dirField.setText(filename.toString());
			}
		});
		
		
		outputPanel.add(dirField);
		outputPanel.add(dirButton);		
		
		
		base.add(outputPanel);
		
		contentPane.add(base);
		
		//buttons
		okButton.setBounds(150, 330, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setBounds(270, 330, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
		});
				
		setSize(510, 385);
		
		if (parent == null){
			setLocationRelativeTo(null);
		}
		else{
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parent.getApplicationFrame().getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);
		
			setBounds(x + parent.getApplicationFrame().getX(), y + parent.getApplicationFrame().getY(), d1.width, d1.height);
		}
		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){

		//process the entered data
		try{
			String prmtop = inputField1.getText().trim();
			String inpcrd = inputField2.getText().trim();
			String outdir = dirField.getText().trim();
			
			int minStepsCount = Integer.parseInt(minSteps.getText().trim());
			int eqStepsCount = Integer.parseInt(eqSteps.getText().trim());
			int nThreads = Integer.parseInt(threadCount.getText().trim());
			int totalRunsCount = Integer.parseInt(totalRuns.getText().trim());
			int steps = Integer.parseInt(mdSteps.getText().trim());
			int frequency = Integer.parseInt(saveFrequency.getText().trim());
			
			if (totalRunsCount < 2){
				totalRunsCount = 2;
				parent.displayMessage("Total MD run count is set to a minimum of two");
			}
			
			boolean explicitWater = false;
			
			//now prepare the input files in the specified directory
			//first, copy over the prmtop and inpcrd files
			if (!prmtop.endsWith("prmtop")){
				parent.displayErrorMessage("Selected prmtop file has incorrect extension");
				return;
			}
			if (!inpcrd.endsWith("inpcrd")){
				parent.displayErrorMessage("Selected inpcrd file has incorrect extension");
				return;
			}
			
			File prmtopFile = new File(prmtop);
			File inpcrdFile = new File(inpcrd);
			
			File prmtopOutFile = new File(outdir + File.separator + prmtopFile.getName());
			File inpcrdOutFile = new File(outdir + File.separator + inpcrdFile.getName());
			
			//check whether source and destination directories are different
			
			FileTransfer transfer = new FileTransfer();
			if (!prmtopFile.toString().equals(prmtopOutFile.toString())){
				boolean a = transfer.copy(prmtopFile, prmtopOutFile);
				if (!a){
					parent.displayErrorMessage("Unable to copy prmtop file to the selected directory");
					return;
				}
			}
			if (!inpcrdFile.toString().equals(inpcrdOutFile.toString())){
				boolean b = transfer.copy(inpcrdFile, inpcrdOutFile);
				if (!b){
					parent.displayErrorMessage("Unable to copy prmtop file to the selected directory");
					return;
				}
			}
			
			
			//get the input file base name
			String n = (new File(prmtop)).getName();
			String basename = n.substring(0, n.indexOf("."));

			
			//now, let's create the minimization input file
			PrintWriter printer = new PrintWriter(new FileWriter(outdir + File.separator + "min.in"));
			printer.println("Initial minimization");
			printer.println(" &cntrl");
			printer.println("	imin=1, maxcyc=" + minStepsCount + ", ncyc=" + (int)(minStepsCount/2) + ",");
			printer.println("	cut=15, ntb=0, igb=1");
			printer.println(" /");
			printer.flush();
			printer.close();

			
			//next, the equilibration input file
			printer = new PrintWriter(new FileWriter(outdir + File.separator + "eq.in"));
			printer.println("Initial MD equilibration");
			printer.println(" &cntrl");
			printer.println("	imin=0, irest=0,");
			printer.println("	nstlim=" + eqStepsCount + ", dt=0.001, ntc=1,");
			printer.println("	ntpr=100, ntwx=100,");
			printer.println("	cut=15, ntb=0, igb=1,");
			printer.println("	ntt=3, gamma_ln=1.0,");
			printer.println("	tempi=0.0, temp0=300.0,");
			printer.println(" /");
			printer.flush();
			printer.close();
			
			
			//next, let's create the LES prmtop and inpcrd for the production MD
			printer = new PrintWriter(new FileWriter(outdir + File.separator + "les.in"));
			printer.println("~ input prmtop");
			printer.println("file rprm name=(" + basename + ".prmtop) read");
			printer.println("~");
			printer.println("~ input coordinates");
			printer.println("file rcvd name=(" + basename + "_eq.rst) read");
			printer.println("~");
			printer.println("~ topology file");
			printer.println("file wprm name=(" + basename + "_les.prmtop) wovr");
			printer.println("~");
			printer.println("~ coordinate file");
			printer.println("file wcrd name=(" + basename + "_les.inpcrd) wovr");
			printer.println("~");
			printer.println("action");
			printer.println("~");
			printer.println("omas");
			printer.println("~ now define the regions and number of copies");
			printer.println("spac numc=5 pick #mon " + minResidue.getText().trim() + " " + maxResidue.getText().trim() + " done");
			printer.println("*EOD");
			printer.flush();
			printer.close();
			
			
			//md simulation input file
			printer = new PrintWriter(new FileWriter(outdir + File.separator + "md.in"));
			printer.println("Production MD");
			printer.println(" &cntrl");
			printer.println("	imin=0, irest=1, ntx=5,");
			printer.println("	nstlim=" + steps + ", dt=0.001, ntc=1,");
			printer.println("	ntpr=" + frequency + ", ntwx=" + frequency + ",");
			printer.println("	cut=15, ntb=0, igb=1,");
			printer.println("	ntt=3, gamma_ln=1.0,");
			printer.println("	tempi=300.0, temp0=300.0,");
			printer.println(" /");
			printer.flush();
			printer.close();
			
			
			//now write out the automation script
			printer = new PrintWriter(new FileWriter(outdir + File.separator + "run.sh"));
			printer.println("#!/bin/csh");
			printer.println("set MDSTARTJOB=2");
			printer.println("set MDENDJOB=" + totalRunsCount);
			printer.println("set MDCURRENTJOB=$MDSTARTJOB");
			printer.println("set MDINPUT=0");

			printer.println("echo -n \"Starting Script at: \"");
			printer.println("date");
			printer.println("echo \"\"");

			printer.println("mpirun -n " + nThreads + " $AMBERHOME/exe/pmemd -O -i min.in -o " + basename + "_min.out \\");
			printer.println("	-p " + basename + ".prmtop -c " + basename + ".inpcrd \\");
			printer.println("	-r " + basename + "_min.rst\n"); 

			printer.println("mpirun -n " + nThreads + " $AMBERHOME/exe/pmemd -O -i eq.in -o " + basename + "_eq.out \\");
			printer.println("	-p " + basename + ".prmtop -c " + basename + "_min.rst \\");
			printer.println("	-r " + basename + "_eq.rst -x " + basename + "_eq.mdcrd\n");
			
			printer.println("$AMBERHOME/exe/addles < les.in > les.out\n");

			printer.println("mpirun -n " + nThreads + " $AMBERHOME/exe/sander.LES.MPI -O -i md.in -o " + basename + "_les_run1.out \\");
			printer.println("	-p " + basename + "_les.prmtop -c " + basename + "_les.inpcrd \\");
			printer.println("	-r " + basename + "_les_run1.rst -x " + basename + "_les_run1.mdcrd\n");

			printer.println("while ( $MDCURRENTJOB <= $MDENDJOB )");
			printer.println("   echo -n \"Job $MDCURRENTJOB started at: \"");
			printer.println("   date");
			printer.println("   @ MDINPUT = $MDCURRENTJOB - 1");
			printer.println("   mpirun -n " + nThreads + " $AMBERHOME/exe/sander.LES.MPI -O -i md.in \\");
			printer.println("                            -o " + basename + "_les_run$MDCURRENTJOB.out \\");
			printer.println("                            -p " + basename + "_les.prmtop \\");
			printer.println("                            -c " + basename + "_les_run$MDINPUT.rst \\");
			printer.println("                            -r " + basename + "_les_run$MDCURRENTJOB.rst \\");
			printer.println("                            -x " + basename + "_les_run$MDCURRENTJOB.mdcrd");
			printer.println("   echo -n \"Job $MDCURRENTJOB finished at: \"");
			printer.println("   date");
			printer.println("	@ MDCURRENTJOB = $MDCURRENTJOB + 1");
			printer.println("end");
			printer.println("echo \"ALL DONE\"");
			printer.flush();
			printer.close();

			
			/**
			 * TODO the current problem with compression is that we need to specify full path to
			 * the target directory, and that results in the full path being encoded in the tar file.
			 * This produces an unnecessary directory structure on the execution host.
			 * For now, replace this with a simple Perl script that allows changing of current
			 * directory and use of bare file names.
			 */
/*			//if we are on a Linux machine, compress the output directory
			String os = System.getProperty("os.name");
			if (os.startsWith("Linux")){
				try{
					System.out.println("Linux");
					String[] cmd = new String[4];
					cmd[0] = "/bin/tar";
					cmd[1] = "-cvf";
					cmd[2] = outdir + ".tar";
					cmd[3] = outdir;
					
					System.out.println(cmd[2]);
					
					Process process = Runtime.getRuntime().exec(cmd);
						
					InputStream in = process.getInputStream();
					BufferedReader reader = new BufferedReader(new InputStreamReader(in));
					String line = null;
					String dump = null;
					while ((line = reader.readLine()) != null){
						dump = line;
					}
			        in.close();
			        
			        process.waitFor();

					//next, compress the tar file
			        cmd = new String[2];
					cmd[0] = "/usr/bin/gzip";
					cmd[1] = outdir + ".tar";
					System.out.println(cmd[1]);
					
					process = Runtime.getRuntime().exec(cmd);
						
					in = process.getInputStream();
					reader = new BufferedReader(new InputStreamReader(in));
					line = null;
					dump = null;
					while ((line = reader.readLine()) != null){
						dump = line;
					}
			        in.close();
			        
			        process.waitFor();
					
			        System.out.println("Finished compression");
					
				}
				catch (Exception ex){
					parent.displayExceptionMessage("Exception trying to compress output directory", ex);
				}
			}
*/			
			
			setVisible(false);
			parent.displayMessage("Molecular Dynamics setup completed");
		}
		catch (Exception ex){
			parent.displayExceptionMessage("Exception preparing MD simulation", ex);
		}
		
		
		
		parent.setDisplayDialogStatus(false);
		
		dispose();
	}
	
	private Border createTitledBorder(String title){
		
		Border border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		TitledBorder border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " " + title + " ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		Border border = BorderFactory.createCompoundBorder(border1, border2);

		return border;
	}

	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
