package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class LabelDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel setPanel = new JPanel();
	private JPanel typePanel = new JPanel();
	private JPanel actionPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	public int setFlag = DialogConstants.APPLY_SELECTION;
	
	public static final int TYPE_NAME = 0;
	public static final int TYPE_ELEMENT = 1;
	public static final int TYPE_CHARGE = 2;
	public static final int TYPE_HYBRIDIZATION = 3;
	public static final int TYPE_COORDINATES = 4;
	public static final int TYPE_CUSTOM = 5;
	
	public int typeFlag = TYPE_NAME;
	
	private ButtonGroup setGroup = new ButtonGroup();
	private JRadioButton radio1 = new JRadioButton("Entire display", false);
	private JRadioButton radio2 = new JRadioButton("Currently selected", true);
	private JRadioButton radio3 = new JRadioButton("Structure", false);
	private JRadioButton radio4 = new JRadioButton("Chain", false);
	private JRadioButton radio5 = new JRadioButton("Residue", false);
	private JRadioButton radio6 = new JRadioButton("Atom", false);
	
	private ButtonGroup typeGroup = new ButtonGroup();
	private JRadioButton radio7 = new JRadioButton("Atom name", true);
	private JRadioButton radio8 = new JRadioButton("Element", false);
	private JRadioButton radio9 = new JRadioButton("Partial charge", false);
	private JRadioButton radio10 = new JRadioButton("Hybridization", false);
	private JRadioButton radio105 = new JRadioButton("Coordinates", false);
	private JRadioButton radio11 = new JRadioButton("Custom label", false);
	
	private ButtonGroup actionGroup = new ButtonGroup();
	private JRadioButton radio12 = new JRadioButton("Add labels", true);
	private JRadioButton radio13 = new JRadioButton("Remove labels", false);

	private JTextField field = new JTextField(30);
	private JLabel header = new JLabel();
	private JLabel label = new JLabel();
	
	private JTextField customField = new JTextField(30);
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JLabel or = new JLabel("or");
	private JComboBox combo = new JComboBox();
	private Vector structures = new Vector();

	
	private LabelEvent event;
	
	public LabelDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Atom labels", false);

		setFlag = DialogConstants.APPLY_SELECTION;
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		
		
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(360, 300));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 360, 300);
		base.setLayout(null);
		
		setPanel.setPreferredSize(new Dimension(200, 290));
		setPanel.setLocation(new Point(5,5));
		setPanel.setBounds(5,5,200,290);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Apply to ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		//text field
		header.setForeground(Color.black);
		header.setFont(new Font("Dialog", Font.PLAIN, 12));
		header.setText("Pick object to label");
		header.setBounds(20,85,150,20);
		
		label.setForeground(Color.black);
		label.setFont(new Font("Dialog", Font.PLAIN, 11));
		label.setText("Enter name or click structure");
		label.setPreferredSize(new Dimension(8,20));
		label.setBounds(20,195,170,20);
		
		field.setBounds(20,215,160,20);
		field.setEditable(false);
		field.setEnabled(false);
		field.setVisible(true);
		field.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				if (radio1.isSelected()){
					setFlag = DialogConstants.APPLY_RESIDUE;
					radio1.setSelected(false);
					radio4.setSelected(true);
					field.setText("");
					field.setEditable(true);
					field.setEnabled(true);
					field.requestFocus();
				}
			}
		});
		field.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});
		
		
		or.setForeground(Color.black);
		or.setFont(new Font("Dialog", Font.PLAIN, 11));
		or.setBounds(20,250,15,20);
		
		//walk through the loaded structures
		structures.add("Select structure or set");
		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures.add(sv.getStructureName(st));
		}
		
		Vector setNames = sv.getAtomSetNames();
		for (int i = 0; i < setNames.size(); i++){
			structures.add(setNames.get(i));
		}


		combo = new JComboBox(structures);
		combo.setBounds(35,250,145,20);
		if (structures.size() == 1) combo.setEnabled(false);
		combo.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo.getSelectedItem();
				if (choice.startsWith("Select")) return;
				field.setText(choice);
				field.setEnabled(true);
				field.setEditable(true);
				setFlag = DialogConstants.APPLY_STRUCTURE;		
				radio3.setSelected(true);
			}
		});
		
		
		//define the radio buttons
		radio1.setLocation(20,25);
		radio1.setBounds(20,25,150,20);
		radio1.setVisible(true);
		radio1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_ALL;
				field.setText("");
				field.setEditable(false);
				field.setEnabled(false);
			}
		});

		radio2.setBounds(20,50,150,20);
		radio2.setVisible(true);
		radio2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_SELECTION;
				field.setText("");
				field.setEditable(false);
				field.setEnabled(false);
			}
		});
		
		radio3.setBounds(20,110,150,20);
		radio3.setVisible(true);
		radio3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_STRUCTURE;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		radio4.setBounds(20,130,150,20);
		radio4.setVisible(true);
		radio4.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_CHAIN;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		radio5.setBounds(20,150,150,20);
		radio5.setVisible(true);
		radio5.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_RESIDUE;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		radio6.setBounds(20,170,150,20);
		radio6.setVisible(true);
		radio6.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_ATOM;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		//draw a line between the radio buttons
		JSeparator line = new JSeparator();
		line.setBounds(10,80,180,5);
		line.setVisible(true);
		
		setPanel.add(line);
		setPanel.add(header);
		
		setGroup.add(radio1);
		setGroup.add(radio2);
		setGroup.add(radio3);
		setGroup.add(radio4);
		setGroup.add(radio5);
		setGroup.add(radio6);
		
		setPanel.add(radio1);
		setPanel.add(radio2);
		setPanel.add(radio3);
		setPanel.add(radio4);
		setPanel.add(radio5);
		setPanel.add(radio6);
		
		setPanel.add(label);
		setPanel.add(field);
		setPanel.add(or);
		setPanel.add(combo);
		
		
		//type panel
		typePanel.setBounds(205,5,150,190);
		typePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  Label data ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		typePanel.setBorder(border);
		
		//second button group
		radio7.setBounds(20,20,100,20);
		radio7.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				typeFlag = TYPE_NAME;
				customField.setEnabled(false);
				customField.setEditable(false);
			}
		});
		
		radio8.setBounds(20,40,100,20);
		radio8.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				typeFlag = TYPE_ELEMENT;
				customField.setEnabled(false);
				customField.setEditable(false);
			}
		});
		
		radio9.setBounds(20,60,100,20);
		radio9.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				typeFlag = TYPE_CHARGE;
				customField.setEnabled(false);
				customField.setEditable(false);
			}
		});
		
		radio10.setBounds(20,80,100,20);
		radio10.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				typeFlag = TYPE_HYBRIDIZATION;
				customField.setEnabled(false);
				customField.setEditable(false);
			}
		});
		
		radio105.setBounds(20,100,100,20);
		radio105.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				typeFlag = TYPE_COORDINATES;
				customField.setEnabled(false);
				customField.setEditable(false);
			}
		});

		radio11.setBounds(20,120,100,20);
		radio11.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				typeFlag = TYPE_CUSTOM;
				customField.setEnabled(true);
				customField.setEditable(true);
				customField.requestFocus();
			}
		});
		
		customField.setBounds(20,155,110,20);
		customField.setEditable(false);
		customField.setEnabled(false);
		customField.setVisible(true);
		customField.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				if (radio11.isSelected()){
					customField.setText("");
					customField.setEditable(true);
					customField.setEnabled(true);
					customField.requestFocus();
				}
			}
		});
		customField.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});

		
		typeGroup.add(radio7);
		typeGroup.add(radio8);
		typeGroup.add(radio9);
		typeGroup.add(radio10);
		typeGroup.add(radio105);
		typeGroup.add(radio11);
		
		typePanel.add(radio7);
		typePanel.add(radio8);
		typePanel.add(radio9);
		typePanel.add(radio10);
		typePanel.add(radio105);
		typePanel.add(radio11);
		typePanel.add(customField);
		
		//type panel
		actionPanel.setBounds(205,195,150,100);
		actionPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  Action ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		actionPanel.setBorder(border);
		
		//second button group
		radio12.setBounds(20,25,100,20);
		radio13.setBounds(20,50,100,20);
		
		
		actionGroup.add(radio12);
		actionGroup.add(radio13);
		
		actionPanel.add(radio12);
		actionPanel.add(radio13);
		
		//add panels to the base
		base.add(setPanel);
		base.add(typePanel);
		base.add(actionPanel);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(100, 315));
		okButton.setBounds(100, 315, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(200, 315));
		cancelButton.setBounds(200, 315, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(380, 375);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		try{
			
		
			//add error checking for selection bounds
			//eg., selection level is residue, but entered only structure name
			setVisible(false);
			
			//first, check the number of tags
			int count = 0;
			StringTokenizer tok = new StringTokenizer(field.getText(), ":", false);
			while (tok.hasMoreTokens()){
				Object o = tok.nextToken();
				count++;
			}
			
			if (setFlag != DialogConstants.ADD_SELECTION && setFlag != DialogConstants.APPLY_ALL){
				if (count < setFlag){
					setFlag = count;
				}
			}
	
			event = new LabelEvent(itself);
			event.setFlag = setFlag;
			event.typeFlag = typeFlag;
			event.structureComponent = structureComponent;
			event.componentId = field.getText();
			event.aux = radio12.isSelected();//whether to add or remove labels
			
			event.text = customField.getText();
			
			Thread runner = new Thread(){
				public void run(){
					parent.setDisplayDialogStatus(false);
					sv.processDisplayDialogEvent(event);
				}
			};
			runner.start();
		
		}
		catch (Exception e){
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception setting atom labels", e);
		}

		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		if (field.isEditable()){
			field.setText(data);
		}
	}
	
}
