package edu.sdsc.sirius.dialogs;

// Core
import java.io.*;
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.*;
import edu.sdsc.sirius.viewers.*;
import edu.sdsc.sirius.md.*;

public class MDEnergyDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private MDPanel mdPanel;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private JPanel inputPanel = new JPanel();
	private JPanel typePanel = new JPanel();
	private JPanel outputPanel = new JPanel();
	
	private JButton inputButton2;
	private JButton inputButton3;
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private JTextField inputField1 = new JTextField(50);//nowat prmtop of the system
	
	private JTextField inputField2 = new JTextField(50);//nowat prmtop of the protein
	private JTextField inputField3 = new JTextField(50);//nowat prmtop of the ligand
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton stabilityButton = new JRadioButton("Calculate system stability", true);
	private JRadioButton bindingButton = new JRadioButton("Calculate binding energy", false);
	
	private JTextField dirField = new JTextField(50);
	
	private JTextField snapshotCount = new JTextField(30);
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private String out;
	
	public MDEnergyDialog(JFrame f, Manager p, MDPanel md, String n){

		super(f, "Calculate system energy with MM-PBSA", false);

		parentFrame = f;
		parent = p;
		mdPanel = md;
		out = n;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 495, 300);
		base.setLayout(null);
		
		//first panel - input files
		inputPanel.setBounds(5,5,485,85);
		inputPanel.setLayout(null);
		
		inputPanel.setBorder(createTitledBorder("Desolvated system PRMTOP"));
		
		JLabel input1 = new JLabel("System prmtop:");
		
		input1.setBounds(20, 25, 90, 20);
		
		inputField1.setBounds(120,25,245,20);
				
		JButton inputButton1 = new JButton("Browse...");
		inputButton1.setFont(new Font("Dialog", Font.PLAIN, 12));
		inputButton1.setBounds(370,25,90,20);
		inputButton1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				int result = chooser.showOpenDialog(parent.getApplicationFrame());
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				inputField1.setText(filename.toString());
				parent.setLastUsedDirectory(filename.toString());
			}
		});
		
		JLabel snaps = new JLabel("Number of trajectory snapshots:");
		snaps.setBounds(20, 50, 250, 20);
		
		snapshotCount.setBounds(315, 50, 50, 20);
		snapshotCount.setText("50");
		
		
		
		inputPanel.add(input1);
		inputPanel.add(inputField1);
		inputPanel.add(inputButton1);
		inputPanel.add(snaps);
		inputPanel.add(snapshotCount);
				
		base.add(inputPanel);
		
		//type
		typePanel.setBounds(5,90,485,150);
		typePanel.setLayout(null);
		
		typePanel.setBorder(createTitledBorder("Type of calculation"));
		stabilityButton.setBounds(20, 25, 200, 20);
		stabilityButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (stabilityButton.isSelected()){
					inputField2.setText("");
					inputField2.setEnabled(false);
					inputField3.setText("");
					inputField3.setEnabled(false);
					inputField2.setEditable(false);
					inputField3.setEditable(false);
					inputButton2.setEnabled(false);
					inputButton3.setEnabled(false);
				}
			}
		});
		
		bindingButton.setBounds(20, 50, 200, 20);
		bindingButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (bindingButton.isSelected()){
					
					
					
					//check whether anything in the loaded structure is selected
					//since selection denotes the ligand
					StructureViewer viewer = parent.getStructureViewer();
					
					if (viewer.getLoadedStructures().size() == 0){
						parent.displayErrorMessage("No structures are loaded. Please wait until the first frame loads and try again.");
						return;
					}
					
					Structure structure = (Structure)viewer.getLoadedStructures().get(0);
					Hashtable selected = structure.getStructureMap().getStructureStyles().getSelection();
					
					if (selected.size() == 0){
						parent.displayErrorMessage("Nothing is selected in the loaded structure. Ligand cannot be found.");
						stabilityButton.setSelected(true);
						bindingButton.setSelected(false);
						return;
					}
					
					
					inputField2.setEnabled(true);
					inputField3.setEnabled(true);
					inputField2.setEditable(true);
					inputField3.setEditable(true);
					inputButton2.setEnabled(true);
					inputButton3.setEnabled(true);
				}
			}
		});

		group.add(bindingButton);
		group.add(stabilityButton);
		
		typePanel.add(stabilityButton);
		typePanel.add(bindingButton);
		
		
		//add prmtop fields
		JLabel p1 = new JLabel("Desolvated protein prmtop:");
		p1.setBounds(40, 75, 140, 20);
		
		inputField2.setBounds(185,75,175,20);
		inputField2.setEnabled(false);
		inputField2.setEditable(false);
		
		inputButton2 = new JButton("Browse...");
		inputButton2.setEnabled(false);
		inputButton2.setFont(new Font("Dialog", Font.PLAIN, 12));
		inputButton2.setBounds(370,75,90,20);
		inputButton2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				int result = chooser.showOpenDialog(parent.getApplicationFrame());
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				inputField2.setText(filename.toString());
				parent.setLastUsedDirectory(filename.toString());
			}
		});
		
		
		JLabel p2 = new JLabel("Desolvated ligand prmtop:");
		p2.setBounds(40, 100, 140, 20);
		
		inputField3.setBounds(185,100,175,20);
		inputField3.setEnabled(false);
		inputField3.setEditable(false);
		
		inputButton3 = new JButton("Browse...");
		inputButton3.setEnabled(false);
		inputButton3.setFont(new Font("Dialog", Font.PLAIN, 12));
		inputButton3.setBounds(370,100,90,20);
		inputButton3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				int result = chooser.showOpenDialog(parent.getApplicationFrame());
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				inputField3.setText(filename.toString());
				parent.setLastUsedDirectory(filename.toString());
			}
		});
		
		
		
		typePanel.add(p1);
		typePanel.add(p2);
		typePanel.add(inputField2);
		typePanel.add(inputButton2);
		typePanel.add(inputField3);
		typePanel.add(inputButton3);
		
		
		base.add(typePanel);
		
		
		//output directory
		outputPanel.setBounds(5,240,485,50);
		outputPanel.setLayout(null);
		outputPanel.setBorder(createTitledBorder("Output directory"));

		dirField.setBounds(25,20,335,20);
		dirField.setText(out);
		
		JButton dirButton = new JButton("Browse...");
		dirButton.setFont(new Font("Dialog", Font.PLAIN, 12));
		dirButton.setBounds(370,20,90,20);
		dirButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				int result = chooser.showOpenDialog(parent.getApplicationFrame());
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				dirField.setText(filename.toString());
			}
		});
		
		
		outputPanel.add(dirField);
		outputPanel.add(dirButton);		
		
		
		base.add(outputPanel);
		
		contentPane.add(base);
		
		//buttons
		okButton.setBounds(150, 310, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				Thread runner = new Thread(){
					public void run(){
						process();
					}
				};
				runner.start();
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		cancelButton.setBounds(270, 310, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
		});
				
		setSize(510, 365);
		
		if (parent == null){
			setLocationRelativeTo(null);
		}
		else{
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parent.getApplicationFrame().getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);
		
			setBounds(x + parent.getApplicationFrame().getX(), y + parent.getApplicationFrame().getY(), d1.width, d1.height);
		}
		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		//collect the input data
		String desolvComplexPrmtop = inputField1.getText().trim();
		
		boolean binding = false;
		if (bindingButton.isSelected()){
			binding = true;
		}
		
		String outdir = dirField.getText().trim();
		
		String desolvProteinPrmtop = inputField2.getText().trim();
		String desolvLigandPrmtop = inputField3.getText().trim();
		
		//pass the parameters back to the md panel
		PBSAInput input = new PBSAInput();
		input.desolvComplexPrmtop = desolvComplexPrmtop;
		input.desolvProteinPrmtop = desolvProteinPrmtop;
		input.desolvLigandPrmtop = desolvLigandPrmtop;
		input.outdir = outdir;
		
		input.binding = binding;
		
		try{
			input.snapshotCount = Integer.parseInt(snapshotCount.getText().trim());
		}
		catch (NumberFormatException e){
			System.err.println("Incorrect value of snapshot count entered. Default 50 is assumed");
		}
		
		if (binding){
			//get the selected atoms
			StructureViewer viewer = parent.getStructureViewer();
			Structure structure = (Structure)viewer.getLoadedStructures().get(0);
			Hashtable selected = structure.getStructureMap().getStructureStyles().getSelection();
			
			Vector selection = new Vector();
			Set keys = selected.keySet();
			Iterator it = keys.iterator();
			while (it.hasNext()){
				try{
					Atom a = (Atom)it.next();
					selection.add(a);
				}
				catch (ClassCastException ex){
					continue;
				}
			}
			
			input.ligand = selection;
		}
		
		mdPanel.computeEnergy(input);
	}
	
	private Border createTitledBorder(String title){
		
		Border border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		TitledBorder border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " " + title + " ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		Border border = BorderFactory.createCompoundBorder(border1, border2);

		return border;
	}

	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
