package edu.sdsc.sirius.dialogs;

import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;
import javax.swing.event.*;

import edu.sdsc.sirius.dialogs.TableImpl.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.sirius.md.*;

import java.io.*;

public class MDFileListerDialog extends JDialog implements ResultPanelCallable {
	
	private Container contentPane;
	private JDialog self;
	
	private int width = 300;
	private int height = 350;
	
	public static final int TYPE_OUT = 0;
	public static final int TYPE_COORD = 1;
	
	private String workingDir = ".";
	
	public MDPanel parent;
	private JFrame parentFrame;
	
	private StructureDocument structureDocument;
	
	private Manager callable;
	
	private JPanel base = new JPanel();
	private JPanel buttonPanel = new JPanel();
	private JButton loadButton = new JButton("OK");
	private JButton closeButton = new JButton("Cancel");
	
	private JButton up = new JButton("Move up");
	private JButton down = new JButton("Move down");
	
	private File[] order;//new ordered list
	private HashMap indices = new HashMap();//DataBlock -> its position in the set
	
	private String[] list;
	
	private JList listObject;
	
	private int type = 0;
	
	/**
	 * Constructor that creates the dialog.
	 * @param f parent frame
	 * @param p Manager object that will process the RequestSet
	 * @param title dialog title
	 * @param modal whether the dialog is modal (other frames in the application will be inaccessible)
	 */
	public MDFileListerDialog (JFrame f, MDPanel parent, Manager callable, File[] files, int t){
	
		super(f, "Order of MD trajectory files", false);
		this.parent = parent;
		parentFrame = f;
		this.type = t;
		
		this.callable = callable;
		
		order = files;
		list = new String[files.length];
		
		for (int j = 0; j < files.length; j++){
			String ff = files[j].toString();
			String label = null;
			int index2 = ff.lastIndexOf(File.separator);
			if (index2 > 0){
				label = ff.substring(index2+1);
			}
			else{
				label = ff;
			}
			
			list[j] = label;
		}
		
		self = this;
		
		base.setBorder(new BevelBorder(BevelBorder.LOWERED));
		base.setLayout(new BorderLayout());
		
		JScrollPane sp = new JScrollPane();
		base.setBackground(new Color(200,200,240));
		
		listObject = new JList(list);
		listObject.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		sp.getViewport().add(listObject);
		base.add(sp, BorderLayout.CENTER);

		
		//add window listener
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				dispose();
			}
		});
		
		getContentPane().add(base, BorderLayout.CENTER);
		
		//add the manipulation panel
		JPanel controlPanel = new JPanel();
		controlPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 10, 5));
		up.setPreferredSize(new Dimension(90,23));
		up.setVisible(true);
		up.setEnabled(false);
		up.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				int index = listObject.getSelectedIndex();
				
				//swap the current file with the previous one
				int last = index - 1;
				StringBuffer buffer = new StringBuffer();
				buffer.append(list[last]);
				String temp = buffer.toString();
				list[last] = list[index];
				list[index] = temp;
				listObject.setSelectedIndex(last);
				
				//make the same swap of File objects
				File f = order[last];
				order[last] = order[index];
				order[index] = f;
				
				listObject.revalidate();
				listObject.repaint();
			}
		});
		
		down.setPreferredSize(new Dimension(90,23));
		down.setVisible(true);
		down.setEnabled(false);
		down.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				int index = listObject.getSelectedIndex();
				
				//swap the current file with the previous one
				int next = index + 1;
				StringBuffer buffer = new StringBuffer();
				buffer.append(list[next]);
				String temp = buffer.toString();
				list[next] = list[index];
				list[index] = temp;
				listObject.setSelectedIndex(next);
				
				//make the same swap of File objects
				File f = order[next];
				order[next] = order[index];
				order[index] = f;
				
				listObject.revalidate();
				listObject.repaint();


			}
		});
		
		listObject.addListSelectionListener(new ListSelectionListener(){
			public void valueChanged(ListSelectionEvent e){
				if (e.getValueIsAdjusting()) return;
				
				int index = listObject.getSelectedIndex();
				if (index == -1) return;
				
				if (index == 0){
					up.setEnabled(false);
					down.setEnabled(true);
				}
				else if (index == list.length-1){
					up.setEnabled(true);
					down.setEnabled(false);
				}
				else{
					up.setEnabled(true);
					down.setEnabled(true);
				}
			}
		});
		
		controlPanel.add(up);
		controlPanel.add(down);
		
		base.add(controlPanel, BorderLayout.SOUTH);
		
		//panel that holds buttons
		JPanel lowerPanel = new JPanel();
		lowerPanel.setLayout(new BorderLayout());
		JPanel borderPanel = new JPanel();
		borderPanel.setLayout(new BorderLayout());
		borderPanel.add(new JSeparator(), BorderLayout.NORTH);
		
		lowerPanel.add(borderPanel, BorderLayout.NORTH);
		
		buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 30, 5));
		
		loadButton.setPreferredSize(new Dimension(80,25));
		loadButton.setVisible(true);
		loadButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				if (type == TYPE_OUT){
					((MDFileListerDialog)self).parent.readUpdatedOutFileList(order);
				}
				else{
					((MDFileListerDialog)self).parent.readUpdatedCoordFileList(order);
				}
				dispose();
			}
		});
		
		closeButton.setPreferredSize(new Dimension(80,25));
		closeButton.setVisible(true);
		closeButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				dispose();
			}
		});
		
		buttonPanel.add(loadButton);
		buttonPanel.add(closeButton);
		
		
		lowerPanel.add(buttonPanel, BorderLayout.CENTER);
		getContentPane().add(lowerPanel, BorderLayout.SOUTH);
		
		Dimension dim = getToolkit().getScreenSize();
		if (parentFrame == null){
			setLocationRelativeTo(null);
		}
		else{
			int x = parentFrame.getX() + (parentFrame.getWidth() - this.width)/2;
			int y = parentFrame.getY() + (parentFrame.getHeight() - this.height)/2;
			setBounds(x, y, width, height);
		}
		
		setSize(width, height);
		
		setVisible(true);
	}
	
	/**
	 * Sets the display to the given DataSet.
	 */
/*	public void setData(DataSet set){
		
		System.out.println("set data");
	
		if (contentPanel != null){
			return;
		}
		
		System.out.println("setting table");
		//used to show a table in a previously open frame
		//(after a new search initiated from this frame)
		contentPanel = new ResultPanel(this, set, callable, ResultPanel.NAVIGATION_TABLE, searchTypes, null);
		contentPane.remove(base);
		contentPane.add(contentPanel, BorderLayout.CENTER);
		
	}
*/	
	public void setNumberOfHits(int n){}
	
	public void setSelectedIndices(Vector v){}
}