package edu.sdsc.sirius.dialogs;

// Core
import java.io.File;
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.*;
import edu.sdsc.sirius.viewers.*;

import edu.sdsc.sirius.md.*;

public class MDRMSDDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	private MDPanel mdpanel;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private JPanel sourcePanel = new JPanel();
	private JPanel selectionPanel = new JPanel();
	private JPanel referencePanel = new JPanel();
	private JPanel setPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	public static final int FIRST_FRAME = 0;
	public static final int LOWEST_FRAME = 1;
	public static final int ANOTHER_STRUCTURE = 2;
	
	
	private int reference = FIRST_FRAME;
	
	private boolean ptraj = false;
	
	public static final int USE_ALL_ATOMS = 0;
	public static final int USE_ALL_EXCEPT_SOLVENT = 1;
	public static final int USE_ALL_HEAVY_ATOMS_EXCEPT_SOLVENT = 2;
	public static final int USE_BACKBONE_ATOMS = 3;
	public static final int USE_CA_ATOMS = 4;
	public static final int USE_DEFINED_SET = 5;
	
	private int extent = USE_ALL_ATOMS;
	
	private JTextField nameField = new JTextField(30);
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton first = new JRadioButton("First frame of the run", true);
	private JRadioButton lowest = new JRadioButton("Lowest energy frame", false);
	private JRadioButton another = new JRadioButton("Another structure of the loaded molecule", false);
	
	private ButtonGroup group2 = new ButtonGroup();
	private JRadioButton allAtoms = new JRadioButton("Use all atoms", true);
	private JRadioButton noSolventAtoms = new JRadioButton("Use all atoms except solvent", false);
	private JRadioButton heavyAtoms = new JRadioButton("Use all heavy atoms atoms except solvent", false);
	private JRadioButton backboneAtoms = new JRadioButton("Use only backbone atoms", false);
	private JRadioButton caAtoms = new JRadioButton("Use only alpha-carbons (proteins)", false);
	private JRadioButton setAtoms = new JRadioButton("Use custom atom set", false);
	
	
	private JRadioButton sourceLoaded = new JRadioButton("Loaded trajectory", true);
	private JRadioButton sourceFile = new JRadioButton("Select trajectory files", false);
	private JTextField sourceFileText = new JTextField(50);
	private JButton sourceFileButton = new JButton("mdcrd/dcd");
	private JTextField sourcePsfText = new JTextField(50);
	private JButton sourcePsfButton = new JButton("prmtop/psf");
	
	private JRadioButton selectionIgnore = new JRadioButton("Use entire structure", true);
	private JRadioButton selectionUse = new JRadioButton("Use current selection", false);
	
	private JLabel customSetLabel = new JLabel();

	private JComboBox currentSets;
	
	private Vector trajectories = new Vector();//String filenames


	private JTextField field = new JTextField(50);
	private JLabel label1 = new JLabel();
	
	private JTextField field2 = new JTextField(30);
	private JLabel label2 = new JLabel();
	
	private JLabel label3 = new JLabel();
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JTextField referenceFileField;
	private JButton referenceFileButton;
	
	private Vector existingSets;
	private Vector list = new Vector();
	
	private boolean browsing = false;
	
	public MDRMSDDialog(JFrame f, Manager p, MDPanel mdpanel, StructureViewer s){

		super(f, "Compute RMSD graph", false);

		parentFrame = f;
		parent = p;
		sv = s;
		this.mdpanel = mdpanel;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		String arch = System.getProperty("os.arch");
		
		if (System.getProperty("os.name").startsWith("Win")){
			ptraj = false;
		}
		else{
			String pt = "/data/amber10/exe/ptraj";
			File ff = new File(pt);
			if (ff.exists()){
				ptraj = true;
			}
			else{
				ptraj = false;
			}
		}
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		existingSets = sv.getAtomSetNames();

		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 300, 500);
		base.setLayout(null);
		
		sourcePanel.setBounds(5,5, 290, 130);
		sourcePanel.setLayout(null);
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Source trajectory ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		sourcePanel.setBorder(border);
		
		if (!ptraj){
			sourceFile.setEnabled(false);
		}
		
		ButtonGroup g = new ButtonGroup();
		g.add(sourceLoaded);
		g.add(sourceFile);
		
		sourceLoaded.setBounds(20, 20, 200, 20);
		sourceFile.setBounds(20, 40, 200, 20);
		
		sourceFile.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				boolean file = sourceFile.isSelected();
				sourceFileText.setEnabled(file);
				sourceFileButton.setEnabled(file);
				sourceFileText.setEditable(file);
				sourcePsfText.setEnabled(file);
				sourcePsfText.setEditable(file);
				sourcePsfButton.setEnabled(file);
				
				lowest.setEnabled(false);
				if (lowest.isSelected()){
					first.setSelected(true);
					lowest.setSelected(false);
				}
			}
		});
		
		sourceLoaded.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				boolean loaded = sourceLoaded.isSelected();
				sourceFileText.setEnabled(!loaded);
				sourceFileButton.setEnabled(!loaded);
				sourceFileText.setEditable(!loaded);
				
				sourcePsfText.setEnabled(!loaded);
				sourcePsfButton.setEnabled(!loaded);
				sourcePsfText.setEditable(!loaded);

				lowest.setEnabled(true);
			}
		});
		
		sourceFileText.setEnabled(false);
		sourceFileText.setEditable(false);
		sourcePsfText.setEnabled(false);
		sourcePsfText.setEditable(false);
		
		sourceFileButton.setEnabled(false);
		sourcePsfButton.setEnabled(false);
		
		sourceFileText.setBounds(20, 95, 150, 20);
		sourceFileButton.setBounds(180, 95, 95, 20);
		
		sourcePsfText.setBounds(20, 65, 150, 20);
		sourcePsfButton.setBounds(180, 65, 95, 20);
		
		sourcePsfButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				browsing = true;
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.setApproveButtonText("Select");
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int result = chooser.showOpenDialog(parentFrame);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				String newDirectory = filename.toString();
				sourcePsfText.setText(newDirectory);
				parent.setLastUsedDirectory(newDirectory);
				browsing = false;
			}
		});
				
		sourceFileButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				browsing = true;
				//open MD output file
				final JFileChooser jFileChooser = new JFileChooser(parent.getLastUsedDirectory());
				jFileChooser.setMultiSelectionEnabled(true);
				//amber md output type
				javax.swing.filechooser.FileFilter structureFilter = new javax.swing.filechooser.FileFilter( ){

					public boolean accept( File file ){
						if ( file.toString().endsWith("mdcrd") ) return true;
						if ( file.toString().endsWith("mdcrd.gz") ) return true;
						if ( file.toString().endsWith("dcd") ) return true;
						if ( file.isDirectory() ) return true;
						return false;
					}
					
					public String getDescription( ){
						return "MD trajectory file";
					}
				};
				
				jFileChooser.addChoosableFileFilter( structureFilter );
				
				int returnVal = jFileChooser.showOpenDialog( parent.getApplicationFrame() );
				if ( returnVal == JFileChooser.APPROVE_OPTION ){
					Thread runner = new Thread(){
						public void run(){
							browsing = true;
							trajectories.clear();
							//get the filename and read the out file
							File[] files = jFileChooser.getSelectedFiles( );
							//save the used directory
							String dir = files[0].getParentFile().toString();
							parent.setLastUsedDirectory(dir);
							
							//check files
							for (int i = 0; i < files.length; i++){
								File f = files[i];
								if (!f.toString().endsWith("mdcrd") && !f.toString().endsWith("mdcrd.gz") && !f.toString().endsWith("dcd")){
									parent.displayErrorMessage("All selected files must be MD trajectories");
									return;
								}
								trajectories.add(files[i]);
							}
							
							try{
								//display the array of files in a dialog to allow the user to arrange the files in the correct order
								//the dialog will call readUpdatedFileList()
								TrajectoryListerDialog d = new TrajectoryListerDialog(parent.getApplicationFrame(), parent, trajectories);
							}
							catch (Exception e){
								e.printStackTrace();
							}
							
							
							sourceFileText.setText(trajectories.get(0).toString());
							browsing = false;
						}
					};
					runner.start();
				
				}

				browsing = false;
			}
		});
		
		sourcePanel.add(sourceLoaded);
		sourcePanel.add(sourceFile);
		sourcePanel.add(sourceFileText);
		sourcePanel.add(sourceFileButton);
		sourcePanel.add(sourcePsfText);
		sourcePanel.add(sourcePsfButton);
		
		base.add(sourcePanel);
		
		
		selectionPanel.setBounds(5, 135, 290, 70);
		selectionPanel.setLayout(null);
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Atom set used for RMSD calculation");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		selectionPanel.setBorder(border);

		selectionIgnore.setBounds(25, 20, 200, 20);
		selectionUse.setBounds(25, 40, 200, 20);
		
		selectionPanel.add(selectionIgnore);
		selectionPanel.add(selectionUse);
		
		ButtonGroup select = new ButtonGroup();
		select.add(selectionIgnore);
		select.add(selectionUse);
		
		base.add(selectionPanel);
		
		
		
		referencePanel.setBounds(5,205,290,130);
		referencePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Reference for RMSD calculation ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		referencePanel.setBorder(border);
		
	
		//define the radio buttons
		first.setBounds(25,20,150,20);
		first.setVisible(true);
		first.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				reference = MDRMSDDialog.FIRST_FRAME;
				referenceFileField.setEnabled(false);
				referenceFileField.setText("");
				referenceFileField.setEditable(false);
				referenceFileButton.setEnabled(false);
			}
		});

		lowest.setBounds(25,40,150,20);
		lowest.setVisible(true);
		lowest.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				reference = MDRMSDDialog.LOWEST_FRAME;
				referenceFileField.setEnabled(false);
				referenceFileField.setText("");
				referenceFileField.setEditable(false);
				referenceFileButton.setEnabled(false);
			}
		});
		
		another.setBounds(25,60,250,20);
		another.setVisible(true);
		another.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				reference = MDRMSDDialog.ANOTHER_STRUCTURE;
				referenceFileField.setEnabled(true);
				referenceFileField.setEditable(true);
				referenceFileButton.setEnabled(true);
			}
		});
		
		referenceFileField = new JTextField(50);
		referenceFileField.setBounds(20,90,160,20);
		referenceFileField.setVisible(true);
		referenceFileField.setEnabled(false);
		referenceFileField.setEditable(false);

		referenceFileButton = new JButton("Browse..");
		referenceFileButton.setFont(new Font("Dialog", Font.PLAIN, 12));
		referenceFileButton.setBounds(190,90,85,20);
		referenceFileButton.setVisible(true);
		referenceFileButton.setEnabled(false);
		referenceFileButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				//get the new directory from the user
				//browse the filesystem. select directories
				browsing = true;
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.addChoosableFileFilter(new FileNameFilter("mdcrd", "AMBER trajectory format"));
				chooser.addChoosableFileFilter(new FileNameFilter("rst", "AMBER restart file format"));
				chooser.addChoosableFileFilter(new FileNameFilter("inpcrd", "AMBER input coordinate format"));
				chooser.addChoosableFileFilter(new FileNameFilter("pdb", "PDB structure format"));
				
				chooser.setApproveButtonText("Select");
				chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				int result = chooser.showOpenDialog(parentFrame);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				parent.setLastUsedDirectory(filename.getParent());
				String newFile = filename.toString();
				referenceFileField.setText(newFile);
				browsing = false;
			}
		});
		
		
		group.add(first);
		group.add(lowest);
		group.add(another);
		
		referencePanel.add(first);
		referencePanel.add(lowest);
		referencePanel.add(another);
		referencePanel.add(referenceFileField);
		referencePanel.add(referenceFileButton);
		
		//done with the reference selection panel
		base.add(referencePanel);

		
		//next: subset used for rmsd calculation
		
		//check the current sets
		list = new Vector();
		list.add("Select set");

		if (existingSets.size() > 0){
			for (int i = 0; i < existingSets.size(); i++){
				list.add(existingSets.get(i));
			}
		}
		else{
			list.set(0, "No sets");
		}
		
		setPanel.setBounds(5,335,290,160);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Atoms used to compute RMSD ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		
		//define the radio buttons
		allAtoms.setLocation(20,20);
		allAtoms.setBounds(20,20,180,20);
		allAtoms.setVisible(true);
		allAtoms.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				extent = MDRMSDDialog.USE_ALL_ATOMS;
				currentSets.setEnabled(false);
			}
		});

		noSolventAtoms.setLocation(20,40);
		noSolventAtoms.setBounds(20,40,180,20);
		noSolventAtoms.setVisible(true);
		noSolventAtoms.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				extent = MDRMSDDialog.USE_ALL_EXCEPT_SOLVENT;
				currentSets.setEnabled(false);
			}
		});
		
		heavyAtoms.setLocation(20,60);
		heavyAtoms.setBounds(20,60,250,20);
		heavyAtoms.setVisible(true);
		heavyAtoms.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				extent = MDRMSDDialog.USE_ALL_HEAVY_ATOMS_EXCEPT_SOLVENT;
				currentSets.setEnabled(false);
			}
		});
		
		backboneAtoms.setLocation(20,80);
		backboneAtoms.setBounds(20,80,180,20);
		backboneAtoms.setVisible(true);
		backboneAtoms.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				extent = MDRMSDDialog.USE_BACKBONE_ATOMS;
				currentSets.setEnabled(false);
			}
		});
		
		caAtoms.setBounds(20,100,220,20);
		caAtoms.setVisible(true);
		caAtoms.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				extent = MDRMSDDialog.USE_CA_ATOMS;
				currentSets.setEnabled(false);
			}
		});
		
		setAtoms.setLocation(20,120);
		setAtoms.setBounds(20,120,120,20);
		setAtoms.setVisible(true);
		setAtoms.setEnabled(!ptraj);
		setAtoms.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				extent = MDRMSDDialog.USE_DEFINED_SET;
				currentSets.setEnabled(true);
			}
		});
		
		
		currentSets = new JComboBox(list);
		currentSets.setBounds(190, 120, 85, 20);
		currentSets.setVisible(true);
		currentSets.setEnabled(false);
		if (list.size() > 1){
			//create the populated combo box
			if (ptraj){
				setAtoms.setEnabled(false);
			}
			else{
				setAtoms.setEnabled(true);
			}
		}
		else{
			setAtoms.setEnabled(false);
		}
		
		group2.add(allAtoms);
		group2.add(noSolventAtoms);
		group2.add(heavyAtoms);
		group2.add(backboneAtoms);
		group2.add(caAtoms);
		group2.add(setAtoms);
		
		setPanel.add(allAtoms);
		setPanel.add(noSolventAtoms);
		setPanel.add(heavyAtoms);
		setPanel.add(backboneAtoms);
		setPanel.add(caAtoms);
		setPanel.add(setAtoms);
		setPanel.add(currentSets);

		
		base.add(setPanel);
		
		//buttons
		okButton.setBounds(65, 510, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setBounds(160, 510, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		nameField.requestFocus();

		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
/*			public void windowDeactivated(WindowEvent e){
				if (!browsing) toFront();
			}
*/		});
				
		setSize(315, 570);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		File file = null;
		String setname = null;
		if (reference == MDRMSDDialog.ANOTHER_STRUCTURE){
			file = new File(referenceFileField.getText());
		}
		
		if (extent == MDRMSDDialog.USE_DEFINED_SET){
			setname = (String)currentSets.getSelectedItem();
			if (setname.startsWith("Select set")){
				browsing = true;
				parent.displayErrorMessage("You must select a valid atom set");
				browsing = false;
				return;
			}
		}
		
		RMSData rms = new RMSData();
		rms.setName = setname;
		rms.extent = extent;
		rms.reference = reference;
		rms.referenceFile = file;
		rms.trajectories = trajectories;
		rms.internal = sourceLoaded.isSelected();
		rms.selection = selectionUse.isSelected();
		if (sourceLoaded.isSelected()){
			rms.parameterFile = mdpanel.getParameterFile();
		}
		else{
			rms.parameterFile = sourcePsfText.getText().trim();
		}
		
		setVisible(false);
		parent.setDisplayDialogStatus(false);
		try{		
			//depending on the availability of ptraj, use different methods to produce
			//currentRMSDFrames
			if (ptraj){
				//use ptraj to generate rmsd values
					mdpanel.ptrajComputeRMSD(rms);
			}
			else{
//				mdpanel.ptrajComputeRMSD(rms);
				mdpanel.computeRMSD(rms);
			}
			
		}
		catch (Exception ex){
			parent.displayExceptionMessage("Exception computing RMSD", ex);
		}
		
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
