package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import java.io.File;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.md.*;


public class MDVideoDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private MDPanel mdpanel;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private JPanel topPanel = new JPanel();
	private JPanel ratePanel = new JPanel();
	private JPanel outputPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private boolean browse = false;
	
	
	private JTextField startField = new JTextField(30);
	private JTextField endField = new JTextField(30);
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton allFrames = new JRadioButton("Entire trajectory", true);
	private JRadioButton partFrames = new JRadioButton("Range of frames", false);
	
	private JTextField rateField;

	private JTextField filename = new JTextField(50);
	private JButton fileBrowse = new JButton("Browse...");
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
		
	public MDVideoDialog(JFrame f, Manager p, MDPanel s){

		super(f, "Export MD trajectory as video", false);

		parentFrame = f;
		parent = p;
		mdpanel = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 290, 230);
		base.setLayout(null);
		
		topPanel.setBounds(5,5,280,110);
		topPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Frame set to export ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		topPanel.setBorder(border);
		
	
		//define the radio buttons
		allFrames.setBounds(25,25,150,20);
		allFrames.setVisible(true);
		allFrames.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				startField.setEnabled(false);
				endField.setEnabled(false);
				startField.setEditable(false);
				endField.setEditable(false);
			}
		});

		partFrames.setBounds(25,50,120,20);
		partFrames.setVisible(true);
		partFrames.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				startField.setEnabled(true);
				endField.setEnabled(true);
				startField.setEditable(true);
				endField.setEditable(true);
				startField.requestFocus();
			}
		});
		
		
		group.add(allFrames);
		group.add(partFrames);
		
		topPanel.add(allFrames);
		topPanel.add(partFrames);
		
		
		JLabel startLabel = new JLabel("From:");
		startLabel.setFont(new Font("Dialog", Font.PLAIN, 11));
		startLabel.setBounds(40,75,40,20);
		startLabel.setVisible(true);
		
		startField.setBounds(80,75,60,19);
		startField.setEditable(false);
		startField.setEnabled(false);
		startField.setVisible(true);
		
		JLabel endLabel = new JLabel("To:");
		endLabel.setFont(new Font("Dialog", Font.PLAIN, 11));
		endLabel.setBounds(155,75,30,20);
		endLabel.setVisible(true);
		
		endField.setBounds(190,75,50,19);
		endField.setEditable(false);
		endField.setEnabled(false);
		endField.setVisible(true);

		
		topPanel.add(startLabel);
		topPanel.add(startField);
		topPanel.add(endLabel);
		topPanel.add(endField);
		
		base.add(topPanel);
		
		
		ratePanel.setBounds(5,115,280,50);
		ratePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Desired frame rate ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		ratePanel.setBorder(border);
		
		
		//define the radio buttons
		JLabel rateLabel = new JLabel("Frame rate:");
		rateLabel.setBounds(40,20,100,20);
		
		rateField = new JTextField(20);
		rateField.setEnabled(true);
		rateField.setEditable(true);
		rateField.setBounds(130,20,50,19);
		rateField.setText("10");
		
		ratePanel.add(rateLabel);
		ratePanel.add(rateField);
		
		base.add(ratePanel);
		
		
		//file location
		outputPanel.setBounds(5,165,280,60);
		outputPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Output file (QuickTime movie)");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		outputPanel.setBorder(border);
		
		filename = new JTextField(100);
		filename.setBounds(25,25,150,20);
		filename.setEditable(true);
		filename.setEnabled(true);
		
		fileBrowse.setBounds(180,25,80,20);
		fileBrowse.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				//get the new directory from the user
				//browse the filesystem. select directories
				browse = true;
				JFileChooser chooser = new JFileChooser(parent.getLastUsedDirectory());
				chooser.setApproveButtonText("Browse");
				chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				int result = chooser.showSaveDialog(parent.getApplicationFrame());
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File file = chooser.getSelectedFile();
				String name = file.toString();
				filename.setText(name);
				browse = false;
			}
		});
		
		outputPanel.add(filename);
		outputPanel.add(fileBrowse);
		
		
		base.add(outputPanel);
		
		//buttons
		okButton.setBounds(50, 240, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setBounds(170, 240, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				if (browse) return;
				toFront();
			}
		});
				
		setSize(305, 300);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		parent.setDisplayDialogStatus(false);
		setVisible(false);
		
		if (filename.getText().length() == 0){
			parent.displayErrorMessage("Output file name must be specified");
			return;
		}
		
		if (!filename.getText().endsWith("mov")){
			parent.displayMessage("Output file does not have a .mov extension. It will be appended automatically.");
		}
		
		try{
			
			int start = -1;
			int end = -1;
			
			if (partFrames.isSelected()){
				start = Integer.parseInt(startField.getText());
				end = Integer.parseInt(endField.getText());
			}
			
			int rate = Integer.parseInt(rateField.getText());
			
			String out = filename.getText();
			if (!out.endsWith("mov")) out += ".mov";
			
			mdpanel.exportVideo(start, end, rate, out);
			
		}
		catch (Exception ex){
			parent.displayErrorMessage("All values must be integers");
		}
		finally{
			dispose();
		}
	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
