package edu.sdsc.sirius.dialogs;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import edu.sdsc.sirius.viewers.*;

public class MotifDialog extends JDialog {
//public class MotifDialog extends JDialog{

	private JFrame applicationFrame = null;
	private SequenceViewer parent = null;
	private int entryCount = 2;
	
	private JPanel base = new JPanel();
	private JPanel panel1 = new JPanel();//stores options for the currently loaded set
	private JPanel buttonPanel = new JPanel();
	
	private Border border1 = null;
	private TitledBorder border2 = null;
	private Border border = null;
	
	
	private JButton okButton = null;
	private JButton cancelButton = null;
	
	private JLabel message = null;
	
	private JTextField field1 = new JTextField(300);
	private JLabel label1 = new JLabel("Enter sequence motif in format GXXGXG");
	
	private int selectionFlag = DialogConstants.SELECTED_IGNORE;
	private int setFlag = DialogConstants.USE_LOADED;
	
	public MotifDialog(JFrame p, SequenceViewer viewer, int c){
	
		super(p, " Sequence motif search ", true);
		
		applicationFrame = p;
		parent = viewer;
		entryCount = c;
		
		//temporary fix for Macs
		String os = System.getProperty("os.name");

		base.setSize(new Dimension(300,310));
		base.setPreferredSize(new Dimension(300,130));
//		base.setLayout(null);

		panel1.setPreferredSize(new Dimension(290,105));
		panel1.setLocation(new Point(5,5));
		panel1.setVisible(true);
		panel1.setLayout(null);
		panel1.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
		
		//create the panels that hold the content of the first tab
		JPanel top1 = new JPanel();
		top1.setLocation(new Point(5,5));
		top1.setPreferredSize(new Dimension(280, 95));
		top1.setSize(new Dimension(280, 95));
		top1.setVisible(true);
		top1.setLayout(null);
		
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  Search string ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		top1.setBorder(border);
		
		
		//set up the string field
		field1.setLocation(new Point(15,55));
		field1.setPreferredSize(new Dimension(250, 20));
		field1.setSize(new Dimension(250, 20));
		field1.setVisible(true);

		label1.setLocation(new Point(15, 25));
		label1.setPreferredSize(new Dimension(250,20));
		label1.setSize(new Dimension(250, 20));
		label1.setVisible(true);
		
		top1.add(label1);
		top1.add(field1);

		
		panel1.add(top1);
		
		
		base.add(panel1);
		
		
		//set a keyboard listener
		field1.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					dispose();
				}
			}
		});


		
		//create buttons
		okButton = new JButton("Search");
		okButton.setPreferredSize(new Dimension(80,25));
		if (os.startsWith("Mac")){
			okButton.setLocation(new Point(40, 285));
		}
		else{
			okButton.setLocation(new Point(40, 300));
		}
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton = new JButton("Cancel");
		cancelButton.setPreferredSize(new Dimension(80,25));
		if (os.startsWith("Mac")){
			cancelButton.setLocation(new Point(90, 285));
		}
		else{
			cancelButton.setLocation(new Point(90, 300));
		}
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				dispose();
			}
		});
		
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);
		buttonPanel.setPreferredSize(new Dimension(300,40));
		buttonPanel.setVisible(true);
		buttonPanel.setLocation(new Point(0,130));
		
		base.add(buttonPanel);

		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				dispose();
			}
		});


		getContentPane().add(base);
		setSize(new Dimension(310, 185));
		
		if (parent == null){
			setLocationRelativeTo(null);
		}
		else{
			//set location
			Dimension d1 = getSize();
			
			Rectangle r = applicationFrame.getBounds();
			int parentWidth = r.width;
			int parentHeight = r.height;
			
			int x = Math.max((parentWidth - d1.width)/2, 0);
			int y = Math.max((parentHeight - d1.height)/2, 0);
		
			setBounds(x + r.x, y + r.y, d1.width, d1.height);
		}
		
		setResizable(false);
		
		field1.requestFocus();
		
		setVisible(true);
	}
	
	public void process(){

		setVisible(false);
		
		Thread runner = new Thread(){
			public void run(){
				parent.processMotifSearch(field1.getText().toUpperCase());
			}
		};
		runner.start();
		
		dispose();
	}
	
	
/*	public static void main(String[] args){
		MotifDialog d = new MotifDialog();
	}
*/	
}
		
