package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class MotionDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel setPanel = new JPanel();
	private JPanel bumpPanel = new JPanel();
		
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	public static int setFlag = DialogConstants.APPLY_SELECTION;
	
	private JCheckBox check = new JCheckBox("Track steric clashes");
	
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton selected = new JRadioButton("Currently selected", true);
	private JRadioButton structure = new JRadioButton("Structure", false);
	private JRadioButton chain = new JRadioButton("Chain", false);
	private JRadioButton residue = new JRadioButton("Residue", false);
	private JRadioButton atom = new JRadioButton("Atom", false);
	
	
	private JTextField field1 = new JTextField(30);
	private JLabel header1 = new JLabel();
	private JLabel label1 = new JLabel();
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JLabel or = new JLabel("or");
	private JComboBox combo = new JComboBox();
	private Vector structures = new Vector();

	private ViewEvent event;
	
	private Atom[] atoms = new Atom[2];
	
	private boolean trackBumps = false;
	
	public MotionDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Specify object to move", false);

		setFlag = DialogConstants.APPLY_SELECTION;
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(230, 290));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 230, 290);
		base.setLayout(null);
		
	
		
		setPanel.setPreferredSize(new Dimension(220, 230));
		setPanel.setLocation(new Point(5,5));
		setPanel.setBounds(5,5,220,230);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Structure object ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		//text field
		header1.setForeground(Color.black);
		header1.setFont(new Font("Dialog", Font.PLAIN, 12));
		header1.setText("Pick object to move");
		header1.setPreferredSize(new Dimension(180,20));
		header1.setBounds(20,60,180,20);
		header1.setLocation(new Point(20,60));
		header1.setVisible(true);
		
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 11));
		label1.setText("Enter name or click");
		label1.setPreferredSize(new Dimension(130,20));
		label1.setBounds(20,140,130,20);
		label1.setLocation(new Point(20,140));
		label1.setVisible(true);
		
		field1.setPreferredSize(new Dimension(180,20));
		field1.setBounds(20,165,180,20);
		field1.setLocation(new Point(20,165));
		field1.setEditable(false);
		field1.setEnabled(false);
		field1.setVisible(true);
		field1.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				if (selected.isSelected()){
					setFlag = DialogConstants.APPLY_RESIDUE;
					selected.setSelected(false);
					residue.setSelected(true);
					field1.setText("");
					field1.setEditable(true);
					field1.setEnabled(true);
					field1.requestFocus();
				}
			}
		});
		field1.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});
					
		or.setForeground(Color.black);
		or.setFont(new Font("Dialog", Font.PLAIN, 11));
		or.setPreferredSize(new Dimension(15,20));
		or.setBounds(20,195,15,20);
		or.setLocation(new Point(20,195));
		or.setVisible(true);
		
		//walk through the loaded structures
		structures.add("Select structure or set");
		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures.add(sv.getStructureName(st));
		}
		
		Vector setNames = sv.getAtomSetNames();
		for (int i = 0; i < setNames.size(); i++){
			structures.add(setNames.get(i));
		}


		combo = new JComboBox(structures);
		combo.setPreferredSize(new Dimension(165,20));
		combo.setBounds(35,195,165,20);
		combo.setLocation(new Point(35,195));
		combo.setVisible(true);
		if (structures.size() == 1) combo.setEnabled(false);
		combo.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo.getSelectedItem();
				field1.setText(choice);
				setFlag = DialogConstants.APPLY_STRUCTURE;		
				structure.setSelected(true);
			}
		});
		
		//define the radio buttons
		selected.setLocation(20,25);
		selected.setBounds(20,25,130,20);
		selected.setVisible(true);
		selected.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_SELECTION;
				field1.setText("");
				field1.setEditable(false);
				field1.setEnabled(false);
			}
		});
		
		structure.setLocation(20,80);
		structure.setBounds(20,80,130,20);
		structure.setVisible(true);
		structure.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_STRUCTURE;
				field1.setEditable(true);
				field1.setEnabled(true);
				field1.requestFocus();
			}
		});
		
		chain.setLocation(20,100);
		chain.setBounds(20,100,130,20);
		chain.setVisible(true);
		chain.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_CHAIN;
				field1.setEditable(true);
				field1.setEnabled(true);
				field1.requestFocus();
			}
		});
		
		residue.setLocation(20,120);
		residue.setBounds(20,120,130,20);
		residue.setVisible(true);
		residue.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_RESIDUE;
				field1.setEditable(true);
				field1.setEnabled(true);
				field1.requestFocus();
			}
		});
		
		atom.setLocation(20,140);
		atom.setBounds(20,140,130,20);
		atom.setVisible(true);
		atom.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_ATOM;
				field1.setEditable(true);
				field1.setEnabled(true);
				field1.requestFocus();
			}
		});

		
		//draw a line between the radio buttons
		JSeparator line1 = new JSeparator();
		line1.setLocation(10,55);
		line1.setBounds(10,55,200,5);
		line1.setVisible(true);
		
		setPanel.add(line1);
		setPanel.add(header1);
		
		group.add(selected);
		group.add(structure);
		group.add(chain);
		group.add(residue);
		group.add(atom);
		
		setPanel.add(selected);
		setPanel.add(structure);
		setPanel.add(chain);
		setPanel.add(residue);
		setPanel.add(atom);
		
		setPanel.add(label1);
		setPanel.add(field1);
		setPanel.add(or);
		setPanel.add(combo);
		
		
		
		//add panel to the base
		base.add(setPanel);
		
		//bump panel
		bumpPanel.setPreferredSize(new Dimension(220, 50));
		bumpPanel.setLocation(new Point(5,235));
		bumpPanel.setBounds(5,235,220,50);
		bumpPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Bump tracking ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		bumpPanel.setBorder(border);
		
		check.setBounds(20,20, 150, 20);
		check.setVisible(true);
		check.setSelected(false);
		check.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				trackBumps = check.isSelected();
			}
		});
		
		bumpPanel.add(check);

		base.add(bumpPanel);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(35, 300));
		okButton.setBounds(35, 300, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(135, 300));
		cancelButton.setBounds(135, 300, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(250, 360);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		try{
			
			//add error checking for selection bounds
			//eg., selection level is residue, but entered only structure name
			setVisible(false);
			
			//first, check the number of tags
			int count = 0;
			StringTokenizer tok = new StringTokenizer(field1.getText(), ":", false);
			while (tok.hasMoreTokens()){
				Object o = tok.nextToken();
				count++;
			}
			
			if (setFlag != 0){
				if (count < setFlag){
					setFlag = count;
				}
			}
	
			event = new ViewEvent(itself);
			event.setFlag = setFlag;
			
			event.structureComponent = this.structureComponent;
			
			event.componentId = field1.getText();
			event.flag = trackBumps;
	
			Thread runner = new Thread(){
				public void run(){
					parent.setDisplayDialogStatus(false);
					sv.processDisplayDialogEvent(event);
				}
			};
			runner.start();
		
		}
		catch (Exception e){
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception setting independent motion", e);
		}
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		field1.setText(data);
	}
	
}
