package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;


public class PdbDialog extends JDialog implements DisplayDialog{

	//implements DisplayDialog only to use open dialog tracking system
	//and avoid opening another copy of this dialog while this one is in background

	private JFrame parentFrame = null;
	private Manager parent = null;
	
	private Container contentPane = null;
	private JPanel base = new JPanel();
	private JPanel setPanel = new JPanel();
	
	private Border border1 = null;
	private TitledBorder border2 = null;
	private Border border = null;
	
	private JTextField pdbText = new JTextField();
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton radio1 = new JRadioButton("Select PDB id from the list");
	private JRadioButton radio2 = new JRadioButton("Enter PDB id in the text field");
		
	private JList pdbIdList = null;//holds PDB ids available for download
	private Vector idCodes = null;
	
	private JButton okButton = new JButton("Load");
	private JButton cancelButton = new JButton("Cancel");
	
	
	public PdbDialog(JFrame f, Manager p, Vector codes){
	
		super((JFrame)null, "Load structure from PDB", false);
	
		parentFrame = f;
		parent = p;
		idCodes = codes;
		
//		System.out.println("PDB dialog");
		
	
		parent.setDisplayDialogStatus(true);
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 240));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 240);
		base.setLayout(null);
		

		radio1.setPreferredSize(new Dimension(200,15));
		radio1.setLocation(new Point(7,5));
		radio1.setBounds(7,5,200,15);
		radio1.setSelected(true);
		radio1.setVisible(true);
		radio1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				pdbIdList.setEnabled(true);
				pdbText.setEnabled(false);
				pdbText.setText("");
			}
		});
		
		radio2.setPreferredSize(new Dimension(200,15));
		radio2.setLocation(new Point(7,178));
		radio2.setBounds(7,178,200,15);
		radio2.setVisible(true);
		radio2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				pdbIdList.setEnabled(false);
				pdbText.setEnabled(true);
				pdbText.setEditable(true);
				pdbText.requestFocus();
			}
		});
		
		group.add(radio1);
		group.add(radio2);
		
		pdbIdList = new JList(idCodes);
		pdbIdList.setVisible(true);
		pdbIdList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		JPanel listPanel = new JPanel();
		listPanel.setLayout(null);
		listPanel.setPreferredSize(new Dimension(200, 225));
		listPanel.setLocation(new Point(5,5));
		listPanel.setBounds(5,5,200,225);
		listPanel.setVisible(true);
		
		JScrollPane sp = new JScrollPane();
		sp.setPreferredSize(new Dimension(180, 135));
		sp.setBounds(10,25, 180, 135);
		sp.setLocation(new Point(10,25));
		sp.setVisible(true);
		sp.getViewport().add(pdbIdList);
		
		//text field
		pdbText.setPreferredSize(new Dimension(180,20));
		pdbText.setBounds(10,200,180,20);
		pdbText.setLocation(new Point(10,200));
		pdbText.setEditable(true);
		pdbText.setEnabled(true);
		pdbText.setVisible(true);
		pdbText.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				radio1.setSelected(false);
				radio2.setSelected(true);
				pdbText.setEditable(true);
				pdbText.setEnabled(true);
				pdbIdList.setEnabled(false);
			}
		});
		

		listPanel.add(sp);
		listPanel.add(radio1);
		listPanel.add(radio2);
		listPanel.add(pdbText);
//		base.add(label);
		base.add(listPanel);
		
		pdbIdList.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					dispose();
				}
			}
		});
		
		pdbText.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					dispose();
				}
			}
		});
		
		addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					dispose();
				}
			}
		});
		
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 255));
		okButton.setBounds(20, 255, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 255));
		cancelButton.setBounds(120, 255, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		setResizable(false);
		
		setSize(230, 315);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			setLocationRelativeTo(null);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);

//			int x = 5;
//			int y = 45;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}
		setVisible(true);
	}
	
	public void process(){
	
		setVisible(false);
		
		int index = pdbIdList.getSelectedIndex();
		String str = null;
		if (radio1.isSelected()){
			if (index >= 0){
				str = (String)idCodes.elementAt(index);
			}
			else{
				return;
			}
		}
		else{
			str = pdbText.getText().trim();
		}
		
		String id = str.toLowerCase( );
		
		if (id.equals("")){
			parent.doRcsbLoad(null);
			dispose();
			return;
		}
		if (!idCodes.contains(id)){
			parent.doRcsbLoad(null);
			dispose();
			return;
		}
		
		parent.setDisplayDialogStatus(false);
		parent.doRcsbLoad(id);
		dispose();
	
	
	}
	
	public void processPick(String data, StructureComponent s){
		return;
	}
	
}
