package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;

public class PdbLoadDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	
	private JLabel label = new JLabel();
	private JTextField field = new JTextField(30);
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
		
	public PdbLoadDialog(JFrame f, Manager p){
	
		super(f, "Load from PDB", false);
	
		parentFrame = f;
		parent = p;
		
//		System.out.println("Starting");
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 60));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 60);
		base.setLayout(null);
		
		
		//object field
		label.setForeground(Color.black);
		label.setFont(new Font("Dialog", Font.PLAIN, 12));
		label.setText("Enter PDB id");
		label.setPreferredSize(new Dimension(180,20));
		label.setBounds(10,5,180,20);
		label.setLocation(new Point(10,5));
		label.setVisible(true);
		
		field.setPreferredSize(new Dimension(180,20));
		field.setBounds(10,30,180,20);
		field.setLocation(new Point(10,30));
		field.setEditable(true);
		field.setEnabled(true);
		field.setVisible(true);
		
		field.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					parent.setDisplayDialogStatus(false);
					setVisible(false);
					dispose();
				}
			}
		});

		
		base.add(label);
		base.add(field);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 75));
		okButton.setBounds(20, 75, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 75));
		cancelButton.setBounds(120, 75, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(230, 135);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}



		setVisible(true);
		


	}
	
	private void process(){
		try{
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			parent.doRcsbLoad(field.getText());
		}
		catch (Exception e){
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception loading from PDB", e);

		}

		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		field.setText(data);
		//move focus along only if something has been picked
	}
	
}
