package edu.sdsc.sirius.dialogs;

import java.awt.*;

/**
 * This class serves as a temporary repository of all user selections in the preferences
 * dialog. If an OK button os clicked, the values are used to update StylesPreferences.
 * If cancel, they are discarded, leaving main preferences intact
 * @author Oleksandr V. Buzko
 *
 */
public class PreferencesCache {
	
	public String workingDirectory;
	public String ptrajDirectory;
	public float[] selectionColor;
	public short structureView = -1;
	public int renderBondOrder = -1;
	public short startupRenderingQuality = -1;
	
	public int fontSize = -1;
	
	public int toolbarPosition = -1;
	
	public Font sequenceViewerFont;
	
	public Color[] chainColors;
	public Color[] structureColors;
	
	public int structureColorSequence = -1;
	
	public Color cellBackgroundColor;
	
	public float[] backgroundColor;
	public float[] monitorColor;
	
	public float[] helixColor;
	public float[] strandColor;
	public float[] turnColor;
	public float[] coilColor;
	
	public int ribbonQuality = -1;
	
	public int ballRadiusOption = -1;
	
	public int selectionMode = -1;
	
	public int selectionLevel = -1;

	public int commonRibbonColoring = -1;
	
	public int commonSelection = -1;
	public int commonColoring = -1;
	
	public int showCellGrid = -1;
	public int showResidueTips = -1;
	public int showSs = -1;
	
	public int showBoundWaters = -1;
	
	public boolean[] bondOrderOptions = new boolean[1];
	
	public int undoEnabled = -1;
	public int undoDepth = -1;
	
	public int toolbar = -1;
	public int toolbarTips = -1;
	
	public int laf = -1;
	
	public int toolbarPDB = -1;
	public int toolbarUndo = -1;
	public int toolbarVisibility = -1;
	public int toolbarRendering = -1;
	public int toolbarColoring = -1;
	public int toolbarLabels = -1;
	public int toolbarCenter = -1;
	public int toolbarSeparate = -1;
	public int toolbarCommon = -1;
	public int toolbarDistance = -1;
	public int toolbarAngle = -1;
	public int toolbarDihedral = -1;
	public int toolbarFog = -1;

	public int fastGeometry = -1;
	
	public int zoomMiddle = -1;
	
}