//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.image.*;
import java.io.*;
import java.util.*;

import edu.sdsc.mbt.viewables.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.util.FileNameFilter;
import edu.sdsc.sirius.util.LimitedLengthDocument;

import java.util.prefs.*;

/**
 * Implementation of the Preferences dialog used to set all user-adjustable parameters.
 * @author Oleksandr V. Buzko
 */
public class PreferencesDialog extends JDialog implements ChangeListener {

	private JTabbedPane pane = new JTabbedPane();
	private JFrame parent = null;
	
	private StylesPreferences preferences;
		
	private JPanel base = new JPanel();
	private JPanel panel1 = new JPanel();//stores general options
	private JPanel panel2 = new JPanel();//structure options
	private JPanel panel3 = new JPanel();//sequence options
	private JPanel panel4 = new JPanel();//misc options
	private JPanel panel5 = new JPanel();//toolbar options
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private ButtonGroup buttons = new ButtonGroup();
	private JRadioButton button1;
	private JRadioButton button2;
	private JRadioButton button3;
	
	private JDialog thisDialog;
	private Manager callable;
	
	private ButtonGroup alignmentButtons = new ButtonGroup();
	private JRadioButton alignmentButton1;
	private JRadioButton alignmentButton2;
	
	private ButtonGroup svButtons = new ButtonGroup();
	private JRadioButton svButton1;
	private JRadioButton svButton2;
	private JRadioButton svButton3;
	private JRadioButton svButton4;
	private JRadioButton svButton5;
	
	private ButtonGroup mmButtons = new ButtonGroup();
	private JRadioButton mmButton1;
	private JRadioButton mmButton2;

	private ButtonGroup rrButtons = new ButtonGroup();
	private JRadioButton rrButton1;
	private JRadioButton rrButton2;

	private ButtonGroup sqButtons = new ButtonGroup();
	private JRadioButton sqButton1;
	private JRadioButton sqButton2;
	
	private JCheckBox bond1;
	private JCheckBox water1;
	
	private boolean bondOrderReset = false;
	
	private String inputRAM;
	private JTextField memoryField = new JTextField(20);
	
	private JPanel buttonPanel = new JPanel();
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	private JButton defaultButton = new JButton("Default");
	private JButton importButton = new JButton("Import...");
	private JButton exportButton = new JButton("Export...");
	
	private JButton bkgButton;
	private JButton monitorButton;
	private JButton elementButton;
	
	//buttons that set colors of SS elements
	private JButton helixButton;
	private JButton sheetButton;
	private JButton turnButton;
	private JButton coilButton;
	private JSlider ribbonSlider;
	
	private ButtonGroup ballGroup = new ButtonGroup();//set size of ball in ball&stick
	private JRadioButton ball1;
	private JRadioButton ball2;
	
	private JTextField stickRadiusField;
	private JTextField ballRadiusField;
	
	private JSlider fastSlider;
	private JSlider bestSlider;
	
	private ButtonGroup levelGroup = new ButtonGroup();
	private JRadioButton atomButton;
	private JRadioButton residueButton;
	
	private ButtonGroup zoomGroup = new ButtonGroup();
	private JRadioButton zoomMiddle;
	private JRadioButton zoomAlt;

	private JTextField dirField;
	
	private JLabel selectionLabel;
	private JButton selectionButton;
	
	private JSlider bondlineSlider;
	private JSlider mouseSlider;
	
	private int sampleStringLength = 10;
	private JLabel fontLabel;
	
	private JLabel cellBackgroundLabel;
	private JButton cellBackgroundButton;
	
	private PreferencesCache cache = new PreferencesCache();
	
	private JCheckBox commonSelection;
	private JCheckBox commonColoring;
	
	private JCheckBox showTips;
	private JCheckBox showGrid;
	private JCheckBox showSs;
	
	private JComboBox undoDepth;
	
	private JCheckBox toolbar;
	private JCheckBox toolbarTips;
	
	private JTextField ptrajPathField;
	
	private int i = 0;//counter to be accessible for inner classes
	
	
	private boolean imported = false;//if preferences get imported, ok doesn't rewrite preferences

	
	public PreferencesDialog(JFrame p, Manager pp){
	
		super(p, "Preferences", true);
		
		parent = p;
		callable = pp;
		
		thisDialog = this;
		
		String os = System.getProperty("os.name");
		
		//get the current preferences in case the user clicks cancel and
		//they will need to be restored
		preferences = callable.getPreferences();
//		preferences.readPreferences();
		
		if (!os.startsWith("W")){
			base.setSize(new Dimension(520,375));
			base.setPreferredSize(new Dimension(520,375));
		}
		else{
			base.setSize(new Dimension(500,360));
			base.setPreferredSize(new Dimension(500,360));
		}
		base.setLayout(new BorderLayout());
		pane.setBorder(new EmptyBorder(5,5,5,5));

		//first panel: general
		panel1.setPreferredSize(new Dimension(490,335));
		panel1.setLocation(new Point(5,5));
		panel1.setVisible(true);
		panel1.setLayout(null);
		
		//working directory
		JPanel g1 = new JPanel();
		g1.setPreferredSize(new Dimension(480, 60));
		g1.setBounds(5,0,480,60);
		g1.setLocation(new Point(5,0));
		g1.setVisible(true);
		g1.setLayout(null);
		
		g1.setBorder(createTitledBorder("Initial working directory"));
		
		dirField = new JTextField(50);
		dirField.setPreferredSize(new Dimension(360,20));
		dirField.setLocation(new Point(15,25));
		dirField.setBounds(15,25,360,20);
		dirField.setVisible(true);
		
		//get full path of the currently selected directory
		File dir = new File(StylesPreferences.workingDirectory);
		String path = dir.getAbsolutePath();
		dirField.setText(path);
		
		JButton dirButton = new JButton("Change..");
		dirButton.setFont(new Font("Dialog", Font.PLAIN, 12));
		dirButton.setPreferredSize(new Dimension(85,20));
		dirButton.setLocation(new Point(380, 25));
		dirButton.setBounds(380,25,85,20);
		dirButton.setVisible(true);
		dirButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				//get the new directory from the user
				//browse the filesystem. select directories
				JFileChooser chooser = new JFileChooser(StylesPreferences.workingDirectory);
				chooser.setApproveButtonText("Select");
//				chooser.setApproveButtonToolTipText(null);
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				int result = chooser.showOpenDialog(parent);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				String newDirectory = filename.toString();
				dirField.setText(newDirectory);
				cache.workingDirectory = newDirectory;
//				System.out.println("Set new directory to " + StructureStyles.workingDirectory);
			}
		});
		
		g1.add(dirField);
		g1.add(dirButton);
		
		panel1.add(g1);
		
		//selection color
		JPanel g2 = new JPanel();
		g2.setPreferredSize(new Dimension(240, 55));
		g2.setBounds(245,60,240,55);
		g2.setLocation(new Point(245,60));
		g2.setVisible(true);
		g2.setLayout(null);
		
		g2.setBorder(createTitledBorder("Default selection color"));
		
		selectionLabel = new JLabel("Current color");
		selectionLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		selectionLabel.setLocation(new Point(15,20));
		selectionLabel.setPreferredSize(new Dimension(130,20));
		selectionLabel.setBounds(15,20,130,20);
		selectionLabel.setVisible(true);
		
		//color control buttons
		selectionButton = new JButton(createImageIcon(StylesPreferences.selectionColor));
		selectionButton.setPreferredSize(new Dimension(70,20));
		selectionButton.setLocation(new Point(150, 20));
		selectionButton.setBounds(150,20,70,20);
		selectionButton.setVisible(true);
		selectionButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Color current = new Color(StylesPreferences.selectionColor[0], StylesPreferences.selectionColor[1], StylesPreferences.selectionColor[2]);
				Color newColor = JColorChooser.showDialog(null, "Choose selection color", current);
				if (newColor != null){
					//proceed with new color
					float[] color = newColor.getRGBColorComponents(null);
					cache.selectionColor = color;
					selectionButton.setIcon(createImageIcon(cache.selectionColor));
				}
			}
		});
		
		g2.add(selectionLabel);
		g2.add(selectionButton);
		panel1.add(g2);
		
		
		
		//startup quality options
		JPanel g3 = new JPanel();
		g3.setBounds(5,178,240,67);
		g3.setVisible(true);
		g3.setLayout(null);
		
		g3.setBorder(createTitledBorder("Startup rendering quality"));
		
		
		//add radio buttons
		sqButton1 = new JRadioButton("Fast rendering");
		sqButton1.setFont(new Font("Dialog", Font.PLAIN, 11));
		sqButton1.setPreferredSize(new Dimension(210,20));
		sqButton1.setLocation(new Point(20,20));
		sqButton1.setBounds(20,20,210,20);
		sqButton1.setVisible(true);
		sqButton1.setSelected(StylesPreferences.startupRenderingQuality == StylesPreferences.RENDERING_FAST);
		sqButton1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.startupRenderingQuality = StylesPreferences.RENDERING_FAST;
			}
		});
		
		sqButton2 = new JRadioButton("Best rendering");
		sqButton2.setFont(new Font("Dialog", Font.PLAIN, 11));
		sqButton2.setPreferredSize(new Dimension(200,20));
		sqButton2.setLocation(new Point(20,40));
		sqButton2.setBounds(20,40,200,20);
		sqButton2.setVisible(true);
		sqButton2.setSelected(StylesPreferences.startupRenderingQuality == StylesPreferences.RENDERING_BEST);
		sqButton2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.startupRenderingQuality = StylesPreferences.RENDERING_BEST;
			}
		});
		
		sqButtons.add(sqButton1);
		sqButtons.add(sqButton2);
		
		g3.add(sqButton1);
		g3.add(sqButton2);
		panel1.add(g3);
		
		

		
		//startup structure appearance
		JPanel g4 = new JPanel();
		g4.setBounds(5,60,240,120);
		g4.setVisible(true);
		g4.setLayout(null);
		
		g4.setBorder(createTitledBorder("Default structure display"));
		
		
		//add radio buttons
		svButton1 = new JRadioButton("Bond lines");
		svButton1.setFont(new Font("Dialog", Font.PLAIN, 11));
		svButton1.setBounds(20,18,200,18);
		svButton1.setVisible(true);
		svButton1.setSelected(StylesPreferences.structureView == StylesPreferences.RENDERING_LINES);
		svButton1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.structureView = StylesPreferences.RENDERING_LINES;
			}
		});
		
		svButton2 = new JRadioButton("Stick representation");
		svButton2.setFont(new Font("Dialog", Font.PLAIN, 11));
		svButton2.setBounds(20,36,200,18);
		svButton2.setVisible(true);
		svButton2.setSelected(StylesPreferences.structureView == StylesPreferences.RENDERING_STICK);
		svButton2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
//				System.out.println("setting cache to stick");
				cache.structureView = StylesPreferences.RENDERING_STICK;
			}
		});
		
		svButton3 = new JRadioButton("Ball and stick");
		svButton3.setFont(new Font("Dialog", Font.PLAIN, 11));
		svButton3.setBounds(20,54,200,18);
		svButton3.setVisible(true);
		svButton3.setSelected(StylesPreferences.structureView == StylesPreferences.RENDERING_BALL_STICK);
		svButton3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.structureView = StylesPreferences.RENDERING_BALL_STICK;
			}
		});
		
		svButton4 = new JRadioButton("Space-filling");
		svButton4.setFont(new Font("Dialog", Font.PLAIN, 11));
		svButton4.setBounds(20,72,200,18);
		svButton4.setVisible(true);
		svButton4.setSelected(StylesPreferences.structureView == StylesPreferences.RENDERING_CPK);
		svButton4.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.structureView = StylesPreferences.RENDERING_CPK;
			}
		});
		
		svButton5 = new JRadioButton("Ribbon only (for proteins)");
		svButton5.setFont(new Font("Dialog", Font.PLAIN, 11));
		svButton5.setBounds(20,90,200,18);
		svButton5.setVisible(true);
		svButton5.setEnabled(true);
		svButton5.setSelected(StylesPreferences.structureView == StylesPreferences.RENDERING_RIBBON);
		svButton5.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.structureView = StylesPreferences.RENDERING_RIBBON;
			}
		});

		svButtons.add(svButton1);
		svButtons.add(svButton2);
		svButtons.add(svButton3);
		svButtons.add(svButton4);
		svButtons.add(svButton5);
		
		g4.add(svButton1);
		g4.add(svButton2);
		g4.add(svButton3);
		g4.add(svButton4);
		g4.add(svButton5);
		panel1.add(g4);
		
		
		//create the render speed items
		JPanel p1 = new JPanel();
		p1.setBounds(245,178,240,67);
		p1.setVisible(true);
		p1.setLayout(null);
		
		p1.setBorder(createTitledBorder("Thickness of bond lines"));
		
		JLabel fLabel1 = new JLabel("Thin");
		fLabel1.setFont(new Font("Dialog", Font.PLAIN, 12));
		fLabel1.setLocation(new Point(15,25));
		fLabel1.setPreferredSize(new Dimension(130,20));
		fLabel1.setBounds(15,25,130,20);
		fLabel1.setVisible(true);
		
		JLabel fLabel2 = new JLabel("Thick");
		fLabel2.setFont(new Font("Dialog", Font.PLAIN, 12));
		fLabel2.setLocation(new Point(200,25));
		fLabel2.setPreferredSize(new Dimension(130,20));
		fLabel2.setBounds(200,25,130,20);
		fLabel2.setVisible(true);

		bondlineSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, (int)StylesPreferences.lineWidth);
		bondlineSlider.setPreferredSize(new Dimension(150,25));
		bondlineSlider.setLocation(new Point(45,30));
		bondlineSlider.setBounds(45,30,150,25);
		bondlineSlider.setVisible(true);
		bondlineSlider.setPaintTicks(true);
		bondlineSlider.setSnapToTicks(true);
		bondlineSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		bondlineSlider.setMajorTickSpacing(1);
		
		
		p1.add(fLabel1);
		p1.add(fLabel2);
		p1.add(bondlineSlider);
		
		panel4.add(p1);
		
		//zoom mode option for two-button mice
		JPanel t12 = new JPanel();
		t12.setBounds(245,115,240,65);
		t12.setVisible(true);
		t12.setLayout(null);
		
		t12.setBorder(createTitledBorder("Structure zoom mode"));
		
		zoomMiddle = new JRadioButton("Middle mouse button");
		zoomMiddle.setBounds(20, 17, 150, 20);
		zoomMiddle.setSelected(StylesPreferences.zoomMiddle);
		zoomMiddle.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.zoomMiddle = 0;
			}
		});
		
		zoomAlt = new JRadioButton("Alt + left mouse button");
		zoomAlt.setBounds(20, 35, 150, 20);
		zoomAlt.setSelected(!StylesPreferences.zoomMiddle);
		zoomAlt.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.zoomMiddle = 1;
			}
		});
		
		zoomGroup.add(zoomMiddle);
		zoomGroup.add(zoomAlt);
		
		t12.add(zoomMiddle);
		t12.add(zoomAlt);
		
		panel1.add(t12);


		
/*		
		//bond orders in b-n-s
		JPanel g5 = new JPanel();
		g5.setBounds(245,178,240,67);
		g5.setVisible(true);
		g5.setLayout(null);
		
		g5.setBorder(createTitledBorder("Bond orders in rendered styles"));
		
		
		//add radio buttons
		mmButton1 = new JRadioButton("Show bond orders in ball and stick");
		mmButton1.setFont(new Font("Dialog", Font.PLAIN, 11));
		mmButton1.setBounds(20,20,210,20);
		mmButton1.setSelected(StylesPreferences.renderBondOrder);
		mmButton1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.renderBondOrder = 0;
			}
		});
		
		mmButton2 = new JRadioButton("Keep uniform rendered bonds");
		mmButton2.setFont(new Font("Dialog", Font.PLAIN, 11));
		mmButton2.setBounds(20,40,200,20);
		mmButton2.setSelected(!StylesPreferences.renderBondOrder);
		mmButton2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.renderBondOrder = 1;
			}
		});
		
		mmButtons.add(mmButton1);
		mmButtons.add(mmButton2);
		
		g5.add(mmButton1);
		g5.add(mmButton2);
*/		panel1.add(p1);
		
		//startup magnification mode
		JPanel g7 = new JPanel();
		g7.setBounds(245,245,240,65);
		g7.setVisible(true);
		g7.setLayout(null);
		
		g7.setBorder(createTitledBorder("Protein ribbon coloring"));
		
		
		//add radio buttons
		rrButton1 = new JRadioButton("Common coloring with structure");
		rrButton1.setFont(new Font("Dialog", Font.PLAIN, 11));
		rrButton1.setPreferredSize(new Dimension(210,20));
		rrButton1.setLocation(new Point(20,20));
		rrButton1.setBounds(20,20,210,20);
		rrButton1.setVisible(true);
		rrButton1.setSelected(StylesPreferences.commonRibbonColoring);
		rrButton1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.commonRibbonColoring = 0;
			}
		});
		
		rrButton2 = new JRadioButton("Separately from the structure");
		rrButton2.setFont(new Font("Dialog", Font.PLAIN, 11));
		rrButton2.setPreferredSize(new Dimension(200,20));
		rrButton2.setLocation(new Point(20,40));
		rrButton2.setBounds(20,40,200,20);
		rrButton2.setVisible(true);
		rrButton2.setSelected(!StylesPreferences.commonRibbonColoring);
		rrButton2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.commonRibbonColoring = 1;
			}
		});
		
		rrButtons.add(rrButton1);
		rrButtons.add(rrButton2);
		
		g7.add(rrButton1);
		g7.add(rrButton2);
		panel1.add(g7);
		
		
		//bond order options
		JPanel g6 = new JPanel();
		g6.setBounds(5,245,240,65);
		g6.setVisible(true);
		g6.setLayout(null);
		
		g6.setBorder(createTitledBorder("Miscellaneous options"));
		
		
		//add radio buttons
		bond1 = new JCheckBox("Show bond orders if available");
		bond1.setFont(new Font("Dialog", Font.PLAIN, 11));
		bond1.setPreferredSize(new Dimension(210,20));
		bond1.setLocation(new Point(20,18));
		bond1.setBounds(20,18,210,20);
		bond1.setVisible(true);
		bond1.setSelected(StylesPreferences.showBondOrder);
		bond1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.bondOrderOptions[0] = bond1.isSelected();
//				bond2.setEnabled(bond1.isSelected());
				bondOrderReset = true;
			}
		});
		
		water1 = new JCheckBox("Show waters in loaded proteins");
		water1.setFont(new Font("Dialog", Font.PLAIN, 11));
		water1.setPreferredSize(new Dimension(200,20));
		water1.setLocation(new Point(20,38));
		water1.setBounds(20,38,200,20);
		water1.setVisible(true);
		water1.setSelected(StylesPreferences.showBoundWaters);
		water1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (water1.isSelected()){
					cache.showBoundWaters = 0;
				}
				else{
					cache.showBoundWaters = 1;
				}
			}
		});
		
		g6.add(bond1);
		g6.add(water1);
		panel1.add(g6);
		

		
		

		pane.addTab("Startup options", panel1);
		
		
		
		//structure panel
		panel2.setPreferredSize(new Dimension(490,335));
		panel2.setLocation(new Point(5,5));
//		panel2.setBounds
		panel2.setVisible(true);
		panel2.setLayout(null);
		
		
		//create the Structure items
		JPanel s1 = new JPanel();
		s1.setPreferredSize(new Dimension(250, 140));
		s1.setBounds(5,0,250,140);
		s1.setLocation(new Point(5,0));
		s1.setVisible(true);
		s1.setLayout(null);
		
		s1.setBorder(createTitledBorder("Display settings"));
		
		//add the elements to the s1 panel
		JLabel bkgLabel = new JLabel("Background color");
		bkgLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		bkgLabel.setLocation(new Point(15,30));
		bkgLabel.setPreferredSize(new Dimension(130,20));
		bkgLabel.setBounds(15,30,130,20);
		bkgLabel.setVisible(true);
		
		JLabel monitorLabel = new JLabel("Distance monitor color");
		monitorLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		monitorLabel.setLocation(new Point(15,65));
		monitorLabel.setPreferredSize(new Dimension(130,20));
		monitorLabel.setBounds(15,65,130,20);
		monitorLabel.setVisible(true);
		
		JLabel elementLabel = new JLabel("Element colors");
		elementLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		elementLabel.setLocation(new Point(15,100));
		elementLabel.setPreferredSize(new Dimension(130,20));
		elementLabel.setBounds(15,100,130,20);
		elementLabel.setVisible(true);
		
		//color control buttons
		bkgButton = new JButton(createImageIcon(StylesPreferences.backgroundColor));
		bkgButton.setPreferredSize(new Dimension(70,20));
		bkgButton.setLocation(new Point(150, 30));
		bkgButton.setBounds(150,30,70,20);
		bkgButton.setVisible(true);
		bkgButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Color current = new Color(StylesPreferences.backgroundColor[0], StylesPreferences.backgroundColor[1], StylesPreferences.backgroundColor[2]);
				Color newColor = JColorChooser.showDialog(null, "Choose background color", current);
				if (newColor != null){
					//proceed with new color
					float[] color = newColor.getRGBColorComponents(null);
					cache.backgroundColor = color;
					bkgButton.setIcon(createImageIcon(StylesPreferences.backgroundColor));
				}
			}
		});
		
		monitorButton = new JButton(createImageIcon(StylesPreferences.monitorColor));
		monitorButton.setPreferredSize(new Dimension(70,20));
		monitorButton.setLocation(new Point(150, 65));
		monitorButton.setBounds(150,65,70,20);
		monitorButton.setVisible(true);
		monitorButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Color current = new Color(StylesPreferences.monitorColor[0], StylesPreferences.monitorColor[1], StylesPreferences.monitorColor[2]);
				Color newColor = JColorChooser.showDialog(null, "Choose monitor color", current);
				if (newColor != null){
					//proceed with new color
					float[] color = newColor.getRGBColorComponents(null);
					cache.monitorColor = color;
					monitorButton.setIcon(createImageIcon(StylesPreferences.monitorColor));
				}
			}
		});
		
		elementButton = new JButton("Edit...");
		elementButton.setPreferredSize(new Dimension(70,20));
		elementButton.setLocation(new Point(150, 100));
		elementButton.setBounds(150,100,70,20);
		elementButton.setVisible(true);
		elementButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Thread runner = new Thread(){
					public void run(){
						ElementStylesDialog d = new ElementStylesDialog(null, callable);
					}
				};
				runner.start();
				
			}
		});
		
		
		s1.add(bkgLabel);
		s1.add(bkgButton);
		s1.add(monitorLabel);
		s1.add(monitorButton);
		s1.add(elementLabel);
		s1.add(elementButton);
		
		panel2.add(s1);
		
		//create the panel for SS element colors
		JPanel s2 = new JPanel();
		s2.setPreferredSize(new Dimension(250, 165));
		s2.setBounds(5,140,250,165);
		s2.setLocation(new Point(5,140));
		s2.setVisible(true);
		s2.setLayout(null);
		
		s2.setBorder(createTitledBorder("Protein secondary structure"));
		
		JLabel helixLabel = new JLabel("Helix color");
		helixLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		helixLabel.setLocation(new Point(15,25));
		helixLabel.setPreferredSize(new Dimension(130,20));
		helixLabel.setBounds(15,25,130,20);
		helixLabel.setVisible(true);
		
		JLabel sheetLabel = new JLabel("Strand color");
		sheetLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		sheetLabel.setLocation(new Point(15,50));
		sheetLabel.setPreferredSize(new Dimension(130,20));
		sheetLabel.setBounds(15,50,130,20);
		sheetLabel.setVisible(true);
		
		JLabel turnLabel = new JLabel("Turn color");
		turnLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		turnLabel.setLocation(new Point(15,75));
		turnLabel.setPreferredSize(new Dimension(130,20));
		turnLabel.setBounds(15,75,130,20);
		turnLabel.setVisible(true);
		
		JLabel coilLabel = new JLabel("Coil color");
		coilLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		coilLabel.setLocation(new Point(15,100));
		coilLabel.setPreferredSize(new Dimension(130,20));
		coilLabel.setBounds(15,100,130,20);
		coilLabel.setVisible(true);
		
		//set color of helix
		helixButton = new JButton(createImageIcon(StylesPreferences.HELIX_COLOR));
		helixButton.setPreferredSize(new Dimension(70,20));
		helixButton.setLocation(new Point(150, 20));
		helixButton.setBounds(150,20,70,20);
		helixButton.setVisible(true);
		helixButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Color current = new Color(StylesPreferences.HELIX_COLOR[0], StylesPreferences.HELIX_COLOR[1], StylesPreferences.HELIX_COLOR[2]);
				Color newColor = JColorChooser.showDialog(null, "Choose helix color", current);
//				System.out.println("newColor = " + newColor);
				if (newColor != null){
					//proceed with new color
					cache.helixColor = new float[]{ (float)newColor.getRed()/255.0f, (float)newColor.getGreen()/255.0f, (float)newColor.getBlue()/255.0f};
					helixButton.setIcon(createImageIcon(newColor));
				}
			}
		});
		
		sheetButton = new JButton(createImageIcon(StylesPreferences.STRAND_COLOR));
		sheetButton.setPreferredSize(new Dimension(70,20));
		sheetButton.setLocation(new Point(150, 45));
		sheetButton.setBounds(150,45,70,20);
		sheetButton.setVisible(true);
		sheetButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Color current = new Color( StylesPreferences.STRAND_COLOR[0], StylesPreferences.STRAND_COLOR[1], StylesPreferences.STRAND_COLOR[2]);
				Color newColor = JColorChooser.showDialog(null, "Choose color of beta-strand", current);
				if (newColor != null){
					//proceed with new color
					cache.strandColor = new float[]{ (float)newColor.getRed()/255.0f, (float)newColor.getGreen()/255.0f, (float)newColor.getBlue()/255.0f};;
					sheetButton.setIcon(createImageIcon(newColor));
				}
			}
		});
		

		turnButton = new JButton(createImageIcon(StylesPreferences.TURN_COLOR));
		turnButton.setPreferredSize(new Dimension(70,20));
		turnButton.setLocation(new Point(150, 70));
		turnButton.setBounds(150,70,70,20);
		turnButton.setVisible(true);
		turnButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Color current = new Color(StylesPreferences.TURN_COLOR[0], StylesPreferences.TURN_COLOR[1], StylesPreferences.TURN_COLOR[2]);
				Color newColor = JColorChooser.showDialog(null, "Choose color of turns", current);
				if (newColor != null){
					//proceed with new color
					cache.turnColor = new float[]{ (float)newColor.getRed()/255.0f, (float)newColor.getGreen()/255.0f, (float)newColor.getBlue()/255.0f};;
					turnButton.setIcon(createImageIcon(newColor));
				}
			}
		});
		
		coilButton = new JButton(createImageIcon(StylesPreferences.COIL_COLOR));
		coilButton.setPreferredSize(new Dimension(70,20));
		coilButton.setLocation(new Point(150, 95));
		coilButton.setBounds(150,95,70,20);
		coilButton.setVisible(true);
		coilButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Color current = new Color(StylesPreferences.COIL_COLOR[0], StylesPreferences.COIL_COLOR[1], StylesPreferences.COIL_COLOR[2]);
				Color newColor = JColorChooser.showDialog(null, "Choose color of random coil", current);
				if (newColor != null){
					//proceed with new color
					cache.coilColor = new float[]{ (float)newColor.getRed()/255.0f, (float)newColor.getGreen()/255.0f, (float)newColor.getBlue()/255.0f};;
					coilButton.setIcon(createImageIcon(newColor));
				}
			}
		});
		
		
		
		JLabel ribbonLabel = new JLabel("Quality");
		ribbonLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		ribbonLabel.setLocation(new Point(15,125));
		ribbonLabel.setPreferredSize(new Dimension(60,20));
		ribbonLabel.setBounds(15,125,60,20);
		ribbonLabel.setVisible(true);
		
		ribbonSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, (int)StylesPreferences.ribbonQuality);
		ribbonSlider.setPreferredSize(new Dimension(150,25));
		ribbonSlider.setLocation(new Point(80,125));
		ribbonSlider.setBounds(80,125,150,25);
		ribbonSlider.setVisible(true);
		ribbonSlider.setPaintTicks(true);
		ribbonSlider.setSnapToTicks(true);
		ribbonSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		ribbonSlider.setMajorTickSpacing(1);
		

		
		s2.add(helixLabel);
		s2.add(helixButton);
		s2.add(sheetLabel);
		s2.add(sheetButton);
		s2.add(turnLabel);
		s2.add(turnButton);
		s2.add(coilLabel);
		s2.add(coilButton);
		s2.add(ribbonLabel);
		s2.add(ribbonSlider);
		
		panel2.add(s2);
		
		
		//rendering settings panel
		JPanel s3 = new JPanel();
		s3.setPreferredSize(new Dimension(230, 60));
		s3.setBounds(255,0,230,60);
		s3.setLocation(new Point(255,0));
		s3.setVisible(true);
		s3.setLayout(null);
		
		s3.setBorder(createTitledBorder("Rendered stick size"));
		
		//rendering options of sticks
		JLabel stickRadiusLabel = new JLabel("Stick radius");
		stickRadiusLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		stickRadiusLabel.setLocation(new Point(15,25));
		stickRadiusLabel.setPreferredSize(new Dimension(130,20));
		stickRadiusLabel.setBounds(15,25,130,20);
		stickRadiusLabel.setVisible(true);
		
		stickRadiusField = new JTextField(new LimitedLengthDocument(5), (new Double(StylesPreferences.stickSize)).toString(), 5);
		stickRadiusField.setPreferredSize(new Dimension(40,20));
		stickRadiusField.setLocation(new Point(170,25));
		stickRadiusField.setBounds(170,25,40,20);
		stickRadiusField.setVisible(true);
		
		s3.add(stickRadiusLabel);
		s3.add(stickRadiusField);
		panel2.add(s3);
		
		//ball panel
		JPanel s4 = new JPanel();
		s4.setPreferredSize(new Dimension(230, 80));
		s4.setBounds(255,60,230,80);
		s4.setLocation(new Point(255,60));
		s4.setVisible(true);
		s4.setLayout(null);
		
		s4.setBorder(createTitledBorder("Rendered ball size"));
		
		//radio buttons
		ball1 = new JRadioButton("Use atomic radii");
		ball1.setFont(new Font("Dialog", Font.PLAIN, 12));
		ball1.setPreferredSize(new Dimension(120,20));
		ball1.setLocation(new Point(15,25));
		ball1.setBounds(15,25,120,20);
		ball1.setVisible(true);
		ball1.setSelected(StylesPreferences.ballRadiusOption == StylesPreferences.ATOMIC_RADIUS);
		ball1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				cache.ballRadiusOption = StylesPreferences.ATOMIC_RADIUS;
				ballRadiusField.setEnabled(false);
			}
		});
		
		ball2 = new JRadioButton("Set uniform radius");
		ball2.setFont(new Font("Dialog", Font.PLAIN, 12));
		ball2.setPreferredSize(new Dimension(130,20));
		ball2.setLocation(new Point(15,50));
		ball2.setBounds(15,50,130,20);
		ball2.setVisible(true);
		ball2.setSelected(StylesPreferences.ballRadiusOption == StylesPreferences.UNIFORM_RADIUS);
		ball2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				cache.ballRadiusOption = StylesPreferences.UNIFORM_RADIUS;
				ballRadiusField.setEnabled(true);
				ballRadiusField.requestFocus();
			}
		});
		
		ballRadiusField = new JTextField(new LimitedLengthDocument(5), (new Double(StylesPreferences.ballRadius)).toString(), 5);
		ballRadiusField.setPreferredSize(new Dimension(40,20));
		ballRadiusField.setLocation(new Point(170,50));
		ballRadiusField.setBounds(170,50,40,20);
		ballRadiusField.setVisible(true);
		ballRadiusField.setEnabled(false);
		ballRadiusField.setEditable(true);
		if (StylesPreferences.ballRadiusOption == StylesPreferences.UNIFORM_RADIUS){
			ballRadiusField.setText((new Double(StylesPreferences.ballRadius)).toString());
		}
		ballRadiusField.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				StylesPreferences.ballRadiusOption = StylesPreferences.UNIFORM_RADIUS;
				ballRadiusField.setEnabled(true);
				ballRadiusField.setEditable(true);
				ball1.setSelected(false);
				ball2.setSelected(true);
				ballRadiusField.requestFocus();
			}
		});
		
		
		s4.add(ball1);
		s4.add(ball2);
		s4.add(ballRadiusField);
		
		ballGroup.add(ball1);
		ballGroup.add(ball2);
		
		panel2.add(s4);
		
		
		//add quality control panel
		JPanel s5 = new JPanel();
		s5.setPreferredSize(new Dimension(230, 105));
		s5.setBounds(255,140,230,105);
		s5.setLocation(new Point(255,140));
		s5.setVisible(true);
		s5.setLayout(null);
		
		s5.setBorder(createTitledBorder("Structure rendering quality"));
		JLabel fastLabel = new JLabel("Fast:");
		fastLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		fastLabel.setLocation(new Point(15,25));
		fastLabel.setPreferredSize(new Dimension(60,20));
		fastLabel.setBounds(15,25,60,20);
		fastLabel.setVisible(true);
		
		fastSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, (int)StylesPreferences.renderingFastQuality);
		fastSlider.setPreferredSize(new Dimension(150,25));
		fastSlider.setLocation(new Point(70,30));
		fastSlider.setBounds(70,30,150,25);
		fastSlider.setVisible(true);
		fastSlider.setPaintTicks(true);
		fastSlider.setSnapToTicks(true);
		fastSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		fastSlider.setMajorTickSpacing(1);
		
		
		JLabel bestLabel = new JLabel("Best:");
		bestLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		bestLabel.setLocation(new Point(15,65));
		bestLabel.setPreferredSize(new Dimension(80,20));
		bestLabel.setBounds(15,65,80,20);
		bestLabel.setVisible(true);
		
		bestSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, (int)StylesPreferences.renderingBestQuality);
		bestSlider.setPreferredSize(new Dimension(150,25));
		bestSlider.setLocation(new Point(70,65));
		bestSlider.setBounds(70,65,150,25);
		bestSlider.setVisible(true);
		bestSlider.setPaintTicks(true);
		bestSlider.setSnapToTicks(true);
		bestSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		bestSlider.setMajorTickSpacing(1);
		
		s5.add(fastLabel);
		s5.add(fastSlider);
		s5.add(bestLabel);
		s5.add(bestSlider);
		
		panel2.add(s5);
		
		//panel that sets selection level
		JPanel s6 = new JPanel();
		s6.setPreferredSize(new Dimension(230, 60));
		s6.setBounds(255,245,230,60);
		s6.setLocation(new Point(255,245));
		s6.setVisible(true);
		s6.setLayout(null);
		s6.setBorder(createTitledBorder("Default selection mode"));
		
		//radio buttons
		//radio buttons
		atomButton = new JRadioButton("Atom");
		atomButton.setFont(new Font("Dialog", Font.PLAIN, 12));
		atomButton.setPreferredSize(new Dimension(80,20));
		atomButton.setLocation(new Point(25,25));
		atomButton.setBounds(25,25,80,20);
		atomButton.setVisible(true);
		atomButton.setSelected(StylesPreferences.selectionLevel == StylesPreferences.SELECTION_ATOM);
		atomButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				cache.selectionLevel = StylesPreferences.SELECTION_ATOM;
			}
		});
		
		residueButton = new JRadioButton("Residue");
		residueButton.setFont(new Font("Dialog", Font.PLAIN, 12));
		residueButton.setPreferredSize(new Dimension(80,20));
		residueButton.setLocation(new Point(130,25));
		residueButton.setBounds(130,25,80,20);
		residueButton.setVisible(true);
		residueButton.setSelected(StylesPreferences.selectionLevel == StylesPreferences.SELECTION_RESIDUE);
		residueButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				cache.selectionLevel = StylesPreferences.SELECTION_RESIDUE;
			}
		});
		
		levelGroup.add(atomButton);
		levelGroup.add(residueButton);
		
		s6.add(atomButton);
		s6.add(residueButton);
		
		panel2.add(s6);
	
		
		pane.addTab("Structure Viewer", panel2);
		
		
		
		//sequence viewer options panel
		panel3.setPreferredSize(new Dimension(490,335));
		panel3.setLocation(new Point(5,5));
		panel3.setVisible(true);
		panel3.setLayout(null);
		
		//default font panel
		final JPanel v1 = new JPanel();
		v1.setPreferredSize(new Dimension(250, 130));
		v1.setBounds(5,0,250,130);
		v1.setLocation(new Point(5,0));
		v1.setVisible(true);
		v1.setLayout(null);
		
		v1.setBorder(createTitledBorder("Default font"));
		
		//create a display area that shows a sample text rendered in the current font
		ImageIcon sample = createTextSample(StylesPreferences.sequenceViewerFont);
		fontLabel = new JLabel(sample);
		fontLabel.setPreferredSize(new Dimension(200,50));
		
		//calculate location of the sample
		int offset = (v1.getPreferredSize().width)/2 - sampleStringLength/2;
		fontLabel.setLocation(new Point(offset,10));
		fontLabel.setBounds(offset,10,200,50);
		fontLabel.setVisible(true);
		
		JButton fontButton = new JButton("Change...");
		fontButton.setPreferredSize(new Dimension(100, 30));
		fontButton.setLocation(new Point(85, 80));
		fontButton.setBounds(80,70,100,30);
		fontButton.setVisible(true);
		fontButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Thread runner = new Thread(){
					public void run(){
						JFontChooser jfc = new JFontChooser(StylesPreferences.sequenceViewerFont);
						int i = jfc.showDialog(null, "Select sequence font");
						Font f = null;
						if (i == JFontChooser.ACCEPT_OPTION){
							f = jfc.acceptSelection();
						}
						else{
							return;
						}
//						System.out.println("new font = " + f);
						cache.sequenceViewerFont = f;
						fontLabel.setIcon(createTextSample(cache.sequenceViewerFont));
						int offset = (v1.getPreferredSize().width)/2 - sampleStringLength/2;
						fontLabel.setLocation(new Point(offset,10));
						fontLabel.setBounds(offset,10,200,50);
					}
				};
				runner.start();
				
			}
		});
		
		
		
		v1.add(fontLabel);
		v1.add(fontButton);
		
		panel3.add(v1);
		
		
		
		//create the panel for chain colors
		JPanel v2 = new JPanel();
		v2.setPreferredSize(new Dimension(250, 175));
		v2.setBounds(5,130,250,175);
		v2.setLocation(new Point(5,130));
		v2.setVisible(true);
		v2.setLayout(null);
		
		v2.setBorder(createTitledBorder("Residue coloring by chain"));
		
		//draw the residue and background labels
		
		
		for (i = 1; i <= StylesPreferences.chainColors.length; i++){
			final JLabel chainLabel = new JLabel("Chain " + i);
			chainLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
			chainLabel.setLocation(new Point(35,28*i - 5));
			chainLabel.setPreferredSize(new Dimension(100,20));
			chainLabel.setBounds(35,28*i - 5,100,20);
			chainLabel.setVisible(true);
			v2.add(chainLabel);
			
			//add the residue button
			final JButton resButton = new JButton(createImageIcon(StylesPreferences.chainColors[i-1]));
			resButton.setPreferredSize(new Dimension(70,20));
			resButton.setLocation(new Point(120, 28*i - 5));
			resButton.setBounds(120,28*i - 5,70,20);
			resButton.setVisible(true);
			final int index = i;
			resButton.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent ae){
					Color current = StylesPreferences.chainColors[index-1];
					Color newColor = JColorChooser.showDialog(null, "Choose color", current);
					if (newColor != null){
						//proceed with new color
						if (cache.chainColors == null){
							cache.chainColors = new Color[StylesPreferences.chainColors.length];
							for (int j = 0; j < StylesPreferences.chainColors.length; j++){
								cache.chainColors[j] = StylesPreferences.chainColors[j];
							}
						}
						cache.chainColors[index-1] = newColor;
						resButton.setIcon(createImageIcon(cache.chainColors[index-1]));
					}
				}
			});
			v2.add(resButton);
			
		}
		
		
		panel3.add(v2);
		
		//labeling options
		JPanel v3 = new JPanel();
		v3.setPreferredSize(new Dimension(230, 130));
		v3.setBounds(255,0,230,130);
		v3.setLocation(new Point(255,0));
		v3.setVisible(true);
		v3.setLayout(null);
		
		v3.setBorder(createTitledBorder("Sequence display options"));
		
		//add checkboxes
		showSs = new JCheckBox("Show secondary structure");
		showSs.setFont(new Font("Dialog", Font.PLAIN, 12));
		showSs.setBounds(15,25,200,20);
		showSs.setSelected(StylesPreferences.showSs);
		showSs.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				if (showSs.isSelected()){
					cache.showSs = 0;
				}
				else{
					cache.showSs = 1;
				}
			}
		});

		showTips = new JCheckBox("Show residue tips");
		showTips.setFont(new Font("Dialog", Font.PLAIN, 12));
		showTips.setPreferredSize(new Dimension(150,20));
		showTips.setLocation(new Point(15, 50));
		showTips.setBounds(15,50,150,20);
		showTips.setVisible(true);
		showTips.setSelected(StylesPreferences.showResidueTips);
		showTips.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				if (showTips.isSelected()){
					cache.showResidueTips = 0;
				}
				else{
					cache.showResidueTips = 1;
				}
			}
		});
		
		showGrid = new JCheckBox("Show gridlines");
		showGrid.setFont(new Font("Dialog", Font.PLAIN, 12));
		showGrid.setPreferredSize(new Dimension(150,20));
		showGrid.setLocation(new Point(15, 75));
		showGrid.setBounds(15,75,150,20);
		showGrid.setVisible(true);
		showGrid.setSelected(StylesPreferences.showCellGrid);
		showGrid.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				if (showGrid.isSelected()){
					cache.showCellGrid = 0;
				}
				else{
					cache.showCellGrid = 1;
				}
			}
		});
				
		
//		v3.add(showSs);
		v3.add(showTips);
		v3.add(showGrid);
		
		panel3.add(v3);
		

		//cell background color
		//selection color
		JPanel v4 = new JPanel();
		v4.setPreferredSize(new Dimension(230, 60));
		v4.setBounds(255,130,230,60);
		v4.setLocation(new Point(255,130));
		v4.setVisible(true);
		v4.setLayout(null);
		
		v4.setBorder(createTitledBorder("Cell background color"));
		
		cellBackgroundLabel = new JLabel("Default color");
		cellBackgroundLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		cellBackgroundLabel.setLocation(new Point(15,25));
		cellBackgroundLabel.setPreferredSize(new Dimension(130,20));
		cellBackgroundLabel.setBounds(15,25,130,20);
		cellBackgroundLabel.setVisible(true);
		
		//color control buttons
		cellBackgroundButton = new JButton(createImageIcon(StylesPreferences.cellBackgroundColor));
		cellBackgroundButton.setPreferredSize(new Dimension(70,20));
		cellBackgroundButton.setLocation(new Point(150, 25));
		cellBackgroundButton.setBounds(150,25,70,20);
		cellBackgroundButton.setVisible(true);
		cellBackgroundButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Color current = StylesPreferences.cellBackgroundColor;
				Color newColor = JColorChooser.showDialog(null, "Choose background color", current);
				if (newColor != null){
					//proceed with new color
					float[] color = newColor.getRGBColorComponents(null);
					cache.cellBackgroundColor = newColor;
					callable.updateAppearance();
				}
				cellBackgroundButton.setIcon(createImageIcon(cache.cellBackgroundColor));
			}
		});
		
		v4.add(cellBackgroundLabel);
		v4.add(cellBackgroundButton);
		panel3.add(v4);
		
		
		JPanel v5 = new JPanel();
		v5.setPreferredSize(new Dimension(230, 115));
		v5.setBounds(255,190,230,115);
		v5.setLocation(new Point(255,190));
		v5.setVisible(true);
		v5.setLayout(null);
		
		v5.setBorder(createTitledBorder("Cross-viewer events"));

		commonSelection = new JCheckBox("Common selection");
		commonSelection.setFont(new Font("Dialog", Font.PLAIN, 12));
		commonSelection.setPreferredSize(new Dimension(150,20));
		commonSelection.setLocation(new Point(15, 25));
		commonSelection.setBounds(15,25,150,20);
		commonSelection.setVisible(true);
		commonSelection.setSelected(StylesPreferences.commonSelection);
		commonSelection.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				if (commonSelection.isSelected()){
					cache.commonSelection = 0;
				}
				else{
					cache.commonSelection = 1;
				}
			}
		});
		
		commonColoring = new JCheckBox("Common coloring");
		commonColoring.setFont(new Font("Dialog", Font.PLAIN, 12));
		commonColoring.setPreferredSize(new Dimension(150,20));
		commonColoring.setLocation(new Point(15, 55));
		commonColoring.setBounds(15,55,150,20);
		commonColoring.setVisible(true);
		commonColoring.setSelected(StylesPreferences.commonColoring);
		commonColoring.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				if (commonColoring.isSelected()){
					cache.commonColoring = 0;
				}
				else{
					cache.commonColoring = 1;
				}
			}
		});
		
		v5.add(commonSelection);
		v5.add(commonColoring);
		
		panel3.add(v5);
		
		
		
		pane.addTab("Sequence Viewer", panel3);

		
		
		
		//misc panel
		panel4.setPreferredSize(new Dimension(490,335));
		panel4.setLocation(new Point(5,5));
//		panel2.setBounds
		panel4.setVisible(true);
		panel4.setLayout(null);
		

		/**
		 * TODO the memory amount
		 */
		
		//create the render speed items
		JPanel p6 = new JPanel();
		p6.setBounds(5,0,250,80);
		p6.setVisible(true);
		p6.setLayout(null);
		
		p6.setBorder(createTitledBorder("Maximum memory available to Sirius"));
		
		
		Preferences root = Preferences.userRoot();
		final Preferences node = root.node("/edu/sdsc/sirius/config");
		String config = node.get("installDir", null) + File.separator + ".vmoptions";
		
		String record = null;
		try{
			BufferedReader reader = new BufferedReader(new FileReader(config));
			Vector buffer = new Vector();
			do {
				record = reader.readLine();
		    	if( record != null ) {
		    		break;
		    	}
			} while( record != null );
			reader.close();
			
		}
		catch (Exception ex){
//			callable.displayExceptionMessage("Exception reading RAM", ex);
			record = "-mx128m - exception";
		}
		
		
		//parse out the amount
		String value = record.substring(3, record.length()-1);
		
		inputRAM = value;

		JLabel label6 = new JLabel("Enter top amount of RAM");
		label6.setBounds(20,25,150,20);
		
		memoryField.setBounds(170,25,40,20);
		memoryField.setText(value);
		
		JLabel label7 = new JLabel("MB");
		label7.setBounds(220,25,150,20);
		
		JLabel label8 = new JLabel("Use no more than 70% of total RAM");
		label8.setBounds(20,50,220,20);
		
		
		p6.add(label6);
		p6.add(memoryField);
		p6.add(label7);
		p6.add(label8);
		
		panel4.add(p6);

		
		//create the mouse speed items
		JPanel p2 = new JPanel();
		p2.setBounds(5,80,250,75);
		p2.setLayout(null);
		
		p2.setBorder(createTitledBorder("Mouse responsiveness"));
		
		JLabel mLabel1 = new JLabel("Slow");
		mLabel1.setFont(new Font("Dialog", Font.PLAIN, 12));
		mLabel1.setLocation(new Point(15,25));
		mLabel1.setPreferredSize(new Dimension(130,20));
		mLabel1.setBounds(15,25,130,20);
		mLabel1.setVisible(true);
		
		JLabel mLabel2 = new JLabel("Fast");
		mLabel2.setFont(new Font("Dialog", Font.PLAIN, 12));
		mLabel2.setLocation(new Point(200,25));
		mLabel2.setPreferredSize(new Dimension(130,20));
		mLabel2.setBounds(200,25,130,20);
		mLabel2.setVisible(true);

		mouseSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, StylesPreferences.mouseFactor);
		mouseSlider.setPreferredSize(new Dimension(150,25));
		mouseSlider.setLocation(new Point(45,30));
		mouseSlider.setBounds(45,30,150,25);
		mouseSlider.setVisible(true);
		mouseSlider.setPaintTicks(true);
		mouseSlider.setSnapToTicks(true);
		mouseSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		mouseSlider.setMajorTickSpacing(1);
		
		
		p2.add(mLabel1);
		p2.add(mLabel2);
		p2.add(mouseSlider);
		
		panel4.add(p2);
		
		
		//font sizes
		JPanel t2 = new JPanel();
		t2.setBounds(5,155,250,65);
		t2.setVisible(true);
		t2.setLayout(null);
		
		t2.setBorder(createTitledBorder("Menu and label font size"));
		
		JLabel menuFontLabel = new JLabel("Font size");
		menuFontLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		menuFontLabel.setLocation(new Point(10,25));
		menuFontLabel.setPreferredSize(new Dimension(130,20));
		menuFontLabel.setBounds(10,25,130,20);
		menuFontLabel.setVisible(true);
		
		JSlider fontSlider = new JSlider(JSlider.HORIZONTAL, 0, 4, StylesPreferences.menuFontSize + 2);
		fontSlider.setPreferredSize(new Dimension(150,25));
		fontSlider.setLocation(new Point(70,25));
		fontSlider.setBounds(70,25,150,25);
		fontSlider.setVisible(true);
		fontSlider.setPaintTicks(true);
		fontSlider.setSnapToTicks(true);
		fontSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		fontSlider.setMajorTickSpacing(1);
		fontSlider.addChangeListener(this);
		
		t2.add(menuFontLabel);
		t2.add(fontSlider);
		panel4.add(t2);
		
		
		JPanel p3 = new JPanel();
		p3.setPreferredSize(new Dimension(230, 80));
		p3.setBounds(255,0,230,80);
		p3.setLocation(new Point(255,0));
		p3.setVisible(true);
		p3.setLayout(null);
		
		p3.setBorder(createTitledBorder("Molecular dynamics setup"));

		JLabel ptrajLabel = new JLabel("ptraj installation directory:");
		ptrajLabel.setBounds(15,20,150,20);
		
		ptrajPathField = new JTextField(50);
		ptrajPathField.setPreferredSize(new Dimension(130,20));
		ptrajPathField.setLocation(new Point(15,40));
		ptrajPathField.setBounds(15,40,130,20);
		ptrajPathField.setText(StylesPreferences.ptrajDirectory);

		JButton ptrajButton = new JButton("Select");
		ptrajButton.setFont(new Font("Dialog", Font.PLAIN, 12));
		ptrajButton.setPreferredSize(new Dimension(70,20));
		ptrajButton.setLocation(new Point(150, 40));
		ptrajButton.setBounds(150,40,70,20);
		ptrajButton.setVisible(true);
		ptrajButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				//get the new directory from the user
				//browse the filesystem. select directories
				JFileChooser chooser = new JFileChooser(StylesPreferences.ptrajDirectory);
				chooser.setApproveButtonText("Select");
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				int result = chooser.showOpenDialog(parent);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				String newDirectory = filename.toString();
				
				//make sure that the new directory doesn't have a trailing file separator
				String nd = null;
				if (newDirectory.endsWith(File.separator)){
					nd = newDirectory.substring(0, newDirectory.length()-1);
				}
				else{
					nd = newDirectory;
				}
				ptrajPathField.setText(newDirectory);
				cache.workingDirectory = newDirectory;
			}
		});
		
		p3.add(ptrajLabel);
		p3.add(ptrajPathField);
		p3.add(ptrajButton);
		
		
		panel4.add(p3);
		
		
		JPanel p4 = new JPanel();
		p4.setBounds(255,80,230,230);
		p4.setVisible(true);
		p4.setLayout(null);
		
		p4.setBorder(createTitledBorder("Color of loaded structures"));
		
		
		JRadioButton structureColorDefault = new JRadioButton("Color structures by element");
		structureColorDefault.setBounds(20,20,200,20);
		structureColorDefault.setSelected(!StylesPreferences.structureColorSequence);
		structureColorDefault.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.structureColorSequence = 1;
			}
		});
		
		JRadioButton structureColorSequence = new JRadioButton("Color loaded structure in order:");
		structureColorSequence.setBounds(20,40,200,20);
		structureColorSequence.setSelected(StylesPreferences.structureColorSequence);
		structureColorSequence.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.structureColorSequence = 0;
			}
		});
		
		ButtonGroup group = new ButtonGroup();
		group.add(structureColorDefault);
		group.add(structureColorSequence);
		
		p4.add(structureColorDefault);
		p4.add(structureColorSequence);
		
		for (i = 1; i <= StylesPreferences.structureColors.length; i++){
			final JLabel structureLabel = new JLabel("Structure " + i);
			structureLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
			structureLabel.setBounds(35,42+23*i - 5,100,20);
			structureLabel.setVisible(true);
			p4.add(structureLabel);
			
			//add the residue button
			final JButton resButton = new JButton(createImageIcon(StylesPreferences.structureColors[i-1]));
			resButton.setBounds(120,42+23*i - 5,70,20);
			resButton.setVisible(true);
			final int index = i;
			resButton.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent ae){
					Color current = StylesPreferences.structureColors[index-1];
					Color newColor = JColorChooser.showDialog(null, "Choose color", current);
					if (newColor != null){
						//proceed with new color
						if (cache.structureColors == null){
							cache.structureColors = new Color[StylesPreferences.structureColors.length];
							for (int j = 0; j < StylesPreferences.structureColors.length; j++){
								cache.structureColors[j] = StylesPreferences.structureColors[j];
							}
						}
						cache.structureColors[index-1] = newColor;
						resButton.setIcon(createImageIcon(cache.structureColors[index-1]));
					}
				}
			});
			p4.add(resButton);
			
		}

		
		
		panel4.add(p4);
		
		//if it's a Mac, add a panel to switch between native and Sirius look and feel modes
		boolean activate = false;
//		if (os.startsWith("Mac")){
			activate = true;
//		}
		
		//create the mouse speed items
		JPanel p5 = new JPanel();
		p5.setBounds(5,220,250,90);
		p5.setVisible(true);
		p5.setLayout(null);
		
		p5.setBorder(createTitledBorder("Application look and feel"));
		
		ButtonGroup lg = new ButtonGroup();
		JRadioButton laf1 = new JRadioButton("Sirius look and feel");
		laf1.setEnabled(activate);
		laf1.setSelected(StylesPreferences.LAF == StylesPreferences.SMOOTH_LAF);
		laf1.setBounds(20,25,150,20);
		laf1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent r){
				cache.laf = StylesPreferences.SMOOTH_LAF;
			}
		});
		
		JRadioButton laf2 = new JRadioButton("Native look and feel");
		laf2.setSelected(StylesPreferences.LAF == StylesPreferences.NATIVE_LAF);
		laf2.setEnabled(activate);
		laf2.setBounds(20,50,150,20);
		laf2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent r){
				cache.laf = StylesPreferences.NATIVE_LAF;
			}
		});
		
		lg.add(laf1);
		lg.add(laf2);
		
		p5.add(laf1);
		p5.add(laf2);
		
		panel4.add(p5);
			
		
		//toolbar panel
		panel5.setPreferredSize(new Dimension(490,335));
		panel5.setLocation(new Point(5,5));
//		panel2.setBounds
		panel5.setVisible(true);
		panel5.setLayout(null);

		
		JPanel t1 = new JPanel();
		t1.setBounds(5,0,230,85);
		t1.setVisible(true);
		t1.setLayout(null);
		
		t1.setBorder(createTitledBorder("Toolbar display"));

		toolbar = new JCheckBox("Enable toolbar display");
		toolbar.setFont(new Font("Dialog", Font.PLAIN, 11));
		toolbar.setBounds(20,25,150,20);
		toolbar.setVisible(true);
		toolbar.setSelected(StylesPreferences.displayToolbar);
		toolbar.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (toolbar.isSelected()){
					cache.toolbar = 0;
					toolbarTips.setEnabled(true);
				}
				else{
					cache.toolbar = 1;
					toolbarTips.setEnabled(false);
				}
			}
		});
		
		t1.add(toolbar);
		
		toolbarTips = new JCheckBox("Show toolbar tips");
		toolbarTips.setFont(new Font("Dialog", Font.PLAIN, 11));
		toolbarTips.setBounds(20,50,140,20);
		toolbarTips.setVisible(true);
		if (StylesPreferences.displayToolbar){
			toolbarTips.setEnabled(true);
		}
		else{
			toolbarTips.setEnabled(false);
		}
		toolbarTips.setSelected(StylesPreferences.showToolbarTips);
		toolbarTips.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (toolbarTips.isSelected()){
					cache.toolbarTips = 0;
				}
				else{
					cache.toolbarTips = 1;
				}
			}
		});
		
		t1.add(toolbarTips);

		
		panel5.add(t1);
		
		
		//toolbar position
		JPanel tt2 = new JPanel();
		tt2.setBounds(235,0,250,85);
		tt2.setVisible(true);
		tt2.setLayout(null);
		
		tt2.setBorder(createTitledBorder("Toolbar position"));
		
		ButtonGroup g = new ButtonGroup();
		
		JRadioButton left = new JRadioButton("Dock on left");
		left.setBounds(20,25,140,20);
		left.setSelected(StylesPreferences.toolbarPosition == StylesPreferences.POSITION_LEFT);
		left.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.toolbarPosition = StylesPreferences.POSITION_LEFT;
			}
		});
		
		JRadioButton right = new JRadioButton("Dock on top");
		right.setBounds(20,50,140,20);
		right.setSelected(StylesPreferences.toolbarPosition == StylesPreferences.POSITION_TOP);
		right.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cache.toolbarPosition = StylesPreferences.POSITION_TOP;
			}
		});
		
		g.add(left);
		g.add(right);
		
		
		tt2.add(left);
		tt2.add(right);
		
		panel5.add(tt2);
		
		
		//buttons to display
		JPanel tt3 = new JPanel();
		tt3.setBounds(5,85,480,150);
		tt3.setVisible(true);
		tt3.setLayout(null);
		
		tt3.setBorder(createTitledBorder("Displayed toolbar buttons"));
		
		final JCheckBox box1 = new JCheckBox("Load from PDB");
		box1.setBounds(20,20,120,20);
		box1.setSelected(StylesPreferences.toolbarPDB);
		box1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box1.isSelected()){
					cache.toolbarPDB = 0;
				}
				else{
					cache.toolbarPDB = 1;
				}
			}
		});
		
		final JCheckBox box2 = new JCheckBox("Undo last action");
		box2.setBounds(20,45,120,20);
		box2.setSelected(StylesPreferences.toolbarUndo);
		box2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box2.isSelected()){
					cache.toolbarUndo = 0;
				}
				else{
					cache.toolbarUndo = 1;
				}
			}
		});
		
		final JCheckBox box3 = new JCheckBox("Structure visibility");
		box3.setBounds(20,70,120,20);
		box3.setSelected(StylesPreferences.toolbarVisibility);
		box3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box3.isSelected()){
					cache.toolbarVisibility = 0;
				}
				else{
					cache.toolbarVisibility = 1;
				}
			}
		});
		
		final JCheckBox box4 = new JCheckBox("Structure rendering");
		box4.setBounds(20,95,130,20);
		box4.setSelected(StylesPreferences.toolbarRendering);
		box4.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box4.isSelected()){
					cache.toolbarRendering = 0;
				}
				else{
					cache.toolbarRendering = 1;
				}
			}
		});
		
		final JCheckBox box5 = new JCheckBox("Structure color");
		box5.setBounds(20,120,120,20);
		box5.setSelected(StylesPreferences.toolbarColoring);
		box5.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box5.isSelected()){
					cache.toolbarColoring = 0;
				}
				else{
					cache.toolbarColoring = 1;
				}
			}
		});
		
		final JCheckBox box6 = new JCheckBox("Atom labels");
		box6.setBounds(170,20,120,20);
		box6.setSelected(StylesPreferences.toolbarLabels);
		box6.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box6.isSelected()){
					cache.toolbarLabels = 0;
				}
				else{
					cache.toolbarLabels = 1;
				}
			}
		});

		final JCheckBox box7 = new JCheckBox("Center at atom");
		box7.setBounds(170,45,120,20);
		box7.setSelected(StylesPreferences.toolbarCenter);
		box7.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box7.isSelected()){
					cache.toolbarCenter = 0;
				}
				else{
					cache.toolbarCenter = 1;
				}
			}
		});
		
		final JCheckBox box8 = new JCheckBox("Separate motion");
		box8.setBounds(170,70,120,20);
		box8.setSelected(StylesPreferences.toolbarSeparate);
		box8.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box8.isSelected()){
					cache.toolbarSeparate = 0;
				}
				else{
					cache.toolbarSeparate = 1;
				}
			}
		});
		
		final JCheckBox box9 = new JCheckBox("Common motion");
		box9.setBounds(170,95,120,20);
		box9.setSelected(StylesPreferences.toolbarCommon);
		box9.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box9.isSelected()){
					cache.toolbarCommon = 0;
				}
				else{
					cache.toolbarCommon = 1;
				}
			}
		});
		
		final JCheckBox box10 = new JCheckBox("Measure distance");
		box10.setBounds(170,120,120,20);
		box10.setSelected(StylesPreferences.toolbarDistance);
		box10.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box10.isSelected()){
					cache.toolbarDistance = 0;
				}
				else{
					cache.toolbarDistance = 1;
				}
			}
		});
		
		final JCheckBox box11 = new JCheckBox("Measure bond angle");
		box11.setBounds(320,20,140,20);
		box11.setSelected(StylesPreferences.toolbarAngle);
		box11.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box11.isSelected()){
					cache.toolbarAngle = 0;
				}
				else{
					cache.toolbarAngle = 1;
				}
			}
		});
		
		final JCheckBox box12 = new JCheckBox("Measure dihedrals");
		box12.setBounds(320,45,140,20);
		box12.setSelected(StylesPreferences.toolbarDihedral);
		box12.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box12.isSelected()){
					cache.toolbarDihedral = 0;
				}
				else{
					cache.toolbarDihedral = 1;
				}
			}
		});
		
		final JCheckBox box13 = new JCheckBox("Set depth of view");
		box13.setBounds(320,70,120,20);
		box13.setSelected(StylesPreferences.toolbarFog);
		box13.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent t){
				if (box13.isSelected()){
					cache.toolbarFog = 0;
				}
				else{
					cache.toolbarFog = 1;
				}
			}
		});
		
		
		
		
		
		tt3.add(box1);
		tt3.add(box2);
		tt3.add(box3);
		tt3.add(box4);
		tt3.add(box5);
		tt3.add(box6);
		tt3.add(box7);
		tt3.add(box8);
		tt3.add(box9);
		tt3.add(box10);
		tt3.add(box11);
		tt3.add(box12);
		tt3.add(box13);
		
		panel5.add(tt3);
		
		//panel for fast measurements
		JPanel tt4 = new JPanel();
		tt4.setBounds(5,235,480,75);
		tt4.setVisible(true);
		tt4.setLayout(null);
		
		tt4.setBorder(createTitledBorder("Quick geometry measurements with toolbar buttons"));
		
		final JCheckBox f1 = new JCheckBox("Compute distances/angles for selected atoms without displaying a dialog");
		f1.setBounds(20,25,450,20);
		f1.setSelected(StylesPreferences.fastGeometry);
		f1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (f1.isSelected()){
					cache.fastGeometry = 0;
				}
				else{
					cache.fastGeometry = 1;
				}
			}
		});
		
		tt4.add(f1);
	
		panel5.add(tt4);
		
		pane.addTab("Toolbar options", panel5);
		
		
		pane.addTab("Other", panel4);
		

		//take care of the buttons
		//panel that holds buttons
		JPanel lowerPanel = new JPanel();
		lowerPanel.setLayout(new BorderLayout());
		JPanel borderPanel = new JPanel();
		borderPanel.setLayout(new BorderLayout());
		borderPanel.add(new JSeparator(), BorderLayout.NORTH);
		
		lowerPanel.add(borderPanel, BorderLayout.NORTH);
		
		buttonPanel.setPreferredSize(new Dimension(500,35));
		buttonPanel.setLayout(null);
		
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(240,5));
		okButton.setBounds(240,5,80,25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(330,5));
		cancelButton.setBounds(330,5,80,25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				//restore original configuration
				dispose();
			}
		});
		
		defaultButton.setPreferredSize(new Dimension(80,25));
		defaultButton.setLocation(new Point(420,5));
		defaultButton.setBounds(420,5,80,25);
		defaultButton.setVisible(true);
		defaultButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				StylesPreferences.resetStylesDefaults();
				//update the display variables
				callable.updateMouseResponse(StylesPreferences.mouseFactor);
				preferences.writePreferences();
				
				callable.updateAppearance();
				setVisible(false);
				dispose();
			}
		});
		
		//export preferences
		exportButton.setPreferredSize(new Dimension(80,25));
		exportButton.setLocation(new Point(5,5));
		exportButton.setBounds(5,5,80,25);
		exportButton.setVisible(true);
		exportButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				JFileChooser chooser = new JFileChooser(StylesPreferences.workingDirectory);
				chooser.setFileFilter(new FileNameFilter("scf", "Sirius configuration file (*.scf)"));
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int result = chooser.showSaveDialog(thisDialog);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				String fname = filename.toString();
				if (!fname.endsWith(".scf")){
					fname += ".scf";
				}

				try{
					FileOutputStream out = new FileOutputStream(fname);
					preferences.exportPreferences(out);
				}
				catch (Exception ex){
					JOptionPane.showMessageDialog(parent, "Unable to export preferences: " + ex, "Error", JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		
		//import preferences
		importButton.setPreferredSize(new Dimension(80,25));
		importButton.setLocation(new Point(95,5));
		importButton.setBounds(95,5,80,25);
		importButton.setVisible(true);
		importButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				JFileChooser chooser = new JFileChooser(StylesPreferences.workingDirectory);
				chooser.setFileFilter(new FileNameFilter("scf", "Sirius configuration file (*.scf)"));
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int result = chooser.showOpenDialog(thisDialog);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				String fname = filename.toString();

				try{
					FileInputStream in = new FileInputStream(fname);
					preferences.importPreferences(in);
					
					//display message
					imported = true;
					JOptionPane.showMessageDialog(parent, "This dialog window needs to be reopen in order for changes to become visible", "Configuration import", JOptionPane.INFORMATION_MESSAGE);
				}
				catch (Exception ex){
					JOptionPane.showMessageDialog(parent, "Unable to import preferences: " + ex, "Error", JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		
		buttonPanel.add(importButton);
		buttonPanel.add(exportButton);
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);
		buttonPanel.add(defaultButton);

		lowerPanel.add(buttonPanel, BorderLayout.CENTER);
		
		//add the pane and the buttons to the base panel
		base.add(pane, BorderLayout.CENTER);
		base.add(lowerPanel, BorderLayout.SOUTH);
	

		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				dispose();
			}
		});



		
		getContentPane().add(base);
		if (os.startsWith("Win")){
			setSize(new Dimension(510, 410));
		}
		else{
			setSize(new Dimension(530, 425));
		}
		
		setLocationRelativeTo(null);
		setResizable(false);
		
		if (parent == null){
			setLocationRelativeTo(null);
		}
		else{
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parent.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);
		
			setBounds(x + parent.getX(), y + parent.getY(), d1.width, d1.height);
		}
		
		
		setVisible(true);
	}
	
	public void process(){
		
		if (imported){
			setVisible(false);
			dispose();
			return;
		}
		
		boolean restart = false;
		
		//check the values in the stick and ball radius fields
		try{
			double stickR = Double.parseDouble(stickRadiusField.getText());
			if (stickR > 1.0){
				stickR = 1.0;
			}
			if (stickR < 0.05){
				stickR = 0.05;
			}
			StylesPreferences.stickSize = stickR;
		}
		catch (NumberFormatException ex){
			if (callable != null){
				callable.displayErrorMessage("Invalid value of stick radius");
				return;
			}
		}
		
		try{
			double ballR = Double.parseDouble(ballRadiusField.getText());
			if (ballR > 5.0){
				ballR = 5.0;
			}
			if (ballR < 0.2){
				ballR = 0.2;
			}
			StylesPreferences.ballRadius = ballR;
		}
		catch (NumberFormatException ex){
			if (callable != null){
				callable.displayErrorMessage("Invalid value of ball radius");
				return;
			}
		}
		
		if (!inputRAM.equals(memoryField.getText())){
			
			Preferences root = Preferences.userRoot();
			final Preferences node = root.node("/edu/sdsc/sirius/config");
			String config = node.get("installDir", null) + File.separator + ".vmoptions";
			
			//check whether the entered value is an integer
			try{
				int v = Integer.parseInt(memoryField.getText());
				
				//update the file
				PrintWriter printer = new PrintWriter(new FileWriter(config));
				printer.print("-mx");
				printer.print(memoryField.getText());
				printer.println("m");
				printer.flush();
				printer.close();
				
				restart = true;

			}
			catch (Exception e){}
		}
		
		//get the quality values from the sliders
		int fastValue = fastSlider.getValue();
		int bestValue = bestSlider.getValue();
		StylesPreferences.renderingFastQuality = (float)fastValue;
		StylesPreferences.renderingBestQuality = (float)bestValue;
		
		StylesPreferences.ribbonQuality = ribbonSlider.getValue();
		
		int lineWidth = bondlineSlider.getValue();
		if (lineWidth != StylesPreferences.lineWidth){
			StylesPreferences.lineWidth = lineWidth;
		}
		
		int mouse = mouseSlider.getValue();
		if (mouse != StylesPreferences.mouseFactor){
			StylesPreferences.mouseFactor = mouse;
			callable.updateMouseResponse(mouse);
		}
		
		//reset the selection level
		if (atomButton.isSelected()){
			StylesPreferences.selectionLevel = StylesPreferences.SELECTION_ATOM;
			callable.setSelectionMode(StylesPreferences.SELECTION_ATOM);
		}
		else{
			StylesPreferences.selectionLevel = StylesPreferences.SELECTION_RESIDUE;
			callable.setSelectionMode(StylesPreferences.SELECTION_RESIDUE);
		}
		
		//check for fields of cache. if a value is valid (non-null or non -1), it has to be
		//updated
		if (cache.workingDirectory != null){
			StylesPreferences.workingDirectory = cache.workingDirectory;
			callable.setLastUsedDirectory(StylesPreferences.workingDirectory);
		}
		
		if (cache.ptrajDirectory != null){
			StylesPreferences.ptrajDirectory = cache.ptrajDirectory;
		}
		
		if (cache.backgroundColor != null){
			StylesPreferences.backgroundColor = cache.backgroundColor;
			callable.getStructureViewer().setBackground(StylesPreferences.backgroundColor);
		}
		
		if (cache.selectionColor != null){
			StylesPreferences.selectionColor = cache.selectionColor;
		}
		
		if (cache.monitorColor != null){
			StylesPreferences.monitorColor = cache.monitorColor;
		}
		
		if (cache.selectionLevel != -1){
			StylesPreferences.selectionLevel = cache.selectionLevel;
		}
		
		if (cache.structureView != -1){
			StylesPreferences.structureView = cache.structureView;
//			StylesPreferences.renderingMode = cache.structureView;
//			System.out.println("structureView set to " + cache.structureView);
		}
		
		if (cache.startupRenderingQuality != -1){
			StylesPreferences.startupRenderingQuality = cache.startupRenderingQuality;
		}
		

		if (cache.helixColor != null){
			StylesPreferences.HELIX_COLOR = cache.helixColor;
		}
		
		if (cache.strandColor != null){
			StylesPreferences.STRAND_COLOR = cache.strandColor;
		}
		
		if (cache.turnColor != null){
			StylesPreferences.TURN_COLOR = cache.turnColor;
		}
		
		if (cache.coilColor != null){
			StylesPreferences.COIL_COLOR = cache.coilColor;
		}
		
		if (cache.ribbonQuality != -1){
			StylesPreferences.ribbonQuality = cache.ribbonQuality;
		}
		
		if (cache.ballRadiusOption != -1){
			StylesPreferences.ballRadiusOption = cache.ballRadiusOption;
		}
		
		if (cache.renderBondOrder != -1){
			StylesPreferences.renderBondOrder = (cache.renderBondOrder == 0);
		}
		
		if (bondOrderReset){
			if (cache.bondOrderOptions[0] != StylesPreferences.showBondOrder){
				StylesPreferences.showBondOrder = cache.bondOrderOptions[0];
			}
			
		}
		
		if (cache.showBoundWaters != -1){
			StylesPreferences.showBoundWaters = (cache.showBoundWaters == 0);
			callable.updateBoundWaters();
		}
		
		if (cache.commonRibbonColoring != -1){
			StylesPreferences.commonRibbonColoring = (cache.commonRibbonColoring == 0);
		}
		
		if (cache.commonColoring != -1){
			StylesPreferences.commonColoring = (cache.commonColoring == 0);
		}
		
		if (cache.commonSelection != -1){
			StylesPreferences.commonSelection = (cache.commonSelection == 0);
		}
		
		if (cache.showCellGrid != -1){
			StylesPreferences.showCellGrid = (cache.showCellGrid == 0);
		}

		if (cache.showResidueTips != -1){
			StylesPreferences.showResidueTips = (cache.showResidueTips == 0);
		}
		
		if (cache.showSs != -1){
			StylesPreferences.showSs = (cache.showSs == 0);
		}

		if (cache.undoEnabled != -1){
			StylesPreferences.undoEnabled = (cache.undoEnabled == 0);
		}
		
		if (cache.undoDepth != -1){
			StylesPreferences.undoBufferDepth = cache.undoDepth;
		}
		
		if (cache.toolbar != -1){
			StylesPreferences.displayToolbar = (cache.toolbar == 0);
		}
		
		//toolbar buttons
		if (cache.toolbarAngle != -1){
			StylesPreferences.toolbarAngle = (cache.toolbarAngle == 0);
			StylesPreferences.toolbarChanged = true;
		}
		
		if (cache.toolbarPDB != -1){
			StylesPreferences.toolbarPDB = (cache.toolbarPDB == 0);
			StylesPreferences.toolbarChanged = true;
		}
		
		if (cache.toolbarUndo != -1){
			StylesPreferences.toolbarUndo = (cache.toolbarUndo == 0);
			StylesPreferences.toolbarChanged = true;
		}
		
		if (cache.toolbarVisibility != -1){
			StylesPreferences.toolbarVisibility = (cache.toolbarVisibility == 0);
			StylesPreferences.toolbarChanged = true;
		}

		if (cache.toolbarRendering != -1){
			StylesPreferences.toolbarRendering = (cache.toolbarRendering == 0);
			StylesPreferences.toolbarChanged = true;
		}

		if (cache.toolbarColoring != -1){
			StylesPreferences.toolbarColoring = (cache.toolbarColoring == 0);
			StylesPreferences.toolbarChanged = true;
		}

		if (cache.toolbarLabels != -1){
			StylesPreferences.toolbarLabels = (cache.toolbarLabels == 0);
			StylesPreferences.toolbarChanged = true;
		}

		if (cache.toolbarCenter != -1){
			StylesPreferences.toolbarCenter = (cache.toolbarCenter == 0);
			StylesPreferences.toolbarChanged = true;
		}

		if (cache.toolbarSeparate != -1){
			StylesPreferences.toolbarSeparate = (cache.toolbarSeparate == 0);
			StylesPreferences.toolbarChanged = true;
		}
		
		if (cache.toolbarCommon != -1){
			StylesPreferences.toolbarCommon = (cache.toolbarCommon == 0);
			StylesPreferences.toolbarChanged = true;
		}
		
		if (cache.toolbarDistance != -1){
			StylesPreferences.toolbarDistance = (cache.toolbarDistance == 0);
			StylesPreferences.toolbarChanged = true;
		}

		if (cache.toolbarDihedral != -1){
			StylesPreferences.toolbarDihedral = (cache.toolbarDihedral == 0);
			StylesPreferences.toolbarChanged = true;
		}

		if (cache.toolbarFog != -1){
			StylesPreferences.toolbarFog = (cache.toolbarFog == 0);
			StylesPreferences.toolbarChanged = true;
		}

		
		if (cache.toolbarPosition != -1){
			StylesPreferences.toolbarPosition = cache.toolbarPosition;
		}

		if (cache.toolbarTips != -1){
			StylesPreferences.showToolbarTips = (cache.toolbarTips == 0);
		}
		
		if (cache.sequenceViewerFont != null){
			StylesPreferences.sequenceViewerFont = cache.sequenceViewerFont;
		}
		
		if (cache.chainColors != null){
			StylesPreferences.chainColors = cache.chainColors;
		}
		
		if (cache.structureColors != null){
			StylesPreferences.structureColors = cache.structureColors;
		}
		
		if (cache.structureColorSequence != -1){
			StylesPreferences.structureColorSequence = (cache.structureColorSequence == 0);
		}
		
		if (cache.cellBackgroundColor != null){
			StylesPreferences.cellBackgroundColor = cache.cellBackgroundColor;
		}
		
		if (cache.fastGeometry != -1){
			StylesPreferences.fastGeometry = (cache.fastGeometry == 0);
		}
		
		if (cache.zoomMiddle != -1){
			StylesPreferences.zoomMiddle = (cache.zoomMiddle == 0);
		}

		if (cache.laf != -1){
			StylesPreferences.LAF = cache.laf;
		}

		//these preferences are saved to the user preferences on the local system
		preferences.writePreferences();
		
		//check whether a toolbar is needed
		if (cache.toolbar != -1 || cache.toolbarTips != -1 || cache.toolbarPosition != -1 || StylesPreferences.toolbarChanged ){
			callable.updateToolbar();
		}
		
		//take care of the visual attributes that should change (checkboxes in menus that show relevant options)
		callable.updateAppearance();
		
		setVisible(false);
		
		if (restart){
			callable.displayMessage("You have made changes that will take effect after the application is restarted");
		}
		else{
			if (cache.laf != -1){
				callable.displayMessage("Change of application look and feel will take effect after the application is restarted");
			}
		}
		
		dispose();
	}
	
	private Border createTitledBorder(String title){
		
		Border border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		TitledBorder border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " " + title + " ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		Border border = BorderFactory.createCompoundBorder(border1, border2);

		return border;
	}
	
	private ImageIcon createImageIcon(float[] color){
		
		BufferedImage m_image = new BufferedImage(50,10, BufferedImage.TYPE_INT_RGB);
		Graphics g = m_image.createGraphics();
		
		g.setColor(new Color(color[0], color[1], color[2]));
		g.fillRect(0,0,50,10);
		g.setColor(Color.black);
		g.drawRect(0,0,49,9);
		
		return new ImageIcon(m_image);
	}
	
	private ImageIcon createImageIcon(Color color){
		
		BufferedImage m_image = new BufferedImage(50,10, BufferedImage.TYPE_INT_RGB);
		Graphics g = m_image.createGraphics();
		g.setColor(color);
		g.fillRect(0,0,50,10);
		g.setColor(Color.black);
		g.drawRect(0,0,49,9);
		
		return new ImageIcon(m_image);
	}
	
	public void stateChanged(ChangeEvent e){
		int value = ((JSlider)e.getSource()).getValue() - 2;
		if (value == StylesPreferences.menuFontSize) return;
		StylesPreferences.menuFontSize = value;
		callable.displayMessage("The new font size will take effect when application is restarted.");
	}
	
	public static void main(String[] args){
		PreferencesDialog d = new PreferencesDialog(null, null);
	}
	
	
	public ImageIcon createTextSample(Font font){
		BufferedImage m_image = new BufferedImage(200,50, BufferedImage.TYPE_INT_ARGB);
		Graphics2D g = m_image.createGraphics();
		g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g.setFont(font);
		g.setColor(Color.BLACK);
		g.drawString("Sample", 0,45);
		
		//calculate length of the string
		FontMetrics fontMetrics = g.getFontMetrics( );
		sampleStringLength = fontMetrics.stringWidth("Sample");

		return new ImageIcon(m_image);
		
	}


	
}
		
