package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.mbt.*;
import edu.sdsc.mbt.util.*;
import edu.sdsc.sirius.ray.RayTraceUtil;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class RayTracerDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel typePanel = new JPanel();
	private JPanel qPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
		
	private JLabel label1 = new JLabel("Width:");
	private JTextField field1 = new JTextField(30);
	private JLabel label2 = new JLabel("Height:");
	private JTextField field2 = new JTextField(30);
	
	private double maximumDistance = -1;//default: no fog
	
	private JSlider fogSlider;
	
	private int width = 230;
	private int height = 270;
	
	private boolean addRibbon = true;
	private Chain chain;
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	public static boolean ribbonDisplay = true;
	private int ribbonType = StylesPreferences.RIBBON_RENDERED;
	
	public RayTracerDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Image export options", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		int w = sv.getGeometryViewer().getWidth();
		int h = sv.getGeometryViewer().getHeight();
		
		
		itself = this;
		
		//reset static variables
		ribbonDisplay = true;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 210, 200);
		base.setLayout(null);

		//ribbon type panel
		typePanel.setBounds(5,5,200,130);
		typePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Image dimensions ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		typePanel.setBorder(border);
		
		
		//object field
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 12));
		label1.setText("Width:");
		label1.setBounds(25,35,50,20);
		label1.setVisible(true);
		
		field1.setBounds(80,35,80,20);
		field1.setEditable(true);
		field1.setEnabled(true);
		field1.setText((new Integer(w)).toString());
		
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 12));
		label2.setText("Height:");
		label2.setBounds(25,65,70,20);
		label2.setVisible(true);
		field2.setText((new Integer(h)).toString());
		
		field2.setBounds(80,65,80,20);
		field2.setEditable(true);
		field2.setEnabled(true);
		field2.setVisible(true);

		typePanel.add(label1);
		typePanel.add(field1);
		typePanel.add(label2);
		typePanel.add(field2);
		
		
		//quality panel
		qPanel.setBounds(5,135,200,60);
		qPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Distance fading ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		qPanel.setBorder(border);

		fogSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, 1);
		fogSlider.setBounds(40,25,120,25);
		fogSlider.setVisible(true);
		fogSlider.setPaintTicks(true);
		fogSlider.setSnapToTicks(true);
		fogSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		fogSlider.setMajorTickSpacing(1);
		
		JLabel low = new JLabel("None");
		low.setFont(new Font("Dialog", Font.PLAIN, 11));
		low.setBounds(10,20,25,20);
		
		JLabel high = new JLabel("Max");
		high.setFont(new Font("Dialog", Font.PLAIN, 11));
		high.setBounds(165,20,30,20);

		qPanel.add(fogSlider);
		qPanel.add(low);
		qPanel.add(high);
		
		base.add(typePanel);
		base.add(qPanel);
		
		//buttons
		okButton.setBounds(20, 210, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setBounds(120, 210, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
//			public void windowDeactivated(WindowEvent e){
//				toFront();
//			}
		});
		
		
		
		Dimension dim = getToolkit().getScreenSize();
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}
		
		setSize(width, height);
		setResizable(false);
		setVisible(true);

	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
	private void process(){
		
		try{
			final int width = Integer.parseInt(field1.getText());
			final int height = Integer.parseInt(field2.getText());
			setVisible(false);
			parent.setDisplayDialogStatus(false);

			Thread runner = new Thread(){
				public void run(){
					try{
						if (fogSlider.getValue() > 1){
							//calculate the distance to the farthest part of the structure from the camera
							//it is needed to set the scale of the fog slider
							//walk over all atoms and determine the maximum distance from the camera
							double[] camera = sv.getGeometryViewer().getEyePosition();
							double max = 0;
							for (int i = 0; i < sv.getLoadedStructures().size(); i++){
								Structure st = (Structure)sv.getLoadedStructures().get(i);
								StructureMap map = st.getStructureMap();
								for (int j = 0; j < map.getAtomCount(); j++){
									double dist = Algebra.distance(map.getAtom(j).coordinate, camera);
									if (dist > max) max = dist;
								}
							}
							
							maximumDistance = max;
						}
						
						String filename = RayTraceUtil.getPOVContent(sv, parent, width, height, maximumDistance/fogSlider.getValue(), true, null);
						if (filename == null){
							parent.displayErrorMessage("Image rendering failed.");
							return;
						}
						parent.openImagePreviewPanel(filename);
					}
					catch (Exception ex){
						parent.displayExceptionMessage("Exception", ex);
					}
						
					dispose();
				}
			};
			runner.start();

		}
		catch (Exception ex){
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Processing exception", ex);
			return;
		}

		dispose();

	}
	
}
