package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.util.*;
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class ReplaceAtomDialog extends JDialog implements DisplayDialog, ElementSettable {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	private Atom[] atoms = new Atom[2];
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	
	
	private JLabel label = new JLabel();
	private JTextField field = new JTextField(30);
	
	private JTextField elementField = new JTextField(20);
	private JButton select = new JButton("Select");
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private String element = null;//selection
	
	
	public ReplaceAtomDialog(JFrame f, Manager p, StructureViewer s){
	
		super(f, "Replace atom", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
//		System.out.println("Starting");
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(210, 190));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 210, 190);
		base.setLayout(null);
		
		
		//object field
		label.setForeground(Color.black);
		label.setFont(new Font("Dialog", Font.PLAIN, 12));
		label.setText("Enter atom name or click");
		label.setPreferredSize(new Dimension(170,20));
		label.setBounds(15,15,170,20);
		label.setLocation(new Point(15,15));
		label.setVisible(true);
		
		field.setPreferredSize(new Dimension(180,20));
		field.setBounds(15,40,180,20);
		field.setLocation(new Point(15,40));
		field.setEditable(true);
		field.setEnabled(true);
		field.setVisible(true);
		
		base.add(label);
		base.add(field);
		
		//element buttons
		JButton H = new JButton("H");
		H.setPreferredSize(new Dimension(40,30));
		H.setLocation(new Point(15, 80));
		H.setBounds(15, 80, 40, 30);
		H.setVisible(true);
		H.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				elementField.setText("H");
			}
		});
		
		JButton C = new JButton("C");
		C.setPreferredSize(new Dimension(40,30));
		C.setLocation(new Point(60, 80));
		C.setBounds(60, 80, 40, 30);
		C.setVisible(true);
		C.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				elementField.setText("C");
			}
		});

		JButton N = new JButton("N");
		N.setPreferredSize(new Dimension(40,30));
		N.setLocation(new Point(105, 80));
		N.setBounds(105, 80, 40, 30);
		N.setVisible(true);
		N.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				elementField.setText("N");
			}
		});

		JButton O = new JButton("O");
		O.setPreferredSize(new Dimension(40,30));
		O.setLocation(new Point(150, 80));
		O.setBounds(150, 80, 40, 30);
		O.setVisible(true);
		O.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				elementField.setText("O");
			}
		});

		JButton S = new JButton("S");
		S.setPreferredSize(new Dimension(40,30));
		S.setLocation(new Point(15, 115));
		S.setBounds(15, 115, 40, 30);
		S.setVisible(true);
		S.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				elementField.setText("S");
			}
		});

		JButton P = new JButton("P");
		P.setPreferredSize(new Dimension(40,30));
		P.setLocation(new Point(60, 115));
		P.setBounds(60, 115, 40, 30);
		P.setVisible(true);
		P.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				elementField.setText("P");
			}
		});

		JButton F = new JButton("F");
		F.setPreferredSize(new Dimension(40,30));
		F.setLocation(new Point(105, 115));
		F.setBounds(105, 115, 40, 30);
		F.setVisible(true);
		F.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				elementField.setText("F");
			}
		});
	
		JButton K = new JButton("K");
		K.setPreferredSize(new Dimension(40,30));
		K.setLocation(new Point(150, 115));
		K.setBounds(150, 115, 40, 30);
		K.setVisible(true);
		K.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				elementField.setText("K");
			}
		});
		
		base.add(H);
		base.add(C);
		base.add(N);
		base.add(O);
		base.add(S);
		base.add(P);
		base.add(F);
		base.add(K);
		
		elementField.setPreferredSize(new Dimension(100,20));
		elementField.setBounds(15,150,100,20);
		elementField.setLocation(new Point(15,150));
		elementField.setEditable(true);
		elementField.setEnabled(true);
		elementField.setVisible(true);
		
		select.setPreferredSize(new Dimension(70,20));
		select.setLocation(new Point(120, 150));
		select.setBounds(120, 150, 70, 20);
		select.setVisible(true);
		select.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Thread runner = new Thread(){
					public void run(){
						ElementSelectionDialog d = new ElementSelectionDialog(parentFrame, "Select new element", (ElementSettable)itself);
					}
				};
				runner.start();
				
			}
		});

		
		base.add(elementField);
		base.add(select);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(20, 200));
		okButton.setBounds(20, 200, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
			
				//add error checking for selection bounds
				//eg., selection level is residue, but entered only structure name
				try{
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					if (atoms[0] == null || field.getText().length() == 0){
						parent.displayErrorMessage("Atom and desired element must be selected.");
					}
					else{
						StructureEvent event = new StructureEvent(itself);
						event.atomLabels.add(field.getText());
						event.atoms.add(atoms[0]);
						event.element = elementField.getText();
						event.eventType = StructureEventRegistry.REPLACE_ATOM;
						sv.processDisplayDialogEvent(event);
					}
				}
				catch (Exception e){
					parent.setDisplayDialogStatus(false);
					parent.displayExceptionMessage("Exception replacing atom", e);
				}

				dispose();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(120, 200));
		cancelButton.setBounds(120, 200, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
		});
		
		setResizable(false);
		
		setSize(230, 255);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		setVisible(true);
		


	}
	
	public void processPick(String data, StructureComponent structureComponent){
		
		field.setText(data);
		atoms[0] = (Atom)structureComponent;
	}
	
	public void setElement(String element){
		elementField.setText(element);
		this.element = element;
	}
}
