package edu.sdsc.sirius.dialogs;

// Core
// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;
import java.util.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.builder.FragmentButton;
import edu.sdsc.sirius.builder.FragmentRecord;
import edu.sdsc.sirius.builder.FragmentRegistry;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class ReplaceResidueDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private JPanel topPanel = new JPanel();
	private JPanel setPanel = new JPanel();
	
	private Border border1 = null;
	private TitledBorder border2 = null;
	private Border border = null;
	
	public int selection = DialogConstants.ADD_SELECTION;
	
	private JTextField field = new JTextField(50);
	private JLabel label = new JLabel("Enter name or pick amino acid");
	
	private JTextField selectionField = new JTextField(50);
	private JLabel selectionLabel = new JLabel("Selected amino acid:");
	
	private Residue residue;
	
	private Vector buttons = new Vector();
	
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	public ReplaceResidueDialog(JFrame f, Manager p, StructureViewer s){

		super(f, " Replace amino acid", false);

		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(300, 320));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 300, 320);
		base.setLayout(null);
		
		topPanel.setPreferredSize(new Dimension(290, 75));
		topPanel.setLocation(new Point(5,5));
		topPanel.setBounds(5,5,290,75);
		topPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Target amino acid ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		topPanel.setBorder(border);
		
		label.setPreferredSize(new Dimension(200, 20));
		label.setLocation(new Point(15,20));
		label.setBounds(15,20,200,20);
	
		field.setPreferredSize(new Dimension(150, 20));
		field.setLocation(new Point(15, 40));
		field.setBounds(15,40,150,20);
		
		topPanel.add(label);
		topPanel.add(field);
		
		base.add(topPanel);
		
		setPanel.setPreferredSize(new Dimension(290, 200));
		setPanel.setLocation(new Point(5,80));
		setPanel.setBounds(5,80,290,200);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Pick the new amino acid ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		
		setPanel.setLayout(new GridLayout(5,4));
		
		for (int i = 20; i < 40; i++){
			FragmentButton button = new FragmentButton((FragmentRecord)FragmentRegistry.getFragmentRecords().get(i), this );
			setPanel.add(button);
			buttons.add(button);
		}
		
		base.add(setPanel);
		
		
		//add selection field panel
		JPanel selectionPanel = new JPanel();
		selectionPanel.setPreferredSize(new Dimension(290, 30));
		selectionPanel.setLocation(new Point(5,290));
		selectionPanel.setBounds(5,280,290,30);
		selectionPanel.setLayout(null);
		
		selectionLabel.setPreferredSize(new Dimension(130, 20));
		selectionLabel.setLocation(new Point(10,10));
		selectionLabel.setBounds(10,10,130,20);
		
		selectionField.setPreferredSize(new Dimension(130, 20));
		selectionField.setLocation(new Point(140, 35));
		selectionField.setBounds(140,10,130,20);
		
		selectionPanel.add(selectionLabel);
		selectionPanel.add(selectionField);
		
		base.add(selectionPanel);
		
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(65, 335));
		okButton.setBounds(65, 335, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(160, 335));
		cancelButton.setBounds(160, 335, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(315, 400);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		
		Thread runner = new Thread(){
			public void run(){
				
				if (field.getText().length() == 0 || residue == null){
					parent.displayErrorMessage("Nothing selected. Please define the target residue and try again");
					cleanup();
					return;
				}

				if (residue == null){
					//look into the text entry: the user may have typed in the name
					Object object = sv.labelToObject(field.getText());
					if (object instanceof Residue){
						residue = (Residue)object;
					}
					else if (object instanceof Atom){
						Atom a = (Atom)object;
						residue = a.structure.getStructureMap().getResidue(a);
					}
					else{
						parent.displayErrorMessage("Entered label does not match a residue. Please define the target residue and try again");
						cleanup();
						return;
					}
				}
				
				if (residue.getCompoundCode().equals(selectionField.getText().toUpperCase())){
					parent.displayErrorMessage("Selected amino acid is the same as the current one.");
					cleanup();
					return;
				}
				
				parent.setDisplayDialogStatus(false);
				sv.replaceResidue(residue, selectionField.getText().toUpperCase());
			}
		};
		runner.start();
		dispose();
	}
	
	private void cleanup(){
		setVisible(false);
		parent.setDisplayDialogStatus(false);
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		if (data.length() > 0){
			Atom a = (Atom)structureComponent;
			if (a != null) residue = a.structure.getStructureMap().getResidue(a);
			field.setText(data);
		}
		
		if (structureComponent == null){
			field.setText("");
			residue = null;
		}
		
	}
	
	public void setResidue(FragmentButton button, String residue){
		selectionField.setText(residue);
		
		//deselect any other pressed button
		for (int i = 0; i < buttons.size(); i++){
			FragmentButton b = (FragmentButton)buttons.get(i);
			if (b == button) continue;
			b.setPressed(false);
		}
	}
	
}
