package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class RibbonDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel switchPanel = new JPanel();
	private JPanel typePanel = new JPanel();
	private JPanel qPanel = new JPanel();
	private JPanel setPanel = new JPanel();
	private JPanel sPanel = new JPanel();
	
	private ButtonGroup setGroup = new ButtonGroup();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
		
	private ButtonGroup switchGroup = new ButtonGroup();
	private JRadioButton radio1 = new JRadioButton("Show", true);
	private JRadioButton radio2 = new JRadioButton("Hide", false);
	
	private ButtonGroup typeGroup = new ButtonGroup();
	private JRadioButton type1 = new JRadioButton("Round cross-section", false);
	private JRadioButton type2 = new JRadioButton("Cartoon ribbon", true);
	private JRadioButton type3 = new JRadioButton("Backbone trace line", false);
	
	private JLabel radiusLabel = new JLabel("Ribbon diameter:");
	private JTextField radiusField = new JTextField(20);
	
	private JLabel helixLabel = new JLabel("Helix type:");
	private JComboBox helixCombo;
	
	private JLabel dimensionLabel = new JLabel("Cylinder diameter:");
	private JTextField dimensionField = new JTextField(20);
	

	private int setFlag = DialogConstants.APPLY_STRUCTURE;
	
	private JRadioButton radio3 = new JRadioButton("Structure", true);
	private JRadioButton radio4 = new JRadioButton("Chain", false);
	private JRadioButton radio5 = new JRadioButton("Residue", true);
	private JRadioButton radio6 = new JRadioButton("Current selection", false);
	private JRadioButton radio7 = new JRadioButton("Visible ribbon only", false);
	
	private JSlider ribbonSlider;
	
	private JCheckBox box;
	
	private boolean ignore = false;//ignore if the window s deactivated: used when displaying error messages

	
	private JTextField field = new JTextField(30);
	private JLabel label = new JLabel();
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JLabel or = new JLabel("or");
	private JComboBox combo;
	
	//this variable notes whether the user has changed type settings
	//if not, the type is adjusted according to the apply to selection to reflect
	//the current appearance. if yes, no action is taken, assuming that the user
	//intends to change it
	private boolean typeSet = false;
	
	public static boolean ribbonDisplay = true;
	private int ribbonType = StylesPreferences.RIBBON_FLAT_HELICES;
	
	private Vector structures = new Vector();
	
	public RibbonDialog(JFrame f, Manager p, StructureViewer s){

		super(f, " Show/hide ribbon ", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//reset static variables
		ribbonDisplay = true;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 430, 340);
		base.setLayout(null);
		
		
		//ribbon type panel
		typePanel.setBounds(205,5,220,220);
		typePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Ribbon type ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		typePanel.setBorder(border);
		

		//define the radio buttons
		type1.setFont(new Font("Dialog", Font.PLAIN, 12));
		type1.setBounds(25,25,150,20);
		type1.setVisible(true);
		type1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ribbonType = StylesPreferences.RIBBON_UNIFORM_ROUND;
				radiusField.setEnabled(true);
				dimensionField.setEnabled(false);
				typeSet = true;
			}
		});

		radiusLabel.setFont(new Font("Dialog", Font.PLAIN, 11));
		radiusLabel.setBounds(50, 50, 85, 20);
		
		radiusField.setBounds(150, 50, 30, 20);
		radiusField.setText(new Float(StylesPreferences.ribbonDiameter).toString());
		radiusField.setEnabled(type1.isSelected());

		type2.setFont(new Font("Dialog", Font.PLAIN, 12));
		type2.setBounds(25,80,150,20);
		type2.setVisible(true);
		type2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				int choice = helixCombo.getSelectedIndex();
				if (choice == 0){
					ribbonType = StylesPreferences.RIBBON_FLAT_HELICES;
					dimensionLabel.setText("Helix thickness:");
					dimensionField.setText(new Float(StylesPreferences.helixThickness).toString());
					dimensionField.setEnabled(true);
				}
				else if (choice == 1){
					ribbonType = StylesPreferences.RIBBON_RENDERED;
					dimensionLabel.setText("Helix thickness:");
					dimensionField.setText(new Float(StylesPreferences.helixThickness).toString());
					dimensionField.setEnabled(false);
				}
				else{
					ribbonType = StylesPreferences.RIBBON_CYLINDER_HELICES;
					dimensionLabel.setText("Helix diameter:");
					dimensionField.setText(new Float(StylesPreferences.cylinderDiameter).toString());
					dimensionField.setEnabled(true);
				}
				radiusField.setEnabled(false);
				typeSet = true;
				box.setSelected(false);
			}
		});
		
		
		//add the combo box with helix types
		helixLabel.setBounds(50,110,60,20);

		Vector types = new Vector();
		types.add("Flat");
		types.add("Rounded");
		types.add("Cylinder");
		
		helixCombo = new JComboBox(types);
		helixCombo.setBounds(120,110,80,20);
		helixCombo.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				type2.setSelected(true);
				dimensionField.setEnabled(true);
				int choice = helixCombo.getSelectedIndex();
				if (choice == 0){
					ribbonType = StylesPreferences.RIBBON_FLAT_HELICES;
					dimensionLabel.setText("Helix thickness:");
					dimensionField.setText(new Float(StylesPreferences.helixThickness).toString());
				}
				else if (choice == 1){
					ribbonType = StylesPreferences.RIBBON_RENDERED;
					dimensionLabel.setText("Helix thickness:");
					dimensionField.setText(new Float(StylesPreferences.helixThickness).toString());
					dimensionField.setEnabled(false);
				}
				else{
					ribbonType = StylesPreferences.RIBBON_CYLINDER_HELICES;
					dimensionLabel.setText("Helix diameter:");
					dimensionField.setText(new Float(StylesPreferences.cylinderDiameter).toString());
				}
			}
		});
		
		dimensionLabel.setFont(new Font("Dialog", Font.PLAIN, 11));
		dimensionLabel.setText("Helix thickness:");
		dimensionLabel.setBounds(50, 140, 100, 20);
		
		dimensionField.setBounds(160, 140, 40, 20);
		dimensionField.setText(new Float(StylesPreferences.helixThickness).toString());
		dimensionField.setEnabled(type2.isSelected());
		
		

		type3.setFont(new Font("Dialog", Font.PLAIN, 12));
		type3.setBounds(25,180,150,20);
		type3.setVisible(true);
		type3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ribbonType = StylesPreferences.RIBBON_LINE;
				dimensionField.setEnabled(false);
//				helixCombo.setEnabled(false);
				radiusField.setEnabled(false);
				typeSet = true;
			}
		});

		
		typePanel.add(type1);
		typePanel.add(type2);
		typePanel.add(helixLabel);
		typePanel.add(helixCombo);
		typePanel.add(dimensionLabel);
		typePanel.add(dimensionField);
		typePanel.add(radiusLabel);
		typePanel.add(radiusField);
		typePanel.add(type3);
		
		typeGroup.add(type1);
		typeGroup.add(type2);
		typeGroup.add(type3);
		
		
		//quality panel
		qPanel.setBounds(205,275,220,60);
		qPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Ribbon quality ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		qPanel.setBorder(border);

		ribbonSlider = new JSlider(JSlider.HORIZONTAL, 1, 5, (int)StylesPreferences.ribbonQuality);
		ribbonSlider.setBounds(35,25,120,25);
		ribbonSlider.setVisible(true);
		ribbonSlider.setPaintTicks(true);
		ribbonSlider.setSnapToTicks(true);
		ribbonSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		ribbonSlider.setMajorTickSpacing(1);
		ribbonSlider.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				typeSet = true;
			}
		});
		
		JLabel low = new JLabel("Low");
		low.setFont(new Font("Dialog", Font.PLAIN, 11));
		low.setBounds(10,20,25,20);
		
		JLabel high = new JLabel("High");
		high.setFont(new Font("Dialog", Font.PLAIN, 11));
		high.setBounds(165,20,30,20);

		qPanel.add(ribbonSlider);
		qPanel.add(low);
		qPanel.add(high);
		
		//smoothing switch panel
		sPanel.setBounds(205,225,220,50);
		sPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Ribbon path smoothing ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		sPanel.setBorder(border);
		
		box = new JCheckBox("Force ribbon through CA atoms");
		box.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				if (box.isSelected() && type2.isSelected()){
					box.setSelected(false);
					ignore = true;
					parent.displayErrorMessage("Ribbon cannot be forced to pass through CA atoms when cartoon shape is enabled");
				}
				StylesPreferences.smoothRibbon = !box.isSelected();
			}
		});
		box.setSelected(!StylesPreferences.smoothRibbon);
		box.setBounds(25,20,180,20);
		
		sPanel.add(box);
		
		
		
		
		//structure panel
		setPanel.setBounds(5,65,200,270);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  Apply to ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		
		//object field
		
		radio3.setBounds(20,85,100,20);
		radio3.setVisible(true);
		radio3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_STRUCTURE;
				field.requestFocus();
			}
		});
		
		radio4.setBounds(20,110,100,20);
		radio4.setVisible(true);
		radio4.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_CHAIN;
				field.requestFocus();
			}
		});

		radio5.setBounds(20,135,100,20);
		radio5.setVisible(true);
		radio5.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_RESIDUE;
				field.requestFocus();
			}
		});
		
		radio6.setBounds(20,25,150,20);
		radio6.setVisible(true);
		radio6.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_SELECTION;
				
				//check whether the current selection has a ribbon
				//and update current type and quality, if so

				Chain c = null;
				//we assume that the first residue of selection points to the correct
				//ribbon. in most cases, it's true, except when multiple structures/chains are
				//selected. But then it's impossible to decide which chain to use anyway.
				for (int i = 0; i < sv.getLoadedStructures().size(); i++){
					Structure s = (Structure)sv.getLoadedStructures().get(i);
					Hashtable selection = s.getStructureMap().getStructureStyles().getSelection();
					Set keys = selection.keySet();
					Iterator it = keys.iterator();
					while (it.hasNext()){
						Object item = it.next();
						if (item instanceof Residue){
							c = s.getStructureMap().getChain(((Residue)item).getAtom(0));
							break;
						}
					}
					
				}
				
				if (c == null) return;
				
				Structure s = c.structure;
				
				int type = s.getStructureMap().getStructureStyles().getRibbonType(c);
				float q = s.getStructureMap().getStructureStyles().getRibbonQuality(c);
				
				if (type == -1) return;//no ribbon exists for this chain
				
				if (!typeSet){
					//use only the first chain's parameters, since there is no way of knowing which
					//chain's parameters the user would want to use
					if (type == StylesPreferences.RIBBON_UNIFORM_ROUND){
						type1.setSelected(true);
						radiusField.setEnabled(true);
						dimensionField.setEnabled(false);
//						helixCombo.setEnabled(false);
						ribbonType = StylesPreferences.RIBBON_UNIFORM_ROUND;
					}
					else if (type == StylesPreferences.RIBBON_RENDERED){
						type2.setSelected(true);
						radiusField.setEnabled(false);
						dimensionField.setEnabled(false);
//						helixCombo.setEnabled(true);
						helixCombo.setSelectedIndex(1);
						ribbonType = StylesPreferences.RIBBON_RENDERED;
					}
					else if (type == StylesPreferences.RIBBON_FLAT_HELICES){
						type2.setSelected(true);
						radiusField.setEnabled(false);
						dimensionField.setEnabled(true);
//						helixCombo.setEnabled(true);
						helixCombo.setSelectedIndex(0);
						ribbonType = StylesPreferences.RIBBON_FLAT_HELICES;
					}
					else if (type == StylesPreferences.RIBBON_CYLINDER_HELICES){
						type2.setSelected(true);
						radiusField.setEnabled(false);
						dimensionField.setEnabled(true);
//						helixCombo.setEnabled(true);
						helixCombo.setSelectedIndex(2);
						ribbonType = StylesPreferences.RIBBON_CYLINDER_HELICES;
					}
					else if (type == StylesPreferences.RIBBON_LINE){
						type3.setSelected(true);
						radiusField.setEnabled(false);
						dimensionField.setEnabled(false);
//						helixCombo.setEnabled(false);
						ribbonType = StylesPreferences.RIBBON_LINE;
					}
					
					//take care of quality
					ribbonSlider.setValue((int)q);
				}
				
				

			}
		});


		radio7.setBounds(20,50,150,20);
		radio7.setVisible(true);
		radio7.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_VISIBLE;
				
				//check whether the current selection has a ribbon
				//and update current type and quality, if so

				Chain c = null;
				//we assume that the first visible ribbon fragment points to the correct
				//ribbon. in most cases, it's true, except when multiple structures/chains are
				//visible. But then it's impossible to decide which chain to use anyway.
				for (int i = 0; i < sv.getLoadedStructures().size(); i++){
					Structure s = (Structure)sv.getLoadedStructures().get(i);
					StructureMap map = s.getStructureMap();
					for (int j = 0; j < map.getResidueCount(); j++){
						Residue res = map.getResidue(j);
						if (res.ribbon){
							c = map.getChain(res.getAtom(0));
							break;
						}
					}
					
				}
				
				if (c == null) return;
				
				Structure s = c.structure;
				
				int type = s.getStructureMap().getStructureStyles().getRibbonType(c);
				float q = s.getStructureMap().getStructureStyles().getRibbonQuality(c);
				
				if (type == -1) return;//no ribbon exists for this chain
				
				if (!typeSet){
					//use only the first chain's parameters, since there is no way of knowing which
					//chain's parameters the user would want to use
					if (type == StylesPreferences.RIBBON_UNIFORM_ROUND){
						type1.setSelected(true);
						radiusField.setEnabled(true);
						dimensionField.setEnabled(false);
//						helixCombo.setEnabled(false);
						ribbonType = StylesPreferences.RIBBON_UNIFORM_ROUND;
					}
					else if (type == StylesPreferences.RIBBON_RENDERED){
						type2.setSelected(true);
						radiusField.setEnabled(false);
						dimensionField.setEnabled(false);
//						helixCombo.setEnabled(true);
						helixCombo.setSelectedIndex(1);
						ribbonType = StylesPreferences.RIBBON_RENDERED;
					}
					else if (type == StylesPreferences.RIBBON_FLAT_HELICES){
						type2.setSelected(true);
						radiusField.setEnabled(false);
						dimensionField.setEnabled(true);
//						helixCombo.setEnabled(true);
						helixCombo.setSelectedIndex(0);
						ribbonType = StylesPreferences.RIBBON_FLAT_HELICES;
					}
					else if (type == StylesPreferences.RIBBON_CYLINDER_HELICES){
						type2.setSelected(true);
						radiusField.setEnabled(false);
						dimensionField.setEnabled(true);
//						helixCombo.setEnabled(true);
						helixCombo.setSelectedIndex(2);
						ribbonType = StylesPreferences.RIBBON_CYLINDER_HELICES;
					}
					else if (type == StylesPreferences.RIBBON_LINE){
						type3.setSelected(true);
						radiusField.setEnabled(false);
						dimensionField.setEnabled(false);
//						helixCombo.setEnabled(false);
						ribbonType = StylesPreferences.RIBBON_LINE;
					}

					//take care of quality
					ribbonSlider.setValue((int)q);
				}
				
				
				
				
			}
		});

		
		label.setForeground(Color.black);
		label.setFont(new Font("Dialog", Font.PLAIN, 11));
		label.setText("Enter name or click structure");
		label.setPreferredSize(new Dimension(170,20));
		label.setBounds(20,165,170,20);
		label.setVisible(true);
		
		field.setBounds(20,195,170,20);
		field.setEditable(true);
		field.setEnabled(true);
		field.setVisible(true);
		
		field.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});
		
		setPanel.add(radio3);
		setPanel.add(radio4);
		setPanel.add(radio5);
		setPanel.add(radio6);
		setPanel.add(radio7);
		
		setGroup.add(radio3);
		setGroup.add(radio4);
		setGroup.add(radio5);
		setGroup.add(radio6);
		setGroup.add(radio7);
		

		setPanel.add(label);
		setPanel.add(field);
		
		or.setForeground(Color.black);
		or.setFont(new Font("Dialog", Font.PLAIN, 11));
		or.setPreferredSize(new Dimension(15,20));
		or.setBounds(25,230,15,20);
		or.setVisible(true);
		
		//walk through the loaded structures
		structures.add("Select structure or set");
		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures.add(sv.getStructureName(st));
		}
		
		Vector setNames = sv.getAtomSetNames();
		for (int i = 0; i < setNames.size(); i++){
			structures.add(setNames.get(i));
		}

		combo = new JComboBox(structures);
		combo.setBounds(45,230,145,20);
		combo.setVisible(true);
		if (structures.size() == 1) combo.setEnabled(false);
		combo.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo.getSelectedItem();
				if (choice.startsWith("Select")) return;
				field.setText(choice);
				setFlag = DialogConstants.APPLY_STRUCTURE;
				radio3.setSelected(true);
				
				Vector loaded = sv.getLoadedStructures();
				for (int i = 0; i < loaded.size(); i++){
					Structure s = (Structure)loaded.get(i);
					if (sv.getStructureName(s).equals(choice)){
						//this is the structure
						for (int j = 0; j < s.getStructureMap().getChainCount(); j++){
							Chain c = s.getStructureMap().getChain(j);
							int type = s.getStructureMap().getStructureStyles().getRibbonType(c);
							float q = s.getStructureMap().getStructureStyles().getRibbonQuality(c);
							
							if (type == -1) continue;//no ribbon exists for this chain
							
							if (!typeSet){
								//use only the first chain's parameters, since there is no way of knowing which
								//chain's parameters the user would want to use
								if (type == StylesPreferences.RIBBON_UNIFORM_ROUND){
									type1.setSelected(true);
									radiusField.setEnabled(true);
									dimensionField.setEnabled(false);
//									helixCombo.setEnabled(false);
									ribbonType = StylesPreferences.RIBBON_UNIFORM_ROUND;
								}
								else if (type == StylesPreferences.RIBBON_RENDERED){
									type2.setSelected(true);
									radiusField.setEnabled(false);
									dimensionField.setEnabled(false);
//									helixCombo.setEnabled(true);
									helixCombo.setSelectedIndex(1);
									ribbonType = StylesPreferences.RIBBON_RENDERED;
								}
								else if (type == StylesPreferences.RIBBON_FLAT_HELICES){
									type2.setSelected(true);
									radiusField.setEnabled(false);
									dimensionField.setEnabled(true);
//									helixCombo.setEnabled(true);
									helixCombo.setSelectedIndex(0);
									ribbonType = StylesPreferences.RIBBON_FLAT_HELICES;
								}
								else if (type == StylesPreferences.RIBBON_CYLINDER_HELICES){
									type2.setSelected(true);
									radiusField.setEnabled(false);
									dimensionField.setEnabled(true);
//									helixCombo.setEnabled(true);
									helixCombo.setSelectedIndex(2);
									ribbonType = StylesPreferences.RIBBON_CYLINDER_HELICES;
								}
								else if (type == StylesPreferences.RIBBON_LINE){
									type3.setSelected(true);
									radiusField.setEnabled(false);
									dimensionField.setEnabled(false);
//									helixCombo.setEnabled(false);
									ribbonType = StylesPreferences.RIBBON_LINE;
								}
								
								//take care of quality
								ribbonSlider.setValue((int)q);

							}
							
							
						}
					}
				}
			}
		});

		setPanel.add(or);
		setPanel.add(combo);
		
		
		
		switchPanel.setBounds(5,5,200,60);
		switchPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Action ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		switchPanel.setBorder(border);
		

		//define the radio buttons
		radio1.setBounds(30,25,70,20);
		radio1.setVisible(true);
		radio1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ribbonDisplay = true;
			}
		});
		
		radio2.setBounds(110,25,70,20);
		radio2.setVisible(true);
		radio2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				ribbonDisplay = false;
			}
		});

		//add radio buttons to groups
		switchGroup.add(radio1);
		switchGroup.add(radio2);
		
		switchPanel.add(radio1);
		switchPanel.add(radio2);
		
		
		base.add(switchPanel);
		base.add(typePanel);
		base.add(qPanel);
		base.add(setPanel);
		base.add(sPanel);
		
		//buttons
		okButton.setBounds(125, 350, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setBounds(245, 350, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				if (!ignore) toFront();
			}
		});
		
		
		
		setSize(450, 410);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
			
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		setVisible(true);

	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		if (field.isEditable()){
			field.setText(data);
		}
		
		//get the chain the structure component belongs to
		
		Chain c = null;
		if (structureComponent instanceof Atom){
			Atom a = (Atom)structureComponent;
			c = a.structure.getStructureMap().getChain(a);
		}
		else if (structureComponent instanceof Bond){
			Bond b = (Bond)structureComponent;
			c = b.getAtom(0).structure.getStructureMap().getChain(b.getAtom(0));
		}
		else if (structureComponent instanceof Residue){
			Residue r = (Residue)structureComponent;
			c = r.structure.getStructureMap().getChain(r.getAtom(0));
		}
		else if (structureComponent instanceof Chain){
			c = (Chain)structureComponent;
		}
			
		if (c == null) return;
		int type = structureComponent.structure.getStructureMap().getStructureStyles().getRibbonType(c);
		float q = structureComponent.structure.getStructureMap().getStructureStyles().getRibbonQuality(c);
		
		if (type == -1) return;//no ribbon exists for this chain
		
		if (!typeSet){
			//use only the first chain's parameters, since there is no way of knowing which
			//chain's parameters the user would want to use
			if (type == StylesPreferences.RIBBON_UNIFORM_ROUND){
				type1.setSelected(true);
				radiusField.setEnabled(true);
				dimensionField.setEnabled(false);
				ribbonType = StylesPreferences.RIBBON_UNIFORM_ROUND;
			}
			else if (type == StylesPreferences.RIBBON_RENDERED){
				type2.setSelected(true);
				radiusField.setEnabled(false);
				dimensionField.setEnabled(false);
				helixCombo.setSelectedIndex(1);
				ribbonType = StylesPreferences.RIBBON_RENDERED;
			}
			else if (type == StylesPreferences.RIBBON_FLAT_HELICES){
				type2.setSelected(true);
				radiusField.setEnabled(false);
				dimensionField.setEnabled(true);
				helixCombo.setSelectedIndex(0);
				ribbonType = StylesPreferences.RIBBON_FLAT_HELICES;
			}
			else if (type == StylesPreferences.RIBBON_CYLINDER_HELICES){
				type2.setSelected(true);
				radiusField.setEnabled(false);
				dimensionField.setEnabled(true);
				helixCombo.setSelectedIndex(2);
				ribbonType = StylesPreferences.RIBBON_CYLINDER_HELICES;
			}
			else if (type == StylesPreferences.RIBBON_LINE){
				type3.setSelected(true);
				radiusField.setEnabled(false);
				dimensionField.setEnabled(false);
				ribbonType = StylesPreferences.RIBBON_LINE;
			}
			//take care of quality
			ribbonSlider.setValue((int)q);
		}
		
		
		
	}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		try{

			setVisible(false);
			parent.setDisplayDialogStatus(false);
			
			RibbonEvent event = new RibbonEvent(itself);
			event.componentId = field.getText();
			event.status = radio1.isSelected();
			
			event.ribbonDiameter = StylesPreferences.ribbonDiameter;

			if (ribbonType == StylesPreferences.RIBBON_UNIFORM_ROUND){
				try{
					float diameter = Float.parseFloat(radiusField.getText());
					event.ribbonDiameter = diameter;
					StylesPreferences.ribbonDiameter = diameter;
				}
				catch (NumberFormatException e){
					ignore = true;
					parent.displayErrorMessage("Invalid value of ribbon diameter: " + radiusField.getText());
					return;
				}
			}
			else if (ribbonType == StylesPreferences.RIBBON_RENDERED){
				
				//regular ribbon cartoon. get the thickness value - IGNORE FOR NOW: NO WAY OF IMPLEMENTING THE GRAPHICS CHANGE
/*				try{
					float thickness = Float.parseFloat(dimensionField.getText());
					StylesPreferences.helixThickness = thickness;
				}
				catch (NumberFormatException e){
					ignore = true;
					parent.displayErrorMessage("Invalid value of helix thickness: " + dimensionField.getText());
					return;
				}
*/			}
			else if (ribbonType == StylesPreferences.RIBBON_FLAT_HELICES){
				try{
					float thickness = Float.parseFloat(dimensionField.getText());
					StylesPreferences.helixThickness = thickness;
				}
				catch (NumberFormatException e){
					ignore = true;
					parent.displayErrorMessage("Invalid value of helix thickness: " + dimensionField.getText());
					return;
				}
			}
			else if (ribbonType == StylesPreferences.RIBBON_CYLINDER_HELICES){
				//cylinders
				try{
					float diameter = Float.parseFloat(dimensionField.getText());
					StylesPreferences.cylinderDiameter = diameter;
				}
				catch (NumberFormatException e){
					ignore = true;
					parent.displayErrorMessage("Invalid value of cylinder diameter: " + dimensionField.getText());
					return;
				}
				
			}
			
			//no extra action needed with trace line
			
			event.ribbonType = ribbonType;
			event.structureComponent = structureComponent;
			event.setFlag = setFlag;
			event.ribbonQuality = ribbonSlider.getValue();
			sv.processDisplayDialogEvent(event);
			
		}
		catch (Exception e){
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			e.printStackTrace();
		}

		dispose();

	}
	
}
