package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.util.DataService;
import edu.sdsc.sirius.viewers.*;

public class SelectListDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	
	private JPanel topPanel = new JPanel();
	private JPanel setPanel = new JPanel();
	
	private Border border1 = null;
	private TitledBorder border2 = null;
	private Border border = null;
	
	public int selection = DialogConstants.ADD_SELECTION;
	
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton add = new JRadioButton("Add to existing selection", true);
	private JRadioButton replace = new JRadioButton("Replace existing selection", false);


	private JTextField field = new JTextField(50);
	private JLabel label1 = new JLabel();
	
	private JTextField field2 = new JTextField(30);
	private JLabel label2 = new JLabel();
	
	private JLabel label3 = new JLabel();
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JComboBox combo1 = new JComboBox();
	private Vector structures = new Vector();

	private JComboBox combo2 = new JComboBox();
	private Vector chains = new Vector();
	
	private Structure structure;
	private Chain chain;
	
	private Vector residues;

	
	private StericEvent event = null;
	
	private Atom[] atoms = new Atom[2];
	
	public SelectListDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Selection by list", false);

		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(300, 230));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 300, 230);
		base.setLayout(null);
		
		topPanel.setPreferredSize(new Dimension(290, 70));
		topPanel.setLocation(new Point(5,5));
		topPanel.setBounds(5,5,290,70);
		topPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Type of selection operation ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		topPanel.setBorder(border);
		
	
		//define the radio buttons
		add.setLocation(20,20);
		add.setBounds(20,20,180,20);
		add.setVisible(true);
		add.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				selection = DialogConstants.ADD_SELECTION;
			}
		});

		replace.setLocation(20,40);
		replace.setBounds(20,40,180,20);
		replace.setVisible(true);
		replace.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				selection = DialogConstants.REPLACE_SELECTION;
			}
		});
		
		group.add(add);
		group.add(replace);
		
		topPanel.add(add);
		topPanel.add(replace);
		
		base.add(topPanel);
		
		
		
		
		setPanel.setPreferredSize(new Dimension(290, 140));
		setPanel.setLocation(new Point(5,80));
		setPanel.setBounds(5,80,290,140);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Define the list of residue numbers ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 11));
		label1.setText("Structure:");
		label1.setPreferredSize(new Dimension(60,20));
		label1.setBounds(20,25,60,20);
		label1.setLocation(new Point(20,25));
		label1.setVisible(true);
		
		//walk through the loaded structures
		structures.add("Select");
		chains.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures.add(sv.getStructureName(st));
		}
		
		combo1 = new JComboBox(structures);
		combo1.setPreferredSize(new Dimension(100,20));
		combo1.setBounds(90,25,100,20);
		combo1.setLocation(new Point(90,25));
		combo1.setVisible(true);
		if (structures.size() == 1) combo1.setEnabled(false);
		combo1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo1.getSelectedItem();
				try{
					structure = (Structure)sv.getLoadedStructures().get(combo1.getSelectedIndex() - 1);
					//walk through the chains in the structure and add them
					chains.clear();
					chains.add("Select");
					StructureMap map = structure.getStructureMap();
					for (int i = 0; i < map.getChainCount(); i++){
						chains.add((map.getChain(i)).getChainId());
					}
					if (chains.size() == 1){
						chains.add("Default");
						combo2.setSelectedIndex(1);
					}
					combo2.setEnabled(true);
					combo2.setModel(new DefaultComboBoxModel(chains));
				}
				catch (Exception ex){
					chains.clear();
					chains.add("Select");
					combo2.setEnabled(false);
					combo2.setSelectedIndex(0);
					field.setEnabled(false);
					field.setEditable(false);
					field.setText("");
				}
				combo2.revalidate();
			}
		});
		
		
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 11));
		label2.setText("Chain:");
		label2.setPreferredSize(new Dimension(60,20));
		label2.setBounds(20,60,60,20);
		label2.setLocation(new Point(20,55));
		label2.setVisible(true);

		combo2 = new JComboBox(chains);
		combo2.setPreferredSize(new Dimension(100,20));
		combo2.setBounds(90,60,100,20);
		combo2.setLocation(new Point(90,60));
		combo2.setVisible(true);
		combo2.setEnabled(false);
		combo2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo2.getSelectedItem();
				field.setEnabled(true);
				field.setEditable(true);
				try{
					chain = structure.getStructureMap().getChain(combo2.getSelectedIndex() - 1);
					field.requestFocus();
				}
				catch (Exception ex){
					field.setEnabled(false);
					field.setEditable(false);
					field.setText("");
				}
			}
		});
		
		label3.setForeground(Color.black);
		label3.setFont(new Font("Dialog", Font.PLAIN, 11));
		label3.setText("Residues:");
		label3.setPreferredSize(new Dimension(60,20));
		label3.setBounds(20,95,60,20);
		label3.setLocation(new Point(20,95));
		label3.setVisible(true);
		
		field.setPreferredSize(new Dimension(180,20));
		field.setBounds(90,95,180,20);
		field.setLocation(new Point(90,95));
		field.setEditable(false);
		field.setEnabled(false);
		field.setVisible(true);
		field.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});
		
		//add panels to the base
		setPanel.add(label1);
		setPanel.add(combo1);
		setPanel.add(label2);
		setPanel.add(combo2);
		setPanel.add(label3);
		setPanel.add(field);
		
		base.add(setPanel);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(65, 240));
		okButton.setBounds(65, 240, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(160, 240));
		cancelButton.setBounds(160, 240, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(315, 300);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		setVisible(false);
		parent.setDisplayDialogStatus(false);
	
		residues = DataService.parseResidueList(structure, chain, field.getText());
		
		
		Thread runner = new Thread(){
			public void run(){
				sv.selectResidues(residues, selection);
				parent.setDisplayDialogStatus(false);
			}
		};
		runner.start();
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
