package edu.sdsc.sirius.dialogs;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class SelectionAreaDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	private Atom[] atoms = new Atom[2];
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	
	private JPanel panel1 = new JPanel();
	private JPanel panel2 = new JPanel();
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton radio1 = new JRadioButton("By fixed radius");
	private JRadioButton radio2 = new JRadioButton("By distance from residue/atom");
	private JRadioButton radio3 = new JRadioButton("Current selection");
	private JRadioButton radio4 = new JRadioButton("Pick a residue");
	
	private JLabel label1 = new JLabel();
	private JTextField field1 = new JTextField(30);
	private JLabel label2 = new JLabel();
	private JTextField field2 = new JTextField(20);
	
	
	private JTextField field3 = new JTextField(30);
	
	private JLabel label3 = new JLabel("Distance");
	private JTextField field4 = new JTextField(20);

	
	private JCheckBox check = new JCheckBox("Include full residues");
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	public SelectionAreaDialog(JFrame f, Manager p, StructureViewer s){
	
		super(f, "Define selected area", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 260, 350);
		base.setLayout(null);
		
		panel1.setBounds(5,5,250,290);
		panel1.setVisible(true);
		panel1.setLayout(null);
		
		panel1.setBorder(createTitledBorder("Selection criteria"));
		
		radio1.setBounds(20,20,200,20);
		radio1.setSelected(true);
		radio1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				field1.setEnabled(true);
				field1.setEditable(true);
				field2.setEnabled(true);
				field2.setEditable(true);
				
				radio3.setEnabled(false);
				radio4.setEnabled(false);
				field3.setEnabled(false);
				field3.setEditable(false);
				field4.setEnabled(false);
				field4.setEditable(false);
				
				field1.requestFocus();
//				check.setEnabled(true);
			}
		});
		
		//object field
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 11));
		label1.setText("Center: enter atom name or click");
		label1.setBounds(20,40,180,20);
		label1.setVisible(true);
		
		field1.setBounds(20,60,170,20);
		field1.setEditable(true);
		field1.setEnabled(true);
		field1.requestFocus();
		
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 11));
		label2.setText("Radius of selection");
		label2.setBounds(20,80,190,20);
		
		field2.setBounds(20,100,100,20);
		field2.setEditable(true);
		field2.setEnabled(true);
		
		field2.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					parent.setDisplayDialogStatus(false);
					setVisible(false);
					dispose();
				}
			}
		});
		
		
		
		panel1.add(radio1);
		panel1.add(label1);
		panel1.add(field1);
		panel1.add(label2);
		panel1.add(field2);

		JSeparator line = new JSeparator();
		line.setBounds(10,130,210,5);
		line.setVisible(true);
		
		panel1.add(line);
		
		
		
		radio2.setBounds(20, 140, 210, 20);
		radio2.setSelected(false);
		radio2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				field1.setEnabled(false);
				field1.setEditable(false);
				field2.setEnabled(false);
				field2.setEditable(false);
				
				radio3.setEnabled(true);
				radio4.setEnabled(true);
				if (radio4.isSelected()){
					field3.setEnabled(true);
					field3.setEditable(true);
					field3.requestFocus();
				}
				else{
					field4.requestFocus();
				}
				field4.setEnabled(true);
				field4.setEditable(true);
				
			}
		});
		
		group.add(radio1);
		group.add(radio2);
		
		panel1.add(radio2);
		
		
		radio3.setEnabled(false);
		radio3.setSelected(true);
		radio3.setBounds(40, 160, 150, 20);
		radio3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				field3.setEnabled(false);
				field3.setEditable(false);
				field4.requestFocus();
			}
		});
		
		radio4.setEnabled(false);
		radio4.setSelected(false);
		radio4.setBounds(40, 180, 150, 20);
		radio4.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				field3.setEnabled(true);
				field3.setEditable(true);
				field3.requestFocus();
			}
		});
		
		ButtonGroup group2 = new ButtonGroup();
		group2.add(radio3);
		group2.add(radio4);
		
		field3.setBounds(40,210,150,20);
		field3.setEditable(false);
		field3.setEnabled(false);
		
		label3.setFont(new Font("Dialog", Font.PLAIN, 11));
		label3.setBounds(40,230,100,20);

		
		field4.setBounds(40,250,100,20);
		field4.setEditable(false);
		field4.setEnabled(false);
		field4.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					parent.setDisplayDialogStatus(false);
					setVisible(false);
					dispose();
				}
			}
		});
		
		panel1.add(radio3);
		panel1.add(radio4);
		panel1.add(field3);
		panel1.add(label3);
		panel1.add(field4);
		
		
		
		panel2.setBounds(5,295,250,50);
		panel2.setVisible(true);
		panel2.setLayout(null);
		
		panel2.setBorder(createTitledBorder("Residue inclusion"));

		
		check.setBounds(20,20,150,20);
		check.setSelected(true);
		check.setEnabled(true);
		
		panel2.add(check);
		
		
		base.add(panel1);
		base.add(panel2);
		
		//buttons
		okButton.setBounds(40, 360, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setBounds(160, 360, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(280, 420);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}



		setVisible(true);
		


	}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		try{
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			if (atoms[0] == null && field1.getText().length() == 0 && field3.getText().length() == 0 && !radio3.isSelected()){
				parent.displayErrorMessage("An atom must be selected");
			}
			else{
				if (radio1.isSelected()){
					//regular radius selection
					ViewEvent event = new ViewEvent(itself);
					event.componentId = field1.getText();
					event.structureComponent = atoms[0];
					event.flag = check.isSelected();
					try{
						event.radius = Float.parseFloat(field2.getText());
					}
					catch (NumberFormatException ex){
						parent.displayErrorMessage("Entered radius value is not a number");
						return;
					}
					sv.processDisplayDialogEvent(event);
				}
				else{
					//constant distance from a component
					if (radio3.isSelected()){
						//use current selection as the input set
						try{
							double distance = Double.parseDouble(field4.getText());
							
							sv.setSelectionArea(null, distance, check.isSelected());
						}
						catch (NumberFormatException ex){
							parent.displayErrorMessage("Distance must be entered as a number");
							return;
						}
					}
					else{
						//get the picked residue
						String id = field3.getText();
						System.out.println("id = " + id);
						Residue residue = null;
						try{
							Atom a = (Atom)sv.labelToObject(id);
							System.out.println("a = " + a);
							residue = a.residue;
						}
						catch (ClassCastException e){
							//could have been a residue
							residue = (Residue)sv.labelToObject(id);
						}
						
						try{
							double distance = Double.parseDouble(field4.getText());
							
							sv.setSelectionArea(residue, distance, check.isSelected());
						}
						catch (NumberFormatException ex){
							parent.displayErrorMessage("Distance must be entered as a number");
							return;
						}
						
					}
				}
			}
		}
		catch (Exception e){
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception selecting area", e);
		}

		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){

		if (field1.isEnabled()) {
			field1.setText(data);
			if (data.length() > 0) field2.requestFocus();
		}
		else{
			field3.setText(data);
			if (data.length() > 0) field4.requestFocus();
		}

		atoms[0] = (Atom)structureComponent;
	}
	
	private Border createTitledBorder(String title){
		
		Border border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		TitledBorder border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " " + title + " ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		Border border = BorderFactory.createCompoundBorder(border1, border2);

		return border;
	}

	
}
