package edu.sdsc.sirius.dialogs;


// GUI
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;


public class SequenceRenameDialog extends JDialog implements DisplayDialog {

	private Manager parent = null;
	
	private static SequenceRenameDialog dialog = null;
	private static String newName = null;
	
	
	public SequenceRenameDialog(JFrame f){
		super(f, "Rename sequence", true);
	}
	
	public static String showDialog(JFrame f, Sequence sequence){
		
//		System.out.println("Starting");
		
		if (sequence == null){
			System.out.println("sequence = null");
		}
		dialog = new SequenceRenameDialog(f);
		JFrame parentFrame = f;
		newName = sequence.getName();
		
		//create the panels
		Container contentPane = dialog.getContentPane();
		contentPane.setLayout(null);
		
		JPanel base = new JPanel();
		base.setPreferredSize(new Dimension(245, 90));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 245, 90);
		base.setLayout(null);
		
		
		//current name
		JLabel label1 = new JLabel();
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.BOLD, 12));
		label1.setText("Current name:");
		label1.setPreferredSize(new Dimension(100,20));
		label1.setBounds(15,15,90,20);
		label1.setLocation(new Point(15,15));
		label1.setVisible(true);
		
		JLabel label2 = new JLabel();
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 12));
		label2.setText(sequence.getName());
		label2.setPreferredSize(new Dimension(130,20));
		label2.setBounds(110,15,130,20);
		label2.setLocation(new Point(110,15));
		label2.setVisible(true);
		
		JLabel label3 = new JLabel();
		label3.setForeground(Color.black);
		label3.setFont(new Font("Dialog", Font.BOLD, 12));
		label3.setText("New name:");
		label3.setPreferredSize(new Dimension(130,20));
		label3.setBounds(15,45,90,20);
		label3.setLocation(new Point(15,45));
		label3.setVisible(true);
		
		final JTextField field1 = new JTextField();
		field1.setPreferredSize(new Dimension(110,20));
		field1.setBounds(110,45,110,20);
		field1.setLocation(new Point(110,45));
		field1.setEditable(true);
		field1.setEnabled(true);
		field1.setVisible(true);
		field1.requestFocus();
		
		base.add(label1);
		base.add(label2);
		base.add(label3);
		base.add(field1);
		
		//buttons
		JButton okButton = new JButton("OK");
		okButton.setPreferredSize(new Dimension(70,25));
		okButton.setLocation(new Point(50, 100));
		okButton.setBounds(50, 100, 70, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				String n = field1.getText();
				if (n.length() > 0){
					newName = n;
				}
				dialog.setVisible(false);
				dialog.dispose();
			}
		});
		field1.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					String n = field1.getText();
					if (n.length() > 0){
						newName = n;
					}
					dialog.setVisible(false);
					dialog.dispose();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					dialog.setVisible(false);
					dialog.dispose();
				}
			}
		});
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.setPreferredSize(new Dimension(85,25));
		cancelButton.setLocation(new Point(140, 100));
		cancelButton.setBounds(140, 100, 85, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				dialog.setVisible(false);
				dialog.dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		dialog.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				dialog.setVisible(false);
				dialog.dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				dialog.toFront();
			}
		});
		
		
		
		dialog.setSize(260, 160);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			dialog.setLocationRelativeTo(null);
		}
		else{
		
			//set location
			Dimension d1 = dialog.getSize();
			Dimension d2 = parentFrame.getSize();
			
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);

//			int x = 5;
//			int y = 45;
			
			
		
			dialog.setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}



		dialog.setVisible(true);
		
		return newName;
		
	}
	
	public void processPick(String data, StructureComponent component){}
	
}
