package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class StructureAlignmentDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private StructureAlignmentDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel setPanel1 = new JPanel();
	private JPanel setPanel2 = new JPanel();
	
	private JPanel subsetPanel1 = new JPanel();
	private JPanel subsetPanel2 = new JPanel();
	
	private JPanel midPanel = new JPanel();//contains process button
	
	private JButton alignButton = new JButton("Run alignment");
	
	private JPanel rmsdPanel = new JPanel();
	private JLabel rmsdLabel = new JLabel("RMSD:");
	private JTextField rmsdValue = new JTextField(20);
	
	private JPanel namePanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private int width = 440;
	private int height = 460;
	
	
	private ButtonGroup group1 = new ButtonGroup();
	private JRadioButton select1 = new JRadioButton("Select structure from list", true);
	private JRadioButton pick1 = new JRadioButton("Pick structure in display", false);
	
	private ButtonGroup group2 = new ButtonGroup();
	private JRadioButton select2 = new JRadioButton("Select structure from list", true);
	private JRadioButton pick2 = new JRadioButton("Pick structure in display", false);
	
	private ButtonGroup sg1 = new ButtonGroup();
	private JRadioButton sbAll1 = new JRadioButton("Entire structure", true);
	private JRadioButton sbSelection1 = new JRadioButton("Contiguous residue selection", false);
	private JRadioButton sbSet1 = new JRadioButton("Defined set", false);
	private JComboBox sbCombo1 = new JComboBox();
	private String setName1;
	
	private Vector sets1 = new Vector();
	
	private ButtonGroup sg2 = new ButtonGroup();
	private JRadioButton sbAll2 = new JRadioButton("Entire structure", true);
	private JRadioButton sbSelection2 = new JRadioButton("Contiguous residue selection", false);
	private JRadioButton sbSet2 = new JRadioButton("Defined set", false);
	private JComboBox sbCombo2 = new JComboBox();
	private String setName2;
	
	private Vector sets2 = new Vector();
	
	private JTextField field1 = new JTextField(30);
	private JTextField field2 = new JTextField(30);
	
	private Atom[] atoms = new Atom[2];

	private JLabel label11 = new JLabel();
	private JLabel label12 = new JLabel();
	
	private JLabel label21 = new JLabel();
	private JLabel label22 = new JLabel();
	
	private JTextField activeField = field1;

	private JButton cancelButton = new JButton("Close");
	
	private JLabel nameLabel1 = new JLabel("Y. Zhang, J. Skolnick, TM-align: A protein structure alignment algorithm ");
	private JLabel nameLabel2 = new JLabel("based on TM-score , Nucleic Acids Research, 2005 33: 2302-2309.");
	
	
	private JComboBox combo11 = new JComboBox();
	private Vector structures1 = new Vector();

	private JComboBox combo12 = new JComboBox();
	private Vector chains1 = new Vector();
	
	private JComboBox combo21 = new JComboBox();
	private Vector structures2 = new Vector();

	private JComboBox combo22 = new JComboBox();
	private Vector chains2 = new Vector();

	private Structure structure1;
	private Structure structure2;
	private Chain chain1;
	private Chain chain2;

	private Structure structureOut1;
	private Structure structureOut2;
	
	public static final int USE_ALL = 0;
	public static final int USE_SELECTION = 1;
	public static final int USE_SET = 2;
	
	
	private int subset1 = USE_ALL;
	private int subset2 = USE_ALL;
	
	
	public StructureAlignmentDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Align two protein structures", false);

		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 425, 390);
		base.setLayout(null);
		
		
		setPanel1.setBounds(5,5,205,150);
		setPanel1.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " First structure (reference) ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel1.setBorder(border);
		

		label11.setForeground(Color.black);
		label11.setFont(new Font("Dialog", Font.PLAIN, 11));
		label11.setText("Structure:");
		label11.setBounds(25,50,60,20);
		label11.setVisible(true);
		
		//walk through the loaded structures
		structures1.add("Select");
		chains1.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures1.add(sv.getStructureName(st));
		}
		
		combo11 = new JComboBox(structures1);
		combo11.setBounds(85,50,100,20);
		combo11.setVisible(true);
		if (structures1.size() == 1) combo11.setEnabled(false);
		combo11.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo11.getSelectedItem();
				try{
					structure1 = (Structure)sv.getLoadedStructures().get(combo11.getSelectedIndex() - 1);
					//walk through the chains in the structure and add them
					chains1.clear();
					chains1.add("Select");
					StructureMap map = structure1.getStructureMap();
					for (int i = 0; i < map.getChainCount(); i++){
						chains1.add((map.getChain(i)).getChainId());
					}
					if (chains1.size() == 1){
						chains1.add("Default");
						combo12.setSelectedIndex(1);
					}
					combo12.setEnabled(true);
					combo12.setModel(new DefaultComboBoxModel(chains1));
				}
				catch (Exception ex){
					chains1.clear();
					chains1.add("Select");
					combo12.setEnabled(false);
					combo12.setSelectedIndex(0);
				}
				combo12.revalidate();
			}
		});
		
		
		label12.setForeground(Color.black);
		label12.setFont(new Font("Dialog", Font.PLAIN, 11));
		label12.setText("Chain:");
		label12.setBounds(30,80,40,20);
		label12.setVisible(true);

		combo12 = new JComboBox(chains1);
		combo12.setBounds(85,80,100,20);
		combo12.setVisible(true);
		combo12.setEnabled(false);
		combo12.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo12.getSelectedItem();
				try{
					chain1 = structure1.getStructureMap().getChain(combo12.getSelectedIndex() - 1);
				}
				catch (Exception ex){}
			}
		});
		
		select1.setBounds(20,20,180,20);
		select1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (structures1.size() > 1) combo11.setEnabled(true);
//				combo12.setEnabled(true);
				field1.setText("");
				field1.setEnabled(false);
				field1.setEditable(false);
			}
		});
		
		pick1.setBounds(20,80,150,20);
		pick1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				combo11.setEnabled(false);
				combo12.setEnabled(false);
				field1.setEnabled(true);
				field1.setEditable(true);
				field1.requestFocus();
				activeField = field1;
			}
		});
		
		field1.setBounds(85, 110, 100, 20);
		field1.setEnabled(false);
		field1.setEditable(false);
		field1.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field1;
			}
		});

		setPanel1.add(label11);
		setPanel1.add(combo11);
//		setPanel1.add(label12);
//		setPanel1.add(combo12);
		setPanel1.add(select1);
		setPanel1.add(pick1);
		setPanel1.add(field1);
		
		group1.add(select1);
		group1.add(pick1);
		
		
		
		///second set panel
		setPanel2.setBounds(215,5,205,150);
		setPanel2.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Second structure (aligned - moved) ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel2.setBorder(border);
		
		label21.setForeground(Color.black);
		label21.setFont(new Font("Dialog", Font.PLAIN, 11));
		label21.setText("Structure:");
		label21.setBounds(25,50,60,20);
		label21.setVisible(true);
		
		//walk through the loaded structures
		structures2.add("Select");
		chains2.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures2.add(sv.getStructureName(st));
		}
		
		combo21 = new JComboBox(structures2);
		combo21.setBounds(85,50,100,20);
		combo21.setVisible(true);
		if (structures2.size() == 1) combo21.setEnabled(false);
		combo21.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo21.getSelectedItem();
				try{
					structure2 = (Structure)sv.getLoadedStructures().get(combo21.getSelectedIndex() - 1);
					//walk through the chains in the structure and add them
					chains2.clear();
					chains2.add("Select");
					StructureMap map = structure2.getStructureMap();
					for (int i = 0; i < map.getChainCount(); i++){
						chains2.add((map.getChain(i)).getChainId());
					}
					if (chains2.size() == 1){
						chains2.add("Default");
						combo22.setSelectedIndex(1);
					}
					combo22.setEnabled(true);
					combo22.setModel(new DefaultComboBoxModel(chains2));
				}
				catch (Exception ex){
					chains2.clear();
					chains2.add("Select");
					combo22.setEnabled(false);
					combo22.setSelectedIndex(0);
				}
				combo22.revalidate();
			}
		});
		
		
		label22.setForeground(Color.black);
		label22.setFont(new Font("Dialog", Font.PLAIN, 11));
		label22.setText("Chain:");
		label22.setBounds(30,80,40,20);
		label22.setVisible(true);

		combo22 = new JComboBox(chains1);
		combo22.setBounds(85,80,100,20);
		combo22.setVisible(true);
		combo22.setEnabled(false);
		combo22.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo22.getSelectedItem();
				try{
					chain2 = structure2.getStructureMap().getChain(combo22.getSelectedIndex() - 1);
				}
				catch (Exception ex){}
			}
		});
		
		select2.setBounds(20,20,180,20);
		select2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (structures2.size() > 1) combo21.setEnabled(true);
//				combo12.setEnabled(true);
				field2.setText("");
				field2.setEnabled(false);
				field2.setEditable(false);
			}
		});
		
		pick2.setBounds(20,80,150,20);
		pick2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				combo21.setEnabled(false);
				combo22.setEnabled(false);
				field2.setEnabled(true);
				field2.setEditable(true);
				field2.requestFocus();
				activeField = field2;
			}
		});
		
		field2.setBounds(85, 110, 100, 20);
		field2.setEnabled(false);
		field2.setEditable(false);
		field2.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field2;
			}
		});

		setPanel2.add(label21);
		setPanel2.add(combo21);
//		setPanel2.add(label22);
//		setPanel2.add(combo22);
		setPanel2.add(select2);
		setPanel2.add(pick2);
		setPanel2.add(field2);
		
		group2.add(select2);
		group2.add(pick2);

		
		
		//add panels to the base
		base.add(setPanel1);
		base.add(setPanel2);
		
		
		
		
		//subset panels
		subsetPanel1.setBounds(5,155,205,90);
		subsetPanel1.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Aligned part of first structure ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		subsetPanel1.setBorder(border);
		
		
		sbAll1.setBounds(20,25,140,20);
		sbAll1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				subset1 = USE_ALL;
				sbCombo1.setEnabled(false);
			}
		});
		
		sbSelection1.setBounds(20,50,180,20);
		sbSelection1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				subset1 = USE_SELECTION;
				sbCombo1.setEnabled(false);
			}
		});
		
		//walk through the loaded structures
		sets1.add("Select");
		sets2.add("Select");
		Vector setNames = sv.getAtomSetNames();
		for (int i = 0; i < setNames.size(); i++){
			sets1.add(setNames.get(i));
			sets2.add(setNames.get(i));
		}

		
		sbSet1.setBounds(25,75,140,20);
//		if (sets1.size() == 1) sbSet1.setEnabled(false);
		sbSet1.setEnabled(false);
		sbSet1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				subset1 = USE_SET;
				sbCombo1.setEnabled(true);
			}
		});
		
		
		sbCombo1 = new JComboBox(sets1);
		sbCombo1.setBounds(80,110,100,20);
		sbCombo1.setVisible(true);
		sbCombo1.setEnabled(false);
		if (sets1.size() == 1) sbCombo1.setEnabled(false);
		sbCombo1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)sbCombo1.getSelectedItem();
				setName1 = (String)sets1.get(sbCombo1.getSelectedIndex());
			}
		});

		
		
		sg1.add(sbAll1);
		sg1.add(sbSelection1);
//		sg1.add(sbSet1);
		
		subsetPanel1.add(sbAll1);
		subsetPanel1.add(sbSelection1);
//		subsetPanel1.add(sbSet1);
//		subsetPanel1.add(sbCombo1);
		
		base.add(subsetPanel1);
		
		
		//second panel
		
		subsetPanel2.setBounds(215,155,205,90);
		subsetPanel2.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Aligned part of second structure ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		subsetPanel2.setBorder(border);
		
		
		sbAll2.setBounds(20,25,140,20);
		sbAll2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				subset2 = USE_ALL;
				sbCombo2.setEnabled(false);
			}
		});
		
		sbSelection2.setBounds(20,50,180,20);
		sbSelection2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				subset2 = USE_SELECTION;
				sbCombo2.setEnabled(false);
			}
		});
		
		sbSet2.setBounds(25,75,140,20);
//		if (sets2.size() == 1) sbSet2.setEnabled(false);
		sbSet2.setEnabled(false);
		sbSet2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				subset2 = USE_SET;
				sbCombo2.setEnabled(true);
			}
		});
		
		sbCombo2 = new JComboBox(sets2);
		sbCombo2.setBounds(80,110,100,20);
		sbCombo2.setVisible(true);
		sbCombo2.setEnabled(false);
		if (sets2.size() == 1) sbCombo2.setEnabled(false);
		sbCombo2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)sbCombo2.getSelectedItem();
				setName2 = (String)sets1.get(sbCombo2.getSelectedIndex());
			}
		});

		
		sg2.add(sbAll2);
		sg2.add(sbSelection2);
//		sg2.add(sbSet2);
		
		subsetPanel2.add(sbAll2);
		subsetPanel2.add(sbSelection2);
//		subsetPanel2.add(sbSet2);
//		subsetPanel2.add(sbCombo2);
		
		base.add(subsetPanel2);

		//mid panel
		midPanel.setBounds(5,245,415,70);
		midPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Alignment ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		midPanel.setBorder(border);
		
		alignButton.setBounds(40, 30, 110, 20);
		alignButton.setEnabled(true);
		alignButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				alignButton.setEnabled(false);
				process();
			}
		});
		
		rmsdLabel.setBounds(240, 30, 40, 20);
		rmsdValue.setBounds(290, 30, 50, 18);
		rmsdValue.setEnabled(false);
		rmsdValue.setEditable(false);
		
		midPanel.add(alignButton);
		midPanel.add(rmsdLabel);
		midPanel.add(rmsdValue);
		base.add(midPanel);
		
		
		
		//bottom panel
		///second set panel
		namePanel.setBounds(5,315,415,70);
		namePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Method reference ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		namePanel.setBorder(border);
		
		nameLabel1.setForeground(Color.black);
		nameLabel1.setFont(new Font("Dialog", Font.PLAIN, 11));
		nameLabel1.setBounds(20,20,380,20);
		nameLabel1.setVisible(true);
		
		nameLabel2.setForeground(Color.black);
		nameLabel2.setFont(new Font("Dialog", Font.PLAIN, 11));
		nameLabel2.setBounds(20,35,380,20);
		nameLabel2.setVisible(true);

		namePanel.add(nameLabel1);
		namePanel.add(nameLabel2);
		
		base.add(namePanel);
		
		
		
		cancelButton.setBounds(180, 400, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
		});
				
		Dimension dim = getToolkit().getScreenSize();
		
		//position the panel next to the main window on the right
		//if it ends up being wider than screen, fit it to the width of the screen
		if ((parentFrame.getX() + parentFrame.getWidth() + width) > dim.getWidth()){
			setBounds(dim.width - width, parentFrame.getY(), width, height);
		}
		else{
			setBounds(parentFrame.getX() + parentFrame.getWidth(), parentFrame.getY(), width, height);
		}

		setResizable(false);
		setVisible(true);
		


	}
	
	private void process(){
		
		try{
			//add error checking for selection bounds
			//eg., selection level is residue, but entered only structure name
			
			
			//get the chains to be aligned
			if (select1.isSelected()){
				//get the choice from the combo box
				structureOut1 = structure1;
			}
			else if (pick1.isSelected()){
				//get the picked chain
				if (atoms[0] != null){
					structureOut1 = atoms[0].structure;
				}
				
				if (structureOut1 == null){
					//try getting it out of the text in the field
					structureOut1 = (Structure)sv.labelToObject(field1.getText());
				}
				
				if (structureOut1 == null){
					alignButton.setEnabled(true);
					parent.displayErrorMessage("Unable to identify the first structure. Please try again");
					return;
				}
			}
			
			//get the chains to be aligned
			if (select2.isSelected()){
				//get the choice from the combo box
				structureOut2 = structure2;
			}
			else if (pick2.isSelected()){
				//get the picked chain
				if (atoms[1] != null){
					structureOut2 = atoms[1].structure;
				}
				
				if (structureOut2 == null){
					//try getting it out of the text in the field
					structureOut2 = (Structure)sv.labelToObject(field2.getText());
				}
				
				if (structureOut2 == null){
					alignButton.setEnabled(true);
					parent.displayErrorMessage("Unable to identify the second structure. Please try again");
					return;
				}
			}
			
			if (structureOut1 == null || structureOut2 == null){
				alignButton.setEnabled(true);
				parent.displayErrorMessage("Unable to identify one or both structures. Please try again.");
				return;
			}
			
			if (structureOut1 == structureOut2){
				alignButton.setEnabled(true);
				parent.displayErrorMessage("Alignment can only be run for different structures. Please try again.");
				return;
			}
			
			
//			Thread runner = new Thread(){
//				public void run(){
					sv.alignStructures(structureOut2, subset2, setName2, structureOut1, subset1, setName1, itself);//for further convenience - second structure will be aligned to the first one
//					dispose();
					parent.setDisplayDialogStatus(false);
//				}
//			};
//			runner.start();
		}
		catch (Exception e){
			parent.setDisplayDialogStatus(false);
			dispose();
			parent.displayExceptionMessage("Exception in structure alignment", e);
		}
		
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		System.out.println("pick " + this.structureComponent);
		activeField.setText(data);
		//move focus along only if something has been picked
		if (data.length() > 0){
			if (activeField == field1){
				atoms[0] = (Atom)structureComponent;
				if (field2.isEnabled()){
					activeField = field2;
					field2.requestFocus();
				}
			}
			else{
				atoms[1] = (Atom)structureComponent;
			}
		}
	}
	
	public void processAlignment(String rmsd){
		rmsdValue.setText(rmsd);
		rmsdValue.setEnabled(true);
		alignButton.setEnabled(true);
	}
	
}
