package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class StructureRenameDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private JPanel setPanel = new JPanel();
	private JPanel namePanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private JTextField field = new JTextField(50);
	private JLabel label1 = new JLabel();
	
	private JTextField field2 = new JTextField(30);
	private JLabel label2 = new JLabel();
	
	private JTextField field3 = new JTextField(30);
	private JLabel label3 = new JLabel();
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JComboBox combo1 = new JComboBox();
	private Vector structures = new Vector();

	private Structure structure;
	
	public StructureRenameDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Rename a structure", false);

		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(250, 160));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 250, 160);
		base.setLayout(null);
		
		
		setPanel.setPreferredSize(new Dimension(240, 70));
		setPanel.setLocation(new Point(5,5));
		setPanel.setBounds(5,5,240,70);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Select structure ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 11));
		label1.setText("Structure:");
		label1.setPreferredSize(new Dimension(60,20));
		label1.setBounds(20,30,60,20);
		label1.setLocation(new Point(20,30));
		label1.setVisible(true);
		
		//walk through the loaded structures
		structures.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures.add(sv.getStructureName(st));
		}
		
		combo1 = new JComboBox(structures);
		combo1.setPreferredSize(new Dimension(90,20));
		combo1.setBounds(110,30,100,20);
		combo1.setLocation(new Point(110,30));
		combo1.setVisible(true);
		if (structures.size() == 1) combo1.setEnabled(false);
		combo1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo1.getSelectedItem();
				structure = (Structure)sv.getLoadedStructures().get(combo1.getSelectedIndex() - 1);
				field2.setText(choice);
				field3.requestFocus();
			}
		});
		
		
		//add panel to the base
		setPanel.add(label1);
		setPanel.add(combo1);

		base.add(setPanel);
		
		namePanel.setPreferredSize(new Dimension(240, 80));
		namePanel.setLocation(new Point(5,75));
		namePanel.setBounds(5,75,240,80);
		namePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Structure name ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		namePanel.setBorder(border);
		
		
		label2.setText("Current name:");
		label2.setBounds(20,25,80,20);
		label2.setVisible(true);
		
		label3.setText("New name:");
		label3.setBounds(20,50,80,20);
		label3.setVisible(true);
		
		field2.setBounds(110,25,100,20);
		field2.setVisible(true);
		
		field3.setBounds(110,50,100,20);
		field3.setVisible(true);
		field3.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					parent.setDisplayDialogStatus(false);
					setVisible(false);
					dispose();
				}
			}
		});
		
		if (structures.size() == 1){
			field2.setEnabled(false);
			field3.setEnabled(false);
		}
		
		namePanel.add(label2);
		namePanel.add(label3);
		namePanel.add(field2);
		namePanel.add(field3);
		
		base.add(namePanel);
		
		
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(40, 175));
		okButton.setBounds(40, 175, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(140, 175));
		cancelButton.setBounds(140, 175, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(265, 230);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		setVisible(false);
		parent.setDisplayDialogStatus(false);
		
		if (field3.getText().length() == 0){
			parent.displayErrorMessage("No name has been entered. Name has not been changed");
			return;
		}
	
		Thread runner = new Thread(){
			public void run(){
				if (structure != null) sv.renameStructure(structure, field3.getText());
			}
		};
		runner.start();
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
