package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class StructureSelectionDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private JPanel setPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private JTextField field = new JTextField(50);
	private JLabel label1 = new JLabel();
	
	private JTextField field2 = new JTextField(30);
	private JLabel label2 = new JLabel();
	
	private JLabel label3 = new JLabel();
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JComboBox combo1 = new JComboBox();
	private Vector structures = new Vector();

	private Structure structure;
	
	public StructureSelectionDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Structure selection", false);

		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(250, 80));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 250, 80);
		base.setLayout(null);
		
		
		setPanel.setPreferredSize(new Dimension(240, 70));
		setPanel.setLocation(new Point(5,5));
		setPanel.setBounds(5,5,240,70);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Select structure for Ramachandran plot ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 11));
		label1.setText("Structure:");
		label1.setPreferredSize(new Dimension(60,20));
		label1.setBounds(20,30,60,20);
		label1.setLocation(new Point(20,30));
		label1.setVisible(true);
		
		//walk through the loaded structures
		structures.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures.add(sv.getStructureName(st));
		}
		
		combo1 = new JComboBox(structures);
		combo1.setPreferredSize(new Dimension(90,20));
		combo1.setBounds(90,30,100,20);
		combo1.setLocation(new Point(90,30));
		combo1.setVisible(true);
		if (structures.size() == 1) combo1.setEnabled(false);
		combo1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo1.getSelectedItem();
				structure = (Structure)sv.getLoadedStructures().get(combo1.getSelectedIndex() - 1);
			}
		});
		
		
		//add panels to the base
		setPanel.add(label1);
		setPanel.add(combo1);

		base.add(setPanel);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(40, 95));
		okButton.setBounds(40, 95, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(140, 95));
		cancelButton.setBounds(140, 95, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(265, 150);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		setVisible(false);
		parent.setDisplayDialogStatus(false);
	
		Thread runner = new Thread(){
			public void run(){
				if (structure != null) parent.displayRamachandranPlot(structure);
			}
		};
		runner.start();
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
