package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.util.DNAProperties;
import edu.sdsc.sirius.util.ProteinProperties;
import edu.sdsc.sirius.viewers.*;

import java.util.regex.*;

public class StructureSetDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	
	private JPanel topPanel = new JPanel();
	private JPanel choicePanel = new JPanel();
	private JPanel setPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private final int CREATE_SET = 0;
	private final int ADD_SET = 1;
	private final int DELETE_SET = 2;
	
	
	private int setAction = CREATE_SET;
	private boolean useSelection = true;
	
	private JTextField nameField = new JTextField(30);
	
	private ButtonGroup group = new ButtonGroup();
	private JRadioButton newSet = new JRadioButton("Create new set", true);
	private JRadioButton addSet = new JRadioButton("Add to existing set", false);
	private JRadioButton deleteSet = new JRadioButton("Delete existing set", false);
	
	private ButtonGroup group2 = new ButtonGroup();
	private JRadioButton selectionButton = new JRadioButton("Use current selection", true);
	private JRadioButton setButton = new JRadioButton("Define set of atoms", false);

	
	private JComboBox currentSets;


	private JTextField field = new JTextField(50);
	private JLabel label1 = new JLabel();
	
	private JTextField field2 = new JTextField(30);
	private JLabel label2 = new JLabel();
	
	private JLabel label3 = new JLabel();
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private JComboBox combo1 = new JComboBox();
	private Vector structures = new Vector();

	private JComboBox combo2 = new JComboBox();
	private Vector chains = new Vector();
	
	private Structure structure;
	private Chain chain;
	
	private Vector residues;
	private Vector existingSets;

	
	private StericEvent event;
	
	private Atom[] atoms = new Atom[2];
	
	public StructureSetDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Define set of atoms", false);

		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		existingSets = sv.getAtomSetNames();

		
		structures.add("Select");
		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures.add(sv.getStructureName(st));
		}

		
		base.setPreferredSize(new Dimension(300, 310));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 300, 310);
		base.setLayout(null);
		
		topPanel.setPreferredSize(new Dimension(290, 90));
		topPanel.setLocation(new Point(5,5));
		topPanel.setBounds(5,5,290,90);
		topPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Type of set operation ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		topPanel.setBorder(border);
		
	
		//define the radio buttons
		newSet.setLocation(20,20);
		newSet.setBounds(20,20,100,20);
		newSet.setVisible(true);
		newSet.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setAction = CREATE_SET;
				nameField.setEnabled(true);
				currentSets.setEnabled(false);
			}
		});

		addSet.setLocation(20,40);
		addSet.setBounds(20,40,120,20);
		addSet.setVisible(true);
		addSet.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setAction = ADD_SET;
				nameField.setEnabled(false);
				currentSets.setEnabled(true);
			}
		});
		
		deleteSet.setLocation(20,60);
		deleteSet.setBounds(20,60,120,20);
		deleteSet.setVisible(true);
		deleteSet.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setAction = DELETE_SET;
				nameField.setEnabled(false);
				currentSets.setEnabled(true);
			}
		});

		
		//check the current sets
		Vector list = new Vector();
		list.add("Select set");

		if (existingSets.size() > 0){
			for (int i = 0; i < existingSets.size(); i++){
				list.add(existingSets.get(i));
			}
		}
		
		currentSets = new JComboBox(list);
		currentSets.setBounds(150, 60, 130, 20);
		currentSets.setVisible(true);
		currentSets.setEnabled(false);
		if (list.size() > 1){
			//create the populated combo box 
			addSet.setEnabled(true);
			deleteSet.setEnabled(true);
		}
		else{
			addSet.setEnabled(false);
			deleteSet.setEnabled(false);
		}
		
		group.add(newSet);
		group.add(addSet);
		group.add(deleteSet);
		
		JLabel nameLabel = new JLabel("Name:");
		nameLabel.setFont(new Font("Dialog", Font.PLAIN, 11));
		nameLabel.setBounds(135,20,40,20);
		nameLabel.setVisible(true);
		
		nameField.setPreferredSize(new Dimension(100,20));
		nameField.setBounds(180,20,100,20);
		nameField.setLocation(new Point(180,20));
		nameField.setEditable(true);
		nameField.setEnabled(true);
		nameField.setVisible(true);
		
		nameField.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					dispose();
				}
			}
		});

		

		topPanel.add(nameLabel);
		topPanel.add(nameField);
		topPanel.add(newSet);
		topPanel.add(addSet);
		topPanel.add(deleteSet);
		topPanel.add(currentSets);
		
		base.add(topPanel);
		
		
		choicePanel.setPreferredSize(new Dimension(290, 70));
		choicePanel.setLocation(new Point(5,95));
		choicePanel.setBounds(5,95,290,70);
		choicePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Set definition mode ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		choicePanel.setBorder(border);
		
		
		//define the radio buttons
		selectionButton.setLocation(20,20);
		selectionButton.setBounds(20,20,180,20);
		selectionButton.setVisible(true);
		selectionButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				useSelection = true;
				
				combo1.setEnabled(false);
				combo2.setEnabled(false);
				field.setEnabled(false);
			}
		});

		setButton.setLocation(20,40);
		setButton.setBounds(20,40,170,20);
		setButton.setVisible(true);
		setButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				useSelection = false;
				if (structures.size() > 1){
					combo1.setEnabled(true);
				}
			}
		});
		
		group2.add(selectionButton);
		group2.add(setButton);
		
		choicePanel.add(selectionButton);
		choicePanel.add(setButton);

		
		base.add(choicePanel);
		
		
		
		setPanel.setPreferredSize(new Dimension(290, 140));
		setPanel.setLocation(new Point(5,165));
		setPanel.setBounds(5,165,290,140);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Define the list of residue numbers ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		label1.setForeground(Color.black);
		label1.setFont(new Font("Dialog", Font.PLAIN, 11));
		label1.setText("Structure:");
		label1.setPreferredSize(new Dimension(60,20));
		label1.setBounds(20,25,60,20);
		label1.setLocation(new Point(20,25));
		label1.setVisible(true);
		
		//walk through the loaded structures
		chains.add("Select");

		
		combo1 = new JComboBox(structures);
		combo1.setPreferredSize(new Dimension(100,20));
		combo1.setBounds(90,25,100,20);
		combo1.setLocation(new Point(90,25));
		combo1.setSelectedIndex(0);
		combo1.setVisible(true);
		combo1.setEnabled(false);//since selection is the default, disable it for now in any event
		combo1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo1.getSelectedItem();
				try{
					structure = (Structure)sv.getLoadedStructures().get(combo1.getSelectedIndex() - 1);
					//walk through the chains in the structure and add them
					chains.clear();
					chains.add("Select");
					StructureMap map = structure.getStructureMap();
					for (int i = 0; i < map.getChainCount(); i++){
						chains.add((map.getChain(i)).getChainId());
					}
					if (chains.size() == 1){
						chains.add("Default");
						combo2.setSelectedIndex(1);
					}
					combo2.setEnabled(true);
					combo2.setModel(new DefaultComboBoxModel(chains));
				}
				catch (Exception ex){
					chains.clear();
					chains.add("Select");
					combo2.setEnabled(false);
					combo2.setSelectedIndex(0);
					field.setEnabled(false);
					field.setEditable(false);
					field.setText("");
				}
				combo2.revalidate();
			}
		});
		
		
		label2.setForeground(Color.black);
		label2.setFont(new Font("Dialog", Font.PLAIN, 11));
		label2.setText("Chain:");
		label2.setPreferredSize(new Dimension(60,20));
		label2.setBounds(20,60,60,20);
		label2.setLocation(new Point(20,55));
		label2.setVisible(true);

		combo2 = new JComboBox(chains);
		combo2.setPreferredSize(new Dimension(100,20));
		combo2.setBounds(90,60,100,20);
		combo2.setLocation(new Point(90,60));
		combo2.setVisible(true);
		combo2.setEnabled(false);
		combo2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo2.getSelectedItem();
				field.setEnabled(true);
				field.setEditable(true);
				try{
					chain = structure.getStructureMap().getChain(combo2.getSelectedIndex() - 1);
					field.requestFocus();
				}
				catch (Exception ex){
					field.setEnabled(false);
					field.setEditable(false);
					field.setText("");
				}
			}
		});
		
		label3.setForeground(Color.black);
		label3.setFont(new Font("Dialog", Font.PLAIN, 11));
		label3.setText("Residues:");
		label3.setPreferredSize(new Dimension(60,20));
		label3.setBounds(20,95,60,20);
		label3.setLocation(new Point(20,95));
		label3.setVisible(true);
		
		field.setPreferredSize(new Dimension(180,20));
		field.setBounds(90,95,180,20);
		field.setLocation(new Point(90,95));
		field.setEditable(false);
		field.setEnabled(false);
		field.setVisible(true);
		field.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});
		
		//add panels to the base
		setPanel.add(label1);
		setPanel.add(combo1);
		setPanel.add(label2);
		setPanel.add(combo2);
		setPanel.add(label3);
		setPanel.add(field);
		
		base.add(setPanel);
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(65, 320));
		okButton.setBounds(65, 320, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(160, 320));
		cancelButton.setBounds(160, 320, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		

		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(315, 380);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		nameField.requestFocus();
		
		setVisible(true);
		


	}
	
	private void process(){
		
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		setVisible(false);
		parent.setDisplayDialogStatus(false);
		
		if (nameField.getText().length() == 0 && newSet.isSelected()){
			parent.displayErrorMessage("A name for the new set must be selected.");
			dispose();
			return;
		}
		
		//get the name
		String nn = nameField.getText();
		if (existingSets.contains(nn)){
			parent.displayErrorMessage("A set with the specified name already exists.");
			dispose();
			return;
		}
		
		if (structures.contains(nn)){
			parent.displayErrorMessage("A loaded structure with the chosen name already exists.");
			dispose();
			return;
		}

		
		if (useSelection){
			
			//just use the selection as flag and specify whether it's a new set or an addition
			Thread runner = new Thread(){
				public void run(){
					if (setAction == CREATE_SET){
						sv.createSet(nameField.getText(), null);
					}
					else if (setAction == ADD_SET){
						String selected = (String)currentSets.getSelectedItem();
						if (selected != null && !selected.equals("Select set")){
							sv.createSet(selected, null);
						}
					}
					else{
						//delete named set
						String selected = (String)currentSets.getSelectedItem();
						if (selected != null && !selected.equals("Select set")){
							HashMap sets = sv.getAtomSets();
							if (sets.containsKey(selected)){
								sets.remove(selected);
								sv.getAtomSetNames().remove(selected);
							}
						}
						
					}
				}
			};
			runner.start();
			dispose();
			
			return;
		}	
	
		residues = new Vector();
		
		//this method produces a list of Residues that are defined by the parameters
		//and passes them to the StructureViewer to its method instead of firing an event
		//to a handler method
		
		if (chain == null){
			//select the entire selected structure
			Thread thread = new Thread(){
				public void run(){
					structure.getStructureMap().getStructureStyles().selectAll();
				}
			};
			thread.start();
			dispose();
		}
		else{
			String input = field.getText();
			if (input.equals("*") || input.equals("")){
				//select all residues of the given chain
				for (int i = 0; i < chain.getResidueCount(); i++){
					residues.add(chain.getResidue(i));
				}
			}
			else{
				
				HashMap map = new HashMap();//residue_id -> Residue
				for (int i = 0; i < structure.getStructureMap().getResidueCount(); i++){
					Residue r = structure.getStructureMap().getResidue(i);
					map.put(new Integer(r.getResidueId()), r);
				}
				
				Pattern aanum = Pattern.compile("(([a-zA-Z]+)([0-9]+))");
				Pattern letters = Pattern.compile("(^([a-zA-Z]+))");
				
				
				//to avoid repeated scanning of the entire residue list for each token,
				//record the residue numbers and alphabetic expressions in two vectors,
				//and walk through them once the parsing is completed
				Vector numbers = new Vector();
				Vector names = new Vector();
				Vector fragments = new Vector();
				//parse the input in the text field to get the list of numbers
				StringTokenizer tok = new StringTokenizer(field.getText(), ",", false);
				while (tok.hasMoreTokens()){
					String token = tok.nextToken();
					try{
						//check for - as a sign of range
						int dash = token.indexOf("-");
						if (dash != -1){
							//there is a range
							String start = token.substring(0,dash);
							String end = token.substring(dash+1);
							
							int a = -1;
							int b = -1;
							try{
								a = Integer.parseInt(start.trim());
							}
							catch (NumberFormatException e){
								//it's not just the number
								//could be an amino acid symbol followed by a number
								//extract an integer from this string
								Matcher m = aanum.matcher(start);
								boolean res = m.find();
								if (res){
									String r = m.group(3);
									try{
										a = Integer.parseInt(r);
									}
									catch (NumberFormatException exx){
										continue;
									}
								}
							}
							
							try{
								b = Integer.parseInt(end.trim());
							}
							catch (NumberFormatException e){
								//it's not just the number
								//could be an amino acid symbol followed by a number
								Matcher m = aanum.matcher(end);
								boolean res = m.find();
								if (res){
									String r = m.group(3);
									try{
										b = Integer.parseInt(r);
									}
									catch (NumberFormatException exx){
										continue;
									}
								}
							}
							
							//we have a and b
	//						System.out.println("a = " + a + ", b = " + b);
							for (int j = a; j <=b; j++){
								numbers.add(new Integer(j));
							}
							
						}
						else{
							//no ranges
							int n = -1;
							try{
								n = Integer.parseInt(token);
								//get the residue from its number
								if (!numbers.contains(new Integer(n)))numbers.add(new Integer(n));
							}
							catch (NumberFormatException e){
								//there is something in addition to the number
								int indexStar = token.indexOf("*");
								if (indexStar != -1){
					
									//wildcard possibly following an aminoacid symbol
									//get the part preceding the wildcard
									String pre = token.substring(0, indexStar);
	//								System.out.println("pre = " + pre);
									//just go through the residues and
									//match those that start with the given letter sequence
									if (ProteinProperties.isSingleLetterAminoAcid(pre.toUpperCase()) || 
											ProteinProperties.isAminoAcid(pre.toUpperCase())){
										if (!fragments.contains(pre))names.add(pre.toUpperCase());
									}
									else if (DNAProperties.isNucleicAcid(pre.toUpperCase())){
										if (!fragments.contains(pre))names.add(pre.toUpperCase());
									}
									else{
										if (!fragments.contains(pre))names.add(pre);
									}
									
								}
								else{
									//no wildcard: possibly an aminoacid followed by its number
									//only extract the numeric portion, if no number, get the letters,
									//and if it's a valid aminoacid symbol, select all aminoacids in this chain
									
									
									Matcher m = aanum.matcher(token);
									boolean res = m.find();//found both letters and numbers
									if (res){
										String r = m.group(3);
										try{
											int b = Integer.parseInt(r);
											if (!numbers.contains(new Integer(b)))numbers.add(new Integer(n));
										}
										catch (NumberFormatException exx){
											continue;
										}
									}
									else{
										//no match, try to get only the letters in the beginning
										Matcher mm = letters.matcher(token);
										boolean found = mm.find();//found letters
										if (found){
											String name = mm.group(2);
											if (ProteinProperties.isSingleLetterAminoAcid(name.toUpperCase()) || 
													ProteinProperties.isAminoAcid(name.toUpperCase())){
												if (!names.contains(name))names.add(name.toUpperCase());
											}
											else if (DNAProperties.isNucleicAcid(name.toUpperCase())){
												if (!names.contains(name))names.add(name.toUpperCase());
											}
											else if (name.equals("hoh")){
												if (!names.contains(name))names.add(name.toUpperCase());
											}
											else{
												if (!names.contains(name))names.add(name);
											}
										}
									}
								}
							}
							
						}
						
					}
					catch (Exception exx){
						parent.displayExceptionMessage("Exception selecting residue list", exx);
						continue;
					}
				}
				
				//scan through the given structure/chain combination and check against the parameters in
				//names and numbers
				StructureMap structureMap = structure.getStructureMap();
				for (int i = 0; i < structureMap.getResidueCount(); i++){
					Residue r = structureMap.getResidue(i);
					if (!r.getChainId().equals(chain.getChainId()))continue;
					
					//this is the correct chain, check for numbers and names
					Integer id = new Integer(r.getResidueId());
					String name = r.getCompoundCode();
					if (numbers.contains(id)){
						if (!residues.contains(r))residues.add(r);
						continue;
					}
	
	
					//iterate through names because matching is needed
					for (int j = 0; j < names.size(); j++){
						String n = (String)names.get(j);
						if (name.startsWith(n)){
							if (!residues.contains(r)) residues.add(r);
						}
					}
				}
			}
		}//end of condition chain != null
		
		Thread runner = new Thread(){
			public void run(){

				if (setAction == CREATE_SET){
					//get the name
					sv.createSet(nameField.getText(), residues);
				}
				else if (setAction == ADD_SET){
					String selected = (String)currentSets.getSelectedItem();
					if (selected != null && !selected.equals("Select set")){
						sv.createSet(selected, residues);
					}
				}
				else{
					//delete named set
					String selected = (String)currentSets.getSelectedItem();
					if (selected != null && !selected.equals("Select set")){
						HashMap sets = sv.getAtomSets();
						if (sets.containsKey(selected)) sets.remove(selected);
					}
					
				}

				
				
				parent.setDisplayDialogStatus(false);
			}
		};
		runner.start();
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){}
	
}
